<?php

namespace App\Core;

// solve CORS header
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Max-Age: 86400');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

trait Responses
{
    /**
     * Response and status code
     *
     * @param  mixed $code
     * @param  mixed $data
     * @return void
     */
    public static function response(int $code = 200, $data): void
    {
        http_response_code($code);
        header('Content-Type: application/json');
        echo json_encode($data);
        exit;
    }

    /**
     * Response and status code
     *
     * @param  mixed $code
     * @param  mixed $data
     * @return void
     */
    public static function responseWithToken(int $code = 200, $data, $token): void
    {
        http_response_code($code);
        header('Content-Type: application/json');
        header('Authorization: Bearer ' . $token);
        echo json_encode($data);
        exit;
    }
}
