<?php
/**
 * Text used for 'Entities' (Document Structure Elements) such as
 * Books, Shelves, Chapters & Pages
 */
return [

    // Shared
    'recently_created' => 'Недавно созданные',
    'recently_created_pages' => 'Недавно созданные страницы',
    'recently_updated_pages' => 'Недавно обновленные страницы',
    'recently_created_chapters' => 'Недавно созданные главы',
    'recently_created_books' => 'Недавно созданные книги',
    'recently_created_shelves' => 'Недавно созданные полки',
    'recently_update' => 'Недавно обновленные',
    'recently_viewed' => 'Недавно просмотренные',
    'recent_activity' => 'Недавние действия',
    'create_now' => 'Создать сейчас',
    'revisions' => 'Версии',
    'meta_revision' => 'Версия #:revisionCount',
    'meta_created' => 'Создано :timeLength',
    'meta_created_name' => ':user создал :timeLength',
    'meta_updated' => 'Обновлено :timeLength',
    'meta_updated_name' => ':user обновил :timeLength',
    'meta_owned_name' => 'Владелец :user',
    'meta_reference_count' => 'Ссылается :count элемент|Ссылается :count элементов',
    'entity_select' => 'Выбор объекта',
    'entity_select_lack_permission' => 'У вас нет разрешения на выбор этого элемента',
    'images' => 'Изображения',
    'my_recent_drafts' => 'Мои последние черновики',
    'my_recently_viewed' => 'Мои недавние просмотры',
    'my_most_viewed_favourites' => 'Популярное избранное',
    'my_favourites' => 'Мое избранное',
    'no_pages_viewed' => 'Вы не просматривали ни одной страницы',
    'no_pages_recently_created' => 'Нет недавно созданных страниц',
    'no_pages_recently_updated' => 'Нет недавно обновленных страниц',
    'export' => 'Экспорт',
    'export_html' => 'Веб файл',
    'export_pdf' => 'PDF файл',
    'export_text' => 'Текстовый файл',
    'export_md' => 'Файл Markdown',
    'default_template' => 'Шаблон страницы по умолчанию',
    'default_template_explain' => 'Назначить шаблон страницы, который будет использоваться в качестве содержимого по умолчанию для всех страниц, созданных в этом элементе. Имейте в виду, что это будет работать, только если создатель страницы имеет доступ к выбранной странице шаблона.',
    'default_template_select' => 'Выберите страницу шаблона',

    // Permissions and restrictions
    'permissions' => 'Разрешения',
    'permissions_desc' => 'Установите права доступа для переопределения прав, предоставленных ролями пользователей по-умолчанию.',
    'permissions_book_cascade' => 'Права доступа, установленные для книг, автоматически распространяются на дочерние главы и страницы, если для них не определены собственные разрешения.',
    'permissions_chapter_cascade' => 'Права доступа, установленные для глав, автоматически распространяются на дочерние страницы, если для них не определены собственные разрешения.',
    'permissions_save' => 'Сохранить разрешения',
    'permissions_owner' => 'Владелец',
    'permissions_role_everyone_else' => 'Все остальные',
    'permissions_role_everyone_else_desc' => 'Установить права доступа для всех ролей, которые не были специально переопределены.',
    'permissions_role_override' => 'Переопределить права доступа для роли',
    'permissions_inherit_defaults' => 'Наследовать по умолчанию',

    // Search
    'search_results' => 'Результаты поиска',
    'search_total_results_found' => 'Найден :count результат|Найдено :count результата|Найдено :count результатов',
    'search_clear' => 'Очистить поиск',
    'search_no_pages' => 'Нет страниц, соответствующих этому поиску',
    'search_for_term' => 'Искать :term',
    'search_more' => 'Еще результаты',
    'search_advanced' => 'Расширенный поиск',
    'search_terms' => 'Поисковые запросы',
    'search_content_type' => 'Тип содержимого',
    'search_exact_matches' => 'Точные соответствия',
    'search_tags' => 'Поиск по тегам',
    'search_options' => 'Параметры',
    'search_viewed_by_me' => 'Просмотрено мной',
    'search_not_viewed_by_me' => 'Не просматривалось мной',
    'search_permissions_set' => 'Набор разрешений',
    'search_created_by_me' => 'Создано мной',
    'search_updated_by_me' => 'Обновлено мной',
    'search_owned_by_me' => 'Созданные мной',
    'search_date_options' => 'Параметры даты',
    'search_updated_before' => 'Обновлено до',
    'search_updated_after' => 'Обновлено после',
    'search_created_before' => 'Создано до',
    'search_created_after' => 'Создано после',
    'search_set_date' => 'Установить дату',
    'search_update' => 'Обновить поиск',

    // Shelves
    'shelf' => 'Полка',
    'shelves' => 'Полки',
    'x_shelves' => ':count полка|:count полки|:count полок',
    'shelves_empty' => 'Полки не созданы',
    'shelves_create' => 'Создать новую полку',
    'shelves_popular' => 'Популярные полки',
    'shelves_new' => 'Новые полки',
    'shelves_new_action' => 'Новая полка',
    'shelves_popular_empty' => 'Популярные полки появятся здесь.',
    'shelves_new_empty' => 'Последние созданные полки появятся здесь.',
    'shelves_save' => 'Сохранить полку',
    'shelves_books' => 'Книги из этой полки',
    'shelves_add_books' => 'Добавить книгу в эту полку',
    'shelves_drag_books' => 'Перетащите книги ниже, чтобы добавить их на эту полку',
    'shelves_empty_contents' => 'На этой полке нет книг',
    'shelves_edit_and_assign' => 'Изменить полку для привязки книг',
    'shelves_edit_named' => 'Редактировать полку :name',
    'shelves_edit' => 'Редактировать полку',
    'shelves_delete' => 'Удалить полку',
    'shelves_delete_named' => 'Удалить полку :name',
    'shelves_delete_explain' => "Это приведет к удалению полки с именем ':name'. Привязанные книги удалены не будут.",
    'shelves_delete_confirmation' => 'Вы уверены, что хотите удалить эту полку?',
    'shelves_permissions' => 'Доступы к полке',
    'shelves_permissions_updated' => 'Доступы к полке обновлены',
    'shelves_permissions_active' => 'Действующие разрешения полки',
    'shelves_permissions_cascade_warning' => 'Разрешения на полки не наследуются автоматически содержащимся в них книгам. Это происходит потому, что книга может находиться на нескольких полках. Однако разрешения могут быть установлены для книг полки с помощью опции, приведенной ниже.',
    'shelves_permissions_create' => 'Разрешения полки на создание используется только для копирования разрешений на дочерние книги с помощью действия, описанного ниже. Они не контролируют возможность создавать книги.',
    'shelves_copy_permissions_to_books' => 'Наследовать доступы книгам',
    'shelves_copy_permissions' => 'Копировать доступы',
    'shelves_copy_permissions_explain' => 'Это применит текущие настройки разрешений для этой полки ко всем книгам, содержащимся в ней. Перед активацией убедитесь, что все изменения разрешений этой полки были сохранены.',
    'shelves_copy_permission_success' => 'Доступы полки скопированы для :count книг',

    // Books
    'book' => 'Книга',
    'books' => 'Книги',
    'x_books' => ':count книга|:count книги|:count книг',
    'books_empty' => 'Нет созданных книг',
    'books_popular' => 'Популярные книги',
    'books_recent' => 'Недавние книги',
    'books_new' => 'Новые книги',
    'books_new_action' => 'Новая книга',
    'books_popular_empty' => 'Здесь появятся самые популярные книги.',
    'books_new_empty' => 'Здесь появятся самые последние созданные книги.',
    'books_create' => 'Создать новую книгу',
    'books_delete' => 'Удалить книгу',
    'books_delete_named' => 'Удалить книгу :bookName',
    'books_delete_explain' => 'Это удалит книги с именем \':bookName\'. Все разделы и страницы будут удалены.',
    'books_delete_confirmation' => 'Вы действительно хотите удалить эту книгу?',
    'books_edit' => 'Редактировать книгу',
    'books_edit_named' => 'Редактировать книгу :bookName',
    'books_form_book_name' => 'Название книги',
    'books_save' => 'Сохранить книгу',
    'books_permissions' => 'Разрешения на книгу',
    'books_permissions_updated' => 'Разрешения на книгу обновлены',
    'books_empty_contents' => 'Для этой книги нет страниц или разделов.',
    'books_empty_create_page' => 'Создать новую страницу',
    'books_empty_sort_current_book' => 'Сортировка текущей книги',
    'books_empty_add_chapter' => 'Добавить главу',
    'books_permissions_active' => 'Действующие разрешения книги',
    'books_search_this' => 'Поиск в этой книге',
    'books_navigation' => 'Навигация по книге',
    'books_sort' => 'Сортировка содержимого книги',
    'books_sort_desc' => 'Переместите разделы и страницы в книге, чтобы изменить содержание. Могут быть добавлены другие книги, что позволяет легко перемещать разделы и страницы между книгами.',
    'books_sort_named' => 'Сортировка книги :bookName',
    'books_sort_name' => 'По имени',
    'books_sort_created' => 'По дате создания',
    'books_sort_updated' => 'По дате обновления',
    'books_sort_chapters_first' => 'Главы в начале',
    'books_sort_chapters_last' => 'Главы в конце',
    'books_sort_show_other' => 'Показать другие книги',
    'books_sort_save' => 'Сохранить новый порядок',
    'books_sort_show_other_desc' => 'Добавьте другие книги здесь, чтобы включить их в сортировку, и позволить легко реорганизовать книгу.',
    'books_sort_move_up' => 'Переместить вверх',
    'books_sort_move_down' => 'Переместить вниз',
    'books_sort_move_prev_book' => 'Переместить в предыдущую книгу',
    'books_sort_move_next_book' => 'Переместить в следующую книгу',
    'books_sort_move_prev_chapter' => 'Переместить в предыдущую главу',
    'books_sort_move_next_chapter' => 'Переместить в следующую главу',
    'books_sort_move_book_start' => 'Переместить в начало книги',
    'books_sort_move_book_end' => 'Переместить в конец книги',
    'books_sort_move_before_chapter' => 'Переместить перед главой',
    'books_sort_move_after_chapter' => 'Переместить после главы',
    'books_copy' => 'Копировать книгу',
    'books_copy_success' => 'Книга успешно скопирована',

    // Chapters
    'chapter' => 'Глава',
    'chapters' => 'Главы',
    'x_chapters' => ':count глава|:count главы|:count глав',
    'chapters_popular' => 'Популярные главы',
    'chapters_new' => 'Новая глава',
    'chapters_create' => 'Создать новую главу',
    'chapters_delete' => 'Удалить главу',
    'chapters_delete_named' => 'Удалить главу :chapterName',
    'chapters_delete_explain' => 'Это действие удалит главу с названием \':chapterName\'. Все страницы, которые существуют в этой главе, также будут удалены.',
    'chapters_delete_confirm' => 'Вы действительно хотите удалить эту главу?',
    'chapters_edit' => 'Редактировать главу',
    'chapters_edit_named' => 'Редактировать главу :chapterName',
    'chapters_save' => 'Сохранить главу',
    'chapters_move' => 'Переместить главу',
    'chapters_move_named' => 'Переместить главу :chapterName',
    'chapters_copy' => 'Копировать главу',
    'chapters_copy_success' => 'Глава успешно скопирована',
    'chapters_permissions' => 'Разрешения главы',
    'chapters_empty' => 'В этой главе нет страниц.',
    'chapters_permissions_active' => 'Действующие разрешения главы',
    'chapters_permissions_success' => 'Разрешения главы обновлены',
    'chapters_search_this' => 'Искать в этой главе',
    'chapter_sort_book' => 'Сортировать книгу',

    // Pages
    'page' => 'Страница',
    'pages' => 'Страницы',
    'x_pages' => ':count страница|:count страницы|:count страниц',
    'pages_popular' => 'Популярные страницы',
    'pages_new' => 'Новая страница',
    'pages_attachments' => 'Вложения',
    'pages_navigation' => 'Навигация на странице',
    'pages_delete' => 'Удалить страницу',
    'pages_delete_named' => 'Удалить страницу :pageName',
    'pages_delete_draft_named' => 'Удалить черновик :pageName',
    'pages_delete_draft' => 'Удалить черновик',
    'pages_delete_success' => 'Страница удалена',
    'pages_delete_draft_success' => 'Черновик удален',
    'pages_delete_warning_template' => 'Эта страница активно используется как шаблон страницы по умолчанию для книги или главы. Эти книги или главы больше не будут иметь шаблон страницы по умолчанию, назначенный после удаления этой страницы.',
    'pages_delete_confirm' => 'Вы действительно хотите удалить эту страницу?',
    'pages_delete_draft_confirm' => 'Вы действительно хотите удалить этот черновик?',
    'pages_editing_named' => 'Редактирование страницы :pageName',
    'pages_edit_draft_options' => 'Параметры черновика',
    'pages_edit_save_draft' => 'Сохранить черновик',
    'pages_edit_draft' => 'Редактировать черновик',
    'pages_editing_draft' => 'Редактирование черновика',
    'pages_editing_page' => 'Редактирование страницы',
    'pages_edit_draft_save_at' => 'Черновик сохранён в ',
    'pages_edit_delete_draft' => 'Удалить черновик',
    'pages_edit_delete_draft_confirm' => 'Вы уверены, что хотите удалить черновик с изменениями? Все изменения, внесенные вами с момента последнего полного сохранения, будут утеряны и редактор будет обновлен данными с последнего сохранения страницы.',
    'pages_edit_discard_draft' => 'Отменить черновик',
    'pages_edit_switch_to_markdown' => 'Переключиться на Markdown',
    'pages_edit_switch_to_markdown_clean' => 'Только Markdown (с возможными потерями форматирования)',
    'pages_edit_switch_to_markdown_stable' => 'Полное сохранение форматирования (HTML)',
    'pages_edit_switch_to_wysiwyg' => 'Переключиться в WYSIWYG',
    'pages_edit_switch_to_new_wysiwyg' => 'Switch to new WYSIWYG',
    'pages_edit_switch_to_new_wysiwyg_desc' => '(In Alpha Testing)',
    'pages_edit_set_changelog' => 'Задать список изменений',
    'pages_edit_enter_changelog_desc' => 'Введите краткое описание внесенных изменений',
    'pages_edit_enter_changelog' => 'Введите список изменений',
    'pages_editor_switch_title' => 'Переключить редактор',
    'pages_editor_switch_are_you_sure' => 'Вы уверены, что хотите изменить редактор для этой страницы?',
    'pages_editor_switch_consider_following' => 'При изменении редактора учитывайте следующее:',
    'pages_editor_switch_consideration_a' => 'После сохранения новая опция редактора будет использоваться любыми пользователями, которые будут редактировать данную страницу, включая тех, которые не смогут самостоятельно изменить тип редактора.',
    'pages_editor_switch_consideration_b' => 'Это потенциально может привести к потере деталей и синтаксиса при определенных обстоятельствах.',
    'pages_editor_switch_consideration_c' => 'Изменения в тегах или журнале, сделанные с момента последнего сохранения, не сохраняются в этом изменении.',
    'pages_save' => 'Сохранить страницу',
    'pages_title' => 'Заголовок страницы',
    'pages_name' => 'Название страницы',
    'pages_md_editor' => 'Редактор',
    'pages_md_preview' => 'Просмотр',
    'pages_md_insert_image' => 'Вставить изображение',
    'pages_md_insert_link' => 'Вставить ссылку на объект',
    'pages_md_insert_drawing' => 'Вставить рисунок',
    'pages_md_show_preview' => 'Предпросмотр',
    'pages_md_sync_scroll' => 'Синхронизировать прокрутку',
    'pages_drawing_unsaved' => 'Найден несохраненный чертеж',
    'pages_drawing_unsaved_confirm' => 'Несохраненные данные были найдены из предыдущей неудачной попытки сохранения рисунка. Вы хотите восстановить и продолжить редактирование несохраненного рисунка?',
    'pages_not_in_chapter' => 'Страница не находится в главе',
    'pages_move' => 'Переместить страницу',
    'pages_copy' => 'Скопировать страницу',
    'pages_copy_desination' => 'Скопировать в',
    'pages_copy_success' => 'Страница скопирована',
    'pages_permissions' => 'Разрешения страницы',
    'pages_permissions_success' => 'Pазрешения страницы обновлены',
    'pages_revision' => 'Версия',
    'pages_revisions' => 'Версии страницы',
    'pages_revisions_desc' => 'Ниже перечислены все предыдущие изменения этой страницы. Вы можете посмотреть резервные копии, сравнить и восстановить старые версии страниц, если позволяют разрешения. Полная история страницы не может быть полностью отражена здесь, поскольку, в зависимости от системной конфигурации, старые версии могут быть удалены автоматически.',
    'pages_revisions_named' => 'Версии страницы для :pageName',
    'pages_revision_named' => 'Версия страницы для :pageName',
    'pages_revision_restored_from' => 'Восстановлено из #:id; :summary',
    'pages_revisions_created_by' => 'Создана',
    'pages_revisions_date' => 'Дата версии',
    'pages_revisions_number' => '#',
    'pages_revisions_sort_number' => 'Номер версии',
    'pages_revisions_numbered' => 'Версия #:id',
    'pages_revisions_numbered_changes' => 'Изменения в версии #:id',
    'pages_revisions_editor' => 'Тип редактора',
    'pages_revisions_changelog' => 'Список изменений',
    'pages_revisions_changes' => 'Изменения',
    'pages_revisions_current' => 'Текущая версия',
    'pages_revisions_preview' => 'Просмотр',
    'pages_revisions_restore' => 'Восстановить',
    'pages_revisions_none' => 'У этой страницы нет других версий',
    'pages_copy_link' => 'Копировать ссылку',
    'pages_edit_content_link' => 'Перейти к разделу в редакторе',
    'pages_pointer_enter_mode' => 'Войти в режим выбора раздела',
    'pages_pointer_label' => 'Настройки раздела страницы',
    'pages_pointer_permalink' => 'Постоянная ссылка на раздел страницы',
    'pages_pointer_include_tag' => 'Раздел страницы с тегом',
    'pages_pointer_toggle_link' => 'Режим постоянной ссылки. Нажмите, чтобы показать включение тега',
    'pages_pointer_toggle_include' => 'Включить режим тега. Нажмите для отображения постоянной ссылки',
    'pages_permissions_active' => 'Действующие разрешения на страницу',
    'pages_initial_revision' => 'Первоначальное издание',
    'pages_references_update_revision' => 'Система автоматически обновила внутренние ссылки',
    'pages_initial_name' => 'Новая страница',
    'pages_editing_draft_notification' => 'В настоящее время вы редактируете черновик, который был сохранён :timeDiff.',
    'pages_draft_edited_notification' => 'Эта страница была обновлена до этого момента. Рекомендуется отменить этот черновик.',
    'pages_draft_page_changed_since_creation' => 'Эта страница была обновлена с момента создания данного черновика. Рекомендуется выбросить этот черновик или следить за тем, чтобы не перезаписать все изменения на странице.',
    'pages_draft_edit_active' => [
        'start_a' => ':count пользователей начали редактирование этой страницы',
        'start_b' => ':userName начал редактирование этой страницы',
        'time_a' => 'поскольку последние страницы были обновлены',
        'time_b' => 'за последние :minCount минут',
        'message' => ':start :time. Будьте осторожны, чтобы не перезаписывать друг друга!',
    ],
    'pages_draft_discarded' => 'Черновик сброшен! Редактор обновлен текущим содержимым страницы',
    'pages_draft_deleted' => 'Черновик удалён! Редактор обновлен текущим содержимым страницы',
    'pages_specific' => 'Конкретная страница',
    'pages_is_template' => 'Шаблон страницы',

    // Editor Sidebar
    'toggle_sidebar' => 'Переключить боковую панель',
    'page_tags' => 'Теги страницы',
    'chapter_tags' => 'Теги главы',
    'book_tags' => 'Теги книги',
    'shelf_tags' => 'Теги полки',
    'tag' => 'Тег',
    'tags' =>  'Теги',
    'tags_index_desc' => 'Теги могут быть применены к содержимому для гибкой категоризации. Теги могут иметь как ключ, так и значение, значение является необязательным. После применения содержимое может быть найдено с помощью имени тега и значения.',
    'tag_name' =>  'Имя тега',
    'tag_value' => 'Значение тега (опционально)',
    'tags_explain' => "Добавьте теги, чтобы лучше классифицировать ваш контент. \\n Вы можете присвоить значение тегу для более глубокой организации.",
    'tags_add' => 'Добавить тег',
    'tags_remove' => 'Удалить этот тег',
    'tags_usages' => 'Всего использовано тегов',
    'tags_assigned_pages' => 'Назначено на страницы',
    'tags_assigned_chapters' => 'Назначено на главы',
    'tags_assigned_books' => 'Назначено на книги',
    'tags_assigned_shelves' => 'Назначено на полки',
    'tags_x_unique_values' => 'Уникальные значения: :count',
    'tags_all_values' => 'Все значения',
    'tags_view_tags' => 'Посмотреть теги',
    'tags_view_existing_tags' => 'Просмотр имеющихся тегов',
    'tags_list_empty_hint' => 'Теги можно присваивать через боковую панель редактора страниц или при редактировании сведений о книге, главе или полке.',
    'attachments' => 'Вложения',
    'attachments_explain' => 'Загрузите несколько файлов или добавьте ссылку для отображения на своей странице. Они видны на боковой панели страницы.',
    'attachments_explain_instant_save' => 'Изменения здесь сохраняются мгновенно.',
    'attachments_upload' => 'Загрузить файл',
    'attachments_link' => 'Присоединить ссылку',
    'attachments_upload_drop' => 'Или вы можете перетащить файл сюда, чтобы загрузить его в качестве вложения.',
    'attachments_set_link' => 'Установить ссылку',
    'attachments_delete' => 'Вы уверены, что хотите удалить это вложение?',
    'attachments_dropzone' => 'Перетащите файлы сюда для загрузки',
    'attachments_no_files' => 'Файлы не загружены',
    'attachments_explain_link' => 'Вы можете присоединить ссылку, если вы предпочитаете не загружать файл. Это может быть ссылка на другую страницу или ссылка на файл в облаке.',
    'attachments_link_name' => 'Название ссылки',
    'attachment_link' => 'Ссылка на вложение',
    'attachments_link_url' => 'Ссылка на файл',
    'attachments_link_url_hint' => 'URL-адрес сайта или файла',
    'attach' => 'Прикрепить',
    'attachments_insert_link' => 'Добавить ссылку на вложение',
    'attachments_edit_file' => 'Редактировать файл',
    'attachments_edit_file_name' => 'Название файла',
    'attachments_edit_drop_upload' => 'Перетащите файлы или нажмите здесь, чтобы загрузить и перезаписать',
    'attachments_order_updated' => 'Порядок вложений обновлен',
    'attachments_updated_success' => 'Детали вложения обновлены',
    'attachments_deleted' => 'Вложение удалено',
    'attachments_file_uploaded' => 'Файл успешно загружен',
    'attachments_file_updated' => 'Файл успешно обновлен',
    'attachments_link_attached' => 'Ссылка успешно присоединена к странице',
    'templates' => 'Шаблоны',
    'templates_set_as_template' => 'Страница является шаблоном',
    'templates_explain_set_as_template' => 'Вы можете назначить эту страницу в качестве шаблона, её содержимое будет использоваться при создании других страниц. Пользователи смогут использовать этот шаблон в случае, если имеют разрешения на просмотр этой страницы.',
    'templates_replace_content' => 'Заменить содержимое страницы',
    'templates_append_content' => 'Добавить к содержанию страницы',
    'templates_prepend_content' => 'Добавить в начало содержимого страницы',

    // Profile View
    'profile_user_for_x' => 'Пользователь уже :time',
    'profile_created_content' => 'Созданный контент',
    'profile_not_created_pages' => ':userName не создал ни одной страницы',
    'profile_not_created_chapters' => ':userName не создал ни одной главы',
    'profile_not_created_books' => ':userName не создал ни одной книги',
    'profile_not_created_shelves' => ':userName не создал ни одной полки',

    // Comments
    'comment' => 'Комментарий',
    'comments' => 'Комментарии',
    'comment_add' => 'Комментировать',
    'comment_placeholder' => 'Оставить комментарий здесь',
    'comment_count' => '{0} Нет комментариев|{1} 1 комментарий|[2,*] :count комментария',
    'comment_save' => 'Сохранить комментарий',
    'comment_new' => 'Новый комментарий',
    'comment_created' => 'прокомментировал :createDiff',
    'comment_updated' => 'Обновлен :updateDiff пользователем :username',
    'comment_updated_indicator' => 'Обновлено',
    'comment_deleted_success' => 'Комментарий удален',
    'comment_created_success' => 'Комментарий добавлен',
    'comment_updated_success' => 'Комментарий обновлен',
    'comment_delete_confirm' => 'Удалить этот комментарий?',
    'comment_in_reply_to' => 'В ответ на :commentId',
    'comment_editor_explain' => 'Вот комментарии, которые были оставлены на этой странице. Комментарии могут быть добавлены и управляться при просмотре сохраненной страницы.',

    // Revision
    'revision_delete_confirm' => 'Удалить эту версию?',
    'revision_restore_confirm' => 'Вы уверены, что хотите восстановить эту версию? Текущее содержимое страницы будет заменено.',
    'revision_cannot_delete_latest' => 'Нельзя удалить последнюю версию.',

    // Copy view
    'copy_consider' => 'При копировании содержимого, пожалуйста, учтите следующее.',
    'copy_consider_permissions' => 'Пользовательские настройки прав доступа не будут скопированы.',
    'copy_consider_owner' => 'Вы станете владельцем всего скопированного контента.',
    'copy_consider_images' => 'Файлы изображений страницы не будут дублироваться и исходные изображения сохранят их отношение к странице, в которую они были загружены изначально.',
    'copy_consider_attachments' => 'Вложения страницы не будут скопированы.',
    'copy_consider_access' => 'Изменение положения, владельца или разрешений может привести к тому, что контент будет доступен пользователям, у которых не было доступа ранее.',

    // Conversions
    'convert_to_shelf' => 'Преобразовать в полку',
    'convert_to_shelf_contents_desc' => 'Вы можете превратить эту книгу в новую полку с тем же содержимым. Главы, содержащиеся в этой книге, будут преобразованы в новые книги. Если эта книга содержит какие-либо страницы, которых нет в главе, она будет переименована и будет содержать такие страницы, и эта книга станет частью новой полки.',
    'convert_to_shelf_permissions_desc' => 'Любые разрешения, установленные для этой книги, будут скопированы на новую полку и во все новые дочерние книги, для которых не применяются собственные разрешения. Обратите внимание, что разрешения на полки не применяются автоматически к содержимому внутри, как это происходит с книгами.',
    'convert_book' => 'Преобразовать книгу',
    'convert_book_confirm' => 'Вы уверены, что хотите преобразовать эту книгу?',
    'convert_undo_warning' => 'Это не отменяется простым способом.',
    'convert_to_book' => 'Преобразовать в книгу',
    'convert_to_book_desc' => 'Вы можете преобразовать эту главу в новую книгу с тем же содержанием. Любые разрешения, установленные в этой главе, будут скопированы в новую книгу, но любые унаследованные разрешения из родительской книги не будут скопированы, что может привести к изменению контроля доступа.',
    'convert_chapter' => 'Преобразовать главу',
    'convert_chapter_confirm' => 'Вы уверены, что хотите преобразовать эту главу?',

    // References
    'references' => 'Ссылки',
    'references_none' => 'Нет отслеживаемых ссылок на этот элемент.',
    'references_to_desc' => 'Ниже перечислены все известные материалы в системе, которые ссылаются на этот элемент.',

    // Watch Options
    'watch' => 'Наблюдать',
    'watch_title_default' => 'Свойства по умолчанию',
    'watch_desc_default' => 'Вернуть просмотр только ваших настроек уведомлений по умолчанию.',
    'watch_title_ignore' => 'Игнорировать',
    'watch_desc_ignore' => 'Игнорировать все уведомления, включая уведомления из пользовательского уровня.',
    'watch_title_new' => 'Новые страницы',
    'watch_desc_new' => 'Уведомлять при создании новой страницы внутри этого элемента.',
    'watch_title_updates' => 'Все обновления страницы',
    'watch_desc_updates' => 'Уведомлять обо всех новых страницах и изменениях страницы.',
    'watch_desc_updates_page' => 'Уведомлять о всех изменениях страницы.',
    'watch_title_comments' => 'Все обновления и комментарии страниц',
    'watch_desc_comments' => 'Уведомлять обо всех новых страницах, изменениях страниц и новых комментариях.',
    'watch_desc_comments_page' => 'Уведомлять об изменениях страниц и новых комментариях.',
    'watch_change_default' => 'Изменить настройки уведомлений по умолчанию',
    'watch_detail_ignore' => 'Игнорирование уведомлений',
    'watch_detail_new' => 'Наблюдение за новыми страницами',
    'watch_detail_updates' => 'Просмотр новых страниц и обновлений',
    'watch_detail_comments' => 'Просмотр новых страниц, обновлений и комментариев',
    'watch_detail_parent_book' => 'Просмотр через родительскую книгу',
    'watch_detail_parent_book_ignore' => 'Игнорирование через родительскую книгу',
    'watch_detail_parent_chapter' => 'Просмотр через родительскую главу',
    'watch_detail_parent_chapter_ignore' => 'Игнорирование через родительскую главу',
];
