
# BlinkID Single Side Recognizer and BlinkID Multi Side Recognizer

## Table of contents

[Supported documents](#supported-documents)

* [Supported medical documents](#supported-medical-documents)


    + [Philippines](#philippines)<br>
    + [Croatia](#croatia)<br>
    + [European Union](#european-union)<br>
    + [Canada, Ontario](#canada-ontario)<br>
    + [Canada, Quebec](#canada-quebec)<br>
    + [Australia](#australia)<br>



* [Supported identity documents](#supported-identity-documents)


    + [Asia](#asia)

    + [Europe](#europe)

    + [Latin America and the Caribbean](#latin-america-and-the-caribbean)

    + [Middle East and Africa](#middle-east-and-africa)

    + [Northern America](#northern-america)

    + [Oceania](#oceania)



<br><br><br>

# Supported documents

BlinkID can be used to scan both Identity documents (ID, DL, Passports, etc.) and Medical documents. Each document type has been issued in 
multiple versions throughout the years and document design is usually significantly changed in different versions. Some document changes that we observed are: 
change in orientation (horizontal vs vertical), addition or replacement of the script of the document (Latin, Cyrillic, Arabic), security features changes, 
and other similar updates. Key document features on supported documents are noted below (e.g. document orientation, script) as well as supported document sides (front, back, bio-data-page, etc.)

All information is listed in tables below in different columns: Document Type, Localised Document Name, Supported side and orientation,
Supported scripts, respectively.

Some documents which are supported by BlinkID are still in the research and knowledge gathering phase and they will be noted with the BETA tag (xx <sup> BETA</sup>). 
That means scanning them is possible but some scanning and/or extraction challenges are possible.


Other than documents listed here, BlinkID Recognizers also scan the <strong>Machine Readable Zone (MRZ)</strong> on standard (ISO/IEC 7501 compliant) 
<strong>Machine Readable Travel Documents (MRTD)</strong>. This includes <strong>passports, visas</strong> and other identification documents.


<br><br>

## Supported medical documents

<table>
<tr><th>Document Type</th><th>Localised Document Name</th><th>Supported side and orientation</th><th>Supported scripts</th></tr>
<tr><th width=1200px colspan = 4 align="center"> <b><h3>PHILIPPINES</h3></b></th></tr>
<tr><td width=35%>Health Insurance Card<sup> BETA</sup></td><td width=35%>PhilHealth ID</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><th width=1200px colspan = 4 align="center"> <b><h3>CROATIA</h3></b></th></tr>
<tr><td width=35%>Health Insurance Card<sup> BETA</sup></td><td width=35%>Zdravstvena iskaznica</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><th width=1200px colspan = 4 align="center"> <b><h3>EUROPEAN UNION</h3></b></th></tr>
<tr><td width=35%>Health Insurance Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, ONTARIO</h3></b></th></tr>
<tr><td width=35%>Health Insurance Card</td><td width=35%>Ontario Health card (OHIP) / Carte Santé de l’Ontario</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, QUEBEC</h3></b></th></tr>
<tr><td width=35%>Health Insurance Card<sup> BETA</sup></td><td width=35%>Régie de l'assurance maladie du Québec (RAMQ)</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA</h3></b></th></tr>
<tr><td width=35%>Health Insurance Card<sup> BETA</sup></td><td width=35%>Medicare card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA</h3></b></th></tr>
<tr><td width=35%>Interim Health Insurance Card<sup> BETA</sup></td><td width=35%>Interim Medicare card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA</h3></b></th></tr>
<tr><td width=35%>Reciprocal Health Insurance Card<sup> BETA</sup></td><td width=35%>Reciprocal Health Care Card / Reciprocal Health Care Medicare card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>

</table>

<br><br>

## Supported identity documents


## Asia

<table>



</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AFGHANISTAN</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>تذکره الکترونیک‎</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>پاسپورټ</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ARMENIA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>վարորդական վկայական</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>նույնականացման քարտը</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>ԱՆՁՆԱԳԻՐ</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AZERBAIJAN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Sürücülük vəsiqəsi</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Şəxsiyyət vəsiqəsi</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>Pasport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BANGLADESH</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>মোটর ড্রাইভিং লাইসেন্স</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>জাতীয় পরিচয় পত্র</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>পাসপোর্ট</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>পাসপোর্ট</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRUNEI</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Kad Pengenalan (Kuning)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Military ID<sup> BETA</sup></td><td width=35%>Kad Pengenalan Tentera (ABDB)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>​Kad Pengenalan (Ungu)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Temporary Residence Permit<sup> BETA</sup></td><td width=35%>Kad Pengenalan (Hijau)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CAMBODIA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>ប័ណ្ណបើកបរ</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>អត្តសញ្ញាណប័ណ្ណសញ្ជាតិខ្មែរ</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>លិខិតឆ្លងដែន</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CHINA</h3></b></th></tr>
<tr><td width=35%>Exit Entry Permit</td><td width=35%>往来港澳通行证</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>中华人民共和国居民身份证</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Mainland Travel Permit Taiwan<sup> BETA</sup></td><td width=35%>台湾居民来往大陆通行证, 往来台湾通行证</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>中华人民共和国护照</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>HONG KONG</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>香港身份證</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>護照</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Aadhaar card / आधार कार्ड</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>PAN Card</td><td width=35%>स्थायी खाता संख्या कार्ड</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE, INSIDE BACK COVER</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Voter ID</td><td width=35%>भारतीय मतदाता पहचान पत्र</td><td align="center" width=15%><sub>FRONT,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA, ANDHRA PRADESH</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA, GUJARAT</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>ड्राइविंग लाइसेंस</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA, HARYANA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA, KARNATAKA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>ड्राइविंग लाइसेंस</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA, KERALA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>ड्राइविंग लाइसेंस</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA, MADHYA PRADESH</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>ड्राइविंग लाइसेंस</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA, MAHARASHTRA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>ड्राइविंग लाइसेंस</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA, PUNJAB</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>ड्राइविंग लाइसेंस</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDIA, TAMIL NADU</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>ड्राइविंग लाइसेंस</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>INDONESIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Surat Izin Mengemudi (SIM)</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Kartu Tanda Penduduk (KTP)</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Paspor</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Paspor</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>JAPAN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>運転免許</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>My Number Card</td><td width=35%>マイナンバーカード</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>旅券</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>在留カード</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>KAZAKHSTAN</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Жеке қуәлік / Yдостоверение личности</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Паспорт</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>KYRGYZSTAN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Айдоочулардын күбөлүгү / Водительское удостоверение</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>идентификациялык карта / идентификационная карта</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Жалпы жарандык паспорт / Общегражданский паспорт</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Жалпы жарандык паспорт / Общегражданский паспорт</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MALAYSIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Lesen Memandu</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>MyKad</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>MyKAS</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>MyKid</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>MyPR</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>MyPolis<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>MyTentera</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Refugee ID</td><td width=35%>UNHCR Card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>i-Kad</td><td width=35%>iKad</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MALDIVES</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>ދިވެހި ރައްޔިތެއްކަން އަންގައިދޭ ކާޑު</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MYANMAR</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>ယာဉ်မောင်းလိုင်စင်</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>နိုင်ငံကူးလက်မှတ်</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>NEPAL</h3></b></th></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>राहदानी</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>राहदानी</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PAKISTAN</h3></b></th></tr>
<tr><td width=35%>Afghan Citizen Card<sup> BETA</sup></td><td width=35%>Afghan Citizen Card (ACC)</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Consular ID</td><td width=35%>National Identity Card for Overseas Pakistanis (NICOP)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Computerized National Identity Card (CNIC), Smart National Identity Card (SNIC)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Proof Of Registration</td><td width=35%>Afghan Citizen Proof of Registration card (PoR)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PAKISTAN, PUNJAB</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PHILIPPINES</h3></b></th></tr>
<tr><td width=35%>Alien ID<sup> BETA</sup></td><td width=35%>Alien certificate of registration identity card (ACR I-Card)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>PhilSys ID / PhilID</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Multipurpose ID</td><td width=35%>Unified Multi-Purpose ID</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Postal ID<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Professional ID</td><td width=35%>PRC License</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Social Security Card</td><td width=35%>SSS ID</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Tax ID<sup> BETA</sup></td><td width=35%>TIN ID card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Voter ID<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Work Permit<sup> BETA</sup></td><td width=35%>Alien Employment Permit (AEP)</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PHILIPPINES, BANGSAMORO</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SINGAPORE</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Employment Pass</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Fin Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>NRIC (Pink)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Resident ID</td><td width=35%>NRIC (Blue)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>S Pass</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Work Permit</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SOUTH KOREA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>자동차운전면허증</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>주민등록증</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>여권</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SRI LANKA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>රියදුරු බලපත්රය</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>ජාතික හැඳුනුම්පත / தேசிய அடையாள அட்டை</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>ගමන් බලපත්‍රය / கடவுச்சீட்டு</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>TAIWAN</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>中華民國國民身分證</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Temporary Residence Permit<sup> BETA</sup></td><td width=35%>中華民國居留證 (ARC)</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>TAJIKISTAN</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Шиноснома</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>шиноснома</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>THAILAND</h3></b></th></tr>
<tr><td width=35%>Alien ID</td><td width=35%>บัตรประจำตัวคนซึ่งไม่มีสัญชาติไทย (บัตรสีชมพู)</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>ใบอนุญาตขับรถ</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>บัตรประจำตัวประชาชน</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>หนังสือเดินทาง</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>TURKMENISTAN</h3></b></th></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>UZBEKISTAN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Haydovchilik guvohnomasi</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Shaxs guvohnomasi</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>VIETNAM</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Giấy phép lái xe</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Căn cước công dân, Giấy chứng minh nhân dân</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table>
<br><br><br>

## Europe

<table>



</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ALBANIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Leje drejtimi</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver Card</td><td width=35%>Karta e drejtuesit të mjetit</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Letёrnjoftim</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Professional DL</td><td width=35%>Certifikatë aftëstimi profesionale</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasaportë</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ANDORRA</h3></b></th></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Passaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>Passaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Führerschein</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Personalausweis</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Reisepass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Aufenthaltstitel</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Reisepass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BELARUS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>BАДЗІЦЕЛЬСКАЕ ПАСВЕДЧАННЕ / ВОДИТЕЛЬСКОЕ УДОСТОВЕРЕНИЕ</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>ІДЭНТЫФІКАЦЫЙНАЯ КАРТКА</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Пашпарт / Паспорт</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>вид на жительство иностранного гражданина</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>пашпарт</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BELGIUM</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Rijbewijs / Permis de conduire / Führerschein</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Identiteitskaart / Carte d'identité / Personalausweis</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Minors ID</td><td width=35%>Kids-ID</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Paspoort / Passeport / Reisepass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Provisional DL<sup> BETA</sup></td><td width=35%>Permis de Conduire Provisoire / Vorloopig Rijebewijs / Schulungführerschein</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Verblijfstitel / Titre de Sejour</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Resident ID</td><td width=35%>Document de Seojur / Verblijfsdocument / Aufenthaltsdokument, E Kaart / Carte E / E Karte; E+ Kaart / Carte E+ / E+ Karte; F Kaart / Carte F / F Karte; F+ Kaart / Carte F+ / F+ Karte </td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>Paspoort / Passeport / Reisepass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Special ID<sup> BETA</sup></td><td width=35%>Carte d'identité spéciale / Bijzondere identiteitskaart / Besonderer Personalausweis</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BOSNIA AND HERZEGOVINA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Vozačka dozvola</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Lična karta / Osobna iskaznica</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasoš / Пасош / Putovnica</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BULGARIA</h3></b></th></tr>
<tr><td width=35%>Alien ID<sup> BETA</sup></td><td width=35%>удостоверение за пребиваване на граждани на ЕС</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Свидетелство за управление на МПС</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%> Лична карта, Лична карта</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Паспорт</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>разрешение за пребиваване</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CROATIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Vozačka dozvola</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Osobna iskaznica</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Boravišna iskaznica / Dozvola boravka</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Putovnica</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CYPRUS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Sürüş ruhsati / Aάδεια οδήγησης</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Kimlik kartı / Δελτίο Ταυτότητας</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaport / Διαβατήριο</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>ΑΔΕΙΑ ΔΙΑΜΟΝΗΣ</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CZECHIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Řidičský průkaz</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Občanský průkaz</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Povolení k pobytu</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Cestovní pas</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>DENMARK</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Kørekort</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Opholdstilladelse / Opholdskort</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pas</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ESTONIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Juhiluba</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Isikutunnistus</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Elamisluba</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>Pass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>FINLAND</h3></b></th></tr>
<tr><td width=35%>Alien ID</td><td width=35%>Ulkomaalaisen henkilökortti / Identitetskort för utlänning</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Ajokortti / Körkort</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Henkilökortti / Identitetskort</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Oleskelulupa / Uppehållstillstånd</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Passi / Pass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>FRANCE</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permis de conduire</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte d'identité</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Passeport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Professional ID<sup> BETA</sup></td><td width=35%>Carte d'identification professionnelle / Carte BTP</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Titre de séjour</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>GEORGIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>მართვის მოწმობა</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>მოქალაქის პირადობის მოწმობა</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>პასპორტი</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>GERMANY</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Führerschein</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver Qualification Card<sup> BETA</sup></td><td width=35%>Fahrerqualifizierungsnachweis</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Personalausweis</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Minors Passport</td><td width=35%>Kinderreisepass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Reisepass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Aufenthaltstitel</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Reisepass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>eID</td><td width=35%>eID-Karte</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>GIBRALTAR</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>GREECE</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Aάδεια οδήγησης</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Greek, Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>ΔΕΛΤΙΟ ΤΑΥΤΟΤΗΤΑΣ</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Διαβατήριο</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>ΑΔΕΙΑ ΔΙΑΜΟΝΗΣ</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Διαβατήριο</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>HUNGARY</h3></b></th></tr>
<tr><td width=35%>Address Card<sup> BETA</sup></td><td width=35%>Lakcímkártya / Lakcímigazolvány</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Vezetői engedély</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Személyazonosító igazolvány</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Útlevél</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Tartózkodási engedély</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ICELAND</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Ökuskírteini</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Vegabréf</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>IRELAND</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Ceadúnas tiomána</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Passport Card</td><td width=35%>Cárta Pas</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Public Services Card</td><td width=35%>Cárta Seirbhísí Poiblí</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pas</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ITALY</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Patente di guida</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carta d'identità</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Passaporto</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Permesso di soggiorno</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>KOSOVO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Patentë shoferi / возачка дозвола</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Letёrnjoftim / Лична карта</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaportë / Пасош</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>LATVIA</h3></b></th></tr>
<tr><td width=35%>Alien ID</td><td width=35%>Nepilsoņa personas apliecība</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Vadītāja apliecība</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Personas apliecība</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Uzturēšanās atļauja</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Alien Passport</td><td width=35%>Nepilsoņa pase</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pase</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>LIECHTENSTEIN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Führerschein</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Identitätskarte</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>LITHUANIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Vairuotojo pažymėjimai</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Asmens tapatybės kortelė</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Leidimas gyventi</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasas</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>LUXEMBOURG</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permis de conduire</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte d'Identité / Personalausweis</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Titre de sejour</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pass / Passeport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MALTA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Liċenzja tas-Sewqan</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Karta tal-Identità</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Passaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Permess ta' residenza / Residence documentation</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>Passaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MOLDOVA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Permis de conducere</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Buletin de identitate</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Paşaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Paşaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MONACO</h3></b></th></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Passeport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MONTENEGRO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Vozačka dozvola / Возачка дозвола</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Lična karta, Lična karta / Лична карта, Лична карта / Lična karta</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasoš / Пасош</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>NETHERLANDS</h3></b></th></tr>
<tr><td width=35%>Alien ID<sup> BETA</sup></td><td width=35%>Vreemdelingen identiteitsbewijs</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Rijebewijs</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Identiteitskaart (ID-kaart)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Verblijfstitel / Verblijfskaart</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Paspoort</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>NORTH MACEDONIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>возачка дозвола / Patentë shoferi</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>лична карта, лична карта / Letёrnjoftim</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Пасош / Pasaportë</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>NORWAY</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>FØRERKORT FØRARKORT, Førerkort / Førarkort</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>ID-kort / ID-duođaštus</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Oppholdstillatelse / Opphaldsløyve</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>POLAND</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Prawo jazdy</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Dowód osobisty</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Paszport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Karta pobytu</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Paszport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PORTUGAL</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Carta de Condução</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cartão de Cidadão (CC)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Passaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Título de Residência / Cartão de Residência</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ROMANIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permis de conducere</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte de identitate</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Permis de şedere</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasaport / Pașaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>RUSSIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Водительское удостоверение</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>(Заграничный) Паспорт</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>(Заграничный) Паспорт</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SAN MARINO</h3></b></th></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>Passaporto</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SERBIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Возачка дозвола / Vozačka dozvola</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Лична карта / Lična karta</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Пасош / Pasoš</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SLOVAKIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Vodičský preukaz</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Občiansky preukaz</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Povolenie na pobyt / Pobytový preukaz občana EÚ / Pobytový preukaz rodinného príslušníka občana EÚ</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Cestovný pas</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SLOVENIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Vozniško dovoljenje</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Osebna izkaznica</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Dovoljenje za prebivanje</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Potni list</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SPAIN</h3></b></th></tr>
<tr><td width=35%>Alien ID</td><td width=35%>Tarjeta de Identidad de Extranjero (TIE)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permiso de Conducción</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Documento Nacional de Identidad (DNI)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Permiso de residencia</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SWEDEN</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Körkort</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Nationellt identitetskort</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Uppehållstillstånd / Uppehållskort</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pass</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Refugee Passport</td><td width=35%>Resedokument</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Sis ID</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Social Security Card</td><td width=35%>Identitetskort / Skatteverkets id-kort</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SWITZERLAND</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Führerausweis / Permis de conduire / Licenza di condurre / Permiss da manischar</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>IDENTITÄTSKARTE CARTE D'IDENTITÉ CARTA D'IDENTITÀ CARTA D'IDENTITAD, Identitätskarte / Carte d’identité  / Carta d’identità / Carta d’identitad</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pass / Passeport / Passaporto / Passaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Aufenthaltstitel / Titre de séjour / Permesso di soggiorno / Permissiun da dimora</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>Pass / Passeport / Passaporto / Passaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>UK</h3></b></th></tr>
<tr><td width=35%>Asylum Request<sup> BETA</sup></td><td width=35%>Application registration card (ARC)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Trwydded yrru</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Proof Of Age Card</td><td width=35%>CitizenCard</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>UKRAINE</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Посвідчення водія / Водительское удостоверение</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Паспорт громадянина України</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Посвідка на постійне проживання (ППП)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Паспорт</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Temporary Residence Permit</td><td width=35%>Посвідка на тимчасове проживання</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Cyrillic, Latin</sub></td></tr>
</table>
<br><br><br>

## Latin America and the Caribbean

<table>



</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ANTIGUA AND BARBUDA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ARGENTINA</h3></b></th></tr>
<tr><td width=35%>Alien ID</td><td width=35%>DNI para extranjeros</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Documento Nacional de Identidad (DNI)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BAHAMAS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>NIB Smart Card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Temporary Residence Permit</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Work Permit</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BARBADOS</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Driving licence</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Trident ID Card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BOLIVIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia para conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de identidad</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Minors ID</td><td width=35%>Cédula de identidad para menores</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL</h3></b></th></tr>
<tr><td width=35%>Alien ID</td><td width=35%>Carteira de Registro Nacional Migratório, Cédula de Identidade de Estrangeiro</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Consular Paper Passport<sup> BETA</sup></td><td width=35%>Passaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Carteira Nacional de Habilitação (CNH)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Passaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, CEARA</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, DISTRITO FEDERAL</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, GOIAS</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, MARANHAO</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, MATO GROSSO</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, MINAS GERAIS</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, PARA</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, PARANA</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, PERNAMBUCO</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, RIO DE JANEIRO</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, RIO GRANDE DO SUL</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, SANTA CATARINA</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, SAO PAOLO</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BRAZIL, SERGIPE</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Cédula de identidade</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CAYMAN ISLANDS</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Driver's licence</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Voter ID<sup> BETA</sup></td><td width=35%>Voter registration card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CHILE</h3></b></th></tr>
<tr><td width=35%>Alien ID</td><td width=35%>Cédula de identidad para extranjeros</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de Identidad</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>COLOMBIA</h3></b></th></tr>
<tr><td width=35%>Alien ID</td><td width=35%>Cédula de Extranjería (CE)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducción</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula Digital Colombiana, Cédula de Ciudadanía (CC)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Minors ID</td><td width=35%>Tarjeta de identidad Biométrica (Azul)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Temporary Protection Permit</td><td width=35%>Permiso por protección temporal</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>COSTA RICA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de identidad</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CUBA</h3></b></th></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Carné de Identidad</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>DOMINICAN REPUBLIC</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de Identidad y Electoral (CIE)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Non Voter ID</td><td width=35%>Cédula de Identidad</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ECUADOR</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de Identidad, Cédula de Identidad Electrónica</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>EL SALVADOR</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Documento Único de Identidad (DUI)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>GUATEMALA</h3></b></th></tr>
<tr><td width=35%>Alien ID</td><td width=35%>Documento Personal de Identificación (DPI) - Extranjero domiciliado</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Consular ID</td><td width=35%>Tarjeta de Identificación Consular (TICG)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Documento Personal de Identificación (DPI)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>GUYANA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>HAITI</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permis de conduire</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte d'identification nationale (CIN) / Kat Idantifikasyon Nasyonal</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Passeport / Paspò</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>HONDURAS</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Tarjeta de identidad</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>JAMAICA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Motor vehicle license / MV license</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Passeport / Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Voter ID</td><td width=35%>Elector registration identification card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO</h3></b></th></tr>
<tr><td width=35%>Consular ID<sup> BETA</sup></td><td width=35%>Matrícula Consular, Matrícula consular</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Consular Voter ID</td><td width=35%>Credencial para votar desde el extranjero</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Professional DL<sup> BETA</sup></td><td width=35%>Licencia Federal de Conductor</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Professional ID<sup> BETA</sup></td><td width=35%>Cédula Profesional</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>Tarjeta de Residencia Temporal y Residencia Permanente</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Tax ID<sup> BETA</sup></td><td width=35%>Cédula de Identificación Fiscal (CIF)</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Voter ID</td><td width=35%>Credencial para votar</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, AGUASCALIENTES</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, BAJA CALIFORNIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, BAJA CALIFORNIA SUR</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, CAMPECHE</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, CHIAPAS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, CHIHUAHUA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, CIUDAD DE MEXICO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, COAHUILA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, COLIMA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, DURANGO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, GUANAJUATO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, GUERRERO JUCHITAN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, HIDALGO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, JALISCO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, MEXICO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, MICHOACAN</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, MORELOS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, NAYARIT</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, NUEVO LEON</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>LICENCIA PARA CONDUCIR, Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, OAXACA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, PUEBLA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, QUINTANA ROO</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, QUINTANA ROO BENITO JUAREZ</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, QUINTANA ROO COZUMEL</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, QUINTANA ROO SOLIDARIDAD</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, SAN LUIS POTOSI</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, SINALOA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, SONORA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir, Licencia para conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, TABASCO</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, TAMAULIPAS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, TLAXCALA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir, Licencia para conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, VERACRUZ</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, YUCATAN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MEXICO, ZACATECAS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>NICARAGUA</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de Identidad Ciudadana</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PANAMA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de Identidad, Documento de Identidad</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Carné de Residente Permanente</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Temporary Residence Permit</td><td width=35%>Carné de Residencia Provisional</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PARAGUAY</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de Identidad Civil</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PERU</h3></b></th></tr>
<tr><td width=35%>Alien ID<sup> BETA</sup></td><td width=35%>Carné de Extranjería</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de conducir</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Documento Nacional de Identidad (DNI)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Minors ID</td><td width=35%>Documento Nacional de Identidad (DNI) para menores</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PUERTO RICO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia de Conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Voter ID<sup> BETA</sup></td><td width=35%>Tarjeta de Identificación Electoral (TIE) / Electoral Identification Card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SAINT KITTS AND NEVIS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SAINT LUCIA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>NIS/NIC Card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>TRINIDAD AND TOBAGO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>TURKS AND CAICOS ISLANDS</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>National Turks & Caicos Islander Status Card / National TCI Status Card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>URUGUAY</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de Identidad</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>VENEZUELA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Licencia para conducir</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Cédula de Identidad</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasaporte</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table>
<br><br><br>

## Middle East and Africa

<table>



</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ALGERIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>رخصة القيادة</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte nationale d’identité / بطاقة الهوية الوطني</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>جواز السفر / Passeport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BAHRAIN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>رخصة السائق</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة الهوية / CPR Card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BOTSWANA</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Omang</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BURKINA FASO</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte Nationale d'Identité Burkinabè (CNIB)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CAMEROON</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte Nationale d'Identité (CNI)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Passeport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Passeport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>COMOROS</h3></b></th></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Passeport / جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>DEMOCRATIC REPUBLIC OF THE CONGO</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Permis de conduire (CONADEP)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Voter ID<sup> BETA</sup></td><td width=35%>Carte d'electeur</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>EGYPT</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>رخصة القيادة</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة تحقيق الشخصية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ESWATINI</h3></b></th></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>GHANA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Ghana Card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>IRAN</h3></b></th></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>گذرنامه</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>IRAQ</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>البطاقة الوطنية / كارتى نيشتمانى</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>پاسپورت / جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>پاسپورت / جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ISRAEL</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>רשיון נהיגה</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Tehudat Zehut / بطاقة هوية‎ / תעודת זהות</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>דרכון</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>IVORY COAST</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permis de conduire</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte Nationale d'Identité (CNI)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>JORDAN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>رخصة القيادة</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة شخصية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>KENYA</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Kitambulisho</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Passport / Pasi</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>KUWAIT</h3></b></th></tr>
<tr><td width=35%>Bidoon Card<sup> BETA</sup></td><td width=35%>بطاقة مراجعة</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Driver's License</td><td width=35%>رخصة القيادة</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة المدنية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Resident ID</td><td width=35%>بطاقة المدنية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>LEBANON</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>رخصة السائق</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة الهوية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>LIBYA</h3></b></th></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MAURITIUS</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MOROCCO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permis de conduire / رخصة القيادة</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte nationale d'identité /  بطاقة التعريف الوطنية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>Passeport / جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>MOZAMBIQUE</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>Carta de Condução</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Bilhete de Identidade (BI)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>NAMIBIA</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>NIGERIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>e-ID card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Voter ID</td><td width=35%>Permanent Voter Card (PVC)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>OMAN</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%>رخصة قيادة مركبة</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة الهوية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport<sup> BETA</sup></td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Resident ID</td><td width=35%>بطاقة مقيم</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>PALESTINE</h3></b></th></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>جواز سفر / דרכון</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>QATAR</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>رخصة القيادة</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>بطاقة إثبات شخصية</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>تصريح الإقامة</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>RWANDA</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Indangamuntu</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SAUDI ARABIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>رخصة قيادة</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة الأحوال المدنية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Resident ID</td><td width=35%>Iqama / هوية المقيم</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SENEGAL</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Carte d'identité biométrique CEDEAO, Carte nationale d'identité</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SOUTH AFRICA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Bestuurslisensie</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Smart ID card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Green barcoded ID	book</td><td align="center" width=15%><sub>FRONT<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Passeport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SUDAN</h3></b></th></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>SYRIA</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة شخصية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>TANZANIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Leseni ya udereva</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Kitambulisho cha Taifa / NIDA</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Voter ID<sup> BETA</sup></td><td width=35%>Kadi ya mpiga kura / Voter Card</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>TOGO</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Permis de conduire</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>TUNISIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>رخصة قيادة</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة التعريف الوطنية</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>TURKEY</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Sürücü belgesi</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Kimlik Kartı</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Pasaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit<sup> BETA</sup></td><td width=35%>İkamet İzni</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Pasaport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>UAE</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>رخصة القيادة</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>بطاقة الهوية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Resident ID</td><td width=35%>بطاقة الهوية الوطنية</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport<sup> BETA</sup></td><td width=35%>جواز سفر</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Arabic, Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>UGANDA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>ZIMBABWE</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%>National registration card (NRC)</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>UAE</h3></b></th></tr>
<tr><td width=35%>Vehicle Registration<sup> BETA</sup></td><td width=35%>Vehicle License</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub></sub></td></tr>
</table>
<br><br><br>

## Northern America

<table>



</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>BERMUDA</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA</h3></b></th></tr>
<tr><td width=35%>Citizenship Certificate<sup> BETA</sup></td><td width=35%>Canada citizenship card / Carte de citoyenneté canadienne </td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%>Passport / Passeport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Residence Permit</td><td width=35%>Permanent residence (PR) card / Carte de résident permanent</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Passport / Passeport</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Social Security Card<sup> BETA</sup></td><td width=35%>Social insurance card (SIN card) / Carte d'assurance sociale (Carte de NAS) </td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Tribal ID</td><td width=35%>Certificate of Indian Status / Certificat de statut Indien</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Weapon Permit</td><td width=35%>Possesion and Aquisition License (PAL) / Permis de possession et d'acquisition</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, ALBERTA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, BRITISH COLUMBIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Driver's License/Public Services Card (Combined)</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Minors Public Services Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Public Services Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, MANITOBA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, NEW BRUNSWICK</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permis de conduire</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%>Carte d'identité</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, NEWFOUNDLAND AND LABRADOR</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, NOVA SCOTIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, ONTARIO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%>Photo card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, PRINCE EDWARD ISLAND</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, QUEBEC</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permis de conduire</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, SASKATCHEWAN</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>CANADA, YUKON</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%>Permis de conduire</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA</h3></b></th></tr>
<tr><td width=35%>Border Crossing Card</td><td width=35%>BCC</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Global Entry Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Green Card</td><td width=35%>Permanent resident card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Military ID</td><td width=35%>Common Access Card (CAC)</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Nexus Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Passport Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Social Security Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Twic Card</td><td width=35%>Transportation Worker Identification Credential</td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Uniformed Services ID</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Veteran ID</td><td width=35%>VIC</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Work Permit</td><td width=35%>Employment authorization document / EAD Card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, ALABAMA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, ALASKA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, ARIZONA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, ARKANSAS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, CALIFORNIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, COLORADO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, CONNECTICUT</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, DELAWARE</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, DISTRICT OF COLUMBIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, FLORIDA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, GEORGIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, HAWAII</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, IDAHO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, ILLINOIS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, INDIANA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, IOWA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, KANSAS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, KENTUCKY</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, LOUISIANA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, MAINE</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, MARYLAND</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, MASSACHUSETTS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, MICHIGAN</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, MINNESOTA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, MISSISSIPPI</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, MISSOURI</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, MONTANA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, NEBRASKA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, NEVADA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, NEW HAMPSHIRE</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, NEW JERSEY</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, NEW MEXICO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, NEW YORK</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, NEW YORK CITY</h3></b></th></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, NORTH CAROLINA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, NORTH DAKOTA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, OHIO</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, OKLAHOMA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, OREGON</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, PENNSYLVANIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, RHODE ISLAND</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, SOUTH CAROLINA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, SOUTH DAKOTA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, TENNESSEE</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, TEXAS</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Weapon Permit</td><td width=35%>License to Carry a Handgun (LTC)</td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, UTAH</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, VERMONT</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, VIRGINIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, WASHINGTON</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, WEST VIRGINIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, WISCONSIN</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>USA, WYOMING</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table>
<br><br><br>

## Oceania

<table>



</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA</h3></b></th></tr>
<tr><td width=35%>Asic Card<sup> BETA</sup></td><td width=35%>Aviation Security Identification Card</td><td align="center" width=15%><sub>FRONT,<br>VERTICAL</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Paper Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%></td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA, AUSTRALIAN CAPITAL TERRITORY</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA, NEW SOUTH WALES</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA, NORTHERN TERRITORY</h3></b></th></tr>
<tr><td width=35%>Driver's License<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Proof Of Age Card</td><td width=35%>NT Evidence of age card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA, QUEENSLAND</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Proof Of Age Card<sup> BETA</sup></td><td width=35%>Photo Identification Card</td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA, SOUTH AUSTRALIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Proof Of Age Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA, TASMANIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA, VICTORIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Proof Of Age Card</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>AUSTRALIA, WESTERN AUSTRALIA</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Identity Card<sup> BETA</sup></td><td width=35%></td><td align="center" width=15%><sub>FRONT, BACK</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table><table><tr><th width=1200px colspan = 4 align="center"> <b><h3>NEW ZEALAND</h3></b></th></tr>
<tr><td width=35%>Driver's License</td><td width=35%></td><td align="center" width=15%><sub>FRONT</sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
<tr><td width=35%>Polycarbonate Passport</td><td width=35%>Uruwhenua</td><td align="center" width=15%><sub>BIO-DATA PAGE </sub></td><td align="center" width=15%><sub>Latin</sub></td></tr>
</table>
<br><br><br>
