---
title: 1.0.0-beta.10 - XML sitemap and Better way of finding pages
lead: Sitemap as new feature and no need for magic strings in routes
published: 2024-08-19
tags: [release, sitemap.xml, razor-pages]
authors:
- name: "Jan Tesař"
  gitHubUserName: "tesar-tech"
  xUserName: "tesar_tech"
- name: "Melty Observer"
  gitHubUserName: "MeltyObserver"
---

## Breaking Changes

- `RazorPagesPaths` is no longer available. It was used to get the location of razor pages to scan for the `@page`
  directive.
  Now, BlazorStatic scans the assembly for all pages.
- `AddNonParametrizedRazorPages` was renamed to `AddPagesWithoutParameters` as it clearly describes what it is about.

## Features

XML sitemap and a better way of finding pages.

## XML Sitemap

Check an example [here](https://tesar-tech.github.io/BlazorStatic/sitemap.xml).

BlazorStatic now includes the ability to generate an XML sitemap, which is beneficial for search engine optimization (
SEO).
To generate a proper sitemap, you can configure three new settings, two of which are required.

```csharp
builder.Services.AddBlazorStaticService(opt => {
  opt.ShouldGenerateSitemap = true;
  opt.SiteUrl = "https://tesar-tech.github.io/BlazorStatic";
});
```

The first setting is a switch that tells the library to generate the sitemap.
The second setting, `SiteUrl`, is required because BlazorStatic cannot determine the site URL when generating static
files.

If you don't provide the `SiteUrl`, you will encounter a warning, and the sitemap will not be generated.

```sh
warn: BlazorStatic.Services.BlazorStaticService[0]
      'BlazorStaticOptions.SiteUrl' is null or empty! Can't generate Sitemap. Either provide the site url or set 'BlazorStaticOptions.ShouldGenerateSitemap' to false
```

The `sitemap.xml` file is generated by default to `wwwroot/sitemap.xml`.
This ensures the file is available not only as a result of static file generation but also during the web app runtime (
and debugging).

Since `sitemap.xml` is a generated file, you might want to consider making it ignored by Git.

## Better way of finding pages

- You no longer need to use the `@page` directive; you can use the `Route` attribute instead (the `@page` directive is
  translated to that anyway).

Before:

```
@page "/projects"
```

After:

```
@attribute [Route("/projects")]*@
```

You might say it is uglier now, and you would be right.
The `@page` directive simplifies the usage of the `Route` attribute, but it only supports strings.
To avoid magic strings and keep all routes in a single place, I recommend defining routes centrally.
For example, in BlazorStaticWebsite, the `projects` page is defined as:

```
@attribute [Route($"/{WebsiteKeys.ProjectsUrl}")]
```

Which keeps the `project` string definition in one place.



