![images](assets/hacktoberfest.svg)

Hacktoberfest® is open to everyone in our global community. Whether you’re a seasoned contributor or looking for projects to contribute to for the first time, you’re welcome to participate.

### Visit [Hacktoberfest](https://hacktoberfest.digitalocean.com/) Website to know more.

### How to register:

* Go to <https://github.com> & create an account.
* Then register at <https://hacktoberfest.digitalocean.com/register> by logging through your GitHub Account and you're all set to contribute for Hacktoberfest.

### But there are some rules for Hacktoberfest and here we go:

✅ Pull requests can be submitted to any opted-in repository on GitHub or GitLab.

✅ The pull request must contain commits you made yourself.

⚠️ If a maintainer reports your pull request as spam, it will not be counted toward your participation in Hacktoberfest.

⚠️ If a maintainer reports behavior that’s not in line with the project’s code of conduct, you will be ineligible to participate.

✅ To get a shirt, you must make four approved pull requests (PRs) on opted-in projects between October 1-31 in any time zone.

😀 This year, the first 50,000 participants can earn a T-shirt.

A repository/project is considered to be participating in Hacktoberfest if the **'hacktoberfest'** topic is present and is accepting public contributions via pull requests. An individual pull request can also be opted-in directly by adding the 'hacktoberfest-accepted' label.

A pull request is considered approved once it has an overall approving review from maintainers, or has been merged by maintainers, or has been given the 'hacktoberfest-accepted' label. A pull request with any label containing the word 'spam' or 'invalid' will be considered ineligible for Hacktoberfest.

Read the [participation details](https://hacktoberfest.digitalocean.com/resources/participation) to learn how to earn your Hacktoberfest tee or tree reward.

## Resources for learning Git and GitHub

### What is Git?

<div align="center">
    <img src="https://github.com/Hack-Club-SIT/Git-Learning-Resources/blob/master/assets/git_logo.png" alt="git-logo" width="300px" height="300px">
</div>

**Git** is a *Distributed Version Control System*. If you didn't understand anything then read this [blog](https://medium.com/@mallickdebajit3/deep-dive-into-git-2e190c5404ea).

### What is GitHub?

<div align="center">
    <img src="https://github.com/Hack-Club-SIT/Git-Learning-Resources/blob/master/assets/github_logo.png" alt="github-logo" width="300px" height="300px">
</div>

**GitHub** is a code hosting platform for *version control* and *collaboration*. It lets you and others work together on projects from anywhere.

*Here we provide some resources for learning Git and GitHub from beginner to advanced level*.

> All the resources are free.

#### Video Resources
* [Git Started with GitHub(Udemy)](https://www.udemy.com/course/git-started-with-github/?LSNPUBID=JVFxdTr9V80&ranEAID=JVFxdTr9V80&ranMID=39197&ranSiteID=JVFxdTr9V80-ueX9MWXfgLzfQ4cyW2x..Q&utm_medium=udemyads&utm_source=aff-campaign)

* [Intro to Git(Udemy)](https://www.udemy.com/course/intro-to-git/?LSNPUBID=JVFxdTr9V80&ranEAID=JVFxdTr9V80&ranMID=39197&ranSiteID=JVFxdTr9V80-EdA9vsQYD99cnfBbrZvx.w&utm_medium=udemyads&utm_source=aff-campaign)

* [Git: Become an Expert in Git & GitHub in 4 Hours(Udemy)](https://www.udemy.com/course/git-expert-4-hours/?LSNPUBID=JVFxdTr9V80&ranEAID=JVFxdTr9V80&ranMID=39197&ranSiteID=JVFxdTr9V80-LkjkptGe2LuspCTaCL6wgQ&utm_medium=udemyads&utm_source=aff-campaign)

* [Git and GitHub - Step by Step for Beginners(Udemy)](https://www.udemy.com/course/git-and-github-step-by-step-for-beginners/?LSNPUBID=JVFxdTr9V80&ranEAID=JVFxdTr9V80&ranMID=39197&ranSiteID=JVFxdTr9V80-EzSBZYea7VseFenSexByOw&utm_medium=udemyads&utm_source=aff-campaign)

* [Version Control with Git(Coursera)](https://www.coursera.org/learn/version-control-with-git?ranMID=40328&ranEAID=JVFxdTr9V80&ranSiteID=JVFxdTr9V80-16ETatBacJxlnbaQQg34QQ&siteID=JVFxdTr9V80-16ETatBacJxlnbaQQg34QQ&utm_content=10&utm_medium=partners&utm_source=linkshare&utm_campaign=JVFxdTr9V80)

* [Git and GitHub for Beginners - Crash Course(YouTube - freeCodeCamp.org)](https://youtu.be/RGOj5yH7evk)

#### Text Resources
* [Deep Dive Into Git](https://medium.com/@mallickdebajit3/deep-dive-into-git-2e190c5404ea)

* [Learn Git Branching](https://learngitbranching.js.org/)

* [git - the simple guide](http://up1.github.io/git-guide/index.html)

* [Learn Git with Bitbucket Cloud](https://www.atlassian.com/git/tutorials/learn-git-with-bitbucket-cloud)

#### Cheatsheets
* [Git cheat sheet(Atlassian)](https://www.atlassian.com/git/tutorials/atlassian-git-cheatsheet)

* [Git cheat sheet(GitHub Education)](https://education.github.com/git-cheat-sheet-education.pdf)

* [Git cheat sheet(GitHub Training)](https://github.github.com/training-kit/downloads/github-git-cheat-sheet.pdf)

* [Git cheat sheet(Git Tower)](https://www.git-tower.com/blog/git-cheat-sheet/)

* [Git cheat sheet](https://about.gitlab.com/images/press/git-cheat-sheet.pdf)

* [Git cheat sheet(UCSD DSE MAS)](https://mas-dse.github.io/DSE200/cheat_sheets/3_version_control/3_1_git_cheat_sheet.pdf)

## How to Participate

1. ### Fork the Repo

   Give a start and ⭐ Click on **fork** button in the right corner.It will create a copy of repositiry in your account.

    - Check here [How to fork](https://docs.github.com/en/github/getting-started-with-github/fork-a-repo)
    - Image:
    
      <img align="centre" src="https://github.com/BlankCoders/GoogleKickStart2020_Solutions/blob/master/assets/Fork.JPG" alt="fork">

2. ### Clone the Repo

   You can **clone** your repository in your local pc with use of **[GitHub Desktop](https://desktop.github.com/)** application or for your [Terminal/bash](https://git-scm.com/downloads).

   For **Terminal** -

   ```bash
   git clone <url_name>
   ```

   - [Cloning the Repository](https://docs.github.com/en/github/creating-cloning-and-archiving-repositories/cloning-a-repository)
   - Image:
   
      <img src="https://github.com/BlankCoders/GoogleKickStart2020_Solutions/blob/master/assets/Save1.JPG" alt="clone">
      <br>
      <img src="https://github.com/BlankCoders/GoogleKickStart2020_Solutions/blob/master/assets/Save2.JPG" alt="clone">
      
3. ### Upload your Code or Change and Push it
    
    <img src="https://github.com/BlankCoders/GoogleKickStart2020_Solutions/blob/master/assets/commands.JPG" alt="clone">
    
     #### After doing necessary edits run commands:
     
      - `git add .`
         - This command updates the index using the current content found in the working tree, to prepare the content staged for the next commit. It typically adds the current content of existing paths as a whole, but with some options it can also be used to add content with only part of the changes made to the working tree files applied, or remove paths that do not exist in the working tree anymore.

         - The "index" holds a snapshot of the content of the working tree, and it is this snapshot that is taken as the contents of the next commit. Thus after making any changes to the working tree, and before running the commit command, you must use the add command to add any new or modified files to the index.

         - This command can be performed multiple times before a commit. It only adds the content of the specified file(s) at the time the add command is run; if you want subsequent changes included in the next commit, then you must run git add again to add the new content to the index.

         - The git status command can be used to obtain a summary of which files have changes that are staged for the next commit.

         - The git add command will not add ignored files by default. If any ignored files were explicitly specified on the command line, git add will fail with a list of ignored files. Ignored files reached by directory recursion or filename globbing performed by Git (quote your globs before the shell) will be silently ignored. The git add command can be used to add ignored files with the -f (force) option.
         
      - `git status`
         - Displays paths that have differences between the index file and the current HEAD commit, paths that have differences between the working tree and the index file, and paths in the working tree that are not tracked by Git (and are not ignored by gitignore). The first are what you would commit by running `git commit;` the second and third are what you could commit by running git add before running git commit.
         
      - `git commit -m "<your message>"`   (exclude brackets)
         - Takes the staged snapshot and commits it to the project history. Combined with git add, this defines the basic workflow for all Git users.
         
      - `git remote add origin <url>`  (exclude brackets)
         -  When you clone a repository with git clone , it automatically creates a remote connection called origin pointing back to the cloned repository. This is useful for developers creating a local copy of a central repository, since it provides an easy way to pull upstream changes or publish local commits.
         
      - `git push --force origin master`
         - Updates remote refs using local refs, while sending objects necessary to complete the given refs.

         - You can make interesting things happen to a repository every time you push into it, by setting up hooks there.
         
         - [Push your first code](https://docs.github.com/en/github/importing-your-projects-to-github/adding-an-existing-project-to-github-using-the-command-line)
   
4. ### Make a PR

    <!-- Push it to your repository and Issue a PR(Pull Request) in main repository. -->
    
    #### Now Since you're done with pushing your code. It's time to do that thing for which we are actually waiting & that is `PULL REQUEST` (in short PR).
    
    * Tap `Pull request`
    <img src="https://github.com/BlankCoders/GoogleKickStart2020_Solutions/blob/master/assets/PR.JPG" alt="PR">
    
    * Tap `Create pull request`
    <img src="https://github.com/BlankCoders/GoogleKickStart2020_Solutions/blob/master/assets/PR1.JPG" alt="PR">

    * Write the Title & Description & Tap `Create pull request`
    <img src="https://github.com/BlankCoders/GoogleKickStart2020_Solutions/blob/master/assets/PR2.JPG" alt="PR">
    
    * Pull requests let you tell others about changes you've pushed to a GitHub repository. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.

## :rocket: Voila! You have Contributed to Open-Source 😋.

If you stuck somewhere, contact [here](https://github.com/BlankCoders/GoogleKickStart2020_Solutions/discussions/96).
