# Technical Reading

A list of useful articles, blogs, and scientific papers on modern algorithms and techniques for audio DSP.

- [ADC Videos](https://www.youtube.com/c/JUCElibrary/featured) - This YouTube channel hosts a bunch of talks and lectures given during the annual [Audio Developer's Conference](https://audio.dev/).
  - This one on [high quality wavetable oscillators](https://www.youtube.com/watch?v=qlinVx60778) by the creator of the Vital synth is particularly good one for those interested in wavetable synthesis.
- [AES](https://aes2.org/) - A large collection of high quality research and technical papers. Requires a paid membership to access.
- [Audio Effects Research](https://github.com/mcomunita/AFX-Research) - A collection of scientific literature about audio effects.
- [CCRMA Publications](https://ccrma.stanford.edu/papers) - A large collection of published research, hosted by Standford University.
  - The Effect Design papers by Jon Dattorro are particuarly good. [Part 1](https://ccrma.stanford.edu/~dattorro/EffectDesignPart1.pdf), [Part 2](https://ccrma.stanford.edu/~dattorro/EffectDesignPart2.pdf), [Part 3](https://ccrma.stanford.edu/~dattorro/EffectDesignPart3.pdf)
- [Cytomic Technical Papers](https://cytomic.com/technical-papers/) - Excellent filter designs, equations, and explanations by Cytomic. Use these as a better alternative to biquad filters that both sound better and perform better when being modulated.
  - Specifically the document [SvfLinearTrapOptimised2](https://cytomic.com/files/dsp/SvfLinearTrapOptimised2.pdf) contains filters and equations that are a better alternative to the ones in the [RBJ Cookbook](https://webaudio.github.io/Audio-EQ-Cookbook/audio-eq-cookbook.html).
- [DAFx](http://www.dafx.de/) - An archive of scientific papers and presentations given during an annual DSP research conference.
- [deip.pdf](../content/deip.pdf) - A collection of high quality and fast sub-sample interpolators.
- [DSP Jargon](https://github.com/sudara/dspjargon) - A dictionary of DSP-related jargon.
- [Freeverb3 - DSP References](https://freeverb3vst.osdn.jp/ref.shtml) - A huge list of technical DSP resources focused mainly on reverb design.
- [Freeverb](https://ccrma.stanford.edu/~jos/pasp/Freeverb.html) - An open-source reverb algorithm.
- [Jatin Chowdhury](https://jatinchowdhury18.medium.com/) - An active blog that explores cutting-edge DSP techniques.
- [katjaas](http://www.katjaas.nl/home/home.html) - Neat visual explanations of DSP mathematics and techniques.
- [Musicdsp.org](https://www.musicdsp.org/en/latest/index.html) - A collection of open source DSP algorithms by the community.
- [Noise reduction in python using spectral gating](https://github.com/timsainb/noisereduce) - A [Jupyter Notebook](https://jupyter.org/) describing a high quality noise reduction algorithm.
- [Reaktor 6 DSP Articles](https://www.native-instruments.com/en/products/komplete/synths/reaktor-6/dsp-articles/) - A collection of DSP articles by Native Instruments. It also includes examples of how to implement them in Reaktor 6.
- [Reproducible Audio Research](https://github.com/faroit/reproducible-audio-research/)
- [Signalsmith Audio Blog](https://signalsmith-audio.co.uk/writing/) - An amazing and very useful collection of articles by Signalsmith Audio. The [Let's Write A Reverb](https://signalsmith-audio.co.uk/writing/2021/lets-write-a-reverb/) article is particularly excellent.
- [synfx-dsp](https://github.com/WeirdConstructor/synfx-dsp) - A Rust crate that has several useful essential DSP algorithms you can reference along with links to relevant resources, used by the [HexoSynth](https://github.com/WeirdConstructor/HexoSynth) plugin. Includes algorithms such as filters, oscillators, LFOs, sub-sample interpolation, envelopes, waveshapers, oversampling, and a reverb.
- [Tokyo Dawn Labs Knowledge Base](https://docs.tokyodawn.net/) - A list of technical articles by Tokyo Dawn Labs.
- [The Ardour DAW – Latency Compensation and Anywhere-to-Anywhere Signal Routing Systems](https://gareus.org/misc/thesis-p8/2017-12-Gareus-Lat.pdf) - A thesis describing an algorithm for automatically calculating delay compensation in an audio graph.
- [The Design of the Roland Juno oscillators](https://blog.thea.codes/the-design-of-the-juno-dco/) - A beautiful and simple explanation on the oscillators of this classic synth.
- [TimeStretch PDF](https://github.com/spluta/TimeStretch/blob/main/NessStretchICMC_Final.pdf) - A PDF explaining the DSP of [TimeStretch](https://github.com/spluta/TimeStretch), a refinement of the famous [PaulStretch](http://hypermammut.sourceforge.net/paulstretch/) time stretching effect.
- [Valhalla Blog](https://valhalladsp.com/blog/) - Valhalla DSP has an excellent blog linking many resources that helped them create their industry-leading reverbs.
