# System Tools

A list of system tools useful in developing audio plugins and software.

- [Ardour](https://ardour.org/) - Open-source DAW with useful plugin analysis tools.
- [Bertom EQ Curve Analyzer](https://www.bertomaudio.com/eqca.html) - Analyze the frequency and phase response of any plugin.
- [Cadence](https://kx.studio/Applications:Cadence) - A suite of tools for configuring, monitoring, and controlling system-wide audio in Linux (includes [Carla]).
- [Carla] - System-wide virtual audio and MIDI patching software, using [Jack] as the backend. Available as a standalone application or a VST/LV2 plugin.
- [clap-validator](https://github.com/free-audio/clap-validator) - An open-source CLAP plugin validation tool.
- [DSP Testbench](https://github.com/AndrewJJ/DSP-Testbench) - A tool to help developers using the JUCE framework to analyze their DSP.
- [Jack] - Cross-platform audio driver with support for system-wide patching.
- [PipeWire](https://docs.pipewire.org/index.html) - A modern alternative to Jack with more features (Linux only).
- [Plugindoctor](https://ddmf.eu/plugindoctor/) - An all-encompassing plugin analyzer. It's definitely worth the money if you're serious about DSP.
- [plugin-torture](https://github.com/cth103/plugin-torture) - A tool to test LADSPA and LV2 plugins.
- [pluginval](https://github.com/Tracktion/pluginval) - Cross-platform open-source plugin validation tool made by the company Tracktion.
- [yabridge](https://github.com/robbert-vdh/yabridge) - Allows you to load VST2, VST3, and CLAP plugins made for Windows into Linux DAWs using Wine. Supports both 32 bit and 64 bit plugins, and even allows bridged plugins to communicate with each other.

[Carla]: https://kx.studio/Applications:Carla
[Jack]: https://jackaudio.org/
