# Paid Textbooks

A list of non-free textbooks on audio DSP.

- [A Digital Signal Processing Primer](https://www.amazon.com/Digital-Signal-Processing-Primer-Applications/dp/0486845834) by Kenneth Steiglitz
  - Great introduction to the mathematics of DSP.
  - Focuses more on mathematics and does not have many example effects.
  - ISBN-10: 0486845834, ISBN-13: 978-0486845838
- [Audio Effects: Theory, Implementation and Application](https://www.amazon.com/Audio-Effects-Theory-Implementation-Application/dp/1466560282) by Joshua D. Reiss and Andrew McPherson
  - A comprehensive book describing how to make common audio effects.
  - ISBN-10: 1466560282, ISBN-13: 978-1466560284
- [Code Your Own Synth Plug-Ins With C++ and JUCE](https://www.theaudioprogrammer.com/synth-plugin-book) by Matthijs Hollemans
  - Step-by-step guide that teaches how to build a synthesizer plug-in.
  - This book is aimed at beginners and is light on the mathematics, with in-depth explanations of the algorithms used.
  - ISBN-13: 979-8866751853
- [DAFX: Digital Audio Effects](https://www.amazon.com/DAFX-Digital-Effects-Udo-Z%C3%B6lzer/dp/0470665998) by Udo Zölzer (Editor)
  - Explores good modern advanced effects. It's made by the [DAFx](http://www.dafx.de/) annual scientific research conference.
  - MATLAB is used for its code examples, but [GNU Octave] could probably be used as well.
  - ISBN-10: 0470665998, ISBN-13: 978-0470665992
- [Designing Software Synthesizer Plug-Ins in C++](https://www.amazon.com/Designing-Software-Synthesizer-Plug-Ins-Audio/dp/0367510480) and [Designing Audio Effect Plugins in C++](https://www.amazon.com/Designing-Audio-Effect-Plugins-C/dp/1138591939) by Will Pirkle
  - One of the most highly recommended resources for entering the world of audio DSP.
  - Great beginner resource that teaches fundamental DSP concepts without going into too much mathematics.
  - The synthesizer one is better than the effect one imo, so go for that if you plan on only buying one.
  - Focuses on teaching concepts, not on writing performant code. His coding style is not that efficient for real-world use.
  - ISBN-10: 0367510480 and 1138591939, ISBN-13: 978-0367510480 and 978-1138591936
- [Digital Signal Processing: A Practical Guide for Engineers and Scientists](https://www.amazon.com/Digital-Signal-Processing-Practical-Scientists/dp/075067444X) by Steven Smith
  - Another book recommended to beginners.
  - Focuses more on general DSP rather than audio DSP.
  - Uses MATLAB for its code examples, but [GNU Octave] could probably be used as well.
  - ISBN-10: 075067444X, ISBN-13: 978-0750674447
- [Digital Signal Processing: Concepts and Applications](https://www.amazon.com/Digital-Signal-Processing-Concepts-Applications/dp/0333963563) by Mulgrew, Grant & Thompson
  - Covers the basic principles of DSP in an easy-to-digest way without going into too much mathematics.
  - Focuses more on general DSP rather than audio DSP.
  - Uses MATLAB for its code examples, but [GNU Octave] could probably be used as well.
  - ISBN-10: 0333963563, ISBN-13: 978-0333963562
- [Discrete-Time Signal Processing](https://www.amazon.com/Discrete-Time-Signal-Processing-3rd-Prentice-Hall/dp/0131988425) by Alan Oppenheim and Ronald Schafer
  - A comprehensive book covering all the essentials of DSP.
  - Focuses more on general DSP rather than audio DSP.
  - ISBN-10: 0131988425, ISBN-13: 978-0131988422 

[GNU Octave]: https://www.gnu.org/software/octave/index
