# Mathematics

Learning resources and tools for the mathematics of audio DSP.

DSP (Digital Signal Processing) is the study of using a digital computer to process what is normally thought of as an analog signal (such as sound). Unfortunately (or fortunately depending on who you are 😉), the reality is that DSP is a math heavy field. However, the math needed to get started is not *too* difficult in my opinion. Knowing high-school level math and some of the basics of college-level math will get you most of the way there.

## Prerequisites

I recommend knowing at least these fundamental concepts in order to best get started with learning DSP:

- Algebra dealing with polynomials, fractions, and exponents (exponents are especially important here)
- Basic trigonometry like sine, cosine, tangent, arctangent, etc.
- Logarithms (especially the natural logarithm and the number "e")
- Complex (imaginary) numbers and complex algebra (using algebra with complex numbers). Complex numbers are a core pillar of DSP mathematics.

### Nice to haves

These prerequisites aren't strictly necessary, but they can help you understand things better.

- Basic knowledge of linear algebra (the study of transforming data with matrices).
- Basic knowledge of calculus such as derivatives and integrals.
- Basic knowledge of what differential equations are and why they are important. (Note I don't mean knowing how to actually *solve* differential equations, because they are "really freakin' hard to solve" to put it lightly.)

## Learning Resources

- [3Blue1Brown](https://www.youtube.com/channel/UCYO_jab_esuFRV4b17AJtAw) - An excellent YouTube channel on complex algebra, linear algebra, calculus, and differential equations.
  - His videos on [Euler's Formula](https://www.youtube.com/watch?v=mvmuCPvRoWQ) and the [Fourier Transform](https://www.youtube.com/watch?v=spUNpyF58BY) are particularly excellent.
- [Awesome Math](https://github.com/rossant/awesome-math) - A large list of math-related resources.
- [katjaas](http://www.katjaas.nl/home/home.html) - Neat visual explanations of DSP mathematics and techniques.
- [Khan Academy](https://www.khanacademy.org/math) - Free college-level courses.
- [Paul's Cheat Sheets](https://tutorial.math.lamar.edu/Extras/CheatSheets_Tables.aspx) - Cheat sheets for many common identities and formulas in algebra, trig, calculus, and laplace transformations. Because who can remember all this stuff?
- [Paul's Online Math Notes](https://tutorial.math.lamar.edu/) - Excellent resources written and used by a professor at Lamar University.
- This video on the [Laplace Transform](https://www.youtube.com/watch?v=n2y7n6jw5d0) by Zach Star.

## Tools

- [Awesome Electronics - Simulators](https://github.com/kitspace/awesome-electronics#analog-and-mixed-signal-circuit-simulators) - This awesome list has a list of useful circuit simulation tools.
- [Curcuit JS](https://www.falstad.com/circuit/circuitjs.html) - A cool little circuit simulation tool.
- [Desmos](https://www.desmos.com/calculator) - Free online graphing calculator.
- [GNU Octave](https://www.gnu.org/software/octave/index) - An open-source alternative to MATLAB. There is also an [online version of GNU Octave](https://octave-online.net/) available.
  - [Signal package](https://octave.sourceforge.io/signal/index.html) - Signal processing tools for GNU Octave, including filtering, windowing and display functions.
- [IIR Filter Explorer](http://jaggedplanet.com/iir/iir-explorer.asp) - A neat little interactive tool for designing basic Infinite Impulse Response digital filters.
- [Jupyter](https://jupyter.org/) - A popular web-based environment for interactive scientific computing and data analysis, with support for a large number of programming languages.
- [Qalculate!](https://qalculate.github.io/) - The ultimate desktop calculator.
- [Russell](https://github.com/cpmech/russell) - A collection of tools that assist in the development of scientific computations (and by extension audio DSP). It includes numerical methods and solvers for differential equations, tools for statistical analysis, and other linear algebra tools. It is written in the Rust programming language.
- [Symbolab](https://www.symbolab.com/) - Another helpful math partner.
- [Wolfram Alpha](https://www.wolframalpha.com/) - A helpful math partner.
