# Machine Learning

Machine learning has been gaining traction in the audio industry lately. I don't know much about the topic myself, but I'll link some potentially useful resources here if you're interested.

- [3Blue1Brown - Neural Networks](https://youtube.com/playlist?list=PLZHQObOWTQDNU6R1_67000Dx_ZCJB-3pi) - An excellent short series of YouTube videos explaining the basics of how machine learning actually works.
- [audioFlux](https://github.com/libAudioFlux/audioFlux) -  A deep learning tool library for audio and music analysis.
- [Deep Learning for Audio](https://github.com/markovka17/dla) - A course that teaches how to use deep learning for audio processing.
- [nnAudio](https://github.com/KinWaiCheuk/nnAudio) - An audio processing toolbox using the PyTorch convolutional neural network backend.
- [RTNeural](https://github.com/jatinchowdhury18/RTNeural) - A fast neural inferencing library in C++ made specifically for audio plugins. Used by the [Chowdhury DSP] suite of plugins.
- [SmartCore](https://smartcorelib.org/) - An advanced and comprehensive machine learning library written in the Rust programming language.

## Open Source Projects

Some open source projects that make use of machine learning for audio.

- [AIDA-X](https://github.com/AidaDSP/AIDA-X) - An amp model player that can load AI-trained models of music gear.
- [Chowdhury DSP] - A suite of open source audio plugins. Many of them make use of machine learning.
- [DeepFilterNet](https://github.com/Rikorose/DeepFilterNet) - A low complexity speech enhancement/noise suppression framework.
- [GuitarML](https://github.com/GuitarML) | (C++, [JUCE]) | - A collection of electric guitar effects that use neural network models to emulate real-world hardware.
- [NeuralNote](https://github.com/DamRsn/NeuralNote) - A state-of-the-art plugin that uses machine learning to convert audio to MIDI.
- [RNNoise](https://github.com/xiph/rnnoise) - A noise suppression library based on a recurrent neural network.
- [Ultimate Vocal Remover](https://github.com/Anjok07/ultimatevocalremovergui) - A state-of-the-art program that uses machine learning to separate vocals from a mix.

[Chowdhury DSP]: https://github.com/Chowdhury-DSP
