# Graphic Design and UX

A list of resources to aid in the design of plugin GUIs.

> Note, I highly recommend not worrying at all about GUI when learning DSP or when experimenting with a new plugin idea. It's better to just focus purely on the DSP with GUI-less plugins until it is ready. The last thing you want is to spend a lot of time on the GUI and then find out that the parameters need to be changed or that the DSP doesn't even work out altogether.

# Graphic Design Software

- [Affinity Designer](https://affinity.serif.com/en-us/designer/)/[Affinity Photo](https://affinity.serif.com/en-us/photo/) - Powerful illustration and image editing software. Not free, but is way better priced than Adobe software.
- [Blender](https://www.blender.org/) - Can be used to make fancy 3D rendered assets.
- [Boxy SVG](https://boxy-svg.com/) - An easy to use open source vector graphics editor.
- [Figma](https://www.figma.com/) - Powerful tool to design UI/UX.
- [FontForge](https://fontforge.org/en-US/) - An open source tool that can be used to pack vector icons into a font file.
- [Glyphr Studio](https://www.glyphrstudio.com/) - Another open source tool that can be used to pack vector icons into a font file.
- [Inkscape](https://inkscape.org/) - Popular open source vector graphics editor.
    - [Logos By Nick](https://www.youtube.com/@LogosByNick) - A YouTube channel with great tutorials on how to use Inkscape and GIMP.
- [Krita](https://krita.org/en/) - Open source painting program and image editor. I personally prefer this as my general purpose image editor over [GIMP](https://www.gimp.org/), although GIMP is still a good choice if you take the time to learn it and install extensions.
- [Penpot](https://penpot.app/) - An open source alternative to Figma.

> Be on the lookout for [Graphite](https://graphite.rs/), which aims to be a powerful open source raster and vector graphics editor. It's still in alpha at the time of this writing.

# Free Scalable Icon Packs

Be sure to follow the licensing agreement before using them.

- [Awesome Icons](https://github.com/notlmn/awesome-icons) - A large list of even more free icon packs.
- [Eva Icons](https://github.com/akveo/eva-icons)
- [Fontaudio](https://github.com/fefanto/fontaudio) - Icon toolkit specifically designed for audio software.
- [Heroicons](https://github.com/tailwindlabs/heroicons)
- [Iconoir](https://github.com/iconoir-icons/iconoir)
- [Lucide](https://github.com/lucide-icons/lucide)
- [Material Icon Library](https://github.com/code-mc/material-icon-lib)
- [Octicons](https://github.com/primer/octicons)

# UX Design

Learn what makes a user interface a good user interface.

- [Awesome UX](https://github.com/batoreh/awesome-ux) - Large list of resources to help you get started learning UI/UX design.

My tip: Probably the biggest challenge when it comes to good UX for audio plugins and audio software is "too much visual noise" / "choice paralysis". Audio software tends to come with a *lot* of parameters and controls. The trick is to make the most important parameters that users will typically reach for first the most immediately apparent to the eye (as in what the eye is naturally drawn to first), and then have the more advanced controls be less immediately apparent (maybe even hidden behind a tab as long as that doesn't disrupt the user's workflow). There is a whole art to guiding user's eyes, and it is usually done by separating and differentiating sections with color brightness, size, and/or empty space. (Note that I said color *brightness*. Brightness is much more important than hue. The UI should still be easily readable when converted to grayscale.)

# Color Tools

- [Accessible Color Generator](https://www.learnui.design/tools/accessible-color-generator.html) - A tool that helps you improve the contrast between two colors.
- [Color Designer](https://colordesigner.io/) - A collection of free color tools that run in your browser.
- [Colormind](http://colormind.io/) - Free AI-powered color palette generator.
- [ColorSpace](https://mycolor.space/) - Another great free color palette generator.
- [Data Color Picker](https://www.learnui.design/tools/data-color-picker.html) - A tool for generating visually equidistant colors for data visualization.
- [Leonardo](https://leonardocolor.io/) - A free and open source tool developed by Adobe that aids in generating color palettes which meet the [WCAG minimum contrast standards](https://www.w3.org/TR/WCAG21/#contrast-minimum). It can also aid in creating colorblind-safe color palettes.
- [Reasonable Colors](https://reasonable.work/colors/) - A free collection of hand-tuned color palettes that are optimized for UI.
