# Free Online Textbooks & Courses

A list of free online textbooks and courses on audio DSP.

- [Discrete Time Signal Processing](https://www.youtube.com/playlist?list=PLm_MSClsnwm9SyEkHLnkWnZrC9ZhYwchJ) by Ekeeda
  - A large collection of free DSP video lectures.
- [Julius Orion Smith III Collection](https://ccrma.stanford.edu/~jos/)
  - A great collection of books and resources by Julius Orion Smith III.
  - Very comprehensive, and covers many topics on the mathematics and applications of audio DSP. Good for getting a solid foundation.
  - Contains code examples in C and MatLab (although [GNU Octave](https://www.gnu.org/software/octave/index) can be used as well).
  - Relatively heavy on mathematics.
- [MIT OCW: Signals and Systems](https://ocw.mit.edu/courses/6-003-signals-and-systems-fall-2011/) by Prof. Dennis Freeman 
  - A free online college level course including pre-recorded video lectures, lecture notes, and assignments.
  - Here is a link to the [video lectures on Youtube](https://www.youtube.com/playlist?list=PLUl4u3cNGP61kdPAOC7CzFjJZ8f1eMUxs) if you can't get the videos to play on their website.
- [projet μ](https://mu.krj.st/) by Yü Fang
  - A great free online course that teaches the basics of DSP from scratch using the C programming language. It's my personal go-to recommendation to beginners.
  - Does a great job of explaining concepts in code, along with helpful graphics.
  - Requires some knowledge of complex numbers and basic integral calculus. (There's really no way around this if you're learning DSP). It is also very Linux-focused, but the course can still be done using Windows or MacOS.
- [The Art of VA Filter Design](https://www.native-instruments.com/fileadmin/ni_media/downloads/pdf/VAFilterDesign_2.1.2.pdf) by Vadim Zavalishin
  - Teaches good techniques for adapting analogue designs into the digital realm.
  - Relatively heavy on mathematics.
- [The Scientist and Engineer's Guide to Digital Signal Processing](http://www.dspguide.com/pdfbook.htm) by Steven W. Smith, Ph.D.
  - A common recommendation from many folks.
  - Focuses on DSP in general, not just audio DSP.
  - Relatively heavy on mathematics.
- [The Theory and Technique of Electronic Music](http://msp.ucsd.edu/techniques.htm) by Miller Puckette
  - Focuses more on musical DSP.
  - Teaches core concepts of many common audio effects and synthesizers.
  - Relatively heavy on mathematics.
- [Think DSP](https://github.com/AllenDowney/ThinkDSP) by Allen B. Downey
  - A great free online book for beginners that teaches many fundamental DSP concepts using Python.
  - Teaches concepts from a programming-based approach, rather than an abstract mathematical approach.
  - Requires knowledge of Python, and some knowledge of complex numbers and integral calculus.
