# Electronics & Embedded

Resources for developing audio stuff with analog hardware and embedded microcontrollers.

- [Awesome Electronics](https://github.com/kitspace/awesome-electronics) - An excellent and detailed list of resources for electronics engineering, focused on low-power DC circuits.
- [C++ Real-Time Audio Programming with Bela](https://www.youtube.com/playlist?list=PLCrgFeG6pwQmdbB6l3ehC8oBBZbatVoz3) - A video series on realtime audio programming for the Bela microcontroller.
- [Embassy](https://github.com/embassy-rs/embassy) - A next-generation framework for writing embedded applications in Rust.
- [Guitar Effects Processor](https://github.com/Quinny/GuitarEffects) - A low latency guitar effects processor suitable for running on smaller boards (e.g. a raspberry pi).
- [MiniDexed](https://github.com/probonopd/MiniDexed) - A port of the [Dexed](https://github.com/asb2m10/dexed) synthesizer that can run on a bare-metal Raspberry Pi.
- [signalo](https://github.com/signalo/signalo) - A Rust DSP toolbox with focus on embedded environments.
- [sourcebox's repositories](https://github.com/sourcebox?tab=repositories) - Various repositories of tools and libraries for embedded audio applications, written in Rust.
- [Stompbox](https://github.com/mikeoliphant/stompbox) - A guitar amplification and effects library for both desktop and embedded devices.
- [The Embedded Rust Book](https://docs.rust-embedded.org/book/) - A free online book on using Rust on embedded hardware.
