# DSP Cookbooks

A list of algorithms and equations you can use and reference for your own DSP designs.

- [Audio EQ Cookbook](https://webaudio.github.io/Audio-EQ-Cookbook/audio-eq-cookbook.html) (aka RBJ Cookbook) - A collection of equations for calculating biquad filter coefficients.
- [Cytomic Technical Papers](https://cytomic.com/technical-papers/) - Excellent filter designs, equations, and explanations by Cytomic. Use these as a better alternative to biquad filters that both sound better and perform better when being modulated.
  - Specifically the document [SvfLinearTrapOptimised2](https://cytomic.com/files/dsp/SvfLinearTrapOptimised2.pdf) contains filters and equations that are a better alternative to the ones in the RBJ Cookbook.
- [deip.pdf](https://github.com/BillyDM/Audio-DSP-Resources/blob/main/deip.pdf) - A collection of high quality and fast sub-sample interpolators.
- [Fast-DSP-Approximations](https://github.com/BillyDM/Fast-DSP-Approximations) - My own list of public-domain fast approximations of various expensive calculations.
- [Musicdsp.org](https://www.musicdsp.org/en/latest/index.html) - A large collection of open source DSP algorithms by the community.
