# Awesome Audio DSP

My curated list of audio DSP (digital signal processing) and plugin development resources. New resources may be added in the future. Feel free to open a PR if you wish!

- [Code Libraries](sections/CODE_LIBRARIES.md) - A list of useful libraries for audio software.
- [DSP Cookbooks](sections/DSP_COOKBOOKS.md) - A list of algorithms and equations you can use and reference for your own DSP designs.
- [DSP Playgrounds](sections/DSP_PLAYGROUNDS.md) - Software tools that are useful for quickly and easily prototyping DSP.
- [Electronics & Embedded](sections/ELECTRONICS_AND_EMBEDDED.md) - Resources for developing analog and embedded hardware systems.
- [Forums](sections/FORUMS.md) - A list of audio-development-related forums you can join.
- [Free Online Textbooks & Courses](sections/FREE_ONLINE_TEXTBOOKS_AND_COURSES.md) - A list of free online textbooks and courses on audio DSP.
- [Graphic Design and UX](sections/GRAPHIC_DESIGN_AND_UX.md) - A list of resources to aid in the design of plugin GUIs.
- [Machine Learning](sections/MACHINE_LEARNING.md) - Resources on using this powerful emerging technology for audio DSP.
- [Mathematics](sections/MATHEMATICS.md) - Learning resources and tools for the mathematics of audio DSP.
- [More Lists](sections/MORE_LISTS.md) - Here I'll link curated lists of resources that others have made.
- [Open Source Plugins & Software](sections/OPEN_SOURCE_PLUGINS_AND_SOFTWARE.md) - A list of open source audio software that you can inspect and learn from.
- [Paid Textbooks](sections/PAID_TEXTBOOKS.md) - A list of non-free textbooks on audio DSP.
- [Plugin APIs](sections/PLUGIN_APIS.md) - A list of audio plugin APIs/specs along with their pros and cons.
- [Plugin Development Frameworks](sections/PLUGIN_DEVELOPMENT_FRAMEWORKS.md) - A list of software stacks/frameworks used to make audio plugins with/without GUIs, along with their pros and cons.
- [Programming Languages](sections/PROGRAMMING_LANGUAGES.md) - A list of programming languages used to make audio software, along with their pros and cons.
- [Software Optimization](sections/SOFTWARE_OPTIMIZATION.md) - Tips and tools for optimizing audio software.
    - [Audio Software Optimization Tips](content/AUDIO_SOFTWARE_OPTIMIZATION_TIPS.md) - My own list of audio software optimization tips.
- [Sound Design & Music Production](sections/SOUND_DESIGN_AND_MUSIC_PRODUCTION.md) - While this is not *strictly* development related, knowing how plugins are actually used to make and edit sound can give valuable insight.
- [System Tools](sections/SYSTEM_TOOLS.md) - A list of system tools useful in developing audio plugins and software.
- [Technical Reading](sections/TECHNICAL_READING.md) - A list of useful articles, blogs, and scientific papers on algorithms and techniques for audio DSP.

<hr/>

### *"If I'm a total noob, where should I start?"*

- [Designing Software Synthesizer Plug-Ins in C++](https://www.amazon.com/Designing-Software-Synthesizer-Plug-Ins-Audio/dp/0367510480) and [Designing Audio Effect Plugins in C++](https://www.amazon.com/Designing-Audio-Effect-Plugins-C/dp/1138591939) by Will Pirkle
    - These textbooks are a common recommendation for beginners.
    - The synthesizer one is better than the effect one imo, so go for that if you plan on only buying one.
    - ISBN-10: 0367510480 and 1138591939, ISBN-13: 978-0367510480 and 978-1138591936
- [projet μ](https://mu.krj.st/) by Yü Fang
  - A great free online course that teaches the basics of DSP from scratch using the C programming language. It's my personal go-to recommendation to beginners.
  - Does a great job of explaining concepts in code, along with helpful graphics.
  - Requires some knowledge of complex numbers and basic integral calculus. (There's really no way around this if you're learning DSP). It is also very Linux-focused, but the course can still be done using Windows or MacOS.
- [Think DSP](https://github.com/AllenDowney/ThinkDSP) - A great free online book that teaches many fundamental DSP concepts using Python.

> I often get asked about beginner-friendly DSP learning resources which focus on the [Rust](https://www.rust-lang.org/) programming language. Unfortunately there isn't really anything out there. I would suggest learning DSP in another language first and then translating that knowledge to Rust later. The choice of language doesn't really matter that much for learning DSP, the main difference comes when it's time to create full applications/plugins *around* your DSP code.