package testhelper

import (
	"github.com/bearer/bearer/pkg/commands/process/settings"
	"github.com/bearer/bearer/pkg/util/regex"
)

// new rules are added
func CustomRule() *settings.Rule {
	return &settings.Rule{
		Id:          "custom_test_rule",
		Description: "Its a test!",
		CWEIDs:      []string{},
		Type:        "risk",
		Languages:   []string{"ruby"},
		Severity:    "low",
		IsLocal:     false,
	}
}

func RubyLangSSLVerificationRule() *settings.Rule {
	return &settings.Rule{Id: "ruby_lang_ssl_verification", AssociatedRecipe: "", Type: "risk", Trigger: settings.RuleTrigger{MatchOn: "presence", DataTypesRequired: false}, IsLocal: false, Detectors: []string(nil), Processors: []string(nil), Stored: false, AutoEncrytPrefix: "", HasDetailedContext: false, SkipDataTypes: []string(nil), OnlyDataTypes: []string(nil), Severity: "medium", Description: "Missing SSL certificate verification detected.", RemediationMessage: "## Description\n\nApplications processing sensitive data should use valid SSL certificates. This rule checks if SSL verification is enabled.\n\n## Remediations\n\n❌ By default Ruby check for SSL certificate verification but this can be bypassed when setting Open SSL verification mode to `VERIFY_NONE`:\n\n```clojure\nrequire \"net/https\"\nrequire \"uri\"\n\nuri = URI.parse(\"https://ssl-site.com/\")\nhttp = Net::HTTP.new(uri.host, uri.port)\nhttp.use_ssl = true\nhttp.verify_mode = OpenSSL::SSL::VERIFY_NONE\n```\n\n✅ To ensure that SSL verification always happens, make sure to use the following mode:\n\n```bash\nhttp.verify_mode = OpenSSL::SSL::VERIFY_PEER\n```\n\n## Resources\n- [Ruby OpenSSL module](https://ruby.github.io/openssl/OpenSSL.html)\n", CWEIDs: []string{"295"}, Languages: []string{"ruby"}, Patterns: []settings.RulePattern{settings.RulePattern{Pattern: "Net::HTTP.start(verify_mode: OpenSSL::SSL::VERIFY_NONE)$<...>\n", Focus: "", Filters: []settings.PatternFilter(nil)}, settings.RulePattern{Pattern: "Net::HTTP.start($<...>{ verify_mode: OpenSSL::SSL::VERIFY_NONE })$<...>\n", Focus: "", Filters: []settings.PatternFilter(nil)}, settings.RulePattern{Pattern: "$<_>.verify_mode = OpenSSL::SSL::VERIFY_NONE\n", Focus: "", Filters: []settings.PatternFilter(nil)}}, SanitizerRuleID: "", DocumentationUrl: "https://docs.bearer.com/reference/rules/ruby_lang_ssl_verification", IsAuxilary: false, DependencyCheck: false, Dependency: (*settings.Dependency)(nil), Metavars: map[string]settings.MetaVar(nil), ParamParenting: false, DetectPresence: false, OmitParent: false}
}

func RubyRailsLoggerRule() *settings.Rule {
	return &settings.Rule{Id: "ruby_rails_logger", AssociatedRecipe: "", Type: "risk", Trigger: settings.RuleTrigger{MatchOn: "presence", DataTypesRequired: false}, IsLocal: true, Detectors: []string(nil), Processors: []string(nil), Stored: false, AutoEncrytPrefix: "", HasDetailedContext: false, SkipDataTypes: []string{"Unique Identifier"}, OnlyDataTypes: []string(nil), Severity: "critical", Description: "Sensitive data sent to Rails loggers detected.", RemediationMessage: "## Description\nLeaking sensitive data to loggers is a common cause of data leaks and can lead to data breaches. This rule looks for instances of sensitive data sent to rails loggers.\n\n## Remediations\n❌ Avoid using sensitive data in logger messages:\n\n```ruby\nRails.logger.info('User is: #{user.email}')\n```\n\n✅ If you need to identify a user, ensure to use their unique identifier instead of their personal identifiable information:\n\n```ruby\nRails.logger.info('User is: #{user.uuid}')\n```\n\n## Resources\n- [OWASP logging cheat sheet](https://cheatsheetseries.owasp.org/cheatsheets/Logging_Cheat_Sheet.html)\n", CWEIDs: []string{"209", "532"}, Languages: []string{"ruby"}, Patterns: []settings.RulePattern{settings.RulePattern{Pattern: "Rails.logger.$<METHOD>($<DATA_TYPE>)\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}, settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "METHOD", Detection: "", Scope: "", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string{"info", "warn", "error", "fatal", "unknown"}, LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}}, SanitizerRuleID: "", DocumentationUrl: "https://docs.bearer.com/reference/rules/ruby_rails_logger", IsAuxilary: false, DependencyCheck: false, Dependency: (*settings.Dependency)(nil), Metavars: map[string]settings.MetaVar(nil), ParamParenting: false, DetectPresence: false, OmitParent: false}
}

func RubyThirdPartiesSentryRule() *settings.Rule {
	return &settings.Rule{Id: "ruby_third_parties_sentry", AssociatedRecipe: "Sentry", Type: "risk", Trigger: settings.RuleTrigger{MatchOn: "presence", DataTypesRequired: false}, IsLocal: true, Detectors: []string(nil), Processors: []string(nil), Stored: false, AutoEncrytPrefix: "", HasDetailedContext: false, SkipDataTypes: []string{"Unique Identifier"}, OnlyDataTypes: []string(nil), Severity: "Critical", Description: "Sensitive data sent to Sentry detected.", RemediationMessage: "## Description\nLeaking sensitive data to third-party loggers is a common cause of data leaks and can lead to data breaches. This rule looks for instances of sensitive data sent to Sentry.\n\n## Remediations\n\nWhen logging errors or events, ensure all sensitive data is removed.\n\n## Resources\n- [Sentry Docs](https://docs.sentry.io/)\n", CWEIDs: []string{"201"}, Languages: []string{"ruby"}, Patterns: []settings.RulePattern{settings.RulePattern{Pattern: "Sentry::Breadcrumb.new($<...>$<DATA_TYPE>$<...>)\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.capture_message($<...>$<DATA_TYPE>$<...>)\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.init do |$<CONFIG:identifier>|\n  $<CONFIG>.before_breadcrumb = lambda do |$<BREADCRUMB:identifier>, $<_:identifier>|\n    $<!>$<BREADCRUMB>.message = $<DATA_TYPE>\n  end\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.set_context($<_>, $<...>$<DATA_TYPE>$<...>)\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.configure_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_context($<_>, $<...>$<DATA_TYPE>$<...>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.with_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_context($<_>, $<...>$<DATA_TYPE>$<...>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.configure_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_extra($<_>, $<DATA_TYPE>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.with_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_extra($<_>, $<DATA_TYPE>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.set_extras($<...>$<DATA_TYPE>$<...>)\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.configure_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_extras($<...>$<DATA_TYPE>$<...>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.with_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_extras($<...>$<DATA_TYPE>$<...>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.configure_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_tag($<_>, $<DATA_TYPE>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.with_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_tag($<_>, $<DATA_TYPE>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.set_tags($<...>$<DATA_TYPE>$<...>)\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.configure_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_tags($<...>$<DATA_TYPE>$<...>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.with_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_tags($<...>$<DATA_TYPE>$<...>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.set_user($<...>$<DATA_TYPE>$<...>)\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.configure_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_user($<...>$<DATA_TYPE>$<...>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}, settings.RulePattern{Pattern: "Sentry.with_scope do |$<SCOPE:identifier>|\n  $<!>$<SCOPE>.set_user($<...>$<DATA_TYPE>$<...>)\nend\n", Focus: "", Filters: []settings.PatternFilter{settings.PatternFilter{Not: (*settings.PatternFilter)(nil), Either: []settings.PatternFilter(nil), Variable: "DATA_TYPE", Detection: "datatype", Scope: "result", Filters: []settings.PatternFilter(nil), Contains: (*bool)(nil), Regex: (*regex.SerializableRegexp)(nil), Values: []string(nil), LengthLessThan: (*int)(nil), LessThan: (*int)(nil), LessThanOrEqual: (*int)(nil), GreaterThan: (*int)(nil), GreaterThanOrEqual: (*int)(nil), StringRegex: (*regex.SerializableRegexp)(nil), FilenameRegex: (*regex.SerializableRegexp)(nil)}}}}, SanitizerRuleID: "", DocumentationUrl: "https://docs.bearer.com/reference/rules/ruby_third_parties_sentry", IsAuxilary: false, DependencyCheck: false, Dependency: (*settings.Dependency)(nil), Metavars: map[string]settings.MetaVar(nil), ParamParenting: false, DetectPresence: false, OmitParent: false}
}
