#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 19852
#define LARGE_STATE_COUNT 4737
#define SYMBOL_COUNT 513
#define ALIAS_COUNT 38
#define TOKEN_COUNT 288
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 31
#define MAX_ALIAS_SEQUENCE_LENGTH 21
#define PRODUCTION_ID_COUNT 243

enum {
  anon_sym_SEMI = 1,
  aux_sym_with_clause_token1 = 2,
  aux_sym_with_clause_token2 = 3,
  anon_sym_COMMA = 4,
  aux_sym_cte_token1 = 5,
  aux_sym_cte_token2 = 6,
  aux_sym_cte_token3 = 7,
  anon_sym_LPAREN = 8,
  anon_sym_RPAREN = 9,
  aux_sym_truncate_statement_token1 = 10,
  aux_sym_truncate_statement_token2 = 11,
  aux_sym_truncate_statement_token3 = 12,
  aux_sym_comment_statement_token1 = 13,
  aux_sym_comment_statement_token2 = 14,
  aux_sym_comment_statement_token3 = 15,
  aux_sym_comment_statement_token4 = 16,
  aux_sym_comment_statement_token5 = 17,
  aux_sym_comment_statement_token6 = 18,
  aux_sym_comment_statement_token7 = 19,
  aux_sym_begin_statement_token1 = 20,
  aux_sym_begin_statement_token2 = 21,
  aux_sym_begin_statement_token3 = 22,
  aux_sym_commit_statement_token1 = 23,
  aux_sym_rollback_statement_token1 = 24,
  aux_sym_create_statement_token1 = 25,
  aux_sym_create_statement_token2 = 26,
  aux_sym_create_statement_token3 = 27,
  aux_sym_alter_statement_token1 = 28,
  aux_sym_alter_table_token1 = 29,
  aux_sym_alter_table_token2 = 30,
  aux_sym_alter_schema_rename_action_token1 = 31,
  aux_sym_alter_schema_rename_action_token2 = 32,
  aux_sym_alter_owner_action_token1 = 33,
  anon_sym_CURRENT_USER = 34,
  anon_sym_CURRENT_ROLE = 35,
  anon_sym_SESSION_USER = 36,
  aux_sym_alter_table_action_alter_column_token1 = 37,
  aux_sym_alter_table_action_alter_column_token2 = 38,
  aux_sym_alter_table_action_add_token1 = 39,
  aux_sym_sequence_token1 = 40,
  aux_sym_sequence_token2 = 41,
  aux_sym_sequence_token3 = 42,
  aux_sym_sequence_token4 = 43,
  aux_sym_sequence_token5 = 44,
  aux_sym_sequence_token6 = 45,
  aux_sym_sequence_token7 = 46,
  aux_sym_sequence_token8 = 47,
  aux_sym_sequence_token9 = 48,
  aux_sym_pg_command_token1 = 49,
  aux_sym_pg_command_token2 = 50,
  anon_sym_COLON = 51,
  aux_sym__compound_statement_token1 = 52,
  aux_sym__compound_statement_token2 = 53,
  aux_sym_return_statement_token1 = 54,
  aux_sym_declare_statement_token1 = 55,
  aux_sym_create_function_statement_token1 = 56,
  aux_sym_create_function_statement_token2 = 57,
  aux_sym_create_function_statement_token3 = 58,
  aux_sym_create_function_statement_token4 = 59,
  aux_sym_create_function_statement_token5 = 60,
  aux_sym_create_function_statement_token6 = 61,
  aux_sym_create_function_statement_token7 = 62,
  aux_sym_create_function_statement_token8 = 63,
  aux_sym_create_function_statement_token9 = 64,
  aux_sym_create_function_statement_token10 = 65,
  aux_sym_create_function_statement_token11 = 66,
  aux_sym_external_hint_token1 = 67,
  aux_sym_external_hint_token2 = 68,
  aux_sym_external_hint_token3 = 69,
  aux_sym_external_hint_token4 = 70,
  aux_sym_optimizer_hint_token1 = 71,
  aux_sym_optimizer_hint_token2 = 72,
  aux_sym_optimizer_hint_token3 = 73,
  aux_sym_parallel_hint_token1 = 74,
  aux_sym_parallel_hint_token2 = 75,
  aux_sym_parallel_hint_token3 = 76,
  aux_sym_parallel_hint_token4 = 77,
  aux_sym_null_hint_token1 = 78,
  aux_sym_null_hint_token2 = 79,
  aux_sym_null_hint_token3 = 80,
  aux_sym_null_hint_token4 = 81,
  aux_sym_deterministic_hint_token1 = 82,
  aux_sym_sql_hint_token1 = 83,
  aux_sym_sql_hint_token2 = 84,
  aux_sym_sql_hint_token3 = 85,
  aux_sym_sql_hint_token4 = 86,
  aux_sym_sql_hint_token5 = 87,
  aux_sym__function_language_token1 = 88,
  aux_sym__function_language_token2 = 89,
  aux_sym__function_language_token3 = 90,
  aux_sym_setof_token1 = 91,
  aux_sym_create_function_parameter_token1 = 92,
  aux_sym_create_function_parameter_token2 = 93,
  aux_sym_create_function_parameter_token3 = 94,
  aux_sym_create_function_parameter_token4 = 95,
  anon_sym_EQ = 96,
  aux_sym_create_trigger_statement_token1 = 97,
  aux_sym_create_trigger_statement_token2 = 98,
  aux_sym_create_trigger_statement_token3 = 99,
  aux_sym_create_trigger_statement_token4 = 100,
  aux_sym_create_trigger_statement_token5 = 101,
  aux_sym_create_trigger_statement_token6 = 102,
  aux_sym_create_trigger_statement_token7 = 103,
  aux_sym_trigger_reference_token1 = 104,
  aux_sym_trigger_preferencing_token1 = 105,
  aux_sym_trigger_preferencing_token2 = 106,
  aux_sym_trigger_preferencing_token3 = 107,
  aux_sym_trigger_time_token1 = 108,
  aux_sym_trigger_time_token2 = 109,
  aux_sym_trigger_time_token3 = 110,
  aux_sym_trigger_time_token4 = 111,
  aux_sym_trigger_event_token1 = 112,
  aux_sym_trigger_event_token2 = 113,
  aux_sym_trigger_event_token3 = 114,
  aux_sym_trigger_condition_token1 = 115,
  aux_sym_trigger_order_token1 = 116,
  aux_sym_trigger_order_token2 = 117,
  aux_sym_trigger_body_token1 = 118,
  aux_sym_create_extension_statement_token1 = 119,
  aux_sym_create_extension_statement_token2 = 120,
  aux_sym_create_role_statement_token1 = 121,
  aux_sym_drop_statement_token1 = 122,
  aux_sym_drop_statement_token2 = 123,
  aux_sym_drop_statement_token3 = 124,
  aux_sym_drop_statement_token4 = 125,
  aux_sym_drop_statement_token5 = 126,
  aux_sym_drop_statement_token6 = 127,
  aux_sym_set_statement_token1 = 128,
  aux_sym_set_statement_token2 = 129,
  aux_sym_grant_statement_token1 = 130,
  aux_sym_grant_statement_token2 = 131,
  aux_sym_grant_statement_token3 = 132,
  aux_sym_grant_statement_token4 = 133,
  aux_sym_grant_statement_token5 = 134,
  aux_sym_grant_statement_token6 = 135,
  aux_sym_grant_statement_token7 = 136,
  aux_sym_grant_statement_token8 = 137,
  aux_sym_grant_statement_token9 = 138,
  aux_sym_grant_statement_token10 = 139,
  aux_sym_create_domain_statement_token1 = 140,
  aux_sym_type_spec_enum_token1 = 141,
  aux_sym_type_spec_range_token1 = 142,
  aux_sym_type_spec_range_token2 = 143,
  aux_sym_type_spec_range_token3 = 144,
  aux_sym_type_spec_range_token4 = 145,
  aux_sym_type_spec_range_token5 = 146,
  aux_sym_type_spec_range_token6 = 147,
  aux_sym_type_spec_range_token7 = 148,
  aux_sym_type_spec_base_token1 = 149,
  aux_sym_type_spec_base_token2 = 150,
  aux_sym_type_spec_base_token3 = 151,
  aux_sym_type_spec_base_token4 = 152,
  aux_sym_type_spec_base_token5 = 153,
  aux_sym_type_spec_base_token6 = 154,
  aux_sym_type_spec_base_token7 = 155,
  aux_sym_type_spec_base_token8 = 156,
  aux_sym_type_spec_base_token9 = 157,
  aux_sym_type_spec_base_token10 = 158,
  aux_sym_type_spec_base_token11 = 159,
  aux_sym_type_spec_base_token12 = 160,
  aux_sym_type_spec_base_token13 = 161,
  aux_sym_type_spec_base_token14 = 162,
  aux_sym_type_spec_base_token15 = 163,
  aux_sym_type_spec_base_token16 = 164,
  aux_sym_type_spec_base_token17 = 165,
  aux_sym_type_spec_base_token18 = 166,
  aux_sym_create_index_include_clause_token1 = 167,
  aux_sym_auto_increment_constraint_token1 = 168,
  aux_sym_direction_constraint_token1 = 169,
  aux_sym_direction_constraint_token2 = 170,
  anon_sym_CONSTRAINT = 171,
  aux_sym_mode_token1 = 172,
  aux_sym_initial_mode_token1 = 173,
  aux_sym_initial_mode_token2 = 174,
  aux_sym_initial_mode_token3 = 175,
  aux_sym_table_constraint_check_token1 = 176,
  aux_sym_table_constraint_exclude_token1 = 177,
  aux_sym_table_constraint_exclude_token2 = 178,
  aux_sym_table_constraint_foreign_key_token1 = 179,
  aux_sym_table_constraint_foreign_key_token2 = 180,
  aux_sym_table_constraint_unique_token1 = 181,
  aux_sym_table_constraint_primary_key_token1 = 182,
  aux_sym_create_table_statement_token1 = 183,
  aux_sym_create_table_statement_token2 = 184,
  aux_sym_view_check_option_token1 = 185,
  aux_sym_having_clause_token1 = 186,
  aux_sym_grouping_sets_clause_token1 = 187,
  aux_sym_grouping_sets_clause_token2 = 188,
  aux_sym_rollup_clause_token1 = 189,
  aux_sym_cube_clause_token1 = 190,
  aux_sym_order_expression_token1 = 191,
  aux_sym_order_expression_token2 = 192,
  aux_sym_order_expression_token3 = 193,
  aux_sym_order_by_clause_token1 = 194,
  aux_sym_limit_clause_token1 = 195,
  aux_sym_offset_clause_token1 = 196,
  aux_sym_fetch_clause_token1 = 197,
  aux_sym_fetch_clause_token2 = 198,
  aux_sym_where_clause_token1 = 199,
  aux_sym_select_clause_body_token1 = 200,
  aux_sym_tablesample_clause_token1 = 201,
  aux_sym_repeatable_clause_token1 = 202,
  aux_sym_rows_from_expression_token1 = 203,
  aux_sym_join_clause_token1 = 204,
  aux_sym_join_clause_token2 = 205,
  aux_sym_join_type_token1 = 206,
  aux_sym_join_type_token2 = 207,
  aux_sym_join_type_token3 = 208,
  aux_sym_join_type_token4 = 209,
  aux_sym_join_type_token5 = 210,
  aux_sym_values_clause_token1 = 211,
  aux_sym_conditional_expression_token1 = 212,
  aux_sym_conditional_expression_token2 = 213,
  aux_sym_conditional_expression_token3 = 214,
  aux_sym__function_call_arguments_token1 = 215,
  aux_sym_within_group_clause_token1 = 216,
  aux_sym_filter_clause_token1 = 217,
  aux_sym_over_clause_token1 = 218,
  aux_sym_partition_by_clause_token1 = 219,
  aux_sym_frame_clause_token1 = 220,
  aux_sym_frame_clause_token2 = 221,
  aux_sym_frame_kind_token1 = 222,
  aux_sym_frame_bound_token1 = 223,
  aux_sym_frame_bound_token2 = 224,
  aux_sym_frame_bound_token3 = 225,
  aux_sym_frame_bound_token4 = 226,
  aux_sym_frame_exclusion_token1 = 227,
  aux_sym_frame_exclusion_token2 = 228,
  aux_sym_with_ordinality_token1 = 229,
  aux_sym_at_time_zone_expression_token1 = 230,
  aux_sym_at_time_zone_expression_token2 = 231,
  aux_sym_at_time_zone_expression_token3 = 232,
  aux_sym_TRUE_token1 = 233,
  aux_sym_FALSE_token1 = 234,
  sym_number = 235,
  sym__unquoted_identifier = 236,
  anon_sym_BQUOTE = 237,
  aux_sym__quoted_identifier_token1 = 238,
  anon_sym_DQUOTE = 239,
  aux_sym__quoted_identifier_token2 = 240,
  anon_sym_DOT = 241,
  anon_sym_SQUOTE = 242,
  aux_sym_string_token1 = 243,
  anon_sym_DASH_GT = 244,
  anon_sym_DASH_GT_GT = 245,
  anon_sym_POUND_GT = 246,
  anon_sym_POUND_GT_GT = 247,
  aux_sym_type_token1 = 248,
  aux_sym_type_token2 = 249,
  anon_sym_LBRACK = 250,
  anon_sym_RBRACK = 251,
  anon_sym_COLON_COLON = 252,
  sym_comment = 253,
  anon_sym_PLUS = 254,
  anon_sym_DASH = 255,
  anon_sym_BANG_BANG = 256,
  anon_sym_TILDE = 257,
  anon_sym_AT = 258,
  anon_sym_PIPE_SLASH = 259,
  anon_sym_PIPE_PIPE_SLASH = 260,
  anon_sym_CARET = 261,
  anon_sym_STAR = 262,
  anon_sym_SLASH = 263,
  anon_sym_PERCENT = 264,
  anon_sym_LT_LT = 265,
  anon_sym_GT_GT = 266,
  anon_sym_AMP = 267,
  anon_sym_PIPE = 268,
  anon_sym_POUND = 269,
  anon_sym_LT = 270,
  anon_sym_LT_EQ = 271,
  anon_sym_LT_GT = 272,
  anon_sym_BANG_EQ = 273,
  anon_sym_GT = 274,
  anon_sym_GT_EQ = 275,
  anon_sym_BANG_TILDE = 276,
  anon_sym_TILDE_STAR = 277,
  anon_sym_BANG_TILDE_STAR = 278,
  anon_sym_AMP_AMP = 279,
  anon_sym_PIPE_PIPE = 280,
  anon_sym_DOT_STAR = 281,
  aux_sym_interval_expression_token1 = 282,
  anon_sym_DOLLAR = 283,
  aux_sym_argument_reference_token1 = 284,
  sym__dollar_quoted_string_tag = 285,
  sym__dollar_quoted_string_content = 286,
  sym__dollar_quoted_string_end_tag = 287,
  sym_source_file = 288,
  sym__statement = 289,
  sym__simple_statement = 290,
  sym_with_clause = 291,
  sym_cte = 292,
  sym_select_statement = 293,
  sym_insert_statement = 294,
  sym_update_statement = 295,
  sym_delete_statement = 296,
  sym_truncate_statement = 297,
  sym_comment_statement = 298,
  sym_begin_statement = 299,
  sym_commit_statement = 300,
  sym_rollback_statement = 301,
  sym_create_statement = 302,
  sym_alter_statement = 303,
  sym_alter_table = 304,
  sym_alter_schema_rename_action = 305,
  sym_alter_owner_action = 306,
  sym_alter_schema = 307,
  sym_alter_table_action_alter_column = 308,
  sym_alter_table_action_add = 309,
  sym_alter_table_action_set = 310,
  sym_alter_table_rename_column = 311,
  sym_alter_table_action = 312,
  sym_sequence = 313,
  sym_pg_command = 314,
  sym__compound_statement = 315,
  sym_return_statement = 316,
  sym_declare_statement = 317,
  sym_create_function_statement = 318,
  sym_external_hint = 319,
  sym_optimizer_hint = 320,
  sym_parallel_hint = 321,
  sym_null_hint = 322,
  sym_deterministic_hint = 323,
  sym_sql_hint = 324,
  sym_sql_security_hint = 325,
  sym__function_language = 326,
  sym__create_function_return_type = 327,
  sym_setof = 328,
  sym_constrained_type = 329,
  sym_create_function_parameter = 330,
  sym_create_function_parameters = 331,
  sym_function_body = 332,
  sym_create_trigger_statement = 333,
  sym_trigger_reference = 334,
  sym_trigger_preferencing = 335,
  sym_trigger_time = 336,
  sym_trigger_event = 337,
  sym_trigger_condition = 338,
  sym_trigger_order = 339,
  sym_trigger_body = 340,
  sym_create_extension_statement = 341,
  sym_create_role_statement = 342,
  sym_create_schema_statement = 343,
  sym_drop_statement = 344,
  sym_set_statement = 345,
  sym_grant_statement = 346,
  sym_create_domain_statement = 347,
  sym_create_type_statement = 348,
  sym_type_spec_composite = 349,
  sym_type_spec_enum = 350,
  sym_type_spec_range = 351,
  sym_type_spec_base = 352,
  sym_create_index_with_clause = 353,
  sym_create_index_include_clause = 354,
  sym_create_index_statement = 355,
  sym_table_column = 356,
  sym_auto_increment_constraint = 357,
  sym_direction_constraint = 358,
  sym_named_constraint = 359,
  sym__column_default_expression = 360,
  sym_default_clause = 361,
  sym_table_parameters = 362,
  sym_mode = 363,
  sym_initial_mode = 364,
  sym__table_constraint = 365,
  sym_table_constraint_check = 366,
  sym_op_class = 367,
  sym_exclude_entry = 368,
  sym_table_constraint_exclude = 369,
  sym_table_constraint_foreign_key = 370,
  sym_table_constraint_unique = 371,
  sym_table_constraint_primary_key = 372,
  sym_primary_key_constraint = 373,
  sym_create_table_statement = 374,
  sym_using_clause = 375,
  sym_index_table_parameters = 376,
  sym_create_view_statement = 377,
  sym_view_columns = 378,
  sym_view_option = 379,
  sym_view_options = 380,
  sym_view_check_option = 381,
  sym_view_body = 382,
  sym_create_materialized_view_statement = 383,
  sym_tablespace_hint = 384,
  sym_data_hint = 385,
  sym__select_statement = 386,
  sym_group_by_clause = 387,
  sym_having_clause = 388,
  sym_group_expression = 389,
  sym_grouping_sets_clause = 390,
  sym_rollup_clause = 391,
  sym_cube_clause = 392,
  sym_expression_list = 393,
  sym_order_expression = 394,
  sym_window_clause = 395,
  sym_order_by_clause = 396,
  sym_limit_clause = 397,
  sym_offset_clause = 398,
  sym_fetch_clause = 399,
  sym_where_clause = 400,
  sym_alias = 401,
  sym__aliased_expression = 402,
  sym_column_names = 403,
  sym_column_definitions = 404,
  sym__aliasable_expression = 405,
  sym_select_clause_body = 406,
  sym_select_clause = 407,
  sym_from_clause = 408,
  sym__from_item = 409,
  sym_tablesample_clause = 410,
  sym_repeatable_clause = 411,
  sym_rows_from_expression = 412,
  sym_join_clause = 413,
  sym_join_type = 414,
  sym_join_condition = 415,
  sym_select_subexpression = 416,
  sym__update_statement = 417,
  sym_set_clause = 418,
  sym_set_clause_body = 419,
  sym_assigment_expression = 420,
  sym__insert_statement = 421,
  sym_values_clause = 422,
  sym_values_clause_item = 423,
  sym__delete_statement = 424,
  sym_conditional_expression = 425,
  sym_in_expression = 426,
  sym_tuple = 427,
  sym_references_constraint = 428,
  sym_on_update_action = 429,
  sym_on_delete_action = 430,
  sym__constraint_action = 431,
  sym_unique_constraint = 432,
  sym_null_constraint = 433,
  sym_check_constraint = 434,
  sym_function_call = 435,
  sym__function_call_arguments = 436,
  sym_within_group_clause = 437,
  sym_filter_clause = 438,
  sym_over_clause = 439,
  sym_window_definition = 440,
  sym_partition_by_clause = 441,
  sym_frame_clause = 442,
  sym_frame_kind = 443,
  sym_frame_bound = 444,
  sym_frame_exclusion = 445,
  sym__parenthesized_expression = 446,
  sym_with_ordinality = 447,
  sym_is_expression = 448,
  sym_distinct_from = 449,
  sym_boolean_expression = 450,
  sym_at_time_zone_expression = 451,
  sym_NULL = 452,
  sym_TRUE = 453,
  sym_FALSE = 454,
  sym__quoted_identifier = 455,
  sym_identifier = 456,
  sym_dotted_name = 457,
  sym__identifier = 458,
  sym_string = 459,
  sym_json_access = 460,
  sym_ordered_expression = 461,
  sym_type = 462,
  sym_array_type = 463,
  sym__type = 464,
  sym_type_cast = 465,
  sym_array_element_access = 466,
  sym_unary_expression = 467,
  sym_binary_expression = 468,
  sym_binary_operator = 469,
  sym_asterisk_expression = 470,
  sym_interval_expression = 471,
  sym_argument_reference = 472,
  sym__expression = 473,
  aux_sym_source_file_repeat1 = 474,
  aux_sym_with_clause_repeat1 = 475,
  aux_sym_truncate_statement_repeat1 = 476,
  aux_sym_sequence_repeat1 = 477,
  aux_sym__compound_statement_repeat1 = 478,
  aux_sym_create_function_statement_repeat1 = 479,
  aux_sym_create_function_statement_repeat2 = 480,
  aux_sym_create_function_parameters_repeat1 = 481,
  aux_sym_trigger_preferencing_repeat1 = 482,
  aux_sym_trigger_event_repeat1 = 483,
  aux_sym_trigger_body_repeat1 = 484,
  aux_sym_create_extension_statement_repeat1 = 485,
  aux_sym_grant_statement_repeat1 = 486,
  aux_sym_create_domain_statement_repeat1 = 487,
  aux_sym_type_spec_composite_repeat1 = 488,
  aux_sym_type_spec_range_repeat1 = 489,
  aux_sym_type_spec_base_repeat1 = 490,
  aux_sym_table_column_repeat1 = 491,
  aux_sym_table_parameters_repeat1 = 492,
  aux_sym_table_constraint_exclude_repeat1 = 493,
  aux_sym_index_table_parameters_repeat1 = 494,
  aux_sym_view_options_repeat1 = 495,
  aux_sym__select_statement_repeat1 = 496,
  aux_sym_group_by_clause_repeat1 = 497,
  aux_sym_grouping_sets_clause_repeat1 = 498,
  aux_sym_rollup_clause_repeat1 = 499,
  aux_sym_expression_list_repeat1 = 500,
  aux_sym_order_by_clause_repeat1 = 501,
  aux_sym_column_definitions_repeat1 = 502,
  aux_sym_select_clause_body_repeat1 = 503,
  aux_sym_from_clause_repeat1 = 504,
  aux_sym_rows_from_expression_repeat1 = 505,
  aux_sym_set_clause_body_repeat1 = 506,
  aux_sym_values_clause_repeat1 = 507,
  aux_sym_conditional_expression_repeat1 = 508,
  aux_sym_references_constraint_repeat1 = 509,
  aux_sym_dotted_name_repeat1 = 510,
  aux_sym_type_repeat1 = 511,
  aux_sym_array_type_repeat1 = 512,
  anon_alias_sym_ALTER_COLUMN = 513,
  anon_alias_sym_BY = 514,
  anon_alias_sym_CHECK = 515,
  anon_alias_sym_CREATE_EXTENSION = 516,
  anon_alias_sym_CREATE_SCHEMA = 517,
  anon_alias_sym_DEFERRABLE = 518,
  anon_alias_sym_DEFINER = 519,
  anon_alias_sym_DISTINCT_FROM = 520,
  anon_alias_sym_EXCLUDE_CURRENT_ROW = 521,
  anon_alias_sym_EXCLUDE_GROUP = 522,
  anon_alias_sym_EXISTS = 523,
  anon_alias_sym_FROM = 524,
  anon_alias_sym_FUNCTION = 525,
  anon_alias_sym_IF = 526,
  anon_alias_sym_IF_EXISTS = 527,
  anon_alias_sym_INVOKER = 528,
  anon_alias_sym_MATERIALIZED = 529,
  anon_alias_sym_MATERIALIZED_VIEW = 530,
  anon_alias_sym_NOT = 531,
  anon_alias_sym_NO_SQL = 532,
  anon_alias_sym_NULL = 533,
  anon_alias_sym_OF = 534,
  anon_alias_sym_ON_DELETE = 535,
  anon_alias_sym_ON_UPDATE = 536,
  anon_alias_sym_OR = 537,
  anon_alias_sym_PRECEDING = 538,
  anon_alias_sym_PROCEDURE = 539,
  anon_alias_sym_RENAME_TO = 540,
  anon_alias_sym_ROWS = 541,
  anon_alias_sym_SET_DEFAULT = 542,
  anon_alias_sym_SET_NULL = 543,
  anon_alias_sym_UNBOUNDED_FOLLOWING = 544,
  anon_alias_sym_WITH = 545,
  anon_alias_sym_WITHOUT = 546,
  alias_sym_alter_sequence = 547,
  anon_alias_sym_default = 548,
  alias_sym_default = 549,
  alias_sym_version = 550,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_SEMI] = ";",
  [aux_sym_with_clause_token1] = "WITH_GRANT_OPTION",
  [aux_sym_with_clause_token2] = "RECURSIVE",
  [anon_sym_COMMA] = ",",
  [aux_sym_cte_token1] = "AS",
  [aux_sym_cte_token2] = "IF_NOT_EXISTS",
  [aux_sym_cte_token3] = "CREATE_MATERIALIZED_VIEW",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [aux_sym_truncate_statement_token1] = "TRUNCATE",
  [aux_sym_truncate_statement_token2] = "TABLE",
  [aux_sym_truncate_statement_token3] = "ONLY",
  [aux_sym_comment_statement_token1] = "COMMENT_ON",
  [aux_sym_comment_statement_token2] = "ON",
  [aux_sym_comment_statement_token3] = "COLUMN",
  [aux_sym_comment_statement_token4] = "EXTENSION",
  [aux_sym_comment_statement_token5] = "SCHEMA",
  [aux_sym_comment_statement_token6] = "CREATE_OR_REPLACE_FUNCTION",
  [aux_sym_comment_statement_token7] = "IS",
  [aux_sym_begin_statement_token1] = "BEGIN",
  [aux_sym_begin_statement_token2] = "WORK",
  [aux_sym_begin_statement_token3] = "TRANSACTION",
  [aux_sym_commit_statement_token1] = "COMMIT",
  [aux_sym_rollback_statement_token1] = "ROLLBACK",
  [aux_sym_create_statement_token1] = "CREATE",
  [aux_sym_create_statement_token2] = "TEMP",
  [aux_sym_create_statement_token3] = "TEMPORARY",
  [aux_sym_alter_statement_token1] = "ALTER",
  [aux_sym_alter_table_token1] = "IF_NOT_EXISTS",
  [aux_sym_alter_table_token2] = "IF_NOT_EXISTS",
  [aux_sym_alter_schema_rename_action_token1] = "RENAME",
  [aux_sym_alter_schema_rename_action_token2] = "TO",
  [aux_sym_alter_owner_action_token1] = "OWNER_TO",
  [anon_sym_CURRENT_USER] = "CURRENT_USER",
  [anon_sym_CURRENT_ROLE] = "CURRENT_ROLE",
  [anon_sym_SESSION_USER] = "SESSION_USER",
  [aux_sym_alter_table_action_alter_column_token1] = "SET",
  [aux_sym_alter_table_action_alter_column_token2] = "DEFAULT",
  [aux_sym_alter_table_action_add_token1] = "ADD",
  [aux_sym_sequence_token1] = "SEQUENCE",
  [aux_sym_sequence_token2] = "START",
  [aux_sym_sequence_token3] = "INCREMENT",
  [aux_sym_sequence_token4] = "GROUP_BY",
  [aux_sym_sequence_token5] = "NO",
  [aux_sym_sequence_token6] = "MINVALUE",
  [aux_sym_sequence_token7] = "MAXVALUE",
  [aux_sym_sequence_token8] = "CACHE",
  [aux_sym_sequence_token9] = "OWNED_BY",
  [aux_sym_pg_command_token1] = "pg_command_token1",
  [aux_sym_pg_command_token2] = "pg_command_token2",
  [anon_sym_COLON] = ":",
  [aux_sym__compound_statement_token1] = "ATOMIC",
  [aux_sym__compound_statement_token2] = "END",
  [aux_sym_return_statement_token1] = "RETURN",
  [aux_sym_declare_statement_token1] = "DECLARE",
  [aux_sym_create_function_statement_token1] = "create_function_statement_token1",
  [aux_sym_create_function_statement_token2] = "CREATE_OR_REPLACE_PROCEDURE",
  [aux_sym_create_function_statement_token3] = "RETURNS",
  [aux_sym_create_function_statement_token4] = "TRANSFORM_FOR_TYPE",
  [aux_sym_create_function_statement_token5] = "FOR",
  [aux_sym_create_function_statement_token6] = "CREATE_TYPE",
  [aux_sym_create_function_statement_token7] = "WINDOW",
  [aux_sym_create_function_statement_token8] = "LEAKPROOF",
  [aux_sym_create_function_statement_token9] = "COST",
  [aux_sym_create_function_statement_token10] = "ROWS_FROM",
  [aux_sym_create_function_statement_token11] = "SUPPORT",
  [aux_sym_external_hint_token1] = "EXTERNAL",
  [aux_sym_external_hint_token2] = "SECURITY_INVOKER",
  [aux_sym_external_hint_token3] = "SECURITY_INVOKER",
  [aux_sym_external_hint_token4] = "SECURITY_DEFINER",
  [aux_sym_optimizer_hint_token1] = "VOLATILE",
  [aux_sym_optimizer_hint_token2] = "IMMUTABLE",
  [aux_sym_optimizer_hint_token3] = "STABLE",
  [aux_sym_parallel_hint_token1] = "PARALLEL",
  [aux_sym_parallel_hint_token2] = "SAFE",
  [aux_sym_parallel_hint_token3] = "UNSAFE",
  [aux_sym_parallel_hint_token4] = "RESTRICTED",
  [aux_sym_null_hint_token1] = "CALLED_ON_NULL_INPUT",
  [aux_sym_null_hint_token2] = "RETURNS_NULL_ON_NULL_INPUT",
  [aux_sym_null_hint_token3] = "input",
  [aux_sym_null_hint_token4] = "STRICT",
  [aux_sym_deterministic_hint_token1] = "DETERMINISTIC",
  [aux_sym_sql_hint_token1] = "CONTAINS_SQL",
  [aux_sym_sql_hint_token2] = "SQL_SECURITY",
  [aux_sym_sql_hint_token3] = "READS_SQL_DATA",
  [aux_sym_sql_hint_token4] = "DATA",
  [aux_sym_sql_hint_token5] = "MODIFIES_SQL_DATA",
  [aux_sym__function_language_token1] = "LANGUAGE",
  [aux_sym__function_language_token2] = "language",
  [aux_sym__function_language_token3] = "language",
  [aux_sym_setof_token1] = "SETOF",
  [aux_sym_create_function_parameter_token1] = "IN",
  [aux_sym_create_function_parameter_token2] = "OUT",
  [aux_sym_create_function_parameter_token3] = "INOUT",
  [aux_sym_create_function_parameter_token4] = "VARIADIC",
  [anon_sym_EQ] = "=",
  [aux_sym_create_trigger_statement_token1] = "OR_REPLACE",
  [aux_sym_create_trigger_statement_token2] = "OR_REPLACE",
  [aux_sym_create_trigger_statement_token3] = "CONSTRAINT",
  [aux_sym_create_trigger_statement_token4] = "TRIGGER",
  [aux_sym_create_trigger_statement_token5] = "EACH",
  [aux_sym_create_trigger_statement_token6] = "ROW",
  [aux_sym_create_trigger_statement_token7] = "STATEMENT",
  [aux_sym_trigger_reference_token1] = "ROWS_FROM",
  [aux_sym_trigger_preferencing_token1] = "REFERENCING",
  [aux_sym_trigger_preferencing_token2] = "NEW",
  [aux_sym_trigger_preferencing_token3] = "OLD",
  [aux_sym_trigger_time_token1] = "BEFORE",
  [aux_sym_trigger_time_token2] = "AFTER",
  [aux_sym_trigger_time_token3] = "INSTEAD_OF",
  [aux_sym_trigger_time_token4] = "INSTEAD_OF",
  [aux_sym_trigger_event_token1] = "INSERT",
  [aux_sym_trigger_event_token2] = "DELETE",
  [aux_sym_trigger_event_token3] = "UPDATE",
  [aux_sym_trigger_condition_token1] = "WHEN",
  [aux_sym_trigger_order_token1] = "FOLLOWS",
  [aux_sym_trigger_order_token2] = "PRECEDES",
  [aux_sym_trigger_body_token1] = "EXECUTE",
  [aux_sym_create_extension_statement_token1] = "VERSION",
  [aux_sym_create_extension_statement_token2] = "CASCADE",
  [aux_sym_create_role_statement_token1] = "CREATE_ROLE",
  [aux_sym_drop_statement_token1] = "DROP",
  [aux_sym_drop_statement_token2] = "VIEW",
  [aux_sym_drop_statement_token3] = "INDEX",
  [aux_sym_drop_statement_token4] = "TABLESPACE",
  [aux_sym_drop_statement_token5] = "CONCURRENTLY",
  [aux_sym_drop_statement_token6] = "RESTRICT",
  [aux_sym_set_statement_token1] = "SESSION",
  [aux_sym_set_statement_token2] = "LOCAL",
  [aux_sym_grant_statement_token1] = "GRANT",
  [aux_sym_grant_statement_token2] = "ALL",
  [aux_sym_grant_statement_token3] = "PRIVILEGES",
  [aux_sym_grant_statement_token4] = "SELECT",
  [aux_sym_grant_statement_token5] = "REFERENCES",
  [aux_sym_grant_statement_token6] = "USAGE",
  [aux_sym_grant_statement_token7] = "DATABASE",
  [aux_sym_grant_statement_token8] = "GROUP",
  [aux_sym_grant_statement_token9] = "PUBLIC",
  [aux_sym_grant_statement_token10] = "WITH_GRANT_OPTION",
  [aux_sym_create_domain_statement_token1] = "CREATE_DOMAIN",
  [aux_sym_type_spec_enum_token1] = "ENUM",
  [aux_sym_type_spec_range_token1] = "RANGE",
  [aux_sym_type_spec_range_token2] = "subtype",
  [aux_sym_type_spec_range_token3] = "subtype_opclass",
  [aux_sym_type_spec_range_token4] = "collation",
  [aux_sym_type_spec_range_token5] = "canonical",
  [aux_sym_type_spec_range_token6] = "subtype_diff",
  [aux_sym_type_spec_range_token7] = "multirange_type_name",
  [aux_sym_type_spec_base_token1] = "output",
  [aux_sym_type_spec_base_token2] = "receive",
  [aux_sym_type_spec_base_token3] = "send",
  [aux_sym_type_spec_base_token4] = "typmod_in",
  [aux_sym_type_spec_base_token5] = "typmod_out",
  [aux_sym_type_spec_base_token6] = "analyze",
  [aux_sym_type_spec_base_token7] = "subscript",
  [aux_sym_type_spec_base_token8] = "internallength",
  [aux_sym_type_spec_base_token9] = "VARIABLE",
  [aux_sym_type_spec_base_token10] = "passedbyvalue",
  [aux_sym_type_spec_base_token11] = "alignment",
  [aux_sym_type_spec_base_token12] = "storage",
  [aux_sym_type_spec_base_token13] = "like",
  [aux_sym_type_spec_base_token14] = "category",
  [aux_sym_type_spec_base_token15] = "preferred",
  [aux_sym_type_spec_base_token16] = "element",
  [aux_sym_type_spec_base_token17] = "delimiter",
  [aux_sym_type_spec_base_token18] = "collatable",
  [aux_sym_create_index_include_clause_token1] = "INCLUDE",
  [aux_sym_auto_increment_constraint_token1] = "AUTO_INCREMENT",
  [aux_sym_direction_constraint_token1] = "ASC",
  [aux_sym_direction_constraint_token2] = "DESC",
  [anon_sym_CONSTRAINT] = "CONSTRAINT",
  [aux_sym_mode_token1] = "NOT_DEFERRABLE",
  [aux_sym_initial_mode_token1] = "INITIALLY",
  [aux_sym_initial_mode_token2] = "DEFERRED",
  [aux_sym_initial_mode_token3] = "IMMEDIATE",
  [aux_sym_table_constraint_check_token1] = "CHECK_OPTION",
  [aux_sym_table_constraint_exclude_token1] = "EXCLUDE",
  [aux_sym_table_constraint_exclude_token2] = "USING",
  [aux_sym_table_constraint_foreign_key_token1] = "FOREIGN_KEY",
  [aux_sym_table_constraint_foreign_key_token2] = "PRIMARY_KEY",
  [aux_sym_table_constraint_unique_token1] = "UNIQUE",
  [aux_sym_table_constraint_primary_key_token1] = "PRIMARY_KEY",
  [aux_sym_create_table_statement_token1] = "WITHOUT_OIDS",
  [aux_sym_create_table_statement_token2] = "WITHOUT_OIDS",
  [aux_sym_view_check_option_token1] = "CASCADED",
  [aux_sym_having_clause_token1] = "HAVING",
  [aux_sym_grouping_sets_clause_token1] = "GROUPING_SETS",
  [aux_sym_grouping_sets_clause_token2] = "GROUPING_SETS",
  [aux_sym_rollup_clause_token1] = "ROLLUP",
  [aux_sym_cube_clause_token1] = "CUBE",
  [aux_sym_order_expression_token1] = "NULLS",
  [aux_sym_order_expression_token2] = "FIRST",
  [aux_sym_order_expression_token3] = "LAST",
  [aux_sym_order_by_clause_token1] = "ORDER_BY",
  [aux_sym_limit_clause_token1] = "LIMIT",
  [aux_sym_offset_clause_token1] = "OFFSET",
  [aux_sym_fetch_clause_token1] = "FETCH",
  [aux_sym_fetch_clause_token2] = "NEXT",
  [aux_sym_where_clause_token1] = "WHERE",
  [aux_sym_select_clause_body_token1] = "INTO",
  [aux_sym_tablesample_clause_token1] = "TABLESAMPLE",
  [aux_sym_repeatable_clause_token1] = "REPEATABLE",
  [aux_sym_rows_from_expression_token1] = "LATERAL",
  [aux_sym_join_clause_token1] = "NATURAL",
  [aux_sym_join_clause_token2] = "JOIN",
  [aux_sym_join_type_token1] = "INNER",
  [aux_sym_join_type_token2] = "LEFT",
  [aux_sym_join_type_token3] = "RIGHT",
  [aux_sym_join_type_token4] = "FULL",
  [aux_sym_join_type_token5] = "OUTER",
  [aux_sym_values_clause_token1] = "VALUES",
  [aux_sym_conditional_expression_token1] = "CASE",
  [aux_sym_conditional_expression_token2] = "THEN",
  [aux_sym_conditional_expression_token3] = "ELSE",
  [aux_sym__function_call_arguments_token1] = "DISTINCT",
  [aux_sym_within_group_clause_token1] = "WITHIN_GROUP",
  [aux_sym_filter_clause_token1] = "FILTER",
  [aux_sym_over_clause_token1] = "OVER",
  [aux_sym_partition_by_clause_token1] = "PARTITION_BY",
  [aux_sym_frame_clause_token1] = "BETWEEN",
  [aux_sym_frame_clause_token2] = "AND",
  [aux_sym_frame_kind_token1] = "GROUPS",
  [aux_sym_frame_bound_token1] = "UNBOUNDED_PRECEDING",
  [aux_sym_frame_bound_token2] = "UNBOUNDED_PRECEDING",
  [aux_sym_frame_bound_token3] = "CURRENT_ROW",
  [aux_sym_frame_bound_token4] = "FOLLOWING",
  [aux_sym_frame_exclusion_token1] = "EXCLUDE_TIES",
  [aux_sym_frame_exclusion_token2] = "EXCLUDE_NO_OTHERS",
  [aux_sym_with_ordinality_token1] = "WITH_ORDINALITY",
  [aux_sym_at_time_zone_expression_token1] = "AT_TIME_ZONE",
  [aux_sym_at_time_zone_expression_token2] = "TIME_ZONE",
  [aux_sym_at_time_zone_expression_token3] = "TIME_ZONE",
  [aux_sym_TRUE_token1] = "TRUE",
  [aux_sym_FALSE_token1] = "FALSE",
  [sym_number] = "number",
  [sym__unquoted_identifier] = "_unquoted_identifier",
  [anon_sym_BQUOTE] = "`",
  [aux_sym__quoted_identifier_token1] = "_quoted_identifier_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__quoted_identifier_token2] = "_quoted_identifier_token2",
  [anon_sym_DOT] = ".",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token1] = "content",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_POUND_GT] = "#>",
  [anon_sym_POUND_GT_GT] = "#>>",
  [aux_sym_type_token1] = "VARYING",
  [aux_sym_type_token2] = "PRECISION",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COLON_COLON] = "::",
  [sym_comment] = "comment",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG_BANG] = "!!",
  [anon_sym_TILDE] = "~",
  [anon_sym_AT] = "@",
  [anon_sym_PIPE_SLASH] = "|/",
  [anon_sym_PIPE_PIPE_SLASH] = "||/",
  [anon_sym_CARET] = "^",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_POUND] = "#",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_BANG_TILDE] = "!~",
  [anon_sym_TILDE_STAR] = "~*",
  [anon_sym_BANG_TILDE_STAR] = "!~*",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_DOT_STAR] = ".*",
  [aux_sym_interval_expression_token1] = "interval_expression_token1",
  [anon_sym_DOLLAR] = "$",
  [aux_sym_argument_reference_token1] = "argument_reference_token1",
  [sym__dollar_quoted_string_tag] = "_dollar_quoted_string_tag",
  [sym__dollar_quoted_string_content] = "content",
  [sym__dollar_quoted_string_end_tag] = "_dollar_quoted_string_end_tag",
  [sym_source_file] = "source_file",
  [sym__statement] = "_statement",
  [sym__simple_statement] = "_simple_statement",
  [sym_with_clause] = "with_clause",
  [sym_cte] = "cte",
  [sym_select_statement] = "select_statement",
  [sym_insert_statement] = "insert_statement",
  [sym_update_statement] = "update_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_truncate_statement] = "truncate_statement",
  [sym_comment_statement] = "comment_statement",
  [sym_begin_statement] = "begin_statement",
  [sym_commit_statement] = "commit_statement",
  [sym_rollback_statement] = "rollback_statement",
  [sym_create_statement] = "create_statement",
  [sym_alter_statement] = "alter_statement",
  [sym_alter_table] = "alter_table",
  [sym_alter_schema_rename_action] = "rename",
  [sym_alter_owner_action] = "alter_owner",
  [sym_alter_schema] = "schema",
  [sym_alter_table_action_alter_column] = "alter_table_action_alter_column",
  [sym_alter_table_action_add] = "alter_table_action_add",
  [sym_alter_table_action_set] = "alter_table_action_set",
  [sym_alter_table_rename_column] = "alter_table_rename_column",
  [sym_alter_table_action] = "alter_table_action",
  [sym_sequence] = "create_sequence",
  [sym_pg_command] = "pg_command",
  [sym__compound_statement] = "_compound_statement",
  [sym_return_statement] = "return_statement",
  [sym_declare_statement] = "declare_statement",
  [sym_create_function_statement] = "create_function_statement",
  [sym_external_hint] = "external_hint",
  [sym_optimizer_hint] = "optimizer_hint",
  [sym_parallel_hint] = "parallel_hint",
  [sym_null_hint] = "null_hint",
  [sym_deterministic_hint] = "deterministic_hint",
  [sym_sql_hint] = "sql_hint",
  [sym_sql_security_hint] = "sql_security_hint",
  [sym__function_language] = "_function_language",
  [sym__create_function_return_type] = "_create_function_return_type",
  [sym_setof] = "setof",
  [sym_constrained_type] = "constrained_type",
  [sym_create_function_parameter] = "create_function_parameter",
  [sym_create_function_parameters] = "create_function_parameters",
  [sym_function_body] = "function_body",
  [sym_create_trigger_statement] = "create_trigger_statement",
  [sym_trigger_reference] = "trigger_reference",
  [sym_trigger_preferencing] = "trigger_preferencing",
  [sym_trigger_time] = "trigger_time",
  [sym_trigger_event] = "trigger_event",
  [sym_trigger_condition] = "trigger_condition",
  [sym_trigger_order] = "trigger_order",
  [sym_trigger_body] = "trigger_body",
  [sym_create_extension_statement] = "create_extension_statement",
  [sym_create_role_statement] = "create_role_statement",
  [sym_create_schema_statement] = "create_schema_statement",
  [sym_drop_statement] = "drop_statement",
  [sym_set_statement] = "set_statement",
  [sym_grant_statement] = "grant_statement",
  [sym_create_domain_statement] = "create_domain_statement",
  [sym_create_type_statement] = "create_type_statement",
  [sym_type_spec_composite] = "type_spec_composite",
  [sym_type_spec_enum] = "type_spec_enum",
  [sym_type_spec_range] = "type_spec_range",
  [sym_type_spec_base] = "type_spec_base",
  [sym_create_index_with_clause] = "create_index_with_clause",
  [sym_create_index_include_clause] = "create_index_include_clause",
  [sym_create_index_statement] = "create_index_statement",
  [sym_table_column] = "table_column",
  [sym_auto_increment_constraint] = "auto_increment_constraint",
  [sym_direction_constraint] = "direction_constraint",
  [sym_named_constraint] = "named_constraint",
  [sym__column_default_expression] = "_column_default_expression",
  [sym_default_clause] = "default_clause",
  [sym_table_parameters] = "table_parameters",
  [sym_mode] = "mode",
  [sym_initial_mode] = "initial_mode",
  [sym__table_constraint] = "_table_constraint",
  [sym_table_constraint_check] = "check",
  [sym_op_class] = "op_class",
  [sym_exclude_entry] = "exclude_entry",
  [sym_table_constraint_exclude] = "exclude",
  [sym_table_constraint_foreign_key] = "foreign_key",
  [sym_table_constraint_unique] = "unique",
  [sym_table_constraint_primary_key] = "primary_key",
  [sym_primary_key_constraint] = "primary_key_constraint",
  [sym_create_table_statement] = "create_table_statement",
  [sym_using_clause] = "using_clause",
  [sym_index_table_parameters] = "index_table_parameters",
  [sym_create_view_statement] = "create_view_statement",
  [sym_view_columns] = "view_columns",
  [sym_view_option] = "view_option",
  [sym_view_options] = "view_options",
  [sym_view_check_option] = "view_check_option",
  [sym_view_body] = "view_body",
  [sym_create_materialized_view_statement] = "create_materialized_view_statement",
  [sym_tablespace_hint] = "tablespace_hint",
  [sym_data_hint] = "data_hint",
  [sym__select_statement] = "_select_statement",
  [sym_group_by_clause] = "group_by_clause",
  [sym_having_clause] = "having_clause",
  [sym_group_expression] = "group_expression",
  [sym_grouping_sets_clause] = "grouping_sets_clause",
  [sym_rollup_clause] = "rollup_clause",
  [sym_cube_clause] = "cube_clause",
  [sym_expression_list] = "expression_list",
  [sym_order_expression] = "order_expression",
  [sym_window_clause] = "window_clause",
  [sym_order_by_clause] = "order_by_clause",
  [sym_limit_clause] = "limit_clause",
  [sym_offset_clause] = "offset_clause",
  [sym_fetch_clause] = "fetch_clause",
  [sym_where_clause] = "where_clause",
  [sym_alias] = "alias",
  [sym__aliased_expression] = "_aliased_expression",
  [sym_column_names] = "column_names",
  [sym_column_definitions] = "column_definitions",
  [sym__aliasable_expression] = "_aliasable_expression",
  [sym_select_clause_body] = "select_clause_body",
  [sym_select_clause] = "select_clause",
  [sym_from_clause] = "from_clause",
  [sym__from_item] = "_from_item",
  [sym_tablesample_clause] = "tablesample_clause",
  [sym_repeatable_clause] = "repeatable_clause",
  [sym_rows_from_expression] = "rows_from_expression",
  [sym_join_clause] = "join_clause",
  [sym_join_type] = "join_type",
  [sym_join_condition] = "join_condition",
  [sym_select_subexpression] = "select_subexpression",
  [sym__update_statement] = "_update_statement",
  [sym_set_clause] = "set_clause",
  [sym_set_clause_body] = "set_clause_body",
  [sym_assigment_expression] = "assigment_expression",
  [sym__insert_statement] = "_insert_statement",
  [sym_values_clause] = "values_clause",
  [sym_values_clause_item] = "values_clause_item",
  [sym__delete_statement] = "_delete_statement",
  [sym_conditional_expression] = "conditional_expression",
  [sym_in_expression] = "in_expression",
  [sym_tuple] = "tuple",
  [sym_references_constraint] = "references_constraint",
  [sym_on_update_action] = "on_update_action",
  [sym_on_delete_action] = "on_delete_action",
  [sym__constraint_action] = "_constraint_action",
  [sym_unique_constraint] = "unique_constraint",
  [sym_null_constraint] = "null_constraint",
  [sym_check_constraint] = "check_constraint",
  [sym_function_call] = "function_call",
  [sym__function_call_arguments] = "_function_call_arguments",
  [sym_within_group_clause] = "within_group_clause",
  [sym_filter_clause] = "filter_clause",
  [sym_over_clause] = "over_clause",
  [sym_window_definition] = "window_definition",
  [sym_partition_by_clause] = "partition_by_clause",
  [sym_frame_clause] = "frame_clause",
  [sym_frame_kind] = "frame_kind",
  [sym_frame_bound] = "frame_bound",
  [sym_frame_exclusion] = "frame_exclusion",
  [sym__parenthesized_expression] = "_parenthesized_expression",
  [sym_with_ordinality] = "with_ordinality",
  [sym_is_expression] = "is_expression",
  [sym_distinct_from] = "distinct_from",
  [sym_boolean_expression] = "boolean_expression",
  [sym_at_time_zone_expression] = "at_time_zone_expression",
  [sym_NULL] = "NULL",
  [sym_TRUE] = "TRUE",
  [sym_FALSE] = "FALSE",
  [sym__quoted_identifier] = "_quoted_identifier",
  [sym_identifier] = "identifier",
  [sym_dotted_name] = "dotted_name",
  [sym__identifier] = "_identifier",
  [sym_string] = "string",
  [sym_json_access] = "json_access",
  [sym_ordered_expression] = "ordered_expression",
  [sym_type] = "type",
  [sym_array_type] = "array_type",
  [sym__type] = "_type",
  [sym_type_cast] = "type_cast",
  [sym_array_element_access] = "array_element_access",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_binary_operator] = "binary_operator",
  [sym_asterisk_expression] = "asterisk_expression",
  [sym_interval_expression] = "interval_expression",
  [sym_argument_reference] = "argument_reference",
  [sym__expression] = "_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_truncate_statement_repeat1] = "truncate_statement_repeat1",
  [aux_sym_sequence_repeat1] = "sequence_repeat1",
  [aux_sym__compound_statement_repeat1] = "_compound_statement_repeat1",
  [aux_sym_create_function_statement_repeat1] = "create_function_statement_repeat1",
  [aux_sym_create_function_statement_repeat2] = "create_function_statement_repeat2",
  [aux_sym_create_function_parameters_repeat1] = "create_function_parameters_repeat1",
  [aux_sym_trigger_preferencing_repeat1] = "trigger_preferencing_repeat1",
  [aux_sym_trigger_event_repeat1] = "trigger_event_repeat1",
  [aux_sym_trigger_body_repeat1] = "trigger_body_repeat1",
  [aux_sym_create_extension_statement_repeat1] = "create_extension_statement_repeat1",
  [aux_sym_grant_statement_repeat1] = "grant_statement_repeat1",
  [aux_sym_create_domain_statement_repeat1] = "create_domain_statement_repeat1",
  [aux_sym_type_spec_composite_repeat1] = "type_spec_composite_repeat1",
  [aux_sym_type_spec_range_repeat1] = "type_spec_range_repeat1",
  [aux_sym_type_spec_base_repeat1] = "type_spec_base_repeat1",
  [aux_sym_table_column_repeat1] = "table_column_repeat1",
  [aux_sym_table_parameters_repeat1] = "table_parameters_repeat1",
  [aux_sym_table_constraint_exclude_repeat1] = "table_constraint_exclude_repeat1",
  [aux_sym_index_table_parameters_repeat1] = "index_table_parameters_repeat1",
  [aux_sym_view_options_repeat1] = "view_options_repeat1",
  [aux_sym__select_statement_repeat1] = "_select_statement_repeat1",
  [aux_sym_group_by_clause_repeat1] = "group_by_clause_repeat1",
  [aux_sym_grouping_sets_clause_repeat1] = "grouping_sets_clause_repeat1",
  [aux_sym_rollup_clause_repeat1] = "rollup_clause_repeat1",
  [aux_sym_expression_list_repeat1] = "expression_list_repeat1",
  [aux_sym_order_by_clause_repeat1] = "order_by_clause_repeat1",
  [aux_sym_column_definitions_repeat1] = "column_definitions_repeat1",
  [aux_sym_select_clause_body_repeat1] = "select_clause_body_repeat1",
  [aux_sym_from_clause_repeat1] = "from_clause_repeat1",
  [aux_sym_rows_from_expression_repeat1] = "rows_from_expression_repeat1",
  [aux_sym_set_clause_body_repeat1] = "set_clause_body_repeat1",
  [aux_sym_values_clause_repeat1] = "values_clause_repeat1",
  [aux_sym_conditional_expression_repeat1] = "conditional_expression_repeat1",
  [aux_sym_references_constraint_repeat1] = "references_constraint_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_type_repeat1] = "type_repeat1",
  [aux_sym_array_type_repeat1] = "array_type_repeat1",
  [anon_alias_sym_ALTER_COLUMN] = "ALTER_COLUMN",
  [anon_alias_sym_BY] = "BY",
  [anon_alias_sym_CHECK] = "CHECK",
  [anon_alias_sym_CREATE_EXTENSION] = "CREATE_EXTENSION",
  [anon_alias_sym_CREATE_SCHEMA] = "CREATE_SCHEMA",
  [anon_alias_sym_DEFERRABLE] = "DEFERRABLE",
  [anon_alias_sym_DEFINER] = "DEFINER",
  [anon_alias_sym_DISTINCT_FROM] = "DISTINCT_FROM",
  [anon_alias_sym_EXCLUDE_CURRENT_ROW] = "EXCLUDE_CURRENT_ROW",
  [anon_alias_sym_EXCLUDE_GROUP] = "EXCLUDE_GROUP",
  [anon_alias_sym_EXISTS] = "EXISTS",
  [anon_alias_sym_FROM] = "FROM",
  [anon_alias_sym_FUNCTION] = "FUNCTION",
  [anon_alias_sym_IF] = "IF",
  [anon_alias_sym_IF_EXISTS] = "IF_EXISTS",
  [anon_alias_sym_INVOKER] = "INVOKER",
  [anon_alias_sym_MATERIALIZED] = "MATERIALIZED",
  [anon_alias_sym_MATERIALIZED_VIEW] = "MATERIALIZED_VIEW",
  [anon_alias_sym_NOT] = "NOT",
  [anon_alias_sym_NO_SQL] = "NO_SQL",
  [anon_alias_sym_NULL] = "NULL",
  [anon_alias_sym_OF] = "OF",
  [anon_alias_sym_ON_DELETE] = "ON_DELETE",
  [anon_alias_sym_ON_UPDATE] = "ON_UPDATE",
  [anon_alias_sym_OR] = "OR",
  [anon_alias_sym_PRECEDING] = "PRECEDING",
  [anon_alias_sym_PROCEDURE] = "PROCEDURE",
  [anon_alias_sym_RENAME_TO] = "RENAME_TO",
  [anon_alias_sym_ROWS] = "ROWS",
  [anon_alias_sym_SET_DEFAULT] = "SET_DEFAULT",
  [anon_alias_sym_SET_NULL] = "SET_NULL",
  [anon_alias_sym_UNBOUNDED_FOLLOWING] = "UNBOUNDED_FOLLOWING",
  [anon_alias_sym_WITH] = "WITH",
  [anon_alias_sym_WITHOUT] = "WITHOUT",
  [alias_sym_alter_sequence] = "alter_sequence",
  [anon_alias_sym_default] = "default",
  [alias_sym_default] = "default",
  [alias_sym_version] = "version",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [aux_sym_with_clause_token1] = aux_sym_with_clause_token1,
  [aux_sym_with_clause_token2] = aux_sym_with_clause_token2,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [aux_sym_cte_token1] = aux_sym_cte_token1,
  [aux_sym_cte_token2] = aux_sym_cte_token2,
  [aux_sym_cte_token3] = aux_sym_cte_token3,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_truncate_statement_token1] = aux_sym_truncate_statement_token1,
  [aux_sym_truncate_statement_token2] = aux_sym_truncate_statement_token2,
  [aux_sym_truncate_statement_token3] = aux_sym_truncate_statement_token3,
  [aux_sym_comment_statement_token1] = aux_sym_comment_statement_token1,
  [aux_sym_comment_statement_token2] = aux_sym_comment_statement_token2,
  [aux_sym_comment_statement_token3] = aux_sym_comment_statement_token3,
  [aux_sym_comment_statement_token4] = aux_sym_comment_statement_token4,
  [aux_sym_comment_statement_token5] = aux_sym_comment_statement_token5,
  [aux_sym_comment_statement_token6] = aux_sym_comment_statement_token6,
  [aux_sym_comment_statement_token7] = aux_sym_comment_statement_token7,
  [aux_sym_begin_statement_token1] = aux_sym_begin_statement_token1,
  [aux_sym_begin_statement_token2] = aux_sym_begin_statement_token2,
  [aux_sym_begin_statement_token3] = aux_sym_begin_statement_token3,
  [aux_sym_commit_statement_token1] = aux_sym_commit_statement_token1,
  [aux_sym_rollback_statement_token1] = aux_sym_rollback_statement_token1,
  [aux_sym_create_statement_token1] = aux_sym_create_statement_token1,
  [aux_sym_create_statement_token2] = aux_sym_create_statement_token2,
  [aux_sym_create_statement_token3] = aux_sym_create_statement_token3,
  [aux_sym_alter_statement_token1] = aux_sym_alter_statement_token1,
  [aux_sym_alter_table_token1] = aux_sym_cte_token2,
  [aux_sym_alter_table_token2] = aux_sym_cte_token2,
  [aux_sym_alter_schema_rename_action_token1] = aux_sym_alter_schema_rename_action_token1,
  [aux_sym_alter_schema_rename_action_token2] = aux_sym_alter_schema_rename_action_token2,
  [aux_sym_alter_owner_action_token1] = aux_sym_alter_owner_action_token1,
  [anon_sym_CURRENT_USER] = anon_sym_CURRENT_USER,
  [anon_sym_CURRENT_ROLE] = anon_sym_CURRENT_ROLE,
  [anon_sym_SESSION_USER] = anon_sym_SESSION_USER,
  [aux_sym_alter_table_action_alter_column_token1] = aux_sym_alter_table_action_alter_column_token1,
  [aux_sym_alter_table_action_alter_column_token2] = aux_sym_alter_table_action_alter_column_token2,
  [aux_sym_alter_table_action_add_token1] = aux_sym_alter_table_action_add_token1,
  [aux_sym_sequence_token1] = aux_sym_sequence_token1,
  [aux_sym_sequence_token2] = aux_sym_sequence_token2,
  [aux_sym_sequence_token3] = aux_sym_sequence_token3,
  [aux_sym_sequence_token4] = aux_sym_sequence_token4,
  [aux_sym_sequence_token5] = aux_sym_sequence_token5,
  [aux_sym_sequence_token6] = aux_sym_sequence_token6,
  [aux_sym_sequence_token7] = aux_sym_sequence_token7,
  [aux_sym_sequence_token8] = aux_sym_sequence_token8,
  [aux_sym_sequence_token9] = aux_sym_sequence_token9,
  [aux_sym_pg_command_token1] = aux_sym_pg_command_token1,
  [aux_sym_pg_command_token2] = aux_sym_pg_command_token2,
  [anon_sym_COLON] = anon_sym_COLON,
  [aux_sym__compound_statement_token1] = aux_sym__compound_statement_token1,
  [aux_sym__compound_statement_token2] = aux_sym__compound_statement_token2,
  [aux_sym_return_statement_token1] = aux_sym_return_statement_token1,
  [aux_sym_declare_statement_token1] = aux_sym_declare_statement_token1,
  [aux_sym_create_function_statement_token1] = aux_sym_create_function_statement_token1,
  [aux_sym_create_function_statement_token2] = aux_sym_create_function_statement_token2,
  [aux_sym_create_function_statement_token3] = aux_sym_create_function_statement_token3,
  [aux_sym_create_function_statement_token4] = aux_sym_create_function_statement_token4,
  [aux_sym_create_function_statement_token5] = aux_sym_create_function_statement_token5,
  [aux_sym_create_function_statement_token6] = aux_sym_create_function_statement_token6,
  [aux_sym_create_function_statement_token7] = aux_sym_create_function_statement_token7,
  [aux_sym_create_function_statement_token8] = aux_sym_create_function_statement_token8,
  [aux_sym_create_function_statement_token9] = aux_sym_create_function_statement_token9,
  [aux_sym_create_function_statement_token10] = aux_sym_create_function_statement_token10,
  [aux_sym_create_function_statement_token11] = aux_sym_create_function_statement_token11,
  [aux_sym_external_hint_token1] = aux_sym_external_hint_token1,
  [aux_sym_external_hint_token2] = aux_sym_external_hint_token2,
  [aux_sym_external_hint_token3] = aux_sym_external_hint_token2,
  [aux_sym_external_hint_token4] = aux_sym_external_hint_token4,
  [aux_sym_optimizer_hint_token1] = aux_sym_optimizer_hint_token1,
  [aux_sym_optimizer_hint_token2] = aux_sym_optimizer_hint_token2,
  [aux_sym_optimizer_hint_token3] = aux_sym_optimizer_hint_token3,
  [aux_sym_parallel_hint_token1] = aux_sym_parallel_hint_token1,
  [aux_sym_parallel_hint_token2] = aux_sym_parallel_hint_token2,
  [aux_sym_parallel_hint_token3] = aux_sym_parallel_hint_token3,
  [aux_sym_parallel_hint_token4] = aux_sym_parallel_hint_token4,
  [aux_sym_null_hint_token1] = aux_sym_null_hint_token1,
  [aux_sym_null_hint_token2] = aux_sym_null_hint_token2,
  [aux_sym_null_hint_token3] = aux_sym_null_hint_token3,
  [aux_sym_null_hint_token4] = aux_sym_null_hint_token4,
  [aux_sym_deterministic_hint_token1] = aux_sym_deterministic_hint_token1,
  [aux_sym_sql_hint_token1] = aux_sym_sql_hint_token1,
  [aux_sym_sql_hint_token2] = aux_sym_sql_hint_token2,
  [aux_sym_sql_hint_token3] = aux_sym_sql_hint_token3,
  [aux_sym_sql_hint_token4] = aux_sym_sql_hint_token4,
  [aux_sym_sql_hint_token5] = aux_sym_sql_hint_token5,
  [aux_sym__function_language_token1] = aux_sym__function_language_token1,
  [aux_sym__function_language_token2] = aux_sym__function_language_token2,
  [aux_sym__function_language_token3] = aux_sym__function_language_token2,
  [aux_sym_setof_token1] = aux_sym_setof_token1,
  [aux_sym_create_function_parameter_token1] = aux_sym_create_function_parameter_token1,
  [aux_sym_create_function_parameter_token2] = aux_sym_create_function_parameter_token2,
  [aux_sym_create_function_parameter_token3] = aux_sym_create_function_parameter_token3,
  [aux_sym_create_function_parameter_token4] = aux_sym_create_function_parameter_token4,
  [anon_sym_EQ] = anon_sym_EQ,
  [aux_sym_create_trigger_statement_token1] = aux_sym_create_trigger_statement_token1,
  [aux_sym_create_trigger_statement_token2] = aux_sym_create_trigger_statement_token1,
  [aux_sym_create_trigger_statement_token3] = anon_sym_CONSTRAINT,
  [aux_sym_create_trigger_statement_token4] = aux_sym_create_trigger_statement_token4,
  [aux_sym_create_trigger_statement_token5] = aux_sym_create_trigger_statement_token5,
  [aux_sym_create_trigger_statement_token6] = aux_sym_create_trigger_statement_token6,
  [aux_sym_create_trigger_statement_token7] = aux_sym_create_trigger_statement_token7,
  [aux_sym_trigger_reference_token1] = aux_sym_create_function_statement_token10,
  [aux_sym_trigger_preferencing_token1] = aux_sym_trigger_preferencing_token1,
  [aux_sym_trigger_preferencing_token2] = aux_sym_trigger_preferencing_token2,
  [aux_sym_trigger_preferencing_token3] = aux_sym_trigger_preferencing_token3,
  [aux_sym_trigger_time_token1] = aux_sym_trigger_time_token1,
  [aux_sym_trigger_time_token2] = aux_sym_trigger_time_token2,
  [aux_sym_trigger_time_token3] = aux_sym_trigger_time_token3,
  [aux_sym_trigger_time_token4] = aux_sym_trigger_time_token3,
  [aux_sym_trigger_event_token1] = aux_sym_trigger_event_token1,
  [aux_sym_trigger_event_token2] = aux_sym_trigger_event_token2,
  [aux_sym_trigger_event_token3] = aux_sym_trigger_event_token3,
  [aux_sym_trigger_condition_token1] = aux_sym_trigger_condition_token1,
  [aux_sym_trigger_order_token1] = aux_sym_trigger_order_token1,
  [aux_sym_trigger_order_token2] = aux_sym_trigger_order_token2,
  [aux_sym_trigger_body_token1] = aux_sym_trigger_body_token1,
  [aux_sym_create_extension_statement_token1] = aux_sym_create_extension_statement_token1,
  [aux_sym_create_extension_statement_token2] = aux_sym_create_extension_statement_token2,
  [aux_sym_create_role_statement_token1] = aux_sym_create_role_statement_token1,
  [aux_sym_drop_statement_token1] = aux_sym_drop_statement_token1,
  [aux_sym_drop_statement_token2] = aux_sym_drop_statement_token2,
  [aux_sym_drop_statement_token3] = aux_sym_drop_statement_token3,
  [aux_sym_drop_statement_token4] = aux_sym_drop_statement_token4,
  [aux_sym_drop_statement_token5] = aux_sym_drop_statement_token5,
  [aux_sym_drop_statement_token6] = aux_sym_drop_statement_token6,
  [aux_sym_set_statement_token1] = aux_sym_set_statement_token1,
  [aux_sym_set_statement_token2] = aux_sym_set_statement_token2,
  [aux_sym_grant_statement_token1] = aux_sym_grant_statement_token1,
  [aux_sym_grant_statement_token2] = aux_sym_grant_statement_token2,
  [aux_sym_grant_statement_token3] = aux_sym_grant_statement_token3,
  [aux_sym_grant_statement_token4] = aux_sym_grant_statement_token4,
  [aux_sym_grant_statement_token5] = aux_sym_grant_statement_token5,
  [aux_sym_grant_statement_token6] = aux_sym_grant_statement_token6,
  [aux_sym_grant_statement_token7] = aux_sym_grant_statement_token7,
  [aux_sym_grant_statement_token8] = aux_sym_grant_statement_token8,
  [aux_sym_grant_statement_token9] = aux_sym_grant_statement_token9,
  [aux_sym_grant_statement_token10] = aux_sym_with_clause_token1,
  [aux_sym_create_domain_statement_token1] = aux_sym_create_domain_statement_token1,
  [aux_sym_type_spec_enum_token1] = aux_sym_type_spec_enum_token1,
  [aux_sym_type_spec_range_token1] = aux_sym_type_spec_range_token1,
  [aux_sym_type_spec_range_token2] = aux_sym_type_spec_range_token2,
  [aux_sym_type_spec_range_token3] = aux_sym_type_spec_range_token3,
  [aux_sym_type_spec_range_token4] = aux_sym_type_spec_range_token4,
  [aux_sym_type_spec_range_token5] = aux_sym_type_spec_range_token5,
  [aux_sym_type_spec_range_token6] = aux_sym_type_spec_range_token6,
  [aux_sym_type_spec_range_token7] = aux_sym_type_spec_range_token7,
  [aux_sym_type_spec_base_token1] = aux_sym_type_spec_base_token1,
  [aux_sym_type_spec_base_token2] = aux_sym_type_spec_base_token2,
  [aux_sym_type_spec_base_token3] = aux_sym_type_spec_base_token3,
  [aux_sym_type_spec_base_token4] = aux_sym_type_spec_base_token4,
  [aux_sym_type_spec_base_token5] = aux_sym_type_spec_base_token5,
  [aux_sym_type_spec_base_token6] = aux_sym_type_spec_base_token6,
  [aux_sym_type_spec_base_token7] = aux_sym_type_spec_base_token7,
  [aux_sym_type_spec_base_token8] = aux_sym_type_spec_base_token8,
  [aux_sym_type_spec_base_token9] = aux_sym_type_spec_base_token9,
  [aux_sym_type_spec_base_token10] = aux_sym_type_spec_base_token10,
  [aux_sym_type_spec_base_token11] = aux_sym_type_spec_base_token11,
  [aux_sym_type_spec_base_token12] = aux_sym_type_spec_base_token12,
  [aux_sym_type_spec_base_token13] = aux_sym_type_spec_base_token13,
  [aux_sym_type_spec_base_token14] = aux_sym_type_spec_base_token14,
  [aux_sym_type_spec_base_token15] = aux_sym_type_spec_base_token15,
  [aux_sym_type_spec_base_token16] = aux_sym_type_spec_base_token16,
  [aux_sym_type_spec_base_token17] = aux_sym_type_spec_base_token17,
  [aux_sym_type_spec_base_token18] = aux_sym_type_spec_base_token18,
  [aux_sym_create_index_include_clause_token1] = aux_sym_create_index_include_clause_token1,
  [aux_sym_auto_increment_constraint_token1] = aux_sym_auto_increment_constraint_token1,
  [aux_sym_direction_constraint_token1] = aux_sym_direction_constraint_token1,
  [aux_sym_direction_constraint_token2] = aux_sym_direction_constraint_token2,
  [anon_sym_CONSTRAINT] = anon_sym_CONSTRAINT,
  [aux_sym_mode_token1] = aux_sym_mode_token1,
  [aux_sym_initial_mode_token1] = aux_sym_initial_mode_token1,
  [aux_sym_initial_mode_token2] = aux_sym_initial_mode_token2,
  [aux_sym_initial_mode_token3] = aux_sym_initial_mode_token3,
  [aux_sym_table_constraint_check_token1] = aux_sym_table_constraint_check_token1,
  [aux_sym_table_constraint_exclude_token1] = aux_sym_table_constraint_exclude_token1,
  [aux_sym_table_constraint_exclude_token2] = aux_sym_table_constraint_exclude_token2,
  [aux_sym_table_constraint_foreign_key_token1] = aux_sym_table_constraint_foreign_key_token1,
  [aux_sym_table_constraint_foreign_key_token2] = aux_sym_table_constraint_foreign_key_token2,
  [aux_sym_table_constraint_unique_token1] = aux_sym_table_constraint_unique_token1,
  [aux_sym_table_constraint_primary_key_token1] = aux_sym_table_constraint_foreign_key_token2,
  [aux_sym_create_table_statement_token1] = aux_sym_create_table_statement_token1,
  [aux_sym_create_table_statement_token2] = aux_sym_create_table_statement_token1,
  [aux_sym_view_check_option_token1] = aux_sym_view_check_option_token1,
  [aux_sym_having_clause_token1] = aux_sym_having_clause_token1,
  [aux_sym_grouping_sets_clause_token1] = aux_sym_grouping_sets_clause_token1,
  [aux_sym_grouping_sets_clause_token2] = aux_sym_grouping_sets_clause_token1,
  [aux_sym_rollup_clause_token1] = aux_sym_rollup_clause_token1,
  [aux_sym_cube_clause_token1] = aux_sym_cube_clause_token1,
  [aux_sym_order_expression_token1] = aux_sym_order_expression_token1,
  [aux_sym_order_expression_token2] = aux_sym_order_expression_token2,
  [aux_sym_order_expression_token3] = aux_sym_order_expression_token3,
  [aux_sym_order_by_clause_token1] = aux_sym_order_by_clause_token1,
  [aux_sym_limit_clause_token1] = aux_sym_limit_clause_token1,
  [aux_sym_offset_clause_token1] = aux_sym_offset_clause_token1,
  [aux_sym_fetch_clause_token1] = aux_sym_fetch_clause_token1,
  [aux_sym_fetch_clause_token2] = aux_sym_fetch_clause_token2,
  [aux_sym_where_clause_token1] = aux_sym_where_clause_token1,
  [aux_sym_select_clause_body_token1] = aux_sym_select_clause_body_token1,
  [aux_sym_tablesample_clause_token1] = aux_sym_tablesample_clause_token1,
  [aux_sym_repeatable_clause_token1] = aux_sym_repeatable_clause_token1,
  [aux_sym_rows_from_expression_token1] = aux_sym_rows_from_expression_token1,
  [aux_sym_join_clause_token1] = aux_sym_join_clause_token1,
  [aux_sym_join_clause_token2] = aux_sym_join_clause_token2,
  [aux_sym_join_type_token1] = aux_sym_join_type_token1,
  [aux_sym_join_type_token2] = aux_sym_join_type_token2,
  [aux_sym_join_type_token3] = aux_sym_join_type_token3,
  [aux_sym_join_type_token4] = aux_sym_join_type_token4,
  [aux_sym_join_type_token5] = aux_sym_join_type_token5,
  [aux_sym_values_clause_token1] = aux_sym_values_clause_token1,
  [aux_sym_conditional_expression_token1] = aux_sym_conditional_expression_token1,
  [aux_sym_conditional_expression_token2] = aux_sym_conditional_expression_token2,
  [aux_sym_conditional_expression_token3] = aux_sym_conditional_expression_token3,
  [aux_sym__function_call_arguments_token1] = aux_sym__function_call_arguments_token1,
  [aux_sym_within_group_clause_token1] = aux_sym_within_group_clause_token1,
  [aux_sym_filter_clause_token1] = aux_sym_filter_clause_token1,
  [aux_sym_over_clause_token1] = aux_sym_over_clause_token1,
  [aux_sym_partition_by_clause_token1] = aux_sym_partition_by_clause_token1,
  [aux_sym_frame_clause_token1] = aux_sym_frame_clause_token1,
  [aux_sym_frame_clause_token2] = aux_sym_frame_clause_token2,
  [aux_sym_frame_kind_token1] = aux_sym_frame_kind_token1,
  [aux_sym_frame_bound_token1] = aux_sym_frame_bound_token1,
  [aux_sym_frame_bound_token2] = aux_sym_frame_bound_token1,
  [aux_sym_frame_bound_token3] = aux_sym_frame_bound_token3,
  [aux_sym_frame_bound_token4] = aux_sym_frame_bound_token4,
  [aux_sym_frame_exclusion_token1] = aux_sym_frame_exclusion_token1,
  [aux_sym_frame_exclusion_token2] = aux_sym_frame_exclusion_token2,
  [aux_sym_with_ordinality_token1] = aux_sym_with_ordinality_token1,
  [aux_sym_at_time_zone_expression_token1] = aux_sym_at_time_zone_expression_token1,
  [aux_sym_at_time_zone_expression_token2] = aux_sym_at_time_zone_expression_token2,
  [aux_sym_at_time_zone_expression_token3] = aux_sym_at_time_zone_expression_token2,
  [aux_sym_TRUE_token1] = aux_sym_TRUE_token1,
  [aux_sym_FALSE_token1] = aux_sym_FALSE_token1,
  [sym_number] = sym_number,
  [sym__unquoted_identifier] = sym__unquoted_identifier,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym__quoted_identifier_token1] = aux_sym__quoted_identifier_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__quoted_identifier_token2] = aux_sym__quoted_identifier_token2,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token1] = sym__dollar_quoted_string_content,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_POUND_GT] = anon_sym_POUND_GT,
  [anon_sym_POUND_GT_GT] = anon_sym_POUND_GT_GT,
  [aux_sym_type_token1] = aux_sym_type_token1,
  [aux_sym_type_token2] = aux_sym_type_token2,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_comment] = sym_comment,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG_BANG] = anon_sym_BANG_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_PIPE_SLASH] = anon_sym_PIPE_SLASH,
  [anon_sym_PIPE_PIPE_SLASH] = anon_sym_PIPE_PIPE_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_BANG_TILDE] = anon_sym_BANG_TILDE,
  [anon_sym_TILDE_STAR] = anon_sym_TILDE_STAR,
  [anon_sym_BANG_TILDE_STAR] = anon_sym_BANG_TILDE_STAR,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_DOT_STAR] = anon_sym_DOT_STAR,
  [aux_sym_interval_expression_token1] = aux_sym_interval_expression_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_argument_reference_token1] = aux_sym_argument_reference_token1,
  [sym__dollar_quoted_string_tag] = sym__dollar_quoted_string_tag,
  [sym__dollar_quoted_string_content] = sym__dollar_quoted_string_content,
  [sym__dollar_quoted_string_end_tag] = sym__dollar_quoted_string_end_tag,
  [sym_source_file] = sym_source_file,
  [sym__statement] = sym__statement,
  [sym__simple_statement] = sym__simple_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_cte] = sym_cte,
  [sym_select_statement] = sym_select_statement,
  [sym_insert_statement] = sym_insert_statement,
  [sym_update_statement] = sym_update_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_truncate_statement] = sym_truncate_statement,
  [sym_comment_statement] = sym_comment_statement,
  [sym_begin_statement] = sym_begin_statement,
  [sym_commit_statement] = sym_commit_statement,
  [sym_rollback_statement] = sym_rollback_statement,
  [sym_create_statement] = sym_create_statement,
  [sym_alter_statement] = sym_alter_statement,
  [sym_alter_table] = sym_alter_table,
  [sym_alter_schema_rename_action] = sym_alter_schema_rename_action,
  [sym_alter_owner_action] = sym_alter_owner_action,
  [sym_alter_schema] = sym_alter_schema,
  [sym_alter_table_action_alter_column] = sym_alter_table_action_alter_column,
  [sym_alter_table_action_add] = sym_alter_table_action_add,
  [sym_alter_table_action_set] = sym_alter_table_action_set,
  [sym_alter_table_rename_column] = sym_alter_table_rename_column,
  [sym_alter_table_action] = sym_alter_table_action,
  [sym_sequence] = sym_sequence,
  [sym_pg_command] = sym_pg_command,
  [sym__compound_statement] = sym__compound_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_declare_statement] = sym_declare_statement,
  [sym_create_function_statement] = sym_create_function_statement,
  [sym_external_hint] = sym_external_hint,
  [sym_optimizer_hint] = sym_optimizer_hint,
  [sym_parallel_hint] = sym_parallel_hint,
  [sym_null_hint] = sym_null_hint,
  [sym_deterministic_hint] = sym_deterministic_hint,
  [sym_sql_hint] = sym_sql_hint,
  [sym_sql_security_hint] = sym_sql_security_hint,
  [sym__function_language] = sym__function_language,
  [sym__create_function_return_type] = sym__create_function_return_type,
  [sym_setof] = sym_setof,
  [sym_constrained_type] = sym_constrained_type,
  [sym_create_function_parameter] = sym_create_function_parameter,
  [sym_create_function_parameters] = sym_create_function_parameters,
  [sym_function_body] = sym_function_body,
  [sym_create_trigger_statement] = sym_create_trigger_statement,
  [sym_trigger_reference] = sym_trigger_reference,
  [sym_trigger_preferencing] = sym_trigger_preferencing,
  [sym_trigger_time] = sym_trigger_time,
  [sym_trigger_event] = sym_trigger_event,
  [sym_trigger_condition] = sym_trigger_condition,
  [sym_trigger_order] = sym_trigger_order,
  [sym_trigger_body] = sym_trigger_body,
  [sym_create_extension_statement] = sym_create_extension_statement,
  [sym_create_role_statement] = sym_create_role_statement,
  [sym_create_schema_statement] = sym_create_schema_statement,
  [sym_drop_statement] = sym_drop_statement,
  [sym_set_statement] = sym_set_statement,
  [sym_grant_statement] = sym_grant_statement,
  [sym_create_domain_statement] = sym_create_domain_statement,
  [sym_create_type_statement] = sym_create_type_statement,
  [sym_type_spec_composite] = sym_type_spec_composite,
  [sym_type_spec_enum] = sym_type_spec_enum,
  [sym_type_spec_range] = sym_type_spec_range,
  [sym_type_spec_base] = sym_type_spec_base,
  [sym_create_index_with_clause] = sym_create_index_with_clause,
  [sym_create_index_include_clause] = sym_create_index_include_clause,
  [sym_create_index_statement] = sym_create_index_statement,
  [sym_table_column] = sym_table_column,
  [sym_auto_increment_constraint] = sym_auto_increment_constraint,
  [sym_direction_constraint] = sym_direction_constraint,
  [sym_named_constraint] = sym_named_constraint,
  [sym__column_default_expression] = sym__column_default_expression,
  [sym_default_clause] = sym_default_clause,
  [sym_table_parameters] = sym_table_parameters,
  [sym_mode] = sym_mode,
  [sym_initial_mode] = sym_initial_mode,
  [sym__table_constraint] = sym__table_constraint,
  [sym_table_constraint_check] = sym_table_constraint_check,
  [sym_op_class] = sym_op_class,
  [sym_exclude_entry] = sym_exclude_entry,
  [sym_table_constraint_exclude] = sym_table_constraint_exclude,
  [sym_table_constraint_foreign_key] = sym_table_constraint_foreign_key,
  [sym_table_constraint_unique] = sym_table_constraint_unique,
  [sym_table_constraint_primary_key] = sym_table_constraint_primary_key,
  [sym_primary_key_constraint] = sym_primary_key_constraint,
  [sym_create_table_statement] = sym_create_table_statement,
  [sym_using_clause] = sym_using_clause,
  [sym_index_table_parameters] = sym_index_table_parameters,
  [sym_create_view_statement] = sym_create_view_statement,
  [sym_view_columns] = sym_view_columns,
  [sym_view_option] = sym_view_option,
  [sym_view_options] = sym_view_options,
  [sym_view_check_option] = sym_view_check_option,
  [sym_view_body] = sym_view_body,
  [sym_create_materialized_view_statement] = sym_create_materialized_view_statement,
  [sym_tablespace_hint] = sym_tablespace_hint,
  [sym_data_hint] = sym_data_hint,
  [sym__select_statement] = sym__select_statement,
  [sym_group_by_clause] = sym_group_by_clause,
  [sym_having_clause] = sym_having_clause,
  [sym_group_expression] = sym_group_expression,
  [sym_grouping_sets_clause] = sym_grouping_sets_clause,
  [sym_rollup_clause] = sym_rollup_clause,
  [sym_cube_clause] = sym_cube_clause,
  [sym_expression_list] = sym_expression_list,
  [sym_order_expression] = sym_order_expression,
  [sym_window_clause] = sym_window_clause,
  [sym_order_by_clause] = sym_order_by_clause,
  [sym_limit_clause] = sym_limit_clause,
  [sym_offset_clause] = sym_offset_clause,
  [sym_fetch_clause] = sym_fetch_clause,
  [sym_where_clause] = sym_where_clause,
  [sym_alias] = sym_alias,
  [sym__aliased_expression] = sym__aliased_expression,
  [sym_column_names] = sym_column_names,
  [sym_column_definitions] = sym_column_definitions,
  [sym__aliasable_expression] = sym__aliasable_expression,
  [sym_select_clause_body] = sym_select_clause_body,
  [sym_select_clause] = sym_select_clause,
  [sym_from_clause] = sym_from_clause,
  [sym__from_item] = sym__from_item,
  [sym_tablesample_clause] = sym_tablesample_clause,
  [sym_repeatable_clause] = sym_repeatable_clause,
  [sym_rows_from_expression] = sym_rows_from_expression,
  [sym_join_clause] = sym_join_clause,
  [sym_join_type] = sym_join_type,
  [sym_join_condition] = sym_join_condition,
  [sym_select_subexpression] = sym_select_subexpression,
  [sym__update_statement] = sym__update_statement,
  [sym_set_clause] = sym_set_clause,
  [sym_set_clause_body] = sym_set_clause_body,
  [sym_assigment_expression] = sym_assigment_expression,
  [sym__insert_statement] = sym__insert_statement,
  [sym_values_clause] = sym_values_clause,
  [sym_values_clause_item] = sym_values_clause_item,
  [sym__delete_statement] = sym__delete_statement,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_in_expression] = sym_in_expression,
  [sym_tuple] = sym_tuple,
  [sym_references_constraint] = sym_references_constraint,
  [sym_on_update_action] = sym_on_update_action,
  [sym_on_delete_action] = sym_on_delete_action,
  [sym__constraint_action] = sym__constraint_action,
  [sym_unique_constraint] = sym_unique_constraint,
  [sym_null_constraint] = sym_null_constraint,
  [sym_check_constraint] = sym_check_constraint,
  [sym_function_call] = sym_function_call,
  [sym__function_call_arguments] = sym__function_call_arguments,
  [sym_within_group_clause] = sym_within_group_clause,
  [sym_filter_clause] = sym_filter_clause,
  [sym_over_clause] = sym_over_clause,
  [sym_window_definition] = sym_window_definition,
  [sym_partition_by_clause] = sym_partition_by_clause,
  [sym_frame_clause] = sym_frame_clause,
  [sym_frame_kind] = sym_frame_kind,
  [sym_frame_bound] = sym_frame_bound,
  [sym_frame_exclusion] = sym_frame_exclusion,
  [sym__parenthesized_expression] = sym__parenthesized_expression,
  [sym_with_ordinality] = sym_with_ordinality,
  [sym_is_expression] = sym_is_expression,
  [sym_distinct_from] = sym_distinct_from,
  [sym_boolean_expression] = sym_boolean_expression,
  [sym_at_time_zone_expression] = sym_at_time_zone_expression,
  [sym_NULL] = sym_NULL,
  [sym_TRUE] = sym_TRUE,
  [sym_FALSE] = sym_FALSE,
  [sym__quoted_identifier] = sym__quoted_identifier,
  [sym_identifier] = sym_identifier,
  [sym_dotted_name] = sym_dotted_name,
  [sym__identifier] = sym__identifier,
  [sym_string] = sym_string,
  [sym_json_access] = sym_json_access,
  [sym_ordered_expression] = sym_ordered_expression,
  [sym_type] = sym_type,
  [sym_array_type] = sym_array_type,
  [sym__type] = sym__type,
  [sym_type_cast] = sym_type_cast,
  [sym_array_element_access] = sym_array_element_access,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_binary_operator] = sym_binary_operator,
  [sym_asterisk_expression] = sym_asterisk_expression,
  [sym_interval_expression] = sym_interval_expression,
  [sym_argument_reference] = sym_argument_reference,
  [sym__expression] = sym__expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_truncate_statement_repeat1] = aux_sym_truncate_statement_repeat1,
  [aux_sym_sequence_repeat1] = aux_sym_sequence_repeat1,
  [aux_sym__compound_statement_repeat1] = aux_sym__compound_statement_repeat1,
  [aux_sym_create_function_statement_repeat1] = aux_sym_create_function_statement_repeat1,
  [aux_sym_create_function_statement_repeat2] = aux_sym_create_function_statement_repeat2,
  [aux_sym_create_function_parameters_repeat1] = aux_sym_create_function_parameters_repeat1,
  [aux_sym_trigger_preferencing_repeat1] = aux_sym_trigger_preferencing_repeat1,
  [aux_sym_trigger_event_repeat1] = aux_sym_trigger_event_repeat1,
  [aux_sym_trigger_body_repeat1] = aux_sym_trigger_body_repeat1,
  [aux_sym_create_extension_statement_repeat1] = aux_sym_create_extension_statement_repeat1,
  [aux_sym_grant_statement_repeat1] = aux_sym_grant_statement_repeat1,
  [aux_sym_create_domain_statement_repeat1] = aux_sym_create_domain_statement_repeat1,
  [aux_sym_type_spec_composite_repeat1] = aux_sym_type_spec_composite_repeat1,
  [aux_sym_type_spec_range_repeat1] = aux_sym_type_spec_range_repeat1,
  [aux_sym_type_spec_base_repeat1] = aux_sym_type_spec_base_repeat1,
  [aux_sym_table_column_repeat1] = aux_sym_table_column_repeat1,
  [aux_sym_table_parameters_repeat1] = aux_sym_table_parameters_repeat1,
  [aux_sym_table_constraint_exclude_repeat1] = aux_sym_table_constraint_exclude_repeat1,
  [aux_sym_index_table_parameters_repeat1] = aux_sym_index_table_parameters_repeat1,
  [aux_sym_view_options_repeat1] = aux_sym_view_options_repeat1,
  [aux_sym__select_statement_repeat1] = aux_sym__select_statement_repeat1,
  [aux_sym_group_by_clause_repeat1] = aux_sym_group_by_clause_repeat1,
  [aux_sym_grouping_sets_clause_repeat1] = aux_sym_grouping_sets_clause_repeat1,
  [aux_sym_rollup_clause_repeat1] = aux_sym_rollup_clause_repeat1,
  [aux_sym_expression_list_repeat1] = aux_sym_expression_list_repeat1,
  [aux_sym_order_by_clause_repeat1] = aux_sym_order_by_clause_repeat1,
  [aux_sym_column_definitions_repeat1] = aux_sym_column_definitions_repeat1,
  [aux_sym_select_clause_body_repeat1] = aux_sym_select_clause_body_repeat1,
  [aux_sym_from_clause_repeat1] = aux_sym_from_clause_repeat1,
  [aux_sym_rows_from_expression_repeat1] = aux_sym_rows_from_expression_repeat1,
  [aux_sym_set_clause_body_repeat1] = aux_sym_set_clause_body_repeat1,
  [aux_sym_values_clause_repeat1] = aux_sym_values_clause_repeat1,
  [aux_sym_conditional_expression_repeat1] = aux_sym_conditional_expression_repeat1,
  [aux_sym_references_constraint_repeat1] = aux_sym_references_constraint_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_type_repeat1] = aux_sym_type_repeat1,
  [aux_sym_array_type_repeat1] = aux_sym_array_type_repeat1,
  [anon_alias_sym_ALTER_COLUMN] = anon_alias_sym_ALTER_COLUMN,
  [anon_alias_sym_BY] = anon_alias_sym_BY,
  [anon_alias_sym_CHECK] = anon_alias_sym_CHECK,
  [anon_alias_sym_CREATE_EXTENSION] = anon_alias_sym_CREATE_EXTENSION,
  [anon_alias_sym_CREATE_SCHEMA] = anon_alias_sym_CREATE_SCHEMA,
  [anon_alias_sym_DEFERRABLE] = anon_alias_sym_DEFERRABLE,
  [anon_alias_sym_DEFINER] = anon_alias_sym_DEFINER,
  [anon_alias_sym_DISTINCT_FROM] = anon_alias_sym_DISTINCT_FROM,
  [anon_alias_sym_EXCLUDE_CURRENT_ROW] = anon_alias_sym_EXCLUDE_CURRENT_ROW,
  [anon_alias_sym_EXCLUDE_GROUP] = anon_alias_sym_EXCLUDE_GROUP,
  [anon_alias_sym_EXISTS] = anon_alias_sym_EXISTS,
  [anon_alias_sym_FROM] = anon_alias_sym_FROM,
  [anon_alias_sym_FUNCTION] = anon_alias_sym_FUNCTION,
  [anon_alias_sym_IF] = anon_alias_sym_IF,
  [anon_alias_sym_IF_EXISTS] = anon_alias_sym_IF_EXISTS,
  [anon_alias_sym_INVOKER] = anon_alias_sym_INVOKER,
  [anon_alias_sym_MATERIALIZED] = anon_alias_sym_MATERIALIZED,
  [anon_alias_sym_MATERIALIZED_VIEW] = anon_alias_sym_MATERIALIZED_VIEW,
  [anon_alias_sym_NOT] = anon_alias_sym_NOT,
  [anon_alias_sym_NO_SQL] = anon_alias_sym_NO_SQL,
  [anon_alias_sym_NULL] = anon_alias_sym_NULL,
  [anon_alias_sym_OF] = anon_alias_sym_OF,
  [anon_alias_sym_ON_DELETE] = anon_alias_sym_ON_DELETE,
  [anon_alias_sym_ON_UPDATE] = anon_alias_sym_ON_UPDATE,
  [anon_alias_sym_OR] = anon_alias_sym_OR,
  [anon_alias_sym_PRECEDING] = anon_alias_sym_PRECEDING,
  [anon_alias_sym_PROCEDURE] = anon_alias_sym_PROCEDURE,
  [anon_alias_sym_RENAME_TO] = anon_alias_sym_RENAME_TO,
  [anon_alias_sym_ROWS] = anon_alias_sym_ROWS,
  [anon_alias_sym_SET_DEFAULT] = anon_alias_sym_SET_DEFAULT,
  [anon_alias_sym_SET_NULL] = anon_alias_sym_SET_NULL,
  [anon_alias_sym_UNBOUNDED_FOLLOWING] = anon_alias_sym_UNBOUNDED_FOLLOWING,
  [anon_alias_sym_WITH] = anon_alias_sym_WITH,
  [anon_alias_sym_WITHOUT] = anon_alias_sym_WITHOUT,
  [alias_sym_alter_sequence] = alias_sym_alter_sequence,
  [anon_alias_sym_default] = anon_alias_sym_default,
  [alias_sym_default] = alias_sym_default,
  [alias_sym_version] = alias_sym_version,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_with_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_with_clause_token2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cte_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cte_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cte_token3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_truncate_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_truncate_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_truncate_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_begin_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_begin_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_begin_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_commit_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_rollback_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_schema_rename_action_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_schema_rename_action_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_owner_action_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CURRENT_USER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CURRENT_ROLE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SESSION_USER] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_action_alter_column_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_action_alter_column_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_action_add_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token8] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token9] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_pg_command_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pg_command_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__compound_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__compound_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_return_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_declare_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_function_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token8] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token9] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token10] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token11] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_external_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_external_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_external_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_external_hint_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_optimizer_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_optimizer_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_optimizer_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parallel_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parallel_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parallel_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parallel_hint_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_null_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_null_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_null_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_null_hint_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_deterministic_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__function_language_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__function_language_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__function_language_token3] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_setof_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_parameter_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_parameter_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_parameter_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_parameter_token4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_reference_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_preferencing_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_preferencing_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_preferencing_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_time_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_time_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_time_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_time_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_event_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_event_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_event_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_condition_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_order_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_order_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_body_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_extension_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_extension_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_role_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_set_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_set_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token8] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token9] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token10] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_domain_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_enum_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token8] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token9] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token10] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token11] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token12] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token13] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token14] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token15] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token16] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token17] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token18] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_index_include_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_auto_increment_constraint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_direction_constraint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_direction_constraint_token2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTRAINT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_mode_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_initial_mode_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_initial_mode_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_initial_mode_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_check_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_exclude_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_exclude_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_foreign_key_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_foreign_key_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_unique_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_primary_key_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_table_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_table_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_view_check_option_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_having_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grouping_sets_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grouping_sets_clause_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_rollup_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cube_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_order_expression_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_order_expression_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_order_expression_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_order_by_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_limit_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_offset_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_fetch_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_fetch_clause_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_where_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_select_clause_body_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_tablesample_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_repeatable_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_rows_from_expression_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_clause_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_values_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_conditional_expression_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_conditional_expression_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_conditional_expression_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__function_call_arguments_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_within_group_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_filter_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_over_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_partition_by_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_clause_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_kind_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_bound_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_bound_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_bound_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_bound_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_exclusion_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_exclusion_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_with_ordinality_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_at_time_zone_expression_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_at_time_zone_expression_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_at_time_zone_expression_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_TRUE_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_FALSE_token1] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym__unquoted_identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__quoted_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__quoted_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_token2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interval_expression_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_argument_reference_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__dollar_quoted_string_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__dollar_quoted_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym__dollar_quoted_string_end_tag] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_cte] = {
    .visible = true,
    .named = true,
  },
  [sym_select_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_insert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_update_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_truncate_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_begin_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_commit_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_rollback_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_schema_rename_action] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_owner_action] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_schema] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_action_alter_column] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_action_add] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_action_set] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_rename_column] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_action] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_pg_command] = {
    .visible = true,
    .named = true,
  },
  [sym__compound_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_declare_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_external_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizer_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_parallel_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_null_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_deterministic_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_sql_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_sql_security_hint] = {
    .visible = true,
    .named = true,
  },
  [sym__function_language] = {
    .visible = false,
    .named = true,
  },
  [sym__create_function_return_type] = {
    .visible = false,
    .named = true,
  },
  [sym_setof] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type] = {
    .visible = true,
    .named = true,
  },
  [sym_create_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_create_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_create_trigger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_preferencing] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_time] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_event] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_order] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_body] = {
    .visible = true,
    .named = true,
  },
  [sym_create_extension_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_role_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_schema_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_set_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_grant_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_domain_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_type_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec_composite] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec_range] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec_base] = {
    .visible = true,
    .named = true,
  },
  [sym_create_index_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_create_index_include_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_create_index_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_table_column] = {
    .visible = true,
    .named = true,
  },
  [sym_auto_increment_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_direction_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_named_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym__column_default_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_default_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_table_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_mode] = {
    .visible = true,
    .named = true,
  },
  [sym_initial_mode] = {
    .visible = true,
    .named = true,
  },
  [sym__table_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym_table_constraint_check] = {
    .visible = true,
    .named = true,
  },
  [sym_op_class] = {
    .visible = true,
    .named = true,
  },
  [sym_exclude_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constraint_exclude] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constraint_foreign_key] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constraint_unique] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constraint_primary_key] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_key_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_create_table_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_using_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_index_table_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_create_view_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_view_columns] = {
    .visible = true,
    .named = true,
  },
  [sym_view_option] = {
    .visible = true,
    .named = true,
  },
  [sym_view_options] = {
    .visible = true,
    .named = true,
  },
  [sym_view_check_option] = {
    .visible = true,
    .named = true,
  },
  [sym_view_body] = {
    .visible = true,
    .named = true,
  },
  [sym_create_materialized_view_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_tablespace_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_data_hint] = {
    .visible = true,
    .named = true,
  },
  [sym__select_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_group_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_having_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_group_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_grouping_sets_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_rollup_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_cube_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_order_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_window_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_order_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_limit_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_offset_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_fetch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_alias] = {
    .visible = true,
    .named = true,
  },
  [sym__aliased_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_column_names] = {
    .visible = true,
    .named = true,
  },
  [sym_column_definitions] = {
    .visible = true,
    .named = true,
  },
  [sym__aliasable_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_select_clause_body] = {
    .visible = true,
    .named = true,
  },
  [sym_select_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_from_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_item] = {
    .visible = false,
    .named = true,
  },
  [sym_tablesample_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_repeatable_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_rows_from_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_join_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_join_type] = {
    .visible = true,
    .named = true,
  },
  [sym_join_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_select_subexpression] = {
    .visible = true,
    .named = true,
  },
  [sym__update_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_set_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_set_clause_body] = {
    .visible = true,
    .named = true,
  },
  [sym_assigment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__insert_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_values_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_values_clause_item] = {
    .visible = true,
    .named = true,
  },
  [sym__delete_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_in_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_references_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_on_update_action] = {
    .visible = true,
    .named = true,
  },
  [sym_on_delete_action] = {
    .visible = true,
    .named = true,
  },
  [sym__constraint_action] = {
    .visible = false,
    .named = true,
  },
  [sym_unique_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_null_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_check_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__function_call_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_within_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_filter_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_over_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_window_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_partition_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_frame_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_frame_kind] = {
    .visible = true,
    .named = true,
  },
  [sym_frame_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_frame_exclusion] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_with_ordinality] = {
    .visible = true,
    .named = true,
  },
  [sym_is_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_distinct_from] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_at_time_zone_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_NULL] = {
    .visible = true,
    .named = true,
  },
  [sym_TRUE] = {
    .visible = true,
    .named = true,
  },
  [sym_FALSE] = {
    .visible = true,
    .named = true,
  },
  [sym__quoted_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_json_access] = {
    .visible = true,
    .named = true,
  },
  [sym_ordered_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_type_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_array_element_access] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_interval_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_reference] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_truncate_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__compound_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_function_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_function_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trigger_preferencing_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trigger_event_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trigger_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_extension_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_grant_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_domain_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_spec_composite_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_spec_range_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_spec_base_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_column_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_constraint_exclude_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_index_table_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_view_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__select_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_group_by_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_grouping_sets_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rollup_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_column_definitions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_clause_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_from_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rows_from_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_clause_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_values_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conditional_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_references_constraint_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_ALTER_COLUMN] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_BY] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_CHECK] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_CREATE_EXTENSION] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_CREATE_SCHEMA] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_DEFERRABLE] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_DEFINER] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_DISTINCT_FROM] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_EXCLUDE_CURRENT_ROW] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_EXCLUDE_GROUP] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_EXISTS] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_FROM] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_FUNCTION] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_IF] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_IF_EXISTS] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_INVOKER] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_MATERIALIZED] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_MATERIALIZED_VIEW] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_NOT] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_NO_SQL] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_OF] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_ON_DELETE] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_ON_UPDATE] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_OR] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_PRECEDING] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_PROCEDURE] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_RENAME_TO] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_ROWS] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_SET_DEFAULT] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_SET_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_UNBOUNDED_FOLLOWING] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_WITH] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_WITHOUT] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_alter_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_default] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_default] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_version] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_action = 1,
  field_argmode = 2,
  field_arguments = 3,
  field_begin_label = 4,
  field_content = 5,
  field_elements = 6,
  field_end_label = 7,
  field_frame_end = 8,
  field_frame_start = 9,
  field_function = 10,
  field_into = 11,
  field_kind = 12,
  field_left = 13,
  field_link_symbol = 14,
  field_name = 15,
  field_obj_file = 16,
  field_on_table = 17,
  field_operand = 18,
  field_operator = 19,
  field_order = 20,
  field_replace = 21,
  field_right = 22,
  field_scope = 23,
  field_script = 24,
  field_seed = 25,
  field_storage_parameter = 26,
  field_table_name = 27,
  field_target = 28,
  field_type = 29,
  field_type_name = 30,
  field_value = 31,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_action] = "action",
  [field_argmode] = "argmode",
  [field_arguments] = "arguments",
  [field_begin_label] = "begin_label",
  [field_content] = "content",
  [field_elements] = "elements",
  [field_end_label] = "end_label",
  [field_frame_end] = "frame_end",
  [field_frame_start] = "frame_start",
  [field_function] = "function",
  [field_into] = "into",
  [field_kind] = "kind",
  [field_left] = "left",
  [field_link_symbol] = "link_symbol",
  [field_name] = "name",
  [field_obj_file] = "obj_file",
  [field_on_table] = "on_table",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_order] = "order",
  [field_replace] = "replace",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_script] = "script",
  [field_seed] = "seed",
  [field_storage_parameter] = "storage_parameter",
  [field_table_name] = "table_name",
  [field_target] = "target",
  [field_type] = "type",
  [field_type_name] = "type_name",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [6] = {.index = 0, .length = 1},
  [10] = {.index = 1, .length = 2},
  [12] = {.index = 3, .length = 2},
  [13] = {.index = 5, .length = 1},
  [14] = {.index = 6, .length = 1},
  [19] = {.index = 7, .length = 3},
  [20] = {.index = 10, .length = 2},
  [21] = {.index = 12, .length = 3},
  [22] = {.index = 15, .length = 1},
  [23] = {.index = 16, .length = 1},
  [24] = {.index = 17, .length = 2},
  [25] = {.index = 19, .length = 1},
  [26] = {.index = 20, .length = 1},
  [27] = {.index = 21, .length = 3},
  [35] = {.index = 24, .length = 2},
  [37] = {.index = 26, .length = 1},
  [38] = {.index = 26, .length = 1},
  [39] = {.index = 27, .length = 1},
  [40] = {.index = 28, .length = 1},
  [41] = {.index = 29, .length = 1},
  [42] = {.index = 30, .length = 3},
  [43] = {.index = 33, .length = 4},
  [44] = {.index = 37, .length = 2},
  [45] = {.index = 39, .length = 3},
  [46] = {.index = 42, .length = 1},
  [47] = {.index = 43, .length = 2},
  [48] = {.index = 45, .length = 2},
  [50] = {.index = 47, .length = 2},
  [56] = {.index = 49, .length = 1},
  [57] = {.index = 50, .length = 1},
  [66] = {.index = 51, .length = 1},
  [67] = {.index = 52, .length = 2},
  [71] = {.index = 54, .length = 3},
  [72] = {.index = 57, .length = 4},
  [73] = {.index = 61, .length = 3},
  [74] = {.index = 64, .length = 2},
  [75] = {.index = 66, .length = 2},
  [76] = {.index = 68, .length = 1},
  [79] = {.index = 69, .length = 1},
  [82] = {.index = 70, .length = 1},
  [83] = {.index = 71, .length = 2},
  [84] = {.index = 73, .length = 2},
  [88] = {.index = 75, .length = 2},
  [94] = {.index = 77, .length = 1},
  [95] = {.index = 78, .length = 2},
  [98] = {.index = 80, .length = 1},
  [99] = {.index = 81, .length = 1},
  [100] = {.index = 82, .length = 2},
  [101] = {.index = 84, .length = 2},
  [102] = {.index = 86, .length = 4},
  [103] = {.index = 90, .length = 3},
  [104] = {.index = 93, .length = 3},
  [105] = {.index = 96, .length = 1},
  [107] = {.index = 97, .length = 2},
  [108] = {.index = 99, .length = 1},
  [110] = {.index = 49, .length = 1},
  [112] = {.index = 100, .length = 1},
  [115] = {.index = 101, .length = 1},
  [116] = {.index = 101, .length = 1},
  [117] = {.index = 101, .length = 1},
  [118] = {.index = 101, .length = 1},
  [119] = {.index = 101, .length = 1},
  [120] = {.index = 101, .length = 1},
  [121] = {.index = 101, .length = 1},
  [122] = {.index = 101, .length = 1},
  [123] = {.index = 101, .length = 1},
  [124] = {.index = 101, .length = 1},
  [125] = {.index = 101, .length = 1},
  [126] = {.index = 101, .length = 1},
  [127] = {.index = 101, .length = 1},
  [128] = {.index = 101, .length = 1},
  [129] = {.index = 101, .length = 1},
  [130] = {.index = 101, .length = 1},
  [131] = {.index = 101, .length = 1},
  [132] = {.index = 101, .length = 1},
  [133] = {.index = 101, .length = 1},
  [134] = {.index = 102, .length = 2},
  [136] = {.index = 104, .length = 2},
  [137] = {.index = 106, .length = 1},
  [138] = {.index = 107, .length = 2},
  [139] = {.index = 109, .length = 4},
  [141] = {.index = 113, .length = 1},
  [148] = {.index = 49, .length = 1},
  [149] = {.index = 114, .length = 1},
  [151] = {.index = 115, .length = 1},
  [152] = {.index = 116, .length = 2},
  [153] = {.index = 116, .length = 2},
  [154] = {.index = 116, .length = 2},
  [155] = {.index = 116, .length = 2},
  [156] = {.index = 116, .length = 2},
  [157] = {.index = 116, .length = 2},
  [158] = {.index = 116, .length = 2},
  [159] = {.index = 116, .length = 2},
  [160] = {.index = 116, .length = 2},
  [161] = {.index = 116, .length = 2},
  [162] = {.index = 116, .length = 2},
  [163] = {.index = 116, .length = 2},
  [164] = {.index = 116, .length = 2},
  [165] = {.index = 116, .length = 2},
  [166] = {.index = 116, .length = 2},
  [167] = {.index = 116, .length = 2},
  [168] = {.index = 116, .length = 2},
  [169] = {.index = 116, .length = 2},
  [170] = {.index = 116, .length = 2},
  [171] = {.index = 118, .length = 2},
  [172] = {.index = 120, .length = 2},
  [173] = {.index = 122, .length = 2},
  [175] = {.index = 124, .length = 1},
  [176] = {.index = 19, .length = 1},
  [184] = {.index = 125, .length = 2},
  [185] = {.index = 127, .length = 1},
  [186] = {.index = 127, .length = 1},
  [187] = {.index = 127, .length = 1},
  [188] = {.index = 127, .length = 1},
  [189] = {.index = 127, .length = 1},
  [190] = {.index = 127, .length = 1},
  [191] = {.index = 128, .length = 2},
  [192] = {.index = 130, .length = 2},
  [193] = {.index = 132, .length = 2},
  [195] = {.index = 19, .length = 1},
  [196] = {.index = 96, .length = 1},
  [200] = {.index = 134, .length = 1},
  [201] = {.index = 134, .length = 1},
  [202] = {.index = 135, .length = 2},
  [205] = {.index = 137, .length = 2},
  [206] = {.index = 139, .length = 2},
  [207] = {.index = 139, .length = 2},
  [208] = {.index = 139, .length = 2},
  [209] = {.index = 139, .length = 2},
  [210] = {.index = 139, .length = 2},
  [211] = {.index = 139, .length = 2},
  [212] = {.index = 141, .length = 2},
  [213] = {.index = 143, .length = 1},
  [214] = {.index = 144, .length = 2},
  [215] = {.index = 146, .length = 2},
  [216] = {.index = 96, .length = 1},
  [217] = {.index = 113, .length = 1},
  [222] = {.index = 148, .length = 2},
  [223] = {.index = 150, .length = 1},
  [224] = {.index = 150, .length = 1},
  [225] = {.index = 151, .length = 2},
  [226] = {.index = 113, .length = 1},
  [229] = {.index = 101, .length = 1},
  [230] = {.index = 101, .length = 1},
  [231] = {.index = 101, .length = 1},
  [232] = {.index = 101, .length = 1},
  [233] = {.index = 101, .length = 1},
  [234] = {.index = 101, .length = 1},
  [235] = {.index = 153, .length = 2},
  [236] = {.index = 155, .length = 2},
  [237] = {.index = 155, .length = 2},
  [240] = {.index = 157, .length = 2},
  [241] = {.index = 159, .length = 3},
  [242] = {.index = 159, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_type_name, 2},
  [1] =
    {field_kind, 1},
    {field_target, 2},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_into, 1, .inherited = true},
  [6] =
    {field_name, 1},
  [7] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 3},
  [10] =
    {field_kind, 1},
    {field_target, 3},
  [12] =
    {field_kind, 1},
    {field_target, 2},
    {field_target, 3},
  [15] =
    {field_content, 1},
  [16] =
    {field_into, 2},
  [17] =
    {field_into, 0, .inherited = true},
    {field_into, 1, .inherited = true},
  [19] =
    {field_type, 2},
  [20] =
    {field_function, 0},
  [21] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [24] =
    {field_begin_label, 0, .inherited = true},
    {field_end_label, 0, .inherited = true},
  [26] =
    {field_replace, 1},
  [27] =
    {field_table_name, 3},
  [28] =
    {field_name, 1, .inherited = true},
  [29] =
    {field_scope, 1},
  [30] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 4},
  [33] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 3},
    {field_target, 4},
  [37] =
    {field_kind, 1},
    {field_target, 4},
  [39] =
    {field_kind, 1},
    {field_target, 3},
    {field_target, 4},
  [42] =
    {field_function, 1},
  [43] =
    {field_into, 2},
    {field_into, 3, .inherited = true},
  [45] =
    {field_arguments, 2},
    {field_function, 0},
  [47] =
    {field_name, 0},
    {field_type, 1},
  [49] =
    {field_argmode, 0},
  [50] =
    {field_script, 1},
  [51] =
    {field_table_name, 4},
  [52] =
    {field_name, 2},
    {field_table_name, 4},
  [54] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 5},
  [57] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 4},
    {field_target, 5},
  [61] =
    {field_kind, 1},
    {field_target, 4},
    {field_target, 5},
  [64] =
    {field_kind, 1},
    {field_target, 5},
  [66] =
    {field_arguments, 3},
    {field_function, 1},
  [68] =
    {field_into, 3},
  [69] =
    {field_elements, 1},
  [70] =
    {field_name, 2, .inherited = true},
  [71] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [73] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
  [75] =
    {field_link_symbol, 2},
    {field_obj_file, 1},
  [77] =
    {field_value, 2, .inherited = true},
  [78] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [80] =
    {field_order, 1},
  [81] =
    {field_table_name, 5},
  [82] =
    {field_name, 3},
    {field_table_name, 5},
  [84] =
    {field_name, 2},
    {field_table_name, 5},
  [86] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 5},
    {field_target, 6},
  [90] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 6},
  [93] =
    {field_kind, 1},
    {field_target, 5},
    {field_target, 6},
  [96] =
    {field_type, 3},
  [97] =
    {field_elements, 1},
    {field_elements, 2},
  [99] =
    {field_frame_start, 1},
  [100] =
    {field_end_label, 3},
  [101] =
    {field_value, 3},
  [102] =
    {field_name, 2},
    {field_on_table, 6},
  [104] =
    {field_name, 3},
    {field_table_name, 6},
  [106] =
    {field_table_name, 6},
  [107] =
    {field_name, 4},
    {field_table_name, 6},
  [109] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 6},
    {field_target, 7},
  [113] =
    {field_type, 4},
  [114] =
    {field_end_label, 4},
  [115] =
    {field_begin_label, 0},
  [116] =
    {field_value, 3},
    {field_value, 4, .inherited = true},
  [118] =
    {field_name, 3},
    {field_on_table, 7},
  [120] =
    {field_name, 5},
    {field_table_name, 7},
  [122] =
    {field_name, 4},
    {field_table_name, 7},
  [124] =
    {field_seed, 2},
  [125] =
    {field_begin_label, 0},
    {field_end_label, 5},
  [127] =
    {field_value, 5},
  [128] =
    {field_name, 4},
    {field_on_table, 8},
  [130] =
    {field_name, 5},
    {field_table_name, 8},
  [132] =
    {field_name, 6},
    {field_table_name, 8},
  [134] =
    {field_action, 2},
  [135] =
    {field_frame_end, 4},
    {field_frame_start, 2},
  [137] =
    {field_begin_label, 0},
    {field_end_label, 6},
  [139] =
    {field_value, 5},
    {field_value, 6, .inherited = true},
  [141] =
    {field_name, 5},
    {field_on_table, 9},
  [143] =
    {field_storage_parameter, 2},
  [144] =
    {field_name, 6},
    {field_table_name, 9},
  [146] =
    {field_name, 7},
    {field_table_name, 9},
  [148] =
    {field_name, 6},
    {field_on_table, 10},
  [150] =
    {field_function, 2},
  [151] =
    {field_name, 7},
    {field_table_name, 10},
  [153] =
    {field_name, 7},
    {field_on_table, 11},
  [155] =
    {field_arguments, 4},
    {field_function, 2},
  [157] =
    {field_name, 8},
    {field_on_table, 12},
  [159] =
    {field_arguments, 4},
    {field_arguments, 5},
    {field_function, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = anon_alias_sym_WITH,
  },
  [2] = {
    [1] = alias_sym_alter_sequence,
  },
  [3] = {
    [0] = anon_alias_sym_NULL,
  },
  [4] = {
    [0] = anon_alias_sym_CREATE_EXTENSION,
    [1] = anon_alias_sym_CREATE_EXTENSION,
  },
  [5] = {
    [0] = anon_alias_sym_CREATE_SCHEMA,
    [1] = anon_alias_sym_CREATE_SCHEMA,
  },
  [6] = {
    [0] = aux_sym_create_function_statement_token6,
  },
  [7] = {
    [0] = aux_sym_create_role_statement_token1,
  },
  [8] = {
    [0] = aux_sym_create_domain_statement_token1,
  },
  [9] = {
    [0] = anon_alias_sym_FROM,
  },
  [11] = {
    [0] = anon_alias_sym_NOT,
  },
  [15] = {
    [0] = anon_alias_sym_CREATE_EXTENSION,
    [1] = anon_alias_sym_CREATE_EXTENSION,
    [3] = anon_alias_sym_WITH,
  },
  [16] = {
    [0] = aux_sym_comment_statement_token6,
    [1] = aux_sym_comment_statement_token6,
  },
  [17] = {
    [0] = aux_sym_create_function_statement_token2,
    [1] = aux_sym_create_function_statement_token2,
  },
  [18] = {
    [0] = aux_sym_create_role_statement_token1,
    [3] = anon_alias_sym_WITH,
  },
  [19] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
  },
  [28] = {
    [1] = anon_alias_sym_OR,
  },
  [29] = {
    [0] = aux_sym_sequence_token4,
  },
  [30] = {
    [1] = aux_sym_order_by_clause_token1,
  },
  [31] = {
    [2] = anon_alias_sym_ROWS,
  },
  [32] = {
    [0] = aux_sym_cte_token3,
    [2] = aux_sym_cte_token3,
  },
  [33] = {
    [1] = sym_alter_schema,
  },
  [34] = {
    [1] = alias_sym_version,
  },
  [36] = {
    [1] = anon_alias_sym_IF,
    [2] = anon_alias_sym_EXISTS,
  },
  [37] = {
    [0] = aux_sym_comment_statement_token6,
    [1] = aux_sym_comment_statement_token6,
  },
  [38] = {
    [0] = aux_sym_create_function_statement_token2,
    [1] = aux_sym_create_function_statement_token2,
  },
  [42] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
  },
  [43] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
  },
  [44] = {
    [2] = anon_alias_sym_IF_EXISTS,
    [3] = anon_alias_sym_IF_EXISTS,
  },
  [49] = {
    [1] = anon_alias_sym_NOT,
  },
  [51] = {
    [2] = anon_alias_sym_NOT,
  },
  [52] = {
    [1] = aux_sym_comment_statement_token1,
  },
  [53] = {
    [1] = aux_sym_comment_statement_token1,
    [2] = anon_alias_sym_FUNCTION,
  },
  [54] = {
    [0] = anon_alias_sym_CHECK,
  },
  [55] = {
    [0] = anon_alias_sym_DEFERRABLE,
  },
  [58] = {
    [0] = anon_alias_sym_NO_SQL,
    [1] = anon_alias_sym_NO_SQL,
  },
  [59] = {
    [0] = anon_alias_sym_ROWS,
  },
  [60] = {
    [0] = aux_sym_external_hint_token4,
    [1] = aux_sym_external_hint_token4,
  },
  [61] = {
    [1] = aux_sym_sql_hint_token1,
  },
  [62] = {
    [1] = anon_alias_sym_IF,
    [2] = anon_alias_sym_NOT,
    [3] = anon_alias_sym_EXISTS,
  },
  [63] = {
    [1] = anon_alias_sym_WITH,
  },
  [64] = {
    [1] = anon_alias_sym_BY,
  },
  [65] = {
    [1] = aux_sym_sequence_token9,
  },
  [68] = {
    [1] = anon_alias_sym_IF_EXISTS,
    [2] = anon_alias_sym_IF_EXISTS,
  },
  [69] = {
    [1] = aux_sym_alter_owner_action_token1,
  },
  [70] = {
    [0] = anon_alias_sym_RENAME_TO,
    [1] = anon_alias_sym_RENAME_TO,
  },
  [71] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
    [3] = anon_alias_sym_IF_EXISTS,
    [4] = anon_alias_sym_IF_EXISTS,
  },
  [72] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
  },
  [73] = {
    [2] = anon_alias_sym_IF_EXISTS,
    [3] = anon_alias_sym_IF_EXISTS,
  },
  [74] = {
    [3] = anon_alias_sym_IF_EXISTS,
    [4] = anon_alias_sym_IF_EXISTS,
  },
  [77] = {
    [0] = aux_sym_with_ordinality_token1,
  },
  [78] = {
    [0] = anon_alias_sym_DISTINCT_FROM,
    [1] = anon_alias_sym_DISTINCT_FROM,
  },
  [80] = {
    [2] = aux_sym_at_time_zone_expression_token1,
    [3] = aux_sym_at_time_zone_expression_token1,
  },
  [81] = {
    [2] = anon_alias_sym_MATERIALIZED,
  },
  [85] = {
    [0] = aux_sym_mode_token1,
  },
  [86] = {
    [0] = anon_alias_sym_CREATE_EXTENSION,
    [1] = anon_alias_sym_CREATE_EXTENSION,
    [6] = anon_alias_sym_WITH,
  },
  [87] = {
    [2] = alias_sym_default,
  },
  [89] = {
    [1] = aux_sym_external_hint_token4,
  },
  [90] = {
    [1] = aux_sym_sql_hint_token2,
    [2] = anon_alias_sym_INVOKER,
  },
  [91] = {
    [1] = aux_sym_sql_hint_token2,
    [2] = anon_alias_sym_DEFINER,
  },
  [92] = {
    [1] = aux_sym_sql_hint_token3,
    [2] = aux_sym_sql_hint_token3,
  },
  [93] = {
    [1] = aux_sym_sql_hint_token5,
    [2] = aux_sym_sql_hint_token5,
  },
  [96] = {
    [1] = anon_alias_sym_OF,
  },
  [97] = {
    [0] = anon_alias_sym_WITH,
    [2] = aux_sym_table_constraint_check_token1,
  },
  [102] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
    [3] = anon_alias_sym_IF_EXISTS,
    [4] = anon_alias_sym_IF_EXISTS,
  },
  [103] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
    [4] = anon_alias_sym_IF_EXISTS,
    [5] = anon_alias_sym_IF_EXISTS,
  },
  [104] = {
    [3] = anon_alias_sym_IF_EXISTS,
    [4] = anon_alias_sym_IF_EXISTS,
  },
  [106] = {
    [1] = anon_alias_sym_WITHOUT,
  },
  [109] = {
    [2] = anon_alias_sym_NOT,
    [3] = anon_alias_sym_MATERIALIZED,
  },
  [110] = {
    [3] = alias_sym_default,
  },
  [111] = {
    [3] = alias_sym_default,
  },
  [113] = {
    [1] = aux_sym_create_function_statement_token4,
    [2] = aux_sym_create_function_statement_token4,
  },
  [114] = {
    [1] = aux_sym_null_hint_token1,
    [2] = aux_sym_null_hint_token1,
    [3] = aux_sym_null_hint_token1,
  },
  [115] = {
    [1] = anon_alias_sym_default,
    [2] = anon_alias_sym_default,
    [3] = anon_alias_sym_default,
  },
  [116] = {
    [2] = aux_sym_null_hint_token3,
    [3] = aux_sym_null_hint_token3,
  },
  [117] = {
    [2] = aux_sym_type_spec_base_token1,
    [3] = aux_sym_type_spec_base_token1,
  },
  [118] = {
    [2] = aux_sym_type_spec_base_token2,
    [3] = aux_sym_type_spec_base_token2,
  },
  [119] = {
    [2] = aux_sym_type_spec_base_token3,
    [3] = aux_sym_type_spec_base_token3,
  },
  [120] = {
    [2] = aux_sym_type_spec_base_token4,
    [3] = aux_sym_type_spec_base_token4,
  },
  [121] = {
    [2] = aux_sym_type_spec_base_token5,
    [3] = aux_sym_type_spec_base_token5,
  },
  [122] = {
    [2] = aux_sym_type_spec_base_token6,
    [3] = aux_sym_type_spec_base_token6,
  },
  [123] = {
    [2] = aux_sym_type_spec_base_token7,
    [3] = aux_sym_type_spec_base_token7,
  },
  [124] = {
    [2] = aux_sym_type_spec_base_token8,
  },
  [125] = {
    [2] = aux_sym_type_spec_base_token8,
    [3] = aux_sym_type_spec_base_token8,
  },
  [126] = {
    [2] = aux_sym_type_spec_base_token11,
    [3] = aux_sym_type_spec_base_token11,
  },
  [127] = {
    [2] = aux_sym_type_spec_base_token12,
    [3] = aux_sym_type_spec_base_token12,
  },
  [128] = {
    [2] = aux_sym_type_spec_base_token13,
    [3] = aux_sym_type_spec_base_token13,
  },
  [129] = {
    [2] = aux_sym_type_spec_base_token14,
    [3] = aux_sym_type_spec_base_token14,
  },
  [130] = {
    [2] = aux_sym_type_spec_base_token15,
    [3] = aux_sym_type_spec_base_token15,
  },
  [131] = {
    [2] = aux_sym_type_spec_base_token16,
    [3] = aux_sym_type_spec_base_token16,
  },
  [132] = {
    [2] = aux_sym_type_spec_base_token17,
    [3] = aux_sym_type_spec_base_token17,
  },
  [133] = {
    [2] = aux_sym_type_spec_base_token18,
    [3] = aux_sym_type_spec_base_token18,
  },
  [135] = {
    [0] = anon_alias_sym_WITH,
    [2] = aux_sym_table_constraint_check_token1,
    [3] = aux_sym_table_constraint_check_token1,
  },
  [139] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
    [4] = anon_alias_sym_IF_EXISTS,
    [5] = anon_alias_sym_IF_EXISTS,
  },
  [140] = {
    [6] = aux_sym_with_clause_token1,
    [7] = aux_sym_with_clause_token1,
  },
  [142] = {
    [2] = anon_alias_sym_WITH,
  },
  [143] = {
    [2] = anon_alias_sym_WITHOUT,
  },
  [144] = {
    [1] = aux_sym_partition_by_clause_token1,
  },
  [145] = {
    [0] = anon_alias_sym_UNBOUNDED_FOLLOWING,
    [1] = anon_alias_sym_UNBOUNDED_FOLLOWING,
  },
  [146] = {
    [1] = aux_sym_frame_bound_token3,
  },
  [147] = {
    [1] = anon_alias_sym_PRECEDING,
  },
  [148] = {
    [4] = alias_sym_default,
  },
  [150] = {
    [0] = aux_sym_null_hint_token2,
    [2] = aux_sym_null_hint_token2,
    [4] = aux_sym_null_hint_token2,
  },
  [152] = {
    [1] = anon_alias_sym_default,
    [2] = anon_alias_sym_default,
    [3] = anon_alias_sym_default,
  },
  [153] = {
    [2] = aux_sym_null_hint_token3,
    [3] = aux_sym_null_hint_token3,
  },
  [154] = {
    [2] = aux_sym_type_spec_base_token1,
    [3] = aux_sym_type_spec_base_token1,
  },
  [155] = {
    [2] = aux_sym_type_spec_base_token2,
    [3] = aux_sym_type_spec_base_token2,
  },
  [156] = {
    [2] = aux_sym_type_spec_base_token3,
    [3] = aux_sym_type_spec_base_token3,
  },
  [157] = {
    [2] = aux_sym_type_spec_base_token4,
    [3] = aux_sym_type_spec_base_token4,
  },
  [158] = {
    [2] = aux_sym_type_spec_base_token5,
    [3] = aux_sym_type_spec_base_token5,
  },
  [159] = {
    [2] = aux_sym_type_spec_base_token6,
    [3] = aux_sym_type_spec_base_token6,
  },
  [160] = {
    [2] = aux_sym_type_spec_base_token7,
    [3] = aux_sym_type_spec_base_token7,
  },
  [161] = {
    [2] = aux_sym_type_spec_base_token8,
  },
  [162] = {
    [2] = aux_sym_type_spec_base_token8,
    [3] = aux_sym_type_spec_base_token8,
  },
  [163] = {
    [2] = aux_sym_type_spec_base_token11,
    [3] = aux_sym_type_spec_base_token11,
  },
  [164] = {
    [2] = aux_sym_type_spec_base_token12,
    [3] = aux_sym_type_spec_base_token12,
  },
  [165] = {
    [2] = aux_sym_type_spec_base_token13,
    [3] = aux_sym_type_spec_base_token13,
  },
  [166] = {
    [2] = aux_sym_type_spec_base_token14,
    [3] = aux_sym_type_spec_base_token14,
  },
  [167] = {
    [2] = aux_sym_type_spec_base_token15,
    [3] = aux_sym_type_spec_base_token15,
  },
  [168] = {
    [2] = aux_sym_type_spec_base_token16,
    [3] = aux_sym_type_spec_base_token16,
  },
  [169] = {
    [2] = aux_sym_type_spec_base_token17,
    [3] = aux_sym_type_spec_base_token17,
  },
  [170] = {
    [2] = aux_sym_type_spec_base_token18,
    [3] = aux_sym_type_spec_base_token18,
  },
  [174] = {
    [0] = anon_alias_sym_ALTER_COLUMN,
    [1] = anon_alias_sym_ALTER_COLUMN,
    [3] = anon_alias_sym_SET_DEFAULT,
    [4] = anon_alias_sym_SET_DEFAULT,
  },
  [176] = {
    [6] = aux_sym_with_clause_token1,
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
  },
  [177] = {
    [6] = aux_sym_with_clause_token1,
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
  },
  [178] = {
    [3] = anon_alias_sym_WITH,
  },
  [179] = {
    [3] = anon_alias_sym_WITHOUT,
  },
  [180] = {
    [1] = aux_sym_within_group_clause_token1,
  },
  [181] = {
    [0] = anon_alias_sym_EXCLUDE_GROUP,
    [1] = anon_alias_sym_EXCLUDE_GROUP,
  },
  [182] = {
    [0] = aux_sym_frame_exclusion_token1,
  },
  [183] = {
    [1] = aux_sym_table_constraint_foreign_key_token1,
  },
  [185] = {
    [4] = aux_sym_type_spec_range_token2,
    [5] = aux_sym_type_spec_range_token2,
  },
  [186] = {
    [4] = aux_sym_type_spec_range_token3,
    [5] = aux_sym_type_spec_range_token3,
  },
  [187] = {
    [4] = aux_sym_type_spec_range_token4,
    [5] = aux_sym_type_spec_range_token4,
  },
  [188] = {
    [4] = aux_sym_type_spec_range_token5,
    [5] = aux_sym_type_spec_range_token5,
  },
  [189] = {
    [4] = aux_sym_type_spec_range_token6,
    [5] = aux_sym_type_spec_range_token6,
  },
  [190] = {
    [4] = aux_sym_type_spec_range_token7,
    [5] = aux_sym_type_spec_range_token7,
  },
  [194] = {
    [3] = anon_alias_sym_ROWS,
  },
  [195] = {
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
  },
  [196] = {
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
  },
  [197] = {
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
  },
  [198] = {
    [4] = anon_alias_sym_WITH,
  },
  [199] = {
    [4] = anon_alias_sym_WITHOUT,
  },
  [200] = {
    [0] = anon_alias_sym_ON_DELETE,
    [1] = anon_alias_sym_ON_DELETE,
  },
  [201] = {
    [0] = anon_alias_sym_ON_UPDATE,
    [1] = anon_alias_sym_ON_UPDATE,
  },
  [203] = {
    [0] = aux_sym_frame_exclusion_token2,
    [1] = aux_sym_frame_exclusion_token2,
  },
  [204] = {
    [0] = anon_alias_sym_EXCLUDE_CURRENT_ROW,
    [1] = anon_alias_sym_EXCLUDE_CURRENT_ROW,
    [2] = anon_alias_sym_EXCLUDE_CURRENT_ROW,
  },
  [206] = {
    [4] = aux_sym_type_spec_range_token2,
    [5] = aux_sym_type_spec_range_token2,
  },
  [207] = {
    [4] = aux_sym_type_spec_range_token3,
    [5] = aux_sym_type_spec_range_token3,
  },
  [208] = {
    [4] = aux_sym_type_spec_range_token4,
    [5] = aux_sym_type_spec_range_token4,
  },
  [209] = {
    [4] = aux_sym_type_spec_range_token5,
    [5] = aux_sym_type_spec_range_token5,
  },
  [210] = {
    [4] = aux_sym_type_spec_range_token6,
    [5] = aux_sym_type_spec_range_token6,
  },
  [211] = {
    [4] = aux_sym_type_spec_range_token7,
    [5] = aux_sym_type_spec_range_token7,
  },
  [213] = {
    [0] = anon_alias_sym_WITH,
  },
  [216] = {
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
    [10] = aux_sym_with_clause_token1,
  },
  [217] = {
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
    [10] = aux_sym_with_clause_token1,
  },
  [218] = {
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
    [10] = aux_sym_with_clause_token1,
  },
  [219] = {
    [5] = anon_alias_sym_WITH,
  },
  [220] = {
    [5] = anon_alias_sym_WITHOUT,
  },
  [221] = {
    [0] = anon_alias_sym_SET_NULL,
    [1] = anon_alias_sym_SET_NULL,
  },
  [223] = {
    [1] = anon_alias_sym_FUNCTION,
  },
  [224] = {
    [1] = anon_alias_sym_PROCEDURE,
  },
  [226] = {
    [9] = aux_sym_with_clause_token1,
    [10] = aux_sym_with_clause_token1,
  },
  [227] = {
    [6] = anon_alias_sym_WITH,
  },
  [228] = {
    [6] = anon_alias_sym_WITHOUT,
  },
  [229] = {
    [2] = aux_sym_type_spec_range_token2,
    [3] = aux_sym_type_spec_range_token2,
  },
  [230] = {
    [2] = aux_sym_type_spec_range_token3,
    [3] = aux_sym_type_spec_range_token3,
  },
  [231] = {
    [2] = aux_sym_type_spec_range_token4,
    [3] = aux_sym_type_spec_range_token4,
  },
  [232] = {
    [2] = aux_sym_type_spec_range_token5,
    [3] = aux_sym_type_spec_range_token5,
  },
  [233] = {
    [2] = aux_sym_type_spec_range_token6,
    [3] = aux_sym_type_spec_range_token6,
  },
  [234] = {
    [2] = aux_sym_type_spec_range_token7,
    [3] = aux_sym_type_spec_range_token7,
  },
  [236] = {
    [1] = anon_alias_sym_FUNCTION,
  },
  [237] = {
    [1] = anon_alias_sym_PROCEDURE,
  },
  [238] = {
    [7] = anon_alias_sym_WITH,
  },
  [239] = {
    [7] = anon_alias_sym_WITHOUT,
  },
  [241] = {
    [1] = anon_alias_sym_FUNCTION,
  },
  [242] = {
    [1] = anon_alias_sym_PROCEDURE,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_sequence, 2,
    sym_sequence,
    alias_sym_alter_sequence,
  sym__identifier, 21,
    sym__identifier,
    aux_sym_null_hint_token3,
    aux_sym_type_spec_base_token1,
    aux_sym_type_spec_base_token11,
    aux_sym_type_spec_base_token12,
    aux_sym_type_spec_base_token13,
    aux_sym_type_spec_base_token16,
    aux_sym_type_spec_base_token18,
    aux_sym_type_spec_base_token2,
    aux_sym_type_spec_base_token3,
    aux_sym_type_spec_base_token4,
    aux_sym_type_spec_base_token5,
    aux_sym_type_spec_base_token6,
    aux_sym_type_spec_base_token7,
    aux_sym_type_spec_range_token2,
    aux_sym_type_spec_range_token3,
    aux_sym_type_spec_range_token4,
    aux_sym_type_spec_range_token5,
    aux_sym_type_spec_range_token6,
    aux_sym_type_spec_range_token7,
    sym_alter_schema,
  sym_string, 5,
    sym_string,
    alias_sym_version,
    aux_sym_type_spec_base_token14,
    aux_sym_type_spec_base_token15,
    aux_sym_type_spec_base_token17,
  sym__expression, 3,
    sym__expression,
    alias_sym_default,
    anon_alias_sym_default,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(2499);
      if (lookahead == '!') ADVANCE(716);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3753);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(2594);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == 'C') ADVANCE(1101);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(3731);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(1128);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1329);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1368);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1145);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1129);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1131);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1564);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1369);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1133);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1134);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1156);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1565);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1135);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1147);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1136);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1190);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1843);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1146);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1627);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1975);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3770);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(714)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(714)
      if (lookahead == '\r') SKIP(1)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(903)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(903)
      if (lookahead == '\r') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(950)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(950)
      if (lookahead == '\r') SKIP(5)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(779)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(779)
      if (lookahead == '\r') SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(951)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(951)
      if (lookahead == '\r') SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(748)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(748)
      if (lookahead == '\r') SKIP(11)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(848)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(848)
      if (lookahead == '\r') SKIP(13)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(878)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(878)
      if (lookahead == '\r') SKIP(15)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(781)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(781)
      if (lookahead == '\r') SKIP(17)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(752)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(752)
      if (lookahead == '\r') SKIP(19)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(833)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(833)
      if (lookahead == '\r') SKIP(21)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(772)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(772)
      if (lookahead == '\r') SKIP(23)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(824)
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(824)
      if (lookahead == '\r') SKIP(25)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(851)
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(851)
      if (lookahead == '\r') SKIP(27)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(754)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(754)
      if (lookahead == '\r') SKIP(29)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(774)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(774)
      if (lookahead == '\r') SKIP(31)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(756)
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(756)
      if (lookahead == '\r') SKIP(33)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(853)
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(853)
      if (lookahead == '\r') SKIP(35)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(881)
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(881)
      if (lookahead == '\r') SKIP(37)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(879)
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(879)
      if (lookahead == '\r') SKIP(39)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(825)
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(825)
      if (lookahead == '\r') SKIP(41)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(962)
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(962)
      if (lookahead == '\r') SKIP(43)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(856)
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(856)
      if (lookahead == '\r') SKIP(45)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(834)
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(834)
      if (lookahead == '\r') SKIP(47)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(859)
      END_STATE();
    case 50:
      if (lookahead == '\n') SKIP(859)
      if (lookahead == '\r') SKIP(49)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 51:
      if (lookahead == '\n') SKIP(885)
      END_STATE();
    case 52:
      if (lookahead == '\n') SKIP(885)
      if (lookahead == '\r') SKIP(51)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 53:
      if (lookahead == '\n') SKIP(776)
      END_STATE();
    case 54:
      if (lookahead == '\n') SKIP(776)
      if (lookahead == '\r') SKIP(53)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 55:
      if (lookahead == '\n') SKIP(952)
      END_STATE();
    case 56:
      if (lookahead == '\n') SKIP(952)
      if (lookahead == '\r') SKIP(55)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 57:
      if (lookahead == '\n') SKIP(785)
      END_STATE();
    case 58:
      if (lookahead == '\n') SKIP(785)
      if (lookahead == '\r') SKIP(57)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 59:
      if (lookahead == '\n') SKIP(763)
      END_STATE();
    case 60:
      if (lookahead == '\n') SKIP(763)
      if (lookahead == '\r') SKIP(59)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 61:
      if (lookahead == '\n') SKIP(953)
      END_STATE();
    case 62:
      if (lookahead == '\n') SKIP(953)
      if (lookahead == '\r') SKIP(61)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 63:
      if (lookahead == '\n') SKIP(917)
      END_STATE();
    case 64:
      if (lookahead == '\n') SKIP(917)
      if (lookahead == '\r') SKIP(63)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 65:
      if (lookahead == '\n') SKIP(902)
      END_STATE();
    case 66:
      if (lookahead == '\n') SKIP(902)
      if (lookahead == '\r') SKIP(65)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 67:
      if (lookahead == '\n') SKIP(922)
      END_STATE();
    case 68:
      if (lookahead == '\n') SKIP(922)
      if (lookahead == '\r') SKIP(67)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 69:
      if (lookahead == '\n') SKIP(786)
      END_STATE();
    case 70:
      if (lookahead == '\n') SKIP(786)
      if (lookahead == '\r') SKIP(69)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 71:
      if (lookahead == '\n') SKIP(906)
      END_STATE();
    case 72:
      if (lookahead == '\n') SKIP(906)
      if (lookahead == '\r') SKIP(71)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 73:
      if (lookahead == '\n') SKIP(923)
      END_STATE();
    case 74:
      if (lookahead == '\n') SKIP(923)
      if (lookahead == '\r') SKIP(73)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 75:
      if (lookahead == '\n') SKIP(764)
      END_STATE();
    case 76:
      if (lookahead == '\n') SKIP(764)
      if (lookahead == '\r') SKIP(75)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 77:
      if (lookahead == '\n') SKIP(1073)
      END_STATE();
    case 78:
      if (lookahead == '\n') SKIP(1073)
      if (lookahead == '\r') SKIP(77)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 79:
      if (lookahead == '\n') SKIP(765)
      END_STATE();
    case 80:
      if (lookahead == '\n') SKIP(765)
      if (lookahead == '\r') SKIP(79)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 81:
      if (lookahead == '\n') SKIP(907)
      END_STATE();
    case 82:
      if (lookahead == '\n') SKIP(907)
      if (lookahead == '\r') SKIP(81)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 83:
      if (lookahead == '\n') SKIP(788)
      END_STATE();
    case 84:
      if (lookahead == '\n') SKIP(788)
      if (lookahead == '\r') SKIP(83)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 85:
      if (lookahead == '\n') SKIP(766)
      END_STATE();
    case 86:
      if (lookahead == '\n') SKIP(766)
      if (lookahead == '\r') SKIP(85)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 87:
      if (lookahead == '\n') SKIP(944)
      END_STATE();
    case 88:
      if (lookahead == '\n') SKIP(944)
      if (lookahead == '\r') SKIP(87)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 89:
      if (lookahead == '\n') SKIP(767)
      END_STATE();
    case 90:
      if (lookahead == '\n') SKIP(767)
      if (lookahead == '\r') SKIP(89)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 91:
      if (lookahead == '\n') SKIP(940)
      END_STATE();
    case 92:
      if (lookahead == '\n') SKIP(940)
      if (lookahead == '\r') SKIP(91)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 93:
      if (lookahead == '\n') SKIP(791)
      END_STATE();
    case 94:
      if (lookahead == '\n') SKIP(791)
      if (lookahead == '\r') SKIP(93)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 95:
      if (lookahead == '\n') SKIP(777)
      END_STATE();
    case 96:
      if (lookahead == '\n') SKIP(777)
      if (lookahead == '\r') SKIP(95)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 97:
      if (lookahead == '\n') SKIP(918)
      END_STATE();
    case 98:
      if (lookahead == '\n') SKIP(918)
      if (lookahead == '\r') SKIP(97)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 99:
      if (lookahead == '\n') SKIP(971)
      END_STATE();
    case 100:
      if (lookahead == '\n') SKIP(971)
      if (lookahead == '\r') SKIP(99)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 101:
      if (lookahead == '\n') SKIP(904)
      END_STATE();
    case 102:
      if (lookahead == '\n') SKIP(904)
      if (lookahead == '\r') SKIP(101)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 103:
      if (lookahead == '\n') SKIP(919)
      END_STATE();
    case 104:
      if (lookahead == '\n') SKIP(919)
      if (lookahead == '\r') SKIP(103)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 105:
      if (lookahead == '\n') SKIP(941)
      END_STATE();
    case 106:
      if (lookahead == '\n') SKIP(941)
      if (lookahead == '\r') SKIP(105)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 107:
      if (lookahead == '\n') SKIP(717)
      END_STATE();
    case 108:
      if (lookahead == '\n') SKIP(717)
      if (lookahead == '\r') SKIP(107)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 109:
      if (lookahead == '\n') SKIP(942)
      END_STATE();
    case 110:
      if (lookahead == '\n') SKIP(942)
      if (lookahead == '\r') SKIP(109)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 111:
      if (lookahead == '\n') SKIP(769)
      END_STATE();
    case 112:
      if (lookahead == '\n') SKIP(769)
      if (lookahead == '\r') SKIP(111)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 113:
      if (lookahead == '\n') SKIP(920)
      END_STATE();
    case 114:
      if (lookahead == '\n') SKIP(920)
      if (lookahead == '\r') SKIP(113)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 115:
      if (lookahead == '\n') SKIP(985)
      END_STATE();
    case 116:
      if (lookahead == '\n') SKIP(985)
      if (lookahead == '\r') SKIP(115)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 117:
      if (lookahead == '\n') SKIP(908)
      END_STATE();
    case 118:
      if (lookahead == '\n') SKIP(908)
      if (lookahead == '\r') SKIP(117)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 119:
      if (lookahead == '\n') SKIP(778)
      END_STATE();
    case 120:
      if (lookahead == '\n') SKIP(778)
      if (lookahead == '\r') SKIP(119)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 121:
      if (lookahead == '\n') SKIP(905)
      END_STATE();
    case 122:
      if (lookahead == '\n') SKIP(905)
      if (lookahead == '\r') SKIP(121)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 123:
      if (lookahead == '\n') SKIP(770)
      END_STATE();
    case 124:
      if (lookahead == '\n') SKIP(770)
      if (lookahead == '\r') SKIP(123)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 125:
      if (lookahead == '\n') SKIP(1028)
      END_STATE();
    case 126:
      if (lookahead == '\n') SKIP(1028)
      if (lookahead == '\r') SKIP(125)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 127:
      if (lookahead == '\n') SKIP(972)
      END_STATE();
    case 128:
      if (lookahead == '\n') SKIP(972)
      if (lookahead == '\r') SKIP(127)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 129:
      if (lookahead == '\n') SKIP(966)
      END_STATE();
    case 130:
      if (lookahead == '\n') SKIP(966)
      if (lookahead == '\r') SKIP(129)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 131:
      if (lookahead == '\n') SKIP(910)
      END_STATE();
    case 132:
      if (lookahead == '\n') SKIP(910)
      if (lookahead == '\r') SKIP(131)
      END_STATE();
    case 133:
      if (lookahead == '\n') SKIP(945)
      END_STATE();
    case 134:
      if (lookahead == '\n') SKIP(945)
      if (lookahead == '\r') SKIP(133)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 135:
      if (lookahead == '\n') SKIP(924)
      END_STATE();
    case 136:
      if (lookahead == '\n') SKIP(924)
      if (lookahead == '\r') SKIP(135)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 137:
      if (lookahead == '\n') SKIP(921)
      END_STATE();
    case 138:
      if (lookahead == '\n') SKIP(921)
      if (lookahead == '\r') SKIP(137)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 139:
      if (lookahead == '\n') SKIP(973)
      END_STATE();
    case 140:
      if (lookahead == '\n') SKIP(973)
      if (lookahead == '\r') SKIP(139)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 141:
      if (lookahead == '\n') SKIP(912)
      END_STATE();
    case 142:
      if (lookahead == '\n') SKIP(912)
      if (lookahead == '\r') SKIP(141)
      END_STATE();
    case 143:
      if (lookahead == '\n') SKIP(956)
      END_STATE();
    case 144:
      if (lookahead == '\n') SKIP(956)
      if (lookahead == '\r') SKIP(143)
      END_STATE();
    case 145:
      if (lookahead == '\n') SKIP(726)
      END_STATE();
    case 146:
      if (lookahead == '\n') SKIP(726)
      if (lookahead == '\r') SKIP(145)
      END_STATE();
    case 147:
      if (lookahead == '\n') SKIP(990)
      END_STATE();
    case 148:
      if (lookahead == '\n') SKIP(990)
      if (lookahead == '\r') SKIP(147)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 149:
      if (lookahead == '\n') SKIP(946)
      END_STATE();
    case 150:
      if (lookahead == '\n') SKIP(946)
      if (lookahead == '\r') SKIP(149)
      END_STATE();
    case 151:
      if (lookahead == '\n') SKIP(899)
      END_STATE();
    case 152:
      if (lookahead == '\n') SKIP(899)
      if (lookahead == '\r') SKIP(151)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 153:
      if (lookahead == '\n') SKIP(1029)
      END_STATE();
    case 154:
      if (lookahead == '\n') SKIP(1029)
      if (lookahead == '\r') SKIP(153)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 155:
      if (lookahead == '\n') SKIP(1025)
      END_STATE();
    case 156:
      if (lookahead == '\n') SKIP(1025)
      if (lookahead == '\r') SKIP(155)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 157:
      if (lookahead == '\n') SKIP(967)
      END_STATE();
    case 158:
      if (lookahead == '\n') SKIP(967)
      if (lookahead == '\r') SKIP(157)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 159:
      if (lookahead == '\n') SKIP(837)
      END_STATE();
    case 160:
      if (lookahead == '\n') SKIP(837)
      if (lookahead == '\r') SKIP(159)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 161:
      if (lookahead == '\n') SKIP(722)
      END_STATE();
    case 162:
      if (lookahead == '\n') SKIP(722)
      if (lookahead == '\r') SKIP(161)
      END_STATE();
    case 163:
      if (lookahead == '\n') SKIP(968)
      END_STATE();
    case 164:
      if (lookahead == '\n') SKIP(968)
      if (lookahead == '\r') SKIP(163)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 165:
      if (lookahead == '\n') SKIP(991)
      END_STATE();
    case 166:
      if (lookahead == '\n') SKIP(991)
      if (lookahead == '\r') SKIP(165)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 167:
      if (lookahead == '\n') SKIP(832)
      END_STATE();
    case 168:
      if (lookahead == '\n') SKIP(832)
      if (lookahead == '\r') SKIP(167)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 169:
      if (lookahead == '\n') SKIP(957)
      END_STATE();
    case 170:
      if (lookahead == '\n') SKIP(957)
      if (lookahead == '\r') SKIP(169)
      END_STATE();
    case 171:
      if (lookahead == '\n') SKIP(994)
      END_STATE();
    case 172:
      if (lookahead == '\n') SKIP(994)
      if (lookahead == '\r') SKIP(171)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 173:
      if (lookahead == '\n') SKIP(978)
      END_STATE();
    case 174:
      if (lookahead == '\n') SKIP(978)
      if (lookahead == '\r') SKIP(173)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 175:
      if (lookahead == '\n') SKIP(947)
      END_STATE();
    case 176:
      if (lookahead == '\n') SKIP(947)
      if (lookahead == '\r') SKIP(175)
      END_STATE();
    case 177:
      if (lookahead == '\n') SKIP(718)
      END_STATE();
    case 178:
      if (lookahead == '\n') SKIP(718)
      if (lookahead == '\r') SKIP(177)
      END_STATE();
    case 179:
      if (lookahead == '\n') SKIP(1037)
      END_STATE();
    case 180:
      if (lookahead == '\n') SKIP(1037)
      if (lookahead == '\r') SKIP(179)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 181:
      if (lookahead == '\n') SKIP(1061)
      END_STATE();
    case 182:
      if (lookahead == '\n') SKIP(1061)
      if (lookahead == '\r') SKIP(181)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 183:
      if (lookahead == '\n') SKIP(728)
      END_STATE();
    case 184:
      if (lookahead == '\n') SKIP(728)
      if (lookahead == '\r') SKIP(183)
      END_STATE();
    case 185:
      if (lookahead == '\n') SKIP(913)
      END_STATE();
    case 186:
      if (lookahead == '\n') SKIP(913)
      if (lookahead == '\r') SKIP(185)
      END_STATE();
    case 187:
      if (lookahead == '\n') SKIP(729)
      END_STATE();
    case 188:
      if (lookahead == '\n') SKIP(729)
      if (lookahead == '\r') SKIP(187)
      END_STATE();
    case 189:
      if (lookahead == '\n') SKIP(974)
      END_STATE();
    case 190:
      if (lookahead == '\n') SKIP(974)
      if (lookahead == '\r') SKIP(189)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 191:
      if (lookahead == '\n') SKIP(958)
      END_STATE();
    case 192:
      if (lookahead == '\n') SKIP(958)
      if (lookahead == '\r') SKIP(191)
      END_STATE();
    case 193:
      if (lookahead == '\n') SKIP(838)
      END_STATE();
    case 194:
      if (lookahead == '\n') SKIP(838)
      if (lookahead == '\r') SKIP(193)
      END_STATE();
    case 195:
      if (lookahead == '\n') SKIP(997)
      END_STATE();
    case 196:
      if (lookahead == '\n') SKIP(997)
      if (lookahead == '\r') SKIP(195)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 197:
      if (lookahead == '\n') SKIP(1034)
      END_STATE();
    case 198:
      if (lookahead == '\n') SKIP(1034)
      if (lookahead == '\r') SKIP(197)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 199:
      if (lookahead == '\n') SKIP(926)
      END_STATE();
    case 200:
      if (lookahead == '\n') SKIP(926)
      if (lookahead == '\r') SKIP(199)
      END_STATE();
    case 201:
      if (lookahead == '\n') SKIP(1074)
      END_STATE();
    case 202:
      if (lookahead == '\n') SKIP(1074)
      if (lookahead == '\r') SKIP(201)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 203:
      if (lookahead == '\n') SKIP(1031)
      END_STATE();
    case 204:
      if (lookahead == '\n') SKIP(1031)
      if (lookahead == '\r') SKIP(203)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 205:
      if (lookahead == '\n') SKIP(948)
      END_STATE();
    case 206:
      if (lookahead == '\n') SKIP(948)
      if (lookahead == '\r') SKIP(205)
      END_STATE();
    case 207:
      if (lookahead == '\n') SKIP(738)
      END_STATE();
    case 208:
      if (lookahead == '\n') SKIP(738)
      if (lookahead == '\r') SKIP(207)
      END_STATE();
    case 209:
      if (lookahead == '\n') SKIP(723)
      END_STATE();
    case 210:
      if (lookahead == '\n') SKIP(723)
      if (lookahead == '\r') SKIP(209)
      END_STATE();
    case 211:
      if (lookahead == '\n') SKIP(724)
      END_STATE();
    case 212:
      if (lookahead == '\n') SKIP(724)
      if (lookahead == '\r') SKIP(211)
      END_STATE();
    case 213:
      if (lookahead == '\n') SKIP(959)
      END_STATE();
    case 214:
      if (lookahead == '\n') SKIP(959)
      if (lookahead == '\r') SKIP(213)
      END_STATE();
    case 215:
      if (lookahead == '\n') SKIP(743)
      END_STATE();
    case 216:
      if (lookahead == '\n') SKIP(743)
      if (lookahead == '\r') SKIP(215)
      END_STATE();
    case 217:
      if (lookahead == '\n') SKIP(925)
      END_STATE();
    case 218:
      if (lookahead == '\n') SKIP(925)
      if (lookahead == '\r') SKIP(217)
      END_STATE();
    case 219:
      if (lookahead == '\n') SKIP(960)
      END_STATE();
    case 220:
      if (lookahead == '\n') SKIP(960)
      if (lookahead == '\r') SKIP(219)
      END_STATE();
    case 221:
      if (lookahead == '\n') SKIP(914)
      END_STATE();
    case 222:
      if (lookahead == '\n') SKIP(914)
      if (lookahead == '\r') SKIP(221)
      END_STATE();
    case 223:
      if (lookahead == '\n') SKIP(1020)
      END_STATE();
    case 224:
      if (lookahead == '\n') SKIP(1020)
      if (lookahead == '\r') SKIP(223)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 225:
      if (lookahead == '\n') SKIP(836)
      END_STATE();
    case 226:
      if (lookahead == '\n') SKIP(836)
      if (lookahead == '\r') SKIP(225)
      END_STATE();
    case 227:
      if (lookahead == '\n') SKIP(949)
      END_STATE();
    case 228:
      if (lookahead == '\n') SKIP(949)
      if (lookahead == '\r') SKIP(227)
      END_STATE();
    case 229:
      if (lookahead == '\n') SKIP(742)
      END_STATE();
    case 230:
      if (lookahead == '\n') SKIP(742)
      if (lookahead == '\r') SKIP(229)
      END_STATE();
    case 231:
      if (lookahead == '\n') SKIP(1038)
      END_STATE();
    case 232:
      if (lookahead == '\n') SKIP(1038)
      if (lookahead == '\r') SKIP(231)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 233:
      if (lookahead == '\n') SKIP(927)
      END_STATE();
    case 234:
      if (lookahead == '\n') SKIP(927)
      if (lookahead == '\r') SKIP(233)
      END_STATE();
    case 235:
      if (lookahead == '\n') SKIP(1021)
      END_STATE();
    case 236:
      if (lookahead == '\n') SKIP(1021)
      if (lookahead == '\r') SKIP(235)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 237:
      if (lookahead == '\n') SKIP(984)
      END_STATE();
    case 238:
      if (lookahead == '\n') SKIP(984)
      if (lookahead == '\r') SKIP(237)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 239:
      if (lookahead == '\n') SKIP(719)
      END_STATE();
    case 240:
      if (lookahead == '\n') SKIP(719)
      if (lookahead == '\r') SKIP(239)
      END_STATE();
    case 241:
      if (lookahead == '\n') SKIP(720)
      END_STATE();
    case 242:
      if (lookahead == '\n') SKIP(720)
      if (lookahead == '\r') SKIP(241)
      END_STATE();
    case 243:
      if (lookahead == '\n') SKIP(928)
      END_STATE();
    case 244:
      if (lookahead == '\n') SKIP(928)
      if (lookahead == '\r') SKIP(243)
      END_STATE();
    case 245:
      if (lookahead == '\n') SKIP(911)
      END_STATE();
    case 246:
      if (lookahead == '\n') SKIP(911)
      if (lookahead == '\r') SKIP(245)
      END_STATE();
    case 247:
      if (lookahead == '\n') SKIP(1002)
      END_STATE();
    case 248:
      if (lookahead == '\n') SKIP(1002)
      if (lookahead == '\r') SKIP(247)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 249:
      if (lookahead == '\n') SKIP(839)
      END_STATE();
    case 250:
      if (lookahead == '\n') SKIP(839)
      if (lookahead == '\r') SKIP(249)
      END_STATE();
    case 251:
      if (lookahead == '\n') SKIP(961)
      END_STATE();
    case 252:
      if (lookahead == '\n') SKIP(961)
      if (lookahead == '\r') SKIP(251)
      END_STATE();
    case 253:
      if (lookahead == '\n') SKIP(831)
      END_STATE();
    case 254:
      if (lookahead == '\n') SKIP(831)
      if (lookahead == '\r') SKIP(253)
      END_STATE();
    case 255:
      if (lookahead == '\n') SKIP(744)
      END_STATE();
    case 256:
      if (lookahead == '\n') SKIP(744)
      if (lookahead == '\r') SKIP(255)
      END_STATE();
    case 257:
      if (lookahead == '\n') SKIP(1027)
      END_STATE();
    case 258:
      if (lookahead == '\n') SKIP(1027)
      if (lookahead == '\r') SKIP(257)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 259:
      if (lookahead == '\n') SKIP(1004)
      END_STATE();
    case 260:
      if (lookahead == '\n') SKIP(1004)
      if (lookahead == '\r') SKIP(259)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 261:
      if (lookahead == '\n') SKIP(741)
      END_STATE();
    case 262:
      if (lookahead == '\n') SKIP(741)
      if (lookahead == '\r') SKIP(261)
      END_STATE();
    case 263:
      if (lookahead == '\n') SKIP(1032)
      END_STATE();
    case 264:
      if (lookahead == '\n') SKIP(1032)
      if (lookahead == '\r') SKIP(263)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 265:
      if (lookahead == '\n') SKIP(1040)
      END_STATE();
    case 266:
      if (lookahead == '\n') SKIP(1040)
      if (lookahead == '\r') SKIP(265)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 267:
      if (lookahead == '\n') SKIP(929)
      END_STATE();
    case 268:
      if (lookahead == '\n') SKIP(929)
      if (lookahead == '\r') SKIP(267)
      END_STATE();
    case 269:
      if (lookahead == '\n') SKIP(739)
      END_STATE();
    case 270:
      if (lookahead == '\n') SKIP(739)
      if (lookahead == '\r') SKIP(269)
      END_STATE();
    case 271:
      if (lookahead == '\n') SKIP(740)
      END_STATE();
    case 272:
      if (lookahead == '\n') SKIP(740)
      if (lookahead == '\r') SKIP(271)
      END_STATE();
    case 273:
      if (lookahead == '\n') SKIP(915)
      END_STATE();
    case 274:
      if (lookahead == '\n') SKIP(915)
      if (lookahead == '\r') SKIP(273)
      END_STATE();
    case 275:
      if (lookahead == '\n') SKIP(934)
      END_STATE();
    case 276:
      if (lookahead == '\n') SKIP(934)
      if (lookahead == '\r') SKIP(275)
      END_STATE();
    case 277:
      if (lookahead == '\n') SKIP(1075)
      END_STATE();
    case 278:
      if (lookahead == '\n') SKIP(1075)
      if (lookahead == '\r') SKIP(277)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 279:
      if (lookahead == '\n') SKIP(842)
      END_STATE();
    case 280:
      if (lookahead == '\n') SKIP(842)
      if (lookahead == '\r') SKIP(279)
      END_STATE();
    case 281:
      if (lookahead == '\n') SKIP(930)
      END_STATE();
    case 282:
      if (lookahead == '\n') SKIP(930)
      if (lookahead == '\r') SKIP(281)
      END_STATE();
    case 283:
      if (lookahead == '\n') SKIP(843)
      END_STATE();
    case 284:
      if (lookahead == '\n') SKIP(843)
      if (lookahead == '\r') SKIP(283)
      END_STATE();
    case 285:
      if (lookahead == '\n') SKIP(725)
      END_STATE();
    case 286:
      if (lookahead == '\n') SKIP(725)
      if (lookahead == '\r') SKIP(285)
      END_STATE();
    case 287:
      if (lookahead == '\n') SKIP(747)
      END_STATE();
    case 288:
      if (lookahead == '\n') SKIP(747)
      if (lookahead == '\r') SKIP(287)
      END_STATE();
    case 289:
      if (lookahead == '\n') SKIP(931)
      END_STATE();
    case 290:
      if (lookahead == '\n') SKIP(931)
      if (lookahead == '\r') SKIP(289)
      END_STATE();
    case 291:
      if (lookahead == '\n') SKIP(916)
      END_STATE();
    case 292:
      if (lookahead == '\n') SKIP(916)
      if (lookahead == '\r') SKIP(291)
      END_STATE();
    case 293:
      if (lookahead == '\n') SKIP(933)
      END_STATE();
    case 294:
      if (lookahead == '\n') SKIP(933)
      if (lookahead == '\r') SKIP(293)
      END_STATE();
    case 295:
      if (lookahead == '\n') SKIP(932)
      END_STATE();
    case 296:
      if (lookahead == '\n') SKIP(932)
      if (lookahead == '\r') SKIP(295)
      END_STATE();
    case 297:
      if (lookahead == '\n') SKIP(935)
      END_STATE();
    case 298:
      if (lookahead == '\n') SKIP(935)
      if (lookahead == '\r') SKIP(297)
      END_STATE();
    case 299:
      if (lookahead == '\n') SKIP(721)
      END_STATE();
    case 300:
      if (lookahead == '\n') SKIP(721)
      if (lookahead == '\r') SKIP(299)
      END_STATE();
    case 301:
      if (lookahead == '\n') SKIP(936)
      END_STATE();
    case 302:
      if (lookahead == '\n') SKIP(936)
      if (lookahead == '\r') SKIP(301)
      END_STATE();
    case 303:
      if (lookahead == '\n') SKIP(844)
      END_STATE();
    case 304:
      if (lookahead == '\n') SKIP(844)
      if (lookahead == '\r') SKIP(303)
      END_STATE();
    case 305:
      if (lookahead == '\n') SKIP(845)
      END_STATE();
    case 306:
      if (lookahead == '\n') SKIP(845)
      if (lookahead == '\r') SKIP(305)
      END_STATE();
    case 307:
      if (lookahead == '\n') SKIP(937)
      END_STATE();
    case 308:
      if (lookahead == '\n') SKIP(937)
      if (lookahead == '\r') SKIP(307)
      END_STATE();
    case 309:
      if (lookahead == '\n') SKIP(847)
      END_STATE();
    case 310:
      if (lookahead == '\n') SKIP(847)
      if (lookahead == '\r') SKIP(309)
      END_STATE();
    case 311:
      if (lookahead == '\n') SKIP(1076)
      END_STATE();
    case 312:
      if (lookahead == '\n') SKIP(1076)
      if (lookahead == '\r') SKIP(311)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 313:
      if (lookahead == '\n') SKIP(938)
      END_STATE();
    case 314:
      if (lookahead == '\n') SKIP(938)
      if (lookahead == '\r') SKIP(313)
      END_STATE();
    case 315:
      if (lookahead == '\n') SKIP(939)
      END_STATE();
    case 316:
      if (lookahead == '\n') SKIP(939)
      if (lookahead == '\r') SKIP(315)
      END_STATE();
    case 317:
      if (lookahead == '\n') SKIP(1063)
      END_STATE();
    case 318:
      if (lookahead == '\n') SKIP(1063)
      if (lookahead == '\r') SKIP(317)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 319:
      if (lookahead == '\n') SKIP(1022)
      END_STATE();
    case 320:
      if (lookahead == '\n') SKIP(1022)
      if (lookahead == '\r') SKIP(319)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 321:
      if (lookahead == '\n') SKIP(964)
      END_STATE();
    case 322:
      if (lookahead == '\n') SKIP(964)
      if (lookahead == '\r') SKIP(321)
      END_STATE();
    case 323:
      if (lookahead == '\n') SKIP(1023)
      END_STATE();
    case 324:
      if (lookahead == '\n') SKIP(1023)
      if (lookahead == '\r') SKIP(323)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 325:
      if (lookahead == '\n') SKIP(1081)
      END_STATE();
    case 326:
      if (lookahead == '\n') SKIP(1081)
      if (lookahead == '\r') SKIP(325)
      END_STATE();
    case 327:
      if (lookahead == '\n') SKIP(982)
      END_STATE();
    case 328:
      if (lookahead == '\n') SKIP(982)
      if (lookahead == '\r') SKIP(327)
      END_STATE();
    case 329:
      if (lookahead == '\n') SKIP(963)
      END_STATE();
    case 330:
      if (lookahead == '\n') SKIP(963)
      if (lookahead == '\r') SKIP(329)
      END_STATE();
    case 331:
      if (lookahead == '\n') SKIP(983)
      END_STATE();
    case 332:
      if (lookahead == '\n') SKIP(983)
      if (lookahead == '\r') SKIP(331)
      END_STATE();
    case 333:
      if (lookahead == '\n') SKIP(1047)
      END_STATE();
    case 334:
      if (lookahead == '\n') SKIP(1047)
      if (lookahead == '\r') SKIP(333)
      END_STATE();
    case 335:
      if (lookahead == '\n') SKIP(1048)
      END_STATE();
    case 336:
      if (lookahead == '\n') SKIP(1048)
      if (lookahead == '\r') SKIP(335)
      END_STATE();
    case 337:
      if (lookahead == '\n') SKIP(965)
      END_STATE();
    case 338:
      if (lookahead == '\n') SKIP(965)
      if (lookahead == '\r') SKIP(337)
      END_STATE();
    case 339:
      if (lookahead == '\n') SKIP(981)
      END_STATE();
    case 340:
      if (lookahead == '\n') SKIP(981)
      if (lookahead == '\r') SKIP(339)
      END_STATE();
    case 341:
      if (lookahead == '\n') SKIP(1046)
      END_STATE();
    case 342:
      if (lookahead == '\n') SKIP(1046)
      if (lookahead == '\r') SKIP(341)
      END_STATE();
    case 343:
      if (lookahead == '\n') SKIP(980)
      END_STATE();
    case 344:
      if (lookahead == '\n') SKIP(980)
      if (lookahead == '\r') SKIP(343)
      END_STATE();
    case 345:
      if (lookahead == '\n') SKIP(1049)
      END_STATE();
    case 346:
      if (lookahead == '\n') SKIP(1049)
      if (lookahead == '\r') SKIP(345)
      END_STATE();
    case 347:
      if (lookahead == '\n') SKIP(1050)
      END_STATE();
    case 348:
      if (lookahead == '\n') SKIP(1050)
      if (lookahead == '\r') SKIP(347)
      END_STATE();
    case 349:
      if (lookahead == '\n') SKIP(1051)
      END_STATE();
    case 350:
      if (lookahead == '\n') SKIP(1051)
      if (lookahead == '\r') SKIP(349)
      END_STATE();
    case 351:
      if (lookahead == '\n') SKIP(1052)
      END_STATE();
    case 352:
      if (lookahead == '\n') SKIP(1052)
      if (lookahead == '\r') SKIP(351)
      END_STATE();
    case 353:
      if (lookahead == '\n') SKIP(1024)
      END_STATE();
    case 354:
      if (lookahead == '\n') SKIP(1024)
      if (lookahead == '\r') SKIP(353)
      END_STATE();
    case 355:
      if (lookahead == '\n') SKIP(1053)
      END_STATE();
    case 356:
      if (lookahead == '\n') SKIP(1053)
      if (lookahead == '\r') SKIP(355)
      END_STATE();
    case 357:
      if (lookahead == '\n') SKIP(1054)
      END_STATE();
    case 358:
      if (lookahead == '\n') SKIP(1054)
      if (lookahead == '\r') SKIP(357)
      END_STATE();
    case 359:
      if (lookahead == '\n') SKIP(1055)
      END_STATE();
    case 360:
      if (lookahead == '\n') SKIP(1055)
      if (lookahead == '\r') SKIP(359)
      END_STATE();
    case 361:
      if (lookahead == '\n') SKIP(1056)
      END_STATE();
    case 362:
      if (lookahead == '\n') SKIP(1056)
      if (lookahead == '\r') SKIP(361)
      END_STATE();
    case 363:
      if (lookahead == '\n') SKIP(1057)
      END_STATE();
    case 364:
      if (lookahead == '\n') SKIP(1057)
      if (lookahead == '\r') SKIP(363)
      END_STATE();
    case 365:
      if (lookahead == '\n') SKIP(1058)
      END_STATE();
    case 366:
      if (lookahead == '\n') SKIP(1058)
      if (lookahead == '\r') SKIP(365)
      END_STATE();
    case 367:
      if (lookahead == '\n') SKIP(1059)
      END_STATE();
    case 368:
      if (lookahead == '\n') SKIP(1059)
      if (lookahead == '\r') SKIP(367)
      END_STATE();
    case 369:
      if (lookahead == '\n') SKIP(1060)
      END_STATE();
    case 370:
      if (lookahead == '\n') SKIP(1060)
      if (lookahead == '\r') SKIP(369)
      END_STATE();
    case 371:
      if (lookahead == '\n') SKIP(1069)
      END_STATE();
    case 372:
      if (lookahead == '\n') SKIP(1069)
      if (lookahead == '\r') SKIP(371)
      END_STATE();
    case 373:
      if (lookahead == '\n') SKIP(780)
      END_STATE();
    case 374:
      if (lookahead == '\n') SKIP(780)
      if (lookahead == '\r') SKIP(373)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 375:
      if (lookahead == '\n') SKIP(749)
      END_STATE();
    case 376:
      if (lookahead == '\n') SKIP(749)
      if (lookahead == '\r') SKIP(375)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 377:
      if (lookahead == '\n') SKIP(849)
      END_STATE();
    case 378:
      if (lookahead == '\n') SKIP(849)
      if (lookahead == '\r') SKIP(377)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 379:
      if (lookahead == '\n') SKIP(783)
      END_STATE();
    case 380:
      if (lookahead == '\n') SKIP(783)
      if (lookahead == '\r') SKIP(379)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 381:
      if (lookahead == '\n') SKIP(757)
      END_STATE();
    case 382:
      if (lookahead == '\n') SKIP(757)
      if (lookahead == '\r') SKIP(381)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 383:
      if (lookahead == '\n') SKIP(773)
      END_STATE();
    case 384:
      if (lookahead == '\n') SKIP(773)
      if (lookahead == '\r') SKIP(383)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 385:
      if (lookahead == '\n') SKIP(852)
      END_STATE();
    case 386:
      if (lookahead == '\n') SKIP(852)
      if (lookahead == '\r') SKIP(385)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 387:
      if (lookahead == '\n') SKIP(759)
      END_STATE();
    case 388:
      if (lookahead == '\n') SKIP(759)
      if (lookahead == '\r') SKIP(387)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 389:
      if (lookahead == '\n') SKIP(775)
      END_STATE();
    case 390:
      if (lookahead == '\n') SKIP(775)
      if (lookahead == '\r') SKIP(389)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 391:
      if (lookahead == '\n') SKIP(760)
      END_STATE();
    case 392:
      if (lookahead == '\n') SKIP(760)
      if (lookahead == '\r') SKIP(391)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 393:
      if (lookahead == '\n') SKIP(882)
      END_STATE();
    case 394:
      if (lookahead == '\n') SKIP(882)
      if (lookahead == '\r') SKIP(393)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 395:
      if (lookahead == '\n') SKIP(826)
      END_STATE();
    case 396:
      if (lookahead == '\n') SKIP(826)
      if (lookahead == '\r') SKIP(395)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 397:
      if (lookahead == '\n') SKIP(861)
      END_STATE();
    case 398:
      if (lookahead == '\n') SKIP(861)
      if (lookahead == '\r') SKIP(397)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 399:
      if (lookahead == '\n') SKIP(835)
      END_STATE();
    case 400:
      if (lookahead == '\n') SKIP(835)
      if (lookahead == '\r') SKIP(399)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 401:
      if (lookahead == '\n') SKIP(886)
      END_STATE();
    case 402:
      if (lookahead == '\n') SKIP(886)
      if (lookahead == '\r') SKIP(401)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 403:
      if (lookahead == '\n') SKIP(787)
      END_STATE();
    case 404:
      if (lookahead == '\n') SKIP(787)
      if (lookahead == '\r') SKIP(403)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 405:
      if (lookahead == '\n') SKIP(790)
      END_STATE();
    case 406:
      if (lookahead == '\n') SKIP(790)
      if (lookahead == '\r') SKIP(405)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 407:
      if (lookahead == '\n') SKIP(768)
      END_STATE();
    case 408:
      if (lookahead == '\n') SKIP(768)
      if (lookahead == '\r') SKIP(407)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 409:
      if (lookahead == '\n') SKIP(909)
      END_STATE();
    case 410:
      if (lookahead == '\n') SKIP(909)
      if (lookahead == '\r') SKIP(409)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 411:
      if (lookahead == '\n') SKIP(793)
      END_STATE();
    case 412:
      if (lookahead == '\n') SKIP(793)
      if (lookahead == '\r') SKIP(411)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 413:
      if (lookahead == '\n') SKIP(771)
      END_STATE();
    case 414:
      if (lookahead == '\n') SKIP(771)
      if (lookahead == '\r') SKIP(413)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 415:
      if (lookahead == '\n') SKIP(943)
      END_STATE();
    case 416:
      if (lookahead == '\n') SKIP(943)
      if (lookahead == '\r') SKIP(415)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 417:
      if (lookahead == '\n') SKIP(795)
      END_STATE();
    case 418:
      if (lookahead == '\n') SKIP(795)
      if (lookahead == '\r') SKIP(417)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 419:
      if (lookahead == '\n') SKIP(986)
      END_STATE();
    case 420:
      if (lookahead == '\n') SKIP(986)
      if (lookahead == '\r') SKIP(419)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 421:
      if (lookahead == '\n') SKIP(727)
      END_STATE();
    case 422:
      if (lookahead == '\n') SKIP(727)
      if (lookahead == '\r') SKIP(421)
      END_STATE();
    case 423:
      if (lookahead == '\n') SKIP(993)
      END_STATE();
    case 424:
      if (lookahead == '\n') SKIP(993)
      if (lookahead == '\r') SKIP(423)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 425:
      if (lookahead == '\n') SKIP(900)
      END_STATE();
    case 426:
      if (lookahead == '\n') SKIP(900)
      if (lookahead == '\r') SKIP(425)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 427:
      if (lookahead == '\n') SKIP(1026)
      END_STATE();
    case 428:
      if (lookahead == '\n') SKIP(1026)
      if (lookahead == '\r') SKIP(427)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 429:
      if (lookahead == '\n') SKIP(996)
      END_STATE();
    case 430:
      if (lookahead == '\n') SKIP(996)
      if (lookahead == '\r') SKIP(429)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 431:
      if (lookahead == '\n') SKIP(995)
      END_STATE();
    case 432:
      if (lookahead == '\n') SKIP(995)
      if (lookahead == '\r') SKIP(431)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 433:
      if (lookahead == '\n') SKIP(979)
      END_STATE();
    case 434:
      if (lookahead == '\n') SKIP(979)
      if (lookahead == '\r') SKIP(433)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 435:
      if (lookahead == '\n') SKIP(1062)
      END_STATE();
    case 436:
      if (lookahead == '\n') SKIP(1062)
      if (lookahead == '\r') SKIP(435)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 437:
      if (lookahead == '\n') SKIP(731)
      END_STATE();
    case 438:
      if (lookahead == '\n') SKIP(731)
      if (lookahead == '\r') SKIP(437)
      END_STATE();
    case 439:
      if (lookahead == '\n') SKIP(732)
      END_STATE();
    case 440:
      if (lookahead == '\n') SKIP(732)
      if (lookahead == '\r') SKIP(439)
      END_STATE();
    case 441:
      if (lookahead == '\n') SKIP(975)
      END_STATE();
    case 442:
      if (lookahead == '\n') SKIP(975)
      if (lookahead == '\r') SKIP(441)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 443:
      if (lookahead == '\n') SKIP(1035)
      END_STATE();
    case 444:
      if (lookahead == '\n') SKIP(1035)
      if (lookahead == '\r') SKIP(443)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 445:
      if (lookahead == '\n') SKIP(1039)
      END_STATE();
    case 446:
      if (lookahead == '\n') SKIP(1039)
      if (lookahead == '\r') SKIP(445)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 447:
      if (lookahead == '\n') SKIP(840)
      END_STATE();
    case 448:
      if (lookahead == '\n') SKIP(840)
      if (lookahead == '\r') SKIP(447)
      END_STATE();
    case 449:
      if (lookahead == '\n') SKIP(745)
      END_STATE();
    case 450:
      if (lookahead == '\n') SKIP(745)
      if (lookahead == '\r') SKIP(449)
      END_STATE();
    case 451:
      if (lookahead == '\n') SKIP(782)
      END_STATE();
    case 452:
      if (lookahead == '\n') SKIP(782)
      if (lookahead == '\r') SKIP(451)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 453:
      if (lookahead == '\n') SKIP(750)
      END_STATE();
    case 454:
      if (lookahead == '\n') SKIP(750)
      if (lookahead == '\r') SKIP(453)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 455:
      if (lookahead == '\n') SKIP(850)
      END_STATE();
    case 456:
      if (lookahead == '\n') SKIP(850)
      if (lookahead == '\r') SKIP(455)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 457:
      if (lookahead == '\n') SKIP(758)
      END_STATE();
    case 458:
      if (lookahead == '\n') SKIP(758)
      if (lookahead == '\r') SKIP(457)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 459:
      if (lookahead == '\n') SKIP(855)
      END_STATE();
    case 460:
      if (lookahead == '\n') SKIP(855)
      if (lookahead == '\r') SKIP(459)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 461:
      if (lookahead == '\n') SKIP(762)
      END_STATE();
    case 462:
      if (lookahead == '\n') SKIP(762)
      if (lookahead == '\r') SKIP(461)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 463:
      if (lookahead == '\n') SKIP(883)
      END_STATE();
    case 464:
      if (lookahead == '\n') SKIP(883)
      if (lookahead == '\r') SKIP(463)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 465:
      if (lookahead == '\n') SKIP(827)
      END_STATE();
    case 466:
      if (lookahead == '\n') SKIP(827)
      if (lookahead == '\r') SKIP(465)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 467:
      if (lookahead == '\n') SKIP(887)
      END_STATE();
    case 468:
      if (lookahead == '\n') SKIP(887)
      if (lookahead == '\r') SKIP(467)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 469:
      if (lookahead == '\n') SKIP(789)
      END_STATE();
    case 470:
      if (lookahead == '\n') SKIP(789)
      if (lookahead == '\r') SKIP(469)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 471:
      if (lookahead == '\n') SKIP(792)
      END_STATE();
    case 472:
      if (lookahead == '\n') SKIP(792)
      if (lookahead == '\r') SKIP(471)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 473:
      if (lookahead == '\n') SKIP(987)
      END_STATE();
    case 474:
      if (lookahead == '\n') SKIP(987)
      if (lookahead == '\r') SKIP(473)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 475:
      if (lookahead == '\n') SKIP(730)
      END_STATE();
    case 476:
      if (lookahead == '\n') SKIP(730)
      if (lookahead == '\r') SKIP(475)
      END_STATE();
    case 477:
      if (lookahead == '\n') SKIP(998)
      END_STATE();
    case 478:
      if (lookahead == '\n') SKIP(998)
      if (lookahead == '\r') SKIP(477)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 479:
      if (lookahead == '\n') SKIP(999)
      END_STATE();
    case 480:
      if (lookahead == '\n') SKIP(999)
      if (lookahead == '\r') SKIP(479)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 481:
      if (lookahead == '\n') SKIP(733)
      END_STATE();
    case 482:
      if (lookahead == '\n') SKIP(733)
      if (lookahead == '\r') SKIP(481)
      END_STATE();
    case 483:
      if (lookahead == '\n') SKIP(734)
      END_STATE();
    case 484:
      if (lookahead == '\n') SKIP(734)
      if (lookahead == '\r') SKIP(483)
      END_STATE();
    case 485:
      if (lookahead == '\n') SKIP(976)
      END_STATE();
    case 486:
      if (lookahead == '\n') SKIP(976)
      if (lookahead == '\r') SKIP(485)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 487:
      if (lookahead == '\n') SKIP(1036)
      END_STATE();
    case 488:
      if (lookahead == '\n') SKIP(1036)
      if (lookahead == '\r') SKIP(487)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 489:
      if (lookahead == '\n') SKIP(1041)
      END_STATE();
    case 490:
      if (lookahead == '\n') SKIP(1041)
      if (lookahead == '\r') SKIP(489)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 491:
      if (lookahead == '\n') SKIP(784)
      END_STATE();
    case 492:
      if (lookahead == '\n') SKIP(784)
      if (lookahead == '\r') SKIP(491)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 493:
      if (lookahead == '\n') SKIP(751)
      END_STATE();
    case 494:
      if (lookahead == '\n') SKIP(751)
      if (lookahead == '\r') SKIP(493)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 495:
      if (lookahead == '\n') SKIP(854)
      END_STATE();
    case 496:
      if (lookahead == '\n') SKIP(854)
      if (lookahead == '\r') SKIP(495)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 497:
      if (lookahead == '\n') SKIP(761)
      END_STATE();
    case 498:
      if (lookahead == '\n') SKIP(761)
      if (lookahead == '\r') SKIP(497)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 499:
      if (lookahead == '\n') SKIP(857)
      END_STATE();
    case 500:
      if (lookahead == '\n') SKIP(857)
      if (lookahead == '\r') SKIP(499)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 501:
      if (lookahead == '\n') SKIP(884)
      END_STATE();
    case 502:
      if (lookahead == '\n') SKIP(884)
      if (lookahead == '\r') SKIP(501)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 503:
      if (lookahead == '\n') SKIP(828)
      END_STATE();
    case 504:
      if (lookahead == '\n') SKIP(828)
      if (lookahead == '\r') SKIP(503)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 505:
      if (lookahead == '\n') SKIP(888)
      END_STATE();
    case 506:
      if (lookahead == '\n') SKIP(888)
      if (lookahead == '\r') SKIP(505)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 507:
      if (lookahead == '\n') SKIP(794)
      END_STATE();
    case 508:
      if (lookahead == '\n') SKIP(794)
      if (lookahead == '\r') SKIP(507)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 509:
      if (lookahead == '\n') SKIP(796)
      END_STATE();
    case 510:
      if (lookahead == '\n') SKIP(796)
      if (lookahead == '\r') SKIP(509)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 511:
      if (lookahead == '\n') SKIP(988)
      END_STATE();
    case 512:
      if (lookahead == '\n') SKIP(988)
      if (lookahead == '\r') SKIP(511)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 513:
      if (lookahead == '\n') SKIP(1000)
      END_STATE();
    case 514:
      if (lookahead == '\n') SKIP(1000)
      if (lookahead == '\r') SKIP(513)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 515:
      if (lookahead == '\n') SKIP(1001)
      END_STATE();
    case 516:
      if (lookahead == '\n') SKIP(1001)
      if (lookahead == '\r') SKIP(515)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 517:
      if (lookahead == '\n') SKIP(977)
      END_STATE();
    case 518:
      if (lookahead == '\n') SKIP(977)
      if (lookahead == '\r') SKIP(517)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 519:
      if (lookahead == '\n') SKIP(1042)
      END_STATE();
    case 520:
      if (lookahead == '\n') SKIP(1042)
      if (lookahead == '\r') SKIP(519)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 521:
      if (lookahead == '\n') SKIP(753)
      END_STATE();
    case 522:
      if (lookahead == '\n') SKIP(753)
      if (lookahead == '\r') SKIP(521)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 523:
      if (lookahead == '\n') SKIP(858)
      END_STATE();
    case 524:
      if (lookahead == '\n') SKIP(858)
      if (lookahead == '\r') SKIP(523)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 525:
      if (lookahead == '\n') SKIP(829)
      END_STATE();
    case 526:
      if (lookahead == '\n') SKIP(829)
      if (lookahead == '\r') SKIP(525)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 527:
      if (lookahead == '\n') SKIP(989)
      END_STATE();
    case 528:
      if (lookahead == '\n') SKIP(989)
      if (lookahead == '\r') SKIP(527)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 529:
      if (lookahead == '\n') SKIP(1003)
      END_STATE();
    case 530:
      if (lookahead == '\n') SKIP(1003)
      if (lookahead == '\r') SKIP(529)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 531:
      if (lookahead == '\n') SKIP(1005)
      END_STATE();
    case 532:
      if (lookahead == '\n') SKIP(1005)
      if (lookahead == '\r') SKIP(531)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 533:
      if (lookahead == '\n') SKIP(755)
      END_STATE();
    case 534:
      if (lookahead == '\n') SKIP(755)
      if (lookahead == '\r') SKIP(533)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 535:
      if (lookahead == '\n') SKIP(860)
      END_STATE();
    case 536:
      if (lookahead == '\n') SKIP(860)
      if (lookahead == '\r') SKIP(535)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 537:
      if (lookahead == '\n') SKIP(830)
      END_STATE();
    case 538:
      if (lookahead == '\n') SKIP(830)
      if (lookahead == '\r') SKIP(537)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 539:
      if (lookahead == '\n') SKIP(992)
      END_STATE();
    case 540:
      if (lookahead == '\n') SKIP(992)
      if (lookahead == '\r') SKIP(539)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 541:
      if (lookahead == '\n') SKIP(797)
      END_STATE();
    case 542:
      if (lookahead == '\n') SKIP(797)
      if (lookahead == '\r') SKIP(541)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 543:
      if (lookahead == '\n') SKIP(862)
      END_STATE();
    case 544:
      if (lookahead == '\n') SKIP(862)
      if (lookahead == '\r') SKIP(543)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 545:
      if (lookahead == '\n') SKIP(798)
      END_STATE();
    case 546:
      if (lookahead == '\n') SKIP(798)
      if (lookahead == '\r') SKIP(545)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 547:
      if (lookahead == '\n') SKIP(864)
      END_STATE();
    case 548:
      if (lookahead == '\n') SKIP(864)
      if (lookahead == '\r') SKIP(547)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 549:
      if (lookahead == '\n') SKIP(865)
      END_STATE();
    case 550:
      if (lookahead == '\n') SKIP(865)
      if (lookahead == '\r') SKIP(549)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 551:
      if (lookahead == '\n') SKIP(889)
      END_STATE();
    case 552:
      if (lookahead == '\n') SKIP(889)
      if (lookahead == '\r') SKIP(551)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 553:
      if (lookahead == '\n') SKIP(866)
      END_STATE();
    case 554:
      if (lookahead == '\n') SKIP(866)
      if (lookahead == '\r') SKIP(553)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 555:
      if (lookahead == '\n') SKIP(867)
      END_STATE();
    case 556:
      if (lookahead == '\n') SKIP(867)
      if (lookahead == '\r') SKIP(555)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 557:
      if (lookahead == '\n') SKIP(891)
      END_STATE();
    case 558:
      if (lookahead == '\n') SKIP(891)
      if (lookahead == '\r') SKIP(557)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 559:
      if (lookahead == '\n') SKIP(954)
      END_STATE();
    case 560:
      if (lookahead == '\n') SKIP(954)
      if (lookahead == '\r') SKIP(559)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 561:
      if (lookahead == '\n') SKIP(801)
      END_STATE();
    case 562:
      if (lookahead == '\n') SKIP(801)
      if (lookahead == '\r') SKIP(561)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 563:
      if (lookahead == '\n') SKIP(955)
      END_STATE();
    case 564:
      if (lookahead == '\n') SKIP(955)
      if (lookahead == '\r') SKIP(563)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 565:
      if (lookahead == '\n') SKIP(802)
      END_STATE();
    case 566:
      if (lookahead == '\n') SKIP(802)
      if (lookahead == '\r') SKIP(565)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 567:
      if (lookahead == '\n') SKIP(804)
      END_STATE();
    case 568:
      if (lookahead == '\n') SKIP(804)
      if (lookahead == '\r') SKIP(567)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 569:
      if (lookahead == '\n') SKIP(807)
      END_STATE();
    case 570:
      if (lookahead == '\n') SKIP(807)
      if (lookahead == '\r') SKIP(569)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 571:
      if (lookahead == '\n') SKIP(1006)
      END_STATE();
    case 572:
      if (lookahead == '\n') SKIP(1006)
      if (lookahead == '\r') SKIP(571)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 573:
      if (lookahead == '\n') SKIP(969)
      END_STATE();
    case 574:
      if (lookahead == '\n') SKIP(969)
      if (lookahead == '\r') SKIP(573)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 575:
      if (lookahead == '\n') SKIP(1010)
      END_STATE();
    case 576:
      if (lookahead == '\n') SKIP(1010)
      if (lookahead == '\r') SKIP(575)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 577:
      if (lookahead == '\n') SKIP(970)
      END_STATE();
    case 578:
      if (lookahead == '\n') SKIP(970)
      if (lookahead == '\r') SKIP(577)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 579:
      if (lookahead == '\n') SKIP(1011)
      END_STATE();
    case 580:
      if (lookahead == '\n') SKIP(1011)
      if (lookahead == '\r') SKIP(579)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 581:
      if (lookahead == '\n') SKIP(1043)
      END_STATE();
    case 582:
      if (lookahead == '\n') SKIP(1043)
      if (lookahead == '\r') SKIP(581)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 583:
      if (lookahead == '\n') SKIP(1065)
      END_STATE();
    case 584:
      if (lookahead == '\n') SKIP(1065)
      if (lookahead == '\r') SKIP(583)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 585:
      if (lookahead == '\n') SKIP(1013)
      END_STATE();
    case 586:
      if (lookahead == '\n') SKIP(1013)
      if (lookahead == '\r') SKIP(585)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 587:
      if (lookahead == '\n') SKIP(1044)
      END_STATE();
    case 588:
      if (lookahead == '\n') SKIP(1044)
      if (lookahead == '\r') SKIP(587)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 589:
      if (lookahead == '\n') SKIP(1064)
      END_STATE();
    case 590:
      if (lookahead == '\n') SKIP(1064)
      if (lookahead == '\r') SKIP(589)
      END_STATE();
    case 591:
      if (lookahead == '\n') SKIP(800)
      END_STATE();
    case 592:
      if (lookahead == '\n') SKIP(800)
      if (lookahead == '\r') SKIP(591)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 593:
      if (lookahead == '\n') SKIP(890)
      END_STATE();
    case 594:
      if (lookahead == '\n') SKIP(890)
      if (lookahead == '\r') SKIP(593)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 595:
      if (lookahead == '\n') SKIP(892)
      END_STATE();
    case 596:
      if (lookahead == '\n') SKIP(892)
      if (lookahead == '\r') SKIP(595)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 597:
      if (lookahead == '\n') SKIP(803)
      END_STATE();
    case 598:
      if (lookahead == '\n') SKIP(803)
      if (lookahead == '\r') SKIP(597)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 599:
      if (lookahead == '\n') SKIP(806)
      END_STATE();
    case 600:
      if (lookahead == '\n') SKIP(806)
      if (lookahead == '\r') SKIP(599)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 601:
      if (lookahead == '\n') SKIP(809)
      END_STATE();
    case 602:
      if (lookahead == '\n') SKIP(809)
      if (lookahead == '\r') SKIP(601)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 603:
      if (lookahead == '\n') SKIP(810)
      END_STATE();
    case 604:
      if (lookahead == '\n') SKIP(810)
      if (lookahead == '\r') SKIP(603)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 605:
      if (lookahead == '\n') SKIP(1012)
      END_STATE();
    case 606:
      if (lookahead == '\n') SKIP(1012)
      if (lookahead == '\r') SKIP(605)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 607:
      if (lookahead == '\n') SKIP(799)
      END_STATE();
    case 608:
      if (lookahead == '\n') SKIP(799)
      if (lookahead == '\r') SKIP(607)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 609:
      if (lookahead == '\n') SKIP(863)
      END_STATE();
    case 610:
      if (lookahead == '\n') SKIP(863)
      if (lookahead == '\r') SKIP(609)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 611:
      if (lookahead == '\n') SKIP(805)
      END_STATE();
    case 612:
      if (lookahead == '\n') SKIP(805)
      if (lookahead == '\r') SKIP(611)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 613:
      if (lookahead == '\n') SKIP(808)
      END_STATE();
    case 614:
      if (lookahead == '\n') SKIP(808)
      if (lookahead == '\r') SKIP(613)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 615:
      if (lookahead == '\n') SKIP(1007)
      END_STATE();
    case 616:
      if (lookahead == '\n') SKIP(1007)
      if (lookahead == '\r') SKIP(615)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 617:
      if (lookahead == '\n') SKIP(1014)
      END_STATE();
    case 618:
      if (lookahead == '\n') SKIP(1014)
      if (lookahead == '\r') SKIP(617)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 619:
      if (lookahead == '\n') SKIP(1008)
      END_STATE();
    case 620:
      if (lookahead == '\n') SKIP(1008)
      if (lookahead == '\r') SKIP(619)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 621:
      if (lookahead == '\n') SKIP(1015)
      END_STATE();
    case 622:
      if (lookahead == '\n') SKIP(1015)
      if (lookahead == '\r') SKIP(621)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 623:
      if (lookahead == '\n') SKIP(1045)
      END_STATE();
    case 624:
      if (lookahead == '\n') SKIP(1045)
      if (lookahead == '\r') SKIP(623)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 625:
      if (lookahead == '\n') SKIP(1009)
      END_STATE();
    case 626:
      if (lookahead == '\n') SKIP(1009)
      if (lookahead == '\r') SKIP(625)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 627:
      if (lookahead == '\n') SKIP(1016)
      END_STATE();
    case 628:
      if (lookahead == '\n') SKIP(1016)
      if (lookahead == '\r') SKIP(627)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 629:
      if (lookahead == '\n') SKIP(811)
      END_STATE();
    case 630:
      if (lookahead == '\n') SKIP(811)
      if (lookahead == '\r') SKIP(629)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 631:
      if (lookahead == '\n') SKIP(868)
      END_STATE();
    case 632:
      if (lookahead == '\n') SKIP(868)
      if (lookahead == '\r') SKIP(631)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 633:
      if (lookahead == '\n') SKIP(813)
      END_STATE();
    case 634:
      if (lookahead == '\n') SKIP(813)
      if (lookahead == '\r') SKIP(633)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 635:
      if (lookahead == '\n') SKIP(870)
      END_STATE();
    case 636:
      if (lookahead == '\n') SKIP(870)
      if (lookahead == '\r') SKIP(635)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 637:
      if (lookahead == '\n') SKIP(871)
      END_STATE();
    case 638:
      if (lookahead == '\n') SKIP(871)
      if (lookahead == '\r') SKIP(637)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 639:
      if (lookahead == '\n') SKIP(893)
      END_STATE();
    case 640:
      if (lookahead == '\n') SKIP(893)
      if (lookahead == '\r') SKIP(639)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 641:
      if (lookahead == '\n') SKIP(814)
      END_STATE();
    case 642:
      if (lookahead == '\n') SKIP(814)
      if (lookahead == '\r') SKIP(641)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 643:
      if (lookahead == '\n') SKIP(815)
      END_STATE();
    case 644:
      if (lookahead == '\n') SKIP(815)
      if (lookahead == '\r') SKIP(643)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 645:
      if (lookahead == '\n') SKIP(816)
      END_STATE();
    case 646:
      if (lookahead == '\n') SKIP(816)
      if (lookahead == '\r') SKIP(645)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 647:
      if (lookahead == '\n') SKIP(817)
      END_STATE();
    case 648:
      if (lookahead == '\n') SKIP(817)
      if (lookahead == '\r') SKIP(647)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 649:
      if (lookahead == '\n') SKIP(1017)
      END_STATE();
    case 650:
      if (lookahead == '\n') SKIP(1017)
      if (lookahead == '\r') SKIP(649)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 651:
      if (lookahead == '\n') SKIP(735)
      END_STATE();
    case 652:
      if (lookahead == '\n') SKIP(735)
      if (lookahead == '\r') SKIP(651)
      END_STATE();
    case 653:
      if (lookahead == '\n') SKIP(901)
      END_STATE();
    case 654:
      if (lookahead == '\n') SKIP(901)
      if (lookahead == '\r') SKIP(653)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 655:
      if (lookahead == '\n') SKIP(736)
      END_STATE();
    case 656:
      if (lookahead == '\n') SKIP(736)
      if (lookahead == '\r') SKIP(655)
      END_STATE();
    case 657:
      if (lookahead == '\n') SKIP(737)
      END_STATE();
    case 658:
      if (lookahead == '\n') SKIP(737)
      if (lookahead == '\r') SKIP(657)
      END_STATE();
    case 659:
      if (lookahead == '\n') SKIP(841)
      END_STATE();
    case 660:
      if (lookahead == '\n') SKIP(841)
      if (lookahead == '\r') SKIP(659)
      END_STATE();
    case 661:
      if (lookahead == '\n') SKIP(746)
      END_STATE();
    case 662:
      if (lookahead == '\n') SKIP(746)
      if (lookahead == '\r') SKIP(661)
      END_STATE();
    case 663:
      if (lookahead == '\n') SKIP(846)
      END_STATE();
    case 664:
      if (lookahead == '\n') SKIP(846)
      if (lookahead == '\r') SKIP(663)
      END_STATE();
    case 665:
      if (lookahead == '\n') SKIP(812)
      END_STATE();
    case 666:
      if (lookahead == '\n') SKIP(812)
      if (lookahead == '\r') SKIP(665)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 667:
      if (lookahead == '\n') SKIP(869)
      END_STATE();
    case 668:
      if (lookahead == '\n') SKIP(869)
      if (lookahead == '\r') SKIP(667)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 669:
      if (lookahead == '\n') SKIP(894)
      END_STATE();
    case 670:
      if (lookahead == '\n') SKIP(894)
      if (lookahead == '\r') SKIP(669)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 671:
      if (lookahead == '\n') SKIP(1018)
      END_STATE();
    case 672:
      if (lookahead == '\n') SKIP(1018)
      if (lookahead == '\r') SKIP(671)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 673:
      if (lookahead == '\n') SKIP(872)
      END_STATE();
    case 674:
      if (lookahead == '\n') SKIP(872)
      if (lookahead == '\r') SKIP(673)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 675:
      if (lookahead == '\n') SKIP(818)
      END_STATE();
    case 676:
      if (lookahead == '\n') SKIP(818)
      if (lookahead == '\r') SKIP(675)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 677:
      if (lookahead == '\n') SKIP(873)
      END_STATE();
    case 678:
      if (lookahead == '\n') SKIP(873)
      if (lookahead == '\r') SKIP(677)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 679:
      if (lookahead == '\n') SKIP(819)
      END_STATE();
    case 680:
      if (lookahead == '\n') SKIP(819)
      if (lookahead == '\r') SKIP(679)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 681:
      if (lookahead == '\n') SKIP(874)
      END_STATE();
    case 682:
      if (lookahead == '\n') SKIP(874)
      if (lookahead == '\r') SKIP(681)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 683:
      if (lookahead == '\n') SKIP(875)
      END_STATE();
    case 684:
      if (lookahead == '\n') SKIP(875)
      if (lookahead == '\r') SKIP(683)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 685:
      if (lookahead == '\n') SKIP(895)
      END_STATE();
    case 686:
      if (lookahead == '\n') SKIP(895)
      if (lookahead == '\r') SKIP(685)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 687:
      if (lookahead == '\n') SKIP(820)
      END_STATE();
    case 688:
      if (lookahead == '\n') SKIP(820)
      if (lookahead == '\r') SKIP(687)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 689:
      if (lookahead == '\n') SKIP(821)
      END_STATE();
    case 690:
      if (lookahead == '\n') SKIP(821)
      if (lookahead == '\r') SKIP(689)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 691:
      if (lookahead == '\n') SKIP(822)
      END_STATE();
    case 692:
      if (lookahead == '\n') SKIP(822)
      if (lookahead == '\r') SKIP(691)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 693:
      if (lookahead == '\n') SKIP(823)
      END_STATE();
    case 694:
      if (lookahead == '\n') SKIP(823)
      if (lookahead == '\r') SKIP(693)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 695:
      if (lookahead == '\n') SKIP(1019)
      END_STATE();
    case 696:
      if (lookahead == '\n') SKIP(1019)
      if (lookahead == '\r') SKIP(695)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 697:
      if (lookahead == '\n') SKIP(896)
      END_STATE();
    case 698:
      if (lookahead == '\n') SKIP(896)
      if (lookahead == '\r') SKIP(697)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 699:
      if (lookahead == '\n') SKIP(880)
      END_STATE();
    case 700:
      if (lookahead == '\n') SKIP(880)
      if (lookahead == '\r') SKIP(699)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 701:
      if (lookahead == '\n') SKIP(1030)
      END_STATE();
    case 702:
      if (lookahead == '\n') SKIP(1030)
      if (lookahead == '\r') SKIP(701)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 703:
      if (lookahead == '\n') SKIP(1033)
      END_STATE();
    case 704:
      if (lookahead == '\n') SKIP(1033)
      if (lookahead == '\r') SKIP(703)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 705:
      if (lookahead == '\n') SKIP(876)
      END_STATE();
    case 706:
      if (lookahead == '\n') SKIP(876)
      if (lookahead == '\r') SKIP(705)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 707:
      if (lookahead == '\n') SKIP(897)
      END_STATE();
    case 708:
      if (lookahead == '\n') SKIP(897)
      if (lookahead == '\r') SKIP(707)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 709:
      if (lookahead == '\n') SKIP(898)
      END_STATE();
    case 710:
      if (lookahead == '\n') SKIP(898)
      if (lookahead == '\r') SKIP(709)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 711:
      if (lookahead == '\n') SKIP(877)
      END_STATE();
    case 712:
      if (lookahead == '\n') SKIP(877)
      if (lookahead == '\r') SKIP(711)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2585);
      END_STATE();
    case 713:
      if (lookahead == ' ') ADVANCE(2050);
      END_STATE();
    case 714:
      if (lookahead == '!') ADVANCE(716);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3753);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(2594);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == 'C') ADVANCE(1101);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(3731);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(1128);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1329);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1368);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1145);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1129);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1131);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1564);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1369);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1133);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1134);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1156);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1565);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1135);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1147);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1136);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1190);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1843);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1146);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1627);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1975);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(714)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3770);
      END_STATE();
    case 715:
      if (lookahead == '!') ADVANCE(3740);
      END_STATE();
    case 716:
      if (lookahead == '!') ADVANCE(3740);
      if (lookahead == '=') ADVANCE(3759);
      if (lookahead == '~') ADVANCE(3762);
      END_STATE();
    case 717:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(108);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3491);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3530);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(717)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 718:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(178)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3234);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(718)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 719:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(240)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3242);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(719)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 720:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(242)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3405);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3234);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(720)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 721:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(300)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3430);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3167);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3408);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(721)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 722:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(162)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(722)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 723:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(210)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3236);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(723)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 724:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(212)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3405);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(724)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 725:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(286)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3430);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3167);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3408);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3282);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(725)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 726:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(146)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(726)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 727:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(422)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3234);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(727)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 728:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(184)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3405);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(728)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 729:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(188)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3235);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(729)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 730:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(476)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3234);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(730)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 731:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(438)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3405);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3234);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(731)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 732:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(440)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3242);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(732)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 733:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(482)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3405);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3234);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(733)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 734:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(484)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3242);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(734)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 735:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(652)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3241);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(735)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 736:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(656)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3405);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3241);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(736)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 737:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(658)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3238);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(737)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 738:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(208)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(738)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 739:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(270)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3405);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(739)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 740:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(272)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(740)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 741:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(262)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(741)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 742:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(230)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3282);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(742)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 743:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(216)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3281);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(743)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 744:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(256)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(744)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 745:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(450)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(745)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 746:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(662)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3288);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(746)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 747:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(288)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(747)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 748:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(748)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 749:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(376);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(749)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 750:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(454);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(750)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 751:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(494);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(751)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 752:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3368);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(752)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 753:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(522);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(753)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 754:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3204);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(754)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 755:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(534);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(755)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 756:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(756)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 757:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(382);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3368);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(757)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 758:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(458);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3204);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(758)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 759:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(388);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3204);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(759)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 760:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(392);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(760)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 761:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(498);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(761)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 762:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(462);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(762)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 763:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(763)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 764:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(76);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(764)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 765:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(80);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(765)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 766:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(86);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3491);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3530);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(766)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 767:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(90);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(767)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 768:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(408);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(768)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 769:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(112);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(769)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 770:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(124);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(770)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 771:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(771)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 772:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(772)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 773:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(384);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(773)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 774:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3204);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(774)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 775:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(775)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 776:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(776)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 777:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(96);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3236);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(777)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 778:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(120);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3236);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(778)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 779:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(779)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 780:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(374);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(780)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 781:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(18);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3368);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(781)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 782:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(452);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(782)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 783:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(380);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3368);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(783)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 784:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(492);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(784)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 785:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(785)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 786:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(70);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(786)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 787:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(404);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(787)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 788:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(84);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3491);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3530);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(788)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 789:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(470);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3235);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(789)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 790:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(406);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(790)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 791:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(94);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(791)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 792:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(472);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3235);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(792)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 793:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(412);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3491);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3530);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(793)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 794:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(508);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(794)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 795:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(418);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(795)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 796:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(510);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(796)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 797:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(542);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(797)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 798:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(546);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3368);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(798)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 799:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(608);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(799)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 800:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(592);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3368);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(800)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 801:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(562);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(801)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 802:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(566);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(802)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 803:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(598);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(803)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 804:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(568);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3491);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3530);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(804)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 805:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(612);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(805)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 806:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(600);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(806)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 807:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(570);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(807)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 808:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(614);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3237);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(808)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 809:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(602);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3491);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3530);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(809)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 810:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(604);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(810)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 811:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(630);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(811)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 812:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(666);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(812)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 813:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(634);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3368);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(813)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 814:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(642);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(814)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 815:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(644);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(815)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 816:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(646);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3491);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3530);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(816)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 817:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(648);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(817)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 818:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(676);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(818)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 819:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(680);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3368);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(819)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 820:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(688);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3255);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3014);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(820)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 821:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(690);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3394);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3138);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3175);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(821)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 822:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(692);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3491);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3530);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(822)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 823:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(694);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3398);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(823)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 824:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3304);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2965);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(824)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 825:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(825)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 826:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(396);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(826)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 827:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(466);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(827)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 828:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(504);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3202);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(828)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 829:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(526);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3114);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3369);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(829)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 830:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(538);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(830)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 831:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(254)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3401);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3584);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(831)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 832:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(168);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3306);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3683);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3492);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3397);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3542);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(832)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 833:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3304);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2964);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(833)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 834:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(834)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 835:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(400);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3114);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3369);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(835)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 836:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(226)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3401);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3584);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3282);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(836)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 837:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3306);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3683);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3492);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3397);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3544);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3282);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(837)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 838:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(194)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3400);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3584);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3281);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(838)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 839:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(250)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3400);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3584);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(839)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 840:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(448)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3400);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3584);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(840)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 841:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(660)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3400);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3584);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3288);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(841)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 842:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(280)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3429);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3403);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2986);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3401);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3256);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3015);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3584);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(842)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 843:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(284)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3430);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3167);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3408);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3281);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(843)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 844:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(304)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3430);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3167);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3408);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(844)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 845:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(306)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3430);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3167);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3408);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(845)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 846:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(664)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3430);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3167);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3408);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3288);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(846)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 847:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(310)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3430);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3167);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3408);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3514);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(847)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 848:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(848)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 849:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(378);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(849)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 850:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(850)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 851:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3203);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3253);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(851)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 852:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(386);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3172);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3203);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(852)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 853:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3253);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(853)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('J' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 854:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(496);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(854)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 855:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(460);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(855)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 856:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3203);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(856)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 857:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(500);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3203);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(857)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 858:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(524);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(858)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 859:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(50);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(859)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 860:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(536);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(860)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 861:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(398);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(861)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 862:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(544);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(862)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 863:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(610);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(863)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 864:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(548);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3203);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(864)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 865:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(550);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(865)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('J' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 866:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(554);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3203);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(866)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 867:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(556);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(867)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 868:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(632);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(868)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 869:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(668);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(869)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 870:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(636);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3203);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(870)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 871:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(638);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(871)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('J' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 872:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(674);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3271);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(872)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 873:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(678);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3366);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(873)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 874:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(682);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3203);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(874)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 875:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(684);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(875)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('J' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 876:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(706);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3305);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3172);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3203);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(876)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 877:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(712);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(877)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 878:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3304);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2965);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(878)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 879:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '\\') ADVANCE(40);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3304);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2965);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(879)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 880:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '\\') ADVANCE(700);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3304);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2965);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(880)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 881:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(38);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3253);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(881)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 882:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(394);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3253);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(882)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 883:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(464);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3114);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3369);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(883)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 884:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(502);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(884)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 885:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(885)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 886:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(402);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(886)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 887:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(468);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3114);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3369);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(887)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 888:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(506);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(888)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 889:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(552);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(889)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 890:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(594);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(890)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 891:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(558);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(891)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 892:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(596);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(892)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 893:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(640);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(893)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 894:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(670);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(894)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 895:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(686);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(895)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 896:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(698);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3201);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(896)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 897:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(708);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3114);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3369);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(897)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 898:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(710);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3303);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3367);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(898)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 899:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(152);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3306);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3683);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3270);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3397);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3542);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3281);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(899)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 900:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(426);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3306);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3683);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3492);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3397);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3542);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(900)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 901:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(654);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3306);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3683);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3270);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3397);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3481);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3513);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3542);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(901)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 902:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1106);
      if (lookahead == '\\') ADVANCE(66);
      if (lookahead == ']') ADVANCE(3731);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1625);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1743);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1493);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1427);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1130);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1678);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1866);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1472);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1160);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1576);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2044);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1433);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1432);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1237);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1911);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1188);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1637);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(902)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2903);
      END_STATE();
    case 903:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1103);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1176);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1810);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1427);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1906);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1458);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1231);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1942);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1571);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2044);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1428);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1298);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1235);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1911);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1228);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1642);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(903)
      END_STATE();
    case 904:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1106);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1625);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1810);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1427);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1459);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2079);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1972);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1574);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2044);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1148);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1911);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1640);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(904)
      END_STATE();
    case 905:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1106);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(122);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1625);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1810);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1451);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1868);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1972);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1841);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2044);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1438);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1911);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1685);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(905)
      END_STATE();
    case 906:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1808);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1624);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1439);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1907);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1677);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1866);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1472);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1161);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1578);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2031);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1440);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1240);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1911);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1644);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(906)
      END_STATE();
    case 907:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1811);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1439);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1678);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1866);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1472);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1572);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1440);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1641);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(907)
      END_STATE();
    case 908:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(118);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1809);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1446);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1459);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2079);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1973);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1580);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1150);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1640);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(908)
      END_STATE();
    case 909:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(410);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1811);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1439);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1678);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1866);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1470);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1841);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1440);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1640);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(909)
      END_STATE();
    case 910:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1107);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(132)
      if (lookahead == ']') ADVANCE(3731);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1623);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1901);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1796);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1676);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1972);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1841);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2063);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1545);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1526);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1626);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1910);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1628);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(910)
      END_STATE();
    case 911:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1107);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(246)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1623);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1901);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2067);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1972);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1578);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2031);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1545);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1910);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1700);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(911)
      END_STATE();
    case 912:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(142)
      if (lookahead == ']') ADVANCE(3731);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1900);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1518);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1796);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1457);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2043);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1973);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1580);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2072);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1152);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1626);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1628);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(912)
      END_STATE();
    case 913:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(186)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1678);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2067);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1870);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1472);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1578);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2068);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1544);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1644);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(913)
      END_STATE();
    case 914:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(222)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1678);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1870);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1470);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1841);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2068);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1645);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(2125);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1638);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(914)
      END_STATE();
    case 915:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(274)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2043);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2019);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2068);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1152);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1682);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(915)
      END_STATE();
    case 916:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(292)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1560);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1873);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2022);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2068);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1682);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(916)
      END_STATE();
    case 917:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1105);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(64);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1241);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1810);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1427);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1460);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2079);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1662);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1972);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1573);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2031);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1151);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1137);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1875);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1638);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(917)
      END_STATE();
    case 918:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(98);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1809);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1446);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1459);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1973);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1580);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2068);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1532);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1638);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(918)
      END_STATE();
    case 919:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3713);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(104);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1811);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1439);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1578);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2068);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1532);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1700);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(919)
      END_STATE();
    case 920:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1811);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1439);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2240);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1866);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1470);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2021);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2068);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1531);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1638);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(920)
      END_STATE();
    case 921:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(138);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1811);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1868);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2021);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2068);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1532);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1187);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1682);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(921)
      END_STATE();
    case 922:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1106);
      if (lookahead == '\\') ADVANCE(68);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1625);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1810);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1427);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1972);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1578);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2044);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1436);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1911);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1696);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(922)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2903);
      END_STATE();
    case 923:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1808);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1439);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1678);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1866);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1472);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1572);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1440);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1643);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(923)
      END_STATE();
    case 924:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(136);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1808);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1439);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1577);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1532);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1687);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(924)
      END_STATE();
    case 925:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1107);
      if (lookahead == '\\') SKIP(218)
      if (lookahead == ']') ADVANCE(3731);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1623);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1901);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1796);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1676);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1972);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2022);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2071);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1545);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1626);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1910);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1629);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(925)
      END_STATE();
    case 926:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(200)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1678);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2067);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1870);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1472);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1578);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1645);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1643);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(926)
      END_STATE();
    case 927:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(234)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1900);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1518);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1456);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2043);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1973);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1580);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1152);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1684);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(927)
      END_STATE();
    case 928:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(244)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1678);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1870);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1470);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1841);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1645);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(2125);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1639);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(928)
      END_STATE();
    case 929:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(268)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2067);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1578);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1696);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(929)
      END_STATE();
    case 930:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(282)
      if (lookahead == ']') ADVANCE(3731);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1899);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1796);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1676);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2022);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2076);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1626);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1631);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(930)
      END_STATE();
    case 931:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(290)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2043);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2019);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1152);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1684);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(931)
      END_STATE();
    case 932:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(296)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1560);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1873);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2022);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1684);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(932)
      END_STATE();
    case 933:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1107);
      if (lookahead == '\\') SKIP(294)
      if (lookahead == ']') ADVANCE(3731);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1623);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1901);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1796);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1979);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1972);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2021);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2071);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1545);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1626);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1910);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1630);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(933)
      END_STATE();
    case 934:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(276)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2240);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2067);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1870);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1472);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1577);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1645);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1641);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(934)
      END_STATE();
    case 935:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(298)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2240);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1870);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1470);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1840);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1645);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(2125);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1640);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(935)
      END_STATE();
    case 936:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(302)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1900);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1518);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1455);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2043);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1973);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1579);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1152);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1685);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(936)
      END_STATE();
    case 937:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(308)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2067);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1577);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1687);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(937)
      END_STATE();
    case 938:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(314)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2043);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1869);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2018);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1152);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1685);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(938)
      END_STATE();
    case 939:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') SKIP(316)
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1902);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1560);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1873);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2021);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1685);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(939)
      END_STATE();
    case 940:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(92);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1809);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1446);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1459);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1973);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1580);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1532);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1639);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(940)
      END_STATE();
    case 941:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(106);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1811);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1439);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2006);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1132);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1578);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1532);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1646);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(941)
      END_STATE();
    case 942:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(110);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1811);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1439);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1678);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1866);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1940);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1470);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1159);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2022);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1531);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1639);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(942)
      END_STATE();
    case 943:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(416);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1809);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1446);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1661);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1973);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1580);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1532);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1686);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(943)
      END_STATE();
    case 944:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == 'C') ADVANCE(1106);
      if (lookahead == '\\') ADVANCE(88);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == 'c') ADVANCE(1625);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1810);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1427);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1863);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1972);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2022);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2044);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1438);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1911);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1684);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(944)
      END_STATE();
    case 945:
      if (lookahead == '!') ADVANCE(1085);
      if (lookahead == '#') ADVANCE(3755);
      if (lookahead == '%') ADVANCE(3749);
      if (lookahead == '&') ADVANCE(3752);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3739);
      if (lookahead == '/') ADVANCE(3748);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '<') ADVANCE(3756);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '>') ADVANCE(3760);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == '^') ADVANCE(3746);
      if (lookahead == '|') ADVANCE(3754);
      if (lookahead == '~') ADVANCE(3742);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1811);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1492);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1905);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1675);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2049);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1868);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1971);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2022);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1532);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1430);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2065);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1684);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(945)
      END_STATE();
    case 946:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(150)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3006);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2948);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3535);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3016);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3234);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(946)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 947:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(176)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3006);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2949);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3198);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(947)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 948:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(206)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3355);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3006);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3275);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2949);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(948)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 949:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(228)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3006);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2949);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(949)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 950:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(2593);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2948);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3365);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2950);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3506);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(950)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 951:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2958);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2948);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3365);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2950);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3506);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(951)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 952:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3309);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3002);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2948);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3391);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3016);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3461);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3529);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(952)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 953:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') ADVANCE(62);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3309);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3003);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2948);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3391);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3016);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3176);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(953)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 954:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') ADVANCE(560);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3309);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3002);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2948);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3391);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3016);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3461);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3529);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(954)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 955:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') ADVANCE(564);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3309);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3003);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2948);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3391);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3016);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3176);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(955)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 956:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(144)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3006);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2949);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3442);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3198);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(956)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 957:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(170)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3004);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2949);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3548);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3486);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(957)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 958:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(192)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3006);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2949);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3442);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(958)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 959:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(214)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3181);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3005);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2949);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3418);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(959)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 960:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(220)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3005);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2949);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3418);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(960)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 961:
      if (lookahead == '!') ADVANCE(715);
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '$') ADVANCE(3769);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '*') ADVANCE(3747);
      if (lookahead == '+') ADVANCE(3737);
      if (lookahead == '-') ADVANCE(3738);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '@') ADVANCE(3743);
      if (lookahead == '\\') SKIP(252)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1082);
      if (lookahead == '~') ADVANCE(3741);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3006);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3148);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2949);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3456);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3547);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(961)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 962:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '&') ADVANCE(1068);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '|') ADVANCE(1126);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(962)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 963:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '\'') ADVANCE(3714);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(2277);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') SKIP(330)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3017);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(963)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2902);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 964:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '=') ADVANCE(2684);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') SKIP(322)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3480);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3539);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2988);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3282);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(964)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 965:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') SKIP(338)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(965)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 966:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(966)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 967:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(967)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 968:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(164);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3372);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(968)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 969:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(574);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3013);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(969)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 970:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(578);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3372);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(970)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 971:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3308);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2965);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(971)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 972:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(128);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3308);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2964);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(972)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 973:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3308);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3402);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2965);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(973)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 974:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(190);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(974)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 975:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(442);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(975)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 976:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(486);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3134);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(976)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 977:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(518);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(977)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 978:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(174);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2962);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3370);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3680);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2966);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3133);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2987);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(978)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 979:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(434);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3114);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3371);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3402);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(979)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 980:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '(') ADVANCE(2519);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') SKIP(344)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3468);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(980)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 981:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') SKIP(340)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(981)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 982:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') SKIP(328)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3244);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3682);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3493);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3532);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3440);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(982)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 983:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ')') ADVANCE(2520);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') SKIP(332)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3410);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3661);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2991);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(983)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 984:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(238);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2963);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3126);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(984)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 985:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(116);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3205);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(985)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 986:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(420);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3675);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(986)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 987:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(474);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3205);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(987)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 988:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(512);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(988)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 989:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(528);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(989)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 990:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(990)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 991:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(166);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(991)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 992:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(540);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3675);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(992)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 993:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(424);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(993)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 994:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(172);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(994)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 995:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(432);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(995)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 996:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(430);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(996)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 997:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(196);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(997)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 998:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(478);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3207);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(998)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 999:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(480);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3207);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(999)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1000:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(514);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3207);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1000)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1001:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(516);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3207);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1001)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1002:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(248);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1002)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1003:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(530);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3207);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1003)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1004:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1004)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1005:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(532);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3207);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1005)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1006:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(572);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3205);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3232);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1006)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1007:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(616);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3205);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1007)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1008:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(620);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3091);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1008)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1009:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(626);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3667);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1009)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1010:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(576);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3519);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1010)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1011:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(580);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1011)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1012:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(606);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1012)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1013:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1013)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1014:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(618);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3207);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1014)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1015:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(622);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3459);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3207);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1015)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1016:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(628);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3207);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1016)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1017:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(650);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3205);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3240);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1017)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1018:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(672);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2977);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3675);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1018)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1019:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == ',') ADVANCE(2511);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(696);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3272);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3374);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3490);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2976);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2985);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3205);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3118);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1019)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1020:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(224);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2962);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3370);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3680);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3133);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1020)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1021:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(236);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2963);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3062);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3180);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1021)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1022:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(320);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3309);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3476);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3171);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3451);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3491);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3530);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1022)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1023:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(324);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3309);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3433);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3451);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1023)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1024:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') SKIP(354)
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3402);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1024)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1025:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') ADVANCE(156);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3309);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3683);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3466);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3451);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3542);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3121);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3245);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1025)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1026:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') ADVANCE(428);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3309);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3683);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3467);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3451);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3542);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3121);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3245);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1026)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1027:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '.') ADVANCE(3712);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == '\\') ADVANCE(258);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3309);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3683);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3451);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3177);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3116);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3284);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1027)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1028:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '\\') ADVANCE(126);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3308);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3675);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2965);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1028)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1029:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '\\') ADVANCE(154);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3308);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3675);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2965);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1029)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1030:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == 'C') ADVANCE(2925);
      if (lookahead == '\\') ADVANCE(702);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3308);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3110);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3675);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2965);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3111);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3439);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1030)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1031:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(204);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3675);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1031)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1032:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(264);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3675);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1032)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1033:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(1084);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(704);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3273);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3675);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1033)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1034:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(198);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2999);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1034)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1035:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(444);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3458);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1035)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1036:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '[') ADVANCE(3730);
      if (lookahead == '\\') ADVANCE(488);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3134);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3291);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1036)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1037:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3505);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3375);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2978);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3206);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3251);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1037)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1038:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(232);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3090);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3373);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3497);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3471);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(3239);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1038)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3691);
      END_STATE();
    case 1039:
      if (lookahead == '"') ADVANCE(3702);
      if (lookahead == '-') ADVANCE(1080);
      if (lookahead == '/') ADVANCE(1077);
      if (lookahead == ';') ADVANCE(2500);
      if (lookahead == '\\') ADVANCE(446);
      if (lookahead == '`') ADVANCE(3692);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3307);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(3089);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3000);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(3114);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3684);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3531);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3371);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2979);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3457);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3460);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2967);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3092);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(3132);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3516);
      if (lookahead == 'U' ||
          loo