#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 396
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 142
#define ALIAS_COUNT 0
#define TOKEN_COUNT 62
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum
{
  anon_sym_schema = 1,
  anon_sym_LBRACE = 2,
  anon_sym_RBRACE = 3,
  anon_sym_extend = 4,
  anon_sym_scalar = 5,
  anon_sym_type = 6,
  anon_sym_interface = 7,
  anon_sym_union = 8,
  anon_sym_enum = 9,
  anon_sym_input = 10,
  anon_sym_AMP = 11,
  anon_sym_implements = 12,
  anon_sym_COLON = 13,
  anon_sym_LPAREN = 14,
  anon_sym_RPAREN = 15,
  anon_sym_EQ = 16,
  anon_sym_PIPE = 17,
  anon_sym_query = 18,
  anon_sym_mutation = 19,
  anon_sym_subscription = 20,
  anon_sym_DOLLAR = 21,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 22,
  aux_sym_string_value_token1 = 23,
  anon_sym_DQUOTE = 24,
  aux_sym_string_value_token2 = 25,
  sym_int_value = 26,
  sym_float_value = 27,
  anon_sym_true = 28,
  anon_sym_false = 29,
  sym_null_value = 30,
  anon_sym_LBRACK = 31,
  anon_sym_RBRACK = 32,
  anon_sym_DOT_DOT_DOT = 33,
  anon_sym_fragment = 34,
  anon_sym_on = 35,
  anon_sym_AT = 36,
  anon_sym_directive = 37,
  anon_sym_repeatable = 38,
  anon_sym_QUERY = 39,
  anon_sym_MUTATION = 40,
  anon_sym_SUBSCRIPTION = 41,
  anon_sym_FIELD = 42,
  anon_sym_FRAGMENT_DEFINITION = 43,
  anon_sym_FRAGMENT_SPREAD = 44,
  anon_sym_INLINE_FRAGMENT = 45,
  anon_sym_VARIABLE_DEFINITION = 46,
  anon_sym_SCHEMA = 47,
  anon_sym_SCALAR = 48,
  anon_sym_OBJECT = 49,
  anon_sym_FIELD_DEFINITION = 50,
  anon_sym_ARGUMENT_DEFINITION = 51,
  anon_sym_INTERFACE = 52,
  anon_sym_UNION = 53,
  anon_sym_ENUM = 54,
  anon_sym_ENUM_VALUE = 55,
  anon_sym_INPUT_OBJECT = 56,
  anon_sym_INPUT_FIELD_DEFINITION = 57,
  anon_sym_BANG = 58,
  sym_name = 59,
  sym_comment = 60,
  sym_comma = 61,
  sym_source_file = 62,
  sym_document = 63,
  sym_definition = 64,
  sym_executable_definition = 65,
  sym_type_system_definition = 66,
  sym_type_system_extension = 67,
  sym_schema_definition = 68,
  sym_schema_extension = 69,
  sym_type_extension = 70,
  sym_scalar_type_extension = 71,
  sym_object_type_extension = 72,
  sym_interface_type_extension = 73,
  sym_union_type_extension = 74,
  sym_enum_type_extension = 75,
  sym_input_object_type_extension = 76,
  sym_input_fields_definition = 77,
  sym_enum_values_definition = 78,
  sym_enum_value_definition = 79,
  sym_implements_interfaces = 80,
  sym_fields_definition = 81,
  sym_field_definition = 82,
  sym_arguments_definition = 83,
  sym_input_value_definition = 84,
  sym_default_value = 85,
  sym_union_member_types = 86,
  sym_root_operation_type_definition = 87,
  sym_operation_definition = 88,
  sym_operation_type = 89,
  sym_type_definition = 90,
  sym_scalar_type_definition = 91,
  sym_object_type_definition = 92,
  sym_interface_type_definition = 93,
  sym_union_type_definition = 94,
  sym_enum_type_definition = 95,
  sym_input_object_type_definition = 96,
  sym_variable_definitions = 97,
  sym_variable_definition = 98,
  sym_selection_set = 99,
  sym_selection = 100,
  sym_field = 101,
  sym_alias = 102,
  sym_arguments = 103,
  sym_argument = 104,
  sym_value = 105,
  sym_variable = 106,
  sym_string_value = 107,
  sym_boolean_value = 108,
  sym_enum_value = 109,
  sym_list_value = 110,
  sym_object_value = 111,
  sym_object_field = 112,
  sym_fragment_spread = 113,
  sym_fragment_definition = 114,
  sym_fragment_name = 115,
  sym_inline_fragment = 116,
  sym_type_condition = 117,
  sym_directives = 118,
  sym_directive = 119,
  sym_directive_definition = 120,
  sym_directive_locations = 121,
  sym_directive_location = 122,
  sym_executable_directive_location = 123,
  sym_type_system_directive_location = 124,
  sym_type = 125,
  sym_named_type = 126,
  sym_list_type = 127,
  sym_non_null_type = 128,
  sym_description = 129,
  aux_sym_document_repeat1 = 130,
  aux_sym_schema_definition_repeat1 = 131,
  aux_sym_input_object_type_extension_repeat1 = 132,
  aux_sym_input_fields_definition_repeat1 = 133,
  aux_sym_enum_values_definition_repeat1 = 134,
  aux_sym_fields_definition_repeat1 = 135,
  aux_sym_variable_definitions_repeat1 = 136,
  aux_sym_selection_set_repeat1 = 137,
  aux_sym_arguments_repeat1 = 138,
  aux_sym_list_value_repeat1 = 139,
  aux_sym_object_value_repeat1 = 140,
  aux_sym_directives_repeat1 = 141,
};

static const char *ts_symbol_names[] = {
    [ts_builtin_sym_end] = "end",
    [anon_sym_schema] = "schema",
    [anon_sym_LBRACE] = "{",
    [anon_sym_RBRACE] = "}",
    [anon_sym_extend] = "extend",
    [anon_sym_scalar] = "scalar",
    [anon_sym_type] = "type",
    [anon_sym_interface] = "interface",
    [anon_sym_union] = "union",
    [anon_sym_enum] = "enum",
    [anon_sym_input] = "input",
    [anon_sym_AMP] = "&",
    [anon_sym_implements] = "implements",
    [anon_sym_COLON] = ":",
    [anon_sym_LPAREN] = "(",
    [anon_sym_RPAREN] = ")",
    [anon_sym_EQ] = "=",
    [anon_sym_PIPE] = "|",
    [anon_sym_query] = "query",
    [anon_sym_mutation] = "mutation",
    [anon_sym_subscription] = "subscription",
    [anon_sym_DOLLAR] = "$",
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
    [aux_sym_string_value_token1] = "string_value_token1",
    [anon_sym_DQUOTE] = "\"",
    [aux_sym_string_value_token2] = "string_value_token2",
    [sym_int_value] = "int_value",
    [sym_float_value] = "float_value",
    [anon_sym_true] = "true",
    [anon_sym_false] = "false",
    [sym_null_value] = "null_value",
    [anon_sym_LBRACK] = "[",
    [anon_sym_RBRACK] = "]",
    [anon_sym_DOT_DOT_DOT] = "...",
    [anon_sym_fragment] = "fragment",
    [anon_sym_on] = "on",
    [anon_sym_AT] = "@",
    [anon_sym_directive] = "directive",
    [anon_sym_repeatable] = "repeatable",
    [anon_sym_QUERY] = "QUERY",
    [anon_sym_MUTATION] = "MUTATION",
    [anon_sym_SUBSCRIPTION] = "SUBSCRIPTION",
    [anon_sym_FIELD] = "FIELD",
    [anon_sym_FRAGMENT_DEFINITION] = "FRAGMENT_DEFINITION",
    [anon_sym_FRAGMENT_SPREAD] = "FRAGMENT_SPREAD",
    [anon_sym_INLINE_FRAGMENT] = "INLINE_FRAGMENT",
    [anon_sym_VARIABLE_DEFINITION] = "VARIABLE_DEFINITION",
    [anon_sym_SCHEMA] = "SCHEMA",
    [anon_sym_SCALAR] = "SCALAR",
    [anon_sym_OBJECT] = "OBJECT",
    [anon_sym_FIELD_DEFINITION] = "FIELD_DEFINITION",
    [anon_sym_ARGUMENT_DEFINITION] = "ARGUMENT_DEFINITION",
    [anon_sym_INTERFACE] = "INTERFACE",
    [anon_sym_UNION] = "UNION",
    [anon_sym_ENUM] = "ENUM",
    [anon_sym_ENUM_VALUE] = "ENUM_VALUE",
    [anon_sym_INPUT_OBJECT] = "INPUT_OBJECT",
    [anon_sym_INPUT_FIELD_DEFINITION] = "INPUT_FIELD_DEFINITION",
    [anon_sym_BANG] = "!",
    [sym_name] = "name",
    [sym_comment] = "comment",
    [sym_comma] = "comma",
    [sym_source_file] = "source_file",
    [sym_document] = "document",
    [sym_definition] = "definition",
    [sym_executable_definition] = "executable_definition",
    [sym_type_system_definition] = "type_system_definition",
    [sym_type_system_extension] = "type_system_extension",
    [sym_schema_definition] = "schema_definition",
    [sym_schema_extension] = "schema_extension",
    [sym_type_extension] = "type_extension",
    [sym_scalar_type_extension] = "scalar_type_extension",
    [sym_object_type_extension] = "object_type_extension",
    [sym_interface_type_extension] = "interface_type_extension",
    [sym_union_type_extension] = "union_type_extension",
    [sym_enum_type_extension] = "enum_type_extension",
    [sym_input_object_type_extension] = "input_object_type_extension",
    [sym_input_fields_definition] = "input_fields_definition",
    [sym_enum_values_definition] = "enum_values_definition",
    [sym_enum_value_definition] = "enum_value_definition",
    [sym_implements_interfaces] = "implements_interfaces",
    [sym_fields_definition] = "fields_definition",
    [sym_field_definition] = "field_definition",
    [sym_arguments_definition] = "arguments_definition",
    [sym_input_value_definition] = "input_value_definition",
    [sym_default_value] = "default_value",
    [sym_union_member_types] = "union_member_types",
    [sym_root_operation_type_definition] = "root_operation_type_definition",
    [sym_operation_definition] = "operation_definition",
    [sym_operation_type] = "operation_type",
    [sym_type_definition] = "type_definition",
    [sym_scalar_type_definition] = "scalar_type_definition",
    [sym_object_type_definition] = "object_type_definition",
    [sym_interface_type_definition] = "interface_type_definition",
    [sym_union_type_definition] = "union_type_definition",
    [sym_enum_type_definition] = "enum_type_definition",
    [sym_input_object_type_definition] = "input_object_type_definition",
    [sym_variable_definitions] = "variable_definitions",
    [sym_variable_definition] = "variable_definition",
    [sym_selection_set] = "selection_set",
    [sym_selection] = "selection",
    [sym_field] = "field",
    [sym_alias] = "alias",
    [sym_arguments] = "arguments",
    [sym_argument] = "argument",
    [sym_value] = "value",
    [sym_variable] = "variable",
    [sym_string_value] = "string_value",
    [sym_boolean_value] = "boolean_value",
    [sym_enum_value] = "enum_value",
    [sym_list_value] = "list_value",
    [sym_object_value] = "object_value",
    [sym_object_field] = "object_field",
    [sym_fragment_spread] = "fragment_spread",
    [sym_fragment_definition] = "fragment_definition",
    [sym_fragment_name] = "fragment_name",
    [sym_inline_fragment] = "inline_fragment",
    [sym_type_condition] = "type_condition",
    [sym_directives] = "directives",
    [sym_directive] = "directive",
    [sym_directive_definition] = "directive_definition",
    [sym_directive_locations] = "directive_locations",
    [sym_directive_location] = "directive_location",
    [sym_executable_directive_location] = "executable_directive_location",
    [sym_type_system_directive_location] = "type_system_directive_location",
    [sym_type] = "type",
    [sym_named_type] = "named_type",
    [sym_list_type] = "list_type",
    [sym_non_null_type] = "non_null_type",
    [sym_description] = "description",
    [aux_sym_document_repeat1] = "document_repeat1",
    [aux_sym_schema_definition_repeat1] = "schema_definition_repeat1",
    [aux_sym_input_object_type_extension_repeat1] = "input_object_type_extension_repeat1",
    [aux_sym_input_fields_definition_repeat1] = "input_fields_definition_repeat1",
    [aux_sym_enum_values_definition_repeat1] = "enum_values_definition_repeat1",
    [aux_sym_fields_definition_repeat1] = "fields_definition_repeat1",
    [aux_sym_variable_definitions_repeat1] = "variable_definitions_repeat1",
    [aux_sym_selection_set_repeat1] = "selection_set_repeat1",
    [aux_sym_arguments_repeat1] = "arguments_repeat1",
    [aux_sym_list_value_repeat1] = "list_value_repeat1",
    [aux_sym_object_value_repeat1] = "object_value_repeat1",
    [aux_sym_directives_repeat1] = "directives_repeat1",
};

static TSSymbol ts_symbol_map[] = {
    [ts_builtin_sym_end] = ts_builtin_sym_end,
    [anon_sym_schema] = anon_sym_schema,
    [anon_sym_LBRACE] = anon_sym_LBRACE,
    [anon_sym_RBRACE] = anon_sym_RBRACE,
    [anon_sym_extend] = anon_sym_extend,
    [anon_sym_scalar] = anon_sym_scalar,
    [anon_sym_type] = anon_sym_type,
    [anon_sym_interface] = anon_sym_interface,
    [anon_sym_union] = anon_sym_union,
    [anon_sym_enum] = anon_sym_enum,
    [anon_sym_input] = anon_sym_input,
    [anon_sym_AMP] = anon_sym_AMP,
    [anon_sym_implements] = anon_sym_implements,
    [anon_sym_COLON] = anon_sym_COLON,
    [anon_sym_LPAREN] = anon_sym_LPAREN,
    [anon_sym_RPAREN] = anon_sym_RPAREN,
    [anon_sym_EQ] = anon_sym_EQ,
    [anon_sym_PIPE] = anon_sym_PIPE,
    [anon_sym_query] = anon_sym_query,
    [anon_sym_mutation] = anon_sym_mutation,
    [anon_sym_subscription] = anon_sym_subscription,
    [anon_sym_DOLLAR] = anon_sym_DOLLAR,
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
    [aux_sym_string_value_token1] = aux_sym_string_value_token1,
    [anon_sym_DQUOTE] = anon_sym_DQUOTE,
    [aux_sym_string_value_token2] = aux_sym_string_value_token2,
    [sym_int_value] = sym_int_value,
    [sym_float_value] = sym_float_value,
    [anon_sym_true] = anon_sym_true,
    [anon_sym_false] = anon_sym_false,
    [sym_null_value] = sym_null_value,
    [anon_sym_LBRACK] = anon_sym_LBRACK,
    [anon_sym_RBRACK] = anon_sym_RBRACK,
    [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
    [anon_sym_fragment] = anon_sym_fragment,
    [anon_sym_on] = anon_sym_on,
    [anon_sym_AT] = anon_sym_AT,
    [anon_sym_directive] = anon_sym_directive,
    [anon_sym_repeatable] = anon_sym_repeatable,
    [anon_sym_QUERY] = anon_sym_QUERY,
    [anon_sym_MUTATION] = anon_sym_MUTATION,
    [anon_sym_SUBSCRIPTION] = anon_sym_SUBSCRIPTION,
    [anon_sym_FIELD] = anon_sym_FIELD,
    [anon_sym_FRAGMENT_DEFINITION] = anon_sym_FRAGMENT_DEFINITION,
    [anon_sym_FRAGMENT_SPREAD] = anon_sym_FRAGMENT_SPREAD,
    [anon_sym_INLINE_FRAGMENT] = anon_sym_INLINE_FRAGMENT,
    [anon_sym_VARIABLE_DEFINITION] = anon_sym_VARIABLE_DEFINITION,
    [anon_sym_SCHEMA] = anon_sym_SCHEMA,
    [anon_sym_SCALAR] = anon_sym_SCALAR,
    [anon_sym_OBJECT] = anon_sym_OBJECT,
    [anon_sym_FIELD_DEFINITION] = anon_sym_FIELD_DEFINITION,
    [anon_sym_ARGUMENT_DEFINITION] = anon_sym_ARGUMENT_DEFINITION,
    [anon_sym_INTERFACE] = anon_sym_INTERFACE,
    [anon_sym_UNION] = anon_sym_UNION,
    [anon_sym_ENUM] = anon_sym_ENUM,
    [anon_sym_ENUM_VALUE] = anon_sym_ENUM_VALUE,
    [anon_sym_INPUT_OBJECT] = anon_sym_INPUT_OBJECT,
    [anon_sym_INPUT_FIELD_DEFINITION] = anon_sym_INPUT_FIELD_DEFINITION,
    [anon_sym_BANG] = anon_sym_BANG,
    [sym_name] = sym_name,
    [sym_comment] = sym_comment,
    [sym_comma] = sym_comma,
    [sym_source_file] = sym_source_file,
    [sym_document] = sym_document,
    [sym_definition] = sym_definition,
    [sym_executable_definition] = sym_executable_definition,
    [sym_type_system_definition] = sym_type_system_definition,
    [sym_type_system_extension] = sym_type_system_extension,
    [sym_schema_definition] = sym_schema_definition,
    [sym_schema_extension] = sym_schema_extension,
    [sym_type_extension] = sym_type_extension,
    [sym_scalar_type_extension] = sym_scalar_type_extension,
    [sym_object_type_extension] = sym_object_type_extension,
    [sym_interface_type_extension] = sym_interface_type_extension,
    [sym_union_type_extension] = sym_union_type_extension,
    [sym_enum_type_extension] = sym_enum_type_extension,
    [sym_input_object_type_extension] = sym_input_object_type_extension,
    [sym_input_fields_definition] = sym_input_fields_definition,
    [sym_enum_values_definition] = sym_enum_values_definition,
    [sym_enum_value_definition] = sym_enum_value_definition,
    [sym_implements_interfaces] = sym_implements_interfaces,
    [sym_fields_definition] = sym_fields_definition,
    [sym_field_definition] = sym_field_definition,
    [sym_arguments_definition] = sym_arguments_definition,
    [sym_input_value_definition] = sym_input_value_definition,
    [sym_default_value] = sym_default_value,
    [sym_union_member_types] = sym_union_member_types,
    [sym_root_operation_type_definition] = sym_root_operation_type_definition,
    [sym_operation_definition] = sym_operation_definition,
    [sym_operation_type] = sym_operation_type,
    [sym_type_definition] = sym_type_definition,
    [sym_scalar_type_definition] = sym_scalar_type_definition,
    [sym_object_type_definition] = sym_object_type_definition,
    [sym_interface_type_definition] = sym_interface_type_definition,
    [sym_union_type_definition] = sym_union_type_definition,
    [sym_enum_type_definition] = sym_enum_type_definition,
    [sym_input_object_type_definition] = sym_input_object_type_definition,
    [sym_variable_definitions] = sym_variable_definitions,
    [sym_variable_definition] = sym_variable_definition,
    [sym_selection_set] = sym_selection_set,
    [sym_selection] = sym_selection,
    [sym_field] = sym_field,
    [sym_alias] = sym_alias,
    [sym_arguments] = sym_arguments,
    [sym_argument] = sym_argument,
    [sym_value] = sym_value,
    [sym_variable] = sym_variable,
    [sym_string_value] = sym_string_value,
    [sym_boolean_value] = sym_boolean_value,
    [sym_enum_value] = sym_enum_value,
    [sym_list_value] = sym_list_value,
    [sym_object_value] = sym_object_value,
    [sym_object_field] = sym_object_field,
    [sym_fragment_spread] = sym_fragment_spread,
    [sym_fragment_definition] = sym_fragment_definition,
    [sym_fragment_name] = sym_fragment_name,
    [sym_inline_fragment] = sym_inline_fragment,
    [sym_type_condition] = sym_type_condition,
    [sym_directives] = sym_directives,
    [sym_directive] = sym_directive,
    [sym_directive_definition] = sym_directive_definition,
    [sym_directive_locations] = sym_directive_locations,
    [sym_directive_location] = sym_directive_location,
    [sym_executable_directive_location] = sym_executable_directive_location,
    [sym_type_system_directive_location] = sym_type_system_directive_location,
    [sym_type] = sym_type,
    [sym_named_type] = sym_named_type,
    [sym_list_type] = sym_list_type,
    [sym_non_null_type] = sym_non_null_type,
    [sym_description] = sym_description,
    [aux_sym_document_repeat1] = aux_sym_document_repeat1,
    [aux_sym_schema_definition_repeat1] = aux_sym_schema_definition_repeat1,
    [aux_sym_input_object_type_extension_repeat1] = aux_sym_input_object_type_extension_repeat1,
    [aux_sym_input_fields_definition_repeat1] = aux_sym_input_fields_definition_repeat1,
    [aux_sym_enum_values_definition_repeat1] = aux_sym_enum_values_definition_repeat1,
    [aux_sym_fields_definition_repeat1] = aux_sym_fields_definition_repeat1,
    [aux_sym_variable_definitions_repeat1] = aux_sym_variable_definitions_repeat1,
    [aux_sym_selection_set_repeat1] = aux_sym_selection_set_repeat1,
    [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
    [aux_sym_list_value_repeat1] = aux_sym_list_value_repeat1,
    [aux_sym_object_value_repeat1] = aux_sym_object_value_repeat1,
    [aux_sym_directives_repeat1] = aux_sym_directives_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
    [ts_builtin_sym_end] = {
        .visible = false,
        .named = true,
    },
    [anon_sym_schema] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_LBRACE] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_RBRACE] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_extend] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_scalar] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_type] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_interface] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_union] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_enum] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_input] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_AMP] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_implements] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_COLON] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_LPAREN] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_RPAREN] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_EQ] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_PIPE] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_query] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_mutation] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_subscription] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_DOLLAR] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
        .visible = true,
        .named = false,
    },
    [aux_sym_string_value_token1] = {
        .visible = false,
        .named = false,
    },
    [anon_sym_DQUOTE] = {
        .visible = true,
        .named = false,
    },
    [aux_sym_string_value_token2] = {
        .visible = false,
        .named = false,
    },
    [sym_int_value] = {
        .visible = true,
        .named = true,
    },
    [sym_float_value] = {
        .visible = true,
        .named = true,
    },
    [anon_sym_true] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_false] = {
        .visible = true,
        .named = false,
    },
    [sym_null_value] = {
        .visible = true,
        .named = true,
    },
    [anon_sym_LBRACK] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_RBRACK] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_DOT_DOT_DOT] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_fragment] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_on] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_AT] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_directive] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_repeatable] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_QUERY] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_MUTATION] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_SUBSCRIPTION] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_FIELD] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_FRAGMENT_DEFINITION] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_FRAGMENT_SPREAD] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_INLINE_FRAGMENT] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_VARIABLE_DEFINITION] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_SCHEMA] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_SCALAR] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_OBJECT] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_FIELD_DEFINITION] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_ARGUMENT_DEFINITION] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_INTERFACE] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_UNION] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_ENUM] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_ENUM_VALUE] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_INPUT_OBJECT] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_INPUT_FIELD_DEFINITION] = {
        .visible = true,
        .named = false,
    },
    [anon_sym_BANG] = {
        .visible = true,
        .named = false,
    },
    [sym_name] = {
        .visible = true,
        .named = true,
    },
    [sym_comment] = {
        .visible = true,
        .named = true,
    },
    [sym_comma] = {
        .visible = true,
        .named = true,
    },
    [sym_source_file] = {
        .visible = true,
        .named = true,
    },
    [sym_document] = {
        .visible = true,
        .named = true,
    },
    [sym_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_executable_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_type_system_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_type_system_extension] = {
        .visible = true,
        .named = true,
    },
    [sym_schema_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_schema_extension] = {
        .visible = true,
        .named = true,
    },
    [sym_type_extension] = {
        .visible = true,
        .named = true,
    },
    [sym_scalar_type_extension] = {
        .visible = true,
        .named = true,
    },
    [sym_object_type_extension] = {
        .visible = true,
        .named = true,
    },
    [sym_interface_type_extension] = {
        .visible = true,
        .named = true,
    },
    [sym_union_type_extension] = {
        .visible = true,
        .named = true,
    },
    [sym_enum_type_extension] = {
        .visible = true,
        .named = true,
    },
    [sym_input_object_type_extension] = {
        .visible = true,
        .named = true,
    },
    [sym_input_fields_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_enum_values_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_enum_value_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_implements_interfaces] = {
        .visible = true,
        .named = true,
    },
    [sym_fields_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_field_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_arguments_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_input_value_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_default_value] = {
        .visible = true,
        .named = true,
    },
    [sym_union_member_types] = {
        .visible = true,
        .named = true,
    },
    [sym_root_operation_type_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_operation_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_operation_type] = {
        .visible = true,
        .named = true,
    },
    [sym_type_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_scalar_type_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_object_type_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_interface_type_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_union_type_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_enum_type_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_input_object_type_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_variable_definitions] = {
        .visible = true,
        .named = true,
    },
    [sym_variable_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_selection_set] = {
        .visible = true,
        .named = true,
    },
    [sym_selection] = {
        .visible = true,
        .named = true,
    },
    [sym_field] = {
        .visible = true,
        .named = true,
    },
    [sym_alias] = {
        .visible = true,
        .named = true,
    },
    [sym_arguments] = {
        .visible = true,
        .named = true,
    },
    [sym_argument] = {
        .visible = true,
        .named = true,
    },
    [sym_value] = {
        .visible = true,
        .named = true,
    },
    [sym_variable] = {
        .visible = true,
        .named = true,
    },
    [sym_string_value] = {
        .visible = true,
        .named = true,
    },
    [sym_boolean_value] = {
        .visible = true,
        .named = true,
    },
    [sym_enum_value] = {
        .visible = true,
        .named = true,
    },
    [sym_list_value] = {
        .visible = true,
        .named = true,
    },
    [sym_object_value] = {
        .visible = true,
        .named = true,
    },
    [sym_object_field] = {
        .visible = true,
        .named = true,
    },
    [sym_fragment_spread] = {
        .visible = true,
        .named = true,
    },
    [sym_fragment_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_fragment_name] = {
        .visible = true,
        .named = true,
    },
    [sym_inline_fragment] = {
        .visible = true,
        .named = true,
    },
    [sym_type_condition] = {
        .visible = true,
        .named = true,
    },
    [sym_directives] = {
        .visible = true,
        .named = true,
    },
    [sym_directive] = {
        .visible = true,
        .named = true,
    },
    [sym_directive_definition] = {
        .visible = true,
        .named = true,
    },
    [sym_directive_locations] = {
        .visible = true,
        .named = true,
    },
    [sym_directive_location] = {
        .visible = true,
        .named = true,
    },
    [sym_executable_directive_location] = {
        .visible = true,
        .named = true,
    },
    [sym_type_system_directive_location] = {
        .visible = true,
        .named = true,
    },
    [sym_type] = {
        .visible = true,
        .named = true,
    },
    [sym_named_type] = {
        .visible = true,
        .named = true,
    },
    [sym_list_type] = {
        .visible = true,
        .named = true,
    },
    [sym_non_null_type] = {
        .visible = true,
        .named = true,
    },
    [sym_description] = {
        .visible = true,
        .named = true,
    },
    [aux_sym_document_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_schema_definition_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_input_object_type_extension_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_input_fields_definition_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_enum_values_definition_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_fields_definition_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_variable_definitions_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_selection_set_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_arguments_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_list_value_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_object_value_repeat1] = {
        .visible = false,
        .named = false,
    },
    [aux_sym_directives_repeat1] = {
        .visible = false,
        .named = false,
    },
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
    [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
    0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state)
{
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state)
  {
  case 0:
    if (eof)
      ADVANCE(269);
    if (lookahead == '!')
      ADVANCE(338);
    if (lookahead == '"')
      ADVANCE(296);
    if (lookahead == '#')
      ADVANCE(353);
    if (lookahead == '$')
      ADVANCE(290);
    if (lookahead == '&')
      ADVANCE(280);
    if (lookahead == '(')
      ADVANCE(283);
    if (lookahead == ')')
      ADVANCE(284);
    if (lookahead == ',')
      ADVANCE(354);
    if (lookahead == '-')
      ADVANCE(8);
    if (lookahead == '.')
      ADVANCE(7);
    if (lookahead == '0')
      ADVANCE(300);
    if (lookahead == ':')
      ADVANCE(282);
    if (lookahead == '=')
      ADVANCE(285);
    if (lookahead == '@')
      ADVANCE(316);
    if (lookahead == 'A')
      ADVANCE(134);
    if (lookahead == 'E')
      ADVANCE(114);
    if (lookahead == 'F')
      ADVANCE(68);
    if (lookahead == 'I')
      ADVANCE(104);
    if (lookahead == 'M')
      ADVANCE(157);
    if (lookahead == 'O')
      ADVANCE(20);
    if (lookahead == 'Q')
      ADVANCE(159);
    if (lookahead == 'S')
      ADVANCE(24);
    if (lookahead == 'U')
      ADVANCE(105);
    if (lookahead == 'V')
      ADVANCE(10);
    if (lookahead == '[')
      ADVANCE(310);
    if (lookahead == ']')
      ADVANCE(311);
    if (lookahead == 'd')
      ADVANCE(205);
    if (lookahead == 'e')
      ADVANCE(228);
    if (lookahead == 'f')
      ADVANCE(171);
    if (lookahead == 'i')
      ADVANCE(217);
    if (lookahead == 'm')
      ADVANCE(259);
    if (lookahead == 'n')
      ADVANCE(260);
    if (lookahead == 'o')
      ADVANCE(222);
    if (lookahead == 'q')
      ADVANCE(258);
    if (lookahead == 'r')
      ADVANCE(195);
    if (lookahead == 's')
      ADVANCE(182);
    if (lookahead == 't')
      ADVANCE(244);
    if (lookahead == 'u')
      ADVANCE(227);
    if (lookahead == '{')
      ADVANCE(271);
    if (lookahead == '|')
      ADVANCE(286);
    if (lookahead == '}')
      ADVANCE(272);
    if (lookahead == '\t' ||
        lookahead == '\n' ||
        lookahead == '\r' ||
        lookahead == ' ' ||
        lookahead == 65279)
      SKIP(0)
    if (('1' <= lookahead && lookahead <= '9'))
      ADVANCE(301);
    END_STATE();
  case 1:
    if (lookahead == '!')
      ADVANCE(338);
    if (lookahead == '"')
      ADVANCE(296);
    if (lookahead == '#')
      ADVANCE(353);
    if (lookahead == '$')
      ADVANCE(290);
    if (lookahead == '&')
      ADVANCE(280);
    if (lookahead == '(')
      ADVANCE(283);
    if (lookahead == ')')
      ADVANCE(284);
    if (lookahead == ',')
      ADVANCE(354);
    if (lookahead == '.')
      ADVANCE(7);
    if (lookahead == ':')
      ADVANCE(282);
    if (lookahead == '=')
      ADVANCE(285);
    if (lookahead == '@')
      ADVANCE(316);
    if (lookahead == '[')
      ADVANCE(310);
    if (lookahead == ']')
      ADVANCE(311);
    if (lookahead == '{')
      ADVANCE(271);
    if (lookahead == '|')
      ADVANCE(286);
    if (lookahead == '}')
      ADVANCE(272);
    if (lookahead == '\t' ||
        lookahead == '\n' ||
        lookahead == '\r' ||
        lookahead == ' ' ||
        lookahead == 65279)
      SKIP(1)
    if (('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 2:
    if (lookahead == '"')
      ADVANCE(296);
    if (lookahead == '#')
      ADVANCE(353);
    if (lookahead == '$')
      ADVANCE(290);
    if (lookahead == ',')
      ADVANCE(354);
    if (lookahead == '-')
      ADVANCE(8);
    if (lookahead == '0')
      ADVANCE(300);
    if (lookahead == '[')
      ADVANCE(310);
    if (lookahead == ']')
      ADVANCE(311);
    if (lookahead == 'f')
      ADVANCE(339);
    if (lookahead == 'n')
      ADVANCE(349);
    if (lookahead == 't')
      ADVANCE(346);
    if (lookahead == '{')
      ADVANCE(271);
    if (lookahead == '\t' ||
        lookahead == '\n' ||
        lookahead == '\r' ||
        lookahead == ' ' ||
        lookahead == 65279)
      SKIP(2)
    if (('1' <= lookahead && lookahead <= '9'))
      ADVANCE(301);
    if (('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 3:
    if (lookahead == '"')
      ADVANCE(291);
    END_STATE();
  case 4:
    if (lookahead == '"')
      ADVANCE(295);
    if (lookahead == '#')
      ADVANCE(353);
    if (lookahead == ',')
      ADVANCE(354);
    if (lookahead == '@')
      ADVANCE(316);
    if (lookahead == 'o')
      ADVANCE(345);
    if (lookahead == '{')
      ADVANCE(271);
    if (lookahead == '\t' ||
        lookahead == '\n' ||
        lookahead == '\r' ||
        lookahead == ' ' ||
        lookahead == 65279)
      SKIP(4)
    if (('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 5:
    if (lookahead == '"')
      ADVANCE(268);
    if (lookahead != 0)
      ADVANCE(294);
    END_STATE();
  case 6:
    if (lookahead == '.')
      ADVANCE(312);
    END_STATE();
  case 7:
    if (lookahead == '.')
      ADVANCE(6);
    END_STATE();
  case 8:
    if (lookahead == '0')
      ADVANCE(300);
    if (('1' <= lookahead && lookahead <= '9'))
      ADVANCE(301);
    END_STATE();
  case 9:
    if (lookahead == 'A')
      ADVANCE(327);
    END_STATE();
  case 10:
    if (lookahead == 'A')
      ADVANCE(138);
    END_STATE();
  case 11:
    if (lookahead == 'A')
      ADVANCE(66);
    END_STATE();
  case 12:
    if (lookahead == 'A')
      ADVANCE(97);
    if (lookahead == 'H')
      ADVANCE(43);
    END_STATE();
  case 13:
    if (lookahead == 'A')
      ADVANCE(22);
    END_STATE();
  case 14:
    if (lookahead == 'A')
      ADVANCE(150);
    END_STATE();
  case 15:
    if (lookahead == 'A')
      ADVANCE(27);
    END_STATE();
  case 16:
    if (lookahead == 'A')
      ADVANCE(98);
    END_STATE();
  case 17:
    if (lookahead == 'A')
      ADVANCE(30);
    END_STATE();
  case 18:
    if (lookahead == 'A')
      ADVANCE(137);
    END_STATE();
  case 19:
    if (lookahead == 'A')
      ADVANCE(67);
    END_STATE();
  case 20:
    if (lookahead == 'B')
      ADVANCE(91);
    END_STATE();
  case 21:
    if (lookahead == 'B')
      ADVANCE(142);
    END_STATE();
  case 22:
    if (lookahead == 'B')
      ADVANCE(96);
    END_STATE();
  case 23:
    if (lookahead == 'B')
      ADVANCE(92);
    END_STATE();
  case 24:
    if (lookahead == 'C')
      ADVANCE(12);
    if (lookahead == 'U')
      ADVANCE(21);
    END_STATE();
  case 25:
    if (lookahead == 'C')
      ADVANCE(144);
    END_STATE();
  case 26:
    if (lookahead == 'C')
      ADVANCE(145);
    END_STATE();
  case 27:
    if (lookahead == 'C')
      ADVANCE(39);
    END_STATE();
  case 28:
    if (lookahead == 'C')
      ADVANCE(139);
    END_STATE();
  case 29:
    if (lookahead == 'D')
      ADVANCE(322);
    END_STATE();
  case 30:
    if (lookahead == 'D')
      ADVANCE(324);
    END_STATE();
  case 31:
    if (lookahead == 'D')
      ADVANCE(44);
    END_STATE();
  case 32:
    if (lookahead == 'D')
      ADVANCE(52);
    END_STATE();
  case 33:
    if (lookahead == 'D')
      ADVANCE(53);
    if (lookahead == 'S')
      ADVANCE(132);
    END_STATE();
  case 34:
    if (lookahead == 'D')
      ADVANCE(54);
    END_STATE();
  case 35:
    if (lookahead == 'D')
      ADVANCE(55);
    END_STATE();
  case 36:
    if (lookahead == 'D')
      ADVANCE(170);
    END_STATE();
  case 37:
    if (lookahead == 'E')
      ADVANCE(93);
    END_STATE();
  case 38:
    if (lookahead == 'E')
      ADVANCE(25);
    END_STATE();
  case 39:
    if (lookahead == 'E')
      ADVANCE(332);
    END_STATE();
  case 40:
    if (lookahead == 'E')
      ADVANCE(335);
    END_STATE();
  case 41:
    if (lookahead == 'E')
      ADVANCE(167);
    END_STATE();
  case 42:
    if (lookahead == 'E')
      ADVANCE(135);
    END_STATE();
  case 43:
    if (lookahead == 'E')
      ADVANCE(100);
    END_STATE();
  case 44:
    if (lookahead == 'E')
      ADVANCE(60);
    END_STATE();
  case 45:
    if (lookahead == 'E')
      ADVANCE(136);
    END_STATE();
  case 46:
    if (lookahead == 'E')
      ADVANCE(115);
    END_STATE();
  case 47:
    if (lookahead == 'E')
      ADVANCE(117);
    END_STATE();
  case 48:
    if (lookahead == 'E')
      ADVANCE(17);
    END_STATE();
  case 49:
    if (lookahead == 'E')
      ADVANCE(119);
    END_STATE();
  case 50:
    if (lookahead == 'E')
      ADVANCE(95);
    END_STATE();
  case 51:
    if (lookahead == 'E')
      ADVANCE(26);
    END_STATE();
  case 52:
    if (lookahead == 'E')
      ADVANCE(61);
    END_STATE();
  case 53:
    if (lookahead == 'E')
      ADVANCE(62);
    END_STATE();
  case 54:
    if (lookahead == 'E')
      ADVANCE(63);
    END_STATE();
  case 55:
    if (lookahead == 'E')
      ADVANCE(64);
    END_STATE();
  case 56:
    if (lookahead == 'E')
      ADVANCE(169);
    END_STATE();
  case 57:
    if (lookahead == 'F')
      ADVANCE(81);
    if (lookahead == 'O')
      ADVANCE(23);
    END_STATE();
  case 58:
    if (lookahead == 'F')
      ADVANCE(141);
    END_STATE();
  case 59:
    if (lookahead == 'F')
      ADVANCE(15);
    END_STATE();
  case 60:
    if (lookahead == 'F')
      ADVANCE(73);
    END_STATE();
  case 61:
    if (lookahead == 'F')
      ADVANCE(87);
    END_STATE();
  case 62:
    if (lookahead == 'F')
      ADVANCE(88);
    END_STATE();
  case 63:
    if (lookahead == 'F')
      ADVANCE(89);
    END_STATE();
  case 64:
    if (lookahead == 'F')
      ADVANCE(90);
    END_STATE();
  case 65:
    if (lookahead == 'G')
      ADVANCE(161);
    END_STATE();
  case 66:
    if (lookahead == 'G')
      ADVANCE(102);
    END_STATE();
  case 67:
    if (lookahead == 'G')
      ADVANCE(103);
    END_STATE();
  case 68:
    if (lookahead == 'I')
      ADVANCE(37);
    if (lookahead == 'R')
      ADVANCE(11);
    END_STATE();
  case 69:
    if (lookahead == 'I')
      ADVANCE(124);
    END_STATE();
  case 70:
    if (lookahead == 'I')
      ADVANCE(133);
    END_STATE();
  case 71:
    if (lookahead == 'I')
      ADVANCE(116);
    END_STATE();
  case 72:
    if (lookahead == 'I')
      ADVANCE(13);
    END_STATE();
  case 73:
    if (lookahead == 'I')
      ADVANCE(118);
    END_STATE();
  case 74:
    if (lookahead == 'I')
      ADVANCE(125);
    END_STATE();
  case 75:
    if (lookahead == 'I')
      ADVANCE(126);
    END_STATE();
  case 76:
    if (lookahead == 'I')
      ADVANCE(127);
    END_STATE();
  case 77:
    if (lookahead == 'I')
      ADVANCE(128);
    END_STATE();
  case 78:
    if (lookahead == 'I')
      ADVANCE(129);
    END_STATE();
  case 79:
    if (lookahead == 'I')
      ADVANCE(130);
    END_STATE();
  case 80:
    if (lookahead == 'I')
      ADVANCE(131);
    END_STATE();
  case 81:
    if (lookahead == 'I')
      ADVANCE(50);
    END_STATE();
  case 82:
    if (lookahead == 'I')
      ADVANCE(152);
    END_STATE();
  case 83:
    if (lookahead == 'I')
      ADVANCE(153);
    END_STATE();
  case 84:
    if (lookahead == 'I')
      ADVANCE(154);
    END_STATE();
  case 85:
    if (lookahead == 'I')
      ADVANCE(155);
    END_STATE();
  case 86:
    if (lookahead == 'I')
      ADVANCE(156);
    END_STATE();
  case 87:
    if (lookahead == 'I')
      ADVANCE(120);
    END_STATE();
  case 88:
    if (lookahead == 'I')
      ADVANCE(121);
    END_STATE();
  case 89:
    if (lookahead == 'I')
      ADVANCE(122);
    END_STATE();
  case 90:
    if (lookahead == 'I')
      ADVANCE(123);
    END_STATE();
  case 91:
    if (lookahead == 'J')
      ADVANCE(38);
    END_STATE();
  case 92:
    if (lookahead == 'J')
      ADVANCE(51);
    END_STATE();
  case 93:
    if (lookahead == 'L')
      ADVANCE(29);
    END_STATE();
  case 94:
    if (lookahead == 'L')
      ADVANCE(71);
    if (lookahead == 'P')
      ADVANCE(160);
    if (lookahead == 'T')
      ADVANCE(45);
    END_STATE();
  case 95:
    if (lookahead == 'L')
      ADVANCE(36);
    END_STATE();
  case 96:
    if (lookahead == 'L')
      ADVANCE(56);
    END_STATE();
  case 97:
    if (lookahead == 'L')
      ADVANCE(18);
    END_STATE();
  case 98:
    if (lookahead == 'L')
      ADVANCE(162);
    END_STATE();
  case 99:
    if (lookahead == 'M')
      ADVANCE(334);
    END_STATE();
  case 100:
    if (lookahead == 'M')
      ADVANCE(9);
    END_STATE();
  case 101:
    if (lookahead == 'M')
      ADVANCE(46);
    END_STATE();
  case 102:
    if (lookahead == 'M')
      ADVANCE(47);
    END_STATE();
  case 103:
    if (lookahead == 'M')
      ADVANCE(49);
    END_STATE();
  case 104:
    if (lookahead == 'N')
      ADVANCE(94);
    END_STATE();
  case 105:
    if (lookahead == 'N')
      ADVANCE(69);
    END_STATE();
  case 106:
    if (lookahead == 'N')
      ADVANCE(333);
    END_STATE();
  case 107:
    if (lookahead == 'N')
      ADVANCE(320);
    END_STATE();
  case 108:
    if (lookahead == 'N')
      ADVANCE(321);
    END_STATE();
  case 109:
    if (lookahead == 'N')
      ADVANCE(330);
    END_STATE();
  case 110:
    if (lookahead == 'N')
      ADVANCE(331);
    END_STATE();
  case 111:
    if (lookahead == 'N')
      ADVANCE(323);
    END_STATE();
  case 112:
    if (lookahead == 'N')
      ADVANCE(326);
    END_STATE();
  case 113:
    if (lookahead == 'N')
      ADVANCE(337);
    END_STATE();
  case 114:
    if (lookahead == 'N')
      ADVANCE(158);
    END_STATE();
  case 115:
    if (lookahead == 'N')
      ADVANCE(148);
    END_STATE();
  case 116:
    if (lookahead == 'N')
      ADVANCE(41);
    END_STATE();
  case 117:
    if (lookahead == 'N')
      ADVANCE(149);
    END_STATE();
  case 118:
    if (lookahead == 'N')
      ADVANCE(82);
    END_STATE();
  case 119:
    if (lookahead == 'N')
      ADVANCE(146);
    END_STATE();
  case 120:
    if (lookahead == 'N')
      ADVANCE(83);
    END_STATE();
  case 121:
    if (lookahead == 'N')
      ADVANCE(84);
    END_STATE();
  case 122:
    if (lookahead == 'N')
      ADVANCE(85);
    END_STATE();
  case 123:
    if (lookahead == 'N')
      ADVANCE(86);
    END_STATE();
  case 124:
    if (lookahead == 'O')
      ADVANCE(106);
    END_STATE();
  case 125:
    if (lookahead == 'O')
      ADVANCE(107);
    END_STATE();
  case 126:
    if (lookahead == 'O')
      ADVANCE(108);
    END_STATE();
  case 127:
    if (lookahead == 'O')
      ADVANCE(109);
    END_STATE();
  case 128:
    if (lookahead == 'O')
      ADVANCE(110);
    END_STATE();
  case 129:
    if (lookahead == 'O')
      ADVANCE(111);
    END_STATE();
  case 130:
    if (lookahead == 'O')
      ADVANCE(112);
    END_STATE();
  case 131:
    if (lookahead == 'O')
      ADVANCE(113);
    END_STATE();
  case 132:
    if (lookahead == 'P')
      ADVANCE(140);
    END_STATE();
  case 133:
    if (lookahead == 'P')
      ADVANCE(151);
    END_STATE();
  case 134:
    if (lookahead == 'R')
      ADVANCE(65);
    END_STATE();
  case 135:
    if (lookahead == 'R')
      ADVANCE(164);
    END_STATE();
  case 136:
    if (lookahead == 'R')
      ADVANCE(59);
    END_STATE();
  case 137:
    if (lookahead == 'R')
      ADVANCE(328);
    END_STATE();
  case 138:
    if (lookahead == 'R')
      ADVANCE(72);
    END_STATE();
  case 139:
    if (lookahead == 'R')
      ADVANCE(70);
    END_STATE();
  case 140:
    if (lookahead == 'R')
      ADVANCE(48);
    END_STATE();
  case 141:
    if (lookahead == 'R')
      ADVANCE(19);
    END_STATE();
  case 142:
    if (lookahead == 'S')
      ADVANCE(28);
    END_STATE();
  case 143:
    if (lookahead == 'T')
      ADVANCE(165);
    END_STATE();
  case 144:
    if (lookahead == 'T')
      ADVANCE(329);
    END_STATE();
  case 145:
    if (lookahead == 'T')
      ADVANCE(336);
    END_STATE();
  case 146:
    if (lookahead == 'T')
      ADVANCE(325);
    END_STATE();
  case 147:
    if (lookahead == 'T')
      ADVANCE(14);
    END_STATE();
  case 148:
    if (lookahead == 'T')
      ADVANCE(168);
    END_STATE();
  case 149:
    if (lookahead == 'T')
      ADVANCE(166);
    END_STATE();
  case 150:
    if (lookahead == 'T')
      ADVANCE(74);
    END_STATE();
  case 151:
    if (lookahead == 'T')
      ADVANCE(75);
    END_STATE();
  case 152:
    if (lookahead == 'T')
      ADVANCE(76);
    END_STATE();
  case 153:
    if (lookahead == 'T')
      ADVANCE(77);
    END_STATE();
  case 154:
    if (lookahead == 'T')
      ADVANCE(78);
    END_STATE();
  case 155:
    if (lookahead == 'T')
      ADVANCE(79);
    END_STATE();
  case 156:
    if (lookahead == 'T')
      ADVANCE(80);
    END_STATE();
  case 157:
    if (lookahead == 'U')
      ADVANCE(147);
    END_STATE();
  case 158:
    if (lookahead == 'U')
      ADVANCE(99);
    END_STATE();
  case 159:
    if (lookahead == 'U')
      ADVANCE(42);
    END_STATE();
  case 160:
    if (lookahead == 'U')
      ADVANCE(143);
    END_STATE();
  case 161:
    if (lookahead == 'U')
      ADVANCE(101);
    END_STATE();
  case 162:
    if (lookahead == 'U')
      ADVANCE(40);
    END_STATE();
  case 163:
    if (lookahead == 'V')
      ADVANCE(16);
    END_STATE();
  case 164:
    if (lookahead == 'Y')
      ADVANCE(319);
    END_STATE();
  case 165:
    if (lookahead == '_')
      ADVANCE(57);
    END_STATE();
  case 166:
    if (lookahead == '_')
      ADVANCE(33);
    END_STATE();
  case 167:
    if (lookahead == '_')
      ADVANCE(58);
    END_STATE();
  case 168:
    if (lookahead == '_')
      ADVANCE(32);
    END_STATE();
  case 169:
    if (lookahead == '_')
      ADVANCE(34);
    END_STATE();
  case 170:
    if (lookahead == '_')
      ADVANCE(35);
    END_STATE();
  case 171:
    if (lookahead == 'a')
      ADVANCE(211);
    if (lookahead == 'r')
      ADVANCE(172);
    END_STATE();
  case 172:
    if (lookahead == 'a')
      ADVANCE(204);
    END_STATE();
  case 173:
    if (lookahead == 'a')
      ADVANCE(270);
    END_STATE();
  case 174:
    if (lookahead == 'a')
      ADVANCE(181);
    END_STATE();
  case 175:
    if (lookahead == 'a')
      ADVANCE(185);
    END_STATE();
  case 176:
    if (lookahead == 'a')
      ADVANCE(241);
    END_STATE();
  case 177:
    if (lookahead == 'a')
      ADVANCE(255);
    END_STATE();
  case 178:
    if (lookahead == 'a')
      ADVANCE(214);
    if (lookahead == 'h')
      ADVANCE(199);
    END_STATE();
  case 179:
    if (lookahead == 'a')
      ADVANCE(254);
    END_STATE();
  case 180:
    if (lookahead == 'b')
      ADVANCE(246);
    END_STATE();
  case 181:
    if (lookahead == 'b')
      ADVANCE(216);
    END_STATE();
  case 182:
    if (lookahead == 'c')
      ADVANCE(178);
    if (lookahead == 'u')
      ADVANCE(180);
    END_STATE();
  case 183:
    if (lookahead == 'c')
      ADVANCE(243);
    END_STATE();
  case 184:
    if (lookahead == 'c')
      ADVANCE(251);
    END_STATE();
  case 185:
    if (lookahead == 'c')
      ADVANCE(192);
    END_STATE();
  case 186:
    if (lookahead == 'd')
      ADVANCE(273);
    END_STATE();
  case 187:
    if (lookahead == 'e')
      ADVANCE(184);
    END_STATE();
  case 188:
    if (lookahead == 'e')
      ADVANCE(304);
    END_STATE();
  case 189:
    if (lookahead == 'e')
      ADVANCE(275);
    END_STATE();
  case 190:
    if (lookahead == 'e')
      ADVANCE(306);
    END_STATE();
  case 191:
    if (lookahead == 'e')
      ADVANCE(317);
    END_STATE();
  case 192:
    if (lookahead == 'e')
      ADVANCE(276);
    END_STATE();
  case 193:
    if (lookahead == 'e')
      ADVANCE(318);
    END_STATE();
  case 194:
    if (lookahead == 'e')
      ADVANCE(239);
    END_STATE();
  case 195:
    if (lookahead == 'e')
      ADVANCE(235);
    END_STATE();
  case 196:
    if (lookahead == 'e')
      ADVANCE(223);
    END_STATE();
  case 197:
    if (lookahead == 'e')
      ADVANCE(240);
    END_STATE();
  case 198:
    if (lookahead == 'e')
      ADVANCE(179);
    END_STATE();
  case 199:
    if (lookahead == 'e')
      ADVANCE(219);
    END_STATE();
  case 200:
    if (lookahead == 'e')
      ADVANCE(229);
    END_STATE();
  case 201:
    if (lookahead == 'e')
      ADVANCE(230);
    END_STATE();
  case 202:
    if (lookahead == 'e')
      ADVANCE(221);
    END_STATE();
  case 203:
    if (lookahead == 'f')
      ADVANCE(175);
    END_STATE();
  case 204:
    if (lookahead == 'g')
      ADVANCE(220);
    END_STATE();
  case 205:
    if (lookahead == 'i')
      ADVANCE(242);
    END_STATE();
  case 206:
    if (lookahead == 'i')
      ADVANCE(231);
    END_STATE();
  case 207:
    if (lookahead == 'i')
      ADVANCE(263);
    END_STATE();
  case 208:
    if (lookahead == 'i')
      ADVANCE(238);
    END_STATE();
  case 209:
    if (lookahead == 'i')
      ADVANCE(232);
    END_STATE();
  case 210:
    if (lookahead == 'i')
      ADVANCE(233);
    END_STATE();
  case 211:
    if (lookahead == 'l')
      ADVANCE(247);
    END_STATE();
  case 212:
    if (lookahead == 'l')
      ADVANCE(308);
    END_STATE();
  case 213:
    if (lookahead == 'l')
      ADVANCE(212);
    END_STATE();
  case 214:
    if (lookahead == 'l')
      ADVANCE(176);
    END_STATE();
  case 215:
    if (lookahead == 'l')
      ADVANCE(202);
    END_STATE();
  case 216:
    if (lookahead == 'l')
      ADVANCE(193);
    END_STATE();
  case 217:
    if (lookahead == 'm')
      ADVANCE(234);
    if (lookahead == 'n')
      ADVANCE(237);
    END_STATE();
  case 218:
    if (lookahead == 'm')
      ADVANCE(278);
    END_STATE();
  case 219:
    if (lookahead == 'm')
      ADVANCE(173);
    END_STATE();
  case 220:
    if (lookahead == 'm')
      ADVANCE(200);
    END_STATE();
  case 221:
    if (lookahead == 'm')
      ADVANCE(201);
    END_STATE();
  case 222:
    if (lookahead == 'n')
      ADVANCE(314);
    END_STATE();
  case 223:
    if (lookahead == 'n')
      ADVANCE(186);
    END_STATE();
  case 224:
    if (lookahead == 'n')
      ADVANCE(277);
    END_STATE();
  case 225:
    if (lookahead == 'n')
      ADVANCE(288);
    END_STATE();
  case 226:
    if (lookahead == 'n')
      ADVANCE(289);
    END_STATE();
  case 227:
    if (lookahead == 'n')
      ADVANCE(206);
    END_STATE();
  case 228:
    if (lookahead == 'n')
      ADVANCE(257);
    if (lookahead == 'x')
      ADVANCE(253);
    END_STATE();
  case 229:
    if (lookahead == 'n')
      ADVANCE(249);
    END_STATE();
  case 230:
    if (lookahead == 'n')
      ADVANCE(252);
    END_STATE();
  case 231:
    if (lookahead == 'o')
      ADVANCE(224);
    END_STATE();
  case 232:
    if (lookahead == 'o')
      ADVANCE(225);
    END_STATE();
  case 233:
    if (lookahead == 'o')
      ADVANCE(226);
    END_STATE();
  case 234:
    if (lookahead == 'p')
      ADVANCE(215);
    END_STATE();
  case 235:
    if (lookahead == 'p')
      ADVANCE(198);
    END_STATE();
  case 236:
    if (lookahead == 'p')
      ADVANCE(189);
    END_STATE();
  case 237:
    if (lookahead == 'p')
      ADVANCE(261);
    if (lookahead == 't')
      ADVANCE(197);
    END_STATE();
  case 238:
    if (lookahead == 'p')
      ADVANCE(256);
    END_STATE();
  case 239:
    if (lookahead == 'r')
      ADVANCE(264);
    END_STATE();
  case 240:
    if (lookahead == 'r')
      ADVANCE(203);
    END_STATE();
  case 241:
    if (lookahead == 'r')
      ADVANCE(274);
    END_STATE();
  case 242:
    if (lookahead == 'r')
      ADVANCE(187);
    END_STATE();
  case 243:
    if (lookahead == 'r')
      ADVANCE(208);
    END_STATE();
  case 244:
    if (lookahead == 'r')
      ADVANCE(262);
    if (lookahead == 'y')
      ADVANCE(236);
    END_STATE();
  case 245:
    if (lookahead == 's')
      ADVANCE(281);
    END_STATE();
  case 246:
    if (lookahead == 's')
      ADVANCE(183);
    END_STATE();
  case 247:
    if (lookahead == 's')
      ADVANCE(190);
    END_STATE();
  case 248:
    if (lookahead == 't')
      ADVANCE(279);
    END_STATE();
  case 249:
    if (lookahead == 't')
      ADVANCE(313);
    END_STATE();
  case 250:
    if (lookahead == 't')
      ADVANCE(177);
    END_STATE();
  case 251:
    if (lookahead == 't')
      ADVANCE(207);
    END_STATE();
  case 252:
    if (lookahead == 't')
      ADVANCE(245);
    END_STATE();
  case 253:
    if (lookahead == 't')
      ADVANCE(196);
    END_STATE();
  case 254:
    if (lookahead == 't')
      ADVANCE(174);
    END_STATE();
  case 255:
    if (lookahead == 't')
      ADVANCE(209);
    END_STATE();
  case 256:
    if (lookahead == 't')
      ADVANCE(210);
    END_STATE();
  case 257:
    if (lookahead == 'u')
      ADVANCE(218);
    END_STATE();
  case 258:
    if (lookahead == 'u')
      ADVANCE(194);
    END_STATE();
  case 259:
    if (lookahead == 'u')
      ADVANCE(250);
    END_STATE();
  case 260:
    if (lookahead == 'u')
      ADVANCE(213);
    END_STATE();
  case 261:
    if (lookahead == 'u')
      ADVANCE(248);
    END_STATE();
  case 262:
    if (lookahead == 'u')
      ADVANCE(188);
    END_STATE();
  case 263:
    if (lookahead == 'v')
      ADVANCE(191);
    END_STATE();
  case 264:
    if (lookahead == 'y')
      ADVANCE(287);
    END_STATE();
  case 265:
    if (lookahead == '+' ||
        lookahead == '-')
      ADVANCE(267);
    if (('0' <= lookahead && lookahead <= '9'))
      ADVANCE(303);
    END_STATE();
  case 266:
    if (('0' <= lookahead && lookahead <= '9'))
      ADVANCE(302);
    END_STATE();
  case 267:
    if (('0' <= lookahead && lookahead <= '9'))
      ADVANCE(303);
    END_STATE();
  case 268:
    if (lookahead != 0 &&
        lookahead != '"')
      ADVANCE(294);
    END_STATE();
  case 269:
    ACCEPT_TOKEN(ts_builtin_sym_end);
    END_STATE();
  case 270:
    ACCEPT_TOKEN(anon_sym_schema);
    END_STATE();
  case 271:
    ACCEPT_TOKEN(anon_sym_LBRACE);
    END_STATE();
  case 272:
    ACCEPT_TOKEN(anon_sym_RBRACE);
    END_STATE();
  case 273:
    ACCEPT_TOKEN(anon_sym_extend);
    END_STATE();
  case 274:
    ACCEPT_TOKEN(anon_sym_scalar);
    END_STATE();
  case 275:
    ACCEPT_TOKEN(anon_sym_type);
    END_STATE();
  case 276:
    ACCEPT_TOKEN(anon_sym_interface);
    END_STATE();
  case 277:
    ACCEPT_TOKEN(anon_sym_union);
    END_STATE();
  case 278:
    ACCEPT_TOKEN(anon_sym_enum);
    END_STATE();
  case 279:
    ACCEPT_TOKEN(anon_sym_input);
    END_STATE();
  case 280:
    ACCEPT_TOKEN(anon_sym_AMP);
    END_STATE();
  case 281:
    ACCEPT_TOKEN(anon_sym_implements);
    END_STATE();
  case 282:
    ACCEPT_TOKEN(anon_sym_COLON);
    END_STATE();
  case 283:
    ACCEPT_TOKEN(anon_sym_LPAREN);
    END_STATE();
  case 284:
    ACCEPT_TOKEN(anon_sym_RPAREN);
    END_STATE();
  case 285:
    ACCEPT_TOKEN(anon_sym_EQ);
    END_STATE();
  case 286:
    ACCEPT_TOKEN(anon_sym_PIPE);
    END_STATE();
  case 287:
    ACCEPT_TOKEN(anon_sym_query);
    END_STATE();
  case 288:
    ACCEPT_TOKEN(anon_sym_mutation);
    END_STATE();
  case 289:
    ACCEPT_TOKEN(anon_sym_subscription);
    END_STATE();
  case 290:
    ACCEPT_TOKEN(anon_sym_DOLLAR);
    END_STATE();
  case 291:
    ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
    END_STATE();
  case 292:
    ACCEPT_TOKEN(aux_sym_string_value_token1);
    if (lookahead == '\n')
      ADVANCE(294);
    if (lookahead == '"')
      ADVANCE(352);
    if (lookahead != 0)
      ADVANCE(292);
    END_STATE();
  case 293:
    ACCEPT_TOKEN(aux_sym_string_value_token1);
    if (lookahead == '\t' ||
        lookahead == '\n' ||
        lookahead == '\r' ||
        lookahead == ' ' ||
        lookahead == 65279)
      ADVANCE(293);
    if (lookahead == '"')
      ADVANCE(5);
    if (lookahead == '#')
      ADVANCE(292);
    if (lookahead == ',')
      ADVANCE(356);
    if (lookahead != 0)
      ADVANCE(294);
    END_STATE();
  case 294:
    ACCEPT_TOKEN(aux_sym_string_value_token1);
    if (lookahead != 0 &&
        lookahead != '"')
      ADVANCE(294);
    if (lookahead == '"')
      ADVANCE(5);
    END_STATE();
  case 295:
    ACCEPT_TOKEN(anon_sym_DQUOTE);
    END_STATE();
  case 296:
    ACCEPT_TOKEN(anon_sym_DQUOTE);
    if (lookahead == '"')
      ADVANCE(3);
    END_STATE();
  case 297:
    ACCEPT_TOKEN(aux_sym_string_value_token2);
    if (lookahead == '#')
      ADVANCE(298);
    if (lookahead == ',')
      ADVANCE(355);
    if (lookahead == '\t' ||
        lookahead == '\r' ||
        lookahead == ' ' ||
        lookahead == 65279)
      ADVANCE(297);
    if (lookahead != 0 &&
        lookahead != '\n' &&
        lookahead != '"' &&
        lookahead != '\\')
      ADVANCE(299);
    END_STATE();
  case 298:
    ACCEPT_TOKEN(aux_sym_string_value_token2);
    if (lookahead == '"' ||
        lookahead == '\\')
      ADVANCE(353);
    if (lookahead != 0 &&
        lookahead != '\n')
      ADVANCE(298);
    END_STATE();
  case 299:
    ACCEPT_TOKEN(aux_sym_string_value_token2);
    if (lookahead != 0 &&
        lookahead != '\n' &&
        lookahead != '"' &&
        lookahead != '\\')
      ADVANCE(299);
    END_STATE();
  case 300:
    ACCEPT_TOKEN(sym_int_value);
    if (lookahead == '.')
      ADVANCE(266);
    if (lookahead == 'E' ||
        lookahead == 'e')
      ADVANCE(265);
    END_STATE();
  case 301:
    ACCEPT_TOKEN(sym_int_value);
    if (lookahead == '.')
      ADVANCE(266);
    if (lookahead == 'E' ||
        lookahead == 'e')
      ADVANCE(265);
    if (('0' <= lookahead && lookahead <= '9'))
      ADVANCE(301);
    END_STATE();
  case 302:
    ACCEPT_TOKEN(sym_float_value);
    if (lookahead == 'E' ||
        lookahead == 'e')
      ADVANCE(265);
    if (('0' <= lookahead && lookahead <= '9'))
      ADVANCE(302);
    END_STATE();
  case 303:
    ACCEPT_TOKEN(sym_float_value);
    if (('0' <= lookahead && lookahead <= '9'))
      ADVANCE(303);
    END_STATE();
  case 304:
    ACCEPT_TOKEN(anon_sym_true);
    END_STATE();
  case 305:
    ACCEPT_TOKEN(anon_sym_true);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 306:
    ACCEPT_TOKEN(anon_sym_false);
    END_STATE();
  case 307:
    ACCEPT_TOKEN(anon_sym_false);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 308:
    ACCEPT_TOKEN(sym_null_value);
    END_STATE();
  case 309:
    ACCEPT_TOKEN(sym_null_value);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 310:
    ACCEPT_TOKEN(anon_sym_LBRACK);
    END_STATE();
  case 311:
    ACCEPT_TOKEN(anon_sym_RBRACK);
    END_STATE();
  case 312:
    ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
    END_STATE();
  case 313:
    ACCEPT_TOKEN(anon_sym_fragment);
    END_STATE();
  case 314:
    ACCEPT_TOKEN(anon_sym_on);
    END_STATE();
  case 315:
    ACCEPT_TOKEN(anon_sym_on);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 316:
    ACCEPT_TOKEN(anon_sym_AT);
    END_STATE();
  case 317:
    ACCEPT_TOKEN(anon_sym_directive);
    END_STATE();
  case 318:
    ACCEPT_TOKEN(anon_sym_repeatable);
    END_STATE();
  case 319:
    ACCEPT_TOKEN(anon_sym_QUERY);
    END_STATE();
  case 320:
    ACCEPT_TOKEN(anon_sym_MUTATION);
    END_STATE();
  case 321:
    ACCEPT_TOKEN(anon_sym_SUBSCRIPTION);
    END_STATE();
  case 322:
    ACCEPT_TOKEN(anon_sym_FIELD);
    if (lookahead == '_')
      ADVANCE(31);
    END_STATE();
  case 323:
    ACCEPT_TOKEN(anon_sym_FRAGMENT_DEFINITION);
    END_STATE();
  case 324:
    ACCEPT_TOKEN(anon_sym_FRAGMENT_SPREAD);
    END_STATE();
  case 325:
    ACCEPT_TOKEN(anon_sym_INLINE_FRAGMENT);
    END_STATE();
  case 326:
    ACCEPT_TOKEN(anon_sym_VARIABLE_DEFINITION);
    END_STATE();
  case 327:
    ACCEPT_TOKEN(anon_sym_SCHEMA);
    END_STATE();
  case 328:
    ACCEPT_TOKEN(anon_sym_SCALAR);
    END_STATE();
  case 329:
    ACCEPT_TOKEN(anon_sym_OBJECT);
    END_STATE();
  case 330:
    ACCEPT_TOKEN(anon_sym_FIELD_DEFINITION);
    END_STATE();
  case 331:
    ACCEPT_TOKEN(anon_sym_ARGUMENT_DEFINITION);
    END_STATE();
  case 332:
    ACCEPT_TOKEN(anon_sym_INTERFACE);
    END_STATE();
  case 333:
    ACCEPT_TOKEN(anon_sym_UNION);
    END_STATE();
  case 334:
    ACCEPT_TOKEN(anon_sym_ENUM);
    if (lookahead == '_')
      ADVANCE(163);
    END_STATE();
  case 335:
    ACCEPT_TOKEN(anon_sym_ENUM_VALUE);
    END_STATE();
  case 336:
    ACCEPT_TOKEN(anon_sym_INPUT_OBJECT);
    END_STATE();
  case 337:
    ACCEPT_TOKEN(anon_sym_INPUT_FIELD_DEFINITION);
    END_STATE();
  case 338:
    ACCEPT_TOKEN(anon_sym_BANG);
    END_STATE();
  case 339:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'a')
      ADVANCE(342);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('b' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 340:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'e')
      ADVANCE(305);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 341:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'e')
      ADVANCE(307);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 342:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'l')
      ADVANCE(347);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 343:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'l')
      ADVANCE(309);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 344:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'l')
      ADVANCE(343);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 345:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'n')
      ADVANCE(315);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 346:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'r')
      ADVANCE(348);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 347:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 's')
      ADVANCE(341);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 348:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'u')
      ADVANCE(340);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 349:
    ACCEPT_TOKEN(sym_name);
    if (lookahead == 'u')
      ADVANCE(344);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 350:
    ACCEPT_TOKEN(sym_name);
    if (('0' <= lookahead && lookahead <= '9') ||
        ('A' <= lookahead && lookahead <= 'Z') ||
        lookahead == '_' ||
        ('a' <= lookahead && lookahead <= 'z'))
      ADVANCE(350);
    END_STATE();
  case 351:
    ACCEPT_TOKEN(sym_comment);
    if (lookahead == '\n')
      ADVANCE(294);
    if (lookahead == '"')
      ADVANCE(353);
    if (lookahead != 0)
      ADVANCE(292);
    END_STATE();
  case 352:
    ACCEPT_TOKEN(sym_comment);
    if (lookahead == '\n')
      ADVANCE(294);
    if (lookahead == '"')
      ADVANCE(351);
    if (lookahead != 0)
      ADVANCE(292);
    END_STATE();
  case 353:
    ACCEPT_TOKEN(sym_comment);
    if (lookahead != 0 &&
        lookahead != '\n')
      ADVANCE(353);
    END_STATE();
  case 354:
    ACCEPT_TOKEN(sym_comma);
    END_STATE();
  case 355:
    ACCEPT_TOKEN(sym_comma);
    if (lookahead != 0 &&
        lookahead != '\n' &&
        lookahead != '"' &&
        lookahead != '\\')
      ADVANCE(299);
    END_STATE();
  case 356:
    ACCEPT_TOKEN(sym_comma);
    if (lookahead != 0 &&
        lookahead != '"')
      ADVANCE(294);
    if (lookahead == '"')
      ADVANCE(5);
    END_STATE();
  default:
    return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
    [0] = {.lex_state = 0},
    [1] = {.lex_state = 0},
    [2] = {.lex_state = 0},
    [3] = {.lex_state = 0},
    [4] = {.lex_state = 0},
    [5] = {.lex_state = 0},
    [6] = {.lex_state = 0},
    [7] = {.lex_state = 0},
    [8] = {.lex_state = 0},
    [9] = {.lex_state = 0},
    [10] = {.lex_state = 0},
    [11] = {.lex_state = 0},
    [12] = {.lex_state = 0},
    [13] = {.lex_state = 0},
    [14] = {.lex_state = 0},
    [15] = {.lex_state = 0},
    [16] = {.lex_state = 0},
    [17] = {.lex_state = 0},
    [18] = {.lex_state = 0},
    [19] = {.lex_state = 0},
    [20] = {.lex_state = 0},
    [21] = {.lex_state = 0},
    [22] = {.lex_state = 0},
    [23] = {.lex_state = 0},
    [24] = {.lex_state = 0},
    [25] = {.lex_state = 0},
    [26] = {.lex_state = 0},
    [27] = {.lex_state = 0},
    [28] = {.lex_state = 0},
    [29] = {.lex_state = 0},
    [30] = {.lex_state = 0},
    [31] = {.lex_state = 0},
    [32] = {.lex_state = 0},
    [33] = {.lex_state = 0},
    [34] = {.lex_state = 0},
    [35] = {.lex_state = 0},
    [36] = {.lex_state = 0},
    [37] = {.lex_state = 2},
    [38] = {.lex_state = 2},
    [39] = {.lex_state = 2},
    [40] = {.lex_state = 2},
    [41] = {.lex_state = 2},
    [42] = {.lex_state = 2},
    [43] = {.lex_state = 2},
    [44] = {.lex_state = 0},
    [45] = {.lex_state = 0},
    [46] = {.lex_state = 0},
    [47] = {.lex_state = 0},
    [48] = {.lex_state = 0},
    [49] = {.lex_state = 0},
    [50] = {.lex_state = 0},
    [51] = {.lex_state = 0},
    [52] = {.lex_state = 0},
    [53] = {.lex_state = 0},
    [54] = {.lex_state = 0},
    [55] = {.lex_state = 2},
    [56] = {.lex_state = 0},
    [57] = {.lex_state = 0},
    [58] = {.lex_state = 0},
    [59] = {.lex_state = 0},
    [60] = {.lex_state = 0},
    [61] = {.lex_state = 2},
    [62] = {.lex_state = 0},
    [63] = {.lex_state = 0},
    [64] = {.lex_state = 0},
    [65] = {.lex_state = 0},
    [66] = {.lex_state = 0},
    [67] = {.lex_state = 0},
    [68] = {.lex_state = 0},
    [69] = {.lex_state = 0},
    [70] = {.lex_state = 0},
    [71] = {.lex_state = 0},
    [72] = {.lex_state = 0},
    [73] = {.lex_state = 0},
    [74] = {.lex_state = 0},
    [75] = {.lex_state = 0},
    [76] = {.lex_state = 0},
    [77] = {.lex_state = 0},
    [78] = {.lex_state = 0},
    [79] = {.lex_state = 0},
    [80] = {.lex_state = 0},
    [81] = {.lex_state = 0},
    [82] = {.lex_state = 0},
    [83] = {.lex_state = 2},
    [84] = {.lex_state = 0},
    [85] = {.lex_state = 0},
    [86] = {.lex_state = 0},
    [87] = {.lex_state = 0},
    [88] = {.lex_state = 2},
    [89] = {.lex_state = 0},
    [90] = {.lex_state = 0},
    [91] = {.lex_state = 0},
    [92] = {.lex_state = 0},
    [93] = {.lex_state = 0},
    [94] = {.lex_state = 0},
    [95] = {.lex_state = 0},
    [96] = {.lex_state = 0},
    [97] = {.lex_state = 0},
    [98] = {.lex_state = 0},
    [99] = {.lex_state = 0},
    [100] = {.lex_state = 0},
    [101] = {.lex_state = 0},
    [102] = {.lex_state = 0},
    [103] = {.lex_state = 0},
    [104] = {.lex_state = 0},
    [105] = {.lex_state = 0},
    [106] = {.lex_state = 0},
    [107] = {.lex_state = 0},
    [108] = {.lex_state = 0},
    [109] = {.lex_state = 0},
    [110] = {.lex_state = 0},
    [111] = {.lex_state = 0},
    [112] = {.lex_state = 0},
    [113] = {.lex_state = 0},
    [114] = {.lex_state = 0},
    [115] = {.lex_state = 0},
    [116] = {.lex_state = 0},
    [117] = {.lex_state = 0},
    [118] = {.lex_state = 0},
    [119] = {.lex_state = 0},
    [120] = {.lex_state = 0},
    [121] = {.lex_state = 0},
    [122] = {.lex_state = 0},
    [123] = {.lex_state = 0},
    [124] = {.lex_state = 0},
    [125] = {.lex_state = 0},
    [126] = {.lex_state = 0},
    [127] = {.lex_state = 0},
    [128] = {.lex_state = 0},
    [129] = {.lex_state = 0},
    [130] = {.lex_state = 0},
    [131] = {.lex_state = 0},
    [132] = {.lex_state = 0},
    [133] = {.lex_state = 0},
    [134] = {.lex_state = 0},
    [135] = {.lex_state = 0},
    [136] = {.lex_state = 0},
    [137] = {.lex_state = 0},
    [138] = {.lex_state = 2},
    [139] = {.lex_state = 2},
    [140] = {.lex_state = 2},
    [141] = {.lex_state = 2},
    [142] = {.lex_state = 2},
    [143] = {.lex_state = 2},
    [144] = {.lex_state = 2},
    [145] = {.lex_state = 2},
    [146] = {.lex_state = 2},
    [147] = {.lex_state = 1},
    [148] = {.lex_state = 1},
    [149] = {.lex_state = 4},
    [150] = {.lex_state = 1},
    [151] = {.lex_state = 1},
    [152] = {.lex_state = 1},
    [153] = {.lex_state = 1},
    [154] = {.lex_state = 1},
    [155] = {.lex_state = 1},
    [156] = {.lex_state = 1},
    [157] = {.lex_state = 1},
    [158] = {.lex_state = 1},
    [159] = {.lex_state = 1},
    [160] = {.lex_state = 1},
    [161] = {.lex_state = 1},
    [162] = {.lex_state = 1},
    [163] = {.lex_state = 1},
    [164] = {.lex_state = 1},
    [165] = {.lex_state = 1},
    [166] = {.lex_state = 0},
    [167] = {.lex_state = 1},
    [168] = {.lex_state = 1},
    [169] = {.lex_state = 1},
    [170] = {.lex_state = 1},
    [171] = {.lex_state = 1},
    [172] = {.lex_state = 0},
    [173] = {.lex_state = 1},
    [174] = {.lex_state = 1},
    [175] = {.lex_state = 1},
    [176] = {.lex_state = 0},
    [177] = {.lex_state = 1},
    [178] = {.lex_state = 1},
    [179] = {.lex_state = 1},
    [180] = {.lex_state = 1},
    [181] = {.lex_state = 1},
    [182] = {.lex_state = 0},
    [183] = {.lex_state = 1},
    [184] = {.lex_state = 0},
    [185] = {.lex_state = 1},
    [186] = {.lex_state = 1},
    [187] = {.lex_state = 1},
    [188] = {.lex_state = 1},
    [189] = {.lex_state = 1},
    [190] = {.lex_state = 0},
    [191] = {.lex_state = 1},
    [192] = {.lex_state = 0},
    [193] = {.lex_state = 0},
    [194] = {.lex_state = 1},
    [195] = {.lex_state = 1},
    [196] = {.lex_state = 0},
    [197] = {.lex_state = 1},
    [198] = {.lex_state = 1},
    [199] = {.lex_state = 0},
    [200] = {.lex_state = 0},
    [201] = {.lex_state = 1},
    [202] = {.lex_state = 0},
    [203] = {.lex_state = 0},
    [204] = {.lex_state = 1},
    [205] = {.lex_state = 1},
    [206] = {.lex_state = 1},
    [207] = {.lex_state = 0},
    [208] = {.lex_state = 0},
    [209] = {.lex_state = 1},
    [210] = {.lex_state = 1},
    [211] = {.lex_state = 1},
    [212] = {.lex_state = 0},
    [213] = {.lex_state = 1},
    [214] = {.lex_state = 1},
    [215] = {.lex_state = 0},
    [216] = {.lex_state = 1},
    [217] = {.lex_state = 0},
    [218] = {.lex_state = 1},
    [219] = {.lex_state = 1},
    [220] = {.lex_state = 1},
    [221] = {.lex_state = 1},
    [222] = {.lex_state = 1},
    [223] = {.lex_state = 1},
    [224] = {.lex_state = 1},
    [225] = {.lex_state = 1},
    [226] = {.lex_state = 0},
    [227] = {.lex_state = 0},
    [228] = {.lex_state = 0},
    [229] = {.lex_state = 1},
    [230] = {.lex_state = 1},
    [231] = {.lex_state = 0},
    [232] = {.lex_state = 1},
    [233] = {.lex_state = 1},
    [234] = {.lex_state = 1},
    [235] = {.lex_state = 1},
    [236] = {.lex_state = 1},
    [237] = {.lex_state = 0},
    [238] = {.lex_state = 0},
    [239] = {.lex_state = 0},
    [240] = {.lex_state = 0},
    [241] = {.lex_state = 0},
    [242] = {.lex_state = 1},
    [243] = {.lex_state = 0},
    [244] = {.lex_state = 1},
    [245] = {.lex_state = 1},
    [246] = {.lex_state = 0},
    [247] = {.lex_state = 1},
    [248] = {.lex_state = 0},
    [249] = {.lex_state = 0},
    [250] = {.lex_state = 1},
    [251] = {.lex_state = 1},
    [252] = {.lex_state = 1},
    [253] = {.lex_state = 1},
    [254] = {.lex_state = 1},
    [255] = {.lex_state = 0},
    [256] = {.lex_state = 0},
    [257] = {.lex_state = 1},
    [258] = {.lex_state = 1},
    [259] = {.lex_state = 1},
    [260] = {.lex_state = 0},
    [261] = {.lex_state = 1},
    [262] = {.lex_state = 1},
    [263] = {.lex_state = 1},
    [264] = {.lex_state = 1},
    [265] = {.lex_state = 0},
    [266] = {.lex_state = 0},
    [267] = {.lex_state = 1},
    [268] = {.lex_state = 1},
    [269] = {.lex_state = 0},
    [270] = {.lex_state = 1},
    [271] = {.lex_state = 1},
    [272] = {.lex_state = 1},
    [273] = {.lex_state = 1},
    [274] = {.lex_state = 0},
    [275] = {.lex_state = 0},
    [276] = {.lex_state = 1},
    [277] = {.lex_state = 1},
    [278] = {.lex_state = 1},
    [279] = {.lex_state = 0},
    [280] = {.lex_state = 1},
    [281] = {.lex_state = 0},
    [282] = {.lex_state = 1},
    [283] = {.lex_state = 0},
    [284] = {.lex_state = 0},
    [285] = {.lex_state = 1},
    [286] = {.lex_state = 1},
    [287] = {.lex_state = 1},
    [288] = {.lex_state = 1},
    [289] = {.lex_state = 1},
    [290] = {.lex_state = 1},
    [291] = {.lex_state = 1},
    [292] = {.lex_state = 0},
    [293] = {.lex_state = 1},
    [294] = {.lex_state = 1},
    [295] = {.lex_state = 0},
    [296] = {.lex_state = 1},
    [297] = {.lex_state = 1},
    [298] = {.lex_state = 1},
    [299] = {.lex_state = 1},
    [300] = {.lex_state = 0},
    [301] = {.lex_state = 0},
    [302] = {.lex_state = 0},
    [303] = {.lex_state = 0},
    [304] = {.lex_state = 0},
    [305] = {.lex_state = 0},
    [306] = {.lex_state = 1},
    [307] = {.lex_state = 0},
    [308] = {.lex_state = 0},
    [309] = {.lex_state = 1},
    [310] = {.lex_state = 0},
    [311] = {.lex_state = 0},
    [312] = {.lex_state = 1},
    [313] = {.lex_state = 0},
    [314] = {.lex_state = 0},
    [315] = {.lex_state = 0},
    [316] = {.lex_state = 0},
    [317] = {.lex_state = 1},
    [318] = {.lex_state = 1},
    [319] = {.lex_state = 1},
    [320] = {.lex_state = 1},
    [321] = {.lex_state = 1},
    [322] = {.lex_state = 0},
    [323] = {.lex_state = 0},
    [324] = {.lex_state = 0},
    [325] = {.lex_state = 1},
    [326] = {.lex_state = 0},
    [327] = {.lex_state = 4},
    [328] = {.lex_state = 0},
    [329] = {.lex_state = 1},
    [330] = {.lex_state = 1},
    [331] = {.lex_state = 1},
    [332] = {.lex_state = 1},
    [333] = {.lex_state = 293},
    [334] = {.lex_state = 1},
    [335] = {.lex_state = 1},
    [336] = {.lex_state = 1},
    [337] = {.lex_state = 0},
    [338] = {.lex_state = 0},
    [339] = {.lex_state = 0},
    [340] = {.lex_state = 1},
    [341] = {.lex_state = 0},
    [342] = {.lex_state = 0},
    [343] = {.lex_state = 297},
    [344] = {.lex_state = 0},
    [345] = {.lex_state = 1},
    [346] = {.lex_state = 0},
    [347] = {.lex_state = 1},
    [348] = {.lex_state = 0},
    [349] = {.lex_state = 1},
    [350] = {.lex_state = 1},
    [351] = {.lex_state = 0},
    [352] = {.lex_state = 0},
    [353] = {.lex_state = 0},
    [354] = {.lex_state = 0},
    [355] = {.lex_state = 1},
    [356] = {.lex_state = 0},
    [357] = {.lex_state = 1},
    [358] = {.lex_state = 0},
    [359] = {.lex_state = 1},
    [360] = {.lex_state = 0},
    [361] = {.lex_state = 1},
    [362] = {.lex_state = 1},
    [363] = {.lex_state = 1},
    [364] = {.lex_state = 0},
    [365] = {.lex_state = 0},
    [366] = {.lex_state = 4},
    [367] = {.lex_state = 1},
    [368] = {.lex_state = 1},
    [369] = {.lex_state = 0},
    [370] = {.lex_state = 0},
    [371] = {.lex_state = 1},
    [372] = {.lex_state = 0},
    [373] = {.lex_state = 1},
    [374] = {.lex_state = 1},
    [375] = {.lex_state = 1},
    [376] = {.lex_state = 0},
    [377] = {.lex_state = 4},
    [378] = {.lex_state = 1},
    [379] = {.lex_state = 0},
    [380] = {.lex_state = 0},
    [381] = {.lex_state = 1},
    [382] = {.lex_state = 1},
    [383] = {.lex_state = 0},
    [384] = {.lex_state = 0},
    [385] = {.lex_state = 4},
    [386] = {.lex_state = 1},
    [387] = {.lex_state = 293},
    [388] = {.lex_state = 297},
    [389] = {.lex_state = 1},
    [390] = {.lex_state = 1},
    [391] = {.lex_state = 293},
    [392] = {.lex_state = 297},
    [393] = {.lex_state = 1},
    [394] = {.lex_state = 293},
    [395] = {.lex_state = 297},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
    [0] = {
        [ts_builtin_sym_end] = ACTIONS(1),
        [anon_sym_schema] = ACTIONS(1),
        [anon_sym_LBRACE] = ACTIONS(1),
        [anon_sym_RBRACE] = ACTIONS(1),
        [anon_sym_extend] = ACTIONS(1),
        [anon_sym_scalar] = ACTIONS(1),
        [anon_sym_type] = ACTIONS(1),
        [anon_sym_interface] = ACTIONS(1),
        [anon_sym_union] = ACTIONS(1),
        [anon_sym_enum] = ACTIONS(1),
        [anon_sym_input] = ACTIONS(1),
        [anon_sym_AMP] = ACTIONS(1),
        [anon_sym_implements] = ACTIONS(1),
        [anon_sym_COLON] = ACTIONS(1),
        [anon_sym_LPAREN] = ACTIONS(1),
        [anon_sym_RPAREN] = ACTIONS(1),
        [anon_sym_EQ] = ACTIONS(1),
        [anon_sym_PIPE] = ACTIONS(1),
        [anon_sym_query] = ACTIONS(1),
        [anon_sym_mutation] = ACTIONS(1),
        [anon_sym_subscription] = ACTIONS(1),
        [anon_sym_DOLLAR] = ACTIONS(1),
        [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
        [anon_sym_DQUOTE] = ACTIONS(1),
        [sym_int_value] = ACTIONS(1),
        [sym_float_value] = ACTIONS(1),
        [anon_sym_true] = ACTIONS(1),
        [anon_sym_false] = ACTIONS(1),
        [sym_null_value] = ACTIONS(1),
        [anon_sym_LBRACK] = ACTIONS(1),
        [anon_sym_RBRACK] = ACTIONS(1),
        [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
        [anon_sym_fragment] = ACTIONS(1),
        [anon_sym_on] = ACTIONS(1),
        [anon_sym_AT] = ACTIONS(1),
        [anon_sym_directive] = ACTIONS(1),
        [anon_sym_repeatable] = ACTIONS(1),
        [anon_sym_QUERY] = ACTIONS(1),
        [anon_sym_MUTATION] = ACTIONS(1),
        [anon_sym_SUBSCRIPTION] = ACTIONS(1),
        [anon_sym_FIELD] = ACTIONS(1),
        [anon_sym_FRAGMENT_DEFINITION] = ACTIONS(1),
        [anon_sym_FRAGMENT_SPREAD] = ACTIONS(1),
        [anon_sym_INLINE_FRAGMENT] = ACTIONS(1),
        [anon_sym_VARIABLE_DEFINITION] = ACTIONS(1),
        [anon_sym_SCHEMA] = ACTIONS(1),
        [anon_sym_SCALAR] = ACTIONS(1),
        [anon_sym_OBJECT] = ACTIONS(1),
        [anon_sym_FIELD_DEFINITION] = ACTIONS(1),
        [anon_sym_ARGUMENT_DEFINITION] = ACTIONS(1),
        [anon_sym_INTERFACE] = ACTIONS(1),
        [anon_sym_UNION] = ACTIONS(1),
        [anon_sym_ENUM] = ACTIONS(1),
        [anon_sym_ENUM_VALUE] = ACTIONS(1),
        [anon_sym_INPUT_OBJECT] = ACTIONS(1),
        [anon_sym_INPUT_FIELD_DEFINITION] = ACTIONS(1),
        [anon_sym_BANG] = ACTIONS(1),
        [sym_comment] = ACTIONS(3),
        [sym_comma] = ACTIONS(3),
    },
    [1] = {
        [sym_source_file] = STATE(352),
        [sym_document] = STATE(354),
        [sym_definition] = STATE(2),
        [sym_executable_definition] = STATE(131),
        [sym_type_system_definition] = STATE(131),
        [sym_type_system_extension] = STATE(131),
        [sym_schema_definition] = STATE(123),
        [sym_schema_extension] = STATE(117),
        [sym_type_extension] = STATE(117),
        [sym_scalar_type_extension] = STATE(113),
        [sym_object_type_extension] = STATE(113),
        [sym_interface_type_extension] = STATE(113),
        [sym_union_type_extension] = STATE(113),
        [sym_enum_type_extension] = STATE(113),
        [sym_input_object_type_extension] = STATE(113),
        [sym_operation_definition] = STATE(110),
        [sym_operation_type] = STATE(156),
        [sym_type_definition] = STATE(123),
        [sym_scalar_type_definition] = STATE(107),
        [sym_object_type_definition] = STATE(107),
        [sym_interface_type_definition] = STATE(107),
        [sym_union_type_definition] = STATE(107),
        [sym_enum_type_definition] = STATE(107),
        [sym_input_object_type_definition] = STATE(107),
        [sym_selection_set] = STATE(134),
        [sym_string_value] = STATE(166),
        [sym_fragment_definition] = STATE(110),
        [sym_directive_definition] = STATE(123),
        [sym_description] = STATE(182),
        [aux_sym_document_repeat1] = STATE(2),
        [anon_sym_schema] = ACTIONS(5),
        [anon_sym_LBRACE] = ACTIONS(7),
        [anon_sym_extend] = ACTIONS(9),
        [anon_sym_scalar] = ACTIONS(11),
        [anon_sym_type] = ACTIONS(13),
        [anon_sym_interface] = ACTIONS(15),
        [anon_sym_union] = ACTIONS(17),
        [anon_sym_enum] = ACTIONS(19),
        [anon_sym_input] = ACTIONS(21),
        [anon_sym_query] = ACTIONS(23),
        [anon_sym_mutation] = ACTIONS(23),
        [anon_sym_subscription] = ACTIONS(23),
        [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(25),
        [anon_sym_DQUOTE] = ACTIONS(27),
        [anon_sym_fragment] = ACTIONS(29),
        [anon_sym_directive] = ACTIONS(31),
        [sym_comment] = ACTIONS(3),
        [sym_comma] = ACTIONS(3),
    },
};

static uint16_t ts_small_parse_table[] = {
    [0] = 27,
    ACTIONS(5),
    1,
    anon_sym_schema,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    ACTIONS(9),
    1,
    anon_sym_extend,
    ACTIONS(11),
    1,
    anon_sym_scalar,
    ACTIONS(13),
    1,
    anon_sym_type,
    ACTIONS(15),
    1,
    anon_sym_interface,
    ACTIONS(17),
    1,
    anon_sym_union,
    ACTIONS(19),
    1,
    anon_sym_enum,
    ACTIONS(21),
    1,
    anon_sym_input,
    ACTIONS(25),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(27),
    1,
    anon_sym_DQUOTE,
    ACTIONS(29),
    1,
    anon_sym_fragment,
    ACTIONS(31),
    1,
    anon_sym_directive,
    ACTIONS(33),
    1,
    ts_builtin_sym_end,
    STATE(134),
    1,
    sym_selection_set,
    STATE(156),
    1,
    sym_operation_type,
    STATE(166),
    1,
    sym_string_value,
    STATE(182),
    1,
    sym_description,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(3),
    2,
    sym_definition,
    aux_sym_document_repeat1,
    STATE(110),
    2,
    sym_operation_definition,
    sym_fragment_definition,
    STATE(117),
    2,
    sym_schema_extension,
    sym_type_extension,
    ACTIONS(23),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    STATE(123),
    3,
    sym_schema_definition,
    sym_type_definition,
    sym_directive_definition,
    STATE(131),
    3,
    sym_executable_definition,
    sym_type_system_definition,
    sym_type_system_extension,
    STATE(107),
    6,
    sym_scalar_type_definition,
    sym_object_type_definition,
    sym_interface_type_definition,
    sym_union_type_definition,
    sym_enum_type_definition,
    sym_input_object_type_definition,
    STATE(113),
    6,
    sym_scalar_type_extension,
    sym_object_type_extension,
    sym_interface_type_extension,
    sym_union_type_extension,
    sym_enum_type_extension,
    sym_input_object_type_extension,
    [102] = 27,
    ACTIONS(35),
    1,
    ts_builtin_sym_end,
    ACTIONS(37),
    1,
    anon_sym_schema,
    ACTIONS(40),
    1,
    anon_sym_LBRACE,
    ACTIONS(43),
    1,
    anon_sym_extend,
    ACTIONS(46),
    1,
    anon_sym_scalar,
    ACTIONS(49),
    1,
    anon_sym_type,
    ACTIONS(52),
    1,
    anon_sym_interface,
    ACTIONS(55),
    1,
    anon_sym_union,
    ACTIONS(58),
    1,
    anon_sym_enum,
    ACTIONS(61),
    1,
    anon_sym_input,
    ACTIONS(67),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(70),
    1,
    anon_sym_DQUOTE,
    ACTIONS(73),
    1,
    anon_sym_fragment,
    ACTIONS(76),
    1,
    anon_sym_directive,
    STATE(134),
    1,
    sym_selection_set,
    STATE(156),
    1,
    sym_operation_type,
    STATE(166),
    1,
    sym_string_value,
    STATE(182),
    1,
    sym_description,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(3),
    2,
    sym_definition,
    aux_sym_document_repeat1,
    STATE(110),
    2,
    sym_operation_definition,
    sym_fragment_definition,
    STATE(117),
    2,
    sym_schema_extension,
    sym_type_extension,
    ACTIONS(64),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    STATE(123),
    3,
    sym_schema_definition,
    sym_type_definition,
    sym_directive_definition,
    STATE(131),
    3,
    sym_executable_definition,
    sym_type_system_definition,
    sym_type_system_extension,
    STATE(107),
    6,
    sym_scalar_type_definition,
    sym_object_type_definition,
    sym_interface_type_definition,
    sym_union_type_definition,
    sym_enum_type_definition,
    sym_input_object_type_definition,
    STATE(113),
    6,
    sym_scalar_type_extension,
    sym_object_type_extension,
    sym_interface_type_extension,
    sym_union_type_extension,
    sym_enum_type_extension,
    sym_input_object_type_extension,
    [204] = 10,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(83),
    1,
    anon_sym_implements,
    ACTIONS(85),
    1,
    anon_sym_DQUOTE,
    ACTIONS(87),
    1,
    anon_sym_AT,
    STATE(20),
    1,
    sym_implements_interfaces,
    STATE(81),
    1,
    sym_directives,
    STATE(91),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(79),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [251] = 9,
    ACTIONS(89),
    1,
    anon_sym_PIPE,
    ACTIONS(93),
    1,
    anon_sym_FIELD,
    ACTIONS(97),
    1,
    anon_sym_ENUM,
    STATE(73),
    1,
    sym_directive_locations,
    STATE(74),
    1,
    sym_directive_location,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(75),
    2,
    sym_executable_directive_location,
    sym_type_system_directive_location,
    ACTIONS(91),
    7,
    anon_sym_QUERY,
    anon_sym_MUTATION,
    anon_sym_SUBSCRIPTION,
    anon_sym_FRAGMENT_DEFINITION,
    anon_sym_FRAGMENT_SPREAD,
    anon_sym_INLINE_FRAGMENT,
    anon_sym_VARIABLE_DEFINITION,
    ACTIONS(95),
    10,
    anon_sym_SCHEMA,
    anon_sym_SCALAR,
    anon_sym_OBJECT,
    anon_sym_FIELD_DEFINITION,
    anon_sym_ARGUMENT_DEFINITION,
    anon_sym_INTERFACE,
    anon_sym_UNION,
    anon_sym_ENUM_VALUE,
    anon_sym_INPUT_OBJECT,
    anon_sym_INPUT_FIELD_DEFINITION,
    [296] = 10,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(83),
    1,
    anon_sym_implements,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(101),
    1,
    anon_sym_DQUOTE,
    STATE(21),
    1,
    sym_implements_interfaces,
    STATE(66),
    1,
    sym_directives,
    STATE(136),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(99),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [343] = 9,
    ACTIONS(89),
    1,
    anon_sym_PIPE,
    ACTIONS(93),
    1,
    anon_sym_FIELD,
    ACTIONS(97),
    1,
    anon_sym_ENUM,
    STATE(74),
    1,
    sym_directive_location,
    STATE(82),
    1,
    sym_directive_locations,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(75),
    2,
    sym_executable_directive_location,
    sym_type_system_directive_location,
    ACTIONS(91),
    7,
    anon_sym_QUERY,
    anon_sym_MUTATION,
    anon_sym_SUBSCRIPTION,
    anon_sym_FRAGMENT_DEFINITION,
    anon_sym_FRAGMENT_SPREAD,
    anon_sym_INLINE_FRAGMENT,
    anon_sym_VARIABLE_DEFINITION,
    ACTIONS(95),
    10,
    anon_sym_SCHEMA,
    anon_sym_SCALAR,
    anon_sym_OBJECT,
    anon_sym_FIELD_DEFINITION,
    anon_sym_ARGUMENT_DEFINITION,
    anon_sym_INTERFACE,
    anon_sym_UNION,
    anon_sym_ENUM_VALUE,
    anon_sym_INPUT_OBJECT,
    anon_sym_INPUT_FIELD_DEFINITION,
    [388] = 10,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(83),
    1,
    anon_sym_implements,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(105),
    1,
    anon_sym_DQUOTE,
    STATE(16),
    1,
    sym_implements_interfaces,
    STATE(59),
    1,
    sym_directives,
    STATE(128),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(103),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [435] = 10,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(83),
    1,
    anon_sym_implements,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(109),
    1,
    anon_sym_DQUOTE,
    STATE(17),
    1,
    sym_implements_interfaces,
    STATE(68),
    1,
    sym_directives,
    STATE(106),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(107),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [482] = 9,
    ACTIONS(89),
    1,
    anon_sym_PIPE,
    ACTIONS(93),
    1,
    anon_sym_FIELD,
    ACTIONS(97),
    1,
    anon_sym_ENUM,
    STATE(74),
    1,
    sym_directive_location,
    STATE(87),
    1,
    sym_directive_locations,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(75),
    2,
    sym_executable_directive_location,
    sym_type_system_directive_location,
    ACTIONS(91),
    7,
    anon_sym_QUERY,
    anon_sym_MUTATION,
    anon_sym_SUBSCRIPTION,
    anon_sym_FRAGMENT_DEFINITION,
    anon_sym_FRAGMENT_SPREAD,
    anon_sym_INLINE_FRAGMENT,
    anon_sym_VARIABLE_DEFINITION,
    ACTIONS(95),
    10,
    anon_sym_SCHEMA,
    anon_sym_SCALAR,
    anon_sym_OBJECT,
    anon_sym_FIELD_DEFINITION,
    anon_sym_ARGUMENT_DEFINITION,
    anon_sym_INTERFACE,
    anon_sym_UNION,
    anon_sym_ENUM_VALUE,
    anon_sym_INPUT_OBJECT,
    anon_sym_INPUT_FIELD_DEFINITION,
    [527] = 10,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(83),
    1,
    anon_sym_implements,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(113),
    1,
    anon_sym_DQUOTE,
    STATE(24),
    1,
    sym_implements_interfaces,
    STATE(58),
    1,
    sym_directives,
    STATE(135),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(111),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [574] = 9,
    ACTIONS(89),
    1,
    anon_sym_PIPE,
    ACTIONS(93),
    1,
    anon_sym_FIELD,
    ACTIONS(97),
    1,
    anon_sym_ENUM,
    STATE(74),
    1,
    sym_directive_location,
    STATE(89),
    1,
    sym_directive_locations,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(75),
    2,
    sym_executable_directive_location,
    sym_type_system_directive_location,
    ACTIONS(91),
    7,
    anon_sym_QUERY,
    anon_sym_MUTATION,
    anon_sym_SUBSCRIPTION,
    anon_sym_FRAGMENT_DEFINITION,
    anon_sym_FRAGMENT_SPREAD,
    anon_sym_INLINE_FRAGMENT,
    anon_sym_VARIABLE_DEFINITION,
    ACTIONS(95),
    10,
    anon_sym_SCHEMA,
    anon_sym_SCALAR,
    anon_sym_OBJECT,
    anon_sym_FIELD_DEFINITION,
    anon_sym_ARGUMENT_DEFINITION,
    anon_sym_INTERFACE,
    anon_sym_UNION,
    anon_sym_ENUM_VALUE,
    anon_sym_INPUT_OBJECT,
    anon_sym_INPUT_FIELD_DEFINITION,
    [619] = 10,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(83),
    1,
    anon_sym_implements,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(117),
    1,
    anon_sym_DQUOTE,
    STATE(18),
    1,
    sym_implements_interfaces,
    STATE(84),
    1,
    sym_directives,
    STATE(111),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(115),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [666] = 8,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(121),
    1,
    anon_sym_EQ,
    ACTIONS(123),
    1,
    anon_sym_DQUOTE,
    STATE(54),
    1,
    sym_directives,
    STATE(56),
    1,
    sym_union_member_types,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(119),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [708] = 3,
    ACTIONS(127),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(125),
    22,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_RBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_AMP,
    anon_sym_PIPE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_RBRACK,
    anon_sym_fragment,
    anon_sym_AT,
    anon_sym_directive,
    anon_sym_BANG,
    [740] = 9,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(131),
    1,
    anon_sym_AMP,
    ACTIONS(133),
    1,
    anon_sym_DQUOTE,
    STATE(76),
    1,
    sym_directives,
    STATE(102),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(129),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [784] = 9,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(131),
    1,
    anon_sym_AMP,
    ACTIONS(137),
    1,
    anon_sym_DQUOTE,
    STATE(64),
    1,
    sym_directives,
    STATE(112),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(135),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [828] = 9,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(113),
    1,
    anon_sym_DQUOTE,
    ACTIONS(131),
    1,
    anon_sym_AMP,
    STATE(58),
    1,
    sym_directives,
    STATE(135),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(111),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [872] = 8,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(121),
    1,
    anon_sym_EQ,
    ACTIONS(141),
    1,
    anon_sym_DQUOTE,
    STATE(50),
    1,
    sym_directives,
    STATE(86),
    1,
    sym_union_member_types,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(139),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [914] = 9,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(105),
    1,
    anon_sym_DQUOTE,
    ACTIONS(131),
    1,
    anon_sym_AMP,
    STATE(59),
    1,
    sym_directives,
    STATE(128),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(103),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [958] = 9,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(131),
    1,
    anon_sym_AMP,
    ACTIONS(145),
    1,
    anon_sym_DQUOTE,
    STATE(67),
    1,
    sym_directives,
    STATE(109),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(143),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1002] = 8,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(149),
    1,
    anon_sym_LBRACE,
    ACTIONS(151),
    1,
    anon_sym_DQUOTE,
    STATE(48),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    STATE(49),
    2,
    sym_input_fields_definition,
    aux_sym_input_object_type_extension_repeat1,
    ACTIONS(147),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1044] = 8,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(121),
    1,
    anon_sym_EQ,
    ACTIONS(155),
    1,
    anon_sym_DQUOTE,
    STATE(47),
    1,
    sym_directives,
    STATE(65),
    1,
    sym_union_member_types,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(153),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1086] = 9,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(131),
    1,
    anon_sym_AMP,
    ACTIONS(159),
    1,
    anon_sym_DQUOTE,
    STATE(77),
    1,
    sym_directives,
    STATE(101),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(157),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1130] = 8,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(163),
    1,
    anon_sym_LBRACE,
    ACTIONS(165),
    1,
    anon_sym_DQUOTE,
    STATE(60),
    1,
    sym_directives,
    STATE(137),
    1,
    sym_enum_values_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(161),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1171] = 8,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(149),
    1,
    anon_sym_LBRACE,
    ACTIONS(169),
    1,
    anon_sym_DQUOTE,
    STATE(62),
    1,
    sym_directives,
    STATE(133),
    1,
    sym_input_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(167),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1212] = 7,
    ACTIONS(93),
    1,
    anon_sym_FIELD,
    ACTIONS(97),
    1,
    anon_sym_ENUM,
    STATE(85),
    1,
    sym_directive_location,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(75),
    2,
    sym_executable_directive_location,
    sym_type_system_directive_location,
    ACTIONS(91),
    7,
    anon_sym_QUERY,
    anon_sym_MUTATION,
    anon_sym_SUBSCRIPTION,
    anon_sym_FRAGMENT_DEFINITION,
    anon_sym_FRAGMENT_SPREAD,
    anon_sym_INLINE_FRAGMENT,
    anon_sym_VARIABLE_DEFINITION,
    ACTIONS(95),
    10,
    anon_sym_SCHEMA,
    anon_sym_SCALAR,
    anon_sym_OBJECT,
    anon_sym_FIELD_DEFINITION,
    anon_sym_ARGUMENT_DEFINITION,
    anon_sym_INTERFACE,
    anon_sym_UNION,
    anon_sym_ENUM_VALUE,
    anon_sym_INPUT_OBJECT,
    anon_sym_INPUT_FIELD_DEFINITION,
    [1251] = 8,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(163),
    1,
    anon_sym_LBRACE,
    ACTIONS(173),
    1,
    anon_sym_DQUOTE,
    STATE(90),
    1,
    sym_directives,
    STATE(114),
    1,
    sym_enum_values_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(171),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1292] = 7,
    ACTIONS(93),
    1,
    anon_sym_FIELD,
    ACTIONS(97),
    1,
    anon_sym_ENUM,
    STATE(80),
    1,
    sym_directive_location,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(75),
    2,
    sym_executable_directive_location,
    sym_type_system_directive_location,
    ACTIONS(91),
    7,
    anon_sym_QUERY,
    anon_sym_MUTATION,
    anon_sym_SUBSCRIPTION,
    anon_sym_FRAGMENT_DEFINITION,
    anon_sym_FRAGMENT_SPREAD,
    anon_sym_INLINE_FRAGMENT,
    anon_sym_VARIABLE_DEFINITION,
    ACTIONS(95),
    10,
    anon_sym_SCHEMA,
    anon_sym_SCALAR,
    anon_sym_OBJECT,
    anon_sym_FIELD_DEFINITION,
    anon_sym_ARGUMENT_DEFINITION,
    anon_sym_INTERFACE,
    anon_sym_UNION,
    anon_sym_ENUM_VALUE,
    anon_sym_INPUT_OBJECT,
    anon_sym_INPUT_FIELD_DEFINITION,
    [1331] = 8,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(149),
    1,
    anon_sym_LBRACE,
    ACTIONS(177),
    1,
    anon_sym_DQUOTE,
    STATE(78),
    1,
    sym_directives,
    STATE(116),
    1,
    sym_input_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(175),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1372] = 8,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(163),
    1,
    anon_sym_LBRACE,
    ACTIONS(181),
    1,
    anon_sym_DQUOTE,
    STATE(63),
    1,
    sym_directives,
    STATE(126),
    1,
    sym_enum_values_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(179),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1413] = 5,
    ACTIONS(185),
    1,
    anon_sym_LPAREN,
    ACTIONS(187),
    1,
    anon_sym_DQUOTE,
    STATE(53),
    1,
    sym_arguments,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(183),
    18,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_EQ,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_AT,
    anon_sym_directive,
    [1447] = 6,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(191),
    1,
    anon_sym_DQUOTE,
    STATE(125),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(189),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1483] = 5,
    ACTIONS(195),
    1,
    anon_sym_DQUOTE,
    ACTIONS(197),
    1,
    anon_sym_AT,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(34),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(193),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_EQ,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1517] = 6,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(202),
    1,
    anon_sym_DQUOTE,
    STATE(108),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(200),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1553] = 5,
    ACTIONS(87),
    1,
    anon_sym_AT,
    ACTIONS(206),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(34),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(204),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_EQ,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1587] = 13,
    ACTIONS(208),
    1,
    anon_sym_LBRACE,
    ACTIONS(211),
    1,
    anon_sym_DOLLAR,
    ACTIONS(214),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(217),
    1,
    anon_sym_DQUOTE,
    ACTIONS(223),
    1,
    sym_float_value,
    ACTIONS(229),
    1,
    anon_sym_LBRACK,
    ACTIONS(232),
    1,
    anon_sym_RBRACK,
    ACTIONS(234),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(220),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(226),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(37),
    2,
    sym_value,
    aux_sym_list_value_repeat1,
    STATE(145),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [1636] = 13,
    ACTIONS(237),
    1,
    anon_sym_LBRACE,
    ACTIONS(239),
    1,
    anon_sym_DOLLAR,
    ACTIONS(241),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(243),
    1,
    anon_sym_DQUOTE,
    ACTIONS(247),
    1,
    sym_float_value,
    ACTIONS(251),
    1,
    anon_sym_LBRACK,
    ACTIONS(253),
    1,
    anon_sym_RBRACK,
    ACTIONS(255),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(245),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(249),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(37),
    2,
    sym_value,
    aux_sym_list_value_repeat1,
    STATE(145),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [1685] = 13,
    ACTIONS(237),
    1,
    anon_sym_LBRACE,
    ACTIONS(239),
    1,
    anon_sym_DOLLAR,
    ACTIONS(241),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(243),
    1,
    anon_sym_DQUOTE,
    ACTIONS(247),
    1,
    sym_float_value,
    ACTIONS(251),
    1,
    anon_sym_LBRACK,
    ACTIONS(255),
    1,
    sym_name,
    ACTIONS(257),
    1,
    anon_sym_RBRACK,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(245),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(249),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(40),
    2,
    sym_value,
    aux_sym_list_value_repeat1,
    STATE(145),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [1734] = 13,
    ACTIONS(237),
    1,
    anon_sym_LBRACE,
    ACTIONS(239),
    1,
    anon_sym_DOLLAR,
    ACTIONS(241),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(243),
    1,
    anon_sym_DQUOTE,
    ACTIONS(247),
    1,
    sym_float_value,
    ACTIONS(251),
    1,
    anon_sym_LBRACK,
    ACTIONS(255),
    1,
    sym_name,
    ACTIONS(259),
    1,
    anon_sym_RBRACK,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(245),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(249),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(37),
    2,
    sym_value,
    aux_sym_list_value_repeat1,
    STATE(145),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [1783] = 13,
    ACTIONS(237),
    1,
    anon_sym_LBRACE,
    ACTIONS(239),
    1,
    anon_sym_DOLLAR,
    ACTIONS(241),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(243),
    1,
    anon_sym_DQUOTE,
    ACTIONS(247),
    1,
    sym_float_value,
    ACTIONS(251),
    1,
    anon_sym_LBRACK,
    ACTIONS(255),
    1,
    sym_name,
    ACTIONS(261),
    1,
    anon_sym_RBRACK,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(245),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(249),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(42),
    2,
    sym_value,
    aux_sym_list_value_repeat1,
    STATE(145),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [1832] = 13,
    ACTIONS(237),
    1,
    anon_sym_LBRACE,
    ACTIONS(239),
    1,
    anon_sym_DOLLAR,
    ACTIONS(241),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(243),
    1,
    anon_sym_DQUOTE,
    ACTIONS(247),
    1,
    sym_float_value,
    ACTIONS(251),
    1,
    anon_sym_LBRACK,
    ACTIONS(255),
    1,
    sym_name,
    ACTIONS(263),
    1,
    anon_sym_RBRACK,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(245),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(249),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(37),
    2,
    sym_value,
    aux_sym_list_value_repeat1,
    STATE(145),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [1881] = 13,
    ACTIONS(237),
    1,
    anon_sym_LBRACE,
    ACTIONS(239),
    1,
    anon_sym_DOLLAR,
    ACTIONS(241),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(243),
    1,
    anon_sym_DQUOTE,
    ACTIONS(247),
    1,
    sym_float_value,
    ACTIONS(251),
    1,
    anon_sym_LBRACK,
    ACTIONS(255),
    1,
    sym_name,
    ACTIONS(265),
    1,
    anon_sym_RBRACK,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(245),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(249),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(38),
    2,
    sym_value,
    aux_sym_list_value_repeat1,
    STATE(145),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [1930] = 5,
    ACTIONS(269),
    1,
    anon_sym_LBRACE,
    ACTIONS(272),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(44),
    2,
    sym_input_fields_definition,
    aux_sym_input_object_type_extension_repeat1,
    ACTIONS(267),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1962] = 5,
    ACTIONS(149),
    1,
    anon_sym_LBRACE,
    ACTIONS(276),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(44),
    2,
    sym_input_fields_definition,
    aux_sym_input_object_type_extension_repeat1,
    ACTIONS(274),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [1994] = 3,
    ACTIONS(280),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(278),
    18,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_AMP,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_AT,
    anon_sym_directive,
    [2022] = 5,
    ACTIONS(121),
    1,
    anon_sym_EQ,
    ACTIONS(284),
    1,
    anon_sym_DQUOTE,
    STATE(69),
    1,
    sym_union_member_types,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(282),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2054] = 5,
    ACTIONS(149),
    1,
    anon_sym_LBRACE,
    ACTIONS(288),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(45),
    2,
    sym_input_fields_definition,
    aux_sym_input_object_type_extension_repeat1,
    ACTIONS(286),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2086] = 5,
    ACTIONS(149),
    1,
    anon_sym_LBRACE,
    ACTIONS(288),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(44),
    2,
    sym_input_fields_definition,
    aux_sym_input_object_type_extension_repeat1,
    ACTIONS(286),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2118] = 5,
    ACTIONS(121),
    1,
    anon_sym_EQ,
    ACTIONS(123),
    1,
    anon_sym_DQUOTE,
    STATE(56),
    1,
    sym_union_member_types,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(119),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2150] = 3,
    ACTIONS(292),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(290),
    18,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_AMP,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_AT,
    anon_sym_directive,
    [2178] = 3,
    ACTIONS(296),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(294),
    18,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_EQ,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_AT,
    anon_sym_directive,
    [2206] = 3,
    ACTIONS(300),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(298),
    18,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_EQ,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_AT,
    anon_sym_directive,
    [2234] = 5,
    ACTIONS(121),
    1,
    anon_sym_EQ,
    ACTIONS(304),
    1,
    anon_sym_DQUOTE,
    STATE(79),
    1,
    sym_union_member_types,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(302),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2266] = 12,
    ACTIONS(306),
    1,
    anon_sym_LBRACE,
    ACTIONS(308),
    1,
    anon_sym_DOLLAR,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(316),
    1,
    sym_float_value,
    ACTIONS(320),
    1,
    anon_sym_LBRACK,
    ACTIONS(322),
    1,
    sym_name,
    STATE(317),
    1,
    sym_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(314),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(318),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(205),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [2311] = 4,
    ACTIONS(304),
    1,
    anon_sym_DQUOTE,
    ACTIONS(324),
    1,
    anon_sym_PIPE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(302),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2340] = 3,
    ACTIONS(328),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(326),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_PIPE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2367] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(159),
    1,
    anon_sym_DQUOTE,
    STATE(101),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(157),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2398] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(133),
    1,
    anon_sym_DQUOTE,
    STATE(102),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(129),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2429] = 5,
    ACTIONS(163),
    1,
    anon_sym_LBRACE,
    ACTIONS(332),
    1,
    anon_sym_DQUOTE,
    STATE(94),
    1,
    sym_enum_values_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(330),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2460] = 12,
    ACTIONS(306),
    1,
    anon_sym_LBRACE,
    ACTIONS(308),
    1,
    anon_sym_DOLLAR,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(316),
    1,
    sym_float_value,
    ACTIONS(320),
    1,
    anon_sym_LBRACK,
    ACTIONS(322),
    1,
    sym_name,
    STATE(223),
    1,
    sym_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(314),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(318),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(205),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [2505] = 5,
    ACTIONS(149),
    1,
    anon_sym_LBRACE,
    ACTIONS(336),
    1,
    anon_sym_DQUOTE,
    STATE(93),
    1,
    sym_input_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(334),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2536] = 5,
    ACTIONS(163),
    1,
    anon_sym_LBRACE,
    ACTIONS(340),
    1,
    anon_sym_DQUOTE,
    STATE(105),
    1,
    sym_enum_values_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(338),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2567] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(344),
    1,
    anon_sym_DQUOTE,
    STATE(98),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(342),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2598] = 4,
    ACTIONS(284),
    1,
    anon_sym_DQUOTE,
    ACTIONS(324),
    1,
    anon_sym_PIPE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(282),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2627] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(145),
    1,
    anon_sym_DQUOTE,
    STATE(109),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(143),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2658] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(348),
    1,
    anon_sym_DQUOTE,
    STATE(100),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(346),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2689] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(137),
    1,
    anon_sym_DQUOTE,
    STATE(112),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(135),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2720] = 4,
    ACTIONS(324),
    1,
    anon_sym_PIPE,
    ACTIONS(352),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(350),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2749] = 3,
    ACTIONS(356),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(354),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_PIPE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2776] = 3,
    ACTIONS(360),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(358),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_PIPE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2803] = 3,
    ACTIONS(364),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(362),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_PIPE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2830] = 4,
    ACTIONS(368),
    1,
    anon_sym_PIPE,
    ACTIONS(370),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(366),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2859] = 3,
    ACTIONS(374),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(372),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_PIPE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2886] = 3,
    ACTIONS(378),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(376),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_PIPE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2913] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(382),
    1,
    anon_sym_DQUOTE,
    STATE(119),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(380),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2944] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(386),
    1,
    anon_sym_DQUOTE,
    STATE(92),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(384),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [2975] = 5,
    ACTIONS(149),
    1,
    anon_sym_LBRACE,
    ACTIONS(169),
    1,
    anon_sym_DQUOTE,
    STATE(133),
    1,
    sym_input_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(167),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3006] = 4,
    ACTIONS(324),
    1,
    anon_sym_PIPE,
    ACTIONS(390),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(388),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3035] = 3,
    ACTIONS(394),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(392),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_PIPE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3062] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(105),
    1,
    anon_sym_DQUOTE,
    STATE(128),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(103),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3093] = 4,
    ACTIONS(368),
    1,
    anon_sym_PIPE,
    ACTIONS(398),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(396),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3122] = 12,
    ACTIONS(400),
    1,
    anon_sym_LBRACE,
    ACTIONS(402),
    1,
    anon_sym_DOLLAR,
    ACTIONS(404),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(406),
    1,
    anon_sym_DQUOTE,
    ACTIONS(410),
    1,
    sym_float_value,
    ACTIONS(414),
    1,
    anon_sym_LBRACK,
    ACTIONS(416),
    1,
    sym_name,
    STATE(300),
    1,
    sym_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(408),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(412),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(251),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [3167] = 5,
    ACTIONS(81),
    1,
    anon_sym_LBRACE,
    ACTIONS(113),
    1,
    anon_sym_DQUOTE,
    STATE(135),
    1,
    sym_fields_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(111),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3198] = 3,
    ACTIONS(420),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(418),
    17,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_PIPE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3225] = 4,
    ACTIONS(123),
    1,
    anon_sym_DQUOTE,
    ACTIONS(324),
    1,
    anon_sym_PIPE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(119),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3254] = 4,
    ACTIONS(368),
    1,
    anon_sym_PIPE,
    ACTIONS(424),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(422),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3283] = 12,
    ACTIONS(400),
    1,
    anon_sym_LBRACE,
    ACTIONS(402),
    1,
    anon_sym_DOLLAR,
    ACTIONS(404),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(406),
    1,
    anon_sym_DQUOTE,
    ACTIONS(410),
    1,
    sym_float_value,
    ACTIONS(414),
    1,
    anon_sym_LBRACK,
    ACTIONS(416),
    1,
    sym_name,
    STATE(318),
    1,
    sym_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(408),
    2,
    sym_int_value,
    sym_null_value,
    ACTIONS(412),
    2,
    anon_sym_true,
    anon_sym_false,
    STATE(251),
    6,
    sym_variable,
    sym_string_value,
    sym_boolean_value,
    sym_enum_value,
    sym_list_value,
    sym_object_value,
    [3328] = 4,
    ACTIONS(368),
    1,
    anon_sym_PIPE,
    ACTIONS(428),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(426),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3357] = 5,
    ACTIONS(163),
    1,
    anon_sym_LBRACE,
    ACTIONS(165),
    1,
    anon_sym_DQUOTE,
    STATE(137),
    1,
    sym_enum_values_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(161),
    15,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3388] = 3,
    ACTIONS(105),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(103),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3414] = 3,
    ACTIONS(432),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(430),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3440] = 3,
    ACTIONS(436),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(434),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3466] = 3,
    ACTIONS(440),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(438),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3492] = 3,
    ACTIONS(444),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(442),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3518] = 3,
    ACTIONS(448),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(446),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3544] = 3,
    ACTIONS(452),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(450),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3570] = 3,
    ACTIONS(456),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(454),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3596] = 3,
    ACTIONS(460),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(458),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3622] = 3,
    ACTIONS(464),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(462),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3648] = 3,
    ACTIONS(386),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(384),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3674] = 3,
    ACTIONS(382),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(380),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3700] = 3,
    ACTIONS(468),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(466),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3726] = 3,
    ACTIONS(472),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(470),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3752] = 3,
    ACTIONS(476),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(474),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3778] = 3,
    ACTIONS(137),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(135),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3804] = 3,
    ACTIONS(480),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(478),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3830] = 3,
    ACTIONS(191),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(189),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3856] = 3,
    ACTIONS(348),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(346),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3882] = 3,
    ACTIONS(484),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(482),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3908] = 3,
    ACTIONS(113),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(111),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3934] = 3,
    ACTIONS(344),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(342),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3960] = 3,
    ACTIONS(488),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(486),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [3986] = 3,
    ACTIONS(165),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(161),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4012] = 3,
    ACTIONS(492),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(490),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4038] = 3,
    ACTIONS(169),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(167),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4064] = 3,
    ACTIONS(496),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(494),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4090] = 3,
    ACTIONS(500),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(498),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4116] = 3,
    ACTIONS(504),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(502),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4142] = 3,
    ACTIONS(508),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(506),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4168] = 3,
    ACTIONS(512),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(510),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4194] = 3,
    ACTIONS(516),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(514),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4220] = 3,
    ACTIONS(520),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(518),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4246] = 3,
    ACTIONS(524),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(522),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4272] = 3,
    ACTIONS(528),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(526),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4298] = 3,
    ACTIONS(340),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(338),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4324] = 3,
    ACTIONS(532),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(530),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4350] = 3,
    ACTIONS(133),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(129),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4376] = 3,
    ACTIONS(536),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(534),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4402] = 3,
    ACTIONS(540),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(538),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4428] = 3,
    ACTIONS(544),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(542),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4454] = 3,
    ACTIONS(548),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(546),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4480] = 3,
    ACTIONS(336),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(334),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4506] = 3,
    ACTIONS(552),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(550),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4532] = 3,
    ACTIONS(159),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(157),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4558] = 3,
    ACTIONS(145),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(143),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4584] = 3,
    ACTIONS(332),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(330),
    16,
    ts_builtin_sym_end,
    anon_sym_schema,
    anon_sym_LBRACE,
    anon_sym_extend,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_fragment,
    anon_sym_directive,
    [4610] = 3,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(554),
    6,
    anon_sym_LBRACE,
    anon_sym_DOLLAR,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_float_value,
    anon_sym_LBRACK,
    anon_sym_RBRACK,
    ACTIONS(556),
    6,
    anon_sym_DQUOTE,
    sym_int_value,
    anon_sym_true,
    anon_sym_false,
    sym_null_value,
    sym_name,
    [4631] = 3,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(558),
    6,
    anon_sym_LBRACE,
    anon_sym_DOLLAR,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_float_value,
    anon_sym_LBRACK,
    anon_sym_RBRACK,
    ACTIONS(560),
    6,
    anon_sym_DQUOTE,
    sym_int_value,
    anon_sym_true,
    anon_sym_false,
    sym_null_value,
    sym_name,
    [4652] = 3,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(562),
    6,
    anon_sym_LBRACE,
    anon_sym_DOLLAR,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_float_value,
    anon_sym_LBRACK,
    anon_sym_RBRACK,
    ACTIONS(564),
    6,
    anon_sym_DQUOTE,
    sym_int_value,
    anon_sym_true,
    anon_sym_false,
    sym_null_value,
    sym_name,
    [4673] = 3,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(566),
    6,
    anon_sym_LBRACE,
    anon_sym_DOLLAR,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_float_value,
    anon_sym_LBRACK,
    anon_sym_RBRACK,
    ACTIONS(568),
    6,
    anon_sym_DQUOTE,
    sym_int_value,
    anon_sym_true,
    anon_sym_false,
    sym_null_value,
    sym_name,
    [4694] = 3,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(570),
    6,
    anon_sym_LBRACE,
    anon_sym_DOLLAR,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_float_value,
    anon_sym_LBRACK,
    anon_sym_RBRACK,
    ACTIONS(572),
    6,
    anon_sym_DQUOTE,
    sym_int_value,
    anon_sym_true,
    anon_sym_false,
    sym_null_value,
    sym_name,
    [4715] = 3,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(574),
    6,
    anon_sym_LBRACE,
    anon_sym_DOLLAR,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_float_value,
    anon_sym_LBRACK,
    anon_sym_RBRACK,
    ACTIONS(576),
    6,
    anon_sym_DQUOTE,
    sym_int_value,
    anon_sym_true,
    anon_sym_false,
    sym_null_value,
    sym_name,
    [4736] = 3,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(578),
    6,
    anon_sym_LBRACE,
    anon_sym_DOLLAR,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_float_value,
    anon_sym_LBRACK,
    anon_sym_RBRACK,
    ACTIONS(580),
    6,
    anon_sym_DQUOTE,
    sym_int_value,
    anon_sym_true,
    anon_sym_false,
    sym_null_value,
    sym_name,
    [4757] = 3,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(582),
    6,
    anon_sym_LBRACE,
    anon_sym_DOLLAR,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_float_value,
    anon_sym_LBRACK,
    anon_sym_RBRACK,
    ACTIONS(584),
    6,
    anon_sym_DQUOTE,
    sym_int_value,
    anon_sym_true,
    anon_sym_false,
    sym_null_value,
    sym_name,
    [4778] = 3,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(586),
    6,
    anon_sym_LBRACE,
    anon_sym_DOLLAR,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_float_value,
    anon_sym_LBRACK,
    anon_sym_RBRACK,
    ACTIONS(588),
    6,
    anon_sym_DQUOTE,
    sym_int_value,
    anon_sym_true,
    anon_sym_false,
    sym_null_value,
    sym_name,
    [4799] = 8,
    ACTIONS(592),
    1,
    anon_sym_EQ,
    ACTIONS(594),
    1,
    anon_sym_DQUOTE,
    ACTIONS(596),
    1,
    anon_sym_AT,
    STATE(163),
    1,
    sym_default_value,
    STATE(230),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(590),
    4,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [4829] = 8,
    ACTIONS(592),
    1,
    anon_sym_EQ,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(600),
    1,
    anon_sym_DQUOTE,
    STATE(154),
    1,
    sym_default_value,
    STATE(242),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(598),
    4,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [4859] = 10,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    ACTIONS(604),
    1,
    anon_sym_on,
    ACTIONS(606),
    1,
    sym_name,
    STATE(197),
    1,
    sym_fragment_name,
    STATE(215),
    1,
    sym_type_condition,
    STATE(286),
    1,
    sym_selection_set,
    STATE(324),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [4892] = 9,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    ACTIONS(610),
    1,
    anon_sym_COLON,
    ACTIONS(612),
    1,
    anon_sym_LPAREN,
    STATE(198),
    1,
    sym_arguments,
    STATE(229),
    1,
    sym_directive,
    STATE(280),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(608),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [4923] = 5,
    ACTIONS(187),
    1,
    anon_sym_DQUOTE,
    ACTIONS(612),
    1,
    anon_sym_LPAREN,
    STATE(187),
    1,
    sym_arguments,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(183),
    7,
    anon_sym_LBRACE,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_DOT_DOT_DOT,
    anon_sym_AT,
    sym_name,
    [4946] = 5,
    ACTIONS(206),
    1,
    anon_sym_DQUOTE,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(155),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(204),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [4968] = 8,
    ACTIONS(616),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(619),
    1,
    anon_sym_DQUOTE,
    ACTIONS(622),
    1,
    sym_name,
    STATE(345),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(614),
    2,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    STATE(153),
    2,
    sym_input_value_definition,
    aux_sym_input_fields_definition_repeat1,
    [4996] = 6,
    ACTIONS(594),
    1,
    anon_sym_DQUOTE,
    ACTIONS(596),
    1,
    anon_sym_AT,
    STATE(230),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(590),
    4,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [5020] = 5,
    ACTIONS(195),
    1,
    anon_sym_DQUOTE,
    ACTIONS(625),
    1,
    anon_sym_AT,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(155),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(193),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [5042] = 9,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(628),
    1,
    anon_sym_LPAREN,
    ACTIONS(630),
    1,
    sym_name,
    STATE(129),
    1,
    sym_selection_set,
    STATE(217),
    1,
    sym_variable_definitions,
    STATE(323),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [5072] = 7,
    ACTIONS(632),
    1,
    anon_sym_RBRACE,
    ACTIONS(634),
    1,
    anon_sym_DOT_DOT_DOT,
    ACTIONS(637),
    1,
    sym_name,
    STATE(359),
    1,
    sym_alias,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(157),
    2,
    sym_selection,
    aux_sym_selection_set_repeat1,
    STATE(297),
    3,
    sym_field,
    sym_fragment_spread,
    sym_inline_fragment,
    [5098] = 8,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    ACTIONS(612),
    1,
    anon_sym_LPAREN,
    STATE(195),
    1,
    sym_arguments,
    STATE(250),
    1,
    sym_directive,
    STATE(288),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(640),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [5126] = 7,
    ACTIONS(642),
    1,
    anon_sym_RBRACE,
    ACTIONS(644),
    1,
    anon_sym_DOT_DOT_DOT,
    ACTIONS(646),
    1,
    sym_name,
    STATE(359),
    1,
    sym_alias,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(157),
    2,
    sym_selection,
    aux_sym_selection_set_repeat1,
    STATE(297),
    3,
    sym_field,
    sym_fragment_spread,
    sym_inline_fragment,
    [5152] = 3,
    ACTIONS(650),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(648),
    8,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_RBRACK,
    anon_sym_AT,
    anon_sym_BANG,
    sym_name,
    [5170] = 4,
    ACTIONS(654),
    1,
    anon_sym_DQUOTE,
    ACTIONS(656),
    1,
    anon_sym_BANG,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(652),
    7,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_RBRACK,
    anon_sym_AT,
    sym_name,
    [5190] = 9,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(658),
    1,
    anon_sym_RBRACE,
    ACTIONS(660),
    1,
    sym_name,
    STATE(174),
    1,
    sym_enum_value,
    STATE(319),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(164),
    2,
    sym_enum_value_definition,
    aux_sym_enum_values_definition_repeat1,
    [5220] = 6,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(664),
    1,
    anon_sym_DQUOTE,
    STATE(236),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(662),
    4,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [5244] = 9,
    ACTIONS(666),
    1,
    anon_sym_RBRACE,
    ACTIONS(668),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(671),
    1,
    anon_sym_DQUOTE,
    ACTIONS(674),
    1,
    sym_name,
    STATE(174),
    1,
    sym_enum_value,
    STATE(319),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(164),
    2,
    sym_enum_value_definition,
    aux_sym_enum_values_definition_repeat1,
    [5274] = 7,
    ACTIONS(644),
    1,
    anon_sym_DOT_DOT_DOT,
    ACTIONS(646),
    1,
    sym_name,
    ACTIONS(677),
    1,
    anon_sym_RBRACE,
    STATE(359),
    1,
    sym_alias,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(157),
    2,
    sym_selection,
    aux_sym_selection_set_repeat1,
    STATE(297),
    3,
    sym_field,
    sym_fragment_spread,
    sym_inline_fragment,
    [5300] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(679),
    8,
    anon_sym_schema,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_directive,
    [5315] = 6,
    ACTIONS(644),
    1,
    anon_sym_DOT_DOT_DOT,
    ACTIONS(646),
    1,
    sym_name,
    STATE(359),
    1,
    sym_alias,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(165),
    2,
    sym_selection,
    aux_sym_selection_set_repeat1,
    STATE(297),
    3,
    sym_field,
    sym_fragment_spread,
    sym_inline_fragment,
    [5338] = 3,
    ACTIONS(127),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(125),
    7,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    anon_sym_BANG,
    sym_name,
    [5355] = 8,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(681),
    1,
    anon_sym_RPAREN,
    ACTIONS(683),
    1,
    sym_name,
    STATE(345),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(153),
    2,
    sym_input_value_definition,
    aux_sym_input_fields_definition_repeat1,
    [5382] = 8,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(685),
    1,
    anon_sym_RBRACE,
    ACTIONS(687),
    1,
    sym_name,
    STATE(329),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(185),
    2,
    sym_field_definition,
    aux_sym_fields_definition_repeat1,
    [5409] = 6,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(691),
    1,
    anon_sym_DQUOTE,
    STATE(272),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(689),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [5432] = 8,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(628),
    1,
    anon_sym_LPAREN,
    STATE(124),
    1,
    sym_selection_set,
    STATE(202),
    1,
    sym_variable_definitions,
    STATE(304),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [5459] = 6,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(695),
    1,
    anon_sym_DQUOTE,
    STATE(271),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(693),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [5482] = 6,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(699),
    1,
    anon_sym_DQUOTE,
    STATE(268),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(697),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [5505] = 3,
    ACTIONS(703),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(701),
    7,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_RBRACK,
    anon_sym_AT,
    sym_name,
    [5522] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(570),
    8,
    anon_sym_schema,
    anon_sym_scalar,
    anon_sym_type,
    anon_sym_interface,
    anon_sym_union,
    anon_sym_enum,
    anon_sym_input,
    anon_sym_directive,
    [5537] = 6,
    ACTIONS(644),
    1,
    anon_sym_DOT_DOT_DOT,
    ACTIONS(646),
    1,
    sym_name,
    STATE(359),
    1,
    sym_alias,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(159),
    2,
    sym_selection,
    aux_sym_selection_set_repeat1,
    STATE(297),
    3,
    sym_field,
    sym_fragment_spread,
    sym_inline_fragment,
    [5560] = 3,
    ACTIONS(654),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(652),
    7,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_RBRACK,
    anon_sym_AT,
    sym_name,
    [5577] = 6,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(707),
    1,
    anon_sym_DQUOTE,
    STATE(254),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(705),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [5600] = 8,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(683),
    1,
    sym_name,
    ACTIONS(709),
    1,
    anon_sym_RBRACE,
    STATE(345),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(153),
    2,
    sym_input_value_definition,
    aux_sym_input_fields_definition_repeat1,
    [5627] = 8,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(660),
    1,
    sym_name,
    STATE(174),
    1,
    sym_enum_value,
    STATE(319),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(162),
    2,
    sym_enum_value_definition,
    aux_sym_enum_values_definition_repeat1,
    [5654] = 9,
    ACTIONS(711),
    1,
    anon_sym_schema,
    ACTIONS(713),
    1,
    anon_sym_scalar,
    ACTIONS(715),
    1,
    anon_sym_type,
    ACTIONS(717),
    1,
    anon_sym_interface,
    ACTIONS(719),
    1,
    anon_sym_union,
    ACTIONS(721),
    1,
    anon_sym_enum,
    ACTIONS(723),
    1,
    anon_sym_input,
    ACTIONS(725),
    1,
    anon_sym_directive,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [5683] = 3,
    ACTIONS(296),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(294),
    7,
    anon_sym_LBRACE,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_DOT_DOT_DOT,
    anon_sym_AT,
    sym_name,
    [5700] = 8,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(729),
    1,
    anon_sym_EQ,
    ACTIONS(731),
    1,
    anon_sym_AT,
    ACTIONS(733),
    1,
    sym_comma,
    STATE(207),
    1,
    sym_default_value,
    STATE(301),
    1,
    sym_directives,
    ACTIONS(727),
    2,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    STATE(238),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [5727] = 8,
    ACTIONS(735),
    1,
    anon_sym_RBRACE,
    ACTIONS(737),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(740),
    1,
    anon_sym_DQUOTE,
    ACTIONS(743),
    1,
    sym_name,
    STATE(329),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(185),
    2,
    sym_field_definition,
    aux_sym_fields_definition_repeat1,
    [5754] = 6,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(748),
    1,
    anon_sym_DQUOTE,
    STATE(278),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(746),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [5777] = 3,
    ACTIONS(300),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(298),
    7,
    anon_sym_LBRACE,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_DOT_DOT_DOT,
    anon_sym_AT,
    sym_name,
    [5794] = 3,
    ACTIONS(580),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(578),
    6,
    anon_sym_RBRACE,
    anon_sym_COLON,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [5810] = 7,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(687),
    1,
    sym_name,
    STATE(329),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(170),
    2,
    sym_field_definition,
    aux_sym_fields_definition_repeat1,
    [5834] = 5,
    ACTIONS(750),
    1,
    anon_sym_RBRACE,
    STATE(338),
    1,
    sym_operation_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(190),
    2,
    sym_root_operation_type_definition,
    aux_sym_schema_definition_repeat1,
    ACTIONS(752),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [5854] = 7,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(683),
    1,
    sym_name,
    STATE(345),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(169),
    2,
    sym_input_value_definition,
    aux_sym_input_fields_definition_repeat1,
    [5878] = 5,
    ACTIONS(755),
    1,
    anon_sym_RBRACE,
    STATE(338),
    1,
    sym_operation_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(190),
    2,
    sym_root_operation_type_definition,
    aux_sym_schema_definition_repeat1,
    ACTIONS(23),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [5898] = 5,
    ACTIONS(757),
    1,
    anon_sym_RBRACE,
    STATE(338),
    1,
    sym_operation_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(190),
    2,
    sym_root_operation_type_definition,
    aux_sym_schema_definition_repeat1,
    ACTIONS(23),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [5918] = 7,
    ACTIONS(310),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(312),
    1,
    anon_sym_DQUOTE,
    ACTIONS(683),
    1,
    sym_name,
    STATE(345),
    1,
    sym_description,
    STATE(361),
    1,
    sym_string_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(180),
    2,
    sym_input_value_definition,
    aux_sym_input_fields_definition_repeat1,
    [5942] = 6,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    STATE(247),
    1,
    sym_directive,
    STATE(291),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(759),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [5964] = 5,
    ACTIONS(761),
    1,
    anon_sym_RBRACE,
    STATE(338),
    1,
    sym_operation_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(190),
    2,
    sym_root_operation_type_definition,
    aux_sym_schema_definition_repeat1,
    ACTIONS(23),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [5984] = 5,
    ACTIONS(596),
    1,
    anon_sym_AT,
    STATE(290),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(152),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(763),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [6004] = 6,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    STATE(250),
    1,
    sym_directive,
    STATE(288),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(640),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [6026] = 8,
    ACTIONS(765),
    1,
    anon_sym_schema,
    ACTIONS(767),
    1,
    anon_sym_scalar,
    ACTIONS(769),
    1,
    anon_sym_type,
    ACTIONS(771),
    1,
    anon_sym_interface,
    ACTIONS(773),
    1,
    anon_sym_union,
    ACTIONS(775),
    1,
    anon_sym_enum,
    ACTIONS(777),
    1,
    anon_sym_input,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [6052] = 4,
    STATE(338),
    1,
    sym_operation_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(192),
    2,
    sym_root_operation_type_definition,
    aux_sym_schema_definition_repeat1,
    ACTIONS(23),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [6069] = 3,
    ACTIONS(568),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(566),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [6084] = 6,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    ACTIONS(596),
    1,
    anon_sym_AT,
    STATE(127),
    1,
    sym_selection_set,
    STATE(314),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [6105] = 4,
    STATE(338),
    1,
    sym_operation_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(193),
    2,
    sym_root_operation_type_definition,
    aux_sym_schema_definition_repeat1,
    ACTIONS(23),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [6122] = 6,
    ACTIONS(779),
    1,
    anon_sym_LBRACK,
    ACTIONS(781),
    1,
    sym_name,
    STATE(178),
    1,
    sym_non_null_type,
    STATE(372),
    1,
    sym_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(161),
    2,
    sym_named_type,
    sym_list_type,
    [6143] = 3,
    ACTIONS(584),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(582),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [6158] = 6,
    ACTIONS(779),
    1,
    anon_sym_LBRACK,
    ACTIONS(781),
    1,
    sym_name,
    STATE(178),
    1,
    sym_non_null_type,
    STATE(383),
    1,
    sym_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(161),
    2,
    sym_named_type,
    sym_list_type,
    [6179] = 6,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(731),
    1,
    anon_sym_AT,
    ACTIONS(785),
    1,
    sym_comma,
    STATE(308),
    1,
    sym_directives,
    ACTIONS(783),
    2,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    STATE(238),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [6200] = 6,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    ACTIONS(596),
    1,
    anon_sym_AT,
    STATE(132),
    1,
    sym_selection_set,
    STATE(313),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [6221] = 3,
    ACTIONS(588),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(586),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [6236] = 3,
    ACTIONS(560),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(558),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [6251] = 6,
    ACTIONS(779),
    1,
    anon_sym_LBRACK,
    ACTIONS(787),
    1,
    sym_name,
    STATE(178),
    1,
    sym_non_null_type,
    STATE(179),
    1,
    sym_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(161),
    2,
    sym_named_type,
    sym_list_type,
    [6272] = 4,
    STATE(338),
    1,
    sym_operation_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(196),
    2,
    sym_root_operation_type_definition,
    aux_sym_schema_definition_repeat1,
    ACTIONS(23),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [6289] = 3,
    ACTIONS(572),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(570),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [6304] = 3,
    ACTIONS(564),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(562),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [6319] = 6,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    STATE(289),
    1,
    sym_selection_set,
    STATE(315),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [6340] = 6,
    ACTIONS(779),
    1,
    anon_sym_LBRACK,
    ACTIONS(787),
    1,
    sym_name,
    STATE(148),
    1,
    sym_type,
    STATE(178),
    1,
    sym_non_null_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(161),
    2,
    sym_named_type,
    sym_list_type,
    [6361] = 6,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    ACTIONS(596),
    1,
    anon_sym_AT,
    STATE(124),
    1,
    sym_selection_set,
    STATE(304),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [6382] = 6,
    ACTIONS(779),
    1,
    anon_sym_LBRACK,
    ACTIONS(787),
    1,
    sym_name,
    STATE(147),
    1,
    sym_type,
    STATE(178),
    1,
    sym_non_null_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(161),
    2,
    sym_named_type,
    sym_list_type,
    [6403] = 3,
    ACTIONS(576),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(574),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [6418] = 6,
    ACTIONS(779),
    1,
    anon_sym_LBRACK,
    ACTIONS(787),
    1,
    sym_name,
    STATE(178),
    1,
    sym_non_null_type,
    STATE(186),
    1,
    sym_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(161),
    2,
    sym_named_type,
    sym_list_type,
    [6439] = 6,
    ACTIONS(779),
    1,
    anon_sym_LBRACK,
    ACTIONS(787),
    1,
    sym_name,
    STATE(171),
    1,
    sym_type,
    STATE(178),
    1,
    sym_non_null_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(161),
    2,
    sym_named_type,
    sym_list_type,
    [6460] = 6,
    ACTIONS(789),
    1,
    anon_sym_LBRACK,
    ACTIONS(791),
    1,
    sym_name,
    STATE(184),
    1,
    sym_type,
    STATE(260),
    1,
    sym_non_null_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(249),
    2,
    sym_named_type,
    sym_list_type,
    [6481] = 3,
    ACTIONS(795),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(793),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [6496] = 3,
    ACTIONS(556),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(554),
    5,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    anon_sym_AT,
    sym_name,
    [6511] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(562),
    6,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_name,
    sym_comma,
    [6523] = 4,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(797),
    1,
    anon_sym_AT,
    STATE(226),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(193),
    3,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    sym_comma,
    [6539] = 5,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(800),
    1,
    anon_sym_LBRACE,
    STATE(360),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [6557] = 5,
    ACTIONS(308),
    1,
    anon_sym_DOLLAR,
    ACTIONS(802),
    1,
    anon_sym_RPAREN,
    STATE(353),
    1,
    sym_variable,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(241),
    2,
    sym_variable_definition,
    aux_sym_variable_definitions_repeat1,
    [6575] = 4,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    STATE(288),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(640),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [6591] = 3,
    ACTIONS(664),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(662),
    4,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [6605] = 4,
    STATE(338),
    1,
    sym_operation_type,
    STATE(339),
    1,
    sym_root_operation_type_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(23),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [6621] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(554),
    6,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_name,
    sym_comma,
    [6633] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(558),
    6,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_name,
    sym_comma,
    [6645] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(566),
    6,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_name,
    sym_comma,
    [6657] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(570),
    6,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_name,
    sym_comma,
    [6669] = 3,
    ACTIONS(806),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(804),
    4,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [6683] = 5,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(808),
    1,
    anon_sym_LBRACE,
    STATE(351),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [6701] = 4,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(731),
    1,
    anon_sym_AT,
    STATE(226),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    ACTIONS(204),
    3,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    sym_comma,
    [6717] = 4,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(810),
    1,
    anon_sym_LPAREN,
    STATE(292),
    1,
    sym_arguments,
    ACTIONS(183),
    4,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_comma,
    [6733] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(648),
    6,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DOLLAR,
    anon_sym_AT,
    anon_sym_BANG,
    sym_comma,
    [6745] = 5,
    ACTIONS(812),
    1,
    anon_sym_RPAREN,
    ACTIONS(814),
    1,
    anon_sym_DOLLAR,
    STATE(353),
    1,
    sym_variable,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(241),
    2,
    sym_variable_definition,
    aux_sym_variable_definitions_repeat1,
    [6763] = 3,
    ACTIONS(594),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(590),
    4,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [6777] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(125),
    6,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DOLLAR,
    anon_sym_AT,
    anon_sym_BANG,
    sym_comma,
    [6789] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(578),
    6,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_name,
    sym_comma,
    [6801] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(586),
    6,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_name,
    sym_comma,
    [6813] = 5,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(817),
    1,
    anon_sym_LBRACE,
    STATE(328),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(256),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [6831] = 4,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    STATE(293),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(819),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [6847] = 4,
    STATE(338),
    1,
    sym_operation_type,
    STATE(379),
    1,
    sym_root_operation_type_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(23),
    3,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [6863] = 3,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(821),
    1,
    anon_sym_BANG,
    ACTIONS(652),
    5,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_comma,
    [6877] = 4,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    STATE(291),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(759),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [6893] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(582),
    6,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_name,
    sym_comma,
    [6905] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(823),
    5,
    anon_sym_LBRACE,
    anon_sym_COLON,
    anon_sym_LPAREN,
    anon_sym_AT,
    sym_name,
    [6917] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(574),
    6,
    anon_sym_RBRACE,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_name,
    sym_comma,
    [6929] = 3,
    ACTIONS(827),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(825),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [6942] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(829),
    4,
    anon_sym_RBRACE,
    anon_sym_query,
    anon_sym_mutation,
    anon_sym_subscription,
    [6953] = 4,
    ACTIONS(204),
    1,
    anon_sym_LBRACE,
    ACTIONS(596),
    1,
    anon_sym_AT,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(269),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [6968] = 4,
    ACTIONS(831),
    1,
    anon_sym_RBRACE,
    ACTIONS(833),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(277),
    2,
    sym_object_field,
    aux_sym_object_value_repeat1,
    [6983] = 4,
    ACTIONS(833),
    1,
    sym_name,
    ACTIONS(835),
    1,
    anon_sym_RBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(257),
    2,
    sym_object_field,
    aux_sym_object_value_repeat1,
    [6998] = 4,
    ACTIONS(837),
    1,
    anon_sym_RPAREN,
    ACTIONS(839),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(276),
    2,
    sym_argument,
    aux_sym_arguments_repeat1,
    [7013] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(652),
    5,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_comma,
    [7024] = 4,
    ACTIONS(833),
    1,
    sym_name,
    ACTIONS(841),
    1,
    anon_sym_RBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(277),
    2,
    sym_object_field,
    aux_sym_object_value_repeat1,
    [7039] = 4,
    ACTIONS(833),
    1,
    sym_name,
    ACTIONS(843),
    1,
    anon_sym_RBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(273),
    2,
    sym_object_field,
    aux_sym_object_value_repeat1,
    [7054] = 4,
    ACTIONS(833),
    1,
    sym_name,
    ACTIONS(845),
    1,
    anon_sym_RBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(261),
    2,
    sym_object_field,
    aux_sym_object_value_repeat1,
    [7069] = 4,
    ACTIONS(839),
    1,
    sym_name,
    ACTIONS(847),
    1,
    anon_sym_RPAREN,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(276),
    2,
    sym_argument,
    aux_sym_arguments_repeat1,
    [7084] = 4,
    ACTIONS(87),
    1,
    anon_sym_AT,
    STATE(120),
    1,
    sym_directives,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(36),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [7099] = 5,
    ACTIONS(849),
    1,
    anon_sym_LPAREN,
    ACTIONS(851),
    1,
    anon_sym_on,
    ACTIONS(853),
    1,
    anon_sym_repeatable,
    STATE(305),
    1,
    sym_arguments_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7116] = 4,
    ACTIONS(839),
    1,
    sym_name,
    ACTIONS(855),
    1,
    anon_sym_RPAREN,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(276),
    2,
    sym_argument,
    aux_sym_arguments_repeat1,
    [7131] = 3,
    ACTIONS(695),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(693),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [7144] = 4,
    ACTIONS(193),
    1,
    anon_sym_LBRACE,
    ACTIONS(625),
    1,
    anon_sym_AT,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(269),
    2,
    sym_directive,
    aux_sym_directives_repeat1,
    [7159] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(857),
    4,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    anon_sym_AT,
    sym_name,
    [7170] = 3,
    ACTIONS(861),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(859),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [7183] = 3,
    ACTIONS(707),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(705),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [7196] = 4,
    ACTIONS(833),
    1,
    sym_name,
    ACTIONS(863),
    1,
    anon_sym_RBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(277),
    2,
    sym_object_field,
    aux_sym_object_value_repeat1,
    [7211] = 5,
    ACTIONS(849),
    1,
    anon_sym_LPAREN,
    ACTIONS(865),
    1,
    anon_sym_on,
    ACTIONS(867),
    1,
    anon_sym_repeatable,
    STATE(322),
    1,
    sym_arguments_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7228] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(701),
    5,
    anon_sym_RPAREN,
    anon_sym_EQ,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_comma,
    [7239] = 4,
    ACTIONS(869),
    1,
    anon_sym_RPAREN,
    ACTIONS(871),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(276),
    2,
    sym_argument,
    aux_sym_arguments_repeat1,
    [7254] = 4,
    ACTIONS(874),
    1,
    anon_sym_RBRACE,
    ACTIONS(876),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(277),
    2,
    sym_object_field,
    aux_sym_object_value_repeat1,
    [7269] = 3,
    ACTIONS(691),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(689),
    3,
    anon_sym_RBRACE,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    sym_name,
    [7282] = 4,
    ACTIONS(308),
    1,
    anon_sym_DOLLAR,
    STATE(353),
    1,
    sym_variable,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(228),
    2,
    sym_variable_definition,
    aux_sym_variable_definitions_repeat1,
    [7297] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(640),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7307] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(294),
    4,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_comma,
    [7317] = 3,
    ACTIONS(839),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(259),
    2,
    sym_argument,
    aux_sym_arguments_repeat1,
    [7329] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(879),
    3,
    anon_sym_COLON,
    anon_sym_on,
    anon_sym_repeatable,
    [7339] = 4,
    ACTIONS(849),
    1,
    anon_sym_LPAREN,
    ACTIONS(881),
    1,
    anon_sym_COLON,
    STATE(337),
    1,
    sym_arguments_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7353] = 3,
    ACTIONS(839),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(264),
    2,
    sym_argument,
    aux_sym_arguments_repeat1,
    [7365] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(883),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7375] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(466),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7385] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(759),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7395] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(885),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7405] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(887),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7415] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(819),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7425] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(298),
    4,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_comma,
    [7435] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(889),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7445] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(891),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7455] = 4,
    ACTIONS(849),
    1,
    anon_sym_LPAREN,
    ACTIONS(893),
    1,
    anon_sym_COLON,
    STATE(341),
    1,
    sym_arguments_definition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7469] = 3,
    ACTIONS(839),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    STATE(267),
    2,
    sym_argument,
    aux_sym_arguments_repeat1,
    [7481] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(895),
    3,
    anon_sym_RBRACE,
    anon_sym_DOT_DOT_DOT,
    sym_name,
    [7491] = 4,
    ACTIONS(131),
    1,
    anon_sym_AMP,
    ACTIONS(781),
    1,
    sym_name,
    STATE(51),
    1,
    sym_named_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7505] = 4,
    ACTIONS(324),
    1,
    anon_sym_PIPE,
    ACTIONS(781),
    1,
    sym_name,
    STATE(57),
    1,
    sym_named_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7519] = 2,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(793),
    4,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    anon_sym_AT,
    sym_comma,
    [7529] = 3,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(785),
    1,
    sym_comma,
    ACTIONS(783),
    2,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    [7540] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(783),
    2,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    [7549] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(897),
    2,
    anon_sym_LBRACE,
    anon_sym_AT,
    [7558] = 3,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    STATE(127),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7569] = 3,
    ACTIONS(865),
    1,
    anon_sym_on,
    ACTIONS(867),
    1,
    anon_sym_repeatable,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7580] = 3,
    ACTIONS(781),
    1,
    sym_name,
    STATE(310),
    1,
    sym_named_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7591] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(899),
    2,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    [7600] = 3,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(901),
    1,
    sym_comma,
    ACTIONS(899),
    2,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    [7611] = 3,
    ACTIONS(781),
    1,
    sym_name,
    STATE(255),
    1,
    sym_named_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7622] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(903),
    2,
    anon_sym_LBRACE,
    anon_sym_AT,
    [7631] = 3,
    ACTIONS(905),
    1,
    anon_sym_on,
    STATE(208),
    1,
    sym_type_condition,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7642] = 3,
    ACTIONS(907),
    1,
    sym_name,
    STATE(311),
    1,
    sym_fragment_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7653] = 3,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    STATE(96),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7664] = 3,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    STATE(122),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7675] = 3,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    STATE(294),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7686] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(909),
    2,
    anon_sym_RPAREN,
    anon_sym_DOLLAR,
    [7695] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(911),
    2,
    anon_sym_RPAREN,
    sym_name,
    [7704] = 3,
    ACTIONS(3),
    1,
    sym_comment,
    ACTIONS(915),
    1,
    sym_comma,
    ACTIONS(913),
    2,
    anon_sym_RBRACE,
    sym_name,
    [7715] = 3,
    ACTIONS(660),
    1,
    sym_name,
    STATE(173),
    1,
    sym_enum_value,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7726] = 3,
    ACTIONS(781),
    1,
    sym_name,
    STATE(70),
    1,
    sym_named_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7737] = 2,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    ACTIONS(917),
    2,
    anon_sym_RBRACE,
    sym_name,
    [7746] = 3,
    ACTIONS(919),
    1,
    anon_sym_on,
    ACTIONS(921),
    1,
    anon_sym_repeatable,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7757] = 3,
    ACTIONS(7),
    1,
    anon_sym_LBRACE,
    STATE(124),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7768] = 3,
    ACTIONS(602),
    1,
    anon_sym_LBRACE,
    STATE(289),
    1,
    sym_selection_set,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7779] = 3,
    ACTIONS(781),
    1,
    sym_name,
    STATE(46),
    1,
    sym_named_type,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7790] = 2,
    ACTIONS(923),
    1,
    anon_sym_AT,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7798] = 2,
    ACTIONS(925),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7806] = 2,
    ACTIONS(808),
    1,
    anon_sym_LBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7814] = 2,
    ACTIONS(927),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7822] = 2,
    ACTIONS(929),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7830] = 2,
    ACTIONS(931),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7838] = 2,
    ACTIONS(933),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7846] = 2,
    ACTIONS(935),
    1,
    aux_sym_string_value_token1,
    ACTIONS(937),
    2,
    sym_comment,
    sym_comma,
    [7854] = 2,
    ACTIONS(939),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7862] = 2,
    ACTIONS(941),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7870] = 2,
    ACTIONS(943),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7878] = 2,
    ACTIONS(893),
    1,
    anon_sym_COLON,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7886] = 2,
    ACTIONS(945),
    1,
    anon_sym_COLON,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7894] = 2,
    ACTIONS(947),
    1,
    anon_sym_RBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7902] = 2,
    ACTIONS(949),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7910] = 2,
    ACTIONS(951),
    1,
    anon_sym_COLON,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7918] = 2,
    ACTIONS(953),
    1,
    anon_sym_COLON,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7926] = 2,
    ACTIONS(955),
    1,
    aux_sym_string_value_token2,
    ACTIONS(937),
    2,
    sym_comment,
    sym_comma,
    [7934] = 2,
    ACTIONS(957),
    1,
    anon_sym_COLON,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7942] = 2,
    ACTIONS(959),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7950] = 2,
    ACTIONS(865),
    1,
    anon_sym_on,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7958] = 2,
    ACTIONS(961),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7966] = 2,
    ACTIONS(963),
    1,
    anon_sym_AT,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7974] = 2,
    ACTIONS(965),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7982] = 2,
    ACTIONS(967),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7990] = 2,
    ACTIONS(969),
    1,
    anon_sym_LBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [7998] = 2,
    ACTIONS(971),
    1,
    ts_builtin_sym_end,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8006] = 2,
    ACTIONS(973),
    1,
    anon_sym_COLON,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8014] = 2,
    ACTIONS(975),
    1,
    ts_builtin_sym_end,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8022] = 2,
    ACTIONS(977),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8030] = 2,
    ACTIONS(979),
    1,
    anon_sym_COLON,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8038] = 2,
    ACTIONS(981),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8046] = 2,
    ACTIONS(857),
    1,
    anon_sym_on,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8054] = 2,
    ACTIONS(983),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8062] = 2,
    ACTIONS(985),
    1,
    anon_sym_LBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8070] = 2,
    ACTIONS(679),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8078] = 2,
    ACTIONS(987),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8086] = 2,
    ACTIONS(989),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8094] = 2,
    ACTIONS(925),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8102] = 2,
    ACTIONS(991),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8110] = 2,
    ACTIONS(991),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8118] = 2,
    ACTIONS(993),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8126] = 2,
    ACTIONS(995),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8134] = 2,
    ACTIONS(997),
    1,
    anon_sym_COLON,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8142] = 2,
    ACTIONS(999),
    1,
    anon_sym_on,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8150] = 2,
    ACTIONS(1001),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8158] = 2,
    ACTIONS(1003),
    1,
    anon_sym_RBRACK,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8166] = 2,
    ACTIONS(1005),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8174] = 2,
    ACTIONS(1007),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8182] = 2,
    ACTIONS(1009),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8190] = 2,
    ACTIONS(1011),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8198] = 2,
    ACTIONS(1011),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8206] = 2,
    ACTIONS(1013),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8214] = 2,
    ACTIONS(1015),
    1,
    anon_sym_RBRACE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8222] = 2,
    ACTIONS(919),
    1,
    anon_sym_on,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8230] = 2,
    ACTIONS(1017),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8238] = 2,
    ACTIONS(1019),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8246] = 2,
    ACTIONS(1021),
    1,
    anon_sym_RBRACK,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8254] = 2,
    ACTIONS(1023),
    1,
    anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8262] = 2,
    ACTIONS(1023),
    1,
    anon_sym_DQUOTE,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8270] = 2,
    ACTIONS(1025),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8278] = 2,
    ACTIONS(1027),
    1,
    aux_sym_string_value_token1,
    ACTIONS(937),
    2,
    sym_comment,
    sym_comma,
    [8286] = 2,
    ACTIONS(1029),
    1,
    aux_sym_string_value_token2,
    ACTIONS(937),
    2,
    sym_comment,
    sym_comma,
    [8294] = 2,
    ACTIONS(1031),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8302] = 2,
    ACTIONS(1033),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8310] = 2,
    ACTIONS(1035),
    1,
    aux_sym_string_value_token1,
    ACTIONS(937),
    2,
    sym_comment,
    sym_comma,
    [8318] = 2,
    ACTIONS(1037),
    1,
    aux_sym_string_value_token2,
    ACTIONS(937),
    2,
    sym_comment,
    sym_comma,
    [8326] = 2,
    ACTIONS(1039),
    1,
    sym_name,
    ACTIONS(3),
    2,
    sym_comment,
    sym_comma,
    [8334] = 2,
    ACTIONS(1041),
    1,
    aux_sym_string_value_token1,
    ACTIONS(937),
    2,
    sym_comment,
    sym_comma,
    [8342] = 2,
    ACTIONS(1043),
    1,
    aux_sym_string_value_token2,
    ACTIONS(937),
    2,
    sym_comment,
    sym_comma,
};

static uint32_t ts_small_parse_table_map[] = {
    [SMALL_STATE(2)] = 0,
    [SMALL_STATE(3)] = 102,
    [SMALL_STATE(4)] = 204,
    [SMALL_STATE(5)] = 251,
    [SMALL_STATE(6)] = 296,
    [SMALL_STATE(7)] = 343,
    [SMALL_STATE(8)] = 388,
    [SMALL_STATE(9)] = 435,
    [SMALL_STATE(10)] = 482,
    [SMALL_STATE(11)] = 527,
    [SMALL_STATE(12)] = 574,
    [SMALL_STATE(13)] = 619,
    [SMALL_STATE(14)] = 666,
    [SMALL_STATE(15)] = 708,
    [SMALL_STATE(16)] = 740,
    [SMALL_STATE(17)] = 784,
    [SMALL_STATE(18)] = 828,
    [SMALL_STATE(19)] = 872,
    [SMALL_STATE(20)] = 914,
    [SMALL_STATE(21)] = 958,
    [SMALL_STATE(22)] = 1002,
    [SMALL_STATE(23)] = 1044,
    [SMALL_STATE(24)] = 1086,
    [SMALL_STATE(25)] = 1130,
    [SMALL_STATE(26)] = 1171,
    [SMALL_STATE(27)] = 1212,
    [SMALL_STATE(28)] = 1251,
    [SMALL_STATE(29)] = 1292,
    [SMALL_STATE(30)] = 1331,
    [SMALL_STATE(31)] = 1372,
    [SMALL_STATE(32)] = 1413,
    [SMALL_STATE(33)] = 1447,
    [SMALL_STATE(34)] = 1483,
    [SMALL_STATE(35)] = 1517,
    [SMALL_STATE(36)] = 1553,
    [SMALL_STATE(37)] = 1587,
    [SMALL_STATE(38)] = 1636,
    [SMALL_STATE(39)] = 1685,
    [SMALL_STATE(40)] = 1734,
    [SMALL_STATE(41)] = 1783,
    [SMALL_STATE(42)] = 1832,
    [SMALL_STATE(43)] = 1881,
    [SMALL_STATE(44)] = 1930,
    [SMALL_STATE(45)] = 1962,
    [SMALL_STATE(46)] = 1994,
    [SMALL_STATE(47)] = 2022,
    [SMALL_STATE(48)] = 2054,
    [SMALL_STATE(49)] = 2086,
    [SMALL_STATE(50)] = 2118,
    [SMALL_STATE(51)] = 2150,
    [SMALL_STATE(52)] = 2178,
    [SMALL_STATE(53)] = 2206,
    [SMALL_STATE(54)] = 2234,
    [SMALL_STATE(55)] = 2266,
    [SMALL_STATE(56)] = 2311,
    [SMALL_STATE(57)] = 2340,
    [SMALL_STATE(58)] = 2367,
    [SMALL_STATE(59)] = 2398,
    [SMALL_STATE(60)] = 2429,
    [SMALL_STATE(61)] = 2460,
    [SMALL_STATE(62)] = 2505,
    [SMALL_STATE(63)] = 2536,
    [SMALL_STATE(64)] = 2567,
    [SMALL_STATE(65)] = 2598,
    [SMALL_STATE(66)] = 2627,
    [SMALL_STATE(67)] = 2658,
    [SMALL_STATE(68)] = 2689,
    [SMALL_STATE(69)] = 2720,
    [SMALL_STATE(70)] = 2749,
    [SMALL_STATE(71)] = 2776,
    [SMALL_STATE(72)] = 2803,
    [SMALL_STATE(73)] = 2830,
    [SMALL_STATE(74)] = 2859,
    [SMALL_STATE(75)] = 2886,
    [SMALL_STATE(76)] = 2913,
    [SMALL_STATE(77)] = 2944,
    [SMALL_STATE(78)] = 2975,
    [SMALL_STATE(79)] = 3006,
    [SMALL_STATE(80)] = 3035,
    [SMALL_STATE(81)] = 3062,
    [SMALL_STATE(82)] = 3093,
    [SMALL_STATE(83)] = 3122,
    [SMALL_STATE(84)] = 3167,
    [SMALL_STATE(85)] = 3198,
    [SMALL_STATE(86)] = 3225,
    [SMALL_STATE(87)] = 3254,
    [SMALL_STATE(88)] = 3283,
    [SMALL_STATE(89)] = 3328,
    [SMALL_STATE(90)] = 3357,
    [SMALL_STATE(91)] = 3388,
    [SMALL_STATE(92)] = 3414,
    [SMALL_STATE(93)] = 3440,
    [SMALL_STATE(94)] = 3466,
    [SMALL_STATE(95)] = 3492,
    [SMALL_STATE(96)] = 3518,
    [SMALL_STATE(97)] = 3544,
    [SMALL_STATE(98)] = 3570,
    [SMALL_STATE(99)] = 3596,
    [SMALL_STATE(100)] = 3622,
    [SMALL_STATE(101)] = 3648,
    [SMALL_STATE(102)] = 3674,
    [SMALL_STATE(103)] = 3700,
    [SMALL_STATE(104)] = 3726,
    [SMALL_STATE(105)] = 3752,
    [SMALL_STATE(106)] = 3778,
    [SMALL_STATE(107)] = 3804,
    [SMALL_STATE(108)] = 3830,
    [SMALL_STATE(109)] = 3856,
    [SMALL_STATE(110)] = 3882,
    [SMALL_STATE(111)] = 3908,
    [SMALL_STATE(112)] = 3934,
    [SMALL_STATE(113)] = 3960,
    [SMALL_STATE(114)] = 3986,
    [SMALL_STATE(115)] = 4012,
    [SMALL_STATE(116)] = 4038,
    [SMALL_STATE(117)] = 4064,
    [SMALL_STATE(118)] = 4090,
    [SMALL_STATE(119)] = 4116,
    [SMALL_STATE(120)] = 4142,
    [SMALL_STATE(121)] = 4168,
    [SMALL_STATE(122)] = 4194,
    [SMALL_STATE(123)] = 4220,
    [SMALL_STATE(124)] = 4246,
    [SMALL_STATE(125)] = 4272,
    [SMALL_STATE(126)] = 4298,
    [SMALL_STATE(127)] = 4324,
    [SMALL_STATE(128)] = 4350,
    [SMALL_STATE(129)] = 4376,
    [SMALL_STATE(130)] = 4402,
    [SMALL_STATE(131)] = 4428,
    [SMALL_STATE(132)] = 4454,
    [SMALL_STATE(133)] = 4480,
    [SMALL_STATE(134)] = 4506,
    [SMALL_STATE(135)] = 4532,
    [SMALL_STATE(136)] = 4558,
    [SMALL_STATE(137)] = 4584,
    [SMALL_STATE(138)] = 4610,
    [SMALL_STATE(139)] = 4631,
    [SMALL_STATE(140)] = 4652,
    [SMALL_STATE(141)] = 4673,
    [SMALL_STATE(142)] = 4694,
    [SMALL_STATE(143)] = 4715,
    [SMALL_STATE(144)] = 4736,
    [SMALL_STATE(145)] = 4757,
    [SMALL_STATE(146)] = 4778,
    [SMALL_STATE(147)] = 4799,
    [SMALL_STATE(148)] = 4829,
    [SMALL_STATE(149)] = 4859,
    [SMALL_STATE(150)] = 4892,
    [SMALL_STATE(151)] = 4923,
    [SMALL_STATE(152)] = 4946,
    [SMALL_STATE(153)] = 4968,
    [SMALL_STATE(154)] = 4996,
    [SMALL_STATE(155)] = 5020,
    [SMALL_STATE(156)] = 5042,
    [SMALL_STATE(157)] = 5072,
    [SMALL_STATE(158)] = 5098,
    [SMALL_STATE(159)] = 5126,
    [SMALL_STATE(160)] = 5152,
    [SMALL_STATE(161)] = 5170,
    [SMALL_STATE(162)] = 5190,
    [SMALL_STATE(163)] = 5220,
    [SMALL_STATE(164)] = 5244,
    [SMALL_STATE(165)] = 5274,
    [SMALL_STATE(166)] = 5300,
    [SMALL_STATE(167)] = 5315,
    [SMALL_STATE(168)] = 5338,
    [SMALL_STATE(169)] = 5355,
    [SMALL_STATE(170)] = 5382,
    [SMALL_STATE(171)] = 5409,
    [SMALL_STATE(172)] = 5432,
    [SMALL_STATE(173)] = 5459,
    [SMALL_STATE(174)] = 5482,
    [SMALL_STATE(175)] = 5505,
    [SMALL_STATE(176)] = 5522,
    [SMALL_STATE(177)] = 5537,
    [SMALL_STATE(178)] = 5560,
    [SMALL_STATE(179)] = 5577,
    [SMALL_STATE(180)] = 5600,
    [SMALL_STATE(181)] = 5627,
    [SMALL_STATE(182)] = 5654,
    [SMALL_STATE(183)] = 5683,
    [SMALL_STATE(184)] = 5700,
    [SMALL_STATE(185)] = 5727,
    [SMALL_STATE(186)] = 5754,
    [SMALL_STATE(187)] = 5777,
    [SMALL_STATE(188)] = 5794,
    [SMALL_STATE(189)] = 5810,
    [SMALL_STATE(190)] = 5834,
    [SMALL_STATE(191)] = 5854,
    [SMALL_STATE(192)] = 5878,
    [SMALL_STATE(193)] = 5898,
    [SMALL_STATE(194)] = 5918,
    [SMALL_STATE(195)] = 5942,
    [SMALL_STATE(196)] = 5964,
    [SMALL_STATE(197)] = 5984,
    [SMALL_STATE(198)] = 6004,
    [SMALL_STATE(199)] = 6026,
    [SMALL_STATE(200)] = 6052,
    [SMALL_STATE(201)] = 6069,
    [SMALL_STATE(202)] = 6084,
    [SMALL_STATE(203)] = 6105,
    [SMALL_STATE(204)] = 6122,
    [SMALL_STATE(205)] = 6143,
    [SMALL_STATE(206)] = 6158,
    [SMALL_STATE(207)] = 6179,
    [SMALL_STATE(208)] = 6200,
    [SMALL_STATE(209)] = 6221,
    [SMALL_STATE(210)] = 6236,
    [SMALL_STATE(211)] = 6251,
    [SMALL_STATE(212)] = 6272,
    [SMALL_STATE(213)] = 6289,
    [SMALL_STATE(214)] = 6304,
    [SMALL_STATE(215)] = 6319,
    [SMALL_STATE(216)] = 6340,
    [SMALL_STATE(217)] = 6361,
    [SMALL_STATE(218)] = 6382,
    [SMALL_STATE(219)] = 6403,
    [SMALL_STATE(220)] = 6418,
    [SMALL_STATE(221)] = 6439,
    [SMALL_STATE(222)] = 6460,
    [SMALL_STATE(223)] = 6481,
    [SMALL_STATE(224)] = 6496,
    [SMALL_STATE(225)] = 6511,
    [SMALL_STATE(226)] = 6523,
    [SMALL_STATE(227)] = 6539,
    [SMALL_STATE(228)] = 6557,
    [SMALL_STATE(229)] = 6575,
    [SMALL_STATE(230)] = 6591,
    [SMALL_STATE(231)] = 6605,
    [SMALL_STATE(232)] = 6621,
    [SMALL_STATE(233)] = 6633,
    [SMALL_STATE(234)] = 6645,
    [SMALL_STATE(235)] = 6657,
    [SMALL_STATE(236)] = 6669,
    [SMALL_STATE(237)] = 6683,
    [SMALL_STATE(238)] = 6701,
    [SMALL_STATE(239)] = 6717,
    [SMALL_STATE(240)] = 6733,
    [SMALL_STATE(241)] = 6745,
    [SMALL_STATE(242)] = 6763,
    [SMALL_STATE(243)] = 6777,
    [SMALL_STATE(244)] = 6789,
    [SMALL_STATE(245)] = 6801,
    [SMALL_STATE(246)] = 6813,
    [SMALL_STATE(247)] = 6831,
    [SMALL_STATE(248)] = 6847,
    [SMALL_STATE(249)] = 6863,
    [SMALL_STATE(250)] = 6877,
    [SMALL_STATE(251)] = 6893,
    [SMALL_STATE(252)] = 6905,
    [SMALL_STATE(253)] = 6917,
    [SMALL_STATE(254)] = 6929,
    [SMALL_STATE(255)] = 6942,
    [SMALL_STATE(256)] = 6953,
    [SMALL_STATE(257)] = 6968,
    [SMALL_STATE(258)] = 6983,
    [SMALL_STATE(259)] = 6998,
    [SMALL_STATE(260)] = 7013,
    [SMALL_STATE(261)] = 7024,
    [SMALL_STATE(262)] = 7039,
    [SMALL_STATE(263)] = 7054,
    [SMALL_STATE(264)] = 7069,
    [SMALL_STATE(265)] = 7084,
    [SMALL_STATE(266)] = 7099,
    [SMALL_STATE(267)] = 7116,
    [SMALL_STATE(268)] = 7131,
    [SMALL_STATE(269)] = 7144,
    [SMALL_STATE(270)] = 7159,
    [SMALL_STATE(271)] = 7170,
    [SMALL_STATE(272)] = 7183,
    [SMALL_STATE(273)] = 7196,
    [SMALL_STATE(274)] = 7211,
    [SMALL_STATE(275)] = 7228,
    [SMALL_STATE(276)] = 7239,
    [SMALL_STATE(277)] = 7254,
    [SMALL_STATE(278)] = 7269,
    [SMALL_STATE(279)] = 7282,
    [SMALL_STATE(280)] = 7297,
    [SMALL_STATE(281)] = 7307,
    [SMALL_STATE(282)] = 7317,
    [SMALL_STATE(283)] = 7329,
    [SMALL_STATE(284)] = 7339,
    [SMALL_STATE(285)] = 7353,
    [SMALL_STATE(286)] = 7365,
    [SMALL_STATE(287)] = 7375,
    [SMALL_STATE(288)] = 7385,
    [SMALL_STATE(289)] = 7395,
    [SMALL_STATE(290)] = 7405,
    [SMALL_STATE(291)] = 7415,
    [SMALL_STATE(292)] = 7425,
    [SMALL_STATE(293)] = 7435,
    [SMALL_STATE(294)] = 7445,
    [SMALL_STATE(295)] = 7455,
    [SMALL_STATE(296)] = 7469,
    [SMALL_STATE(297)] = 7481,
    [SMALL_STATE(298)] = 7491,
    [SMALL_STATE(299)] = 7505,
    [SMALL_STATE(300)] = 7519,
    [SMALL_STATE(301)] = 7529,
    [SMALL_STATE(302)] = 7540,
    [SMALL_STATE(303)] = 7549,
    [SMALL_STATE(304)] = 7558,
    [SMALL_STATE(305)] = 7569,
    [SMALL_STATE(306)] = 7580,
    [SMALL_STATE(307)] = 7591,
    [SMALL_STATE(308)] = 7600,
    [SMALL_STATE(309)] = 7611,
    [SMALL_STATE(310)] = 7622,
    [SMALL_STATE(311)] = 7631,
    [SMALL_STATE(312)] = 7642,
    [SMALL_STATE(313)] = 7653,
    [SMALL_STATE(314)] = 7664,
    [SMALL_STATE(315)] = 7675,
    [SMALL_STATE(316)] = 7686,
    [SMALL_STATE(317)] = 7695,
    [SMALL_STATE(318)] = 7704,
    [SMALL_STATE(319)] = 7715,
    [SMALL_STATE(320)] = 7726,
    [SMALL_STATE(321)] = 7737,
    [SMALL_STATE(322)] = 7746,
    [SMALL_STATE(323)] = 7757,
    [SMALL_STATE(324)] = 7768,
    [SMALL_STATE(325)] = 7779,
    [SMALL_STATE(326)] = 7790,
    [SMALL_STATE(327)] = 7798,
    [SMALL_STATE(328)] = 7806,
    [SMALL_STATE(329)] = 7814,
    [SMALL_STATE(330)] = 7822,
    [SMALL_STATE(331)] = 7830,
    [SMALL_STATE(332)] = 7838,
    [SMALL_STATE(333)] = 7846,
    [SMALL_STATE(334)] = 7854,
    [SMALL_STATE(335)] = 7862,
    [SMALL_STATE(336)] = 7870,
    [SMALL_STATE(337)] = 7878,
    [SMALL_STATE(338)] = 7886,
    [SMALL_STATE(339)] = 7894,
    [SMALL_STATE(340)] = 7902,
    [SMALL_STATE(341)] = 7910,
    [SMALL_STATE(342)] = 7918,
    [SMALL_STATE(343)] = 7926,
    [SMALL_STATE(344)] = 7934,
    [SMALL_STATE(345)] = 7942,
    [SMALL_STATE(346)] = 7950,
    [SMALL_STATE(347)] = 7958,
    [SMALL_STATE(348)] = 7966,
    [SMALL_STATE(349)] = 7974,
    [SMALL_STATE(350)] = 7982,
    [SMALL_STATE(351)] = 7990,
    [SMALL_STATE(352)] = 7998,
    [SMALL_STATE(353)] = 8006,
    [SMALL_STATE(354)] = 8014,
    [SMALL_STATE(355)] = 8022,
    [SMALL_STATE(356)] = 8030,
    [SMALL_STATE(357)] = 8038,
    [SMALL_STATE(358)] = 8046,
    [SMALL_STATE(359)] = 8054,
    [SMALL_STATE(360)] = 8062,
    [SMALL_STATE(361)] = 8070,
    [SMALL_STATE(362)] = 8078,
    [SMALL_STATE(363)] = 8086,
    [SMALL_STATE(364)] = 8094,
    [SMALL_STATE(365)] = 8102,
    [SMALL_STATE(366)] = 8110,
    [SMALL_STATE(367)] = 8118,
    [SMALL_STATE(368)] = 8126,
    [SMALL_STATE(369)] = 8134,
    [SMALL_STATE(370)] = 8142,
    [SMALL_STATE(371)] = 8150,
    [SMALL_STATE(372)] = 8158,
    [SMALL_STATE(373)] = 8166,
    [SMALL_STATE(374)] = 8174,
    [SMALL_STATE(375)] = 8182,
    [SMALL_STATE(376)] = 8190,
    [SMALL_STATE(377)] = 8198,
    [SMALL_STATE(378)] = 8206,
    [SMALL_STATE(379)] = 8214,
    [SMALL_STATE(380)] = 8222,
    [SMALL_STATE(381)] = 8230,
    [SMALL_STATE(382)] = 8238,
    [SMALL_STATE(383)] = 8246,
    [SMALL_STATE(384)] = 8254,
    [SMALL_STATE(385)] = 8262,
    [SMALL_STATE(386)] = 8270,
    [SMALL_STATE(387)] = 8278,
    [SMALL_STATE(388)] = 8286,
    [SMALL_STATE(389)] = 8294,
    [SMALL_STATE(390)] = 8302,
    [SMALL_STATE(391)] = 8310,
    [SMALL_STATE(392)] = 8318,
    [SMALL_STATE(393)] = 8326,
    [SMALL_STATE(394)] = 8334,
    [SMALL_STATE(395)] = 8342,
};

static TSParseActionEntry ts_parse_actions[] = {
    [0] = {.entry = {.count = 0, .reusable = false}},
    [1] = {.entry = {.count = 1, .reusable = false}},
    RECOVER(),
    [3] = {.entry = {.count = 1, .reusable = true}},
    SHIFT_EXTRA(),
    [5] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(246),
    [7] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(177),
    [9] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(199),
    [11] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(374),
    [13] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(371),
    [15] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(367),
    [17] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(363),
    [19] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(350),
    [21] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(347),
    [23] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(252),
    [25] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(333),
    [27] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(343),
    [29] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(312),
    [31] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(348),
    [33] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_document, 1),
    [35] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    [37] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(246),
    [40] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(177),
    [43] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(199),
    [46] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(374),
    [49] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(371),
    [52] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(367),
    [55] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(363),
    [58] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(350),
    [61] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(347),
    [64] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(252),
    [67] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(333),
    [70] = {.entry = {.count = 2, .reusable = false}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(343),
    [73] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(312),
    [76] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_document_repeat1, 2),
    SHIFT_REPEAT(348),
    [79] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_type_definition, 2),
    [81] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(189),
    [83] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(298),
    [85] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_type_definition, 2),
    [87] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(362),
    [89] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(29),
    [91] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(71),
    [93] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(71),
    [95] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(72),
    [97] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(72),
    [99] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_interface_type_extension, 3),
    [101] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_interface_type_extension, 3),
    [103] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_type_definition, 3),
    [105] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_type_definition, 3),
    [107] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_type_extension, 3),
    [109] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_type_extension, 3),
    [111] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_interface_type_definition, 3),
    [113] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_interface_type_definition, 3),
    [115] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_interface_type_definition, 2),
    [117] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_interface_type_definition, 2),
    [119] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_union_type_definition, 3),
    [121] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(299),
    [123] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_union_type_definition, 3),
    [125] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_named_type, 1),
    [127] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_named_type, 1),
    [129] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_type_definition, 4),
    [131] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(325),
    [133] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_type_definition, 4),
    [135] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_type_extension, 4),
    [137] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_type_extension, 4),
    [139] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_union_type_definition, 2),
    [141] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_union_type_definition, 2),
    [143] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_interface_type_extension, 4),
    [145] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_interface_type_extension, 4),
    [147] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_object_type_extension, 3),
    [149] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(194),
    [151] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_object_type_extension, 3),
    [153] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_union_type_extension, 3),
    [155] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_union_type_extension, 3),
    [157] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_interface_type_definition, 4),
    [159] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_interface_type_definition, 4),
    [161] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_type_definition, 3),
    [163] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(181),
    [165] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_type_definition, 3),
    [167] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_object_type_definition, 3),
    [169] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_object_type_definition, 3),
    [171] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_type_definition, 2),
    [173] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_type_definition, 2),
    [175] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_object_type_definition, 2),
    [177] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_object_type_definition, 2),
    [179] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_type_extension, 3),
    [181] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_type_extension, 3),
    [183] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive, 2),
    [185] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(285),
    [187] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive, 2),
    [189] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_scalar_type_definition, 3),
    [191] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_scalar_type_definition, 3),
    [193] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_directives_repeat1, 2),
    [195] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(aux_sym_directives_repeat1, 2),
    [197] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_directives_repeat1, 2),
    SHIFT_REPEAT(362),
    [200] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_scalar_type_definition, 2),
    [202] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_scalar_type_definition, 2),
    [204] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directives, 1),
    [206] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directives, 1),
    [208] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    SHIFT_REPEAT(263),
    [211] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    SHIFT_REPEAT(368),
    [214] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    SHIFT_REPEAT(391),
    [217] = {.entry = {.count = 2, .reusable = false}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    SHIFT_REPEAT(392),
    [220] = {.entry = {.count = 2, .reusable = false}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    SHIFT_REPEAT(145),
    [223] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    SHIFT_REPEAT(145),
    [226] = {.entry = {.count = 2, .reusable = false}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    SHIFT_REPEAT(146),
    [229] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    SHIFT_REPEAT(41),
    [232] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    [234] = {.entry = {.count = 2, .reusable = false}},
    REDUCE(aux_sym_list_value_repeat1, 2),
    SHIFT_REPEAT(143),
    [237] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(263),
    [239] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(368),
    [241] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(391),
    [243] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(392),
    [245] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(145),
    [247] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(145),
    [249] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(146),
    [251] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(41),
    [253] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(234),
    [255] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(143),
    [257] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(210),
    [259] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(201),
    [261] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(139),
    [263] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(141),
    [265] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(233),
    [267] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_input_object_type_extension_repeat1, 2),
    [269] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_input_object_type_extension_repeat1, 2),
    SHIFT_REPEAT(194),
    [272] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(aux_sym_input_object_type_extension_repeat1, 2),
    [274] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_object_type_extension, 5),
    [276] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_object_type_extension, 5),
    [278] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_implements_interfaces, 3),
    [280] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_implements_interfaces, 3),
    [282] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_union_type_extension, 4),
    [284] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_union_type_extension, 4),
    [286] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_object_type_extension, 4),
    [288] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_object_type_extension, 4),
    [290] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_implements_interfaces, 2),
    [292] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_implements_interfaces, 2),
    [294] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_arguments, 3),
    [296] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_arguments, 3),
    [298] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive, 3),
    [300] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive, 3),
    [302] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_union_type_definition, 4),
    [304] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_union_type_definition, 4),
    [306] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(262),
    [308] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(355),
    [310] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(387),
    [312] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(388),
    [314] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(205),
    [316] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(205),
    [318] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(209),
    [320] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(39),
    [322] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(219),
    [324] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(320),
    [326] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_union_member_types, 2),
    [328] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_union_member_types, 2),
    [330] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_type_definition, 4),
    [332] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_type_definition, 4),
    [334] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_object_type_definition, 4),
    [336] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_object_type_definition, 4),
    [338] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_type_extension, 4),
    [340] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_type_extension, 4),
    [342] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_type_extension, 5),
    [344] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_type_extension, 5),
    [346] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_interface_type_extension, 5),
    [348] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_interface_type_extension, 5),
    [350] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_union_type_extension, 5),
    [352] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_union_type_extension, 5),
    [354] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_union_member_types, 3),
    [356] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_union_member_types, 3),
    [358] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_executable_directive_location, 1),
    [360] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_executable_directive_location, 1),
    [362] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_type_system_directive_location, 1),
    [364] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_type_system_directive_location, 1),
    [366] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive_definition, 5),
    [368] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(27),
    [370] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive_definition, 5),
    [372] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive_locations, 1),
    [374] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive_locations, 1),
    [376] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive_location, 1),
    [378] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive_location, 1),
    [380] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_type_definition, 5),
    [382] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_type_definition, 5),
    [384] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_interface_type_definition, 5),
    [386] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_interface_type_definition, 5),
    [388] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_union_type_definition, 5),
    [390] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_union_type_definition, 5),
    [392] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive_locations, 2),
    [394] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive_locations, 2),
    [396] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive_definition, 6),
    [398] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive_definition, 6),
    [400] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(258),
    [402] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(378),
    [404] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(394),
    [406] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(395),
    [408] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(251),
    [410] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(251),
    [412] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(245),
    [414] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(43),
    [416] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(253),
    [418] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive_locations, 3),
    [420] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive_locations, 3),
    [422] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive_definition, 7),
    [424] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive_definition, 7),
    [426] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_directive_definition, 8),
    [428] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_directive_definition, 8),
    [430] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_interface_type_definition, 6),
    [432] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_interface_type_definition, 6),
    [434] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_object_type_definition, 5),
    [436] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_object_type_definition, 5),
    [438] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_type_definition, 5),
    [440] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_type_definition, 5),
    [442] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_schema_extension, 6),
    [444] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_schema_extension, 6),
    [446] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_fragment_definition, 5),
    [448] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_fragment_definition, 5),
    [450] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_fields_definition, 3),
    [452] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_fields_definition, 3),
    [454] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_type_extension, 6),
    [456] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_type_extension, 6),
    [458] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_values_definition, 3),
    [460] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_values_definition, 3),
    [462] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_interface_type_extension, 6),
    [464] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_interface_type_extension, 6),
    [466] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_selection_set, 3),
    [468] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_selection_set, 3),
    [470] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_fields_definition, 3),
    [472] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_fields_definition, 3),
    [474] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_type_extension, 5),
    [476] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_type_extension, 5),
    [478] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_type_definition, 1),
    [480] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_type_definition, 1),
    [482] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_executable_definition, 1),
    [484] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_executable_definition, 1),
    [486] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_type_extension, 1),
    [488] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_type_extension, 1),
    [490] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_schema_extension, 5),
    [492] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_schema_extension, 5),
    [494] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_type_system_extension, 1),
    [496] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_type_system_extension, 1),
    [498] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_schema_definition, 6),
    [500] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_schema_definition, 6),
    [502] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_type_definition, 6),
    [504] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_type_definition, 6),
    [506] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_scalar_type_extension, 4),
    [508] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_scalar_type_extension, 4),
    [510] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_schema_definition, 5),
    [512] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_schema_definition, 5),
    [514] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_operation_definition, 5),
    [516] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_operation_definition, 5),
    [518] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_type_system_definition, 1),
    [520] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_type_system_definition, 1),
    [522] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_operation_definition, 3),
    [524] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_operation_definition, 3),
    [526] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_scalar_type_definition, 4),
    [528] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_scalar_type_definition, 4),
    [530] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_operation_definition, 4),
    [532] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_operation_definition, 4),
    [534] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_operation_definition, 2),
    [536] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_operation_definition, 2),
    [538] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_schema_definition, 4),
    [540] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_schema_definition, 4),
    [542] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_definition, 1),
    [544] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_definition, 1),
    [546] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_fragment_definition, 4),
    [548] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_fragment_definition, 4),
    [550] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_operation_definition, 1),
    [552] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_operation_definition, 1),
    [554] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_value, 3),
    [556] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_value, 3),
    [558] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_list_value, 2),
    [560] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_list_value, 2),
    [562] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_value, 2),
    [564] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_object_value, 2),
    [566] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_list_value, 3),
    [568] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_list_value, 3),
    [570] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_string_value, 3),
    [572] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_string_value, 3),
    [574] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_value, 1),
    [576] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_value, 1),
    [578] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_variable, 2),
    [580] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_variable, 2),
    [582] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_value, 1),
    [584] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_value, 1),
    [586] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_boolean_value, 1),
    [588] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_boolean_value, 1),
    [590] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_value_definition, 4),
    [592] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(61),
    [594] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_value_definition, 4),
    [596] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(382),
    [598] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_value_definition, 3),
    [600] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_value_definition, 3),
    [602] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(167),
    [604] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(306),
    [606] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(270),
    [608] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_field, 1),
    [610] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(381),
    [612] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(296),
    [614] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_input_fields_definition_repeat1, 2),
    [616] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_input_fields_definition_repeat1, 2),
    SHIFT_REPEAT(387),
    [619] = {.entry = {.count = 2, .reusable = false}},
    REDUCE(aux_sym_input_fields_definition_repeat1, 2),
    SHIFT_REPEAT(388),
    [622] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_input_fields_definition_repeat1, 2),
    SHIFT_REPEAT(344),
    [625] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_directives_repeat1, 2),
    SHIFT_REPEAT(382),
    [628] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(279),
    [630] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(172),
    [632] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_selection_set_repeat1, 2),
    [634] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_selection_set_repeat1, 2),
    SHIFT_REPEAT(149),
    [637] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_selection_set_repeat1, 2),
    SHIFT_REPEAT(150),
    [640] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_field, 2),
    [642] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(103),
    [644] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(149),
    [646] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(150),
    [648] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_list_type, 3),
    [650] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_list_type, 3),
    [652] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_type, 1),
    [654] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_type, 1),
    [656] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(175),
    [658] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(99),
    [660] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(219),
    [662] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_value_definition, 5),
    [664] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_value_definition, 5),
    [666] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_enum_values_definition_repeat1, 2),
    [668] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_enum_values_definition_repeat1, 2),
    SHIFT_REPEAT(387),
    [671] = {.entry = {.count = 2, .reusable = false}},
    REDUCE(aux_sym_enum_values_definition_repeat1, 2),
    SHIFT_REPEAT(388),
    [674] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_enum_values_definition_repeat1, 2),
    SHIFT_REPEAT(219),
    [677] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(287),
    [679] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_description, 1),
    [681] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(283),
    [683] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(344),
    [685] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(104),
    [687] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(284),
    [689] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_field_definition, 4),
    [691] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_field_definition, 4),
    [693] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_value_definition, 2),
    [695] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_value_definition, 2),
    [697] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_value_definition, 1),
    [699] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_value_definition, 1),
    [701] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_non_null_type, 2),
    [703] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_non_null_type, 2),
    [705] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_field_definition, 5),
    [707] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_field_definition, 5),
    [709] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(97),
    [711] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(237),
    [713] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(330),
    [715] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(331),
    [717] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(332),
    [719] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(334),
    [721] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(335),
    [723] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(336),
    [725] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(326),
    [727] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_variable_definition, 3),
    [729] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(83),
    [731] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(375),
    [733] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(302),
    [735] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_fields_definition_repeat1, 2),
    [737] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_fields_definition_repeat1, 2),
    SHIFT_REPEAT(387),
    [740] = {.entry = {.count = 2, .reusable = false}},
    REDUCE(aux_sym_fields_definition_repeat1, 2),
    SHIFT_REPEAT(388),
    [743] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_fields_definition_repeat1, 2),
    SHIFT_REPEAT(284),
    [746] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_field_definition, 3),
    [748] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_field_definition, 3),
    [750] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_schema_definition_repeat1, 2),
    [752] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_schema_definition_repeat1, 2),
    SHIFT_REPEAT(252),
    [755] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(121),
    [757] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(130),
    [759] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_field, 3),
    [761] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(118),
    [763] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_fragment_spread, 2),
    [765] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(227),
    [767] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(340),
    [769] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(393),
    [771] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(390),
    [773] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(389),
    [775] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(386),
    [777] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(373),
    [779] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(204),
    [781] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(15),
    [783] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_variable_definition, 4),
    [785] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(307),
    [787] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(168),
    [789] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(206),
    [791] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(243),
    [793] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_default_value, 2),
    [795] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_default_value, 2),
    [797] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_directives_repeat1, 2),
    SHIFT_REPEAT(375),
    [800] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(231),
    [802] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(303),
    [804] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_input_value_definition, 6),
    [806] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_input_value_definition, 6),
    [808] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(200),
    [810] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(282),
    [812] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_variable_definitions_repeat1, 2),
    [814] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_variable_definitions_repeat1, 2),
    SHIFT_REPEAT(355),
    [817] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(203),
    [819] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_field, 4),
    [821] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(275),
    [823] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_operation_type, 1),
    [825] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_field_definition, 6),
    [827] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_field_definition, 6),
    [829] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_root_operation_type_definition, 3),
    [831] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(232),
    [833] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(369),
    [835] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(225),
    [837] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(281),
    [839] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(342),
    [841] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(138),
    [843] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(214),
    [845] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(140),
    [847] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(52),
    [849] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(191),
    [851] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(5),
    [853] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(346),
    [855] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(183),
    [857] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_fragment_name, 1),
    [859] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_enum_value_definition, 3),
    [861] = {.entry = {.count = 1, .reusable = false}},
    REDUCE(sym_enum_value_definition, 3),
    [863] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(224),
    [865] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(7),
    [867] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(380),
    [869] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_arguments_repeat1, 2),
    [871] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_arguments_repeat1, 2),
    SHIFT_REPEAT(342),
    [874] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(aux_sym_object_value_repeat1, 2),
    [876] = {.entry = {.count = 2, .reusable = true}},
    REDUCE(aux_sym_object_value_repeat1, 2),
    SHIFT_REPEAT(369),
    [879] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_arguments_definition, 3),
    [881] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(220),
    [883] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_inline_fragment, 2),
    [885] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_inline_fragment, 3),
    [887] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_fragment_spread, 3),
    [889] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_field, 5),
    [891] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_inline_fragment, 4),
    [893] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(221),
    [895] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_selection, 1),
    [897] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_variable_definitions, 3),
    [899] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_variable_definition, 5),
    [901] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(316),
    [903] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_type_condition, 2),
    [905] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(306),
    [907] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(358),
    [909] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_variable_definition, 6),
    [911] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_argument, 3),
    [913] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_field, 3),
    [915] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(321),
    [917] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_object_field, 4),
    [919] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(10),
    [921] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(370),
    [923] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(349),
    [925] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(176),
    [927] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(295),
    [929] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(33),
    [931] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(8),
    [933] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(11),
    [935] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(364),
    [937] = {.entry = {.count = 1, .reusable = false}},
    SHIFT_EXTRA(),
    [939] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(14),
    [941] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(25),
    [943] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(26),
    [945] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(309),
    [947] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(115),
    [949] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(265),
    [951] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(211),
    [953] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(55),
    [955] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(327),
    [957] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(216),
    [959] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(356),
    [961] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(30),
    [963] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(357),
    [965] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(274),
    [967] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(28),
    [969] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(212),
    [971] = {.entry = {.count = 1, .reusable = true}},
    ACCEPT_INPUT(),
    [973] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(222),
    [975] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_source_file, 1),
    [977] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(188),
    [979] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(218),
    [981] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(266),
    [983] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(158),
    [985] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(248),
    [987] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(32),
    [989] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(19),
    [991] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(213),
    [993] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(13),
    [995] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(144),
    [997] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(88),
    [999] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(12),
    [1001] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(4),
    [1003] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(160),
    [1005] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(22),
    [1007] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(35),
    [1009] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(239),
    [1011] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(142),
    [1013] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(244),
    [1015] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(95),
    [1017] = {.entry = {.count = 1, .reusable = true}},
    REDUCE(sym_alias, 2),
    [1019] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(151),
    [1021] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(240),
    [1023] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(235),
    [1025] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(31),
    [1027] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(365),
    [1029] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(366),
    [1031] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(23),
    [1033] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(6),
    [1035] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(376),
    [1037] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(377),
    [1039] = {.entry = {.count = 1, .reusable = true}},
    SHIFT(9),
    [1041] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(384),
    [1043] = {.entry = {.count = 1, .reusable = false}},
    SHIFT(385),
};

#ifdef __cplusplus
extern "C"
{
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

  extern const TSLanguage *tree_sitter_graphql(void)
  {
    static TSLanguage language = {
        .version = LANGUAGE_VERSION,
        .symbol_count = SYMBOL_COUNT,
        .alias_count = ALIAS_COUNT,
        .token_count = TOKEN_COUNT,
        .external_token_count = EXTERNAL_TOKEN_COUNT,
        .state_count = STATE_COUNT,
        .large_state_count = LARGE_STATE_COUNT,
        .production_id_count = PRODUCTION_ID_COUNT,
        .field_count = FIELD_COUNT,
        .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
        .parse_table = (const uint16_t *)ts_parse_table,
        .small_parse_table = (const uint16_t *)ts_small_parse_table,
        .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
        .parse_actions = ts_parse_actions,
        .symbol_names = ts_symbol_names,
        .symbol_metadata = ts_symbol_metadata,
        .public_symbol_map = ts_symbol_map,
        .alias_map = ts_non_terminal_alias_map,
        .alias_sequences = (const TSSymbol *)ts_alias_sequences,
        .lex_modes = ts_lex_modes,
        .lex_fn = ts_lex,
    };
    return &language;
  }
#ifdef __cplusplus
}
#endif
