---
title: Contributing
---

# Contributing Overview

Thanks for your interest in contributing! This guide will help you get started.

## Ways to contribute

You can contribute in a variety of ways:

- [File a new issue]({{meta.sourcePath}}/issues/new/choose) on GitHub.
- [Browse the issues]({{meta.links.issues}}) and fix a bug by [contributing code](/contributing/code/).
- Improve this [documentation](/contributing/docs/).
- [Add a new recipe](/contributing/recipes/) to the recipes database to help Bearer CLI identify more third-parties.
- Help others in the [Community Discord]({{meta.links.discord}})

All contributions and interactions with the community must adhere to our [contributor code of conduct]({{meta.sourcePath}}/blob/main/CODE_OF_CONDUCT.md).

### CLA (Contributor License Agreement)

A Contributor License Agreement (CLA) is a legal document that outlines the terms and conditions under which a contributor submits their work, such as code, documentation, or other materials, to a project.

Before submitting any Pull Request, please take a look at our [CLA document](/cla.pdf), fill it out and send it to [research@cycode.com](mailto:research@cycode.com). After that, you are good to go.

## Best practices

Here are some tips to get you started:

- If you're unfamiliar with the process, check out GitHub's guide: [Creating a pull request](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/creating-a-pull-request)
- Use [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) when creating a pull request.
- As a best practice, we encourage you to [sign your commits](https://docs.github.com/en/authentication/managing-commit-signature-verification/signing-commits). We require our core contributors to sign their commits.
