module.exports = [
  {
    name: "Get Started",
    open: true,
    items: [{ name: "Quick Start", url: "/quickstart/" }],
  },
  {
    name: "Guides",
    open: true,
    items: [
      {
        name: "Configure the scan",
        url: "/guides/configure-scan/",
      },
      {
        name: "Integration strategy",
        url: "/guides/integration-strategy/",
      },
      {
        name: "Set up CI/CD",
        url: "/guides/ci-setup/",
      },
      {
        name: "Using GitHub Actions",
        url: "/guides/github-action/",
      },
      {
        name: "Using GitLab CI/CD",
        url: "/guides/gitlab/",
      },
      {
        name: "Create a custom rule",
        url: "/guides/custom-rule/",
      },
      {
        name: "Run a privacy report",
        url: "/guides/privacy/",
      },
      {
        name: "Run a data flow report",
        url: "/guides/dataflow/",
      },
      {
        name: "Shell completions",
        url: "/guides/shell-completion/",
      },
    ],
  },
  {
    name: "Explanations",
    open: true,
    items: [
      {
        name: "How Bearer CLI works",
        url: "/explanations/workflow/",
      },
      {
        name: "Scanner types",
        url: "/explanations/scanners/",
      },
      {
        name: "Report types",
        url: "/explanations/reports/",
      },
      {
        name: "Sensitive data flow",
        url: "/explanations/discovery-and-classification/",
      },
    ],
  },
  {
    name: "Reference",
    open: false,
    items: [
      { name: "Installation", url: "/reference/installation/" },
      { name: "Configuration", url: "/reference/config/" },
      { name: "Commands", url: "/reference/commands/" },
      { name: "Rules", url: "/reference/rules/" },
      { name: "Data Types", url: "/reference/datatypes/" },
      { name: "Recipes", url: "/reference/recipes/" },
      { name: "Supported Languages", url: "/reference/supported-languages/" },
    ],
  },
  {
    name: "Contributing",
    open: false,
    items: [
      { name: "Overview", url: "/contributing/" },
      { name: "Contribute code", url: "/contributing/code/" },
      { name: "Contribute documentation", url: "/contributing/docs/" },
      { name: "Contribute new recipes", url: "/contributing/recipes/" },
    ],
  },
]
