## Welcome to Lenvo Legion Toolkit contributing guide!

### Other language versions of this contributing guide:
* [简体中文版开发者指南](CONTRIBUTING_zh-hans.md)

Thanks for investing your time in contributing to this project! Giving the growing popularity of LLT, here are a few rules to follow to ensure that your contribution goes smoothly.

<br/>

_Due to large number of issues created, those that do not meet the criteria will be deleted without warning. Repeating offenders will be banned._

<br/>

**1. Before reporting an issue make yourself familiar with the README**

[README](https://github.com/BartoszCichecki/LenovoLegionToolkit/blob/master/README.md) is regularly updated to include answers to frequently asked questions as well as information about most common issues. Take your time to go through what is there before creating an issue or starting a discussion.

**2. Check already reported issues**

Go through [issues](https://github.com/BartoszCichecki/LenovoLegionToolkit/issues?q=is%3Aissue) that were already reported, as well as [discussions](https://github.com/BartoszCichecki/LenovoLegionToolkit/discussions?discussions_q=). Do not create duplicate issues or discussions. Even if the issue is marked as closed, you can still leave a comment there.

**3. Use English**

This makes it easier for everyone to follow the conversation.

**4. Respect scope of the project**

This is not meant to be a do-it-all type of application. The vision for the project is clear: provide a replacement of Vantage for Legion laptops. Do not request support for other types/models/etc devices.

**5. Verify your problem before creating an issue**

Make sure that a bug is really a bug in LLT - this isn't a free system troubleshooting forum. If you use modified version of Windows or your Windows is acting funny, that's on you.

**6. Describe your problem as best as you can**

Providing good description is key. Fill out all the fields of the form when creating an issue, including logs. The better the description, the higher the chance that we will understand each other correctly.

**7. Give a good title to issues and discussions**

It is a lot easier to browse the list and follow issues and discussions. "Error when using LLT" is not a good title.

**8. Stay on topic**

Do not leave unnecessary comments or spam.

**9. One problem per issue**

Do not report many problems or request many features withing one issue. Make one issue or discussion per problem/topic/idea. This makes it easier to follow.

**10. Translations**

Translation contributions are done using [Crowdin](https://crowdin.com/project/llt), so please request access to the project there if you want to contribute.

**11. Pull requests**

Pull requests are welcome (of course). Unless you create a very simple and understandable PR, make an issue first and describe the problem you are solving. It doesn't make sense to spend time working on an idea that will be rejected, because it doesn't fit the project vision. Follow the code style and architecture of the project.

<br/>

Once again, thanks for investing your time in helping LLT get better!
