# Agenda & Outcomes

[Sign up for updates](https://forms.office.com/r/rLds2s8RH1){ :target="_blank" .md-button .md-button--primary }

## Agenda

1. Introduction to Intelligent App Development with Copilot stack
   1. Unveiling the Art of the Possible: Inspiring Walkthroughs
      - [Miyagi](https://github.com/Azure-Samples/miyagi)
      - [Semantic Kernel Samples](https://github.com/microsoft/semantic-kernel#check-out-our-other-repos)
      - [Reddog](https://github.com/Azure/reddog-solutions)
   1. Comprehensive Architecture Overview
   1. Essential Pre-requisites
1. Unearthing Customer Needs and Pain Points (Design Thinking session to personalize the workshop for your organization needs and use cases)
    1. Crafting AI-Driven Design and User Experience
1. First steps to integrate AI into cloud-native and Azure backing services and data processing
1. Empowering Development with AI Capabilities (inner-loop), including leveraging Github CoPilot
1. Learn LLM capabilities and Prompt Engineering
    1. In-context learning (ICL)
    1. Prompt Engineering techniques
    1. Advanced Retrieval augmented generation (RaG)
    1. Integrating vector databases
    1. Prompt Flow
    1. Agents with Semantic Kernel, Autogen, and TaskWeaver
1. Deep-dive into AI orchestration primitives through use cases with Miyagi and Reddog
1. Exploring Agents and Agent-like Orchestration
1. Tradeoffs with AI orchestrators (Semantic Kernel, Langchain, Guidance, TypeChat, PromptFlow etc.)
1. Copilot Studio and Power Platform
1. AI Studio and Prompt Flow
1. AI Content Safety Studio
1. Fine-tuning OSS models with proprietary training data to improve task specific accuracy and latency
1. Streamlined Deployment and Monitoring of AI-Infused Apps
1. (Optional) First Principles of Large Language Models for application developers
    1. High Level Overview of AI and ML
    1. Overview and History of NLP, NLU, and NLG
    1. Autoregressive Models
        1. NLP: RNNs to Transformers
        1. Computer Vision: CNNs to Vision Transformers (ViT)
        1. Audio: Wav2Vec2, Whisper
        1. Multimodal: VisualBERT, CLIP
    1. Reliability & Responsible AI for developers
        1. Ensuring Reliability and Controllability of LLM Output 
            1. Grounding
            1. Alignment
        1. Retrieval augmented generation (RaG)
1. Hands-on Project: Constructing a Semantic Kernel Plugin and integrating it with an Existing App using Miyagi
1. Reliability and controllability of LLM output
1. Embracing "Everything as Code": Automation, Deployment, and Operationalization for production
1. Architecture Design Session: Crafting a customized PoC for your unique use case(s)
1. Conclusion and Next Steps with MVP

## Outcomes

Upon completing this workshop, participants will:

- Comprehend the transformative potential of Azure AI services and Copilot Stack in revolutionizing every facet of AI app development.
- Acquire hands-on experience in AI-driven design and user experience techniques
- Learn to effortlessly integrate foundation models into backend services, data processing, and frontend development
- Build an AI-infused app from the ground up during the hands-on project
- Implement Agents using Assistants API, Code Interpretor, and Retrieval intefaces. 

