# Home

Inspired by Github Copilot's impact on developer productivity, this experiential workshop is designed to demonstrate how you can infuse similar intelligence and product experience into traditional software systems. Using [Microsoft's Copilot stack](https://developer.microsoft.com/en-us/copilot) and practical [use cases](https://iappwksp.com/wksp/05-use-cases/#use-cases), this workshop will guide you in envisioning and creating intelligent systems and agents that integrate foundation models throughout your workflows and applications, resulting in improved productivity and hyper-personalized user experiences.

[Sign up for updates](https://forms.office.com/r/rLds2s8RH1){ :target="_blank" .md-button .md-button--primary }

!!! note ""

   :tv: For a preview, catch the [recording on :simple-youtube: Cosmos DB Live TV](https://www.youtube.com/watch?v=V8dlEvXdGEM&t=144s). For an overview on mental models, see [this video from Semantic Kernel's Channel](https://www.youtube.com/watch?v=EueJTTuluVQ&t=750s).


## Workshop Overview

In this comprehensive workshop, you will:

- Utilize Azure AI Studio for reasoning engines, Prompt Flow for LLMOps, AI Search for semantic retrieval systems, and Semantic Kernel for orchestration.
- Work with [Miyagi](https://github.com/Azure-Samples/miyagi) codebase during the hands-on experiential workshop.
- Explore advanced capabilities such as AutoGen and GraphRaG.


## Topics for the Workshop

???+ info "Pre-requisite"

    Please sign up for [Azure OpenAI (AOAI)](https://aka.ms/oai/access) and complete the [Getting Started with AOAI module](https://learn.microsoft.com/en-us/training/modules/get-started-openai/) to get the most out of this workshop.

1. **Brief Overview of Gen AI Capabilities and Use Cases**: Explore the art of the possible with multi-agent and advanced retrieval systems using samples like [Miyagi](https://github.com/Azure-Samples/miyagi) and [Holmes](https://github.com/Azure-Samples/holmes). Engage in interactive demonstrations to envision potential applications with reasoning engines and semantic memory systems.
1. **Design Thinking Session (Optional)**: Participate in a collaborative brainstorming activity to identify your unique use cases, focusing on addressing user needs and alleviating pain points, ensuring the workshop is relevant to you.
1. **AI Studio and Prompt Flow**: Quickly get started with your own copilot, grounded by your proprietary data in AI Search using our AI Studio experience. Customize it with Prompt Flow and deploy it to a production endpoint, including LLMOps integration.
1. **AI Orchestration SDKs**: Enhance your custom copilot by integrating it with existing APIs and incorporating advanced orchestration and multi-turn LLM interactions using SDKs like Semantic Kernel and LangChain.
1. **Multi-Agent and Advanced Retrieval**: Further develop your solution by leveraging multi-agent capabilities for reliable outputs and complex inference tasks with AutoGen, Assistants API, and GraphRag.
1. **Other Use Cases**: Explore AI Document Intelligence and Vision model capabilities for automating business workflows.

<p align="center"><img src="assets/images/basic-arch.png" width=50% /></p>
<p align="center"><img src="assets/images/ai_application.png" width=50% /></p>

[See full agenda](wksp/00-intro/agenda-and-outcomes.md){ .md-button }



### Disclaimer

This software is provided for demonstration purposes only. It is not intended to be relied upon for any purpose. The creators of this software make no representations or warranties of any kind, express or implied, about the completeness, accuracy, reliability, suitability or availability with respect to the software or the information, products, services, or related graphics contained in the software for any purpose. Any reliance you place on such information is therefore strictly at your own risk.

### License

This software is provided for demonstration purposes only. It is not intended to be relied upon for any purpose. The software is provided “as is” and without any warranties, express or implied. The software is not intended to be used for any commercial purpose. The software is provided solely for demonstration purposes and should not be used for any other purpose. The software is provided without any warranty of any kind, either express or implied, including, but not limited to, the implied warranties of merchantability, fitness for a particular purpose, or non-infringement. The software is provided “as is” and without any warranty of any kind. The user assumes all risk and responsibility for the use of the software.
