# Envisioning Workshop: Build Your Own Custom Copilot

[![Open in Visual Studio Code](https://img.shields.io/static/v1?logo=visualstudiocode&label=&message=Open%20in%20VS%20Code&labelColor=2c2c32&color=007acc&logoColor=007acc)](https://github.dev/Azure/intelligent-app-workshop)
[![License: CC BY-SA 4.0](https://img.shields.io/badge/License-CC%20BY--SA-222.svg)](https://creativecommons.org/licenses/by-sa/4.0/)

Welcome to this envisioning workshop designed to help you build your own custom Copilot using [Microsoft's Copilot stack](https://developer.microsoft.com/en-us/copilot). This workshop aims to rethink user experience, architecture, and app development by leveraging reasoning engines (Foundation models and Language Models) and semantic memory systems.

## Workshop Overview

In this comprehensive workshop, you will:

- Utilize Azure AI Studio for reasoning engines, Prompt Flow for LLMOps, AI Search for semantic retrieval systems, and Semantic Kernel for orchestration.
- Work with [Miyagi](https://github.com/Azure-Samples/miyagi) codebase during the hands-on experiential workshop
- Explore advanced capabilities such as AutoGen and GraphRag

## Objectives

This workshop will guide you through the entire lifecycle of app development, including:

1. Identifying user needs
2. Developing a fully functional, production-grade app
3. Deploying your app on Azure with advanced capabilities

By the end of this workshop, you will have a deeper understanding of how to leverage Microsoft's tools and technologies to create intelligent applications.


<p align="center"><img src="docs/assets/images/basic-arch.png" width=50% /></p>

![wip-azure](docs/assets/images/wip-azure.png)



### Disclaimer

This software is provided for demonstration purposes only. It is not intended to be relied upon for any purpose. The creators of this software make no representations or warranties of any kind, express or implied, about the completeness, accuracy, reliability, suitability or availability with respect to the software or the information, products, services, or related graphics contained in the software for any purpose. Any reliance you place on such information is therefore strictly at your own risk.

### License

This software is provided for demonstration purposes only. It is not intended to be relied upon for any purpose. The software is provided “as is” and without any warranties, express or implied. The software is not intended to be used for any commercial purpose. The software is provided solely for demonstration purposes and should not be used for any other purpose. The software is provided without any warranty of any kind, either express or implied, including, but not limited to, the implied warranties of merchantability, fitness for a particular purpose, or non-infringement. The software is provided “as is” and without any warranty of any kind. The user assumes all risk and responsibility for the use of the software.