# WRK551 Build a multi-tasking assistant with Azure OpenAI

## Welcome to workshop WRK551!

Building Large Language Model (LLM) applications​ is hard! Companies want to build AI solutions, but how can they do this in a reliable, reproducible and observable way?​

### Challenges with AI:  ​
- Getting LLM apps to work with various real world inputs ​
- Debugging (local and production)​ to understand failures
- Setting up and managing production infrastructure automation

This workshop will introduce new tooling that provides practical solutions to these problems. 

## Setting Up

Open the [LAB-SETUP.ipynb](./LAB-SETUP.ipynb) notebook to go through authentication and refreshing your azd environment.
After completing the setup stage, you can get started with the rest of the workshop. 

## Getting Started

In this section we will focus on four key outcomes, each split into their own notebook:

1. [Understanding agents and prompt engineering with Prompty.](./workshop-1-intro.ipynb)
2. [Utilizing Prompty tracing for debugging and observability.](./workshop-2-tracing.ipynb)
3. [Building and running Contoso Creative Writer.](./workshop-3-build.ipynb)
4. [Setting up automated evaluations with GitHub Actions.](./workshop-4-ci-cd.ipynb)
