/*
 *      This file is part of the KoraOS project.
 *  Copyright (C) 2015-2021  <Fabien Bavent>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as
 *  published by the Free Software Foundation, either version 3 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   - - - - - - - - - - - - - - -
 */
#include <stdlib.h>
#include <kernel/core.h>
#include <kernel/stdc.h>

thread_local int __irq_semaphore = 0;

void irq_reset(bool enable)
{
    __irq_semaphore = 0;
}

bool irq_enable()
{
    assert(__irq_semaphore > 0);
    --__irq_semaphore;
    return __irq_semaphore == 0;
}

void irq_disable()
{
    ++__irq_semaphore;
}

void might_sleep(void)
{
    assert(__irq_semaphore == 0);
}
