By contributing to this repo, you agree to the following rules.

# Contributing
###### Last updated on October 2023
- Write good code, well commented, well structured, well readable.
- If you find my code illegible immediately open an issue with the code file and lines reported.
- Test your code manually, heavily, coz I've got no experience with auto-testing (you could help me out here).
- Find a bug

## Find a bug
Issue [#7 - Find a bug](https://github.com/AvirukBasak/jshp/issues/7)

Yes it's a bug bounty, and no you don't need to write any code, only test the framework.

### Details
Find a bug in what works. Finding a bug in a non-existent feature is invalid.

Issue [#7](https://github.com/AvirukBasak/jshp/issues/7) is basically asking you to find out a bug in this project by heavily testing it (manually, coz I've not yet added any automated tests).

Once done, in the PR commits, you just need to create a `docs/<your_username>/bug_<title>.md` file with info on the bug. Also copy paste the details into a new issue (create a new issue coz it really helps).

### Details of the bug
- The bug should be reproducible.
- The bug report should contain every step required to reproduce the bug.
- If required, a link to a repo having code or project that triggers the bug should be given.
- Stack traces help a lot, so if the framework produces one, or some logs, that should be included in the report.
- You should report any bug, from UI/UX, to logic, security, and bad function usages.

### Updating code
If you modify or add code, it'll go through a stricter review.

### Use in HacktoberFest
In return (on your PR submission) you get a `HacktoberFest 2023` contribution.

All non-spam and well-written PRs will get labelled `hacktoberfest-accepted`, even if they're not merged.

### PS
Someone will fix the bug someday.
