Fixes #

#### Changes proposed in this Pull Request

<!--
Title: A descriptive, yet concise, title.
-->

<!--
Description: Write a brief summary about this PR. As you compose your summary, consider each of these questions and address them if appropriate. Why is this change needed? What does this change do? Were there other solutions you considered? Why did you choose to pursue this solution? Describe any trade-offs you might have had to make.
-->

<!--
Questions for PR author:
- How can this code break?
- What are we doing to make sure this code doesn't break?
-->

<!--
Images or gifs: Include before and after screenshots or gifs/videos when it makes sense.
-->

#### Testing instructions

<!--
Testing instructions: How should this be tested and how can a reviewer test the end-user functionality? Are there known issues that you plan to address in a future PR? Are there any side effects that readers should be aware of?
-->

<!--
Add as many details as possible to help others reproduce the issue and test the fix.
"Before / After" screenshots can also be very helpful when the change is visual.
-->

*

-------------------

- [ ] Run `npm run changelog` to add a changelog file, choose `patch` to leave it empty if the change is not significant. You can add multiple changelog files in one PR by running this command a few times. 
- [ ] Covered with tests (or have a good reason not to test in description ☝️)
- [ ] Tested on mobile (or does not apply)

**Post merge**

<!--
Make sure you edit the page for the current release when adding testing instructions.
We often create a blank page ahead of time for the next release.
If this PR need not be QA tested, edit to 'QA Testing Not Applicable'
-->

- [ ] Link to testing instructions from [release testing doc](https://github.com/Automattic/woocommerce-payments/wiki/Release-testing-instructions) following [these instructions](https://github.com/Automattic/woocommerce-payments/wiki/How-to-write-good-manual-testing-scenarios) : _Add link here / 'QA Testing Not Applicable'_
- [ ] Add or update [critical flows](https://github.com/Automattic/woocommerce-payments/wiki/Critical-flows) and [testing instructions for critical flows](https://github.com/Automattic/woocommerce-payments/wiki/Testing-instructions-for-critical-flows), if applicable.
- [ ] Add what's changed (description, screenshot, demo videos etc.) to the release announcement post, if applicable.
