# IVectorTransformer

Namespace: Automation.GenerativeAI.Interfaces

Transforms a given string to a vector

```csharp
public interface IVectorTransformer
```

## Properties

### **VectorLength**

Returns default length of vector generated by this transformer. 
 Returns zero if transformer is not yet initialized.

```csharp
public abstract int VectorLength { get; }
```

#### Property Value

[Int32](https://docs.microsoft.com/en-us/dotnet/api/system.int32)<br>

## Methods

### **Transform(String)**

Transforms the given TextObject to a vector

```csharp
Double[] Transform(string textObject)
```

#### Parameters

`textObject` [String](https://docs.microsoft.com/en-us/dotnet/api/system.string)<br>
Input text

#### Returns

[Double[]](https://docs.microsoft.com/en-us/dotnet/api/system.double)<br>
Vector representation of the input textObject

### **Transform(IEnumerable&lt;String&gt;)**

Learns and transforms a list of text objects into vector representation.

```csharp
Double[][] Transform(IEnumerable<string> textObjects)
```

#### Parameters

`textObjects` [IEnumerable&lt;String&gt;](https://docs.microsoft.com/en-us/dotnet/api/system.collections.generic.ienumerable-1)<br>
A list of text objects

#### Returns

[Double[][]](https://docs.microsoft.com/en-us/dotnet/api/system.double)<br>
list of vector
