```{toctree}
:hidden:

get_started/index
core_concepts/index
evaluation/index
metrics/index
integrations/index
api_reference/index
more/index
```

# Ragrank 🎯

Ragrank is a user-friendly Python library created to make evaluating Retrieval Augmented Generation (RAG) models easier 🔥.


**With Ragrank, you can:**

- Evaluate, monitor, and troubleshoot LLM applications 🛠
- Plug-and-use 5+ LLM-evaluated metrics, most with research backing 💡
- Custom metrics are simple to personalize and create 📐
- Define evaluation datasets in Python code 📦



**Key Features:**

- Easy to Use: Designed for developers new to RAG models 📘
- Customizable: Tailor the evaluation process to your data and metrics 🛠️
- Open Source: The source code is publically available 🌟
-------


````{grid}
:gutter: 2

```{grid-item-card} 🚀 Quick Start
:link: quick-start
:link-type: ref

Master the basics of `ragrank` with a strong step. Evaluate RAG pipelines, generate test sets, and set up online monitoring for RAG apps — all with a few lines of code.
```

```{grid-item-card} 🪩 Core concepts
:link: core-concepts
:link-type: ref

Discover the main ideas and concepts of `ragrank`. Learn how to check how well models work using the tools in the library with fundamentals.
```

````

````{grid}
:gutter: 2

```{grid-item-card} 🛠 The Evaluation
:link: the-evaluation
:link-type: ref

Head over to the comprehensive evaluation with `ragrank`. Explore the various aspects of evaluating Language Model (LLM) and Retrieval Augmented Generation (RAG) models.
```

```{grid-item-card} 📏 Metrics
:link: the-metrics
:link-type: ref

Discover different metrics and create custom ones using `ragrank`. Dive into a variety of measurement methods to analyze and improve the performance of your models effectively.
```

````
