# Evaluation Result

The `EvalResult` object, generated by the `evaluate` function, is versatile and can be easily converted to various data types such as dictionaries and pandas dataframe, facilitating seamless integration with different systems and workflows.

```python
from ragrank import evaluate
from ragrank.evaluation import EvalResult
from ragrank.dataset import DataNode

data = DataNode(
    question="What is the tallest mountain in the world?",
    context=[
        "Mount Everest is the tallest mountain above sea level.",
        "It is located in the Himalayas.",
    ],
    response="The tallest mountain in the world is Mount Everest.",
)

result:EvalResult = evaluate(
    data ,
)

print(result.to_dict())
```

Attributes of the `EvalResult`:
- `llm`: The language model used for evaluation.
- `metrics`: List of metrics used for evaluation.
- `dataset`: The dataset used for evaluation.
- `scores`: List of scores for each metric.
- `response_time`: Response time for the evaluation process.

Methods:
- `to_dict()` : Convert the data into dict format
- `to_dataframe()` : Convert the data into a pandas dataframe