<p align="center">
  <img alt="Logo" src="https://avatars.githubusercontent.com/u/106490518?s=128&v=4" width="128px;" height="128px;">
</p>

<h1 align="center">Aurora Editor</h1>

<br />

Aurora Editor is an innovative Integrated Development Environment (IDE) meticulously crafted in Swift, designed to deliver exceptional native performance on macOS. Envision all the capabilities of Xcode, but enhanced with multi-language support, seamless Git integration, and a suite of your favorite built-in development tools. Aurora Editor is built by the community, for the community, aiming to be the go-to choice for developers seeking a robust and efficient coding environment.

<!--
<img width="1012" alt="github-banner" src="https://user-images.githubusercontent.com/63672227/187914690-2277654c-6cab-4738-b151-1c85947bea8b.jpg">
-->
<img width="1112" alt="image" src="https://github.com/user-attachments/assets/b4bb371f-381b-4044-9531-64d09c334ca8">

## 🚀 Why Choose Aurora Editor?

In the world of code editors, many modern solutions are based on Electron, resulting in significant system resource consumption and less-than-optimal performance. Aurora Editor stands apart as a native macOS application, providing lightning-fast speeds, minimal RAM usage, and smooth, responsive animations. It offers a development experience akin to Xcode, with the added flexibility of supporting multiple programming languages. Whether you’re a seasoned developer or just starting, Aurora Editor ensures a seamless and efficient workflow, making coding a delight.

## 🌐 Join Our Community

Become a part of our vibrant developer community by joining us on [Discord](https://discord.gg/5aecJ4rq9D), [Slack](https://join.slack.com/t/auroraeditor/shared_invite/zt-1fti1r72d-8mWmJsj279vDV~YdKhcUEA) or [Matrix (beta)](https://matrix.to/#/#AuroraEditor:matrix.org). Engage in meaningful discussions, collaborate on exciting projects, and share your ideas. Our community is welcoming and supportive, offering a space for developers of all skill levels to grow and contribute.

## 💾 Download Aurora Editor

Experience the power and performance of Aurora Editor by downloading the latest version. We currently only have a nightyly build available as we get closer to a release build we will add them here.

- **[Download Nightly Build](https://nightly.link/AuroraEditor/AuroraEditor/workflows/build-editor/development/AuroraEditor.zip)**

## 💡 Share Your Ideas

We highly value the input and creativity of our community members. If you have a groundbreaking idea for a new feature, we want to hear it! Share your thoughts in our [Ideas Discussion](https://github.com/AuroraEditor/AuroraEditor/discussions/categories/ideas). If you’ve created something amazing using Aurora Editor, showcase it in our [Show and Tell](https://github.com/AuroraEditor/AuroraEditor/discussions/categories/show-and-tell) section. Stay informed about the latest developments and announcements by following our [Announcements](https://github.com/AuroraEditor/AuroraEditor/discussions/categories/announcements).

## ✨ Contributing

Join the revolution in code editing by contributing to Aurora Editor. Our project thrives on the contributions of developers from all backgrounds and skill levels. To get started, explore the following resources:

- [Development To-Do](https://github.com/AuroraEditor/AuroraEditor/discussions/categories/development-todo): A list of tasks and features that need development.
- [Contribution Guide](https://github.com/AuroraEditor/AuroraEditor/blob/main/CONTRIBUTING.md): Step-by-step instructions for contributing to the project.
- [Architecture Guide](https://github.com/AuroraEditor/AuroraEditor/wiki/Architecture): Detailed documentation on the architectural design of Aurora Editor.
- [Developer Guide](https://github.com/AuroraEditor/AuroraEditor/wiki/Developer-Guide): Comprehensive guide for developers working on Aurora Editor.
- [Troubleshooting Guide](https://github.com/AuroraEditor/AuroraEditor/wiki/Troubleshooting): Solutions to common issues and problems.

## 🌍 Localization

Help us make Aurora Editor accessible to a global audience by translating it into different languages. If you’re proficient in a language other than English, contribute to our localization efforts. [Translate Now](https://app.lokalise.com/public/8719853963cfc24a9bfba9.04156986/)

## 💖 Contributors ✨

We owe our success to the hard work and dedication of our amazing contributors. [Meet the team](http://auroraeditor.com/#contributors) behind Aurora Editor and see how you can join this incredible group.

<!-- AEB-Contributors-Start -->
<!-- AEB-Contributors-End -->

## 💼 Sponsors

Aurora Editor is proudly supported by these sponsors:

<a title="MacStadium" href="https://macstadium.com" target="_blank"><img src="https://user-images.githubusercontent.com/806104/162766594-eff7f985-31a9-48c5-9e58-139794fefa10.png" width="128"></a>
<a title="Lokalise" href="https://lokalise.com" target="_blank"><img src="https://user-images.githubusercontent.com/63672227/214901959-62aa13a7-8d85-44c9-abd0-7d9dc21d7255.png" width="128"></a>
<a href="https://sentry.io" title="Sentry">
  <picture>
    <source alt="Sentry" href="https://sentry.io" media="(prefers-color-scheme: dark)" srcset="https://github.com/AuroraEditor/AuroraEditor/assets/63672227/59a48bf3-5c3f-4904-9b1c-982bcf89fc5f" width="128">
    <img alt="Sentry" href="https://sentry.io" src="https://github.com/AuroraEditor/AuroraEditor/assets/63672227/cccf2fd4-7cfe-4ace-bb84-13557794f93c" width="128">
  </picture>
</a>
<a title="Screen Studio" href="https://www.screen.studio" target="_blank"><img src="https://github.com/AuroraEditor/AuroraEditor/assets/63672227/99ac2fb5-d341-430e-bdf4-63278286f562" width="128"></a>
[![DigitalOcean Referral Badge](https://web-platforms.sfo2.cdn.digitaloceanspaces.com/WWW/Badge%203.svg)](https://www.digitalocean.com/?refcode=d68c5c8d2ac1&utm_campaign=Referral_Invite&utm_medium=Referral_Program&utm_source=badge)

Discover more about our [Sponsors](https://github.com/sponsors/AuroraEditor)

## 📜 License

Aurora Editor is licensed under the MIT License, ensuring that it remains free and open-source for all to use. For more details, see the [LICENSE](https://github.com/AuroraEditor/AuroraEditor/blob/main/LICENSE.md).

## 📏 Code of Conduct

We are committed to maintaining a welcoming and inclusive environment for everyone. Please review our [Code of Conduct](https://github.com/AuroraEditor/AuroraEditor/blob/main/CODE_OF_CONDUCT.md) to understand our community guidelines and expectations.

## 🔛🔝 Stats
![Alt](https://repobeats.axiom.co/api/embed/2ef1e222dc8117fc1afb2ff45d273756aa296647.svg "Repobeats analytics image")
