# Contribute to Aurora Editor 🌟

Join our vibrant community and collaborate with us on the [Aurora Editor Discord Server](https://discord.gg/5aecJ4rq9D). 

> **Please Note**: Aurora Editor is currently in active development, and it might occasionally experience random crashes. Your contributions are invaluable in making it better!

## 🍴 Fork & Clone Aurora Editor

1. Get started by tapping the **"Fork"** button at the top of this GitHub repository.

2. After forking, clone your repository to your Mac using the following command:

    ```bash
    git clone https://github.com/yourusername/AuroraEditor.git
    ```

## 🔍 Explore Issues

Explore the list of open issues from the [Issues tab](https://github.com/AuroraEditor/AuroraEditor/issues).

If you find an issue you'd like to work on, please express your interest by commenting:

    ```
    @aurora-editor-bot please assign me
    ```

## 🚀 Getting Started

1. Fork this repository to your own GitHub account.
2. Clone the repository to your local machine:

    ```bash
    git clone https://github.com/yourusername/AuroraEditor.git
    ```

3. Make your code changes.

4. Create a Pull Request (PR) when you're ready to submit your changes.

## 💻 Code Style

While we don't have a detailed coding style guide, we do follow [SwiftLint rules](.swiftlint.yml).

## 🚧 Pull Request (PR)

When submitting a Pull Request, please follow these guidelines:

- Provide a descriptive **title** summarizing your changes.
- Include a detailed **description** of the modifications you made.
- If your changes affect the user interface (UI), add a **screenshot** or **video** to showcase the improvements.
- Link your PR to a related issue. If there isn't one, create an issue first and then link it to your PR.
- If your PR is still a work in progress, mark it as **Draft**.

## ✔️ Checks, Tests & Documentation

GitHub will automatically notify the required reviewers.

- Resolve all `Violation` errors in Xcode. This is essential for the SwiftLint check on GitHub to pass.

- GitHub will run tests and SwiftLint checks upon submitting your PR. If a test fails, the PR cannot be merged.

- Make sure to resolve any merge conflicts, as unresolvable conflicts can block the PR from being merged.

> **Important**: Ensure your code is well-documented to make it easy for others to understand and work with your contributions! 📚🖋️

Let's work together to make Aurora Editor an exceptional tool! 😄🚀