//
//  HelpButton.swift
//  Aurora Editor
//
//  Created by Lukas Pistrol on 30.03.22.
//  Copyright © 2023 Aurora Company. All rights reserved.
//

import SwiftUI

/// A Button representing a system Help button displaying a question mark symbol.
public struct HelpButton: View {
    /// The action closure
    private var action: () -> Void

    /// Initializes the ``HelpButton`` with an action closure
    /// - Parameter action: A closure that gets called once the button is pressed.
    public init(action: @escaping () -> Void) {
        self.action = action
    }

    /// The view body
    public var body: some View {
        Button(action: action, label: {
            ZStack {
                Circle()
                    .strokeBorder(Color(NSColor.separatorColor), lineWidth: 0.5)
                    .background(Circle().foregroundColor(Color(NSColor.controlColor)))
                    .shadow(color: Color(NSColor.separatorColor).opacity(0.3), radius: 0.5)
                    .shadow(color: Color(NSColor.shadowColor).opacity(0.3), radius: 1, y: 0.5)
                    .frame(width: 20, height: 20)
                Image(systemName: "questionmark")
                    .font(.system(size: 12.5, weight: .medium))
                    .accessibilityLabel(Text("Help"))
            }
        })
        .buttonStyle(PlainButtonStyle())
    }
}

struct HelpButton_Previews: PreviewProvider {
    static var previews: some View {
        HelpButton {}
            .padding()
    }
}
