"""Define constants with dataclasses for use in chasten."""

from dataclasses import dataclass
from pathlib import Path


# chasten constant
@dataclass(frozen=True)
class Chasten:
    """Define the Chasten dataclass for constant(s)."""

    Analyze_Storage: Path
    Application_Name: str
    Application_Author: str
    App_Storage: Path
    API_Key_Storage: Path
    Chasten_Database_View: str
    Emoji: str
    Executable_Fly: str
    Executable_Vercel: str
    Https: str
    Name: str
    Programming_Language: str
    Separator: str
    Server_Shutdown: str
    Tagline: str
    Theme_Background: str
    Theme_Colors: str
    Website: str


chasten = Chasten(
    Analyze_Storage=Path("analysis.md"),
    Application_Name="chasten",
    Application_Author="ChastenedTeam",
    App_Storage=Path("check.txt"),
    API_Key_Storage=Path("userapikey.txt"),
    Chasten_Database_View="chasten_complete",
    Emoji=":dizzy:",
    Executable_Fly="fly",
    Executable_Vercel="vercel",
    Https="https://",
    Name="chasten",
    Programming_Language="python",
    Separator="/",
    Server_Shutdown=":person_shrugging: Shut down chasten's sylog server",
    Tagline="chasten: Analyze the AST of Python Source Code",
    Theme_Background="default",
    Theme_Colors="ansi_dark",
    Website=":link: GitHub: https://github.com/gkapfham/chasten",
)


# checks constant
@dataclass(frozen=True)
class Checks:
    """Define the Checks dataclass for constant(s)."""

    Check_Chasten: str
    Check_Code: str
    Check_Count: str
    Check_Confidence: int
    Check_File: str
    Check_Id: str
    Checks_Label: str
    Check_Max: str
    Check_Min: str
    Check_Name: str
    Check_Pattern: str


checks = Checks(
    Check_Chasten="chasten",
    Check_Code="code",
    Check_Count="count",
    Check_Confidence=80,
    Check_File="checks-file",
    Check_Id="id",
    Checks_Label="checks",
    Check_Max="max",
    Check_Min="min",
    Check_Name="name",
    Check_Pattern="pattern",
)


# datasette constant
@dataclass(frozen=True)
class Datasette:
    """Define the Datasette dataclass for constant(s)."""

    Chasten_Database: str
    Datasette_Executable: str
    Datasette_Copyable_Install: str
    Datasette_Export_Notebook: str
    Datasette_Search_All: str


datasette = Datasette(
    Chasten_Database="chasten.db",
    Datasette_Executable="datasette",
    Datasette_Copyable_Install="--install=datasette-copyable",
    Datasette_Export_Notebook="--install=datasette-export-notebook",
    Datasette_Search_All="--install=datasette-search-all",
)


# filesystem constant
@dataclass(frozen=True)
class Filesystem:
    """Define the Filesystem dataclass for constant(s)."""

    Current_Directory: str
    Dash: str
    Dot: str
    Main_Configuration_File: str
    Main_Checks_File: str
    Main_Results_File_Name: str
    Main_Results_Combined_File_Name: str
    Main_Results_Flattened_Directory_Name: str
    Results_Extension: str


filesystem = Filesystem(
    Current_Directory=".",
    Dash="-",
    Dot=".",
    Main_Configuration_File="config.yml",
    Main_Checks_File="checks.yml",
    Main_Results_File_Name="chasten-results",
    Main_Results_Combined_File_Name="chasten-integrated-results",
    Main_Results_Flattened_Directory_Name="chasten-flattened-csvs-sqlite-db",
    Results_Extension="json",
)


# humanreadable constant
@dataclass(frozen=True)
class Humanreadable:
    """Define the Humanreadable dataclass for constant(s)."""

    Yes: str
    No: str


humanreadable = Humanreadable(Yes="Yes", No="No")


# logger constant
@dataclass(frozen=True)
class Logger:
    """Define the Logger dataclass for constant(s)."""

    Function_Prefix: str
    Richlog: str
    Syslog: str


logger = Logger(
    Function_Prefix="configure_logging_",
    Richlog="chasten-richlog",
    Syslog="chasten-syslog",
)


# logging constant
@dataclass(frozen=True)
class Logging:
    """Define the Logging dataclass for constant(s)."""

    Debug: str
    Info: str
    Warning: str
    Error: str
    Critical: str
    Console_Logging_Destination: str
    Syslog_Logging_Destination: str
    Default_Logging_Destination: str
    Default_Logging_Level: str
    Format: str
    Rich: str


logging = Logging(
    Debug="DEBUG",
    Info="INFO",
    Warning="WARNING",
    Error="ERROR",
    Critical="CRITICAL",
    Console_Logging_Destination="CONSOLE",
    Syslog_Logging_Destination="syslog",
    Default_Logging_Destination="console",
    Default_Logging_Level="ERROR",
    Format="%(message)s",
    Rich="Rich",
)


# markers constant
@dataclass(frozen=True)
class Markers:
    """Define the Markers dataclass for constant(s)."""

    Bad_Fifteen: str
    Bad_Zero_Zero: str
    Code_Context: int
    Comma_Space: str
    Empty_Bytes: bytes
    Empty_String: str
    Ellipse: str
    Forward_Slash: str
    Dot: str
    Hidden: str
    Indent: str
    Newline: str
    Non_Zero_Exit: int
    Nothing: str
    Single_Quote: str
    Slice_One: int
    Small_Bullet_Unicode: str
    Space: str
    Tab: str
    Underscore: str
    Xml: str
    Zero: int
    Zero_Exit: int
    Percent_Multiplier: int


markers = Markers(
    Bad_Fifteen="<15>",
    Bad_Zero_Zero="",
    Code_Context=5,
    Comma_Space=", ",
    Empty_Bytes=b"",
    Empty_String="",
    Ellipse="...",
    Forward_Slash="/",
    Dot=".",
    Hidden=".",
    Indent="   ",
    Newline="\n",
    Non_Zero_Exit=1,
    Nothing="",
    Single_Quote="'",
    Slice_One=1,
    Small_Bullet_Unicode="\u2022",
    Space=" ",
    Tab="\t",
    Underscore="_",
    Xml="xml",
    Zero=0,
    Zero_Exit=0,
    Percent_Multiplier=100,
)


# output constant
@dataclass(frozen=True)
class Output:
    """Define the Output dataclass for constant(s)."""

    Syslog: str
    Test_Start: str


output = Output(
    Syslog=":sparkles: Syslog server for receiving debugging information",
    Test_Start=":sparkles: Start to run test suite for the specified program",
)


# server constant
@dataclass(frozen=True)
class Server:
    """Define the Server dataclass for constant(s)."""

    Backup_Count: int
    Localhost: str
    Log_File: str
    Max_Log_Size: int
    Poll_Interval: float
    Port: int
    Utf8_Encoding: str


server = Server(
    Backup_Count=1,
    Localhost="127.0.0.1",
    Log_File=".discover.log",
    Max_Log_Size=1048576,
    Poll_Interval=0.5,
    Port=2525,
    Utf8_Encoding="utf-8",
)
