# Welcome to the Chasten Contributing Guide

In this guide you will get an overview of how you can contribute to this project.

When contributing to this repository, please first discuss the changes you wish to make via an issue and/or pull request with the owners of this repository.

Please note we have a [Code of Conduct](CODE_OF_CONDUCT.md), please follow it in all your interactions with the project.

To get an overview of the project, read the [README](README.md).

## Issues

If you find a problem with our program, scan through our [existing issues](https://github.com/AstuteSource/chasten/issues) first to see if we are already aware of and working on the issue. If it is an issue that hasn't been addressed before, you can open a new issue using our [bug report issue template](.github/ISSUE_TEMPLATE/bug_report.md).

Even if you have not found a problem you are still welcome to contribute. Look through our [existing issues](https://github.com/AstuteSource/chasten/issues) and find something that you would like to work on!

Have a feature you think should be implemented? Use our [feature request template](.github/ISSUE_TEMPLATE/feature_request.md) to let us know!

### Creating a New Issue

Use our [bug report issue template](.github/ISSUE_TEMPLATE/bug_report.md) when creating a new issue. Be as clear as possible about what exactly the problem is. Explain how you came to encounter this error. Include any relevent code segment, screen shots, error messages, etc. People will not be able to effectivly help solve the problem without all of the information. Learn about creating issues [here](https://docs.github.com/en/issues/tracking-your-work-with-issues/creating-an-issue).

### Existing Issues

If the issue already exists, share any helpful information that you have gained with the other people working on the issue. Be sure to read over the previous disscusions, as to provide your best possible contributions. Any new information could bring us one step closer to solving an issue!

## Making Changes

Any changes being made to our program must first be done in a branch or fork. Once you (and your fellow contributors) are done making changes, you may create a pull request (PR) to the [main repository](https://github.com/AstuteSource/chasten).

### Pre-Commit Hooks

Enabling pre-commit hooks on your system will save you from accidentally making
unwanted changes, such as incorrect formatting, committing merge conflicts, etc.

You can enable pre-commit hooks after installing `poetry`:

```sh
poetry install
poetry run task pre-commit-install # this sets up pre-commit hooks
```

Now, when you make commits, our specific checks will run. This will give you
greater confidence that your contributions align with our standards!

### Branches

Branches are one of the possible features of GitHub that you could use to make changes to our project. Learn about branches [here](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-branches).

### Forks

Another feature of GitHub that you could use to make changes to our project are forks. Learn about forks [here](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/about-forks).

### Pull Requests

Once all your changes are made and you are confident it works, you can create a pull request using our [pull request template](pull_request_template.md). Please include proof of success on all three operating systems (Windows, MacOS, and Linux). A commitee of reviewers will look over the contents of the PR to ensure the accuracy of the changes and that you adhered to our standards.

Learn about pull requests [here](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests).
