#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

char * itoa(unsigned int n, char * buffer, int radix) {
    unsigned int i = 0;
    int rem;

    if (n == 0) {
        buffer[i++] = '0';
        buffer[i] = '\0';
        return buffer;
    }

    while (n) {
        rem = n % radix;
        buffer[i++] = (rem > 9) ? (rem - 10) + 'a' : rem + '0';
        n /= radix;
    }

    buffer[i] = '\0';

    strrev(buffer);

    return buffer;
}
