#include "port.h"

uint8_t inb(uint16_t port) {
    uint8_t result;

    __asm {
        mov dx, port
        in al, dx
        mov result, al
    }

    return result;
} 

uint16_t inw(uint16_t port) {
    uint16_t result;

    __asm {
        mov dx, port
        in ax, dx
        mov result, ax
    }

    return result;
}

void outb(uint16_t port, uint8_t data) {
    __asm {
        mov dx, port
        mov al, data
        out dx, al
    }
}

void outw(uint16_t port, uint16_t data) {
    __asm {
        mov dx, port
        mov ax, data
        out dx, ax
    }
}
