BITS 16

GLOBAL boot_drive
EXTERN load_kernel, vga_print_string, kernel_offset

GLOBAL \
    BS_OEMName, \
    BPB_BytsPerSec, \
    BPB_SecPerClus, \
    BPB_RsvdSecCnt, \
    BPB_NumFATs, \
    BPB_RootEntCnt, \
    BPB_TotSec16, \
    BPB_Media, \
    BPB_FATSz16, \
    BPB_SecPerTrk, \
    BPB_NumHeads, \
    BPB_HiddSec, \
    BPB_TotSec32, \
    BS_DrvNum, \
    BS_Reserved1, \
    BS_BootSig, \
    BS_VolID, \
    BS_VolLab, \
    BS_FilSysType

SECTION CODE CLASS=CODE

..start:

BS_jmpBoot:    jmp near _start
BS_OEMName     db "ArtichOS"
BPB_BytsPerSec dw 512
BPB_SecPerClus db 1
BPB_RsvdSecCnt dw 1
BPB_NumFATs    db 2
BPB_RootEntCnt dw 224
BPB_TotSec16   dw 2880
BPB_Media      db 0xF0
BPB_FATSz16    dw 9
BPB_SecPerTrk  dw 18
BPB_NumHeads   dw 2
BPB_HiddSec    dd 0
BPB_TotSec32   dd 0
BS_DrvNum      db 0
BS_Reserved1   db 0
BS_BootSig     db 0x29
BS_VolID       dd 0xCAFEBEEF
BS_VolLab      db "ArtichOS0.1"
BS_FilSysType  db "FAT 12  "

_start:
    cli

    ;mov ax, DATA
    ;mov ds, ax

    ;mov ax, BPB_DATA
    ;mov es, ax

    mov ax, CODE
    mov ds, ax

    xor ax, ax

    ;mov ds, ax
    mov es, ax

    mov ss, ax
    mov sp, ax

    sti

    mov [boot_drive], dl

    cld

    mov si, welcome_string
    mov bl, 0x0C
    call vga_print_string


    call load_kernel

    xor ax, ax
    mov sp, ax
    call 0:kernel_offset
    hlt
    jmp $

boot_drive db 0x00
welcome_string db `BL ld\n\r`,0

SECTION MAGIC CLASS=MAGIC

dw 0xAA55
