// Talkie library
// Copyright 2011 Peter Knight
// This code is released under GPLv2 license.
//
// Armin Joachimsmeyer 11/2018 converted to .c and .h files
//
// The following phrases are derived from those built into the
// Texas Instruments TI99/4A Speech System add-on from 1979.
//
// A deep male voice with a southern USA accent.
//
// Due to the large vocabulary, this file takes up 32Kbytes of flash.
// It will not fit in most Arduinos as is, so just copy and paste
// out the words you need.
//
// Note that some words/letters are repeated with different spellings.
// eg. 'TWO', 'TO', 'TOO' or 'YOU' and 'U'

#ifndef _TALKIE_VOCAB_US_TI99_H
#define _TALKIE_VOCAB_US_TI99_H

#include <Arduino.h>

extern const uint8_t spt_A[]                 PROGMEM;
extern const uint8_t spt_A1[]                PROGMEM;
extern const uint8_t spt_ABOUT[]             PROGMEM;
extern const uint8_t spt_AFTER[]             PROGMEM;
extern const uint8_t spt_AGAIN[]             PROGMEM;
extern const uint8_t spt_ALL[]               PROGMEM;
extern const uint8_t spt_AM[]                PROGMEM;
extern const uint8_t spt_AN[]                PROGMEM;
extern const uint8_t spt_AND[]               PROGMEM;
extern const uint8_t spt_ANSWER[]            PROGMEM;
extern const uint8_t spt_ANY[]               PROGMEM;
extern const uint8_t spt_ARE[]               PROGMEM;
extern const uint8_t spt_AS[]                PROGMEM;
extern const uint8_t spt_ASSUME[]            PROGMEM;
extern const uint8_t spt_AT[]                PROGMEM;
extern const uint8_t spt_B[]                 PROGMEM;
extern const uint8_t spt_BACK[]              PROGMEM;
extern const uint8_t spt_BASE[]              PROGMEM;
extern const uint8_t spt_BE[]                PROGMEM;
extern const uint8_t spt_BETWEEN[]           PROGMEM;
extern const uint8_t spt_BLACK[]             PROGMEM;
extern const uint8_t spt_BLUE[]              PROGMEM;
extern const uint8_t spt_BOTH[]              PROGMEM;
extern const uint8_t spt_BOTTOM[]            PROGMEM;
extern const uint8_t spt_BUT[]               PROGMEM;
extern const uint8_t spt_BUY[]               PROGMEM;
extern const uint8_t spt_BY[]                PROGMEM;
extern const uint8_t spt_BYE[]               PROGMEM;
extern const uint8_t spt_C[]                 PROGMEM;
extern const uint8_t spt_CAN[]               PROGMEM;
extern const uint8_t spt_CASSETTE[]          PROGMEM;
extern const uint8_t spt_CENTER[]            PROGMEM;
extern const uint8_t spt_CHECK[]             PROGMEM;
extern const uint8_t spt_CHOICE[]            PROGMEM;
extern const uint8_t spt_CLEAR[]             PROGMEM;
extern const uint8_t spt_COLOR[]             PROGMEM;
extern const uint8_t spt_COME[]              PROGMEM;
extern const uint8_t spt_COMES[]             PROGMEM;
extern const uint8_t spt_COMMA[]             PROGMEM;
extern const uint8_t spt_COMMAND[]           PROGMEM;
extern const uint8_t spt_COMPLETE[]          PROGMEM;
extern const uint8_t spt_COMPLETED[]         PROGMEM;
extern const uint8_t spt_COMPUTER[]          PROGMEM;
extern const uint8_t spt_CONNECTED[]         PROGMEM;
extern const uint8_t spt_CONSOLE[]           PROGMEM;
extern const uint8_t spt_CORRECT[]           PROGMEM;
extern const uint8_t spt_COURSE[]            PROGMEM;
extern const uint8_t spt_CYAN[]              PROGMEM;
extern const uint8_t spt_D[]                 PROGMEM;
extern const uint8_t spt_DATA[]              PROGMEM;
extern const uint8_t spt_DECIDE[]            PROGMEM;
extern const uint8_t spt_DEVICE[]            PROGMEM;
extern const uint8_t spt_DID[]               PROGMEM;
extern const uint8_t spt_DIFFERENT[]         PROGMEM;
extern const uint8_t spt_DISKETTE[]          PROGMEM;
extern const uint8_t spt_DO[]                PROGMEM;
extern const uint8_t spt_DOES[]              PROGMEM;
extern const uint8_t spt_DOING[]             PROGMEM;
extern const uint8_t spt_DONE[]              PROGMEM;
extern const uint8_t spt_DOUBLE[]            PROGMEM;
extern const uint8_t spt_DOWN[]              PROGMEM;
extern const uint8_t spt_DRAW[]              PROGMEM;
extern const uint8_t spt_DRAWING[]           PROGMEM;
extern const uint8_t spt_E[]                 PROGMEM;
extern const uint8_t spt_EACH[]              PROGMEM;
extern const uint8_t spt_EIGHT[]             PROGMEM;
extern const uint8_t spt_EIGHTY[]            PROGMEM;
extern const uint8_t spt_ELEVEN[]            PROGMEM;
extern const uint8_t spt_ELSE[]              PROGMEM;
extern const uint8_t spt_END[]               PROGMEM;
extern const uint8_t spt_ENDS[]              PROGMEM;
extern const uint8_t spt_ENTER[]             PROGMEM;
extern const uint8_t spt_ERROR[]             PROGMEM;
extern const uint8_t spt_EXACTLY[]           PROGMEM;
extern const uint8_t spt_EYE[]               PROGMEM;
extern const uint8_t spt_F[]                 PROGMEM;
extern const uint8_t spt_FIFTEEN[]           PROGMEM;
extern const uint8_t spt_FIFTY[]             PROGMEM;
extern const uint8_t spt_FIGURE[]            PROGMEM;
extern const uint8_t spt_FIND[]              PROGMEM;
extern const uint8_t spt_FINE[]              PROGMEM;
extern const uint8_t spt_FINISH[]            PROGMEM;
extern const uint8_t spt_FINISHED[]          PROGMEM;
extern const uint8_t spt_FIRST[]             PROGMEM;
extern const uint8_t spt_FIT[]               PROGMEM;
extern const uint8_t spt_FIVE[]              PROGMEM;
extern const uint8_t spt_FOR[]               PROGMEM;
extern const uint8_t spt_FORTY[]             PROGMEM;
extern const uint8_t spt_FOUR[]              PROGMEM;
extern const uint8_t spt_FOURTEEN[]          PROGMEM;
extern const uint8_t spt_FOURTH[]            PROGMEM;
extern const uint8_t spt_FROM[]              PROGMEM;
extern const uint8_t spt_FRONT[]             PROGMEM;
extern const uint8_t spt_G[]                 PROGMEM;
extern const uint8_t spt_GAMES[]             PROGMEM;
extern const uint8_t spt_GET[]               PROGMEM;
extern const uint8_t spt_GETTING[]           PROGMEM;
extern const uint8_t spt_GIVE[]              PROGMEM;
extern const uint8_t spt_GIVES[]             PROGMEM;
extern const uint8_t spt_GO[]                PROGMEM;
extern const uint8_t spt_GOES[]              PROGMEM;
extern const uint8_t spt_GOING[]             PROGMEM;
extern const uint8_t spt_GOOD[]              PROGMEM;
extern const uint8_t spt_GOOD_WORK[]         PROGMEM;
extern const uint8_t spt_GOODBYE[]           PROGMEM;
extern const uint8_t spt_GOT[]               PROGMEM;
extern const uint8_t spt_GRAY[]              PROGMEM;
extern const uint8_t spt_GREEN[]             PROGMEM;
extern const uint8_t spt_GUESS[]             PROGMEM;
extern const uint8_t spt_H[]                 PROGMEM;
extern const uint8_t spt_HAD[]               PROGMEM;
extern const uint8_t spt_HAND[]              PROGMEM;
extern const uint8_t spt_HANDHELD_UNIT[]     PROGMEM;
extern const uint8_t spt_HAS[]               PROGMEM;
extern const uint8_t spt_HAVE[]              PROGMEM;
extern const uint8_t spt_HEAD[]              PROGMEM;
extern const uint8_t spt_HEAR[]              PROGMEM;
extern const uint8_t spt_HELLO[]             PROGMEM;
extern const uint8_t spt_HELP[]              PROGMEM;
extern const uint8_t spt_HERE[]              PROGMEM;
extern const uint8_t spt_HIGHER[]            PROGMEM;
extern const uint8_t spt_HIT[]               PROGMEM;
extern const uint8_t spt_HOME[]              PROGMEM;
extern const uint8_t spt_HOW[]               PROGMEM;
extern const uint8_t spt_HUNDRED[]           PROGMEM;
extern const uint8_t spt_HURRY[]             PROGMEM;
extern const uint8_t spt_I[]                 PROGMEM;
extern const uint8_t spt_I_WIN[]             PROGMEM;
extern const uint8_t spt_IF[]                PROGMEM;
extern const uint8_t spt_IN[]                PROGMEM;
extern const uint8_t spt_INCH[]              PROGMEM;
extern const uint8_t spt_INCHES[]            PROGMEM;
extern const uint8_t spt_INSTRUCTION[]       PROGMEM;
extern const uint8_t spt_INSTRUCTIONS[]      PROGMEM;
extern const uint8_t spt_IS[]                PROGMEM;
extern const uint8_t spt_IT[]                PROGMEM;
extern const uint8_t spt_J[]                 PROGMEM;
extern const uint8_t spt_JOYSTICK[]          PROGMEM;
extern const uint8_t spt_JUST[]              PROGMEM;
extern const uint8_t spt_K[]                 PROGMEM;
extern const uint8_t spt_KEY[]               PROGMEM;
extern const uint8_t spt_KEYBOARD[]          PROGMEM;
extern const uint8_t spt_KNOW[]              PROGMEM;
extern const uint8_t spt_L[]                 PROGMEM;
extern const uint8_t spt_LARGE[]             PROGMEM;
extern const uint8_t spt_LARGER[]            PROGMEM;
extern const uint8_t spt_LARGEST[]           PROGMEM;
extern const uint8_t spt_LAST[]              PROGMEM;
extern const uint8_t spt_LEARN[]             PROGMEM;
extern const uint8_t spt_LEFT[]              PROGMEM;
extern const uint8_t spt_LESS[]              PROGMEM;
extern const uint8_t spt_LET[]               PROGMEM;
extern const uint8_t spt_LIKE[]              PROGMEM;
extern const uint8_t spt_LIKES[]             PROGMEM;
extern const uint8_t spt_LINE[]              PROGMEM;
extern const uint8_t spt_LOAD[]              PROGMEM;
extern const uint8_t spt_LONG[]              PROGMEM;
extern const uint8_t spt_LOOK[]              PROGMEM;
extern const uint8_t spt_LOOKS[]             PROGMEM;
extern const uint8_t spt_LOWER[]             PROGMEM;
extern const uint8_t spt_M[]                 PROGMEM;
extern const uint8_t spt_MADE[]              PROGMEM;
extern const uint8_t spt_MAGENTA[]           PROGMEM;
extern const uint8_t spt_MAKE[]              PROGMEM;
extern const uint8_t spt_ME[]                PROGMEM;
extern const uint8_t spt_MEAN[]              PROGMEM;
extern const uint8_t spt_MEMORY[]            PROGMEM;
extern const uint8_t spt_MESSAGE[]           PROGMEM;
extern const uint8_t spt_MESSAGES[]          PROGMEM;
extern const uint8_t spt_MIDDLE[]            PROGMEM;
extern const uint8_t spt_MIGHT[]             PROGMEM;
extern const uint8_t spt_MODULE[]            PROGMEM;
extern const uint8_t spt_MORE[]              PROGMEM;
extern const uint8_t spt_MOST[]              PROGMEM;
extern const uint8_t spt_MOVE[]              PROGMEM;
extern const uint8_t spt_MUST[]              PROGMEM;
extern const uint8_t spt_N[]                 PROGMEM;
extern const uint8_t spt_NAME[]              PROGMEM;
extern const uint8_t spt_NEAR[]              PROGMEM;
extern const uint8_t spt_NEED[]              PROGMEM;
extern const uint8_t spt_NEGATIVE[]          PROGMEM;
extern const uint8_t spt_NEXT[]              PROGMEM;
extern const uint8_t spt_NICE_TRY[]          PROGMEM;
extern const uint8_t spt_NINE[]              PROGMEM;
extern const uint8_t spt_NINETY[]            PROGMEM;
extern const uint8_t spt_NO[]                PROGMEM;
extern const uint8_t spt_NOT[]               PROGMEM;
extern const uint8_t spt_NOW[]               PROGMEM;
extern const uint8_t spt_NUMBER[]            PROGMEM;
extern const uint8_t spt_O[]                 PROGMEM;
extern const uint8_t spt_OF[]                PROGMEM;
extern const uint8_t spt_OFF[]               PROGMEM;
extern const uint8_t spt_OH[]                PROGMEM;
extern const uint8_t spt_ON[]                PROGMEM;
extern const uint8_t spt_ONE[]               PROGMEM;
extern const uint8_t spt_ONLY[]              PROGMEM;
extern const uint8_t spt_OR[]                PROGMEM;
extern const uint8_t spt_ORDER[]             PROGMEM;
extern const uint8_t spt_OTHER[]             PROGMEM;
extern const uint8_t spt_OUT[]               PROGMEM;
extern const uint8_t spt_OVER[]              PROGMEM;
extern const uint8_t spt_P[]                 PROGMEM;
extern const uint8_t spt_PART[]              PROGMEM;
extern const uint8_t spt_PARTNER[]           PROGMEM;
extern const uint8_t spt_PARTS[]             PROGMEM;
extern const uint8_t spt_PERIOD[]            PROGMEM;
extern const uint8_t spt_PLAY[]              PROGMEM;
extern const uint8_t spt_PLAYS[]             PROGMEM;
extern const uint8_t spt_PLEASE[]            PROGMEM;
extern const uint8_t spt_POINT[]             PROGMEM;
extern const uint8_t spt_POSITION[]          PROGMEM;
extern const uint8_t spt_POSITIVE[]          PROGMEM;
extern const uint8_t spt_PRESS[]             PROGMEM;
extern const uint8_t spt_PRINT[]             PROGMEM;
extern const uint8_t spt_PRINTER[]           PROGMEM;
extern const uint8_t spt_PROBLEM[]           PROGMEM;
extern const uint8_t spt_PROBLEMS[]          PROGMEM;
extern const uint8_t spt_PROGRAM[]           PROGMEM;
extern const uint8_t spt_PUT[]               PROGMEM;
extern const uint8_t spt_PUTTING[]           PROGMEM;
extern const uint8_t spt_Q[]                 PROGMEM;
extern const uint8_t spt_R[]                 PROGMEM;
extern const uint8_t spt_RANDOMLY[]          PROGMEM;
extern const uint8_t spt_READ[]              PROGMEM;
extern const uint8_t spt_READ1[]             PROGMEM;
extern const uint8_t spt_READY_TO_START[]    PROGMEM;
extern const uint8_t spt_RECORDER[]          PROGMEM;
extern const uint8_t spt_RED[]               PROGMEM;
extern const uint8_t spt_REFER[]             PROGMEM;
extern const uint8_t spt_REMEMBER[]          PROGMEM;
extern const uint8_t spt_RETURN[]            PROGMEM;
extern const uint8_t spt_REWIND[]            PROGMEM;
extern const uint8_t spt_RIGHT[]             PROGMEM;
extern const uint8_t spt_ROUND[]             PROGMEM;
extern const uint8_t spt_S[]                 PROGMEM;
extern const uint8_t spt_SAID[]              PROGMEM;
extern const uint8_t spt_SAVE[]              PROGMEM;
extern const uint8_t spt_SAY[]               PROGMEM;
extern const uint8_t spt_SAYS[]              PROGMEM;
extern const uint8_t spt_SCREEN[]            PROGMEM;
extern const uint8_t spt_SECOND[]            PROGMEM;
extern const uint8_t spt_SEE[]               PROGMEM;
extern const uint8_t spt_SEES[]              PROGMEM;
extern const uint8_t spt_SET[]               PROGMEM;
extern const uint8_t spt_SEVEN[]             PROGMEM;
extern const uint8_t spt_SEVENTY[]           PROGMEM;
extern const uint8_t spt_SHAPE[]             PROGMEM;
extern const uint8_t spt_SHAPES[]            PROGMEM;
extern const uint8_t spt_SHIFT[]             PROGMEM;
extern const uint8_t spt_SHORT[]             PROGMEM;
extern const uint8_t spt_SHORTER[]           PROGMEM;
extern const uint8_t spt_SHOULD[]            PROGMEM;
extern const uint8_t spt_SIDE[]              PROGMEM;
extern const uint8_t spt_SIDES[]             PROGMEM;
extern const uint8_t spt_SIX[]               PROGMEM;
extern const uint8_t spt_SIXTY[]             PROGMEM;
extern const uint8_t spt_SMALL[]             PROGMEM;
extern const uint8_t spt_SMALLER[]           PROGMEM;
extern const uint8_t spt_SMALLEST[]          PROGMEM;
extern const uint8_t spt_SO[]                PROGMEM;
extern const uint8_t spt_SOME[]              PROGMEM;
extern const uint8_t spt_SORRY[]             PROGMEM;
extern const uint8_t spt_SPACE[]             PROGMEM;
extern const uint8_t spt_SPACES[]            PROGMEM;
extern const uint8_t spt_SPELL[]             PROGMEM;
extern const uint8_t spt_SQUARE[]            PROGMEM;
extern const uint8_t spt_START[]             PROGMEM;
extern const uint8_t spt_STEP[]              PROGMEM;
extern const uint8_t spt_STOP[]              PROGMEM;
extern const uint8_t spt_SUM[]               PROGMEM;
extern const uint8_t spt_SUPPOSED[]          PROGMEM;
extern const uint8_t spt_SUPPOSED_TO[]       PROGMEM;
extern const uint8_t spt_SURE[]              PROGMEM;
extern const uint8_t spt_T[]                 PROGMEM;
extern const uint8_t spt_TAKE[]              PROGMEM;
extern const uint8_t spt_TEEN[]              PROGMEM;
extern const uint8_t spt_TELL[]              PROGMEM;
extern const uint8_t spt_TEN[]               PROGMEM;
extern const uint8_t spt_TEXAS_INSTRUMENTS[] PROGMEM;
extern const uint8_t spt_THAN[]              PROGMEM;
extern const uint8_t spt_THAT[]              PROGMEM;
extern const uint8_t spt_THAT_IS_INCORRECT[] PROGMEM;
extern const uint8_t spt_THAT_IS_RIGHT[]     PROGMEM;
extern const uint8_t spt_THE[]               PROGMEM;
extern const uint8_t spt_THE1[]              PROGMEM;
extern const uint8_t spt_THEIR[]             PROGMEM;
extern const uint8_t spt_THEN[]              PROGMEM;
extern const uint8_t spt_THERE[]             PROGMEM;
extern const uint8_t spt_THESE[]             PROGMEM;
extern const uint8_t spt_THEY[]              PROGMEM;
extern const uint8_t spt_THING[]             PROGMEM;
extern const uint8_t spt_THINGS[]            PROGMEM;
extern const uint8_t spt_THINK[]             PROGMEM;
extern const uint8_t spt_THIRD[]             PROGMEM;
extern const uint8_t spt_THIRTEEN[]          PROGMEM;
extern const uint8_t spt_THIRTY[]            PROGMEM;
extern const uint8_t spt_THIS[]              PROGMEM;
extern const uint8_t spt_THREE[]             PROGMEM;
extern const uint8_t spt_THREW[]             PROGMEM;
extern const uint8_t spt_THROUGH[]           PROGMEM;
extern const uint8_t spt_TIME[]              PROGMEM;
extern const uint8_t spt_TO[]                PROGMEM;
extern const uint8_t spt_TOGETHER[]          PROGMEM;
extern const uint8_t spt_TONE[]              PROGMEM;
extern const uint8_t spt_TOO[]               PROGMEM;
extern const uint8_t spt_TOP[]               PROGMEM;
extern const uint8_t spt_TRY[]               PROGMEM;
extern const uint8_t spt_TRY_AGAIN[]         PROGMEM;
extern const uint8_t spt_TURN[]              PROGMEM;
extern const uint8_t spt_TWELVE[]            PROGMEM;
extern const uint8_t spt_TWENTY[]            PROGMEM;
extern const uint8_t spt_TWO[]               PROGMEM;
extern const uint8_t spt_TYPE[]              PROGMEM;
extern const uint8_t spt_U[]                 PROGMEM;
extern const uint8_t spt_UHOH[]              PROGMEM;
extern const uint8_t spt_UNDER[]             PROGMEM;
extern const uint8_t spt_UNDERSTAND[]        PROGMEM;
extern const uint8_t spt_UNTIL[]             PROGMEM;
extern const uint8_t spt_UP[]                PROGMEM;
extern const uint8_t spt_UPPER[]             PROGMEM;
extern const uint8_t spt_USE[]               PROGMEM;
extern const uint8_t spt_V[]                 PROGMEM;
extern const uint8_t spt_VARY[]              PROGMEM;
extern const uint8_t spt_VERY[]              PROGMEM;
extern const uint8_t spt_W[]                 PROGMEM;
extern const uint8_t spt_WAIT[]              PROGMEM;
extern const uint8_t spt_WANT[]              PROGMEM;
extern const uint8_t spt_WANTS[]             PROGMEM;
extern const uint8_t spt_WAY[]               PROGMEM;
extern const uint8_t spt_WE[]                PROGMEM;
extern const uint8_t spt_WEIGH[]             PROGMEM;
extern const uint8_t spt_WEIGHT[]            PROGMEM;
extern const uint8_t spt_WELL[]              PROGMEM;
extern const uint8_t spt_WERE[]              PROGMEM;
extern const uint8_t spt_WHAT[]              PROGMEM;
extern const uint8_t spt_WHAT_WAS_THAT[]     PROGMEM;
extern const uint8_t spt_WHEN[]              PROGMEM;
extern const uint8_t spt_WHERE[]             PROGMEM;
extern const uint8_t spt_WHICH[]             PROGMEM;
extern const uint8_t spt_WHITE[]             PROGMEM;
extern const uint8_t spt_WHO[]               PROGMEM;
extern const uint8_t spt_WHY[]               PROGMEM;
extern const uint8_t spt_WILL[]              PROGMEM;
extern const uint8_t spt_WITH[]              PROGMEM;
extern const uint8_t spt_WON[]               PROGMEM;
extern const uint8_t spt_WORD[]              PROGMEM;
extern const uint8_t spt_WORDS[]             PROGMEM;
extern const uint8_t spt_WORK[]              PROGMEM;
extern const uint8_t spt_WORKING[]           PROGMEM;
extern const uint8_t spt_WRITE[]             PROGMEM;
extern const uint8_t spt_X[]                 PROGMEM;
extern const uint8_t spt_Y[]                 PROGMEM;
extern const uint8_t spt_YELLOW[]            PROGMEM;
extern const uint8_t spt_YES[]               PROGMEM;
extern const uint8_t spt_YET[]               PROGMEM;
extern const uint8_t spt_YOU[]               PROGMEM;
extern const uint8_t spt_YOU_WIN[]           PROGMEM;
extern const uint8_t spt_YOUR[]              PROGMEM;
extern const uint8_t spt_Z[]                 PROGMEM;
extern const uint8_t spt_ZERO[]              PROGMEM;
#endif // _TALKIE_VOCAB_US_TI99_H
