// Talkie library
// Copyright 2011 Peter Knight
// This code is released under GPLv2 license.
//
// Armin Joachimsmeyer 11/2018 converted to .c and .h files and made them unique.
//
// The following phrases are derived from those built into the
// Texas Instruments TI99/4A Speech System add-on from 1979.
//
// A deep male voice with a southern USA accent.
//
// Due to the large vocabulary, this file takes up 32Kbytes of flash.
// It will not fit in most Arduinos as is, so just copy and paste
// out the words you need.
//
// Note that some words/letters are repeated with different spellings.
// eg. 'TWO', 'TO', 'TOO' or 'YOU' and 'U'

#include <Arduino.h>

extern const uint8_t spt_A[]                 PROGMEM ={ 0xA7,0x8A,0xCE,0x25,0xA7,0x2A,0xDD,0x62,0xE7,0x3B,0xBF,0xF9,0xAD,0x56,0xD5,0x72,0xA0,0x44,0x7D,0x99,0x4D,0xED,0xFC,0xE0,0x87,0x07,0x00,0x00};
extern const uint8_t spt_A1[]                PROGMEM ={ 0xAD,0x36,0x25,0x46,0x7C,0x2C,0xCD,0x66,0x36,0xB3,0xED,0x6D,0xEF,0x72,0xE7,0xBB,0xD8,0x3F,0x00,0x00};
extern const uint8_t spt_ABOUT[]             PROGMEM ={0xA1,0x08,0x2E,0xCF,0x4A,0xDB,0xF7,0x62,0x54,0xC9,0xC6,0xB9,0xC9,0xDA,0x56,0x45,0xE3,0x1B,0xCE,0x5D,0x55,0x2D,0x43,0x06,0xAA,0xA7,0x86,0x51,0x05,0x95,0xED,0x26,0xBB,0x57,0xE5,0x6D,0xB5,0xAB,0xBD,0xDE,0xD5,0xAE,0x4E,0xE5,0xFD,0xB4,0x69,0xD4,0x9D,0x55,0xAF,0x4A,0x6D,0xC2,0x8E,0x48,0xD4,0x75,0xB5,0x35,0xF3,0xAC,0x36,0x47,0xD4,0xA2,0xB7,0x4B,0x87,0x65,0x00,0x00,0x02,0x64,0xED,0x81,0x80,0xA3,0xDD,0x10,0xE0,0x4D,0x18,0xC0,0x03};
extern const uint8_t spt_AFTER[]             PROGMEM ={0x25,0x8B,0x23,0xC3,0xA1,0xC3,0x9C,0x2C,0xF6,0x32,0xE7,0xAA,0x7A,0xB3,0x9B,0xDF,0xE2,0x56,0xB5,0x31,0x80,0x15,0xC6,0x1A,0xD0,0x00,0x80,0x01,0x8A,0x32,0x4F,0x85,0x5F,0xEC,0x96,0x9A,0xBD,0xD7,0xB5,0xCB,0x83,0x1B,0xEC,0xA0,0x88,0x8C,0x74,0x62,0xB4,0x03,0xAA,0x2C,0x12,0xB3,0xC9,0x76,0xD6,0xCC,0x70,0xF2};
extern const uint8_t spt_AGAIN[]             PROGMEM ={0x08,0xD0,0xD1,0xBD,0x55,0xAE,0xA7,0x73,0x54,0xAD,0x53,0xC5,0x18,0xE1,0xA2,0x4B,0x4F,0x9D,0x42,0xA8,0x89,0x76,0x6D,0xB5,0xB7,0x22,0x21,0xE9,0xAD,0x36,0xB3,0x1D,0x4D,0xB1,0x22,0xAE,0x97,0xA4,0xE7,0x23,0x2B,0x89,0x5D,0x63,0x92,0xEC,0x6C,0xA7,0x23,0x2D,0xD5,0x42,0x74,0x14,0xCF,0x6C,0xE4,0xA9,0x45,0x08,0x8D,0xE3,0x5D,0xEF,0x66,0xB4,0xB1,0x67,0xB2,0x66,0xE2,0xD9,0x8F,0x3E,0x8C,0x08,0xF2,0x8C,0x1B,0x06,0xE9,0xA5,0xCC,0x46,0xB6,0x1F,0xEC,0x20,0x07,0x34,0xD0,0x10,0x99,0xDA,0x92,0x1E,0x00,0x00};
extern const uint8_t spt_ALL[]               PROGMEM ={0x29,0xB1,0xE6,0x57,0xB9,0xE6,0xD4,0xB4,0xA7,0x23,0x35,0xEE,0xD6,0xD8,0x9B,0xCE,0x74,0x66,0xB3,0x9A,0xD5,0xAC,0x4B,0x23,0xEB,0x8C,0x62,0x3B,0xA9,0x5D,0xE8,0xC4,0xDA,0x56,0x28,0x65,0xBE,0xD7,0xBD,0xEC,0x1F};
extern const uint8_t spt_AM[]                PROGMEM ={0xA3,0x28,0x4D,0xDD,0x64,0x15,0x9D,0xA2,0x34,0x0B,0xD5,0x4A,0x74,0xAA,0x3C,0x2D,0x44,0x2A,0xD5,0xAD,0x6E,0x75,0xAA,0xD4,0xB5,0x59,0x33,0xCE,0xAD,0x4F,0x1D,0x6B,0x94,0x9A,0x57,0xD9,0xED,0x68,0x6D,0xA9,0x56,0xC9,0xD8,0xAD,0x35,0x8E,0x4B,0xC5,0x54,0xFB,0xCE,0x77,0xA6,0xD3,0x8E,0x4A,0xC3,0xDD,0x98,0x4E,0x7A,0x49,0xE5,0x76,0xEA,0x3B,0xDD,0x3F,0x00,0x00};
extern const uint8_t spt_AN[]                PROGMEM ={0xA3,0xCA,0xD3,0x4C,0xBC,0x22,0xDF,0x62,0x15,0x65,0x99,0xB3,0x4E,0x9C,0x5D,0xDC,0xE2,0x54,0x65,0x78,0x32,0x77,0xE2,0x5B,0xED,0x6A,0xD7,0xA3,0x8D,0x4D,0x43,0x39,0x13,0xA5,0xD6,0x7A,0x6A,0xD1,0x76,0x63,0x3B,0xDB,0xAB,0x5E,0x06,0x0E,0x95,0x49,0xAC,0x7B,0xDD,0x3F,0x00,0x00};
extern const uint8_t spt_AND[]               PROGMEM ={0xA1,0xC8,0xD3,0x4C,0xBC,0x22,0xCF,0x62,0xE4,0x65,0x99,0xB3,0x4E,0x9C,0x9B,0xCD,0xAC,0x65,0x65,0x78,0x32,0x77,0xE2,0x96,0x97,0x58,0x2A,0x66,0xB3,0x5B,0x95,0x53,0xB1,0x9A,0x4D,0x69,0x75,0x2A,0x69,0xA2,0x3A,0xA7,0x35,0x31,0x97,0x91,0xD9,0xAC,0xD4,0x25,0x5F,0x85,0x2E,0xB3,0x43,0xAF,0x83,0x9A,0x9A,0xD7,0x76,0xBD,0x0A,0x5C,0x62,0xE3,0xC0,0xF5,0x32,0x70,0x89,0x77,0x2C,0xD3,0x4B,0x47,0x6D,0x3A,0xB1,0xD4,0xA0,0x2D,0xAE,0xD9,0x44,0x92,0x23,0x9F,0xC2,0x54,0x94,0x8B,0x78,0x6C,0xD0,0xA3,0x18,0x52,0x4C,0x75,0xCD,0x5A,0x0F};
extern const uint8_t spt_ANSWER[]            PROGMEM ={0xA5,0x88,0x59,0x2B,0xBC,0x2A,0xDE,0xEA,0x14,0x69,0x78,0x8A,0x56,0x9C,0x9B,0xEF,0x7C,0x64,0x3E,0x25,0x05,0x67,0x3D,0x97,0x5A,0xCF,0xEE,0x78,0x6D,0x75,0x96,0xAA,0x9E,0x2B,0x4D,0x4D,0xB1,0x01,0x6E,0x50,0xF3,0x40,0x06,0x1C,0x70,0xB2,0x7B,0x6B,0x62,0x4C,0x53,0x0D,0xB7,0xA5,0x75,0x5D,0x4C,0x5B,0x9B,0x85,0x5E,0x77,0xCA,0x2C,0xCF,0x65,0x06,0xDD,0x71,0xDA,0xA3,0x95,0x1A,0x64,0xE7,0xDC,0x0C,0x99,0x0F};
extern const uint8_t spt_ANY[]               PROGMEM ={0xA7,0xAA,0x2D,0x53,0x54,0xD7,0xDE,0xEA,0x16,0xB7,0x28,0x45,0x88,0x92,0xAC,0xA3,0xAA,0x14,0x65,0x79,0x08,0xE6,0xD2,0x5B,0xAD,0xB6,0x2E,0x31,0xC1,0x9C,0xD3,0xBA,0x56,0x95,0xD5,0x7A,0x72,0x18,0x52,0x20,0xF3,0xDA,0x00,0x66,0xF0,0x52,0xB5,0xDA,0x0D,0xAB,0xD1,0x3B,0xE2,0x2D,0xB3,0xA2,0xC6,0xC0,0x9D,0xD9,0xCB,0xB5,0x98,0xBC,0x52,0x76,0xCF,0x34,0x0F};
extern const uint8_t spt_ARE[]               PROGMEM ={0xA7,0x70,0xB1,0xCE,0x29,0xD2,0xDD,0xFC,0xE6,0x37,0xBF,0xC5,0xA9,0x7C,0xC8,0x4E,0x95,0xE6,0xB7,0x3A,0x8D,0xAF,0x1E,0x19,0x9C,0xFC,0x76,0xAD,0xB3,0x43,0x32,0xDD,0xEA,0xE4,0xCE,0xF5,0xBE,0x2A,0x6B,0x73,0x22,0xD3,0xC5,0xE9,0x2C,0xCA,0xAE,0x1E,0x00,0x00};
extern const uint8_t spt_AS[]                PROGMEM ={0x27,0x2F,0x3D,0x53,0xD5,0x96,0x9E,0xA2,0xF4,0x4C,0x55,0x9F,0x77,0x8B,0x53,0x84,0x9E,0x29,0x96,0x4D,0x6F,0x75,0xAB,0x55,0xFB,0xE2,0x29,0x96,0x63,0x77,0xD3,0xDB,0xDE,0xE6,0x36,0xB4,0xAA,0x78,0x5A,0x54,0x58,0xD7,0xAA,0xE4,0xE1,0x31,0x91,0x4C,0x6B,0x79,0x59,0xE8,0xA4,0xC8,0xAD,0x02,0x16,0x11,0x95,0x00,0x07,0x28,0x40,0x81,0x07};
extern const uint8_t spt_ASSUME[]            PROGMEM ={0xAD,0x31,0x29,0x43,0x23,0x27,0xCF,0xA6,0x37,0xA5,0xB1,0x3E,0x52,0x3D,0x2E,0xE5,0xC1,0x01,0x19,0x84,0x79,0xC0,0x03,0x0E,0x78,0x2E,0x3C,0x03,0x1E,0x68,0xA1,0xD5,0x19,0x1A,0xD9,0x6B,0x26,0x3D,0xE9,0x69,0xCD,0x7A,0x51,0xAB,0x52,0x1B,0xC7,0xA5,0x62,0xAA,0x73,0x1B,0x3B,0xDF,0xFB,0xC1,0x8E,0x76,0xB4,0xD3,0x03};
extern const uint8_t spt_AT[]                PROGMEM ={0x2B,0x8B,0xC9,0x3A,0x3D,0xA7,0xDC,0xE2,0x16,0xB7,0xD8,0x55,0x6F,0x62,0x03,0x00,0x0A,0xC8,0xCA,0xC5,0x00,0x4B,0xB8,0x11,0xC0,0xA9,0x60,0x80,0x07};
extern const uint8_t spt_B[]                 PROGMEM ={0xAB,0xED,0xD1,0x14,0x5D,0xBB,0xAD,0xB6,0x45,0x57,0xF0,0xDE,0x3A,0x9A,0x59,0x94,0x31,0x62,0xCD,0x6E,0x76,0xB3,0x9B,0xD9,0xF4,0xB6,0xB6,0xB1,0xB7,0x3D,0xEF,0x1F,0x00,0x00};
extern const uint8_t spt_BACK[]              PROGMEM ={0xA7,0x4D,0x59,0xCB,0x39,0xD6,0x9D,0x21,0x54,0x6D,0x93,0xCE,0x76,0x86,0x54,0xAD,0xCD,0x3A,0xED,0xED,0x6F,0x77,0xDB,0xDB,0xDE,0x2A,0x17,0x00,0x08,0xD0,0xC2,0x44,0x01,0x21,0x8B,0x0A,0x20,0x79,0x27,0x04,0xB8,0x28,0xFC};
extern const uint8_t spt_BASE[]              PROGMEM ={0xA6,0xE6,0x3C,0x23,0x3D,0x12,0x9C,0x2A,0xE5,0x08,0x36,0xEE,0x76,0xAA,0x9C,0x4D,0x34,0xF2,0xE9,0xAD,0x4F,0x9D,0x93,0xB1,0x66,0x2E,0x5D,0x75,0xF6,0xC6,0x52,0x39,0xFB,0xD6,0xAD,0xC9,0x4A,0xC5,0x37,0x26,0xB7,0x36,0x67,0x15,0xD1,0x5A,0x92,0xBA,0xA9,0xCD,0x98,0xA2,0x8D,0x02,0x2E,0x17,0x51,0xC0,0xB3,0x2A,0x06,0xF8,0xD1,0xD4,0x00,0xBF,0x39,0x1B,0xE0,0x65,0x25,0x05,0x2C,0xD9,0x86,0x00,0x9B,0x0A,0x1E};
extern const uint8_t spt_BE[]                PROGMEM ={0xAB,0xED,0xD1,0x14,0x5D,0xBB,0xAD,0xB6,0x45,0x57,0xF0,0xDE,0x3A,0x9A,0x59,0x94,0x31,0x62,0xCD,0x6E,0x76,0xB3,0x9B,0xD9,0xF4,0xB6,0xB6,0xB1,0xB7,0x3D,0xEF,0x1F,0x00,0x00};
extern const uint8_t spt_BETWEEN[]           PROGMEM ={0xA1,0x86,0xA6,0x33,0x23,0x1C,0x9D,0xA2,0x5A,0x0B,0x4E,0xED,0x77,0xAA,0x6A,0xCD,0xD9,0x65,0xAF,0xE9,0x24,0x8D,0xB4,0x8A,0x54,0xC0,0x80,0x51,0x35,0x19,0x90,0x43,0x15,0x01,0xFC,0x34,0x43,0x00,0xEB,0xC2,0x2D,0xF3,0x22,0x33,0x1C,0x3A,0xAF,0x3C,0xE9,0x52,0x35,0xEE,0xBC,0x8A,0x9A,0x1C,0xA5,0xA2,0xF3,0xAC,0x56,0x35,0x6A,0x30,0x78,0xB4,0xDE,0xF5,0x6E,0x76,0xBB,0xBB,0xD9,0x85,0xCE,0x79,0xB2,0x0C,0x9D,0xED,0x5A,0x6B,0x61,0xC3,0xCA,0xB6,0x69,0xA4,0xE5,0x73,0x6B,0x4B,0xAA,0xE1,0x46,0xA7,0x34,0x63,0x88,0x46,0x2A,0x89,0xD6,0x4C,0xFC};
extern const uint8_t spt_BLACK[]             PROGMEM ={0xA4,0x12,0xBC,0x32,0x22,0x9C,0x94,0xDA,0x78,0x3B,0xD2,0xF4,0xBC,0xAA,0x60,0x65,0x0B,0x3D,0xDD,0xA9,0xAC,0x8B,0x4D,0xC8,0xA4,0xA7,0xF2,0xC9,0x4E,0x64,0xDC,0xDE,0xFA,0xD4,0xA1,0xF9,0x48,0xB4,0x9B,0xDB,0xEE,0xAE,0xF4,0xA1,0x73,0x5A,0x96,0xA1,0x3A,0xD8,0x01,0x40,0x00,0x71,0x38,0x09,0x20,0x16,0x05,0x06,0x24,0x9F,0x80,0x00,0x17,0x94,0x1E};
extern const uint8_t spt_BLUE[]              PROGMEM ={0x2D,0x0B,0x81,0xC7,0x94,0xD5,0x8F,0x2A,0x27,0x1C,0x27,0x71,0x3F,0xAB,0x55,0x59,0x97,0xA1,0x22,0x79,0x77,0xB5,0xAB,0x59,0xCF,0xB6,0x77,0xA1,0x17,0xB6,0x4B,0x03,0xB3,0xFB,0x9E,0x0D,0x2C,0x6C,0x4A,0x67,0x92,0x07,0x00,0x00};
extern const uint8_t spt_BOTH[]              PROGMEM ={0xA2,0x45,0x29,0xCD,0xAC,0xD2,0xAE,0x5A,0xFB,0x3C,0xA5,0xC8,0x73,0xAB,0x5B,0xAD,0x4A,0xB9,0xBA,0x40,0xEF,0xBA,0xEB,0x5E,0xA7,0x56,0x94,0x2E,0x21,0x7F,0x9E,0x3B,0xDB,0xC9,0x01,0x08,0x10,0xA5,0x8B,0x02,0x52,0x88,0xD2,0x80,0x01,0xB2,0x6B,0x23,0x80,0x6B,0xC1,0xF0};
extern const uint8_t spt_BOTTOM[]            PROGMEM ={0xA2,0x23,0xA2,0x3C,0x2C,0x9C,0xAF,0xCA,0xBB,0x7C,0x09,0x9D,0x73,0xAB,0x5D,0xAD,0xDA,0xA6,0x3A,0x36,0xAF,0xBB,0x9B,0xDE,0x28,0x40,0xAA,0x54,0x09,0x94,0xDA,0x36,0x5F,0xF2,0x70,0xD3,0xEB,0xDA,0xC4,0xD6,0x75,0xDA,0xEB,0xB0,0x97,0x1A,0xDF,0xD9,0x4E,0x0E,0x7C,0x78,0x00,0x00};
extern const uint8_t spt_BUT[]               PROGMEM ={0xAA,0xC5,0xA6,0xCC,0x2D,0xD2,0xAE,0x2A,0x18,0x7F,0x2B,0x59,0xBD,0xAB,0x5B,0xDD,0xEA,0xD6,0xB3,0x4E,0x8D,0xAD,0xE6,0x92,0x13,0x5A,0x36,0x00,0x00,0x0E,0xC8,0xCC,0x0D,0x01,0xDA,0x3B,0xC3,0x03,0x00,0x00};
extern const uint8_t spt_BUY[]               PROGMEM ={0xAE,0xC2,0xA6,0xCC,0x2D,0xD2,0x9E,0xC2,0xA7,0x78,0x91,0xC8,0x74,0xAB,0x53,0xB9,0x34,0xA3,0x30,0x8E,0x6F,0x75,0xAB,0x5B,0x9D,0xDA,0x95,0x6E,0x93,0xB1,0x7F,0xEB,0xDB,0xAC,0x2E,0x4C,0x4B,0xC9,0x96,0xDC,0xBB,0xD6,0x85,0xE2,0x61,0x19,0xA5,0x5B,0x1F,0x8A,0xA9,0x77,0x44,0xEE,0x7D,0xEE,0x62,0x2F,0xFB,0x07,0x00,0x00};
extern const uint8_t spt_BY[]                PROGMEM ={0xAE,0xC2,0xA6,0xCC,0x2D,0xD2,0x9E,0xC2,0xA7,0x78,0x91,0xC8,0x74,0xAB,0x53,0xB9,0x34,0xA3,0x30,0x8E,0x6F,0x75,0xAB,0x5B,0x9D,0xDA,0x95,0x6E,0x93,0xB1,0x7F,0xEB,0xDB,0xAC,0x2E,0x4C,0x4B,0xC9,0x96,0xDC,0xBB,0xD6,0x85,0xE2,0x61,0x19,0xA5,0x5B,0x1F,0x8A,0xA9,0x77,0x44,0xEE,0x7D,0xEE,0x62,0x2F,0xFB,0x07,0x00,0x00};
extern const uint8_t spt_BYE[]               PROGMEM ={0xAE,0xC2,0xA6,0xCC,0x2D,0xD2,0x9E,0xC2,0xA7,0x78,0x91,0xC8,0x74,0xAB,0x53,0xB9,0x34,0xA3,0x30,0x8E,0x6F,0x75,0xAB,0x5B,0x9D,0xDA,0x95,0x6E,0x93,0xB1,0x7F,0xEB,0xDB,0xAC,0x2E,0x4C,0x4B,0xC9,0x96,0xDC,0xBB,0xD6,0x85,0xE2,0x61,0x19,0xA5,0x5B,0x1F,0x8A,0xA9,0x77,0x44,0xEE,0x7D,0xEE,0x62,0x2F,0xFB,0x07,0x00,0x00};
extern const uint8_t spt_C[]                 PROGMEM ={0x08,0xD0,0xB4,0x42,0x00,0x8B,0x88,0x3A,0xE0,0x2B,0xD5,0x00,0xFC,0x18,0xE6,0x81,0x08,0x78,0xC0,0x00,0x4F,0xAB,0x1C,0xA7,0xF8,0x60,0x31,0x7D,0x73,0xE2,0x1A,0x93,0xD8,0xED,0xEB,0x8D,0x6F,0x72,0xB3,0x51,0xF4,0x9A,0x02,0x1A,0x6F,0x77,0xB5,0xEB,0xD9,0x94,0xB6,0x34,0x22,0xA9,0xA9,0x93,0xBB,0xD0,0x25,0xC7,0x94,0x97,0xA1,0x4D,0xE7,0x95,0xF0,0x9E,0x18,0x35,0x5D,0xF4,0xA0,0xD3,0x29,0x4C,0x75,0xC1,0x82,0x86,0xB9,0xB3,0x07};
extern const uint8_t spt_CAN[]               PROGMEM ={0x0C,0x68,0x42,0xCC,0x00,0x33,0x2A,0x3B,0x20,0x69,0xD5,0x92,0xE6,0xE9,0xA6,0x9A,0x75,0x6F,0x75,0xAB,0x53,0xA5,0x6E,0x2E,0x5E,0x51,0x6F,0x7D,0x9B,0xDB,0xEC,0x66,0xB7,0xB3,0xE9,0x4D,0xAA,0xAD,0xA7,0x16,0x6D,0x37,0xB9,0xCE,0xB5,0xAB,0x64,0xE0,0x50,0x99,0xC4,0xBE,0xE6,0xCD,0x03};
extern const uint8_t spt_CASSETTE[]          PROGMEM ={0x0E,0xF0,0x25,0x48,0x03,0x1A,0x68,0xB9,0x49,0xCD,0xE1,0x1D,0xAB,0x56,0x06,0x58,0xD6,0xCD,0x02,0x16,0x70,0xC0,0xB7,0x19,0x16,0x90,0x40,0xAB,0xDC,0x30,0xF7,0xE8,0xBA,0xBB,0xDE,0xF5,0x6C,0x46,0xED,0x9A,0x85,0x79,0xC7,0xA9,0x95,0xAC,0x40,0x03,0x1E,0x20,0x80,0x54,0xA9,0x18,0x78};
extern const uint8_t spt_CENTER[]            PROGMEM ={0x02,0xF8,0x92,0x55,0x00,0xF7,0x1A,0x2A,0xE0,0x17,0x45,0x03,0xFC,0x16,0xEA,0x80,0x9F,0xD4,0x18,0x60,0x9A,0xEA,0xC9,0x43,0x2F,0x76,0xF5,0xAE,0xB7,0xBA,0xD5,0xA8,0xBC,0x57,0x4B,0x88,0x3A,0xB1,0x49,0x40,0x75,0x1E,0xAD,0x76,0x4D,0x34,0xD2,0x3A,0xDF,0x66,0x36,0xBD,0xA9,0x4D,0xAC,0x75,0x2D,0x9B,0x07};
extern const uint8_t spt_CHECK[]             PROGMEM ={0x0E,0x98,0xBD,0x32,0x03,0x11,0x60,0x00,0x73,0x1E,0x23,0x0E,0xD9,0xCD,0x33,0xC7,0xEC,0x74,0xA7,0x3B,0x9F,0x55,0x6F,0x7C,0x03,0x00,0x16,0xE0,0x00,0x06,0x30,0xF0};
extern const uint8_t spt_CHOICE[]            PROGMEM ={0x06,0x98,0xA9,0x2A,0x03,0x16,0x40,0x00,0x9B,0x9D,0x2B,0xB6,0x26,0x3B,0x92,0xF3,0xEE,0x64,0xA7,0x2B,0x8B,0x3A,0xC7,0x83,0xB3,0xED,0x6A,0xD5,0x31,0x8E,0x7A,0x50,0xE7,0xD9,0xB5,0x21,0x99,0x74,0x2D,0x6F,0x5C,0x06,0x5F,0x9C,0xD2,0x3B,0x4A,0x18,0x63,0x70,0x11,0x89,0x19,0x04,0xF8,0x5E,0x48,0x03,0x1A,0xB0,0x80,0x06,0x24,0x40,0x81,0x07,0x00,0x00};
extern const uint8_t spt_CLEAR[]             PROGMEM ={0x02,0x08,0xB1,0x28,0x00,0xDE,0x47,0x06,0xA0,0x3A,0x2B,0x01,0x38,0x5F,0xB9,0x62,0xA3,0x3A,0x25,0xA4,0xED,0x4E,0x4E,0x9A,0x92,0xB1,0x56,0xB4,0xB9,0xD9,0xCD,0x76,0x7E,0xAA,0x54,0x8D,0x35,0xBD,0xEB,0xAD,0x5A,0xED,0x17,0x66,0x9B,0x2D,0xAE,0x6D,0x6E,0x7D,0x67,0x3B,0xDD,0xCB,0xE1,0x01,0x00,0x00};
extern const uint8_t spt_COLOR[]             PROGMEM ={0x0E,0x88,0xC7,0x35,0x00,0x31,0x15,0x7B,0x40,0x03,0x27,0xF6,0xAE,0xDA,0x4D,0xB2,0xDD,0x78,0xC4,0xDA,0x7D,0xB1,0xF2,0xEA,0x9E,0xE4,0xAC,0x17,0xAB,0x72,0x31,0x83,0x8B,0xDB,0xEE,0x66,0x76,0xA9,0xB7,0x4D,0x2D,0x9B,0xB6,0xC4,0x41,0x0F,0x7A,0x94,0xC3,0x03,0x00,0x00};
extern const uint8_t spt_COME[]              PROGMEM ={0x0E,0x88,0xCD,0xD4,0x01,0xCE,0xB9,0x38,0x20,0xBA,0x54,0x05,0xC4,0x1C,0x1A,0x92,0x64,0xAA,0x2D,0x38,0xED,0xCD,0x6E,0x76,0x32,0x17,0xBA,0xD5,0xB8,0xC9,0xCD,0x77,0xD5,0x6A,0x9B,0xA5,0x54,0x28,0x4D,0x6C,0x63,0x1B,0xDB,0xD8,0xF9,0xCE,0xF6,0xB2,0xA7,0xFD,0x03};
extern const uint8_t spt_COMES[]             PROGMEM ={0x06,0x08,0x5D,0xC5,0x01,0x3E,0x1A,0x1A,0x20,0x85,0x16,0x06,0xA8,0x6A,0x76,0x92,0x90,0xCB,0xCD,0xB5,0xF3,0x49,0x42,0xE8,0x74,0x97,0x26,0x37,0x3D,0xA9,0x4D,0x93,0x62,0x56,0x64,0x67,0xA3,0xB2,0x79,0x82,0x42,0x93,0xA4,0xC6,0x3B,0x2C,0x95,0xF0,0x1E,0x9B,0xD8,0xC6,0x36,0xB4,0xC6,0x72,0x89,0x94,0xDB,0xD0,0x5A,0xED,0x61,0x0E,0x8D,0x53,0xF7,0x0C,0x7A,0xB0,0xA4,0x35,0xC0,0x42,0x40,0x06,0xB8,0x82,0x4D,0x01,0x3F,0xB2,0x1A,0xE0,0x09,0xB6,0x07};
extern const uint8_t spt_COMMA[]             PROGMEM ={0x01,0x08,0xD3,0x38,0x00,0xD1,0x84,0x3A,0x20,0xA5,0x75,0x02,0xA8,0x63,0xB6,0x22,0xDB,0x2B,0xDC,0xBD,0xCE,0x4D,0x6E,0xB2,0x12,0xDD,0xCE,0x25,0x3D,0x4E,0x2B,0x6C,0x96,0x52,0xA1,0x34,0xBD,0xAA,0xD5,0x68,0xF4,0x68,0xB1,0xB0,0x04,0xBD,0x6D,0xBD,0x8D,0xED,0x21,0xD8,0xA8,0x0E,0x7E,0xD0,0xFD,0x03,0x00,0x00};
extern const uint8_t spt_COMMAND[]           PROGMEM ={0x06,0x08,0xDB,0x58,0x01,0xDE,0x25,0x1B,0xC0,0x64,0xE5,0x53,0x25,0x53,0x6D,0xC1,0x69,0x6F,0x75,0xAB,0x51,0x85,0x40,0xE5,0x60,0xC9,0x67,0x35,0xAB,0x55,0xC5,0x9A,0xDA,0x94,0x55,0x6F,0x75,0xAB,0x5D,0xEF,0x66,0xB5,0xBE,0x7B,0x9A,0x65,0xD4,0xD9,0xB5,0xCE,0x16,0x0B,0xD2,0xB2,0x5C,0x7B,0xD3,0x2B,0xCB,0x9D,0xDC,0x89,0x6D,0xAF,0x7B,0xDD,0x9B,0x9E,0xA9,0x88,0xB4,0x88,0x6B,0x7A,0xE2,0x32,0x3C,0xCB,0x66,0xE8,0xAD,0xB1,0x50,0x9F,0x06,0xB6,0x7F};
extern const uint8_t spt_COMPLETE[]          PROGMEM ={0x06,0x08,0xB9,0x65,0xE4,0xB6,0x54,0xB8,0x78,0x92,0x5D,0xED,0xAA,0xD4,0x2E,0x70,0x0B,0x9B,0x9A,0xDC,0x86,0xD6,0x7B,0x6C,0xA5,0xD4,0xEA,0x3A,0xE1,0xDD,0x13,0xCA,0x8E,0xE9,0x8D,0x32,0x0F,0x35,0x27,0x00,0x06,0xF0,0xD6,0xDC,0x02,0x25,0xF1,0xB2,0x3C,0xD4,0x16,0xEF,0x64,0x65,0x4E,0x87,0x56,0xC4,0xAC,0x51,0x04,0x2B,0xDC,0x99,0x75,0x5A,0x15,0x0C,0x6B,0x6D,0x26,0xEC,0x8D,0xEB,0xAD,0xC1,0xEE,0x28,0x2B,0xB2,0xC7,0x33,0x00,0x30,0xA0,0xB1,0x34,0x0D,0x70,0x80,0x02,0xF0};
extern const uint8_t spt_COMPLETED[]         PROGMEM ={0x02,0xD0,0xC5,0x99,0x03,0xAD,0xD2,0x35,0x52,0xD3,0x12,0xEF,0xBA,0x34,0xA9,0xE0,0xB2,0x88,0x96,0xD0,0xD8,0x88,0xCF,0x11,0x5E,0x7D,0x23,0x7B,0x10,0x40,0xAD,0xE2,0x1E,0x70,0x40,0xD1,0x9A,0x27,0xF1,0xC6,0x23,0x24,0x32,0x9F,0xD4,0x79,0x33,0x8F,0x6A,0xB5,0xD2,0x14,0x49,0xDD,0x7B,0xF1,0x4C,0x43,0x1E,0x1B,0xB3,0x64,0x6C,0x42,0x00,0xF0,0x15,0x02,0x70,0xDC,0x2D,0xD5,0x25,0x9A,0xA3,0xEB,0xB6,0x5D,0xDF,0x76,0x77,0xA5,0x4F,0xC1,0x8D,0x0D,0xBE,0x88,0x81,0xE9,0xC8,0x88,0xCC,0xC8,0x07,0x31,0x2A,0xE9,0x96,0x9E,0x0E,0xED,0xF0};
extern const uint8_t spt_COMPUTER[]          PROGMEM ={0x0A,0x08,0x79,0xC4,0x02,0xA7,0x8A,0xCE,0xD3,0x03,0xDA,0xEE,0xAA,0xD7,0xA5,0xB6,0x59,0x4A,0x85,0xD2,0xD8,0x16,0x8F,0x02,0x60,0x21,0x32,0x00,0x29,0x2B,0x5A,0xE0,0x24,0x25,0x85,0x82,0x5B,0x9F,0x9D,0xAC,0x34,0x38,0x4B,0xB1,0xC8,0x33,0x33,0x07,0x74,0x1D,0x91,0x2A,0xDF,0x34,0xA9,0xAD,0xED,0xAC,0x66,0x3B,0xFB,0xD6,0xBB,0xA6,0xAA,0x1B,0xE9,0xC3,0x60,0x3B,0xFB,0x14,0xA5,0x76,0x83,0xAD,0xE4,0xE9,0xE6,0xDA,0x0C,0x21,0x5A,0x92,0x7A,0xAA,0x07};
extern const uint8_t spt_CONNECTED[]         PROGMEM ={0x0E,0x88,0xC7,0x35,0x00,0x31,0x15,0x7B,0x20,0x24,0xB1,0x78,0x5A,0xD8,0x92,0x9B,0x9F,0xDC,0xE7,0x70,0x53,0x9F,0x93,0x72,0xEF,0x5D,0x1D,0x2D,0x6D,0x2F,0x4E,0x96,0x72,0x84,0x43,0xD5,0x39,0x69,0x6E,0x91,0x86,0xDD,0x66,0xA4,0x69,0x59,0x90,0x8F,0xEB,0x94,0x45,0xED,0xAA,0x62,0x4A,0x78,0x0D,0x00,0x0A,0x90,0x41,0xA3,0x65,0x25,0x9A,0xA3,0xEB,0xB6,0x59,0xEC,0xAA,0xB6,0xA2,0x17,0x26,0x2C,0xC3,0x33,0xC6,0xDE,0xF6,0xAA,0x57,0xD2,0x2D,0x3D,0x1D,0xBA,0xA6,0x44,0x15,0x16,0xC9,0xAC,0xFA,0x18,0x45,0x94,0xA2,0x26,0xC0,0x03,0x00,0x00};
extern const uint8_t spt_CONSOLE[]           PROGMEM ={0x02,0xF0,0x31,0xC0,0x02,0x1A,0xE0,0xC0,0x8A,0x5D,0x9C,0x70,0x4D,0x3B,0x37,0xB9,0xC9,0x4E,0x52,0xAA,0xBD,0xB9,0xC2,0x68,0xF1,0x99,0x2D,0x74,0xED,0x80,0xAD,0xDC,0x33,0x10,0x01,0x0B,0xB4,0x4A,0xBB,0x4E,0x4D,0xAF,0x5B,0x6A,0xB1,0xAA,0x54,0xB2,0x5B,0x6E,0x63,0x1F,0x07,0x3F,0x98,0x81,0xD5,0x57,0xD3,0x72,0xA3,0x07,0x3D,0x88,0x91,0xB6,0x0B,0x11,0x73,0xC2,0x47,0x3A,0x3E};
extern const uint8_t spt_CORRECT[]           PROGMEM ={0x0E,0x70,0xC7,0x49,0x00,0x3E,0x86,0xA5,0x58,0x8D,0x2C,0x53,0xCD,0x76,0x8B,0x56,0x98,0x23,0x95,0xA2,0x99,0x6B,0x95,0x9B,0xDA,0xAC,0xCA,0x27,0x6D,0xF1,0x8D,0xBD,0xAB,0x59,0xF7,0x26,0xB5,0xBE,0x73,0x79,0x4D,0x90,0xDC,0xB9,0x21,0x0C,0x28,0x8F,0x91,0x29,0x47,0x00,0x00,0x01,0x0C,0xED,0xAA,0x80,0xE5,0xA2,0x05,0xD0,0x74,0x3B,0x02,0xBC,0x4B,0x7A,0x00,0x00};
extern const uint8_t spt_COURSE[]            PROGMEM ={0x0A,0x70,0xC7,0x49,0x03,0x1A,0x48,0xA1,0xEC,0xB5,0xA4,0xDE,0xA5,0x86,0x35,0xAA,0xD1,0x48,0xD4,0xC8,0x32,0xD5,0x6C,0x2D,0x37,0x47,0x2A,0x45,0x33,0xF7,0xAA,0x36,0xB9,0x63,0xC0,0x29,0x6E,0x1A,0x30,0xC0,0x4F,0xEE,0x16,0xD0,0x80,0x00,0x7E,0x31,0x42,0xC0,0xDF,0x8E,0x08,0xF8,0x4B,0x19,0x01,0xD7,0x92,0x3D,0x00,0x00};
extern const uint8_t spt_CYAN[]              PROGMEM ={0x06,0xF8,0x56,0x4D,0x03,0x1A,0xB0,0x80,0x04,0x52,0x68,0x52,0xA6,0xCB,0xD8,0xDD,0xF1,0x8E,0x77,0xBC,0xE2,0x30,0x22,0x9C,0x26,0xCE,0x8E,0x77,0xBC,0xD2,0xD4,0x5D,0x9D,0xB2,0xFA,0xCD,0x77,0xB5,0xAB,0xDD,0x8C,0xD6,0x95,0x30,0x2D,0x8F,0x34,0xBB,0xDA,0x85,0x41,0x45,0x71,0xE3,0x4E,0x6C,0x07,0x3D,0x88,0x41,0x45,0x55,0xD7,0x4C,0x6D,0x87,0x07};
extern const uint8_t spt_D[]                 PROGMEM ={0x0C,0x10,0xD2,0x62,0x64,0xD9,0x2B,0x4B,0xE6,0xE9,0x91,0xE5,0x28,0x2C,0x53,0x83,0x56,0x96,0x8D,0x88,0x6E,0x4D,0x1A,0x59,0x09,0xC2,0xB2,0x35,0x79,0xE6,0xA3,0xEA,0x49,0x19,0xAA,0xC7,0xF4,0xAA,0xD7,0xBD,0xAD,0x9D,0x1F,0xDC,0xD4,0x92,0x12,0x76,0x0F,0x71,0xFD,0x88,0x82,0x32,0x55,0xE5,0x01};
extern const uint8_t spt_DATA[]              PROGMEM ={0xAC,0x85,0x6E,0x22,0x2A,0x24,0xB3,0x96,0xA8,0xCC,0x4C,0x77,0x30,0x9A,0x99,0xCA,0x99,0x3D,0xC9,0xC9,0x63,0x52,0x93,0xD8,0xB9,0xB7,0x5A,0x79,0x1E,0x2C,0xE6,0xD3,0x66,0xE7,0x3B,0x37,0x00,0x33,0x9A,0x0E,0x28,0x3E,0xB9,0xD5,0xD1,0x3B,0x1B,0xE6,0x8C,0xD1,0xB8,0x6C,0x29,0x31,0x49,0x66,0x3B,0x7A,0xE7,0xB3,0xDC,0xE3,0x6E,0x19,0x5D,0x0F,0xD3,0xE8,0x2A,0x71,0xF2,0xB3,0x19,0xA3,0xB3,0x30,0x28,0xCB,0xAC,0x0B,0xB7,0x58,0xC9,0x9D,0xC0,0x03,0x00,0x00};
extern const uint8_t spt_DECIDE[]            PROGMEM ={0xAD,0x1A,0x2C,0x54,0x24,0x32,0xAF,0xAA,0xD8,0x70,0x51,0xD9,0xAA,0xAA,0x18,0x3D,0x44,0x6A,0xAE,0x01,0x7E,0x14,0x8D,0x40,0x04,0x02,0xF0,0x93,0x69,0x04,0x22,0xA0,0x81,0x11,0x06,0x17,0xED,0xD4,0xB1,0x47,0xEA,0x52,0xA7,0x49,0xC6,0x99,0xD9,0xCC,0x7B,0xD1,0x2A,0xD7,0x32,0xC5,0xDB,0x4A,0xAF,0x4A,0xED,0x77,0x24,0x65,0xC9,0x6E,0xAD,0xDF,0x96,0x1C,0x2D,0xA7,0xF5,0x3E,0xBB,0x44,0x47,0xD0,0xDE,0xD7,0x3E,0xF5,0x36,0xB3,0x57,0x56,0x98,0xD4,0x3B,0xE7,0x6C,0xE5,0x95,0x44,0x8F,0x43,0x7A,0x95,0xC9,0x16,0x3D,0xB6,0xE5,0x15,0x69,0xEB,0x01};
extern const uint8_t spt_DEVICE[]            PROGMEM ={0xC0,0x00,0x62,0xDD,0x4E,0x35,0xBC,0x27,0x99,0xF4,0x3B,0x55,0x31,0x9E,0x14,0xDA,0xAD,0x35,0xD5,0x58,0x51,0x90,0xBB,0xDC,0xBA,0xD6,0x69,0x0F,0x65,0xCA,0x73,0xAA,0x60,0xA6,0x85,0xBD,0xF5,0xCD,0x6E,0x76,0xD3,0x93,0x66,0x3D,0x55,0x42,0x8D,0x6F,0x76,0x8A,0xE4,0xC7,0x5D,0xAC,0xF6,0x6D,0xC7,0x18,0xA3,0x69,0xDA,0x94,0x29,0x83,0x4F,0x52,0x99,0x17,0x2A,0x0C,0x2E,0x18,0x75,0x76,0x29,0x01,0x68,0xD0,0x2A,0x80,0x3F,0x59,0x1D,0xF0,0x8B,0x9B,0x03,0xBE,0x15,0x53,0xC0,0x8F,0x22,0x0A,0xF8,0x89,0x89,0x01,0xDF,0xB0,0x10,0xE0,0x59,0xD6,0x07};
extern const uint8_t spt_DID[]               PROGMEM ={0xA2,0x13,0xCC,0xCA,0xD3,0x6D,0xA5,0x6E,0x48,0x63,0x55,0x76,0x32,0xF2,0x11,0xDA,0x20,0x65,0xEB,0xCA,0x6B,0x2C,0x01,0xB3,0x35,0x2B,0x4D,0xD9,0x51,0x2A,0x5F,0xAF,0x24,0x45,0x47,0xED,0xBC,0xB5,0xD2,0x18,0x9D,0xAD,0xEA,0xF6,0xC8,0xA2,0x77,0xD6,0xCA,0x27,0xA3,0xAA,0x26,0x8C,0xAB,0xB6,0xB6,0xAE,0xD9,0x70,0x0A,0x7B,0xDB,0xFA,0xE2,0xC2,0x28,0xEC,0x69,0x1D,0x7C,0x0F,0xA6,0xCF,0x4C,0x45,0x2C,0xDD,0xB8,0xAE,0x28,0x17,0xF1,0xD8,0x20,0xC6,0x5C,0xC3,0x04,0x6D,0xEA,0x03,0x00,0x00};
extern const uint8_t spt_DIFFERENT[]         PROGMEM ={0xAC,0x6A,0x3E,0x8C,0x4D,0xF6,0xFA,0xEA,0xD6,0xB7,0x58,0x79,0x4A,0x6E,0x62,0xF9,0x66,0xA5,0xAE,0xAA,0x59,0x76,0x99,0x50,0x8F,0x5C,0xA1,0x8C,0x4E,0x18,0x10,0xA4,0xAA,0x00,0x54,0xB4,0x74,0x40,0x76,0x65,0x2A,0xB6,0x13,0xCB,0x13,0xF3,0xF4,0x6A,0xD4,0x6E,0x52,0xD8,0x90,0xBF,0xD1,0xF8,0xCD,0xA9,0x8D,0x5D,0x4F,0xEB,0xAB,0xA5,0xB9,0x36,0x3F,0x7D,0x88,0x1D,0x14,0xD6,0xA6,0xF7,0x61,0x50,0x52,0x23,0xB5,0x42,0xD9,0x41,0xF5,0xD6,0x8A,0x26,0x79,0x6A,0x50,0x40,0x37,0x66,0x06,0x38,0xD4,0x4C,0x00,0x5E,0x34,0x12,0x40,0x44,0x37,0x00,0x78};
extern const uint8_t spt_DISKETTE[]          PROGMEM ={0xAD,0x5F,0xD6,0x95,0x19,0xEC,0x9E,0x2A,0xE5,0x50,0xD6,0x5A,0x7A,0xAA,0x18,0x9D,0xAD,0xEA,0x76,0xAB,0xAB,0x09,0xE3,0xAA,0xAD,0x01,0xF8,0xD9,0x2D,0x03,0x09,0xF8,0xD1,0xCC,0x00,0x15,0xAF,0x82,0x01,0x6A,0x31,0x33,0x40,0x8B,0x4A,0x27,0x4E,0xC9,0xA9,0xAD,0xE6,0xDC,0xE4,0xA4,0x39,0x59,0x99,0xE6,0xDC,0x9B,0xDF,0x6A,0xD5,0x31,0x5A,0x39,0x6F,0xCC,0xD8,0x02,0x80,0x02,0xA2,0x74,0x55,0xC0,0x91,0x16,0x0A,0x18,0xDC,0x1C,0x1E};
extern const uint8_t spt_DO[]                PROGMEM ={0x2E,0x4E,0x80,0xB3,0x32,0x6D,0x8D,0x22,0x44,0x53,0x4B,0xFB,0x7C,0xB2,0x22,0xAC,0xA8,0x2C,0xFB,0x4E,0x76,0x32,0xD3,0x99,0xB5,0x22,0x51,0x6B,0x49,0xC9,0xDE,0xAB,0xD6,0x38,0x11,0xA9,0x2E,0xD9,0x6B,0x1B,0x7A,0x69,0x2A,0xCD,0xB5,0x9B,0xEF,0x6D,0xAF,0x87,0x07};
extern const uint8_t spt_DOES[]              PROGMEM ={0xAD,0x4E,0xDE,0x4D,0x4D,0xDE,0xDC,0x7C,0x25,0x26,0x7B,0xB9,0x4D,0x95,0x9D,0xCE,0x74,0xA6,0xAB,0xF0,0x21,0xD3,0xD3,0x16,0xCF,0x6A,0x36,0xB3,0xE9,0x5D,0xE9,0xAC,0xF7,0x70,0xF7,0x2B,0xB9,0xCB,0x9D,0xEB,0xB5,0xF7,0x74,0x8F,0xD1,0xBE,0x67,0x40,0x05,0xEC,0x1A,0xE0,0x00,0x05,0x1E};
extern const uint8_t spt_DOING[]             PROGMEM ={0xAD,0x49,0xC1,0x54,0x9D,0xF7,0xEE,0x64,0x64,0x3E,0x58,0x9A,0xE9,0xAE,0x94,0x88,0x6E,0xEE,0x5E,0x23,0x62,0x52,0xD3,0x90,0x89,0x6E,0xAE,0x99,0x13,0x4B,0x61,0x8A,0xB9,0x79,0x9C,0x6E,0x55,0x6B,0x65,0xE8,0xBC,0x75,0x36,0xBB,0x9D,0x5D,0xEB,0xEA,0x4A,0xC6,0xF0,0xD6,0xB9,0xB7,0xBD,0xEE,0x45,0x6F,0x1D,0x76,0x50,0xC5,0x11,0x9D,0x75,0xD4,0x41,0x15,0x9B,0xF5,0xD2,0x6A,0x14,0x65,0x43,0xD2,0x6B,0x65,0xEA,0xE2,0x6E,0x1E,0x00,0x00};
extern const uint8_t spt_DONE[]              PROGMEM ={0xC0,0x32,0xA6,0x22,0xD2,0xC3,0x36,0xAB,0x88,0xAA,0x4A,0x8B,0xD8,0xA9,0x8E,0xC1,0xD2,0x2C,0x9E,0xDE,0xEA,0x56,0xA7,0x8A,0x3E,0x2A,0x35,0x52,0xDF,0xEA,0x54,0xD1,0x45,0xA7,0x44,0xEA,0x53,0x05,0x1F,0xE5,0x1E,0x89,0x4F,0x1D,0x42,0x94,0xBB,0x47,0x5D,0x8D,0x0F,0x51,0xEE,0x1E,0xB7,0xB5,0x3E,0x78,0x84,0x79,0x96,0xD0,0x05,0x0F,0x6D,0x19,0x6A,0x42,0x17,0x3C,0xB4,0x65,0xA8,0x56,0x9D,0x0B,0x30,0x16,0xA9,0xDA,0x8C,0xDA,0xD2,0x8C,0xB6,0x02,0x3D,0xF1,0x89,0x4E,0x0F};
extern const uint8_t spt_DOUBLE[]            PROGMEM ={0xAB,0x2E,0xC2,0x2D,0xCB,0x52,0xAD,0x3A,0x79,0x4B,0xB7,0x59,0x7B,0x2A,0xE3,0xFD,0x46,0x24,0xFD,0xAD,0x6E,0xB5,0x2B,0xD1,0x12,0xDF,0xAE,0x12,0x6D,0x5D,0x23,0x7D,0x5D,0x08,0xA7,0xEE,0x75,0x6B,0x78,0xEB,0x53,0xE6,0xD6,0xB5,0x4D,0x1D,0x5B,0x3D,0x4C,0x9E,0x3A,0x0E,0x7A,0xC0,0xC3,0x03,0x00,0x00};
extern const uint8_t spt_DOWN[]              PROGMEM ={0xAE,0x49,0x32,0xCC,0x35,0x95,0x8C,0x36,0x79,0x37,0x35,0x79,0xB3,0x0A,0xEF,0xA7,0x4D,0xA3,0xEE,0x2E,0x76,0xB5,0xAB,0xDD,0xCC,0xB6,0xB5,0x26,0xF4,0xAA,0x58,0xBA,0xDE,0xF5,0xAE,0xF6,0xA1,0x0F,0x1E,0xDA,0x32,0xD4,0x84,0x21,0x78,0x68,0xCB,0x50,0x1D,0x07,0x37,0x6A,0x4B,0x33,0xDA,0x0A,0xEC,0xA8,0x47,0x3E,0xD2,0xE9,0x01};
extern const uint8_t spt_DRAW[]              PROGMEM ={0xAE,0x70,0xBD,0x54,0xD2,0xE4,0xB6,0x7A,0xC4,0x34,0x07,0x92,0x3A,0xAA,0xE0,0x53,0xD9,0xDD,0xE9,0xA8,0x4C,0x51,0xF7,0x84,0xE4,0xAB,0x32,0xDE,0x4F,0x9D,0xDB,0xDE,0x6A,0x55,0xC6,0xE7,0x27,0x59,0xFA,0x5D,0xED,0x6A,0x57,0xB3,0x9E,0x4D,0x6B,0x55,0xE9,0x55,0x76,0xAF,0xA9,0x93,0xA3,0x86,0xCD,0x3C,0x84,0x4E,0xEC,0x4A,0x87,0x74,0x1A,0x5A,0xB9,0xD3,0x8D,0x33,0x9C,0xEB,0x94,0xF7,0x12,0x33,0xC9,0xAA,0xF3,0xCE,0xD2,0x20,0xE4,0x3C,0x00,0x00};
extern const uint8_t spt_DRAWING[]           PROGMEM ={0xA6,0x0B,0x3E,0x95,0xDD,0x9D,0xBA,0xCE,0x14,0x75,0x4F,0x48,0xDE,0x6A,0xE3,0xFD,0xD4,0xB9,0xED,0xAC,0x5B,0xE5,0xE4,0xAE,0x1B,0x66,0x9F,0xC5,0xCC,0x67,0x36,0xB3,0x9E,0xF7,0x62,0x54,0xD6,0x4D,0x99,0x48,0xDB,0xD5,0x84,0xD0,0x65,0xCA,0x69,0x4F,0x57,0x42,0xA7,0x38,0x67,0x3D,0x5D,0x4B,0x93,0x64,0x94,0xF5,0xF6,0x7B,0x28,0xC3,0x0C,0xAA,0xD0,0xD5,0x5A,0x0D,0xDA,0xD1,0x94,0xB6,0x45,0x3D,0xE8,0x41,0x0C,0xDA,0xD1,0xA6,0x86,0x05,0x35,0x68,0x67,0xDC,0xE1,0x8E,0xD5,0x60,0x95,0x53,0x35,0x45,0x94,0xE3,0x03};
extern const uint8_t spt_E[]                 PROGMEM ={0x21,0x2A,0x81,0x49,0xB7,0x2B,0xD7,0xB4,0xA7,0x33,0xDB,0xD9,0xCE,0x77,0xBE,0xF3,0x51,0xD4,0x22,0x84,0x5D,0x4B,0x66,0xD5,0xAB,0x5A,0x31,0x80,0x59,0x79,0x53,0x3B,0x61,0xE6,0xE7,0x35,0x1F};
extern const uint8_t spt_EACH[]              PROGMEM ={0xAB,0xE8,0xD1,0x19,0xB2,0x9F,0x8C,0x62,0x24,0x63,0xA8,0x99,0xB3,0x8B,0x5D,0xCC,0xAA,0x35,0xA3,0x99,0x40,0xD4,0x1D,0xDF,0xE1,0x0E,0x80,0x00,0x33,0xB2,0x2A,0x60,0xEF,0x0C,0x0B,0x28,0xE0,0x9C,0x4E,0x01,0xAC,0x69,0xA9,0x80,0x6E,0xCD,0x00,0x01,0x7E,0x90,0x3D};
extern const uint8_t spt_EIGHT[]             PROGMEM ={0x2D,0x2F,0xC5,0x54,0xA3,0x63,0xB5,0xBC,0x54,0x55,0xCD,0x1E,0x32,0xB2,0x5A,0x85,0xB8,0xBA,0xCE,0xCE,0x66,0x36,0x8B,0x56,0xD5,0x22,0xC8,0x55,0x73,0x63,0x2F,0x07,0x00,0x00,0x02,0x44,0x6D,0xCA,0x01,0x04,0x18,0x21,0x86,0x81,0x07};
extern const uint8_t spt_EIGHTY[]            PROGMEM ={0x20,0x00,0x2B,0x2D,0x4E,0xD1,0x52,0x32,0x57,0xAC,0x39,0x59,0x4D,0xC6,0xDA,0xBD,0x66,0x25,0x2D,0x0B,0xC9,0x74,0xAB,0x1B,0xCF,0x44,0xD6,0x0A,0x10,0x28,0x2A,0x14,0xBD,0x38,0x41,0xD6,0xD2,0x59,0xED,0x7A,0x74,0xBD,0x19,0x43,0xF6,0xD2,0x3C,0xF8,0x49,0x4F,0x7C,0x79,0x00,0x00};
extern const uint8_t spt_ELEVEN[]            PROGMEM ={0xA7,0x1E,0xC1,0x1C,0xC3,0xD6,0xDE,0xFA,0xD4,0xA9,0xA5,0xA1,0x45,0x9B,0xD5,0xC4,0x10,0xC6,0x94,0xE9,0x76,0xBD,0x6A,0xAF,0x2B,0xD9,0x37,0xEE,0xA9,0x42,0x4F,0x75,0xAB,0xB8,0xB7,0xB8,0xF9,0xCD,0x57,0xEE,0x53,0x89,0xBB,0xD7,0x73,0xAD,0x8D,0x2D,0x1E,0xDC,0x38,0xB7,0xBB,0x9D,0x7D,0x19,0x5C,0x49,0x29,0xD1,0x46,0x6E,0xB4,0x51,0x5D,0x49,0x9A,0xBA,0xC9,0x04,0x36,0xE7,0x4C,0xA2,0x66,0x13,0xC4,0x02,0x2B,0x91,0x98,0x6C,0x14,0x33,0xC9,0xC4,0x62,0x52,0xC1,0x34,0x24,0x52,0x3F};
extern const uint8_t spt_ELSE[]              PROGMEM ={0x21,0x4B,0xC5,0xDC,0x34,0x27,0x97,0xCC,0x67,0xF7,0xD0,0x5E,0x7A,0x8B,0x5B,0xDD,0x6A,0x54,0x3A,0x6D,0x84,0xFA,0xBC,0x56,0x29,0xFF,0xA3,0xCE,0x69,0x6A,0x53,0x5B,0xD7,0x89,0xD0,0xB1,0x40,0x75,0x54,0x5F,0x4D,0x90,0x8B,0xD8,0x56,0xC0,0x95,0xC5,0x16,0x70,0x40,0x07,0x26,0x1A,0x60,0xC0,0xC1,0x6A,0x0C,0xF8,0xD2,0xF2,0x01};
extern const uint8_t spt_END[]               PROGMEM ={0xA3,0xC8,0x4D,0x4D,0x3C,0x63,0x9F,0xA2,0xB4,0x34,0x51,0x5F,0x7B,0xF3,0x93,0xE5,0x96,0xA6,0x9A,0x73,0x4F,0x56,0x4A,0xA9,0x54,0xCD,0x3D,0x59,0xC9,0xA5,0x5A,0x33,0xE7,0xE4,0x25,0x96,0x8A,0xD9,0xEC,0x53,0xE5,0x54,0xAC,0x66,0x53,0x4E,0x9D,0x4A,0x9A,0xA8,0xCE,0x59,0x4D,0xCC,0x65,0x64,0x36,0x6B,0x74,0xC9,0x57,0xA1,0xCB,0xEC,0xD0,0xEB,0xA0,0xA6,0xE6,0xB5,0x5D,0xAF,0x02,0x97,0xD8,0x38,0x70,0xBD,0x0C,0x5C,0xE2,0x1D,0xCB,0xF4,0xD2,0x51,0x9B,0x4E,0x2C,0x35,0x68,0x8B,0x6B,0x36,0x91,0xE4,0xC8,0xA7,0x30,0x15,0xE5,0x22,0x1E,0x1B,0xF4,0x28,0x86,0x14,0x53,0x5D,0xB3,0xD6,0x03};
extern const uint8_t spt_ENDS[]              PROGMEM ={0xA7,0xCA,0x39,0xC5,0xCC,0x6B,0x9F,0x2A,0xD7,0x30,0x93,0xA8,0x73,0xAA,0x5C,0xD3,0x55,0xB2,0xEE,0xAD,0x6E,0x75,0xAA,0xD8,0xDD,0xC5,0x2A,0xEA,0xAD,0x6E,0xB3,0xBB,0xD6,0xD9,0x6C,0x6A,0x92,0x95,0x43,0xEF,0x34,0x4C,0xB5,0xD2,0x8D,0x7D,0x1C,0xFC,0x68,0x27,0xD7,0x71,0x23,0x5F,0xEA,0x4C,0x7C,0x47,0x00,0x2C,0x2B,0x04,0x30,0x65,0x84,0x04,0x24,0xC0,0x01,0x0A,0x3C};
extern const uint8_t spt_ENTER[]             PROGMEM ={0xA7,0x28,0x39,0x4C,0x43,0xEF,0x9C,0xA2,0x94,0x34,0x31,0x7D,0x72,0xF2,0xD2,0xD4,0x8D,0xBD,0xC9,0xCD,0x52,0xCE,0xBC,0x77,0xE8,0x99,0xCA,0x85,0x03,0x4A,0x70,0x77,0x40,0xE3,0xE2,0xA3,0xF0,0x53,0xD4,0x9D,0xD7,0xCE,0xB6,0xF7,0x61,0x34,0x1D,0xAA,0xC2,0x16,0x99,0xC9,0x74,0xD6,0xF6,0x88,0xAD,0x26,0x9D,0xD8,0xC6,0x5D,0xF1,0x03,0x00,0x00};
extern const uint8_t spt_ERROR[]             PROGMEM ={0x2B,0xAF,0xC9,0x9C,0xDC,0x97,0x9E,0xBC,0xE5,0x34,0x72,0x5F,0x77,0xF2,0x58,0x4D,0x35,0xA3,0xEB,0xCD,0x5A,0x6A,0x07,0x7B,0x27,0xAD,0xEA,0x59,0xCF,0x5B,0xE5,0xB6,0x89,0x37,0x6E,0xED,0x55,0xAF,0x7B,0xD7,0xFB,0x3A,0xF4,0xA1,0x8D,0xB6,0xB9,0xE8,0xD3,0x56,0x37,0xB9,0xA9,0x1A,0x43,0x5B,0xCC,0xEC,0x16,0x66,0xAB,0xA5,0x72,0x8B,0xAB,0x66,0xC6,0xA3,0xE4,0x01,0x00,0x00};
extern const uint8_t spt_EXACTLY[]           PROGMEM ={0xA7,0x2A,0x35,0x95,0xC3,0xD7,0xDE,0x7A,0x37,0xA3,0xC9,0xCD,0x48,0xCB,0xD7,0xE4,0x3A,0x36,0xAD,0x89,0x51,0xC0,0xDB,0x1A,0x05,0xA0,0x03,0x54,0x07,0x74,0x80,0x3A,0x8A,0xC9,0xC3,0x55,0xC2,0xCB,0xC9,0xE3,0x8E,0x30,0x1A,0x27,0x37,0xBF,0xF9,0xCD,0x6F,0xB6,0xF2,0xBC,0x25,0x24,0xDA,0x16,0x02,0x70,0x34,0x03,0x20,0x80,0x97,0xCA,0x01,0x48,0x51,0xDD,0x02,0xA5,0x90,0x25,0xDD,0xCC,0x96,0xF4,0x6A,0xF4,0xA1,0x99,0x89,0xD6,0xD5,0x3A,0x84,0x21,0x24,0xE8,0xAC,0x8B,0x1E,0x46,0x6D,0x3D,0x76,0xCC,0x94,0x19,0x8D,0x93,0xBA,0x34,0x51,0xF0};
extern const uint8_t spt_EYE[]               PROGMEM ={0x23,0x09,0xDE,0x27,0x82,0xBB,0xED,0xEC,0x16,0xB7,0xBE,0xF5,0x6D,0x4E,0x13,0xB2,0x97,0x5B,0xB4,0xDD,0xDD,0xEA,0x42,0xF6,0x70,0x8F,0x39,0xAD,0x8F,0x85,0xDB,0xBC,0xCB,0x94,0x3E,0x64,0xD5,0x1C,0x0B,0x95,0x07,0x37,0x78,0x27,0xB9,0xA9,0x86,0x4D,0x1F,0x3C,0xD3,0xA4,0x1B,0x96,0x35,0xAF,0xE1,0x01,0x00,0x00};
extern const uint8_t spt_F[]                 PROGMEM ={0x2B,0x8B,0x25,0x4A,0xAC,0x13,0xEF,0xEC,0xE6,0xB7,0xB8,0xD5,0xAD,0x6E,0xBD,0x5A,0x1F,0x23,0xD8,0x63,0xD2,0xEE,0xFA,0xE8,0x80,0x68,0x4D,0x3C,0x60,0x01,0x0D,0x68,0x80,0x02,0x0F};
extern const uint8_t spt_FIFTEEN[]           PROGMEM ={0x0A,0xE8,0x26,0xD4,0x02,0x27,0x2C,0x29,0x84,0xCD,0xDE,0xDC,0xE4,0xA6,0x35,0x8B,0xB9,0x01,0x8A,0x0A,0x54,0x40,0x91,0x1E,0x16,0x40,0x00,0xB2,0x15,0x00,0x0A,0x10,0xC6,0x7C,0xC4,0x3D,0x3A,0x43,0xF6,0x93,0x95,0x8C,0x64,0x0C,0x35,0x73,0x66,0x3A,0xB3,0x9E,0xB7,0x6A,0x34,0x13,0x88,0xBA,0xD3,0xEB,0xDE,0x86,0x2E,0x6B,0x96,0x9A,0x0C,0xE8,0x7B,0xD3,0x53,0x17,0x95,0x11,0xB6,0xEC,0x60,0x07,0x3D,0x88,0x81,0x6B,0x8B,0x96,0xB4,0xC5,0x06,0xA1,0xB4,0x56,0xC2,0xD1,0x03};
extern const uint8_t spt_FIFTY[]             PROGMEM ={0x0C,0xA8,0x61,0x54,0x02,0x1A,0xF0,0xC0,0x8A,0x73,0x09,0x63,0xB1,0x67,0x37,0x59,0x49,0x2A,0x66,0xAC,0x39,0x66,0xA4,0xD6,0x99,0x55,0x6C,0x84,0x9C,0x2B,0x60,0x66,0x57,0x0D,0x48,0x80,0x03,0x00,0x0A,0xE8,0x34,0x4D,0x01,0x3D,0xA5,0xA4,0xB0,0x05,0x13,0x8A,0x79,0x33,0x8B,0x5E,0x87,0xAE,0x7A,0x61,0xC9,0xF8,0xE2,0x7B,0x3B,0xD8,0x59,0x8F,0x0F};
extern const uint8_t spt_FIGURE[]            PROGMEM ={0x0C,0xB0,0x3C,0x9C,0x01,0x59,0xBB,0x29,0xA0,0x5A,0x33,0x0B,0x9C,0x30,0x04,0x57,0xCD,0xAC,0x77,0xE2,0x1A,0xD3,0x58,0x74,0xCD,0x89,0x5A,0x36,0xE1,0xF6,0xB7,0x2D,0xAE,0xD5,0x81,0xDB,0x97,0xAA,0x44,0x4B,0x0B,0x2C,0x71,0xC2,0x32,0xE2,0x2A,0xD3,0xDC,0x8E,0x28,0x38,0xAF,0xF4,0x34,0xDB,0xA5,0x5A,0xCD,0xC8,0xC9,0x94,0xB4,0x6A,0x78,0x51,0xB4,0xEA,0xB3,0xEA,0x1A,0x9C,0x21,0x7C,0xEF,0x6A,0x72,0x4A,0x01,0xAF,0x6E,0xAB,0x8D,0x39,0x0D,0xC3,0xD3,0x9F,0x3E,0xF6,0x34,0x0E,0xF6,0xDE,0x7A,0x17,0x93,0xB8,0x33,0xB9,0x1B,0x6D,0x17,0xC9,0xD2,0xEC,0x66,0x70,0x85,0x2C,0xDD,0x92,0x98,0x31,0xB4,0x10,0x52,0x75,0xF5};
extern const uint8_t spt_FIND[]              PROGMEM ={0x0C,0x30,0x56,0x5C,0x01,0xD1,0xA8,0x5A,0xC0,0x02,0x27,0xB1,0x21,0xD6,0x39,0x93,0x9C,0xDC,0xB6,0x0E,0x93,0x4A,0xB3,0x8B,0x5D,0xED,0x6A,0x57,0xAB,0x8E,0xC3,0x4B,0x2C,0x92,0xEC,0x66,0xB6,0xA5,0xCD,0x4D,0xC5,0x3D,0xA7,0xD4,0xB6,0x76,0xA1,0x63,0xCE,0x32,0xA4,0x63,0xF8,0xDE,0x0F,0x76,0x68,0x93,0x73,0xA6,0xE6,0x39,0xB9,0x0E,0xA9,0x8B,0xD9,0x4D,0xC0,0x2A,0x3F};
extern const uint8_t spt_FINE[]              PROGMEM ={0x0C,0x30,0x56,0xDC,0x00,0xD1,0xA8,0x46,0x20,0x02,0x2B,0xB4,0x21,0xD6,0x39,0x93,0x9C,0xCC,0xB6,0x0E,0x93,0x4A,0x73,0xB3,0x9B,0xDD,0xFC,0x16,0xA7,0x8A,0xC3,0x4B,0x2C,0x92,0xDC,0xE6,0xB6,0xA7,0xCB,0x4D,0xC5,0x3D,0xA7,0xEC,0x6E,0xF7,0xA1,0x67,0xCE,0x32,0xA4,0x63,0xC4,0xDE,0xF7,0xBE,0xB7,0x83,0x1E,0xF8,0xF0};
extern const uint8_t spt_FINISH[]            PROGMEM ={0x02,0x48,0xCA,0x55,0x03,0x16,0xF0,0xC0,0x49,0x63,0x32,0xE3,0x8A,0x25,0x27,0xCB,0x39,0x9C,0xC2,0xDA,0xDE,0xEC,0x16,0xA9,0x8A,0x0E,0x22,0x30,0x9B,0xF4,0x6A,0x36,0xA3,0x2D,0xD6,0x49,0x2C,0x5A,0xCC,0xAE,0x75,0x49,0xB3,0x55,0x56,0x45,0x07,0xEC,0x3E,0xE1,0x01,0x0F,0x58,0x40,0x02,0x14,0x78};
extern const uint8_t spt_FINISHED[]          PROGMEM ={0x02,0x28,0xCA,0x49,0x03,0x16,0xB0,0xC0,0x89,0x73,0x0A,0x31,0x8F,0xB6,0x37,0xB9,0x69,0xCB,0x4A,0x75,0x21,0xF6,0x7A,0xAB,0x28,0xC5,0xD9,0x55,0x2E,0x9F,0xBA,0x06,0x25,0xB5,0x9A,0xB9,0x9B,0xD9,0x96,0x2E,0x31,0x93,0xEA,0x0C,0x69,0x80,0x77,0xCA,0x23,0x10,0x81,0x08,0x48,0x00,0x00,0x14,0x30,0xAC,0x9B,0x01,0xB4,0xB7,0x20,0x80,0x57,0xAE,0x0F};
extern const uint8_t spt_FIRST[]             PROGMEM ={0x08,0x08,0xDA,0x04,0x03,0x18,0xE0,0x80,0x07,0x42,0x64,0x86,0x69,0x15,0x65,0xDB,0xF9,0xCE,0x77,0x3E,0x8B,0x51,0xBB,0x9E,0xA4,0x6D,0xEE,0x5B,0xEB,0x87,0x89,0x94,0xB9,0xAF,0x7D,0x1D,0x0C,0xF0,0x8A,0xB1,0x01,0x9E,0x17,0xD6,0x00,0x01,0xFE,0x76,0x44,0x80,0x66,0x95,0x00,0x0A,0x68,0xC1,0xDC,0x00,0xDB,0x8A,0x3F};
extern const uint8_t spt_FIT[]               PROGMEM ={0x04,0x88,0x2E,0x4C,0x02,0x1A,0xD0,0x80,0x07,0x46,0x9C,0x82,0xAB,0x56,0xAE,0xB9,0xC9,0x4D,0x4F,0x1E,0x43,0xA4,0x6A,0xEC,0xD9,0x55,0x6F,0x7C,0xAB,0x7B,0x00,0x50,0x40,0x55,0x2E,0x02,0x68,0xB6,0xE5,0x01,0x00,0x00};
extern const uint8_t spt_FIVE[]              PROGMEM ={0xC0,0x80,0xE8,0xCD,0x46,0xEE,0x9C,0x6F,0x31,0x66,0x39,0xB9,0xF3,0x35,0x45,0xD6,0xF4,0x64,0xDE,0x77,0x27,0x79,0xDD,0x93,0x7A,0xDF,0x1D,0x14,0x45,0x4E,0xE6,0x43,0x97,0x73,0x05,0x3D,0x45,0x08,0x5D,0xC5,0x15,0xE5,0x54,0x21,0x56,0x06,0x67,0x90,0x53,0xC7,0x54,0x15,0x14,0x75,0x4F,0x1B,0xAB,0x17,0x43,0x25,0x59,0x5D,0x6C,0x5E,0xAA,0x59,0x75,0xF4,0xA9,0x59,0x69,0xD5,0xD4,0xD1,0xC7,0x6A,0xA1,0x5E,0x53,0xDB,0x10,0x8B,0x86,0x46,0x5D,0x6D,0x43,0x28,0x1A,0x1A,0x35,0xB4,0xF4,0x2E,0x4B,0xA9,0x75,0x62,0x33,0x98,0xA2,0xC6,0x5A,0x09,0xD9,0x20,0x95,0x7B,0x99,0xBB,0x06,0x04,0x38,0x27,0x84,0x00,0xE5,0xD5,0x1F};
extern const uint8_t spt_FOR[]               PROGMEM ={0xC0,0x00,0x23,0x2D,0x24,0xA0,0x01,0x0B,0x58,0x20,0xC5,0xBC,0xF7,0x11,0x4C,0x9A,0x9A,0xA4,0x84,0xF6,0x39,0x85,0x6E,0x97,0x93,0x98,0x84,0x8C,0xF5,0x5E,0x45,0xCD,0xDE,0x2A,0x91,0x63,0xD2,0x58,0x7D,0x6B,0x55,0xB1,0xF2,0x26,0xED,0xA9,0xE7,0xDB,0xC2,0x4B,0xFC,0xBA,0x49,0x2E,0x89,0x55,0xF4,0xE3,0x66,0xB5,0x95,0xAB,0xCC,0xBB,0x9B,0xED,0x30,0xF6,0x11,0x35,0x76,0x7B,0x00,0x00};
extern const uint8_t spt_FORTY[]             PROGMEM ={0x08,0x48,0x4C,0x8D,0x02,0x0A,0x28,0xDE,0x5D,0x84,0x22,0xCC,0x25,0x50,0xFB,0x9A,0xB4,0x94,0x97,0x19,0x43,0x6D,0xD7,0xD3,0x91,0xA9,0xE2,0x61,0xC5,0xBD,0x7B,0x4E,0x00,0x9D,0x58,0x1C,0x90,0x63,0x6A,0x4A,0x4A,0x0C,0x21,0x9F,0xB7,0xBD,0x18,0x4D,0x8B,0xCE,0x18,0xF1,0x26,0xB7,0xBE,0x73,0x5D,0xB3,0x2E,0x1C,0xD1,0xDA,0x0E,0x72,0x7C};
extern const uint8_t spt_FOUR[]              PROGMEM ={0xC0,0x00,0x23,0x2D,0x24,0xA0,0x01,0x0B,0x58,0x20,0xC5,0xBC,0xF7,0x11,0x4C,0x9A,0x9A,0xA4,0x84,0xF6,0x39,0x85,0x6E,0x97,0x93,0x98,0x84,0x8C,0xF5,0x5E,0x45,0xCD,0xDE,0x2A,0x91,0x63,0xD2,0x58,0x7D,0x6B,0x55,0xB1,0xF2,0x26,0xED,0xA9,0xE7,0xDB,0xC2,0x4B,0xFC,0xBA,0x49,0x2E,0x89,0x55,0xF4,0xE3,0x66,0xB5,0x95,0xAB,0xCC,0xBB,0x9B,0xED,0x30,0xF6,0x11,0x35,0x76,0x7B,0x00,0x00};
extern const uint8_t spt_FOURTEEN[]          PROGMEM ={0x00,0x04,0xF0,0xD2,0x54,0x01,0x49,0xB9,0x85,0x94,0xE5,0x6A,0x0F,0x93,0xDF,0x52,0x11,0xEB,0x99,0x39,0x73,0xCA,0xD8,0xA8,0xA3,0xD0,0xCE,0x25,0xE3,0x2B,0x52,0x5D,0xFB,0x8E,0xDC,0x24,0x37,0x1B,0x75,0xAF,0x00,0x1A,0xA4,0x81,0x00,0x95,0x92,0x03,0x80,0x03,0x8A,0x37,0xB6,0x80,0x00,0x8A,0x23,0x2D,0x41,0xD1,0x22,0xDE,0x59,0x6A,0x24,0x4D,0x0B,0x49,0x56,0xE5,0x91,0x0D,0x2D,0xC4,0x99,0x95,0x5B,0x3E,0xB4,0x30,0x57,0x55,0x2E,0x45,0xE7,0xC4,0x3A,0x19,0xB9,0xD4,0x85,0x13,0xC5,0x84,0x99,0xD4,0x54,0x4E,0xE2,0x17,0xA6,0x53,0xDB,0x34,0x8B,0x6F,0x98,0x49,0x5D,0xD6,0x2C,0x35,0x19,0x30,0x74,0x51,0x2B,0xFB,0x79,0x68,0xD1,0x33,0xAD,0xDD,0x1A,0xA6,0x45,0x4F,0xB4,0x56,0x4A,0xCB,0x16,0x3D,0xD3,0x3A,0x25,0x65,0x4A,0x74,0x5C,0xEB,0x8C,0x44,0x24,0xD1,0x49,0xAD,0xBD,0x1A,0x8E,0x1F,0x00,0x00};
extern const uint8_t spt_FOURTH[]            PROGMEM ={0x08,0xD0,0x22,0x84,0x00,0x51,0x1A,0x0B,0xA0,0x69,0x23,0x03,0xD4,0x50,0x4E,0x00,0x7C,0xCB,0x4B,0x2A,0x5D,0x4D,0x00,0x24,0xEB,0x69,0x48,0xE9,0xDE,0x64,0x88,0xAA,0x21,0xA3,0xBB,0x97,0xC1,0xDA,0xA7,0x9C,0xAD,0x1A,0x45,0xCB,0xD6,0x2A,0x3E,0xB2,0x5D,0x34,0x7B,0xAB,0x75,0xB3,0x1A,0xE5,0xEE,0xA5,0x35,0x95,0x27,0x52,0xDA,0xA6,0x4E,0x27,0x2D,0xCB,0x8C,0x4D,0x00,0xC9,0x8D,0x30,0x80,0x00,0xCF,0x5D,0x11,0xE0,0x99,0x9B,0x00,0xB2,0x34,0x62,0x80,0x0A,0xAA,0x18,0x78};
extern const uint8_t spt_FROM[]              PROGMEM ={0x80,0x80,0x28,0x55,0x08,0x50,0xBD,0xA3,0x03,0x52,0x48,0x2F,0xA9,0x5A,0x9C,0x19,0x94,0x75,0x64,0x7A,0x68,0x79,0x60,0xA7,0x95,0x99,0x30,0xC3,0x9A,0x51,0x76,0xBE,0xF3,0x51,0x38,0xD7,0xC7,0x92,0xA5,0x67,0x35,0x9B,0xD9,0x96,0xCE,0x1B,0x0D,0x43,0x75,0x1F,0x3B,0xD7,0x5B,0x2D,0x65,0x68,0xC9,0x7D,0xEF,0x7B,0xD3,0x5B,0xCD,0xAD,0xE0,0xEE,0x7C,0xEF,0xFB,0x07,0x00,0x00};
extern const uint8_t spt_FRONT[]             PROGMEM ={0x06,0xA8,0x21,0xC5,0x03,0x11,0x88,0x40,0x49,0xF5,0x92,0xF4,0x42,0xAF,0x35,0xEB,0xF9,0xA9,0xBC,0xAF,0x0E,0xF2,0xF4,0xBB,0xDE,0x4D,0xEB,0x7D,0x82,0x76,0x69,0x35,0x71,0xB0,0xBD,0xEB,0x93,0x4D,0x33,0x15,0x19,0xC0,0x80,0xA6,0x9A,0x2D,0xF0};
extern const uint8_t spt_G[]                 PROGMEM ={0xAA,0xBE,0xAB,0x90,0xC1,0xD4,0x05,0x60,0x47,0x86,0x51,0xED,0xE2,0xC2,0x6C,0xD9,0x57,0xD5,0x53,0x08,0x81,0x6E,0x5D,0x45,0x2B,0x41,0x64,0xBE,0x66,0x17,0xBB,0xD8,0xD5,0xAE,0x76,0xD3,0xDA,0x92,0x05,0xA5,0xF2,0x76,0x6D,0x53,0x97,0xB5,0xB2,0x5E,0xD4,0x72,0x5D,0xD4,0xCC,0x79,0x11,0xD2,0x77,0xBA,0x93,0xFD,0x03};
extern const uint8_t spt_GAMES[]             PROGMEM ={0xAA,0x15,0x24,0x2A,0xD6,0xE4,0xB6,0xB6,0x79,0x13,0xB1,0x5C,0xB2,0xF3,0x93,0x97,0xA4,0x66,0x3E,0x75,0x77,0x3E,0xF2,0x52,0x8D,0xCD,0x26,0xF6,0xCC,0x7B,0xDE,0x8A,0x9A,0x14,0x2D,0xBA,0xD2,0xAC,0x66,0xDD,0xEB,0xDE,0x8E,0xB6,0x7A,0x47,0x0D,0xAF,0x95,0x3A,0x6D,0xB1,0x9A,0xDA,0x8E,0xED,0x6C,0x67,0x3A,0x6E,0xA5,0x46,0x42,0xB1,0xED,0x74,0x27,0x3A,0x62,0x32,0xC2,0x23,0x76,0xEA,0x7F,0x22,0x36,0x11,0xF5,0x06,0x38,0x1C,0xC8,0x00,0xDF,0x29,0x39,0xE0,0x7B,0x56,0x03,0x7C,0xCD,0xCA,0x80,0xCC,0x83,0x1E,0x00,0x00};
extern const uint8_t spt_GET[]               PROGMEM ={0xA3,0xAE,0x4A,0xD5,0xC0,0xB4,0xAC,0xB4,0x26,0x17,0xF1,0x58,0xB2,0xF2,0x98,0x2D,0x25,0x72,0xF4,0x2E,0x76,0xB1,0xAB,0x5D,0xCD,0xBA,0x34,0xAE,0x6A,0x58,0x76,0x69,0xDF,0x02,0x00,0x28,0xA0,0xAA,0x30,0x02,0x48,0x6F,0x06,0x0F,0x00,0x00};
extern const uint8_t spt_GETTING[]           PROGMEM ={0xA3,0x9E,0xB9,0x52,0x99,0x1C,0xAF,0x64,0x05,0x67,0xD5,0x74,0x73,0x92,0xE6,0x42,0xB8,0x72,0xF1,0xC9,0x63,0x71,0xA5,0xAC,0x39,0x27,0x4F,0xD5,0x42,0x75,0x13,0xAF,0x3C,0x36,0x4B,0x8C,0xC9,0x06,0x01,0x28,0xD9,0x2C,0x85,0xCD,0x27,0xA3,0x7A,0xAB,0x53,0x95,0xE6,0xA2,0x11,0x4B,0x4E,0x53,0x93,0xB3,0x44,0x2E,0x3E,0x5D,0xCF,0xC6,0xE8,0xD1,0xA8,0x75,0xCD,0x2B,0x71,0x67,0xA4,0xD4,0x27,0x87,0xD2,0x19,0x92,0x4D,0x2F,0x9D,0x6C,0x44,0x4A,0x36,0x83,0xB5,0x38,0x21,0x25,0x43,0x0D,0xC6,0xE0,0x16,0x94,0x0C,0x33,0x38,0x03,0xDD,0x18,0x4E,0xC4,0xC0,0xAC,0x75,0x71,0xA4,0x32,0x53,0xAE,0xC6,0x22,0xE4,0x4C,0x4D,0x39,0x28,0x79,0x54,0x98,0x07,0x00,0x00};
extern const uint8_t spt_GIVE[]              PROGMEM ={0x6A,0x60,0x22,0x3A,0xD3,0x64,0xA7,0x6E,0x16,0x37,0xA0,0x5A,0x5B,0xBB,0xD1,0x8D,0x56,0x09,0x4C,0xDB,0x77,0x3F,0xFA,0xDA,0x82,0xC5,0xE9,0x7B,0xEF,0x47,0x17,0x92,0x9B,0x06,0x7F,0x1B,0x6D,0x8A,0x12,0x11,0xB2,0x7D,0x35,0x3E,0x68,0xB9,0xD9,0x9B,0x51,0xEB,0xE8,0xE3,0x5A,0xAD,0x4A,0xA5,0x82,0xAD,0x4B,0x36,0x70,0x95,0x8C,0xD6,0xC2,0xD5,0xCA,0x65,0x46,0x98,0x15,0xBB,0x5B,0x04,0x18,0x29,0xC2,0x80,0x14,0x54,0x10,0xA0,0x43,0x2A,0x3C};
extern const uint8_t spt_GIVES[]             PROGMEM ={0xAA,0x15,0x34,0x26,0x46,0xE5,0xB6,0x66,0x46,0x66,0x56,0x4F,0x3A,0x8A,0x61,0x58,0x24,0x6B,0xD5,0xCA,0x9B,0x36,0xE1,0x9A,0x45,0x2B,0xCB,0xC2,0xD5,0xB6,0x6A,0x8E,0x34,0x58,0xB3,0xD8,0x9A,0x34,0x32,0xE3,0xCD,0x73,0xAB,0xD2,0xC8,0x5D,0x54,0xF3,0x9C,0x9A,0xA3,0xB0,0x2E,0xCC,0xBA,0x66,0x8E,0xCA,0xD9,0x74,0xCB,0x78,0x34,0x9B,0xDE,0xB6,0x2E,0x4A,0x77,0x75,0x4A,0x5D,0xBB,0xDC,0x99,0x5E,0x99,0x50,0x13,0xAB,0xED,0x86,0x28,0x42,0x45,0x35,0xB5,0x1D,0x05,0xF0,0x9D,0xB9,0x02,0x7E,0x50,0x57,0xC0,0x0F,0x2A,0x0C,0xF8,0x8E,0x95,0x00,0x5F,0x33,0x21,0xE0,0x39,0xD2,0x07};
extern const uint8_t spt_GO[]                PROGMEM ={0xA5,0x4E,0xAE,0x58,0xBC,0x6B,0x9D,0xA2,0x1B,0x75,0xAA,0xC8,0x76,0xAA,0x1C,0x34,0x2C,0x39,0xCB,0xA9,0x82,0xF6,0xB1,0xD4,0x3C,0xA7,0xF2,0x3A,0x37,0x9C,0xBA,0xDD,0xEA,0xD6,0xBB,0x99,0x7D,0x9A,0x8C,0xAA,0x0B,0xC7,0xB4,0x71,0x72,0x93,0x56,0xFD,0x62,0x92,0x56,0xCF,0x0F};
extern const uint8_t spt_GOES[]              PROGMEM ={0xA3,0xEA,0x46,0x9D,0x2A,0xB2,0x9D,0x3C,0x07,0x0D,0x4B,0xCE,0x72,0x8A,0xA0,0x7D,0x2C,0x35,0xCF,0x29,0xBC,0xCE,0x0D,0xA7,0x6E,0xBB,0xBA,0xF5,0x68,0x8D,0xAA,0x0B,0xC7,0xB4,0xBD,0xCB,0x43,0x1C,0xDD,0xA8,0x55,0xBF,0x98,0xA4,0xF5,0x93,0x99,0x3C,0xF1,0x4C,0x01,0x7F,0x76,0x16,0xC0,0x11,0xC4,0x04,0xF8,0xC3,0x51,0x00,0x7F,0x07,0x12,0xE0,0x55,0x42,0x06,0x74,0x21,0xF1};
extern const uint8_t spt_GOING[]             PROGMEM ={0xA4,0x42,0xAE,0x3B,0xA3,0x15,0x85,0xDA,0x1B,0x65,0xD5,0x76,0xD2,0xF2,0x98,0x82,0xC5,0x33,0xF3,0xC9,0x13,0xD5,0x8C,0x52,0xDF,0x2B,0xB7,0xAE,0xDF,0x05,0x3A,0xEF,0xAC,0xE5,0x2A,0xF6,0x29,0xC1,0xE6,0x5C,0xB4,0x4A,0xC5,0x6D,0x06,0x59,0xBD,0xAA,0xA0,0x33,0xCD,0x78,0xCB,0x6A,0xDB,0x2C,0x61,0xC1,0xB5,0xBB,0x6B,0x7D,0xF3,0xC6,0x52,0x59,0x31,0x8C,0x25,0x30,0xDA,0x86,0x49,0x3B,0xE9,0x49,0x8C,0x9A,0xD1,0x34,0x44,0x6C,0x39,0xF2,0xC9,0x4E,0x6A,0x0A,0xD9,0x42,0x35,0x2B,0x3E};
extern const uint8_t spt_GOOD[]              PROGMEM ={0xA3,0x8D,0x29,0x58,0x3C,0x33,0xDF,0xEC,0x14,0x59,0x68,0x6B,0x4A,0xF6,0x5B,0xDD,0xEA,0x56,0xA7,0xB2,0xC6,0x2B,0x3D,0x3A,0xEC,0xBA,0xD7,0xAA,0x26,0xBC,0xD2,0x23,0x1D,0x3C,0x00,0x00};
extern const uint8_t spt_GOOD_WORK[]         PROGMEM ={0xA1,0x89,0xC6,0x95,0xC3,0xF2,0xCD,0xEA,0x14,0x4E,0xA7,0xA6,0x4B,0xFB,0x5B,0xEC,0xE2,0x16,0x0A,0x00,0x57,0x33,0xB4,0xD6,0x58,0xA8,0x4F,0x03,0x10,0x85,0x08,0xDE,0x0E,0x92,0xDA,0xE7,0x21,0x21,0x37,0x4B,0x24,0x32,0xA6,0x88,0x5C,0x77,0xD7,0xF4,0x58,0x42,0x31,0x52,0x3A,0x28,0x53,0x8D,0x46,0x62,0x5A,0x52,0x1C,0xE6,0xED,0x75,0x1F,0xF2,0xA8,0x27,0x00,0x01,0xC4,0xE2,0x22,0x01,0x02,0x94,0xEC,0xF2};
extern const uint8_t spt_GOODBYE[]           PROGMEM ={0xA9,0x49,0xE1,0x54,0x91,0x2D,0xAF,0x22,0x07,0x55,0x29,0x69,0x7B,0xF2,0x18,0x38,0x32,0x3C,0xCB,0x4D,0x52,0xC8,0x4A,0x5A,0x65,0x99,0x52,0x21,0x6A,0x61,0x69,0x2E,0x45,0x46,0x2C,0x43,0xA9,0x3C,0x3D,0x1C,0x87,0x2A,0x3A,0xFB,0x50,0x6E,0x73,0xEB,0xDB,0xEC,0x6E,0x77,0xA3,0xF7,0xD1,0x4E,0x35,0xA2,0xCC,0x7E,0x74,0x3E,0xC6,0xA8,0x79,0x85,0xD1,0x86,0x64,0x65,0x16,0x95,0x5B,0x13,0x52,0xB0,0x65,0x94,0x2E,0xB5,0x4D,0x6A,0x55,0x65,0xF8,0x01,0x00,0x00};
extern const uint8_t spt_GOT[]               PROGMEM ={0xA2,0x20,0xBA,0x2A,0xDD,0x13,0x8F,0x2A,0x07,0x13,0x2D,0x5D,0x7B,0xF3,0x93,0xFB,0x6C,0xE1,0x11,0x73,0x4F,0xE1,0x73,0xB6,0x6B,0xD4,0xBF,0xC5,0xAD,0x66,0x5D,0x3A,0xEF,0x5A,0x4A,0xC2,0x52,0xEE,0x75,0x0F,0x20,0x00,0x43,0xC2,0x19,0x30,0x44,0x04,0x3C};
extern const uint8_t spt_GRAY[]              PROGMEM ={0x04,0xD0,0xD7,0x22,0xA5,0xBA,0x78,0x19,0x8C,0xBA,0x54,0xC8,0x22,0x27,0xAE,0xD9,0x4B,0xA1,0x2A,0xBF,0xA6,0xF8,0x6F,0x99,0x6E,0xFC,0x32,0xD2,0x71,0x65,0x3E,0x4B,0xCB,0x56,0xA2,0x9D,0xED,0xFC,0x14,0xA5,0x99,0x68,0xC4,0xDC,0x5B,0xDD,0x7A,0xB5,0x29,0x93,0x7B,0x6E,0x94,0xDE,0xA7,0x3E,0x46,0xB4,0xAC,0x0E,0x92,0xFA,0xE8,0x49,0xBB,0x3B,0x88,0xEB,0x83,0x11,0xEE,0xE3,0x00,0x0F,0x00,0x00};
extern const uint8_t spt_GREEN[]             PROGMEM ={0xA1,0x0A,0x45,0x46,0xC0,0xA8,0xA6,0xCA,0x66,0x38,0xB5,0x72,0x37,0x0A,0x5F,0x70,0x38,0xDC,0xF7,0xCA,0x63,0xC7,0xE2,0xF0,0x2C,0x27,0x4B,0x55,0x45,0x3C,0x96,0x9D,0xAC,0x77,0x23,0xB2,0x5C,0xBC,0xF3,0x5B,0xEC,0x6A,0xD7,0xAB,0xEE,0xC3,0x19,0x75,0x66,0xEF,0x66,0xB4,0x75,0x19,0xB3,0xF4,0xE2,0xD0,0x39,0x0B,0x1B,0x16,0x76,0x7D,0x6B,0x5A,0x6B,0xE0,0xDD,0x43,0x99,0x68,0x59,0xB2,0x49,0x28,0x43,0xA2,0xD5,0x0A,0x7B,0x25,0x1D,0xBB,0x36,0x44,0x27,0x8E,0x4C,0x24,0x7A,0x1F,0x45,0x4C,0xDB,0x36,0x3C};
extern const uint8_t spt_GUESS[]             PROGMEM ={0x21,0x1F,0xDE,0x14,0x2D,0xDE,0xEC,0x7C,0xE5,0x39,0x59,0x99,0xE6,0xDC,0x9D,0xEF,0x62,0x57,0xAB,0x8E,0xD1,0xCA,0x79,0x63,0xCE,0x26,0xB7,0x02,0x98,0x3C,0x54,0x01,0x3F,0xA8,0x69,0x40,0x03,0x0A,0xF8,0x3E,0xD4,0x00,0xDF,0x46,0x18,0xE0,0x8A,0x30,0x05,0x64,0x57,0x8C,0x00,0x9D,0x54,0x00,0x80,0xD4,0xC1,0x84,0x5B,0xB9,0x93,0x07,0x00,0x00};
extern const uint8_t spt_H[]                 PROGMEM ={0x27,0x2F,0xC1,0x55,0xAB,0x26,0x9F,0x22,0x47,0x55,0xAB,0x9E,0x7A,0x8A,0x92,0x8C,0x74,0x7B,0xF2,0xAD,0x56,0xD5,0x83,0x11,0x75,0x3D,0xAE,0xB5,0xAC,0x01,0x1C,0x30,0x23,0xAB,0x03,0xF6,0xCE,0xB0,0x00,0x03,0xCE,0xE9,0x14,0xC0,0x9A,0x96,0x0F};
extern const uint8_t spt_HAD[]               PROGMEM ={0x08,0x30,0xD6,0x4A,0x00,0x3E,0x68,0x85,0x24,0x25,0x75,0x8F,0x8E,0x72,0xE3,0x93,0x96,0xE2,0xA6,0x59,0x75,0x6E,0x7A,0xB3,0x93,0xE7,0x9A,0x2E,0x9A,0x55,0x6F,0x75,0xEA,0x5C,0xB3,0xC5,0x62,0xEA,0x6D,0x6E,0xB3,0xDB,0xDE,0x9A,0x9E,0xEB,0x14,0xF9,0xA8,0x6C,0x7A,0x61,0x9D,0xF4,0x32,0xB2,0xEB,0x8B,0x72,0x11,0x8F,0x0D,0xB9,0xF3,0xA3,0xEA,0x52,0x71,0xA3,0x58,0xD9,0x0F,0x00,0x00};
extern const uint8_t spt_HAND[]              PROGMEM ={0x08,0x10,0xD6,0x13,0x01,0xC6,0x50,0x49,0x40,0x03,0x25,0x4E,0xCD,0x53,0x63,0x1C,0xDF,0xF4,0xA6,0x27,0x4D,0xCD,0x87,0x32,0x93,0xDE,0xEC,0xE6,0xB7,0xB8,0xD5,0x6E,0x56,0xE3,0xAB,0x87,0x79,0xC5,0xE9,0x4D,0x6F,0x4C,0xC3,0xA2,0x55,0xC9,0x44,0xB2,0x8D,0x6E,0x74,0xC3,0x5A,0x66,0xAC,0x5A,0xC3,0x61,0xE8,0x52,0x14,0x51,0xF0,0x2A,0xB6,0xD5,0xCD,0x03,0x00,0x00};
extern const uint8_t spt_HANDHELD_UNIT[]     PROGMEM ={0x08,0x70,0x5E,0x8C,0x03,0x1A,0x18,0x49,0x1A,0xEE,0xC6,0xE7,0xFC,0x24,0x79,0x64,0x38,0x56,0xD2,0x9B,0xDE,0x6C,0x66,0x21,0x57,0x4E,0xDA,0xE4,0x55,0x99,0x9C,0xD8,0xA8,0x85,0xB0,0x60,0x0B,0x5B,0xC8,0x0A,0x30,0xC0,0x00,0x61,0xA4,0x38,0x30,0x9A,0xD0,0x22,0xC4,0xAB,0xCE,0x6E,0x76,0x33,0x9B,0xD6,0xE8,0x56,0xAD,0x1A,0xB3,0x6B,0x93,0x1A,0x39,0xAA,0x45,0xB3,0xB1,0x6F,0x4C,0x4B,0x5D,0xA8,0x67,0xDB,0x0A,0x7D,0xD0,0xC6,0xBA,0x63,0xD3,0x37,0xA9,0x29,0x23,0x15,0x8B,0xFB,0xA6,0xDA,0x07,0x28,0xD7,0x74,0x17,0xEB,0xD8,0xF8,0xCE,0xF5,0xA1,0x5A,0x50,0xC4,0xD4,0x3C,0xBA,0xD1,0x39,0x8B,0xC8,0x88,0xE1,0x47,0x3D,0x02,0x00,0x08,0xA0,0x7B,0x37,0x0D,0x10,0x20,0x49,0x73,0x0C,0x3C,0x00,0x00};
extern const uint8_t spt_HAS[]               PROGMEM ={0x08,0xB0,0x56,0x94,0x01,0x29,0x3A,0x2B,0x20,0xB5,0x30,0x05,0xF8,0xC0,0x76,0xB2,0xD4,0x3C,0x35,0xC6,0xF1,0x4D,0x6F,0xBA,0xF2,0xD4,0x7C,0x28,0x33,0xE9,0x2E,0x6E,0x75,0xBB,0xDD,0xED,0x7E,0x0C,0xBE,0x7A,0x98,0x57,0x9C,0x3E,0xE4,0xD1,0x8D,0xC6,0x6B,0x99,0x6E,0x6C,0x05,0x74,0x40,0x29,0x01,0x06,0xFC,0xA0,0x82,0x80,0x9F,0x95,0x11,0xF0,0x9C,0x2A,0x3C};
extern const uint8_t spt_HAVE[]              PROGMEM ={0x0C,0x08,0xD1,0x44,0x02,0x14,0x10,0x40,0x0C,0x4E,0x21,0xF5,0xD9,0x2D,0x33,0xAD,0xCC,0x74,0xA7,0x37,0x3D,0x59,0x1A,0x1E,0x62,0x1D,0xF7,0xE6,0xB7,0xBA,0xF5,0xAA,0x43,0x8D,0x30,0x8F,0xAD,0xBB,0x59,0x8D,0x8F,0x11,0x5A,0xB2,0x66,0xB7,0xBD,0x4D,0x9D,0x8B,0x6A,0x2C,0xDC,0xDA,0x77,0xBA,0x93,0xBD,0xED,0x6D,0xAF,0x7B,0x80,0x07,0x00,0x00};
extern const uint8_t spt_HEAD[]              PROGMEM ={0x80,0x80,0x60,0x59,0x08,0x10,0x3D,0xB7,0x00,0x62,0x64,0x1D,0x41,0x8E,0x61,0xC6,0xFE,0xE6,0xC6,0x37,0xBE,0xC9,0xC9,0x72,0x09,0x33,0xCE,0x2D,0xB7,0x3A,0x4D,0x4A,0xEE,0xAE,0xB1,0xE6,0x76,0xAB,0x8F,0xD1,0xDC,0x2C,0x96,0x88,0x9E,0xBA,0x50,0xCF,0xB6,0x25,0x07,0x31,0x50,0x97,0xEA,0xD9,0xB2,0xC4,0xC0,0x54,0x7A,0x46,0x38,0x16,0xC3,0x90,0xA6,0xEA,0xEE,0x3A,0x74,0xCD,0x8F,0x14,0x97,0x43,0xD3,0x46,0xAF,0x26,0xDA,0x0D,0x43,0x9F,0x7D,0x9A,0xB3,0x3A,0x79};
extern const uint8_t spt_HEAR[]              PROGMEM ={0x08,0x08,0xD2,0x88,0x00,0x51,0x29,0x13,0x20,0x5B,0x92,0x94,0x36,0xAF,0x42,0x15,0x6B,0x76,0x32,0xE3,0x1D,0xAF,0xA4,0xE6,0x10,0x48,0xEF,0x3E,0xB3,0x5D,0x8D,0x3A,0xD6,0x32,0x4C,0xF4,0x3E,0xDB,0xDE,0xF5,0x21,0x8D,0x7E,0x9A,0xC8,0x48,0xFE,0x38,0xEA,0x89,0x4F,0x74,0x7A};
extern const uint8_t spt_HELLO[]             PROGMEM ={0x00,0xC0,0x80,0x60,0x59,0x08,0x10,0x3D,0xB7,0x00,0x62,0x64,0x3D,0x55,0x4A,0x9E,0x66,0xDA,0xF6,0x56,0xB7,0x3A,0x55,0x76,0xDA,0xED,0x92,0x75,0x57,0xA3,0x88,0xA8,0xAB,0x02,0xB2,0xF4,0xAC,0x67,0x23,0x73,0xC6,0x2F,0x0C,0xF3,0xED,0x62,0xD7,0xAD,0x13,0xA5,0x46,0x8C,0x57,0xD7,0x21,0x0C,0x22,0x4F,0x93,0x4B,0x27,0x37,0xF0,0x51,0x69,0x98,0x9D,0xD4,0xC8,0xFB,0xB8,0x98,0xB9,0x56,0x23,0x2F,0x93,0xAA,0xE2,0x46,0x8C,0x52,0x57,0x66,0x2B,0x8C,0x07};
extern const uint8_t spt_HELP[]              PROGMEM ={0x08,0xB0,0x4E,0x94,0x00,0x21,0xA8,0x09,0x20,0x66,0xF1,0x96,0xC5,0x66,0xC6,0x54,0x96,0x47,0xEC,0xAA,0x05,0xD9,0x46,0x3B,0x71,0x94,0x51,0xE9,0xD4,0xF9,0xA6,0xB7,0x18,0xB5,0x35,0xB5,0x25,0xA2,0x77,0xB6,0xA9,0x97,0xB1,0xD7,0x85,0xF3,0xA8,0x81,0xA5,0x6D,0x55,0x4E,0x0D,0x00,0xC0,0x00,0x1B,0x3D,0x30,0x00,0x0F};
extern const uint8_t spt_HERE[]              PROGMEM ={0x08,0x08,0xD2,0x88,0x00,0x51,0x29,0x13,0x20,0x5B,0x92,0x94,0x36,0xAF,0x42,0x15,0x6B,0x76,0x32,0xE3,0x1D,0xAF,0xA4,0xE6,0x10,0x48,0xEF,0x3E,0xB3,0x5D,0x8D,0x3A,0xD6,0x32,0x4C,0xF4,0x3E,0xDB,0xDE,0xF5,0x21,0x8D,0x7E,0x9A,0xC8,0x48,0xFE,0x38,0xEA,0x89,0x4F,0x74,0x7A};
extern const uint8_t spt_HIGHER[]            PROGMEM ={0x80,0x01,0x04,0x78,0x1F,0x45,0x01,0x0E,0x94,0xC0,0x8F,0x0E,0xB7,0x8C,0xBA,0xC3,0x1D,0xED,0xE8,0x46,0x2B,0x8A,0x2B,0x4B,0xB5,0xE2,0xCD,0x68,0xC4,0xA5,0xA8,0x99,0x77,0xE9,0x99,0xB4,0xBC,0x15,0x15,0xC9,0x5C,0xDD,0xAB,0x51,0x95,0x1A,0x4C,0xE9,0x5D,0x47,0x9D,0x5A,0x32,0x87,0x66,0x1F,0x4D,0x6C,0x29,0x1A,0x92,0xBD,0xB5,0x7E,0x84,0x50,0x53,0xB7,0xDA,0xA6,0xCE,0x2D,0x91,0x0C,0x5A,0xED,0x7B,0xDD,0xCB,0x81,0xF7,0x74,0x10,0xBD,0xAF,0x4A,0xEA,0xE2,0xF1,0x01,0x00,0x00};
extern const uint8_t spt_HIT[]               PROGMEM ={0x08,0xB0,0x2E,0x4C,0x00,0xDE,0x47,0x29,0x20,0x2A,0x51,0x0D,0x68,0xA0,0x84,0xD9,0x30,0xC7,0x66,0xC0,0x13,0x97,0xEC,0x2C,0x19,0x4B,0x6E,0x72,0xB3,0x9B,0xB7,0x26,0x79,0x57,0x4A,0x7F,0x02,0x00,0x04,0x88,0xD2,0x54,0x00,0x4B,0x7A,0x08,0x60,0x08,0x37,0x78,0x00,0x00};
extern const uint8_t spt_HOME[]              PROGMEM ={0x08,0x50,0x71,0x93,0x00,0x36,0x54,0x53,0x80,0x00,0x2A,0x6E,0x92,0x48,0xFA,0x5F,0x52,0x4D,0xD7,0xA3,0x1E,0xF7,0xB8,0x25,0x5A,0xEE,0x9B,0x81,0xFA,0x99,0xF6,0xAC,0x57,0xAD,0xF6,0x22,0xBA,0x1E,0xE0,0xF6,0xA6,0x37,0xAD,0x0D,0x81,0x23,0x03,0xCD,0xF6,0xAE,0x76,0xB5,0xCB,0x5D,0xEE,0x5C,0xA7,0x2D,0xAE,0x4B,0x38,0x35,0xAD,0x4A,0x6D,0xA1,0xD2,0x48,0x74,0xBA,0xB4,0x89,0x57,0x98,0x07};
extern const uint8_t spt_HOW[]               PROGMEM ={0x80,0x80,0x10,0x4D,0x28,0xA0,0x01,0x03,0xC4,0xE0,0x64,0x80,0xE2,0x3B,0x15,0x10,0xA2,0xDA,0x8A,0x7D,0x8B,0x91,0x88,0xA8,0x23,0xB1,0x23,0x5A,0x22,0xA3,0xCE,0x64,0x24,0xB6,0xE7,0x88,0x67,0xD4,0x91,0xDA,0x52,0x23,0x1A,0x71,0x5A,0xE6,0x62,0xAF,0x8A,0x35,0x69,0x95,0x8D,0x7D,0x22,0xB6,0xA6,0xD4,0xA6,0xF4,0xB2,0xDA,0x92,0xDA,0x96,0x4E,0xA7,0x59,0x31,0x6E,0x9D,0xBB,0xD0,0xCB,0xB2,0xCB,0xCE,0xAB,0x4D,0x2F,0xC6,0x36,0x85,0xB4,0x52,0x3D,0xBF,0x4D,0xEA,0xA1,0x9A,0xF4,0xEC,0x36,0x19,0x85,0x23,0xDC,0xC3,0x03,0x00,0x00};
extern const uint8_t spt_HUNDRED[]           PROGMEM ={0x04,0x90,0xCB,0x4D,0x02,0x1A,0x68,0x89,0xCD,0x55,0x22,0xAD,0x79,0xA7,0x3B,0x1D,0x69,0x0A,0x5E,0xC2,0x91,0x7A,0xA6,0x2E,0x65,0x5E,0x73,0xAC,0x2D,0xDB,0x54,0xE6,0xA9,0x8A,0x59,0x42,0xC1,0xB3,0xA4,0xDA,0x67,0x0E,0xB5,0x68,0xDF,0xAB,0x59,0xCD,0x7A,0x35,0xDE,0xB9,0x59,0xC5,0xE3,0xD9,0xE6,0x5E,0x74,0xC4,0xA6,0x47,0x96,0x2D,0xD6,0x12,0x53,0x11,0x11,0xB1,0x59,0xCB,0x95,0x5A,0x58,0xAA,0x4E,0x43,0xD4,0xAE,0xE2,0xFC,0x52,0x0C,0x31,0xA5,0x28,0x56,0x2B,0x31,0xE4,0x10,0x6A,0xEC,0x0E,0xC9,0x10,0x55,0x5A,0x58,0xBA,0x7D,0x00,0x00};
extern const uint8_t spt_HURRY[]             PROGMEM ={0x00,0x00,0x14,0xE0,0x40,0x4B,0xEC,0x16,0x19,0x95,0xD8,0x3B,0x19,0x89,0xCE,0x8D,0xF1,0xEC,0xB6,0x25,0xBA,0x26,0xC5,0x61,0x97,0x99,0xD4,0xB4,0xE5,0xBA,0xA9,0x55,0x49,0xDE,0x5E,0xAC,0xBA,0x45,0x67,0x8C,0x78,0xB3,0xEB,0xDD,0xCC,0xB6,0xB5,0xB5,0x18,0x72,0xE4,0x9D,0xDA,0xFA,0x4E,0xB7,0x00,0x0F,0x00,0x00};
extern const uint8_t spt_I[]                 PROGMEM ={0x23,0x09,0xDE,0x27,0x82,0xBB,0xED,0xEC,0x16,0xB7,0xBE,0xF5,0x6D,0x4E,0x13,0xB2,0x97,0x5B,0xB4,0xDD,0xDD,0xEA,0x42,0xF6,0x70,0x8F,0x39,0xAD,0x8F,0x85,0xDB,0xBC,0xCB,0x94,0x3E,0x64,0xD5,0x1C,0x0B,0x95,0x07,0x37,0x78,0x27,0xB9,0xA9,0x86,0x4D,0x1F,0x3C,0xD3,0xA4,0x1B,0x96,0x35,0xAF,0xE1,0x01,0x00,0x00};
extern const uint8_t spt_I_WIN[]             PROGMEM ={0x29,0x09,0xDE,0x27,0x82,0xBB,0xF5,0x64,0x26,0x33,0x9D,0xE9,0x48,0x43,0xF6,0x72,0x8B,0xB6,0x35,0x2B,0x99,0x75,0x91,0xAE,0xB2,0x24,0x64,0xC2,0x77,0x99,0x52,0x2B,0x93,0x0B,0x3D,0xED,0x4A,0x2E,0x4D,0xA5,0xC4,0xAC,0x19,0x7A,0x4E,0x55,0xA0,0xB1,0xEA,0x98,0xB7,0x35,0x2D,0x98,0x71,0x51,0xBF,0xD9,0xAE,0xB6,0xC7,0x34,0x4A,0xD9,0xBB,0xBA,0x1E,0xD3,0x39,0xA4,0xEF,0xE8,0x6A,0x48,0xE7,0x90,0xED,0xAD,0x6F,0xAE,0x92,0x9D,0xBA,0xD4,0x3E,0x0D,0xD1,0x99,0x99,0x60,0x13,0x37,0x44,0x4F,0x21,0xEA,0xE9,0xCD,0x60,0xAD,0x26,0x69,0x35,0x53,0xA3,0xB4,0x6E,0x6A,0xD5,0x46,0x8C,0xC2,0x68,0x6B,0xB4,0x6B,0x36,0x19,0xC9,0x95,0x51,0x4A,0xD8,0x64,0x83,0xA9,0x72,0xB8,0x7D};
extern const uint8_t spt_IF[]                PROGMEM ={0xAB,0x28,0xD5,0x85,0x2D,0x9E,0xDC,0xE2,0x16,0xB7,0x3A,0xB5,0x0D,0x56,0x1E,0x71,0xB9,0x37,0xBA,0x67,0x40,0x88,0xAE,0x12,0x90,0x00,0x05,0x18,0x10,0x9D,0x19,0x07,0x28,0xF0};
extern const uint8_t spt_IN[]                PROGMEM ={0xAB,0x2A,0xD1,0xC4,0xA2,0x2F,0x9D,0xA2,0x79,0x17,0x8D,0x78,0x78,0x8A,0x92,0x4C,0xCC,0xFA,0xE6,0x29,0x4A,0x36,0x53,0xAB,0xB9,0xB7,0xDA,0xD5,0xA9,0x62,0xB0,0x30,0x8F,0x29,0xA3,0x8E,0x5E,0x23,0x5C,0x66,0x87,0x3A,0x05,0x18,0x49,0xD7,0x18,0xEB,0x58,0xBB,0xDA,0x5B,0x58,0x4B,0x73,0xE4,0x1B,0xDD,0x88,0x46,0x29,0xC9,0xB2,0x74,0x4C,0xDB,0x07};
extern const uint8_t spt_INCH[]              PROGMEM ={0xAB,0x69,0x59,0x58,0x33,0x66,0x9D,0xAA,0xC6,0x62,0xCE,0x98,0x75,0xAA,0x96,0x5A,0x44,0xED,0xF1,0xAD,0x6E,0xB5,0x9A,0x1C,0x9B,0xCC,0x7A,0xF0,0x9C,0xC2,0xEC,0xAC,0x71,0x85,0x17,0xD6,0x8B,0x58,0x0D,0x77,0x2D,0x57,0xA7,0xC0,0x80,0x46,0xD9,0x08,0x70,0x77,0xBB,0x04,0x34,0xA0,0x01,0x01,0x9C,0x14,0x2D,0x01,0x0A,0x10,0xA0,0xC6,0x0A,0x04,0xE8,0x60,0xFC};
extern const uint8_t spt_INCHES[]            PROGMEM ={0x23,0x0A,0x41,0xCD,0xA3,0x26,0xDF,0xFC,0xE4,0xB9,0x98,0x11,0x6F,0xE2,0x9D,0xAD,0x2C,0x45,0x53,0xA7,0x8D,0xED,0x72,0x69,0xB5,0x8B,0x96,0x8A,0xA8,0x48,0xC8,0x6C,0x33,0xCB,0x06,0xF8,0x33,0x34,0x03,0x01,0xB8,0x29,0xA5,0x55,0x21,0x68,0x70,0xE4,0xE3,0xD9,0xF4,0x2E,0x75,0x36,0x68,0x88,0xF7,0xAA,0xDC,0xA5,0xCE,0x44,0x0D,0x89,0x49,0xA9,0x00,0x2E,0xD6,0x0D,0xB0,0xB0,0x88,0x05,0x14,0xF0,0x3D,0x89,0x06,0xE0,0x01};
extern const uint8_t spt_INSTRUCTION[]       PROGMEM ={0xAD,0x6A,0xDE,0x95,0x2B,0x66,0xCD,0x6A,0x57,0xA1,0x8E,0x0E,0x92,0x4D,0x96,0xC6,0xDA,0xD7,0xBE,0xF1,0xAD,0x01,0xBE,0x57,0x53,0xC0,0xCF,0x16,0x1A,0x90,0x00,0x28,0xA0,0x84,0x4E,0x05,0xA4,0x18,0x52,0x52,0x53,0x4D,0x3D,0x25,0xDB,0x48,0x5D,0x0E,0xF3,0xA4,0xAC,0x23,0x0D,0xA9,0xDC,0x93,0xB2,0xF6,0xD4,0x56,0x80,0x00,0xE1,0x55,0x14,0xD0,0xE2,0xAE,0x07,0x2C,0xA0,0x80,0x11,0xFB,0x4A,0xDE,0x4D,0x85,0x28,0x66,0xDD,0xCD,0xE8,0xAA,0xEE,0x62,0x15,0xB7,0x69,0xB0,0x31,0x84,0x4C,0x13,0x89,0x41,0x1A,0xA7,0x04,0x2B,0xCF,0x07,0x3E,0xD0,0x05,0x4D,0x06,0x77,0x5B,0x84,0xDB,0x07,0x00,0x00};
extern const uint8_t spt_INSTRUCTIONS[]      PROGMEM ={0xAD,0x6A,0xDE,0x95,0x2B,0x66,0xCD,0xAA,0x57,0xA1,0x8E,0x0E,0x92,0x4D,0x96,0xC6,0xDA,0xD7,0xB6,0x11,0xC0,0xF3,0x6A,0x12,0xB0,0x80,0x05,0x24,0x00,0x0A,0x28,0xA1,0x53,0x01,0x29,0x86,0x94,0xD4,0x54,0x53,0x4F,0xC9,0x36,0x52,0x97,0xC3,0x3C,0x29,0xEB,0x4A,0x43,0x2A,0xF7,0xA4,0xAC,0x3D,0xB5,0x15,0x10,0x40,0x78,0x15,0x05,0xB4,0xB8,0x2B,0x01,0x0F,0x18,0x60,0xC4,0xBE,0xD2,0x74,0x53,0x21,0x8A,0x59,0x77,0x33,0xBA,0xAA,0xBB,0x58,0xC5,0x6D,0x18,0x6C,0x0C,0x21,0xD3,0x44,0x62,0x90,0xC6,0x29,0xC1,0xCA,0xF3,0x81,0x0F,0x72,0x94,0x23,0x03,0x5E,0xB2,0xD4,0x00,0x05,0x30,0x80,0x01,0x04,0xCC,0x64,0xF9};
extern const uint8_t spt_IS[]                PROGMEM ={0x23,0x6B,0xCE,0x99,0x3B,0x16,0xAF,0xAC,0xDA,0x60,0x9E,0xFC,0xB1,0xF2,0xEC,0x9D,0xB5,0xF2,0xC6,0xC9,0x42,0x50,0x37,0xEF,0x46,0x37,0xBF,0xC5,0xAE,0x56,0xE3,0x7D,0x84,0x84,0xDF,0xEE,0x5D,0xEF,0x6B,0x5F,0xFB,0xD6,0x7F,0xA9,0x6E,0x64,0xEE,0x1C,0xB0,0x00,0xB9,0x03,0xBE,0x60,0x76,0xC0,0xF7,0xAC,0x0E,0xF8,0x9A,0xC4,0x00,0xDF,0xB0,0x21,0x40,0x7A,0x97,0x07,0x00,0x00};
extern const uint8_t spt_IT[]                PROGMEM ={0x2B,0x19,0xC1,0x99,0x3D,0xDE,0xEC,0xE2,0x14,0x2D,0xBA,0x88,0xE5,0xDB,0x55,0xD5,0x9C,0xC6,0xE2,0x4F,0x57,0x9D,0xB2,0x99,0x44,0x5F,0x49,0xAD,0x2D,0x1C,0xB1,0x6D,0xDA,0x0C,0xD1,0x98,0x7A,0xA9,0x66,0x00,0x50,0xC0,0x32,0x1E,0x1E,0x10,0x40,0x72,0x49,0x0F,0x00,0x00};
extern const uint8_t spt_J[]                 PROGMEM ={0xA1,0xBD,0xAB,0x90,0xC1,0xD4,0x19,0x60,0x47,0x86,0x56,0xED,0xE2,0xC2,0x6C,0xD9,0x57,0x15,0xB2,0xA9,0x68,0x35,0xB9,0xD5,0xAE,0x76,0xB5,0xAA,0x14,0x4C,0x3C,0xAA,0xC5,0xAC,0x66,0x33,0xDA,0x9A,0x9C,0x2D,0xA2,0x71,0x1F,0xD2,0x10,0x23,0x71,0x55,0x47,0x0A,0xA3,0x31,0x66,0x3D,0x6E,0x29,0x8C,0x41,0x8B,0x54,0x87,0xE9,0x07};
extern const uint8_t spt_JOYSTICK[]          PROGMEM ={0x01,0x38,0x49,0x79,0x15,0xC5,0xA5,0x91,0x5B,0xB7,0x53,0x38,0x53,0x95,0xCE,0xD9,0x6E,0x7E,0xB3,0x93,0x79,0x57,0x19,0xC6,0x79,0x57,0xE6,0x53,0x58,0xA8,0xAD,0x5E,0x45,0x0C,0x29,0x9A,0xBE,0x66,0x34,0xC1,0x85,0x78,0x64,0x15,0x05,0xFC,0xAC,0x6C,0x01,0x0D,0x68,0x00,0x03,0x60,0x80,0xAD,0x4D,0x46,0x5E,0x62,0xA8,0xAA,0xAD,0xBD,0x4D,0xEB,0x63,0xE1,0xB0,0x98,0xC5,0x6E,0x08,0x0D,0x33,0x72,0x26,0xB3,0x29,0x38,0x95,0xCE,0x70,0x04,0xC0,0x00,0x6B,0x9D,0x18,0xE0,0x92,0x28,0x06,0xE0,0x01};
extern const uint8_t spt_JUST[]              PROGMEM ={0x09,0xB8,0x8E,0x60,0xA5,0xC3,0x9A,0x89,0x78,0x9F,0x93,0x67,0x9B,0x2A,0x96,0x6F,0x4F,0x1E,0x62,0xBB,0x8B,0xB7,0xBD,0xC5,0xAD,0x6E,0xD5,0x2A,0x2F,0xC7,0x3C,0x22,0x94,0x02,0xBE,0x95,0xF0,0x80,0x03,0x7E,0x32,0x55,0xC0,0x1F,0xC1,0x1C,0xC0,0x00,0x28,0xA0,0x6A,0x77,0x05,0xDC,0x20,0x22,0x80,0xA4,0x53,0x1E,0x00,0x00};
extern const uint8_t spt_K[]                 PROGMEM ={0x09,0xE8,0x51,0x25,0x02,0x0E,0xC8,0xD1,0x78,0x44,0xB9,0x99,0x89,0x57,0x93,0x9D,0xDC,0xF4,0x64,0xA5,0xAA,0xAA,0x65,0x9D,0x9B,0xDF,0xE2,0xD6,0xAB,0xF3,0x56,0xBC,0xBB,0x42,0xF7,0x21,0x0F,0x61,0x4C,0x5E,0x24,0x36,0x2B,0xC5,0xC9,0x4E,0x0F};
extern const uint8_t spt_KEY[]               PROGMEM ={0x01,0x18,0x9E,0x2D,0x02,0x1E,0x68,0xFE,0x08,0xC6,0x10,0xF5,0x78,0xC6,0x3B,0xD9,0xE9,0xAE,0x76,0xBD,0xDB,0xDD,0x8D,0x7E,0x14,0x13,0xB0,0x7A,0x52,0x86,0xEC,0x99,0x65,0xB6,0x74,0x18,0xB2,0x14,0x8A,0x4F,0xC3,0x76,0xD4,0xA3,0x9D,0x1E,0x00,0x00};
extern const uint8_t spt_KEYBOARD[]          PROGMEM ={0x06,0x18,0x23,0xD4,0x01,0xDD,0x0A,0x7B,0x60,0xF8,0x2B,0xAA,0x40,0xE4,0x97,0x19,0xCE,0x70,0x85,0x23,0x3A,0x43,0xE6,0xD7,0x1E,0xA9,0x84,0x5A,0xAF,0x36,0x4D,0xAC,0x73,0x55,0x29,0x95,0x9F,0x8A,0xDA,0x73,0x51,0x8B,0x5A,0x95,0x5A,0x9A,0xFC,0x52,0xD4,0xDE,0x6A,0x63,0x7C,0xCB,0x48,0xFD,0x68,0x8C,0xF3,0x09,0x67,0xF5,0xA3,0x35,0xA5,0x4A,0x4C,0xD4,0x8F,0xDE,0x56,0x77,0x0D,0xF1,0xDE,0x7A,0x5B,0x42,0xB5,0x34,0x7B,0xEB,0x7D,0x33,0xE5,0xF2,0xF4,0xA9,0x57,0x41,0xC9,0xAB,0x1C,0xDB,0x5E,0xF7,0xBA,0xD7,0xFD,0x03,0x00,0x00};
extern const uint8_t spt_KNOW[]              PROGMEM ={0xA1,0xF2,0x0E,0x3E,0xD3,0xA9,0x94,0x3A,0x78,0xB8,0xA8,0xA0,0x93,0x6A,0xEF,0xE0,0xA3,0x9C,0xF1,0xAA,0xA2,0xE7,0x32,0xF3,0x24,0xA7,0xB0,0xDE,0xDB,0xDC,0xDB,0xDC,0xFC,0xE6,0x37,0x5F,0x95,0xF2,0xB9,0x61,0xD4,0x65,0x57,0xBB,0x6E,0x2D,0x8F,0xB3,0x6A,0xD4,0xA5,0x76,0xB5,0x0F,0x3D,0xDD,0x1B,0xAA,0x92,0xC8,0xF7,0x0F,0x00,0x00};
extern const uint8_t spt_L[]                 PROGMEM ={0x27,0x8F,0x25,0xDC,0xA4,0x5B,0x9F,0x3C,0xE5,0x08,0xA7,0x6A,0x73,0xF2,0x10,0xCB,0x83,0xAB,0xCE,0xCD,0x4F,0xE5,0xE4,0x8D,0xA9,0x74,0xBA,0x55,0xA9,0xF8,0x3E,0x11,0xCF,0x4A,0xB5,0xCE,0x75,0xAE,0x43,0xC3,0xCF,0x84,0x70,0xD6,0x72,0x0D,0xDB,0x67,0xE4,0x11,0xDB,0x35,0xBC,0x7C,0x92,0x6A,0x63,0xD5,0xB2,0xB8,0xAE,0xA2,0xB6,0x79,0xFB};
extern const uint8_t spt_LARGE[]             PROGMEM ={0xA5,0xB1,0xC6,0x5A,0xB9,0x5A,0xB5,0xDA,0x6A,0x9D,0x80,0x49,0xBD,0x2A,0xAF,0xAB,0x9B,0x79,0xCE,0xAD,0x56,0x11,0x4C,0x55,0x09,0x2F,0x59,0x85,0x8B,0x95,0x29,0xD2,0x64,0x54,0xAE,0x97,0x64,0x50,0x93,0x5D,0xED,0x6A,0xD5,0x7E,0xB9,0x7A,0x50,0xD6,0x59,0xAF,0x3A,0xD4,0x52,0x2E,0x49,0xDF,0x9B,0xD0,0xC6,0x1E,0x82,0x1E,0xF5,0x01,0x34,0xA0,0x01,0x09,0x48,0x80,0x03,0x14,0x78};
extern const uint8_t spt_LARGER[]            PROGMEM ={0xA9,0xB5,0x9A,0xAF,0x24,0x3C,0xB6,0xDA,0x6B,0xFE,0x94,0xF0,0x74,0x2A,0xE3,0x7B,0x42,0x64,0xC9,0x29,0x9C,0x99,0xB1,0xE0,0xCE,0x27,0xB3,0x39,0x35,0x83,0xBD,0xEC,0x6C,0x65,0x21,0xB6,0x78,0x93,0x97,0x95,0xC7,0x5C,0xA2,0x25,0x5E,0x77,0xB1,0xEB,0xD9,0xE4,0x5E,0x01,0x8D,0xB0,0x6A,0xA0,0x74,0x7E,0x92,0x45,0x6A,0xD7,0xDA,0x87,0xC1,0x2F,0xB2,0x48,0x79,0x1D,0x07,0x3F,0xE8,0x81,0x0F,0x0F,0x00,0x00};
extern const uint8_t spt_LARGEST[]           PROGMEM ={0xA5,0xD0,0xCA,0xB3,0x39,0x66,0x8E,0xCA,0x0B,0xF7,0x15,0xED,0xB4,0xAA,0x20,0xCC,0x9F,0xDC,0xCD,0x29,0xA2,0xF1,0x29,0x93,0x36,0xA7,0xF0,0x3E,0xA6,0x8D,0xD3,0x9C,0xC2,0xE6,0xCC,0x11,0x49,0x7D,0xF3,0x93,0xFB,0x69,0x56,0x2A,0xAD,0x4E,0x1E,0xA7,0xAB,0xB9,0xA6,0x5D,0x55,0x5A,0xA6,0x64,0xE1,0x26,0x54,0xAF,0x65,0x0A,0x10,0xDD,0x04,0x34,0xC2,0x3A,0xEA,0x9B,0xC3,0x08,0x55,0x5B,0xAB,0x83,0x37,0x15,0x9B,0x39,0xA3,0x0D,0xD6,0x42,0x2D,0x6F,0x97,0xDE,0x04,0x77,0x8D,0xAD,0x54,0xFA,0xA0,0x42,0x43,0x2A,0xB5,0x03,0xBE,0x34,0xF1,0x80,0x07,0x28,0x00,0x08,0x40,0xB9,0xC3,0x00,0x47,0xBB,0x09,0x20,0x69,0xE7,0x07};
extern const uint8_t spt_LAST[]              PROGMEM ={0xA1,0x61,0xFE,0x25,0xB9,0x22,0x96,0x46,0xF8,0xB5,0x82,0xB7,0x32,0x6A,0x3E,0x52,0x23,0xDA,0xD1,0xA9,0x6C,0xCD,0xF0,0x98,0xB0,0xB7,0xB8,0xF9,0xCD,0x6F,0x71,0xAB,0xD3,0x84,0x1E,0x29,0xD6,0x56,0x76,0xD3,0xDB,0xDC,0x29,0x60,0xAB,0x34,0x0D,0x68,0x40,0x02,0x1C,0xC0,0x00,0x80,0x01,0x12,0xCB,0x60,0x40,0x51,0x25,0x0F,0x00,0x00};
extern const uint8_t spt_LEARN[]             PROGMEM ={0xA5,0xB3,0xDA,0x3A,0x85,0xB7,0xB4,0x26,0x6A,0x8E,0x36,0xCC,0xDB,0x6A,0xE9,0xAB,0x92,0x32,0xC9,0xAC,0x56,0x61,0x74,0x8F,0xBB,0x66,0x5A,0x99,0xD5,0x55,0x56,0x92,0x79,0x65,0xCE,0xB7,0xF1,0xAA,0xDA,0x99,0xCF,0x62,0x54,0x21,0x8E,0x52,0xB9,0xB6,0x59,0xEF,0x76,0x75,0x21,0xA7,0x61,0x84,0xF3,0xD9,0xCD,0x3E,0xF4,0x52,0xCB,0xA4,0x85,0x65,0xDF,0xFB,0xCE,0x75,0xCA,0x70,0xB9,0x76,0x2C,0xD7,0x69,0x4D,0x1B,0x16,0x76,0x42,0x67,0x55,0x84,0x64,0xDA,0x7E,0x00,0x00};
extern const uint8_t spt_LEFT[]              PROGMEM ={0xAD,0x0E,0xB0,0x96,0x2B,0x5A,0x8C,0xC2,0x93,0x49,0xAE,0x5C,0x78,0x72,0x1F,0x23,0xC5,0xBE,0xF6,0xCD,0x6F,0x71,0xEA,0x58,0xA2,0xC4,0x3A,0xF1,0x6D,0x5B,0xE7,0x63,0x04,0x7B,0x4C,0x8A,0x23,0x03,0xA2,0x35,0xD1,0x80,0x02,0x86,0xF7,0x00,0x00,0x70,0x40,0x17,0xE6,0x08,0x60,0x29,0xFD,0x01,0x00,0x00};
extern const uint8_t spt_LESS[]              PROGMEM ={0xA6,0x16,0xBA,0xDB,0x43,0x52,0x85,0xD6,0x88,0x2A,0x76,0x6D,0x53,0x5A,0xA7,0xD4,0xC3,0xA8,0x6B,0x6B,0x9C,0x31,0x2F,0x92,0xAE,0xA7,0x8E,0xC9,0x5B,0xAC,0xB6,0xDD,0xFA,0xD6,0xA7,0x4A,0x59,0x47,0xB8,0x52,0xDE,0xEA,0x14,0xB1,0x66,0xA3,0x66,0x92,0x52,0xB8,0x1C,0xCE,0x31,0xA1,0x15,0xF0,0x63,0xB8,0x07,0x0C,0xF0,0x83,0x87,0x07,0x02,0xF0,0x83,0x47,0x00,0x9E,0xC9,0x32,0xC0,0x51,0x96,0x04,0x70,0xB1,0x98,0x00,0x31,0x63,0xC2,0x03,0x00,0x00};
extern const uint8_t spt_LET[]               PROGMEM ={0xA9,0x49,0xCA,0x79,0xC1,0xDA,0x96,0x26,0x5A,0xE3,0x06,0xEF,0xBD,0xEA,0x9C,0xA5,0x5C,0x73,0xD3,0xAE,0x67,0x35,0xAB,0x59,0xC4,0x1C,0x00,0xC0,0x01,0x4D,0x84,0x0B,0x60,0xCA,0x30,0x04,0xF8,0xEC,0xF4};
extern const uint8_t spt_LIKE[]              PROGMEM ={0xAA,0x96,0xB1,0x5F,0xB1,0xD3,0xC4,0xAA,0x36,0xB3,0xDE,0xD5,0x29,0x5C,0xCD,0xD6,0x68,0x27,0xB7,0x38,0x55,0xAC,0x31,0x6A,0xED,0xE4,0x34,0xB9,0x45,0x19,0xB7,0x9B,0xD6,0xA7,0xA5,0x49,0xB5,0x1A,0xD3,0x58,0xBA,0x18,0xFB,0x46,0x74,0x53,0x69,0xA8,0x16,0x55,0x0A,0x00,0x0C,0x90,0x73,0xA0,0x06,0x24,0xF0};
extern const uint8_t spt_LIKES[]             PROGMEM ={0xC4,0x75,0x20,0x6D,0x24,0x1D,0x99,0x4A,0x8B,0xF2,0x82,0x4C,0x16,0x5A,0x43,0xD7,0x12,0x66,0x6E,0x69,0x0C,0xCF,0x6C,0x88,0xD6,0xA5,0xB2,0xB2,0xAF,0x50,0x7A,0xCD,0x6A,0x15,0x26,0x6C,0x1B,0xD7,0x92,0x9D,0xCF,0xEC,0xE4,0xDE,0x4F,0x39,0x57,0x93,0x53,0x25,0x37,0x11,0xE2,0x4D,0x4F,0x9B,0x53,0x85,0x8B,0x37,0x1D,0x7D,0xF2,0x25,0x9E,0xD9,0xA8,0x8C,0xB1,0x88,0x46,0xD5,0xE4,0x38,0xFA,0x11,0x00,0x08,0xE0,0x97,0x88,0x00,0xDC,0x72,0x36,0xC0,0x96,0x95,0x06,0xF8,0x3E,0x27,0x00,0x3F,0xBB,0x3B,0xE0,0x07,0x55,0x03,0x7C,0xA3,0x62,0x80,0x2F,0x55,0x1E};
extern const uint8_t spt_LINE[]              PROGMEM ={0x00,0xA1,0xE2,0xEE,0x35,0x25,0xA2,0xA4,0x42,0x98,0xEE,0x81,0x88,0xD3,0x5A,0x65,0xFC,0x13,0xC6,0xF3,0x29,0x8C,0x8D,0x57,0xCC,0x2C,0xA7,0x30,0xB1,0x5E,0xA4,0xD2,0x9C,0xCA,0xE4,0x3E,0xC9,0x4E,0x73,0x2A,0x93,0x7B,0xD4,0xDA,0xCA,0xA9,0x4C,0xEA,0xB6,0x2A,0x2B,0xA7,0xB2,0xA9,0xCB,0x2D,0xAD,0x9C,0x2A,0x84,0x4A,0xB3,0xB0,0x72,0x9A,0x94,0x35,0x55,0x33,0xD6,0x6A,0x63,0xD5,0x90,0xCA,0x58,0xA3,0xCF,0x55,0x4D,0xA2,0x62,0x95,0x31,0x15,0x72,0xA9,0x8E,0x95,0xC7,0x32,0x26,0xAF,0x9C,0x56,0x29,0xCD,0xC8,0x9D,0x46,0x49,0xA5,0x34,0x23,0xB5,0x69,0xE5,0xE5,0xC8,0x8D,0x3E,0xA9,0xAA,0x76,0xCA,0x07,0x00,0x00};
extern const uint8_t spt_LOAD[]              PROGMEM ={0x21,0x37,0xCA,0x63,0xC1,0xBC,0xB5,0xDE,0x1B,0x9A,0x46,0xF3,0xD6,0xDA,0xE4,0xA0,0x87,0x32,0xDF,0xAA,0xA2,0x95,0x3D,0xCA,0x7C,0xAB,0x32,0xC6,0x7F,0x20,0xF3,0x8D,0x42,0x85,0xDE,0x02,0xC9,0x36,0x0A,0x1D,0x7B,0x0A,0xD1,0x7F,0xAB,0x94,0xEF,0x29,0x42,0xFF,0xAD,0x52,0xA6,0xA7,0x08,0xBB,0xB6,0x46,0x9B,0xD8,0x44,0xCC,0x57,0x3A,0xAB,0x7D,0xDD,0xA0,0x4F,0xEA,0xAD,0x8C,0x63,0x87,0xDE,0x69,0x74,0xCA,0x26,0x12,0xFA,0xA4,0xC9,0x5A,0x9E,0x71,0xF1,0x1C,0x26,0x6F,0xA8,0x2A,0x31,0x15,0x9B,0xA8,0x8A,0x6C,0xCB,0x54,0x6A,0xA2,0xB2,0xCA,0x7C,0x14,0xB1,0x89,0xCA,0xC8,0x74,0x75,0x12,0xA6,0xEE,0xC2,0x45,0x25,0xA9,0xED,0x44,0x9B,0x83,0xB9,0x73,0xA6,0x42,0x7D,0xB6,0x6E,0x06,0xA4,0xE4,0x01,0x00,0x00};
extern const uint8_t spt_LONG[]              PROGMEM ={0xA9,0x0D,0x16,0xBB,0x21,0xF3,0xA5,0x2E,0x39,0x98,0x81,0xD0,0x37,0x5A,0xAB,0xAD,0x1B,0x93,0xED,0xAA,0x55,0xEC,0x4F,0x88,0xB6,0xA3,0x92,0x63,0xC7,0x21,0x5A,0x8F,0x42,0xDB,0x3F,0x27,0xCB,0xBC,0x32,0xAB,0xFE,0x8D,0x2C,0xF3,0xC8,0xBC,0xD8,0x37,0x8C,0xD6,0x33,0x6F,0x85,0x8E,0x3F,0xAC,0x9D,0x61,0x54,0xAA,0x5E,0x8A,0x46,0xA2,0xD1,0xE8,0x78,0xAD,0xEA,0xAD,0x4F,0x6B,0xF2,0x96,0xAA,0xB6,0x6E,0x9D,0x49,0x9D,0x61,0xD4,0x39,0xF4,0x3E,0xC0,0xB9,0x5A,0x1D,0xDF,0xBB,0xDE,0x7A,0xF8,0x50,0x8D,0xED,0x3A,0xED,0xE8,0x5D,0x4D,0xB1,0xEF,0x6C,0xFF};
extern const uint8_t spt_LOOK[]              PROGMEM ={0xA6,0x91,0x3A,0x3B,0x20,0xEF,0xA4,0xC6,0x71,0xAF,0x02,0xED,0xD6,0xEA,0xA8,0x78,0x12,0x34,0x6F,0xCB,0x92,0xA2,0x6E,0xA4,0x7C,0x23,0x0B,0x3C,0x36,0x44,0x9A,0x8E,0xCC,0xB2,0x79,0x96,0x5C,0xD5,0x32,0x2D,0xBF,0x21,0xBB,0xD1,0x28,0xAC,0xD8,0x55,0xD5,0x2D,0xBD,0x2E,0x9D,0x93,0xDD,0xEE,0xB4,0xC7,0x0D,0xDA,0x56,0xA4,0x4A,0x67,0x00,0x50,0x40,0xDE,0xA6,0x0A,0x88,0xD1,0x48,0x00,0xC5,0x17,0x30,0xA0,0xC4,0x20,0x04,0x58,0x2F,0xFC};
extern const uint8_t spt_LOOKS[]             PROGMEM ={0xA6,0x91,0x3A,0x3B,0x20,0xEF,0xA4,0xC6,0x71,0xAF,0x02,0xED,0xD6,0xEA,0xA8,0x78,0x12,0x34,0x6F,0xCB,0x92,0xA2,0x6E,0xA4,0x7C,0x23,0x0B,0x3C,0x36,0x44,0x9A,0x8E,0xCC,0xB2,0x79,0x96,0x5C,0xD5,0x32,0x2D,0xBF,0x21,0xBB,0xD1,0x28,0xAC,0xD8,0x55,0xD5,0x2D,0xBD,0x2E,0x9D,0x93,0xDD,0xEE,0xB4,0xC7,0x0D,0xDA,0x56,0xA4,0x4A,0x67,0x00,0x20,0x80,0xBB,0xC5,0x0C,0xD8,0xCA,0x92,0x01,0x3F,0x7B,0x72,0x80,0x03,0x1C,0xE0,0x00,0x05,0x1E,0x00,0x00};
extern const uint8_t spt_LOWER[]             PROGMEM ={0xA9,0x2F,0x01,0x36,0x9D,0xF0,0xF7,0x6E,0x36,0xA3,0x92,0x21,0xBF,0x40,0xDB,0xCD,0x6A,0xA6,0x3D,0xAD,0x69,0xC8,0x79,0xA9,0x17,0xF0,0xBE,0xA9,0x12,0xD9,0x5E,0x94,0xF3,0x94,0x56,0x74,0xCF,0x49,0xCD,0x93,0x87,0x30,0xF1,0xE9,0xBD,0xE1,0x72,0xDD,0x22,0x9B,0xDA,0x07,0xA7,0x31,0x8B,0x6E,0xEC,0x5F,0xAA,0xC6,0x2C,0xA6,0xA8,0xE6,0x19,0x6D,0x77,0xF8,0x66,0x6C,0xDA,0xB6,0xE0,0x01,0x00,0x00};
extern const uint8_t spt_M[]                 PROGMEM ={0x2D,0xCA,0x5E,0x34,0xAA,0x4A,0xAD,0x34,0x27,0x15,0xCF,0x1A,0x75,0xD3,0x95,0xE5,0x24,0x69,0x9E,0xB5,0x4E,0x11,0x5D,0xA6,0xAB,0xA6,0xD9,0xD5,0x68,0x4C,0x1A,0x77,0xB1,0x54,0xA9,0xD5,0x96,0xCA,0xB9,0xB3,0xE5,0x2E,0xF7,0xB1,0xB7,0xBD,0x1D,0xF4,0x08,0x0F,0x00,0x00};
extern const uint8_t spt_MADE[]              PROGMEM ={0x6A,0xD4,0x96,0xCA,0xB9,0xB3,0xB9,0xCE,0x3A,0x6C,0xD1,0x68,0x5B,0x1A,0x1F,0xB0,0x59,0x3C,0xED,0xA9,0xCA,0xF2,0x20,0xAD,0x34,0xB7,0xB8,0xF9,0xC9,0xEB,0x10,0xE5,0x9C,0x3A,0xBB,0x98,0xD5,0x6C,0x66,0x9B,0xFA,0x52,0x48,0xA4,0x67,0x72,0xEE,0xE3,0x00,0xC0,0x46,0xAA,0x32,0x2A,0xC2,0x89,0x1D,0xDD,0x18,0xB4,0xB9,0x95,0xCF,0x14,0x63,0xCC,0x62,0x2C,0x95,0x18,0x1E};
extern const uint8_t spt_MAGENTA[]           PROGMEM ={0xA2,0xA0,0x26,0xF2,0xCD,0x9D,0xB4,0x4E,0xC5,0x68,0xE7,0x4A,0xB4,0xBA,0x10,0xB5,0x83,0xBD,0xF7,0xE9,0x72,0xB4,0x54,0x93,0x4E,0xA5,0x8B,0x9E,0xCD,0xD8,0x72,0x8A,0x1E,0xDB,0xD8,0x71,0xB3,0xC9,0x06,0x2A,0x2B,0x33,0xCA,0x96,0x02,0x1A,0x41,0xB6,0xC0,0xAA,0x6A,0x34,0x13,0xF1,0x37,0x2B,0x0D,0x4E,0xD3,0xA3,0x2A,0xAD,0xD4,0x07,0x1D,0xB7,0x91,0xB9,0x52,0x1F,0x2D,0xD5,0xCB,0x76,0x4F,0x4D,0xCE,0x8D,0x5D,0x53,0x5A,0x36,0x40,0xB1,0x2A,0x06,0xF0,0xD8,0x6D,0xD5,0x21,0x49,0xAB,0x4E,0xEA,0xDB,0xAD,0xC9,0x27,0x9D,0x90,0x5C,0x92,0x66,0x17,0x3C,0x4A,0x35,0x72,0x5A,0x43,0x36,0x2F,0x8A,0x4A,0x69,0x8D,0x85,0x33,0x2C,0x94,0x9A,0xD9,0x26,0xB5,0xE0,0xB2,0xF2};
extern const uint8_t spt_MAKE[]              PROGMEM ={0xA2,0xE1,0x56,0x66,0xB8,0x13,0x87,0xCE,0x3A,0x2C,0xB7,0xF4,0x92,0x1A,0xE7,0xB1,0xC4,0xD2,0xCF,0xA9,0x4A,0xF1,0x70,0xA5,0xAD,0xA7,0x28,0xC5,0xDD,0xD4,0x97,0x9E,0xAC,0x64,0x33,0xD3,0x9E,0x73,0xB3,0x93,0xD5,0x6A,0xA2,0xBA,0xB3,0x4F,0xD5,0x46,0x88,0x70,0xBD,0x19,0x6D,0x49,0x42,0x56,0x3D,0xA9,0xF6,0x6E,0x2A,0x95,0x20,0x72,0x13,0x03,0x00,0x18,0x20,0x55,0x65,0x05,0xC4,0xA6,0x28,0x80,0x9C,0x13,0x1E};
extern const uint8_t spt_ME[]                PROGMEM ={0xAC,0x53,0x96,0xB2,0x53,0x33,0x9B,0x36,0x0F,0x30,0x35,0xAE,0xDF,0xDB,0x59,0xAF,0xAA,0xF7,0x52,0x60,0x79,0xBB,0xAB,0x59,0xF5,0xAA,0xB7,0xBD,0xAD,0x6D,0x69,0x5B,0x0B,0x06,0xF3,0x27,0xA5,0xAD,0x45,0x48,0xB2,0x26,0x87,0x3E,0x7A,0xF0,0xEC,0x36,0x6C,0xFA,0x60,0xC1,0xB3,0x52,0x32,0xEB,0x53,0x42,0x66,0x6D,0x39,0x0F,0x00,0x00};
extern const uint8_t spt_MEAN[]              PROGMEM ={0xAE,0x35,0x0E,0xAA,0x2C,0x12,0xA7,0xD6,0x05,0x28,0x75,0x4B,0x3D,0xDA,0x94,0x54,0xD5,0xB4,0xCD,0xA9,0x5A,0x49,0x41,0xB5,0xD7,0xB7,0xBA,0xD5,0xAE,0x46,0x55,0xAD,0xB0,0xEC,0x04,0xDE,0x55,0xAF,0x67,0x33,0xDB,0xD9,0x85,0xCE,0x3A,0xA8,0xD2,0x96,0x1D,0xFB,0xD0,0x5B,0x87,0x6D,0x51,0x8A,0x55,0x2F,0xAD,0x4C,0x6A,0x5B,0x32,0x7D,0xD6,0x05,0x4A,0xD1,0xF8,0x01,0x00,0x00};
extern const uint8_t spt_MEMORY[]            PROGMEM ={0xA4,0x56,0x96,0x2D,0x29,0xF3,0xB2,0xC2,0x78,0xF4,0x90,0x4C,0x1B,0xAA,0x94,0x2D,0x54,0xAD,0xCD,0xAD,0x6E,0x75,0x8B,0x95,0x97,0x6A,0x6D,0x18,0xC9,0x5C,0xE5,0x12,0x15,0x71,0x24,0x33,0x95,0xCF,0x98,0x22,0xD2,0x38,0xD7,0xA9,0xB1,0x9B,0xCA,0x82,0xDD,0xE4,0x36,0x76,0xA1,0xB3,0x8B,0xCA,0x52,0xBC,0x84,0xDE,0x4F,0x4A,0x1E,0xE9,0x94,0xFA,0xD0,0xC5,0x35,0x7C,0x59,0x18,0x52,0xE1,0x90,0xEC,0xD9,0x6E,0x88,0x89,0xCC,0x6B,0x22,0xAB,0x21,0x5A,0xD6,0xEC,0x0A,0xAC,0x86,0x1C,0xC0,0x22,0x46,0xAC,0x19,0x4B,0x02,0x8B,0x18,0xA9,0x0F};
extern const uint8_t spt_MESSAGE[]           PROGMEM ={0xA6,0xD3,0x0E,0xAA,0x24,0x63,0x87,0xCE,0x05,0x68,0xD5,0x76,0xD2,0xDA,0x90,0x30,0x94,0x25,0xCB,0xA9,0x4B,0xF5,0x56,0xF1,0x36,0xB7,0x3A,0x55,0x2E,0x5E,0x4A,0x93,0x7A,0x54,0xDE,0x85,0x25,0x9F,0xE4,0x58,0x19,0xE0,0x29,0x57,0x03,0xBC,0x68,0x64,0x80,0xA7,0x5D,0x05,0x50,0x89,0xF3,0x68,0x72,0x51,0x57,0xF1,0xA7,0xBB,0x9B,0x43,0x1E,0xC3,0x14,0xB4,0xB1,0xBB,0x2F,0x70,0x93,0x94,0x2E,0x56,0x95,0x80,0x4D,0x5C,0xA6,0x97,0x87,0xED,0x32,0xED,0xAC,0x20,0x92,0x4E,0x14,0xB0,0xBB,0xA2,0x02,0xCE,0x08,0x52,0xC0,0xCA,0xC2,0x04,0x48,0x4A,0x05,0xE0,0x01};
extern const uint8_t spt_MESSAGES[]          PROGMEM ={0xAE,0x67,0xDE,0x35,0xAC,0x12,0xA6,0xDE,0x46,0x0C,0x95,0x48,0x9D,0x5A,0x9F,0xC4,0x45,0xB1,0xED,0x68,0x4A,0xCA,0x50,0xE3,0xA4,0xB7,0x1A,0x45,0x6E,0x51,0x86,0x99,0x76,0xA4,0xBE,0x9A,0x4B,0x8C,0xE2,0x92,0x26,0xD7,0xA4,0xD0,0x51,0x1C,0xB0,0xA0,0x8A,0x05,0x2C,0x10,0xC2,0xEA,0x42,0x55,0xB9,0xEB,0xAD,0x56,0xDD,0x43,0xA8,0x18,0xE4,0x0B,0x5D,0x91,0xAA,0xEC,0xD2,0x55,0xF4,0x16,0x5B,0x66,0x84,0x42,0x03,0x74,0x02,0x36,0xDA,0x96,0xDC,0xCC,0xB0,0xFB,0xED,0x76,0x37,0xFB,0xD2,0x7B,0x27,0x65,0x9A,0x4B,0xC3,0x10,0x68,0x86,0x7B,0xE4,0x4C,0xC3,0xA3,0x1C,0xE1,0x91,0x46,0x01,0x07,0xB0,0x30,0xE0,0x1B,0x56,0x02,0x7C,0x25,0xFA};
extern const uint8_t spt_MIDDLE[]            PROGMEM ={0xA9,0xCD,0x0D,0x82,0x55,0x92,0xB5,0x3A,0x66,0xB0,0x10,0xAD,0x7E,0x8A,0x98,0x34,0xD4,0x2F,0xD6,0xCD,0x6F,0xD6,0x72,0x1B,0xAD,0x8C,0x36,0x6A,0xAB,0x3D,0xAB,0x28,0xA3,0xB6,0xB3,0x6A,0x95,0xB4,0xDF,0xC6,0xD2,0xA6,0x37,0xB5,0x4B,0xBD,0x34,0xBF,0x22,0x9E,0x25,0x8C,0x5A,0xEE,0x3B,0x53,0x9F,0x30,0x69,0xF1,0xA3,0xC2,0x8B,0x1E,0x00,0x00};
extern const uint8_t spt_MIGHT[]             PROGMEM ={0xAE,0xB3,0x4E,0x9B,0x94,0x53,0x87,0xCE,0x59,0x69,0x56,0xB6,0x9B,0xDB,0x5C,0x9F,0x2A,0xA4,0xCE,0x90,0x8A,0x73,0xAB,0x53,0x85,0x5A,0xE9,0x52,0x71,0x4E,0x95,0x7A,0xA6,0x49,0x56,0x59,0x75,0x1E,0xE6,0x2A,0x1D,0x67,0xD4,0xB9,0xA8,0x98,0x57,0xE5,0x54,0x47,0x2F,0x92,0x9D,0x85,0x4D,0x15,0xA5,0xA9,0x8B,0x2B,0x06,0x00,0x06,0x24,0x1D,0xC4,0x80,0x6E,0xD4,0x08,0x10,0x83,0x32,0x3C,0x00,0x00};
extern const uint8_t spt_MODULE[]            PROGMEM ={0xAE,0x51,0x4E,0x5A,0xD4,0xD5,0x84,0xD6,0x3A,0x69,0x51,0x96,0x9B,0x5A,0xE3,0xB4,0x45,0x4C,0xE9,0x6C,0x4E,0x9D,0x42,0x74,0x50,0xD9,0xBD,0xD5,0xAD,0x4E,0x11,0x43,0x56,0x50,0xC5,0x39,0x45,0x72,0x23,0x8E,0x95,0xD4,0x55,0x2A,0x2A,0x45,0x8C,0x6D,0x56,0x21,0x3F,0x9E,0x9E,0x92,0x0D,0x90,0x08,0xEB,0x6A,0x52,0x30,0x95,0xD0,0x74,0xBB,0x19,0x4D,0xD0,0x16,0xDE,0x98,0x6E,0xB6,0xA5,0xB3,0x3A,0xDA,0x13,0xBA,0xA6,0x5E,0xA4,0x19,0x76,0xCB,0x9D,0x66,0x11,0x6B,0xD3,0xC8,0x9F,0x99,0x45,0x8A,0x6F,0x26,0x2F,0x0F};
extern const uint8_t spt_MORE[]              PROGMEM ={0xA1,0x4D,0x1E,0xC6,0x94,0xE5,0x85,0x36,0x58,0x68,0x57,0x91,0xD7,0xEB,0x54,0xB1,0xDB,0xC6,0x34,0x75,0x72,0x15,0x2A,0x76,0xB3,0x80,0x3F,0x49,0xAC,0x52,0xC5,0x47,0x1D,0xA3,0xB7,0x6D,0xB5,0xC8,0x39,0x29,0xEC,0x7E,0x34,0x3A,0x7B,0x95,0xB3,0xF2,0xD2,0xA9,0x29,0xB9,0xA2,0x59,0xF3,0x90,0x06,0xB3,0xC4,0xD7,0x24,0x8F,0x1B,0xF5,0x10,0x7B,0x4E,0x4D,0x61,0xB0,0x5D,0x64,0xCD,0x55,0x9B,0x3E,0x2C,0xE2,0xD0,0xD0,0xFC};
extern const uint8_t spt_MOST[]              PROGMEM ={0xAD,0x49,0x1E,0x53,0x8C,0xED,0x96,0xDA,0xBA,0x3C,0x63,0x5D,0xB3,0xAB,0x52,0x88,0xDD,0xC6,0xD5,0x11,0x6B,0x5E,0xF3,0x52,0x39,0x19,0x6B,0x0E,0x7D,0x6B,0x9D,0x5B,0xD3,0x8B,0x50,0x29,0x6E,0xAD,0x04,0xB0,0x54,0xA8,0x05,0x1C,0xF0,0x63,0x98,0x05,0x3C,0x60,0x01,0x09,0x50,0x80,0x00,0x56,0x88,0x19,0x60,0x19,0x72,0x01,0x54,0x15,0x0E,0x00,0x40,0xFA,0x6C,0xDD,0x5C,0x4D,0xF1,0x03,0x00,0x00};
extern const uint8_t spt_MOVE[]              PROGMEM ={0xA5,0x4A,0x0E,0x5D,0x13,0xF4,0x96,0x3A,0x7B,0x30,0x1B,0x48,0xD6,0x2A,0xE9,0x37,0x44,0xAB,0xD9,0xCE,0x66,0xDA,0x12,0x11,0xC7,0x55,0xB3,0x76,0x49,0x78,0x6D,0xB6,0xCC,0xCA,0x25,0x13,0xAD,0x84,0xBD,0x5B,0x95,0x4A,0x9A,0x1E,0x74,0xDB,0xD4,0xEA,0xC8,0xF4,0xD9,0xA4,0x7B,0xEB,0x82,0xD4,0xB1,0x84,0xEC,0x75,0xA8,0x43,0x1E,0xC2,0x64,0x55,0xB4,0x3A,0x74,0x75,0xB3,0x31,0xEE,0x61,0x21,0x07,0x01,0x54,0xA4,0x10,0x20,0xD8,0x50,0x01,0x04,0xE7,0x4A,0x00,0x9F,0x43,0xE0,0x01,0x00,0x00};
extern const uint8_t spt_MUST[]              PROGMEM ={0x6A,0x14,0x4A,0xB2,0xD4,0xDD,0xBA,0x26,0x58,0x2C,0x75,0x71,0x12,0xEA,0x68,0xB1,0xD5,0xD0,0xEE,0xA8,0xBD,0x8D,0x37,0xE1,0xCD,0xBB,0x5A,0x85,0x73,0x75,0xA6,0xD6,0x78,0x17,0xBB,0xDA,0xF5,0x68,0x5D,0xF0,0x52,0x6B,0x29,0xA1,0xCF,0x36,0x4D,0x30,0x95,0x30,0xE0,0xC8,0x54,0x09,0x68,0x40,0x03,0x04,0x80,0x21,0x1E,0x01,0xD0,0xA5,0x03,0x20,0x40,0xEA,0x34,0x05,0x1C,0xA9,0xFE};
extern const uint8_t spt_N[]                 PROGMEM ={0xAB,0x48,0x3A,0x55,0x3F,0x62,0x9D,0x3C,0x15,0x57,0xB3,0x9A,0x7A,0xF2,0xD4,0x2C,0xD8,0x27,0xF6,0xCD,0x77,0xB1,0xAB,0xD3,0xA4,0xEC,0x21,0xEA,0xB3,0x77,0xDB,0x7A,0x13,0xD4,0x55,0xB3,0xB6,0x1F,0xEC,0x60,0x47,0x33,0x7A,0x4F,0xAE,0x9C,0x4E,0xF5,0xC4,0x26,0xA9,0xB9,0x5A,0xD2,0xF2,0x03,0x00,0x00};
extern const uint8_t spt_NAME[]              PROGMEM ={0xAE,0x0D,0x9A,0xCC,0x9F,0xE3,0xA4,0x2E,0x58,0xB0,0x68,0x6B,0x52,0xBA,0x14,0x40,0xBC,0xAD,0x5A,0xED,0x6A,0x9B,0xDB,0xD2,0x54,0x9F,0x26,0x66,0x8F,0x66,0xB5,0xAA,0x16,0xCA,0x44,0x6D,0xF1,0x2E,0x76,0x31,0x8A,0x11,0x52,0xD8,0x63,0xF1,0xAC,0x76,0x35,0x9A,0x9D,0xC2,0xC0,0x7C,0xD1,0xEC,0x5A,0x3F,0x73,0x2A,0xB8,0xAF,0x6E,0x43,0x9D,0x4E,0xEC,0x3E,0xCB,0x0D,0xC6,0xC1,0x38,0x77,0x12,0x3B,0x98,0xD1,0x7A,0x1C,0x91,0x4E,0x63,0x46,0x19,0x24,0x4C,0xB2,0xB5,0x1A,0xB9,0x95,0x4E,0x4D,0xD7,0xA6,0x93,0xD6,0x2D,0xC2,0x13,0xA9,0xD6,0x25,0x23,0xD6,0x88,0x26,0xDA,0xB0,0x82,0xD4,0xC2,0x32,0x3C};
extern const uint8_t spt_NEAR[]              PROGMEM ={0xA2,0x66,0x56,0x6E,0xC4,0x4C,0x99,0x8A,0x5B,0xEE,0xB4,0x28,0x6D,0x2A,0x69,0x39,0xCA,0x6D,0x74,0xA8,0x8C,0x61,0xAB,0xB0,0x4A,0x23,0x6F,0x25,0x99,0xD5,0x57,0xDF,0xEC,0x66,0x27,0x2B,0x3D,0x85,0xCC,0xFB,0xDE,0xFC,0x16,0xA7,0x4A,0x23,0x45,0x42,0xB2,0xDF,0xF6,0x76,0xBB,0x6F,0xBD,0x2B,0xA6,0xFA,0xE6,0xA6,0x0E,0x79,0xF0,0xBD,0xEA,0xAD,0x57,0x96,0x72,0x97,0xAA,0x0B,0xD5,0x89,0x58,0x1C,0x3D};
extern const uint8_t spt_NEED[]              PROGMEM ={0xA1,0x0B,0x0E,0x3C,0xDB,0xA2,0xE4,0xA6,0x54,0xDE,0x42,0x54,0x59,0xE4,0x55,0x55,0xA5,0x42,0x1D,0x8D,0x4F,0xD1,0x04,0xAB,0x7E,0x87,0xEA,0xD9,0xCC,0x66,0x36,0x8B,0x51,0xB5,0xA0,0x44,0x5B,0x93,0x57,0xBD,0x4A,0x28,0x58,0x3C,0x5D,0xCD,0x6C,0xAE,0xA0,0xF1,0x74,0x76,0xB3,0x2F,0x7D,0x2F,0x2A,0x10,0x79,0xA7,0xF5,0xAD,0x88,0x50,0xC4,0x62,0x31,0x44,0x2F,0x24,0x11,0x8B,0xD8,0x40,0x95,0x57,0xA4,0x3B,0xE1,0x83,0x1B,0x52,0x32,0x15,0xF1,0x45,0x7E,0xF0,0xE3,0x03,0x00,0x00};
extern const uint8_t spt_NEGATIVE[]          PROGMEM ={0x62,0xE0,0x5A,0x67,0xDD,0x13,0x89,0x8E,0x19,0xFD,0xD0,0x91,0x98,0xDA,0xE4,0x61,0x33,0x43,0xC9,0x68,0x4A,0xCA,0x70,0xF6,0x35,0xB7,0xBA,0xD5,0xC9,0x73,0x4E,0x57,0xCE,0x25,0x27,0x2B,0xCD,0x55,0xD5,0x96,0xC6,0xCA,0x54,0x39,0x38,0x4A,0x6B,0xE7,0x59,0xEC,0x6A,0xD4,0xC1,0x87,0x98,0xEB,0x66,0x35,0x70,0x53,0x1A,0x9E,0x89,0x48,0x17,0x4D,0x98,0x8B,0x3B,0x11,0x40,0xD4,0x45,0x16,0x58,0x55,0xAC,0xEE,0x2A,0xB6,0xF4,0xB4,0x29,0xA7,0x89,0xF1,0xDA,0xD5,0x86,0x94,0x26,0x2E,0x6B,0x5A,0xEF,0x92,0xB9,0x99,0xCD,0x75,0xBD,0x2E,0x6A,0x66,0x1D,0x5B,0xF5,0xC6,0xA4,0x98,0x46,0x26,0xD5,0xA7,0xD0,0xC6,0xA4,0x4E,0x7C,0x8F,0x00,0xED,0x43,0x30,0xF0};
extern const uint8_t spt_NEXT[]              PROGMEM ={0xAE,0xF6,0x16,0x3E,0x33,0x25,0x85,0xDA,0x5B,0x78,0x8F,0x34,0x5D,0xEA,0xE0,0x60,0x2C,0x5B,0xF6,0xA9,0x73,0xD6,0x50,0xED,0x3A,0xA7,0xCE,0x55,0x53,0x6C,0xEA,0x9E,0x3A,0x77,0x4D,0x8E,0x49,0x72,0x9A,0xDC,0x35,0xC4,0x37,0xC9,0x6C,0x52,0x53,0x2E,0xA9,0xF2,0x44,0x04,0x30,0xC0,0x91,0x51,0x06,0x78,0x29,0x42,0x03,0x12,0x90,0x00,0x08,0x60,0x04,0x55,0x02,0x9C,0xE0,0x82,0x81,0x07,0x00,0x00};
extern const uint8_t spt_NICE_TRY[]          PROGMEM ={0x66,0x54,0x86,0x66,0x3D,0x24,0x9B,0x41,0x1A,0xBA,0x53,0x93,0x1D,0x06,0xEF,0xE0,0x2B,0x9C,0xCA,0xE9,0xB2,0x4E,0xB7,0xD4,0xB4,0xA7,0xCD,0x36,0xCB,0x5D,0x93,0x9F,0x26,0xFA,0xA8,0x50,0x4F,0x76,0x2A,0x1F,0x33,0x42,0x23,0xD9,0x29,0x7C,0x4E,0xAE,0x88,0x2A,0x2B,0xF7,0xD1,0xAD,0x7C,0xCC,0xAC,0x3C,0x7A,0xD3,0xF4,0x33,0xBD,0xF2,0x42,0x5D,0xB3,0xC2,0x42,0x02,0xAE,0x60,0x0E,0xC0,0x9F,0x46,0x01,0x78,0x37,0x09,0x08,0x10,0x25,0x47,0x02,0x46,0x2D,0x2D,0x40,0x2B,0xE5,0x0E,0xC8,0x25,0xBD,0x44,0x7C,0x46,0x84,0xB9,0x9D,0x91,0xAA,0x11,0x5A,0x03,0x6D,0x5B,0xA2,0x7A,0x59,0x34,0x2E,0x69,0xB1,0x29,0xE9,0x95,0x70,0xAB,0xC5,0xD6,0x6D,0x68,0x53,0xA3,0x9E,0x8C,0xCA,0xE6,0xA8,0x74,0x6D,0x52,0x3A,0x5B,0xC2,0xDD,0xBC,0x74,0xE9,0x6D,0x4A,0xED,0xB2,0x18,0x69,0x70,0xCE,0x33,0x27,0x0C,0xA5,0x21,0x28,0x8F,0x69,0x0F,0xE9,0x86,0x14,0x55,0xCC,0x3A,0x14,0x03,0xB4,0x95,0x7A};
extern const uint8_t spt_NINE[]              PROGMEM ={0x80,0x52,0xAA,0x32,0x2B,0xDA,0xB6,0xA9,0xAC,0x95,0x69,0xCD,0x48,0xAE,0xB1,0x5E,0xC7,0xAD,0x4D,0xAE,0x3A,0xBA,0x0C,0x51,0xAA,0x72,0xAA,0xE0,0x3B,0x25,0xB0,0xCD,0xA9,0x6C,0x9C,0x34,0xCD,0x2A,0x2B,0x77,0x61,0xD2,0x2C,0xEB,0x8C,0xDC,0xFB,0x49,0xD2,0x29,0x32,0x0A,0x17,0xC7,0xCD,0x22,0xEA,0xA9,0x62,0xA8,0x70,0xC9,0x7A,0xA7,0x4D,0x39,0x33,0x58,0x9B,0x8E,0x2E,0x76,0x0D,0xD5,0xA8,0xD3,0xFA,0xD0,0x43,0xB4,0x35,0x76,0x19,0x52,0x96,0xD0,0xCC,0xC8,0x65,0x88,0x43,0x45,0x23,0xAA,0xBA,0x31,0x0C,0x23,0xCD,0x18,0xC3,0x46,0x19,0x25,0x52,0xB3,0xA6,0x1A,0xB4,0xE3,0x48,0xA9,0x88,0x66,0x14,0x56,0x3D,0x22,0x1B,0x86,0xD1,0x29,0x37,0xCA,0x8C,0x0B,0x00,0xF0};
extern const uint8_t spt_NINETY[]            PROGMEM ={0xA1,0x73,0x1A,0x3A,0xCA,0x6A,0xE5,0x36,0xB7,0xAB,0x0E,0xB9,0xCA,0xB4,0xEC,0xDC,0xEA,0x56,0xA7,0xCA,0xBD,0x4A,0x24,0x9C,0x9C,0xA2,0x0E,0x4F,0x34,0x4F,0xBC,0x8B,0x55,0xB4,0xC2,0x2C,0xD9,0x96,0x57,0x95,0x1C,0x6A,0x66,0x05,0xF1,0x95,0x6E,0x0D,0x50,0x94,0x4A,0x04,0x4A,0xD1,0xAB,0xA2,0xB1,0xB6,0x9D,0x4D,0xE9,0x3D,0xE7,0xEC,0x0D,0xDB,0xB9,0xF7,0x83,0x1B,0xAB,0x06,0xB7,0x2D,0x27,0x66,0x1A,0x59,0x18,0xDD,0x95,0x99,0x79,0x74,0x13,0x72,0xA3,0x03,0x08,0x90,0x56,0xE3,0x01};
extern const uint8_t spt_NO[]                PROGMEM ={0xA1,0xF2,0x0E,0x3E,0xD3,0xA9,0x94,0x3A,0x78,0xB8,0xA8,0xA0,0x93,0x6A,0xEF,0xE0,0xA3,0x9C,0xF1,0xAA,0xA2,0xE7,0x32,0xF3,0x24,0xA7,0xB0,0xDE,0xDB,0xDC,0xDB,0xDC,0xFC,0xE6,0x37,0x5F,0x95,0xF2,0xB9,0x61,0xD4,0x65,0x57,0xBB,0x6E,0x2D,0x8F,0xB3,0x6A,0xD4,0xA5,0x76,0xB5,0x0F,0x3D,0xDD,0x1B,0xAA,0x92,0xC8,0xF7,0x0F,0x00,0x00};
extern const uint8_t spt_NOT[]               PROGMEM ={0xAE,0xB1,0x1A,0x3E,0xC3,0x15,0x95,0x26,0x58,0x18,0xF3,0x70,0xDD,0x6A,0x57,0x3B,0x4D,0x4B,0xCE,0xAD,0x6E,0x75,0xAB,0x5B,0xDD,0x7A,0x34,0x76,0xA4,0xBA,0x07,0x93,0xDC,0x01,0x00,0x30,0xC0,0x90,0x70,0x07,0x0C,0x11,0x41,0x00,0x57,0x14,0x1F};
extern const uint8_t spt_NOW[]               PROGMEM ={0xA9,0x4D,0x9A,0xCD,0x9C,0xDB,0xD6,0xF6,0xD4,0xC9,0x77,0xAA,0x79,0x95,0x5B,0xDF,0xFA,0xD6,0xB7,0xB9,0xED,0xE8,0x9D,0xDF,0x66,0xF3,0xDA,0x7D,0x48,0x83,0x9C,0x15,0xE2,0x96,0x38,0x0E,0x69,0x50,0x65,0x83,0xDC,0x93,0xB8,0x51,0x86,0x1D,0x0C,0x73,0xEC,0x46,0xE9,0x7A,0xCD,0x58,0x96,0x19,0xB5,0xC9,0x54,0x61,0x37,0x6A,0xF0,0x3E,0xD2,0x85,0x64,0x3D,0x00,0x00};
extern const uint8_t spt_NUMBER[]            PROGMEM ={0xA9,0x0D,0x0E,0x2A,0xDD,0x12,0xA7,0xD6,0x5B,0xE8,0x70,0x8F,0xBB,0x9A,0xAC,0x2D,0xCD,0xA4,0xF5,0xA9,0xA2,0xAA,0x4A,0xE5,0xC5,0xB7,0x38,0x99,0x57,0xD3,0xA6,0xD2,0xAA,0x64,0xCA,0x57,0xB8,0x50,0xE6,0x98,0xB9,0x9C,0xA6,0xE4,0x70,0x4B,0xEB,0x2B,0x53,0xE3,0x98,0xEA,0x61,0x6E,0x5D,0x67,0x3A,0x7B,0x3A,0xB7,0xEB,0x5D,0xEF,0x7A,0x5F,0xFB,0x34,0xD8,0x4D,0x9A,0x29,0xAD,0xFD,0xE8,0x26,0xD3,0x44,0x32,0xD5,0xAB,0x9B,0x5C,0x37,0xB2,0xE6,0xAC,0x66,0x8A,0x2B,0xC4,0x44,0xED,0x3E};
extern const uint8_t spt_O[]                 PROGMEM ={0xA7,0x72,0x3A,0xDF,0x95,0xF3,0xDE,0x6A,0x57,0xA3,0xB2,0x3C,0x3F,0x14,0xFD,0xCF,0xAA,0xD7,0xBD,0x49,0x9D,0xD2,0xF3,0x24,0xD4,0x2D,0xF6,0xBE,0x57,0x3D,0x8B,0x37,0xA2,0xD8,0xD8,0x0C,0xDC,0xD7,0x96,0x60,0x68,0x35,0x08,0x97,0xDB,0x28,0x92,0x45,0x2F,0x8D,0x57,0x71,0xC8,0x56,0x5D,0x4E,0xCC,0x2A,0xEE,0xE4,0x01};
extern const uint8_t spt_OF[]                PROGMEM ={0xA7,0x8A,0x36,0x3E,0xC9,0xB3,0x9E,0x2A,0xDA,0xF8,0x60,0xCF,0x72,0xAA,0xE8,0xE2,0x93,0x2D,0xCB,0xA9,0xA3,0x8F,0x37,0xD1,0x2E,0xA7,0x8E,0x2E,0xDE,0x44,0xDA,0x9C,0x26,0xDA,0x78,0x53,0x69,0xD3,0x1A,0xEF,0x6B,0xD9,0x6C,0x4D,0x6F,0x46,0xE3,0x7C,0x0D,0x99,0xAE,0x49,0x8D,0xF3,0xD9,0xAC,0xBC,0x58,0xB5,0x2A,0x87,0x8A,0x78,0x2A,0xD3,0x06,0x63,0x2A,0x62,0x4A,0x4C,0x3B,0x6D,0xB8,0xA1,0xC9,0x62,0x40,0x66,0xE6,0x04,0xF0,0x22,0x04,0x01,0xDA,0x85,0xC2,0x03};
extern const uint8_t spt_OFF[]               PROGMEM ={0x2B,0xD5,0xF5,0xC2,0xD4,0xEB,0x9E,0xCA,0x99,0x6B,0x53,0x5D,0x7A,0x2A,0x53,0x66,0x94,0x33,0xCD,0xAD,0x6E,0x75,0xAB,0xDB,0xB4,0x4E,0xFB,0x1C,0x65,0x4B,0x68,0x80,0x6A,0x33,0x3C,0x60,0x01,0x0F,0x38,0x20,0xDB,0x0C,0x03,0xE4,0x98,0xF6};
extern const uint8_t spt_OH[]                PROGMEM ={0xA7,0x72,0x3A,0xDF,0x95,0xF3,0xDE,0x6A,0x57,0xA3,0xB2,0x3C,0x3F,0x14,0xFD,0xCF,0xAA,0xD7,0xBD,0x49,0x9D,0xD2,0xF3,0x24,0xD4,0x2D,0xF6,0xBE,0x57,0x3D,0x8B,0x37,0xA2,0xD8,0xD8,0x0C,0xDC,0xD7,0x96,0x60,0x68,0x35,0x08,0x97,0xDB,0x28,0x92,0x45,0x2F,0x8D,0x57,0x71,0xC8,0x56,0x5D,0x4E,0xCC,0x2A,0xEE,0xE4,0x01};
extern const uint8_t spt_ON[]                PROGMEM ={0xA7,0x36,0x7E,0xC6,0xD9,0x97,0x9E,0xC2,0xA4,0x2D,0xA5,0x4E,0x7A,0xAB,0x5B,0xED,0x6A,0x57,0xBB,0x9E,0xCD,0x68,0x75,0x4F,0x37,0x2F,0xBB,0xBD,0x2B,0x9D,0x6E,0x91,0xE6,0xE5,0xD8,0xF4,0xD2,0x49,0xB1,0x8D,0x1B,0xDB,0x99,0x4E,0x3A,0x69,0xB1,0x71,0xAC,0x3A,0x1E,0xB4,0x42,0xC7,0x76,0xE8,0x02,0x77,0x35,0xD7,0xC6,0xAE,0x0B,0x29,0x0C,0x31,0x5D,0x22,0x40,0x57,0xE2,0x07,0x00,0x00};
extern const uint8_t spt_ONE[]               PROGMEM ={0xA6,0xA5,0x36,0xDF,0x89,0xEC,0xA5,0x86,0xDB,0xF9,0x42,0x56,0x9A,0x2A,0xE1,0xFB,0x0B,0x38,0x7D,0x6F,0x46,0x63,0x7C,0x9D,0x62,0x25,0x9E,0xCD,0x28,0x5C,0xAC,0x32,0xEA,0x38,0xBB,0x1A,0x4D,0x88,0x56,0x2A,0x53,0x67,0x76,0x79,0x70,0x83,0xF3,0x94,0x6C,0xE9,0xD6,0x0C,0xCE,0x61,0x8A,0xB4,0x3B,0x36,0xCA,0x20,0x1A,0xDC,0xAD,0xCD,0x28,0x8D,0x78,0x7B,0x5B,0x26,0x93,0x10,0x6A,0x95,0x9E,0xDA,0x4C,0x25,0x85,0x9A,0x5A,0x9A,0x07};
extern const uint8_t spt_ONLY[]              PROGMEM ={0x2B,0xD5,0x6E,0x2E,0xC0,0xD3,0x8E,0x42,0xA6,0x79,0xE2,0x49,0x33,0x0A,0x65,0xE7,0x49,0x35,0x59,0xCF,0x6B,0x9E,0xF3,0x52,0x44,0x07,0x19,0x2E,0xF1,0x62,0x95,0xAB,0x56,0x67,0x65,0x61,0x45,0x6E,0x76,0xB3,0xDA,0x68,0xA3,0xD4,0xB9,0xED,0x6E,0x47,0x17,0x52,0x98,0x94,0xDF,0x29,0x7D,0x6C,0x14,0x9A,0x3D,0x35,0xF5,0x31,0x42,0x46,0xA7,0x99,0xD8,0xBB,0xDE,0x59,0x8E,0x4E,0x33,0x63,0x7A,0x67,0x29,0xBA,0xCC,0xC8,0x03};
extern const uint8_t spt_OR[]                PROGMEM ={0xAD,0x12,0xB9,0x1F,0x2C,0x66,0xB7,0x8A,0xCF,0x59,0xF0,0x6E,0x3C,0x2A,0x91,0xFB,0x51,0xA3,0xD5,0xA8,0x64,0xAF,0x25,0xF5,0x2E,0xAB,0x56,0x23,0xCB,0x54,0xB3,0x9D,0x46,0x4F,0xCF,0x14,0x69,0xBB,0x3A,0x73,0xA4,0x52,0x34,0xF3,0xE8,0xCC,0x91,0x6C,0xD1,0x2C,0xAD,0xB3,0x9B,0x2A,0x9D,0x5B,0xB4,0xD6,0x4D,0x17,0x1D,0xF4,0x59,0x5A,0x37,0x44,0x3D,0xD5,0x53,0x6A,0x7C,0x70,0xE1,0x70,0x35,0xA1,0xCD,0xA9,0x1A,0x49,0xA5,0x22,0x40,0x19,0xB5,0x07,0x00,0x00};
extern const uint8_t spt_ORDER[]             PROGMEM ={0x29,0x15,0xF1,0x5B,0x98,0x56,0xD7,0x6C,0xE4,0xB2,0x8E,0xBB,0xD0,0x96,0x51,0xC8,0xA1,0x9D,0xAC,0x4D,0x4B,0xA5,0x16,0xAE,0x99,0x75,0x0A,0x8D,0x6C,0xCC,0x1E,0x91,0x76,0x54,0x2E,0xBB,0xB8,0xBB,0xF3,0x51,0xBB,0x89,0x65,0x66,0x6B,0x5A,0xED,0x06,0x9C,0x7A,0xB5,0x2A,0xAD,0x5B,0x70,0x6A,0xD5,0xB2,0x74,0x6E,0x41,0x94,0x4B,0xEF,0xD6,0xD9,0xA6,0x62,0xA7,0xEE,0x43,0x6F,0x07,0x6C,0xA9,0x27,0x74,0x03,0x2F,0xEE,0xA5,0x21,0xE7,0x01,0x00,0x00};
extern const uint8_t spt_OTHER[]             PROGMEM ={0x2B,0x8B,0xDE,0x37,0x38,0xB2,0xDC,0xEA,0x16,0x37,0x3F,0x79,0x34,0xB6,0x2A,0xDC,0xAA,0xD7,0xA9,0x75,0xDE,0x86,0x2D,0x1B,0xCD,0xFA,0xB4,0xC1,0xEB,0x88,0x66,0xAB,0xD6,0x99,0x22,0xA9,0x6D,0x4D,0x4A,0xAF,0x1B,0x75,0x85,0xB6,0xCD,0x43,0x18,0xEC,0x84,0x4E,0x8B,0x36,0xAE,0xF7,0x1B,0x4B,0xD5,0x33,0x84,0xCE,0x17,0x51,0x77,0x4D,0x6C,0xFA,0xD0,0xDC,0x00,0x45,0xE9,0x03,0x00,0x00};
extern const uint8_t spt_OUT[]               PROGMEM ={0xA7,0xCA,0xAE,0xDB,0x4C,0x96,0x9C,0xCA,0xFB,0x69,0xD3,0xA8,0x7B,0xAB,0x5B,0xAD,0xDA,0x84,0x1D,0x91,0xA8,0xDB,0x6A,0x6B,0xE6,0x59,0x6D,0x8E,0x6B,0x45,0x6F,0x97,0x0E,0xCB,0x00,0x00,0x0A,0xC8,0xDA,0x43,0x00,0x47,0xBB,0x31,0xC0,0x9B,0x30,0x04,0x18,0x17,0x02,0x0F,0x00,0x00};
extern const uint8_t spt_OVER[]              PROGMEM ={0xA7,0xD0,0xAE,0x2F,0x50,0xBA,0x9D,0x5C,0xDB,0xFA,0x24,0xCE,0x3A,0x72,0x19,0xFA,0x15,0x25,0x73,0xCB,0x45,0xAE,0x67,0xB4,0x2E,0xAD,0x10,0xB1,0x4E,0xC1,0x3D,0xB7,0x3A,0x1A,0x57,0x95,0x70,0xD4,0x9A,0x6C,0x4C,0x85,0xCD,0x4D,0xAF,0x5A,0xA5,0x7D,0x9A,0x9B,0xBB,0x1B,0x8D,0x69,0x66,0xE9,0xDC,0xAD,0xB5,0xA6,0x84,0xD8,0xA8,0xB6,0xD4,0xE9,0x2E,0x56,0x23,0x7E,0x42,0xAF,0xBB,0xC8,0x94,0x78,0x76,0xBD,0x99,0x2C,0x59,0xEC,0xCB,0xF5,0xB2,0x98,0x64,0xA6,0xE4,0x07,0x00,0x00};
extern const uint8_t spt_P[]                 PROGMEM ={0x60,0x00,0xEB,0x4C,0x05,0xE0,0xAC,0xE0,0x49,0x72,0x14,0xD1,0xCC,0xB9,0x27,0x9D,0x45,0x99,0x3C,0x9F,0xEE,0x6C,0x17,0xB3,0x6E,0x4D,0x8F,0xCC,0x5C,0x75,0x27,0x75,0xC5,0xA0,0xFA,0x64,0x15,0xD7,0x3B,0x41,0xDD,0x19,0x76,0x4C,0x1F,0x15,0x44,0x77,0x88,0x31,0x83,0x57,0x64,0x1D,0x66,0xFB,0x01};
extern const uint8_t spt_PART[]              PROGMEM ={0x20,0x01,0x09,0x48,0xA0,0x25,0xBA,0x56,0x3B,0x79,0xDC,0x93,0x9B,0xD2,0x19,0x22,0x4B,0x4F,0x61,0x7B,0x45,0x1A,0x37,0x3D,0x95,0x9B,0xE1,0xE5,0xD4,0x78,0x34,0xEE,0x68,0x94,0xC8,0xEC,0xD6,0xF9,0x43,0x6B,0xD2,0x91,0x4B,0xEF,0x17,0x76,0x4A,0x26,0x48,0xBD,0x6F,0xAC,0xAE,0xAD,0x12,0x00,0x1C,0x50,0xB5,0xBB,0x00,0xA2,0x75,0x85,0x07};
extern const uint8_t spt_PARTNER[]           PROGMEM ={0x0A,0x10,0x39,0x92,0x03,0x16,0x68,0xB1,0x49,0xEB,0x51,0xD8,0x65,0xA4,0x2E,0xAE,0xDB,0x60,0xB6,0x95,0xB9,0xD2,0x6A,0x4B,0xFE,0x56,0x16,0x72,0x1B,0x9D,0x78,0x6F,0xB9,0x5F,0xA2,0x61,0xE6,0x07,0x00,0xC0,0x14,0xD6,0x61,0x07,0x9F,0xC2,0xD2,0x85,0x19,0xA2,0x89,0xC9,0x67,0x3F,0x87,0x32,0xBA,0x61,0x6A,0x4D,0x6D,0xC3,0xE8,0x0F,0x45,0x38,0x2F,0x4C,0x53,0x98,0xA4,0x19,0xEA,0xC9,0xCD,0xE1,0x30,0xBB,0x59,0xE2,0x07};
extern const uint8_t spt_PARTS[]             PROGMEM ={0x0A,0x70,0xC6,0x8D,0x02,0x1C,0x68,0x89,0x2E,0xDD,0x41,0x5A,0x7B,0x65,0x26,0x4D,0x86,0xF1,0x9A,0x91,0x9B,0xBA,0xEE,0x49,0x6B,0x5A,0x61,0x5B,0x6B,0x0C,0x6C,0x99,0x75,0x69,0xEC,0x08,0xF6,0x67,0xEF,0xAE,0x75,0x8B,0xB4,0x53,0x32,0xB1,0x4E,0x46,0x65,0x8B,0x92,0x83,0xFC,0xA0,0x83,0x5D,0xC3,0x31,0x30,0xE0,0x65,0x75,0x0D,0x58,0xC0,0x00,0xBF,0x86,0x5B,0x40,0x00,0xBF,0x9A,0x33,0xE0,0x28,0xF5,0x07,0x00,0x00};
extern const uint8_t spt_PERIOD[]            PROGMEM ={0x06,0x08,0xDE,0x44,0x03,0x23,0xCE,0xCE,0x94,0x23,0x5B,0x8F,0x34,0x84,0x10,0x59,0xCF,0xBA,0xD3,0x91,0xBA,0x14,0xA2,0xCB,0xFE,0x67,0xDE,0x0A,0x57,0x5C,0xB4,0xD9,0xDF,0xA8,0x42,0x77,0xD1,0x10,0xFF,0xA3,0x8A,0x39,0x94,0x3C,0xBA,0x8E,0xA6,0xC4,0x10,0x36,0xFB,0x3C,0xDB,0xD5,0xE6,0x9C,0xCA,0xA6,0x6F,0x76,0x37,0xFB,0xD6,0x07,0xEF,0xA6,0xE1,0x9B,0xCD,0x60,0x9C,0xA9,0x86,0xB5,0x62,0x3D,0xB6,0x1D,0x11,0xA1,0x98,0xF5,0x44,0x57,0xA4,0xA5,0x62,0xD3,0x67,0x61,0xA2,0x66,0x4E,0x09,0x60,0x64,0xD9,0x03,0x00,0x00};
extern const uint8_t spt_PLAY[]              PROGMEM ={0x06,0xC8,0x55,0x54,0x01,0x49,0x69,0x94,0xC4,0xA4,0x1C,0xE3,0x8A,0xD3,0x93,0x19,0xAF,0x24,0xE4,0x68,0xE1,0x4D,0xBC,0x92,0x58,0x22,0x95,0x27,0xF1,0x4A,0x53,0xF5,0x10,0x99,0x26,0xB3,0x68,0x75,0x29,0x12,0xE2,0x53,0xBB,0x74,0x31,0x52,0x64,0x4F,0xD8,0xDA,0xA7,0x3E,0x3A,0xF6,0xAC,0x2C,0x13,0xFA,0xA0,0x39,0xBA,0x33,0x88,0xEB,0x8D,0x92,0xB9,0x70,0xA1,0x0F,0x00,0x00};
extern const uint8_t spt_PLAYS[]             PROGMEM ={0x0A,0x68,0x51,0x4D,0x00,0x49,0x7A,0x97,0x48,0xD9,0x69,0x15,0xF7,0xB4,0x92,0x10,0xA2,0x9C,0xAB,0xF1,0x4E,0x56,0x12,0x4A,0xA4,0xF0,0xD4,0xD9,0xC9,0x48,0x53,0x51,0x53,0x9D,0xBA,0xA3,0xC8,0x45,0x4C,0xAD,0x9B,0x8C,0xBA,0x96,0x20,0x36,0x7F,0x3A,0xDB,0xDA,0xA5,0x3E,0x25,0x74,0xCB,0xA9,0x5D,0xFB,0xDA,0xA7,0x3E,0x24,0x76,0xF5,0x99,0x9B,0x7A,0x97,0xC5,0x24,0xAA,0x4E,0xE9,0x93,0x0A,0x31,0x8D,0x4E,0x69,0xFC,0x29,0x4D,0x48,0x94,0x1A,0x60,0x09,0x33,0x06,0x5C,0xA6,0xE2,0x80,0x6B,0x4C,0x04,0xD0,0x84,0xE9,0x03,0x00,0x00};
extern const uint8_t spt_PLEASE[]            PROGMEM ={0x0E,0xC8,0x81,0xD4,0x01,0x59,0x9B,0x8F,0xB0,0x48,0x69,0x57,0x73,0x3B,0xD2,0x24,0x2D,0x3D,0x24,0xCD,0x4A,0xBD,0x33,0x8F,0xF0,0xC7,0x3B,0x6B,0x79,0x4D,0x86,0x9C,0xFE,0x64,0x56,0xA3,0xAA,0x59,0x89,0x3D,0xBE,0xCC,0xA6,0xB7,0xA5,0xCF,0x9D,0x85,0xA5,0xDE,0xE6,0x3E,0xF5,0x29,0xB1,0x98,0xC5,0xE3,0xD2,0x07,0x13,0x10,0x56,0x1D,0xCB,0xF0,0x35,0x87,0x51,0xAE,0x75,0xC0,0x04,0xAC,0x06,0xF8,0x46,0xCD,0x00,0x3F,0x1A,0x19,0xE0,0x7B,0x0B,0x01,0x7C,0xA7,0xF6};
extern const uint8_t spt_POINT[]             PROGMEM ={0x0A,0xB0,0x5A,0x8B,0x00,0x5A,0x47,0x23,0x40,0x99,0x29,0x91,0x7A,0xE9,0xD3,0x12,0x8C,0x4A,0x22,0x7D,0xBF,0x82,0xB6,0x19,0xA9,0xD1,0xFD,0x86,0x92,0x66,0xE5,0x41,0xD6,0xAB,0x58,0xB6,0x53,0x25,0xDD,0x2B,0xC6,0x59,0x4E,0x93,0x7D,0x87,0x1A,0xB5,0x3E,0x7D,0xCE,0x65,0xAA,0xBC,0xBA,0x0D,0x29,0x99,0x5A,0xC4,0xCC,0x32,0xE6,0x10,0x2C,0x6A,0x4D,0xDC,0x94,0x99,0x98,0x84,0x39,0x43,0x80,0x45,0x1C,0x08,0xC8,0x98,0x3A,0x00,0x49,0xA6,0x79,0x40,0x00,0x22,0x84,0x3D,0x00,0x00};
extern const uint8_t spt_POSITION[]          PROGMEM ={0x06,0x70,0x2E,0x58,0x03,0xAE,0x8A,0xA1,0x42,0x49,0x3C,0xAD,0xC2,0xC5,0x48,0xD6,0x58,0x72,0xAA,0x60,0x23,0x55,0x65,0xCD,0xAE,0x77,0xE3,0x80,0x0A,0x28,0x23,0x30,0xAA,0x68,0xD3,0x58,0x6D,0xF6,0x2E,0x6E,0xBA,0x92,0x98,0xDD,0x99,0x7B,0x76,0x4F,0x14,0x70,0x66,0xA6,0x07,0x3C,0x20,0x00,0xEE,0x3D,0x56,0x51,0x5D,0x35,0x2B,0xA5,0xBB,0xCD,0xED,0xDA,0x90,0x12,0xA5,0xA0,0xA6,0xCF,0x63,0x1A,0x83,0xA7,0x30,0x36,0xEF,0x61,0x54,0x5E,0xCD,0xB8,0x9A,0xBA,0xD1,0x18,0xF1,0xE0,0x4A,0x6E,0x26,0x63,0xD9,0x5C,0x32,0x8D,0x9A,0x9C,0x15,0x53,0x6E,0xD7,0x0F};
extern const uint8_t spt_POSITIVE[]          PROGMEM ={0x02,0x90,0xC6,0x9D,0x03,0x08,0x10,0x26,0x73,0xC4,0xBA,0x77,0x9A,0x66,0x94,0x95,0xD9,0x3C,0xA3,0x92,0xB5,0x77,0xB6,0xB3,0x95,0x7B,0x57,0xE5,0xEA,0x71,0x5A,0x6E,0x63,0xA9,0xBB,0x57,0x49,0xD5,0x17,0xAC,0x61,0xE9,0x38,0x74,0xBF,0x85,0x1A,0x88,0xDC,0xD0,0x59,0x1F,0xEE,0xEE,0x2D,0x6B,0x95,0x6A,0x6F,0xC2,0xD4,0xAD,0xA7,0xE8,0x94,0x4C,0x76,0x8B,0x56,0xA4,0xF3,0xD2,0x35,0xD4,0x15,0x33,0x20,0x01,0x0D,0x57,0x9B,0xCC,0x15,0x39,0x91,0x63,0x13,0x7B,0x33,0x48,0x97,0x19,0x23,0x35,0xC4,0x20,0x7C,0x44,0xBA,0xC5,0x14,0xA3,0xD6,0xEE,0x1E,0xEE,0x58,0x8C,0xC1,0xB8,0x9A,0xA8,0x6A,0x40,0x80,0xD7,0xCE,0xAA,0x6B,0xA9,0x2D,0x48,0xD5,0x3C,0x00,0x00};
extern const uint8_t spt_PRESS[]             PROGMEM ={0x04,0xC0,0x36,0x4C,0x01,0x2E,0xA9,0x2B,0xC0,0x36,0xAF,0x16,0xB9,0x22,0xE5,0x96,0xC9,0x6E,0x7A,0x32,0xDF,0x2D,0x2C,0x32,0xCE,0xCE,0x77,0x35,0xDB,0xD4,0x9B,0xE4,0xE5,0xBA,0xB6,0xEC,0xA8,0x80,0xEF,0x45,0x34,0x60,0x01,0x03,0xFC,0x28,0x6A,0x80,0x1F,0x4D,0x15,0xF0,0x15,0x99,0x04,0x38,0x00,0x0F,0x00,0x00};
extern const uint8_t spt_PRINT[]             PROGMEM ={0x0A,0x30,0xC5,0x43,0x02,0x18,0x68,0x91,0x5F,0x52,0x52,0xD0,0x76,0x45,0xB1,0xB8,0x6A,0xC4,0xAC,0x1D,0xED,0x78,0xE7,0xAB,0x4E,0x29,0x55,0xDD,0x56,0xB5,0x2E,0x34,0x4B,0x91,0x6C,0x14,0x86,0x2C,0x44,0xB5,0xCC,0x9D,0x1A,0x93,0x76,0x73,0x77,0xC5,0x00,0x0A,0x28,0xDA,0x42,0x00,0x76,0x44,0x10,0x40,0x86,0xB0,0x07};
extern const uint8_t spt_PRINTER[]           PROGMEM ={0x0A,0x30,0xC5,0x43,0x03,0x1A,0x28,0xB1,0x5F,0x52,0x52,0xD0,0xF6,0xC4,0xB1,0xB8,0x6A,0xC4,0xAC,0x1B,0xDF,0x24,0xE6,0xA5,0x2A,0x8E,0xD5,0xCC,0x9D,0x18,0x40,0x24,0xAB,0x93,0xC7,0x64,0xCE,0x65,0x4D,0x6F,0xBD,0xDA,0x30,0x4D,0xA5,0xA4,0x7D,0xEB,0x5D,0x33,0xD1,0xD3,0xF6,0x69,0x70,0x83,0x34,0x5B,0xD6,0xB8,0xD1,0x54,0x51,0x1B,0x97,0xE5,0xA6,0x50,0x8D,0xC9,0xD5,0x8B,0x99,0xC2,0x51,0x51,0x91,0xCC,0xF0};
extern const uint8_t spt_PROBLEM[]           PROGMEM ={0x0C,0xC0,0x36,0x4C,0x01,0x2E,0xA9,0x0B,0xC0,0x36,0x2F,0x02,0xB8,0x0E,0xB1,0x62,0x1B,0x3B,0x22,0x28,0xDD,0x4D,0x4E,0xEA,0xFD,0x54,0x70,0xB8,0xB9,0xE9,0xCD,0x56,0x66,0x63,0x55,0xB0,0x35,0x31,0x15,0xF7,0xD6,0x2A,0xEA,0x59,0xD4,0x38,0x66,0x19,0xB7,0x1D,0xD7,0x08,0xE3,0xE1,0x1E,0x4A,0x5B,0xE5,0x9D,0x8C,0xB3,0xD9,0x1F,0x75,0x34,0x39,0x29,0x94,0xFE,0x36,0xB7,0xDD,0xDD,0xE8,0x7C,0xA8,0x0A,0x81,0xA6,0x61,0x88,0x0E,0x5B,0x54,0xD5,0xC6,0x3E,0xF6,0x7E,0x70,0x83,0x77,0x34,0x22,0xAA,0xC5,0x0C,0xDA,0x6A,0x09,0xA7,0x9A,0x07};
extern const uint8_t spt_PROBLEMS[]          PROGMEM ={0x0C,0xB0,0xCD,0x8B,0x00,0xAE,0x43,0x9C,0xD8,0xC6,0x8E,0x08,0x4A,0x77,0x52,0xEF,0xA6,0xDD,0xA4,0xED,0xC9,0xBC,0x9F,0x76,0x95,0x25,0x27,0xF3,0xA1,0x26,0xD8,0x96,0x9E,0xCC,0xC6,0xEE,0x20,0x5F,0xB2,0x72,0xE3,0xA6,0x92,0xB5,0xAD,0xAA,0x70,0x2A,0x0F,0x76,0xD7,0xA2,0x46,0xB1,0x3D,0x38,0x9C,0x94,0xCA,0x59,0x8D,0x88,0x92,0x5A,0x9A,0xA8,0xB8,0x5A,0xD8,0xDD,0x6A,0x83,0xF6,0x4E,0x15,0xA5,0xAB,0x75,0xB6,0xC6,0x45,0xB2,0x8C,0xDE,0x84,0x2E,0x55,0xCD,0x9A,0x7A,0x67,0xB3,0x4C,0xA1,0xAD,0x1B,0x82,0x83,0x31,0x53,0xAD,0x6E,0x08,0x0E,0xC6,0x35,0xB8,0xBA,0xC1,0x5B,0xE8,0x96,0x60,0x16,0x86,0x22,0x38,0x5D,0x4D,0x2D,0x01,0x3C,0x90,0x12,0xC0,0x57,0xC0,0x0A,0xF8,0x9E,0x59,0x00,0x97,0x83,0x09,0x60,0x11,0x71,0x01,0x24,0x6A,0xF9};
extern const uint8_t spt_PROGRAM[]           PROGMEM ={0x0A,0x30,0x3E,0x55,0x00,0xAE,0x43,0xB8,0x3C,0xB5,0x54,0x77,0x95,0x7B,0x52,0x67,0x62,0x3C,0xA8,0xCD,0x4D,0x4F,0xEA,0x94,0x9F,0x3B,0xA7,0xDF,0x69,0xC9,0x8C,0xC9,0x11,0xA1,0xF4,0x26,0xE3,0xA9,0x92,0xC4,0xBC,0x8A,0x8A,0xDB,0x8C,0x10,0x73,0xE2,0x2A,0x9D,0xA4,0x83,0xCC,0x49,0xAA,0x4C,0xC5,0x55,0x8F,0x74,0xAB,0x0A,0x93,0x9A,0x43,0xDB,0x9F,0x3A,0x2C,0x4D,0x97,0x68,0x72,0x9B,0xDB,0xDE,0x76,0x77,0xA7,0x0B,0x39,0x32,0x54,0xE7,0xEE,0x7E,0xF4,0x21,0x7A,0xA4,0x72,0x9D,0x30,0x3A,0xCF,0xAD,0x18,0x69,0xDD,0x60,0x1C,0xA7,0x8A,0x66,0x55,0x83,0xF4,0x9A,0xCA,0x99,0x45,0x8D,0x5A,0x4B,0xA6,0x64,0x12,0x35,0x3A,0xAD,0xE6,0x54,0x4E,0xC4,0xE4,0xB5,0x69,0xB0,0xB9,0x05,0x52,0x45,0x1F,0xEE,0xEC,0xAE,0x1F};
extern const uint8_t spt_PUT[]               PROGMEM ={0x0A,0x30,0x3E,0x55,0x02,0x1C,0x20,0x80,0x0A,0x65,0x27,0xF2,0x3A,0xB2,0xC4,0x96,0xDD,0x74,0x65,0x26,0x94,0xB9,0xF5,0x9C,0x55,0x58,0x1F,0xEE,0xDA,0x6D,0x4A,0x65,0xBD,0x87,0x7A,0x6D,0x04,0x00,0x07,0x0C,0xE3,0x61,0x80,0x69,0xC2,0x18,0x10,0x5C,0x32,0xC0,0x03};
extern const uint8_t spt_PUTTING[]           PROGMEM ={0x06,0xB0,0xCE,0xCC,0x02,0x1A,0x30,0x91,0x8F,0x5D,0xCE,0x6C,0x67,0x25,0x3A,0x56,0x18,0x67,0xE7,0x93,0x18,0x17,0x19,0x96,0x99,0x4F,0x1A,0x5C,0x58,0x50,0x77,0x12,0x00,0x95,0xDD,0x0A,0x20,0xC1,0x7C,0x44,0x31,0x38,0xA9,0x79,0xA3,0x53,0xE7,0x1E,0xAC,0xE6,0x4B,0x56,0x53,0x5B,0x31,0xBB,0xAE,0x6E,0x5D,0x9D,0x81,0x1C,0xBE,0x30,0xF4,0x29,0x33,0xE4,0x58,0x44,0xD3,0x3B,0x23,0x78,0x49,0x51,0x44,0x2F,0x8D,0xD4,0x8A,0x2A,0x12,0xBD,0xD0,0x1E,0xA3,0x6A,0x49,0xF4,0x46,0xB2,0xB6,0xB9,0x63,0xD1,0x7B,0x23,0x92,0x6A,0x8E,0x59,0x17,0xB4,0x4A,0xAA,0x38,0x02,0x40,0x51,0x52,0xE1,0x69,0xE9,0xF8,0x01,0x00,0x00};
extern const uint8_t spt_Q[]                 PROGMEM ={0x0E,0xB0,0xD1,0x38,0x02,0x06,0x80,0xBE,0xDD,0x01,0xCC,0x58,0x6B,0x60,0x45,0x25,0x2A,0x53,0xF8,0x9A,0x13,0x15,0xEF,0x0C,0xED,0x5D,0x6E,0xB4,0xE2,0xEC,0x9D,0xA9,0x74,0xCF,0x4A,0x93,0x71,0xA5,0x92,0xBD,0x33,0x1F,0x55,0xE0,0x9E,0x5C,0xDA,0xB5,0xD7,0xA9,0xE3,0xA1,0xDC,0x42,0x17,0xC5,0xCE,0x75,0x2C,0xB6,0x87,0xE9,0x02,0xD3,0x09,0xDB,0x6E,0x46,0x33,0x55,0xAB,0xAC,0xF4,0x90,0xC6,0x79,0x00,0x00};
extern const uint8_t spt_R[]                 PROGMEM ={0xA7,0x70,0xB1,0xCE,0x29,0xD2,0xDD,0xFC,0xE6,0x37,0xBF,0xC5,0xA9,0x7C,0xC8,0x4E,0x95,0xE6,0xB7,0x3A,0x8D,0xAF,0x1E,0x19,0x9C,0xFC,0x76,0xAD,0xB3,0x43,0x32,0xDD,0xEA,0xE4,0xCE,0xF5,0xBE,0x2A,0x6B,0x73,0x22,0xD3,0xC5,0xE9,0x2C,0xCA,0xAE,0x1E,0x00,0x00};
extern const uint8_t spt_RANDOMLY[]          PROGMEM ={0xAA,0xA5,0x35,0xCD,0xAD,0x9C,0x84,0x56,0x0C,0xEE,0x2C,0xD3,0xBC,0x1A,0x97,0xA5,0xAD,0xAC,0xF9,0xA9,0x62,0xB4,0x48,0x8B,0x36,0xA7,0x4A,0xC5,0xD2,0x65,0x93,0x9C,0x3C,0x35,0x4B,0x93,0x71,0x72,0xF2,0xD4,0x3C,0x4D,0xDA,0xC9,0xC9,0x63,0xF1,0x30,0x69,0x27,0x2B,0x0F,0xD1,0x2D,0xB8,0x92,0xA4,0x3C,0x7A,0x18,0xF3,0xD2,0x14,0x0A,0x6B,0x68,0x5D,0x5B,0xB5,0xAB,0x8C,0xE2,0x5C,0x95,0x5A,0xA9,0x89,0x54,0xD5,0x43,0x93,0x8E,0xC2,0x1B,0x8F,0x52,0x6B,0x33,0x2A,0x6B,0xA3,0xC2,0x65,0x49,0xA9,0x8D,0xD7,0x09,0x95,0xB9,0xA1,0x31,0x0E,0xCF,0xD4,0x9C,0x87,0xC6,0x3B,0xB8,0x50,0x75,0x9E,0x5A,0xEB,0x70,0x4D,0xDC,0x5E,0xE9,0x9C,0xB6,0x8A,0xC0,0xE6,0xA5,0xB3,0x22,0x47,0x83,0xDB,0x8D,0xD6,0x05,0xAB,0x34,0x5F,0xB6,0xBA,0x10,0x35,0x22,0x62,0xC9,0xE8,0x73,0x22,0x8F,0xCE,0xC6,0xA5,0xCF,0x05,0xDD,0xA7,0x4B,0x85,0x3E,0x26,0xC8,0x9C,0x0E,0x64,0x7A,0x6F,0xB1,0x3B,0x43,0x90,0xEA,0x53,0x04,0x8B,0x2A,0xD3,0x0F,0x00,0x00};
extern const uint8_t spt_READ[]              PROGMEM ={0xA1,0x13,0x31,0x5C,0x3C,0x95,0x95,0x4E,0x56,0x33,0x75,0x93,0xDF,0x1A,0x3D,0xC4,0xC5,0x45,0xFD,0xAA,0x5D,0x67,0xE7,0xB0,0x6C,0xA7,0x0A,0x9E,0x53,0xD3,0x97,0x9C,0xBC,0x28,0x15,0x9D,0x6A,0xB4,0xB2,0x2A,0x59,0x7D,0xAB,0xE6,0xCA,0x9B,0x11,0x96,0xE9,0x85,0xAB,0xE8,0xD9,0x18,0x22,0xDF,0xDC,0xEA,0x56,0xB7,0x59,0x4D,0xAB,0x21,0xA0,0xFA,0x35,0x74,0x4A,0xA8,0xA7,0x56,0x6C,0xDF,0x99,0x8E,0x4B,0xCB,0xB0,0x8A,0x9D,0xFA,0x6A,0x43,0x18,0x25,0x65,0xED,0x5D,0x9F,0xB2,0xA9,0x90,0xC7,0xCE,0xD3,0x03};
extern const uint8_t spt_READ1[]             PROGMEM ={0xA6,0xE5,0x4D,0xDD,0x33,0xE4,0x87,0xC6,0x0C,0x0C,0x4B,0xD3,0x3E,0x2A,0x3F,0x39,0xC5,0x2D,0xEF,0xA9,0x52,0x77,0x17,0xED,0x36,0x37,0xBF,0xF9,0x29,0x52,0xF7,0x10,0xA9,0xD6,0xB7,0xDA,0xF5,0x6E,0x67,0xE7,0x06,0xEB,0x55,0xC5,0xBC,0x91,0x1D,0xEC,0x40,0x02,0xA2,0x32,0xD3,0xD2,0x56,0x18,0x4A,0x6C,0x13,0x51,0xC7,0x0F,0x00,0x00};
extern const uint8_t spt_READY_TO_START[]    PROGMEM ={0xAE,0x91,0x85,0xD3,0x32,0xB8,0xB5,0xC6,0x35,0x4E,0x09,0xCA,0x7E,0x6A,0xDF,0xB9,0xCC,0xB4,0xFB,0xA9,0xE2,0xD4,0x30,0xD5,0xEE,0xB7,0x5A,0x55,0xEA,0x5A,0x10,0x99,0xA5,0x55,0x31,0x1B,0x1B,0x4E,0xA6,0x55,0xE5,0xAE,0xCA,0xD2,0x9D,0x5A,0x55,0xA6,0x08,0x49,0x2D,0x8D,0xB5,0x6C,0x11,0xB0,0x54,0x9A,0x06,0x0C,0xB0,0x8C,0x45,0x29,0xBC,0x4A,0x53,0xCB,0x4E,0xA5,0xA9,0xC2,0x4C,0xD5,0xF2,0x1A,0xA0,0x03,0x35,0x05,0xFC,0xA9,0x6C,0x01,0x05,0xFC,0x1D,0x0C,0x10,0x80,0xA6,0xD2,0x4F,0x1E,0x43,0x44,0x86,0xB4,0xBD,0xC5,0xAD,0x4E,0xE5,0x8B,0x77,0x18,0x37,0x59,0x85,0x9F,0xE6,0xA5,0xBA,0x78,0x67,0x33,0x6D,0x91,0x9F,0x22,0x1D,0xE6,0xD0,0x45,0xDA,0x49,0x46,0xB8,0x2C,0x00,0x03,0x64,0x19,0xCA,0x80,0x26,0x9B,0x11,0xE0,0x12,0x33,0x00,0xC0,0x03,0x00,0x00};
extern const uint8_t spt_RECORDER[]          PROGMEM ={0xA4,0x72,0x3A,0x44,0xC5,0xE4,0xA4,0x4A,0x57,0x4E,0x2B,0xF7,0x76,0x9A,0x34,0xAC,0x48,0xC5,0xF9,0xA9,0x4B,0x89,0x64,0xC7,0xEE,0xB7,0x5E,0x75,0xAB,0x1D,0x10,0xE2,0x9E,0xB4,0x59,0x84,0xB1,0x84,0x5B,0x40,0x80,0x67,0xE5,0x0C,0xD0,0xB3,0x09,0x54,0x2A,0xD2,0x96,0x13,0x77,0xAF,0x69,0x4D,0x4B,0x26,0x53,0x77,0x0A,0xF9,0x6F,0x99,0x8E,0x5E,0x99,0x90,0xB5,0x64,0xB6,0x71,0xA5,0x63,0x93,0x50,0xD8,0xCB,0xEE,0x22,0xEA,0x4C,0xE3,0x97,0x98,0x25,0xB7,0xCB,0x4D,0x6F,0x5A,0xE7,0xB7,0xAA,0x27,0xB7,0x2B,0xBD,0x5B,0xCA,0x51,0xDC,0x2D,0x0D,0x6E,0x2B,0x47,0x49,0x7E,0x33,0xF9,0x8B,0x9A,0xCA,0xAD,0xCC,0x6C,0x87,0x50,0x98,0xBB,0x79,0x00,0x00};
extern const uint8_t spt_RED[]               PROGMEM ={0xA6,0xE5,0x4D,0xDD,0x33,0xE4,0x87,0xC6,0x0C,0x0C,0x4B,0xD3,0x3E,0x2A,0x3F,0x39,0xC5,0x2D,0xEF,0xA9,0x52,0x77,0x17,0xED,0x36,0x37,0xBF,0xF9,0x29,0x52,0xF7,0x10,0xA9,0xD6,0xB7,0xDA,0xF5,0x6E,0x67,0xE7,0x06,0xEB,0x55,0xC5,0xBC,0x91,0x1D,0xEC,0x40,0x02,0xA2,0x32,0xD3,0xD2,0x56,0x18,0x4A,0x6C,0x13,0x51,0xC7,0x0F,0x00,0x00};
extern const uint8_t spt_REFER[]             PROGMEM ={0xA1,0xB6,0x03,0x53,0x4B,0xFC,0x9C,0x2A,0x56,0x2D,0x0E,0xCE,0x37,0x2A,0x1B,0x75,0x34,0xAA,0x71,0xA9,0xB4,0xF5,0x09,0x4B,0x07,0x02,0xF0,0x5A,0x84,0x01,0xD5,0x86,0x52,0x40,0x03,0x02,0x88,0x21,0xB5,0x44,0xB6,0xA9,0x55,0x63,0xE7,0x99,0xF6,0xB4,0x67,0x3D,0xEF,0x55,0xAF,0x5B,0xEB,0x26,0x47,0x26,0x7F,0xA9,0x7D,0x1D,0xD2,0x68,0xBB,0xA9,0x1F,0x77,0x73,0xA3,0xED,0xD4,0x19,0x96,0x2A,0x8C,0x6E,0x50,0xA6,0x59,0x23,0x33,0xB9,0x46,0x91,0x6A,0x89,0xD8,0x28,0x83,0x4A,0x68,0xA4,0x79,0x00,0x00};
extern const uint8_t spt_REMEMBER[]          PROGMEM ={0x22,0x34,0xD2,0x2D,0xC4,0x9D,0x84,0xDA,0x2E,0x48,0x73,0xF7,0xB7,0xAA,0x54,0xB4,0xC8,0xA5,0xDB,0xAD,0x4E,0x15,0xA3,0xA7,0x53,0xB6,0x29,0xB5,0x0D,0x54,0xCA,0xED,0xD6,0xD7,0xB1,0x4A,0x55,0x4C,0x91,0x81,0xD5,0xE4,0xE6,0x37,0xDB,0x69,0xC9,0xBD,0x73,0x0B,0xE1,0xBA,0x3E,0x8F,0x95,0xA8,0x59,0x50,0x2F,0xB5,0x2C,0xA6,0xB7,0x55,0xCD,0x8A,0xB3,0xD4,0xAA,0xB5,0xA1,0x9B,0xE9,0x60,0xF6,0x34,0xB8,0x85,0xE5,0xC1,0x6F,0xD3,0x68,0x3A,0x45,0x97,0x66,0x89,0x93,0x99,0x6D,0x63,0xCB,0x96,0xAC,0x66,0x31,0x45,0x6D,0xC2,0x6D,0xAB,0xC9,0x4F,0x36,0x33,0x77,0x0B,0x00,0xF0};
extern const uint8_t spt_RETURN[]            PROGMEM ={0x00,0x60,0x12,0x15,0xC9,0x27,0x9C,0xF1,0xA8,0xBC,0x93,0xD4,0xD2,0x65,0xAB,0x4A,0x51,0x43,0x25,0x7B,0xDF,0x6A,0x54,0x3E,0x98,0x99,0x76,0x2B,0xD3,0x19,0x19,0x91,0x1A,0x4E,0x00,0x12,0xD0,0x4C,0xB8,0x07,0x14,0xE0,0x9D,0x19,0x02,0x78,0xB5,0x5C,0x91,0x4F,0x2E,0x95,0xEA,0x7A,0x27,0x2B,0x0D,0xA5,0xC9,0x8B,0x3C,0xEF,0x74,0x67,0x23,0x0F,0xDB,0x38,0x55,0x32,0xCF,0x6A,0xD4,0x61,0x3A,0x87,0x8B,0xAF,0xD6,0x84,0x6B,0x66,0x4E,0x9D,0x4A,0x1B,0x0F,0xBB,0x86,0xA4,0x09,0x5D,0x58,0x90,0x66,0xE5,0xCA,0x75,0x2C,0x58,0x9B,0xB4,0x69,0xDF,0xF9,0xEE,0x01};
extern const uint8_t spt_REWIND[]            PROGMEM ={0x62,0xE4,0xC5,0xB4,0x42,0x95,0x86,0x36,0x5C,0x0E,0x68,0xCE,0xBA,0x9A,0x32,0x3C,0x49,0xA9,0xFD,0x6D,0x4E,0x53,0x46,0x1A,0x18,0x77,0x5F,0x4D,0xC9,0x2E,0x98,0x92,0xBD,0x34,0x41,0xA9,0xDB,0x89,0x7B,0xD3,0xD2,0xD8,0x69,0x22,0x49,0x6D,0x13,0x1A,0xEE,0x6B,0x4D,0xD8,0x4D,0xAB,0x9D,0x89,0x0F,0xA1,0x2C,0xBB,0x5A,0x95,0x77,0x3D,0x89,0x91,0x64,0x57,0xBB,0x5A,0x55,0x8C,0x99,0x41,0x65,0xE7,0x56,0xAB,0x4E,0x23,0x5A,0xB8,0xDC,0xEC,0x66,0xB5,0x79,0xBB,0x33,0x57,0x93,0xDD,0xCE,0xAE,0x75,0xF9,0x98,0xB3,0x54,0x13,0xD7,0x6B,0x47,0x15,0x96,0x76,0x6C,0xA7,0x3B,0xD1,0x71,0x2F,0x9D,0x96,0x96,0x59,0x4F,0x4D,0x66,0x46,0xD8,0x0C,0xC3,0xD0,0xA3,0xAA,0xE5,0x1A,0x01,0x5E,0xB6,0x60,0xE0,0x01,0x00,0x00};
extern const uint8_t spt_RIGHT[]             PROGMEM ={0xA2,0x65,0x21,0xDD,0x39,0x1C,0x8B,0x9A,0x8E,0x90,0xB0,0x74,0xAC,0x6A,0x3A,0x5C,0xA2,0x43,0x89,0x69,0xF8,0x52,0x8E,0x31,0x27,0xA9,0xD1,0x07,0xB3,0x54,0xDC,0xAF,0xDA,0xC4,0x1A,0x67,0x9D,0x77,0xEB,0x53,0x85,0x9C,0xE9,0xDC,0x71,0x6E,0x75,0xAA,0x58,0x33,0x4D,0x3A,0xEE,0xA9,0xD3,0xF0,0x64,0xCF,0xBA,0xA7,0xC9,0x45,0xC4,0xA2,0x2A,0xCD,0x2E,0xF5,0x29,0xB3,0x44,0x57,0x61,0x33,0x18,0x69,0x92,0xE9,0x16,0x00,0x40,0x01,0x5D,0x79,0x3C};
extern const uint8_t spt_ROUND[]             PROGMEM ={0xAA,0xA2,0xA5,0x4D,0xBD,0x64,0x85,0x5A,0x0D,0x0E,0x2F,0x63,0x3F,0x2A,0x9B,0xB5,0xAD,0xF8,0xFA,0xA9,0x42,0xF0,0x72,0xB5,0xDC,0xA7,0x0A,0x29,0xD2,0xA9,0x1B,0x9F,0x2A,0xE6,0x28,0xA7,0x8E,0x73,0xAA,0x90,0xA3,0x9C,0x36,0xF6,0xA9,0x42,0xCA,0x08,0x6A,0xC7,0xA7,0xF6,0x31,0x2B,0xB0,0xA2,0xAC,0xDA,0xC5,0xAA,0xC0,0x8C,0x33,0x1A,0x93,0x27,0x9C,0x2A,0xCA,0x6A,0x6D,0x98,0x74,0xF4,0x2A,0xA3,0x35,0x61,0xC2,0x28,0x6A,0xB7,0x4E,0xFB,0x49,0xA3,0xA8,0xDD,0x3A,0xA3,0x27,0x94,0x23,0x76,0xEA,0xA5,0x49,0x33,0x73,0xDB,0xA9,0xD7,0x4E,0xDD,0xD5,0xE2,0xA6,0xDE,0x38,0xCE,0x30,0x8B,0x93,0x7A,0x65,0xB9,0x92,0x23,0x71,0xE8,0xB9,0xD5,0x2A,0xB6,0x84,0x6E,0xA0,0xDE,0x2B,0x25,0x62,0x94,0x51,0x73,0xF7,0x0C,0xB7,0x9D,0xC6,0xAE,0x82,0xD3,0x34,0x35,0x03,0x78,0x10,0x65,0x80,0xB6,0xA6,0xF0};
extern const uint8_t spt_S[]                 PROGMEM ={0x04,0x48,0x49,0x74,0x14,0x21,0x4A,0x7A,0x6D,0xAC,0x53,0xA5,0xA2,0x29,0xB1,0x4D,0x4E,0x15,0xB3,0x34,0x6D,0x27,0x3A,0x55,0xC8,0xDA,0x12,0xEB,0xFA,0x56,0xA7,0x8E,0x29,0xC2,0xF1,0xDD,0x84,0xD6,0x3B,0x6D,0x91,0x97,0x25,0x80,0xA3,0xC3,0x2C,0x60,0x80,0x2B,0x53,0x34,0x60,0x01,0x07,0x7C,0xEB,0xEE,0x80,0xEF,0xCC,0x1C,0xF0,0x8D,0x85,0x02,0xBE,0x30,0xC3,0xC0,0x03};
extern const uint8_t spt_SAID[]              PROGMEM ={0x06,0x38,0xBA,0xCC,0x02,0x16,0xF0,0x80,0x04,0x4E,0x94,0x63,0x98,0xB1,0xBF,0xB9,0xD1,0x8D,0x6F,0x72,0xF2,0x5C,0xC2,0x8C,0x73,0xCB,0xAD,0x4E,0x9D,0x92,0xBB,0x6B,0xAC,0xB9,0xDD,0xE8,0x63,0x34,0x37,0x8B,0x25,0xAE,0xA7,0x2E,0xD4,0xB3,0x6D,0xF1,0x81,0x0D,0xD4,0xA5,0x7A,0xB6,0x2C,0x36,0x30,0x95,0x9E,0x11,0x8E,0x5D,0x37,0xA4,0xA9,0xBA,0xBB,0x56,0x5D,0x1C,0x26,0xCC,0x59,0x1B,0xE0,0x01,0x00,0x00};
extern const uint8_t spt_SAVE[]              PROGMEM ={0x0A,0x78,0x46,0xD4,0x02,0x16,0x90,0x40,0x4B,0x7C,0xF2,0x50,0xEF,0x26,0x3B,0x39,0x49,0xEC,0x11,0x22,0xD5,0xF4,0x24,0xB1,0xB8,0x8B,0x4D,0x93,0x95,0xA6,0xAC,0xA6,0xB6,0x4D,0x76,0x36,0xF2,0x5C,0x44,0xD5,0xB7,0xF1,0xAA,0x72,0x15,0x55,0x9F,0x25,0xA3,0xCE,0x59,0x58,0xB3,0x6E,0x8F,0x26,0x67,0x61,0x8D,0x7C,0xDC,0x9A,0x9C,0x85,0x34,0x73,0xF6,0x68,0x4A,0x77,0x22,0xB3,0xA7,0xA3,0x29,0x31,0x98,0xC2,0xD6,0x94,0x36,0x06,0x55,0x73,0x69,0x12,0x3A,0x1F,0xC5,0x8D,0xB5,0x8D,0xEA,0x8C,0x34,0x09,0x33,0x37,0x66,0xE8,0x31,0xDD,0x58,0x69,0x33,0x20,0x84,0x14,0x04,0xE8,0xE8,0x81,0x00,0xED,0x5C,0x1F,0x00,0x00};
extern const uint8_t spt_SAY[]               PROGMEM ={0x08,0x78,0xDE,0x5C,0x03,0x16,0xB0,0x80,0x05,0x2C,0x60,0x01,0x0D,0xAC,0x38,0xE5,0x70,0xD1,0x9A,0x7B,0x93,0x9B,0x9C,0x34,0xD5,0x30,0xD1,0x9A,0x7B,0xB3,0x93,0xD7,0x1C,0xA4,0x1A,0x6F,0x6E,0xBD,0xBA,0x52,0x59,0xD5,0xB7,0x76,0x1F,0xEA,0x90,0x07,0x37,0xE4,0x82,0x9A,0xF1,0x51,0xDC,0x98,0xAD,0x62,0x74,0x07,0x7A};
extern const uint8_t spt_SAYS[]              PROGMEM ={0x0C,0xF8,0x0C,0x42,0x01,0xDF,0x8B,0x28,0xE0,0x2B,0x35,0x05,0x5C,0xAD,0x66,0x80,0x17,0xCC,0x2C,0xA0,0x80,0xEF,0x4D,0x39,0x70,0xA2,0x18,0xDC,0x4D,0xAA,0xF1,0x4D,0x57,0x1A,0xAA,0x85,0xC4,0x24,0x99,0xE9,0xCE,0x76,0xB1,0xEB,0xDD,0xAC,0xD6,0x45,0x4F,0xB5,0x5A,0xBC,0xDB,0xD9,0xF6,0xA6,0x35,0x3E,0x58,0x0A,0x67,0x9B,0xD2,0x78,0xEB,0xEE,0x18,0x9D,0x53,0xBB,0xB8,0x9A,0x87,0xEA,0x15,0xC0,0x33,0xA4,0x12,0x30,0xC0,0xD5,0x62,0x1A,0x10,0x40,0x63,0xA1,0x0F};
extern const uint8_t spt_SCREEN[]            PROGMEM ={0x04,0xF8,0x4A,0x4D,0x00,0x57,0xAB,0x29,0xE0,0x05,0x33,0x0D,0x80,0x01,0x3C,0x2B,0x17,0x80,0x9E,0x4D,0x12,0x28,0xB1,0x19,0x18,0x96,0xA6,0xBD,0xA7,0x23,0xF1,0x93,0x53,0xDC,0xF2,0xAE,0x24,0x4E,0x35,0xA5,0x88,0xBF,0x92,0x11,0x83,0xD0,0x7D,0xCD,0x4E,0x6E,0xBA,0xB3,0x51,0x8C,0x1C,0x0C,0x9A,0x8B,0x77,0xB5,0x9B,0xD1,0xF6,0x9A,0x0C,0xEA,0x8B,0x4B,0x57,0xAB,0x23,0x9B,0x3D,0x76,0x9D,0x73,0x50,0x66,0x65,0xDB,0x77,0xBE,0x77,0xBD,0xF5,0x58,0x6A,0xE5,0xD8,0xF6,0xBA,0x97,0xC3,0x03,0x00,0x00};
extern const uint8_t spt_SECOND[]            PROGMEM ={0x0C,0x88,0xC4,0xC2,0x01,0xDF,0x08,0x3B,0xE0,0x17,0x22,0x07,0xFC,0x22,0x1C,0x80,0x5F,0x14,0x1C,0xF0,0x83,0x4A,0x88,0x3A,0x73,0x33,0x31,0x5B,0x3B,0x1D,0x99,0xCB,0x11,0x6E,0x59,0x67,0x64,0xB1,0xB8,0x86,0x66,0x65,0x20,0x80,0xF6,0x26,0x18,0x40,0x80,0x28,0x1A,0xAB,0x0E,0x25,0xCC,0xD4,0x27,0xEF,0x66,0x74,0xDE,0x97,0x6A,0x58,0xEC,0xD0,0x07,0x0F,0xA5,0x29,0x49,0x62,0x1F,0xFB,0xD8,0xBB,0xDE,0x58,0x38,0x0F,0x93,0x62,0x7B,0x31,0xE0,0x90,0x95,0x5A,0x36,0xD3,0x10,0xB3,0x87,0x70,0xC4,0xF4,0xCD,0x03,0x00,0x00};
extern const uint8_t spt_SEE[]               PROGMEM ={0x08,0xD0,0xB4,0x42,0x00,0x8B,0x88,0x3A,0xE0,0x2B,0xD5,0x00,0xFC,0x18,0xE6,0x81,0x08,0x78,0xC0,0x00,0x4F,0xAB,0x1C,0xA7,0xF8,0x60,0x31,0x7D,0x73,0xE2,0x1A,0x93,0xD8,0xED,0xEB,0x8D,0x6F,0x72,0xB3,0x51,0xF4,0x9A,0x02,0x1A,0x6F,0x77,0xB5,0xEB,0xD9,0x94,0xB6,0x34,0x22,0xA9,0xA9,0x93,0xBB,0xD0,0x25,0xC7,0x94,0x97,0xA1,0x4D,0xE7,0x95,0xF0,0x9E,0x18,0x35,0x5D,0xF4,0xA0,0xD3,0x29,0x4C,0x75,0xC1,0x82,0x86,0xB9,0xB3,0x07};
extern const uint8_t spt_SEES[]              PROGMEM ={0x08,0x30,0x2C,0x45,0x01,0x3F,0x87,0x7B,0xC0,0x03,0x11,0x88,0x80,0x03,0x8E,0x09,0x1B,0x49,0xB2,0xA6,0x66,0xD1,0xE9,0xC4,0xCD,0x87,0xA2,0xCB,0xD7,0x95,0xF4,0xE8,0x0C,0x11,0x6F,0x77,0x3A,0xB3,0x59,0xF5,0x6A,0xB4,0xBD,0x95,0x02,0xCB,0xB6,0xD2,0x97,0xCA,0x82,0x51,0x4F,0xCA,0x90,0x0A,0x8B,0x58,0xBD,0xCD,0x7D,0x1A,0x62,0x62,0x91,0xC8,0xC7,0x69,0x08,0x91,0x55,0xB5,0xEE,0x84,0x3E,0x68,0x53,0x75,0x5F,0xA1,0x80,0x04,0x34,0x3D,0x60,0x01,0x09,0x50,0xE0,0x01,0x00,0x00};
extern const uint8_t spt_SET[]               PROGMEM ={0x06,0xF8,0x4E,0xC9,0x00,0xD7,0x29,0x2B,0xE0,0x3B,0x25,0x0B,0x58,0x40,0x01,0x5B,0xAA,0xB4,0x28,0xA5,0x50,0xD3,0x9C,0x77,0x93,0x9B,0xDE,0xEC,0x54,0x31,0x5B,0x8B,0x4F,0xE2,0x5B,0xF7,0x96,0x01,0x32,0x69,0x03,0x80,0x02,0xBC,0x4C,0xF3,0x00,0x02,0xA8,0x2D,0x05,0x80,0x07};
extern const uint8_t spt_SEVEN[]             PROGMEM ={0x0C,0xF8,0xDE,0x4C,0x02,0x1A,0xD0,0x80,0x05,0x2C,0xB0,0x62,0x17,0x2D,0x43,0x2B,0xF1,0x4D,0x6E,0xB2,0xD3,0x92,0x19,0x1F,0x6E,0xEC,0x51,0x5C,0xE5,0xB9,0x5A,0x58,0x3A,0x76,0x95,0xF7,0x9E,0x1E,0x30,0xAF,0x77,0x65,0xB2,0x29,0x42,0x2C,0xA6,0xB8,0xD9,0x64,0xCD,0x90,0x8A,0xE5,0x66,0x13,0x38,0x8C,0xD3,0x9D,0x58,0xB4,0x17,0x1B,0x29,0xF7,0x62,0x31,0x5E,0xC5,0x24,0xD3,0x88,0xCD,0x79,0xD6,0x90,0x71,0xF7};
extern const uint8_t spt_SEVENTY[]           PROGMEM ={0x0E,0xF8,0x41,0x38,0x02,0x1E,0xF0,0x80,0x07,0x2C,0xC0,0x81,0x13,0xBB,0xEC,0xA5,0x31,0xF1,0x6E,0x7C,0xE3,0x96,0xC6,0x64,0x6D,0xA4,0xB1,0x4D,0xE5,0x42,0xB8,0xAB,0x2D,0xEE,0x55,0xAB,0xBC,0x4F,0x33,0xD5,0xD9,0xA5,0x71,0x2E,0xC5,0x95,0x66,0x85,0xD6,0x58,0x98,0x94,0x8C,0xED,0x5B,0xD5,0x09,0x47,0x97,0x5C,0x96,0x44,0x2F,0x64,0x7A,0x84,0x5B,0x06,0x70,0x40,0xD1,0x69,0xA9,0xF6,0x4E,0xB8,0xD6,0x43,0xD5,0x3E,0x0F,0x71,0xB4,0x03,0x3C};
extern const uint8_t spt_SHAPE[]             PROGMEM ={0x00,0x0C,0x58,0x69,0x43,0x03,0x16,0x88,0x80,0x07,0x3C,0xE0,0x01,0x0F,0x9C,0x24,0x67,0x57,0xD5,0x6E,0x7A,0xD3,0x9B,0xDF,0xEA,0x54,0x2D,0x06,0x89,0xD6,0xD2,0x59,0x87,0xBA,0x06,0x43,0x8B,0xBE,0xE3,0x9A,0x18,0x51,0x2A,0x7B,0x34,0x6E,0x00,0xC0,0x00,0xC1,0x25,0x33,0x80,0xBB,0x30,0x80,0x07};
extern const uint8_t spt_SHAPES[]            PROGMEM ={0x0A,0x58,0x69,0xC3,0x02,0x1E,0x88,0x80,0x07,0x3C,0xE0,0x81,0x15,0xE5,0xEC,0xAA,0xDA,0x4D,0x6F,0x7C,0xE3,0x9B,0x9C,0xB4,0xC5,0x20,0xD1,0x5A,0x7A,0xF3,0x51,0xD5,0x60,0x68,0xD1,0x77,0x4A,0x1B,0x23,0x4A,0x65,0x8F,0xD6,0x2D,0x00,0x80,0x01,0x7E,0x76,0xB7,0x80,0x03,0x7E,0x72,0x75,0xC0,0x2F,0xA1,0x06,0xF8,0xD9,0xD5,0x00,0x3F,0xB9,0x32,0xE0,0x07,0x16,0x01,0x2C,0xE9,0xF9};
extern const uint8_t spt_SHIFT[]             PROGMEM ={0x08,0x98,0x6D,0x53,0x03,0x1E,0xF0,0x40,0x02,0x56,0xDA,0x88,0x40,0x04,0x2C,0x70,0x92,0xAA,0x42,0x65,0x7C,0xF3,0x4D,0x6F,0x76,0x8A,0x22,0xC3,0x74,0x6C,0xD3,0xAC,0x7C,0x4B,0x00,0x2B,0x9C,0x39,0xC0,0x01,0x0E,0x70,0x00,0x00,0x40,0x01,0x99,0x87,0x11,0x40,0xB8,0x30,0x78};
extern const uint8_t spt_SHORT[]             PROGMEM ={0x0E,0x18,0x63,0xDB,0x01,0x63,0xEC,0x3A,0x60,0xF4,0x19,0x0B,0x50,0x60,0xA4,0xCA,0x56,0xBA,0x9B,0x9F,0x99,0x8E,0x54,0xDB,0x8D,0x70,0xD5,0xBE,0xF3,0x55,0x99,0x30,0x66,0x29,0xFA,0x57,0xE5,0x42,0x8B,0xB6,0xEA,0x5B,0x95,0xAF,0xC5,0x52,0xAE,0x2F,0x55,0xAE,0x0B,0x7B,0x54,0x5C,0xD6,0x27,0x67,0x1E,0x12,0x6E,0x00,0x0C,0x50,0xBC,0xAB,0x02,0x52,0x2E,0x41,0x80,0x0E,0x16,0x0F};
extern const uint8_t spt_SHORTER[]           PROGMEM ={0x08,0x18,0x63,0x5B,0x03,0x16,0x30,0xC0,0x18,0xBB,0x0E,0x18,0x7D,0xC6,0x02,0x14,0x18,0xA9,0x33,0xE1,0x9E,0xAA,0x76,0xA4,0xCA,0x55,0x65,0x90,0xF6,0x91,0xCA,0xB8,0x5D,0x0E,0xEE,0x47,0x2A,0xD3,0x56,0x3A,0xBA,0x5F,0xA9,0x0E,0x13,0x9E,0xEC,0x7D,0xA5,0xD6,0xA7,0xF9,0xB2,0xB6,0x91,0xFA,0xA9,0x1A,0xE6,0x7A,0xC0,0x00,0x21,0x2A,0x07,0xA0,0x0C,0x97,0x92,0xBB,0x24,0x9E,0x16,0x49,0x46,0xE5,0x17,0x85,0xBB,0x67,0x1B,0x8D,0x9F,0xEC,0x96,0x96,0xBD,0x75,0x7E,0xB1,0x5B,0x6A,0xF6,0xD2,0xDB,0x41,0x11,0x19,0xE9,0x42,0x6F,0x07,0x54,0x59,0x24,0x76,0x83,0xED,0xAC,0x99,0xE1,0xC4,0x74,0xF1,0xB2,0xB8,0x9A,0x63,0x00,0x00,0x94,0x26,0x93,0xE2,0xE1,0x6A,0x1E};
extern const uint8_t spt_SHOULD[]            PROGMEM ={0xE0,0x80,0xD9,0x36,0x23,0x10,0x81,0x04,0xAC,0xB4,0x91,0x81,0x08,0xAC,0x38,0xE8,0x10,0x4D,0xEF,0x77,0x12,0x6F,0x3C,0x23,0x29,0xEF,0x4E,0x57,0xEA,0x74,0xA4,0x87,0xE4,0xBD,0xC5,0xAD,0x6E,0x77,0xBB,0xDD,0x97,0x3E,0x06,0x09,0x37,0x79,0x6B,0x7B,0x3D,0x88,0x5E,0xF0,0xF0,0xB2,0x70,0x9D,0x86,0x6A,0x4C,0x3C,0xCD,0xB5,0xEB,0x53,0x14,0x57,0xD1,0x47,0x08,0xE0,0xDA,0xE3,0x01};
extern const uint8_t spt_SIDE[]              PROGMEM ={0x04,0xF8,0xC5,0xC4,0x02,0x16,0xB0,0x80,0x05,0x28,0xB0,0x2A,0xEF,0xAB,0x5D,0xA2,0xF1,0x4D,0x6F,0x7A,0xD3,0x93,0x85,0x58,0x65,0x12,0xB3,0x6F,0x7E,0xAA,0x90,0xB3,0x4C,0x7C,0xCE,0xAD,0x4F,0x9B,0x8A,0x85,0x69,0xCD,0xD9,0xDD,0xE8,0x63,0x12,0xD7,0xE8,0xD9,0xBD,0x2F,0x7D,0x8A,0x6C,0x6E,0x75,0x47,0x0C,0x54,0x67,0x84,0x7B,0x62,0xD9,0xB3,0x9E,0xC9,0xF2,0xB4,0x50,0x92,0xFA,0xE5,0xD2,0x4C,0xCD,0xB1,0x69,0xA3,0x57,0x55,0xB1,0x4E,0xAA,0x8F,0x55,0x8D,0x69,0x12,0x3E};
extern const uint8_t spt_SIDES[]             PROGMEM ={0x08,0xF8,0x56,0x58,0x03,0x1E,0xF0,0x80,0x05,0x24,0xA0,0x81,0x93,0x86,0x5C,0x65,0x92,0x75,0x6E,0x7E,0xF3,0x5B,0xDC,0xE2,0x54,0xA1,0x56,0xAA,0x46,0x9D,0xD3,0xC4,0xA2,0x61,0x56,0x53,0x77,0x3B,0xBA,0x94,0xC5,0xDC,0x6B,0xCA,0xEC,0x7B,0x5F,0xFA,0xE0,0x54,0x3C,0xE2,0x91,0xE8,0xB0,0xA9,0xF0,0x4A,0x99,0xB2,0x93,0x9D,0xEA,0x9F,0x15,0x74,0x31,0xBB,0xBE,0x57,0xC0,0xE6,0x22,0x0E,0xF8,0x4E,0x39,0x02,0x1A,0x78,0x00,0x00};
extern const uint8_t spt_SIX[]               PROGMEM ={0x06,0x98,0xB6,0xC4,0x01,0x2F,0x66,0x46,0x20,0x01,0xD3,0x96,0x18,0x40,0x04,0xAF,0x96,0xA4,0x60,0xA1,0x52,0x8B,0x6F,0xB2,0x92,0x58,0xC4,0xC5,0x67,0xC9,0x4E,0x46,0x95,0x9A,0xB8,0x44,0x2D,0x76,0x7D,0x48,0xD8,0x13,0x15,0x03,0x00,0x10,0x60,0xA2,0x8B,0x00,0x8E,0xAD,0x52,0xC0,0xCF,0x9E,0x1A,0x10,0xC0,0x8F,0xE6,0x0F,0x00,0x00};
extern const uint8_t spt_SIXTY[]             PROGMEM ={0x06,0xF8,0x8A,0x5C,0x03,0x0E,0xF8,0xCE,0x44,0x01,0x4F,0x98,0x9D,0x24,0x3A,0x37,0xB7,0x78,0x72,0xE2,0x9C,0xCD,0xCC,0xE2,0xC9,0x8A,0x73,0x57,0x51,0xCD,0xBB,0x00,0x0C,0x30,0x25,0x28,0x00,0xC7,0x54,0x04,0xE0,0x5B,0x57,0x05,0x5C,0xC1,0x8C,0x00,0x0F,0xAA,0xC0,0x01,0x35,0x16,0x8D,0x2C,0xEA,0xA0,0xB4,0x6A,0xBC,0xAA,0x92,0x8C,0x39,0xE2,0x4D,0x69,0x4B,0x57,0xA6,0xA8,0xDB,0xA1,0x4F,0x41,0xD0,0xAE,0x63,0x9B,0x31,0x19,0xE2,0xAA,0x0A,0xFD};
extern const uint8_t spt_SMALL[]             PROGMEM ={0x0C,0xF8,0xD9,0x44,0x02,0x12,0xD0,0x80,0x05,0x34,0x10,0x52,0x69,0x35,0x4A,0xCC,0x5E,0xCC,0x56,0x66,0xDC,0xAD,0xB1,0x37,0xDD,0xD9,0xCC,0x67,0x31,0xAB,0xD9,0x94,0x46,0xD6,0x19,0xC5,0x76,0x52,0xBB,0xD0,0x89,0xB5,0xAD,0x50,0xCA,0x62,0xEF,0x7A,0x7E,0x2F,0x14,0x53,0x99,0xE9,0x79,0x7B,0x52,0x75,0xBB,0x0F,0x00,0x00};
extern const uint8_t spt_SMALLER[]           PROGMEM ={0x04,0xF8,0xD5,0x48,0x02,0x1A,0xD0,0x80,0x06,0x38,0x00,0x29,0xD6,0x46,0xBA,0x59,0x93,0x94,0xD4,0x8B,0x9E,0x64,0x4E,0x3A,0xD3,0x99,0xEC,0x64,0xA7,0x3B,0x2D,0x95,0xD6,0xD3,0x49,0x6A,0xAF,0xD4,0xDA,0xFB,0xAB,0x9A,0xE6,0xD4,0xEA,0xCE,0xD3,0x62,0x89,0x63,0xEF,0x06,0x77,0xD0,0xC6,0xB4,0x91,0x1F,0xDC,0xE8,0x2E,0xAB,0x57,0x78,0xB1,0xD3,0x03};
extern const uint8_t spt_SMALLEST[]          PROGMEM ={0x0A,0xF8,0x06,0xC5,0x02,0x1E,0xF0,0x00,0x05,0xC0,0xA5,0x34,0x25,0x87,0x5B,0xDA,0x96,0x79,0x95,0x1F,0xAC,0xAD,0x77,0x76,0xB3,0x95,0x59,0x53,0xEF,0xE4,0x8D,0x57,0x66,0xCC,0x97,0xAA,0xA5,0xDD,0x79,0xAD,0x5A,0xE3,0xD8,0x95,0x39,0x35,0x19,0xAD,0xB5,0x13,0xA6,0xBE,0x68,0xF4,0x36,0x44,0x86,0x54,0x93,0x32,0xD8,0xE6,0x6C,0x35,0x2E,0xF3,0x10,0x86,0x10,0xCA,0x18,0x22,0x93,0x01,0xBE,0x15,0xF2,0x40,0x00,0x7E,0x35,0x70,0xC0,0x1F,0x0A,0x18,0x00,0x70,0x40,0xE5,0x16,0x06,0x38,0x4E,0x0C,0x1E,0x00,0x00};
extern const uint8_t spt_SO[]                PROGMEM ={0x06,0xF8,0x51,0x38,0x01,0xDF,0x29,0x07,0xE0,0x47,0xE5,0x04,0x7C,0xA7,0x1C,0x80,0x1F,0xCD,0x22,0x70,0xE2,0xC8,0xA3,0xD3,0x34,0xCF,0x8D,0x6F,0xB2,0x52,0xAB,0xBA,0xCA,0xD9,0xEF,0xCE,0x76,0x35,0xDB,0xD2,0x8B,0x50,0x9B,0x46,0x59,0xC3,0x40,0x57,0x77,0x92,0xA5,0xB4,0x83,0x1A,0xC9,0x99,0x30,0xF1,0xD4,0x62,0x64,0xBD,0x43,0xC5,0xDD,0x3C,0x00,0x00};
extern const uint8_t spt_SOME[]              PROGMEM ={0x0C,0x78,0x55,0x40,0x02,0x12,0xD0,0x80,0x06,0x2C,0x10,0x92,0x64,0xAA,0x2D,0x38,0xED,0x4D,0x6E,0x76,0x32,0x17,0xBA,0xD5,0xB8,0xC9,0xCD,0x76,0xDE,0x2A,0x9B,0xA5,0x54,0x28,0x4D,0xAC,0x63,0x1B,0xDB,0xD8,0xFA,0xCE,0x76,0xB2,0xA7,0xFD,0x03};
extern const uint8_t spt_SORRY[]             PROGMEM ={0x06,0x38,0xD6,0xD4,0x03,0x01,0xF8,0x5E,0x35,0x00,0x3F,0xBA,0x45,0x20,0x03,0xCB,0x77,0xD6,0xDA,0x35,0x6D,0x9F,0xD8,0x27,0xDF,0x10,0x4F,0x7B,0xE3,0x13,0x87,0x6C,0xE7,0xA6,0x69,0x6E,0x7C,0x12,0x57,0xEC,0xCC,0xB5,0xED,0xCA,0x4C,0xB3,0xB3,0x94,0x2C,0xA3,0xB2,0x4D,0xC7,0x06,0xD7,0x8E,0xC6,0x57,0x69,0x19,0x69,0x37,0xFB,0xD1,0xA7,0xCA,0x66,0x31,0x0D,0x7B,0xDF,0xFA,0x32,0xC8,0x35,0x36,0x56,0xE9,0x72,0x03,0xB3,0x38,0x49,0xA5,0xAD,0xD5,0x21,0xB4,0x4B,0x9B,0xC6,0x19,0xE6,0xF7,0x90,0xF2};
extern const uint8_t spt_SPACE[]             PROGMEM ={0x0C,0x78,0x46,0x54,0x03,0x1E,0x88,0x00,0x06,0x00,0xC0,0x00,0xAA,0x4A,0x9F,0x3C,0x34,0x73,0xB1,0x4A,0x7D,0xF3,0x53,0xA4,0x66,0xA6,0x1A,0x4B,0x57,0x95,0x93,0xB2,0x46,0xAC,0x9E,0x75,0x6B,0x63,0x10,0x31,0xAF,0xC5,0xB5,0x53,0xC0,0xD7,0xA6,0x11,0x88,0x80,0x07,0x22,0xE0,0x81,0x07};
extern const uint8_t spt_SPACES[]            PROGMEM ={0xC0,0x80,0x09,0xAC,0x0C,0xF0,0x8C,0x86,0x03,0x7E,0x50,0x77,0xC0,0x8F,0x16,0x0E,0xF8,0x2E,0xD3,0x00,0xCC,0xA5,0x03,0x9C,0x24,0x34,0x73,0xB1,0x4A,0x7D,0xB3,0x93,0xA7,0x66,0xA6,0x1A,0x4B,0x4F,0x9E,0x93,0xB2,0x46,0xAC,0xDE,0x59,0xCB,0x62,0x10,0x31,0xAF,0xC5,0x3D,0x33,0xC0,0xB7,0xA4,0x0E,0xF8,0x4E,0x24,0x00,0xDF,0x98,0x1B,0xA0,0x31,0xF3,0x34,0x98,0xE0,0x66,0x19,0xB7,0xF2,0x90,0xA7,0x38,0x99,0xC9,0x04,0x73,0x8D,0x7A,0x10,0xA6,0xAB,0x3D,0x54,0x58,0xBF,0x01,0x36,0x66,0xD5,0x80,0x02,0x2E,0x23,0x55,0xC0,0x67,0xA8,0x02,0xF8,0x92,0x4D,0x00,0x93,0x98,0xC1,0x03};
extern const uint8_t spt_SPELL[]             PROGMEM ={0x01,0xF8,0x5E,0x2D,0x01,0x3F,0x9A,0x27,0xE0,0x27,0x0B,0x07,0x5C,0x4D,0x0E,0x00,0x0C,0xB0,0x22,0xEC,0xA4,0x26,0xA4,0xAB,0x57,0xAA,0x93,0xD9,0x98,0xE1,0xDE,0xA9,0x4F,0xEE,0x62,0x86,0x79,0xA5,0x3E,0x85,0x4F,0x19,0xEA,0xD1,0xE6,0x54,0x3E,0x64,0x9A,0x46,0xE6,0x53,0x85,0x90,0x15,0x12,0xBE,0x57,0x6D,0x72,0x65,0xD0,0x7A,0x1A,0xAD,0xCA,0x53,0x4E,0xE3,0xB9,0x0D,0xB2,0x4F,0x06,0xA7,0xE7,0x32,0x8A,0xDE,0xD9,0x10,0x9E,0xD3,0xC4,0x7B,0x47,0x83,0xDB,0xF6,0x93,0x99,0xA4,0x7F,0x2B,0xA2,0x54,0x66,0x16,0x39,0x2C,0x2C,0x2C,0x3D};
extern const uint8_t spt_SQUARE[]            PROGMEM ={0x0A,0xF8,0x01,0xC5,0x02,0x11,0xC8,0x00,0x06,0x00,0x10,0x20,0xE6,0x18,0x02,0x78,0x6F,0x2B,0x89,0x8C,0x5D,0x69,0x94,0x75,0xA6,0x3B,0x3D,0x69,0x28,0x66,0xA1,0xBE,0xE6,0x66,0x3B,0xDF,0xC5,0xAA,0x62,0x73,0xF1,0xB4,0xAE,0xAD,0xF3,0x87,0x3D,0xCC,0xBB,0xD4,0x21,0x8F,0x69,0xF4,0xDB,0x29,0x42,0x66,0x87,0x29,0x5C,0xD7,0x40,0x4E,0xE6,0xA6,0x70,0xD8,0x92,0x3C,0x91,0x9D,0x1E};
extern const uint8_t spt_START[]             PROGMEM ={0x0A,0xF8,0x41,0xC2,0x00,0x3F,0x59,0x78,0xC0,0x02,0x00,0x01,0xA8,0xCE,0xED,0x84,0xC1,0x65,0x98,0x45,0xEA,0x93,0xD8,0x12,0xE3,0x9C,0x99,0x6F,0x7A,0x32,0x97,0x63,0x82,0xAD,0xCD,0xCA,0x7D,0x0B,0x2F,0xC7,0xA5,0xB7,0x5E,0x9D,0x1F,0xAE,0x19,0xB4,0xA4,0x0F,0x6D,0x0C,0x8D,0x3C,0xC3,0x62,0x87,0x21,0x74,0xD0,0xF0,0x48,0x0C,0x90,0x80,0x61,0x22,0x1C,0xA0,0xB5,0x0B,0x06,0x1E};
extern const uint8_t spt_STEP[]              PROGMEM ={0x06,0x78,0xC1,0xD3,0x02,0x11,0xB0,0x00,0x40,0x02,0xAA,0x4A,0x39,0x69,0x88,0xA1,0xA6,0xD5,0xFA,0xA4,0xA1,0x5B,0x88,0x75,0xD3,0x9B,0xDF,0x62,0xB4,0xB6,0x59,0xB9,0x75,0xAC,0x30,0x98,0xA9,0xA5,0xB6,0xB1,0x01,0x80,0x01,0x32,0x04,0x63,0xE0,0x01,0x00,0x00};
extern const uint8_t spt_STOP[]              PROGMEM ={0x0E,0xD8,0x5A,0x3D,0x02,0x11,0xF0,0x00,0x40,0x00,0xBA,0x0F,0x5F,0x85,0x4F,0xBD,0x2A,0x91,0xE4,0x16,0xB7,0xBA,0xD5,0x6D,0x6E,0x33,0x3A,0xDB,0xA7,0x94,0xC7,0xAE,0xEF,0x01,0x00,0x04,0xA0,0xBD,0x39,0x06,0xE0,0x01,0x00,0x00};
extern const uint8_t spt_SUM[]               PROGMEM ={0x0C,0x78,0x55,0x40,0x02,0x12,0xD0,0x80,0x06,0x2C,0x10,0x92,0x64,0xAA,0x2D,0x38,0xED,0x4D,0x6E,0x76,0x32,0x17,0xBA,0xD5,0xB8,0xC9,0xCD,0x76,0xDE,0x2A,0x9B,0xA5,0x54,0x28,0x4D,0xAC,0x63,0x1B,0xDB,0xD8,0xFA,0xCE,0x76,0xB2,0xA7,0xFD,0x03};
extern const uint8_t spt_SUPPOSED[]          PROGMEM ={0x06,0xD8,0xCA,0xC5,0x03,0x11,0x88,0x80,0x07,0x46,0x62,0x74,0x96,0xB9,0xB7,0x9A,0x59,0x2D,0x70,0x05,0x0E,0xB0,0x35,0x6D,0xA5,0xC6,0x65,0x9B,0x6A,0xEB,0x93,0x39,0x93,0x63,0xAA,0x59,0x46,0xA6,0x6D,0x8D,0xAA,0x75,0x99,0xD9,0x2C,0x5A,0xA5,0x4C,0xB7,0x9A,0x76,0x1E,0xB5,0x36,0x55,0x62,0xD6,0x65,0xD4,0xC6,0x54,0xAA,0x6B,0x97,0xD5,0x58,0x9D,0x25,0xAE,0x5D,0x46,0xE3,0x55,0xA6,0x98,0x76,0x6D,0xAD,0xB3,0x15,0x64,0xD6,0x46,0x01,0x15,0x90,0x7B,0x20,0x02,0x11,0x00,0x60,0x80,0x13,0x1E,0x06,0x68,0x22,0x0C,0x1E,0x00,0x00};
extern const uint8_t spt_SUPPOSED_TO[]       PROGMEM ={0x04,0x78,0x4D,0xC8,0x02,0x0E,0xF8,0x45,0xD0,0x01,0xBF,0x9A,0x7A,0xE0,0x14,0x51,0x66,0xB2,0x47,0xEB,0x5B,0xED,0x0A,0x0C,0xE0,0xB5,0x65,0x4B,0xB4,0x9B,0x52,0xF5,0xD6,0x3B,0xBD,0xD9,0xCE,0x46,0x2E,0xDD,0x26,0x47,0xB5,0x9A,0x79,0xCF,0x6B,0xE5,0x80,0x5B,0x98,0x3D,0x60,0x80,0x3F,0x98,0x00,0x12,0xB0,0x9C,0x7A,0x00,0x96,0x74,0x1F,0x55,0x71,0x6E,0x9C,0x9C,0xED,0x36,0xB7,0x1B,0xBD,0xF1,0x1A,0x19,0x3A,0xBB,0xF6,0x61,0x94,0xC1,0x33,0xD3,0x1A,0xB9,0x51,0x24,0xB7,0x4C,0xAF,0x6D,0x46,0x65,0xCB,0xAD,0xA4,0xA1,0x19,0x8D,0x31,0x6B,0xD6,0x44,0x0F};
extern const uint8_t spt_SURE[]              PROGMEM ={0x00,0x00,0x00,0x40,0x80,0x2C,0x45,0x0D,0xB0,0xE6,0x54,0x04,0x22,0xB0,0xD2,0x5E,0x76,0xAE,0x52,0xF1,0x09,0x4A,0xAC,0x40,0x54,0xAD,0x2B,0x4D,0x3E,0x8C,0x22,0xB5,0xAF,0x34,0xF8,0x30,0x19,0xF7,0xBE,0x72,0xE7,0x43,0x6D,0xDD,0xFD,0xAA,0xBC,0x2B,0xB1,0x55,0xF7,0xA3,0x72,0x39,0x38,0x86,0xBD,0xB7,0xDA,0x54,0x97,0x1C,0x4D,0x9F,0x5B,0xD7,0xD9,0x49,0x5E,0x66,0x5D,0x54,0xAF,0x8A,0x7A,0x5A,0x30,0x52,0xBD,0x2B,0xA2,0xAE,0xA1,0x51,0xF4,0xBE,0x99,0x18,0xBB,0x6B,0x00,0x00,0x78};
extern const uint8_t spt_T[]                 PROGMEM ={0x09,0x58,0xCC,0x3C,0x00,0x2F,0x85,0x96,0x70,0xC6,0x50,0x62,0x69,0xB2,0x92,0x91,0x82,0xC1,0xE3,0xED,0x4D,0x4E,0x3A,0xA2,0x32,0x46,0x3E,0xD9,0xF9,0xAC,0x5A,0x3D,0x2C,0x33,0x77,0xCE,0x4E,0x4D,0x51,0xCC,0xB6,0x59,0xC6,0x35,0x46,0x88,0x4F,0xAB,0x55,0xD5,0x38,0x26,0x3E,0x23,0x66,0x1F,0x00,0x00};
extern const uint8_t spt_TAKE[]              PROGMEM ={0x09,0xE8,0xDA,0x3D,0x00,0xCD,0xB5,0x18,0x20,0x15,0xB5,0x11,0xA7,0xA6,0x2E,0x31,0xAE,0x6F,0x72,0xD2,0xD2,0xD5,0x28,0xAA,0xE9,0xCD,0x76,0x31,0xEA,0xE8,0xC0,0xB6,0xD2,0x74,0xEC,0xCD,0x98,0x64,0x6A,0x98,0x29,0x06,0x08,0x40,0x74,0x4E,0x16,0x10,0x40,0x0A,0x06,0xF0};
extern const uint8_t spt_TEEN[]              PROGMEM ={0x01,0x58,0x36,0x25,0x02,0x16,0x38,0x7E,0x0B,0x26,0xE4,0x31,0xF7,0x26,0x37,0x1D,0xD9,0x8C,0xCC,0xD2,0x39,0x69,0x16,0xB3,0xEA,0xCD,0xEC,0x5A,0x37,0xA2,0x30,0x67,0x54,0x09,0xBD,0xB6,0xB4,0x69,0x25,0xC5,0x0E,0x66,0xD0,0x86,0x2E,0xB4,0x6C,0x9B,0x41,0x6A,0x99,0x94,0x74,0xA4,0x06,0x61,0x64,0x53,0xCB,0xB6,0x19,0x3C,0x35,0xCB,0xF2,0x54,0x00,0xF0};
extern const uint8_t spt_TELL[]              PROGMEM ={0x90,0x80,0xA5,0x42,0x1C,0xD0,0x6C,0x48,0x89,0x63,0x75,0x93,0xA8,0xB8,0x37,0xBD,0xE9,0x4D,0x4F,0x16,0x5A,0x84,0x78,0xD5,0xB9,0xF9,0x29,0x5C,0xCE,0x56,0xC9,0x26,0xB7,0x1A,0xB5,0x6E,0xD5,0xAA,0x31,0x7B,0xB6,0xAD,0x95,0xA3,0x5A,0x34,0x1B,0xD7,0xAE,0x74,0x62,0x55,0x29,0x67,0xE2,0xD0,0xF1,0x9B,0xA9,0xD4,0x51,0x4D,0xCF,0x6E,0xB8,0x4A,0xCB,0x71,0xBD,0x4A,0x16,0xE1,0x25,0xE9,0x01};
extern const uint8_t spt_TEN[]               PROGMEM ={0x0A,0xB0,0xDC,0xD4,0x01,0x83,0x86,0x28,0x20,0x85,0x10,0x01,0xB8,0x28,0x72,0xE2,0x34,0xCB,0x55,0xA2,0xEE,0x4D,0x6E,0x7A,0xB3,0x9B,0x9F,0x22,0x2E,0x77,0xF6,0x88,0x73,0xEB,0xDD,0xCE,0x2E,0x74,0xDE,0x42,0x4B,0x7A,0xA3,0xD8,0x85,0xDE,0x5B,0x18,0x89,0x4C,0xE9,0x7A,0x67,0xB0,0xC5,0x2B,0xA5,0xE9,0x95,0xE1,0x96,0xE8,0x84,0xAA,0xE7,0x4E,0xC3,0xEC,0x63,0x3F,0x00,0x00};
extern const uint8_t spt_TEXAS_INSTRUMENTS[] PROGMEM ={0x0E,0xA8,0xCA,0xD4,0x01,0x59,0xA4,0xAE,0x24,0xE8,0xD4,0xF0,0x88,0x74,0x92,0x90,0x4B,0xCD,0xA3,0xDE,0x49,0x62,0x29,0x31,0x8F,0xA5,0x2B,0x49,0x3B,0xD9,0x34,0x9A,0xB8,0x3C,0x24,0x07,0xD1,0x8C,0x63,0x92,0x15,0xB7,0x0C,0x59,0x96,0x01,0x7E,0x51,0xF5,0x80,0x03,0x7E,0x33,0x6A,0xC1,0x5F,0x29,0xC2,0x26,0x7F,0xE5,0xD1,0x94,0x99,0xD8,0xEB,0x95,0x45,0x5D,0xE6,0xEC,0x8F,0x57,0x16,0x6D,0x9A,0xA3,0x3F,0x69,0xF9,0xE2,0x92,0x26,0x96,0xD5,0x01,0xCF,0xB0,0x58,0xC0,0x03,0x1A,0x58,0x59,0x72,0xA5,0x41,0x3C,0x7B,0xE7,0x3B,0x9F,0x45,0x2B,0x9C,0xA6,0x6C,0xAA,0x7A,0xB1,0x0A,0xC0,0xEB,0x01,0x1E,0x70,0xC0,0xAB,0x0E,0x08,0x30,0x44,0x4B,0x00,0xC5,0x81,0x05,0x60,0x14,0x8F,0xD5,0x44,0xE7,0x2E,0x1A,0xCE,0x76,0x93,0x3A,0xE3,0xCC,0x25,0x54,0x79,0xEA,0xB5,0x75,0x17,0x33,0xB7,0xA5,0x77,0xBE,0x0A,0x3C,0x1C,0xF7,0xB1,0x4C,0xDE,0x55,0x70,0x78,0x4A,0x33,0x5B,0xA7,0xE1,0x90,0x71,0xED,0x24,0x67,0xB1,0x26,0x67,0x16,0xE8,0x89,0x15,0x30,0x05,0x9B,0x01,0x7E,0x51,0xF0,0x80,0x00,0x9E,0x47,0x92,0x80,0x02,0x7E,0x01,0x7C};
extern const uint8_t spt_THAN[]              PROGMEM ={0xA5,0xC9,0xDE,0xDD,0x88,0x9C,0xE6,0xA6,0xB4,0x22,0xAA,0xA9,0x76,0xE2,0xD4,0x70,0x17,0xAC,0xD6,0x6E,0x72,0x7D,0xEA,0x14,0xBC,0x44,0x6D,0xE9,0xA9,0x72,0x8F,0x64,0xE9,0x24,0xB7,0xBA,0xC5,0x2D,0x6E,0x71,0xAB,0x5B,0x9D,0x36,0x77,0x2F,0xD6,0x88,0x73,0xBB,0xDB,0xED,0xBE,0x0F,0x69,0xB0,0x51,0xD2,0xDC,0x1D,0x87,0xC1,0x79,0x4C,0xD7,0x74,0xED,0x06,0xEB,0x30,0x4D,0xCB,0xAD,0x1F,0x6C,0xAF,0x3B,0xD6,0xC5,0x18,0x22,0x58,0x36,0x01,0xE5,0xC5,0x84,0x86,0xBA,0x9C,0x07};
extern const uint8_t spt_THAT[]              PROGMEM ={0x22,0x57,0x51,0x55,0x7D,0x12,0x99,0x46,0x73,0x77,0x73,0x6F,0x65,0x3A,0x2F,0x38,0x35,0xB9,0x91,0xEA,0xB5,0x73,0x21,0xCF,0x56,0xA1,0x4F,0x3E,0x5C,0xC8,0x32,0x97,0x3A,0x45,0x4B,0x35,0x7B,0x7A,0xEA,0x50,0x3D,0x24,0x6A,0xEE,0xA9,0xE3,0xF0,0x94,0xC8,0x3A,0xA7,0x4A,0x33,0x4B,0x2C,0xE2,0x9C,0x2A,0xEE,0x48,0xF1,0xB4,0x73,0xAA,0x30,0x23,0xD4,0xDA,0xF6,0xA9,0x7C,0xF1,0x30,0x2B,0x49,0xAB,0x4A,0xCE,0xCC,0xC5,0x1C,0x97,0xD6,0x18,0x63,0x93,0x4A,0x0A,0x16,0xB0,0x00,0x07,0xE0,0x01,0x00,0x00};
extern const uint8_t spt_THAT_IS_INCORRECT[] PROGMEM ={0xA5,0x2B,0x51,0x25,0xC8,0x7C,0x9F,0x2A,0x78,0xCD,0xD0,0x7A,0x7A,0x0A,0x1F,0x2D,0xDD,0x7B,0xEE,0x29,0x6C,0x48,0xCF,0xE8,0x29,0xA7,0x30,0x21,0x3D,0x63,0xCA,0x0A,0x40,0xB8,0xA8,0x15,0x67,0x6F,0xEA,0xEA,0x6B,0x4E,0x93,0x42,0x88,0xAA,0xBF,0x3D,0x6D,0x49,0x2E,0x26,0xFE,0x76,0x75,0x39,0x9A,0xA8,0xC6,0xD7,0xD1,0x97,0x6C,0x2A,0x6A,0x7B,0xDA,0x90,0xA3,0x29,0x8B,0x6D,0x6E,0x43,0x49,0xA6,0x4A,0xDC,0xAF,0xF5,0xC5,0x99,0x38,0xF3,0xE7,0xD2,0x17,0x19,0xE2,0x2C,0xBD,0x15,0x70,0x04,0xB1,0x06,0x0C,0xF0,0xB3,0x72,0x00,0x06,0x63,0x63,0x00,0x37,0xD6,0x02,0xD0,0x81,0x67,0x15,0xB9,0x98,0xAA,0xD6,0xE2,0x9B,0x9C,0x38,0x47,0xD3,0xE0,0x6E,0xB2,0xA2,0x64,0x9C,0x8A,0x62,0x76,0x89,0xA2,0x87,0xF1,0x74,0x35,0x25,0xB2,0x52,0xDC,0x27,0x6C,0xAB,0x88,0x19,0xCF,0x37,0x77,0x02,0x01,0x88,0xD9,0x3A,0x44,0xBA,0x72,0x5B,0x52,0xAA,0x1A,0xA5,0x48,0x2E,0x4E,0x4F,0xEA,0x62,0x62,0xB6,0x24,0x32,0x55,0xAB,0x89,0xF9,0xA6,0x2A,0x17,0xB7,0x25,0xD2,0x93,0x26,0xD4,0x73,0x8F,0x50,0xE7,0xF4,0x92,0x6C,0xB6,0x22,0xEF,0xCA,0x4B,0x6A,0xF2,0x8A,0x7D,0xF4,0x0A,0xFD,0x58,0xA7,0xF1,0xD1,0xB2,0x6C,0x6B,0xEF,0xBE,0x4F,0x75,0x06,0x00,0x00,0x03,0x4C,0x27,0x2A,0x80,0x61,0xD4,0x18,0x50,0xB4,0xF2,0x03,0x00,0x00};
extern const uint8_t spt_THAT_IS_RIGHT[]     PROGMEM ={0xA6,0xD1,0xC6,0x25,0x68,0x52,0x97,0xCE,0x5B,0x8A,0xE0,0xE8,0x74,0xBA,0x12,0x55,0x82,0xCC,0xF7,0xA9,0x7C,0xB4,0x74,0xEF,0xB9,0xB7,0xB8,0xC5,0x2D,0x14,0x20,0x83,0x07,0x07,0x5A,0x1D,0xB3,0x06,0x5A,0xCE,0x5B,0x4D,0x88,0xA6,0x6C,0x7E,0xA7,0xB5,0x51,0x9B,0xB1,0xE9,0xE6,0x00,0x04,0xAA,0xEC,0x01,0x0B,0x00,0xAA,0x64,0x35,0xF7,0x42,0xAF,0xB9,0x68,0xB9,0x1A,0x96,0x19,0xD0,0x65,0xE4,0x6A,0x56,0x79,0xC0,0xEA,0x93,0x39,0x5F,0x53,0xE4,0x8D,0x6F,0x76,0x8B,0x53,0x97,0x6A,0x66,0x9C,0xB5,0xFB,0xD8,0xA7,0x3A,0x87,0xB9,0x54,0x31,0xD1,0x6A,0x04,0x00,0x06,0xC8,0x36,0xC2,0x00,0x3B,0xB0,0xC0,0x03,0x00,0x00};
extern const uint8_t spt_THE[]               PROGMEM ={0xA1,0xB5,0x86,0xD3,0xD8,0x1B,0xB9,0xD6,0x1A,0x0E,0x61,0x5F,0x18,0xDA,0xE2,0x58,0xC5,0xA0,0xCF,0x2A,0x6A,0x31,0x15,0xE5,0x2D,0x27,0x6F,0x23,0x94,0x85,0xF6,0xAE,0xBC,0x25,0x21,0xAE,0xBC,0x3D,0xAB,0x59,0xF5,0x26,0x75,0xDD,0x09,0xD1,0xD5,0x4D,0x37,0x44,0x4E,0xD6,0xEF,0x61,0x7C,0x6F,0x86,0xE4,0x41,0xEB,0x4A,0xB4,0x1D,0x1E,0x00,0x00};
extern const uint8_t spt_THE1[]              PROGMEM ={0xA9,0x73,0x5E,0x93,0xC9,0x53,0xC7,0x6E,0xB4,0xC9,0x6A,0xBB,0xE9,0xD6,0x5B,0x9D,0x2A,0x3A,0xEF,0x64,0x6F,0x7A,0xAB,0x55,0x45,0xEF,0x93,0xEC,0x49,0x5B,0x6D,0x72,0xA7,0xD1,0x5A,0x49,0x4D,0x72,0x1E,0x8E,0x6A,0xE9,0x01};
extern const uint8_t spt_THEIR[]             PROGMEM ={0xA2,0x66,0x3E,0xCC,0x6D,0x62,0x8B,0x9A,0xF9,0x30,0x97,0x8D,0x2C,0x1A,0x6A,0x53,0x53,0x2A,0x09,0x6F,0x58,0x2D,0x45,0x98,0x5B,0x39,0x76,0x75,0xF2,0xE6,0x01,0xD3,0x74,0xE7,0x37,0x3F,0x79,0xAE,0xE6,0xA2,0xD3,0xE6,0xE6,0x37,0xBF,0xC5,0xA9,0xD2,0x50,0x35,0xEB,0x2E,0xA7,0x8A,0x53,0xCD,0xDC,0xBB,0xDC,0x66,0xB5,0xE1,0x52,0x86,0x46,0x93,0xD9,0xB5,0xCE,0x1F,0xCA,0x34,0x6F,0x92,0x3A,0xBF,0x71,0x5C,0xDA,0x45,0xE8,0xFC,0xC0,0x0A,0x6E,0x9B,0xA6,0x0B,0x87,0xCC,0xC8,0x53,0xA9,0x36,0x4C,0x46,0x15,0x73,0x23,0xDA,0x98,0x5C,0x85,0x3D,0x11,0x3C,0x00,0x00};
extern const uint8_t spt_THEN[]              PROGMEM ={0xA2,0xA1,0x2E,0x2C,0xAC,0x13,0x8B,0x86,0xE9,0xF0,0xD0,0x49,0x2D,0x6A,0xC1,0xD3,0xD3,0xCA,0xB1,0xA8,0x8D,0x30,0x73,0x0F,0xC7,0xA1,0xAA,0xDC,0x54,0x4C,0x53,0x9F,0x3C,0x25,0x37,0xA5,0x6E,0x7D,0xB2,0x54,0xCD,0x59,0xAE,0xCD,0xC9,0x72,0x75,0x53,0x9E,0xD6,0x27,0xCB,0x3D,0x4C,0xA8,0x1B,0x9F,0xAC,0xB4,0x30,0xA5,0x6A,0x7C,0x8A,0xDC,0xC2,0x85,0xA6,0xF1,0xA9,0x72,0x0B,0x53,0xEA,0xC4,0xA7,0x4E,0xCD,0x43,0x69,0x92,0x9C,0x26,0x55,0x4F,0xE5,0x4E,0x72,0xDA,0x90,0x3D,0x4C,0x2A,0x71,0xE9,0xBC,0x85,0x55,0x4F,0x55,0xBE,0x77,0xBD,0xB3,0xB0,0xAE,0xE5,0xDA,0xF4,0xCA,0xE0,0xBA,0xB4,0x6D,0xD5,0x0B,0x2B,0x6D,0xB2,0x91,0x42,0xAF,0x6D,0x48,0xE8,0xD8,0x74,0x7D,0xF4,0xCA,0x4A,0xE5,0x04,0x01,0x3A,0x8A,0x00,0x00,0xC9,0x93,0xF6,0x34,0x71,0xDB,0x0F};
extern const uint8_t spt_THERE[]             PROGMEM ={0xA2,0x66,0x3E,0xCC,0x6D,0x62,0x8B,0x9A,0xF9,0x30,0x97,0x8D,0x2C,0x1A,0x6A,0x53,0x53,0x2A,0x09,0x6F,0x58,0x2D,0x45,0x98,0x5B,0x39,0x76,0x75,0xF2,0xE6,0x01,0xD3,0x74,0xE7,0x37,0x3F,0x79,0xAE,0xE6,0xA2,0xD3,0xE6,0xE6,0x37,0xBF,0xC5,0xA9,0xD2,0x50,0x35,0xEB,0x2E,0xA7,0x8A,0x53,0xCD,0xDC,0xBB,0xDC,0x66,0xB5,0xE1,0x52,0x86,0x46,0x93,0xD9,0xB5,0xCE,0x1F,0xCA,0x34,0x6F,0x92,0x3A,0xBF,0x71,0x5C,0xDA,0x45,0xE8,0xFC,0xC0,0x0A,0x6E,0x9B,0xA6,0x0B,0x87,0xCC,0xC8,0x53,0xA9,0x36,0x4C,0x46,0x15,0x73,0x23,0xDA,0x98,0x5C,0x85,0x3D,0x11,0x3C,0x00,0x00};
extern const uint8_t spt_THESE[]             PROGMEM ={0xA9,0xF5,0xD6,0x4C,0x89,0xB3,0xC4,0x36,0x36,0xA5,0x4E,0xC6,0x4D,0x98,0xB2,0x8C,0x2A,0xCB,0x30,0x09,0xDB,0x34,0x52,0xEB,0x5C,0xA2,0x63,0xD4,0x4A,0x82,0x70,0xB1,0x8F,0x86,0x23,0xE9,0x21,0x10,0x2A,0x37,0xCF,0xB4,0x67,0xB5,0x28,0x55,0x8F,0x46,0x18,0xB9,0x66,0x36,0xAD,0x2B,0x49,0x91,0x32,0x17,0xF7,0xBE,0xF5,0xD5,0x1B,0x71,0xFA,0x96,0xDE,0x97,0xBE,0x38,0x67,0x0E,0xFD,0xD2,0xFA,0x69,0x2C,0x50,0x3C,0x5F,0xEB,0x7F,0x35,0x09,0x50,0x6F,0x01,0xB8,0x9A,0x38,0x00,0xBF,0x2A,0x39,0xE0,0xAF,0x14,0x03,0xFC,0xCC,0xC2,0x80,0x28,0x5C,0x1F};
extern const uint8_t spt_THEY[]              PROGMEM ={0xA6,0x11,0x51,0x4D,0xB5,0x13,0xAB,0x96,0xBB,0x60,0xB5,0x76,0xE3,0x9A,0xA8,0x55,0x59,0xDD,0x49,0xAA,0x53,0xF0,0x12,0xB5,0xA5,0xB7,0xBA,0xD5,0xA9,0x72,0xCD,0x10,0xF1,0xA5,0xB7,0xBA,0xD5,0xA9,0x4B,0x0F,0x15,0xC9,0xA5,0xB7,0x39,0x5D,0x6E,0x2E,0xEA,0x35,0xA7,0xF4,0x29,0x63,0xD8,0x6C,0xE4,0x32,0x24,0x63,0x12,0xEF,0xB5,0xD2,0x90,0xA4,0x6A,0x4E,0x84,0x0E,0x43,0x0E,0xC4,0xD5,0x19,0xC8,0x0D,0xC9,0x0A,0xE6,0x7A,0x68,0x33,0x06,0xCD,0xD2,0xE5,0x51,0x1E};
extern const uint8_t spt_THING[]             PROGMEM ={0x40,0x00,0x6D,0xDD,0x11,0xE0,0x85,0x3B,0x01,0x9C,0x34,0x16,0x40,0x70,0xA6,0x27,0x89,0xD1,0xD5,0xAD,0x16,0xDE,0xE4,0x24,0xB9,0xB8,0xA8,0xC6,0xE2,0x93,0xD6,0x9E,0x22,0xE2,0x8B,0x4F,0x56,0x67,0x89,0xB0,0xAE,0x3E,0x79,0x5B,0x29,0x2C,0xBA,0xF8,0x54,0x75,0x05,0xB1,0xF9,0xA2,0x51,0xD7,0x69,0xA0,0x1E,0xB3,0x5A,0x5D,0x1A,0x43,0x64,0x54,0x4C,0x4D,0x08,0x60,0xEB,0x6E,0x26,0x34,0xCE,0xC1,0x87,0x39,0x9D,0xD0,0x78,0x07,0x97,0x9A,0x4C,0x42,0x13,0x1C,0x5C,0x68,0x28,0x0D,0x8D,0xB5,0x70,0xA1,0x29,0x27,0x35,0x51,0x39,0x45,0x79,0xC9,0xD0,0xA5,0x60,0xA8,0x6A,0xB3,0x1F};
extern const uint8_t spt_THINGS[]            PROGMEM ={0x00,0x08,0x60,0xBA,0x93,0x01,0xDA,0x99,0x33,0x40,0x5B,0x77,0x03,0x78,0xE1,0xAE,0x00,0x27,0x8D,0x2D,0x70,0xE2,0x18,0x4D,0x8D,0x3A,0xF6,0x89,0x4B,0x76,0x76,0xE9,0x5A,0x37,0xBE,0xF1,0xCA,0xCA,0x0E,0x56,0xCE,0x46,0xB7,0xBE,0xED,0x18,0xCA,0x31,0x56,0xA9,0x9A,0x61,0x34,0x16,0x7B,0x25,0xA9,0xD8,0xC9,0x4E,0x66,0x8A,0x1E,0xA6,0xBC,0x18,0xDB,0xC9,0x4D,0xD1,0xC3,0x94,0x27,0x5C,0x37,0x55,0xA1,0x90,0xB1,0x52,0xEC,0x64,0x26,0x2D,0xD2,0x5C,0x25,0x8D,0x00,0x7E,0x0D,0x93,0x80,0x04,0x38,0xC0,0x81,0x07,0x00,0x00};
extern const uint8_t spt_THINK[]             PROGMEM ={0x08,0xB0,0xD4,0x14,0x01,0x19,0xBB,0x50,0x80,0x03,0x27,0x8E,0xDE,0xDC,0xA5,0x67,0x9F,0x28,0xDA,0x90,0xF0,0x9C,0xB9,0x92,0x3A,0x5B,0x8C,0xAC,0xF3,0xCD,0x6E,0xB5,0xDA,0xB2,0x12,0x55,0xBC,0x65,0x19,0xB5,0x25,0x9F,0x0C,0x27,0x79,0xB4,0x13,0x69,0x83,0x0A,0x35,0x2B,0xC7,0x60,0x80,0xBC,0x4D,0x1D,0x10,0xA3,0x91,0x02,0x8A,0x2F,0x50,0x40,0x89,0x41,0x08,0xB0,0x5E,0xF8,0x01};
extern const uint8_t spt_THIRD[]             PROGMEM ={0x08,0xE0,0x3C,0x9D,0x00,0x92,0x56,0x30,0x40,0x12,0x0F,0x05,0x64,0x6B,0x72,0xFC,0xE4,0x24,0x4B,0x32,0xF3,0x89,0x9D,0xF5,0x4C,0x8B,0xCE,0x23,0x76,0x5D,0x24,0xD3,0xF2,0xCC,0x64,0xA6,0xB3,0xD8,0xED,0xEE,0x46,0x1F,0xA6,0x89,0x94,0xE4,0x9F,0x7D,0x1B,0xE2,0x16,0x95,0x94,0xEE,0x79,0x14,0x23,0xF1,0x61,0x95,0x65,0x8B,0x4D,0xCC,0x84,0xA5,0x4F,0xE2,0x30,0x45,0xA5,0x9A,0x11,0x2D,0xDC,0x54,0x8A,0x06,0x73,0x67,0x44,0x80,0xB2,0x6A,0x0F};
extern const uint8_t spt_THIRTEEN[]          PROGMEM ={0x00,0x60,0x80,0xA6,0x42,0x18,0x60,0x4D,0xD8,0x8A,0x8C,0xCD,0x28,0xD3,0x46,0x27,0x31,0x21,0xBC,0x5A,0xFD,0xAE,0xD4,0xA4,0x90,0x18,0xF3,0x37,0x32,0x53,0x8D,0x63,0xCC,0x6F,0xC9,0xFC,0x56,0x16,0x0F,0xF7,0xA4,0x20,0x66,0x22,0x32,0x2D,0x01,0x10,0x40,0x0A,0xCF,0x04,0x54,0xA3,0x1C,0xFC,0x56,0x47,0x15,0x24,0xF1,0x4A,0x4A,0x72,0x21,0xCB,0xDB,0x23,0x49,0x5E,0xD8,0xBA,0x4A,0x8D,0xAC,0x19,0x65,0xAD,0x2C,0xD5,0x8A,0xE6,0x94,0xB4,0xB2,0xF4,0xA8,0x5B,0x50,0x94,0xC8,0x4A,0xAD,0x6B,0x4E,0x49,0x32,0x2B,0x97,0xBE,0x79,0x25,0xC9,0x2C,0x1D,0x86,0xEC,0x48,0x2C,0x2B,0x94,0x1B,0x83,0x21,0xF3,0x2E,0x29,0x6E,0xD4,0x46,0xAC,0xD3,0xA4,0xB8,0xD9,0x58,0x8C,0x09,0xB5,0x13,0xE6,0x94,0x21,0x4A,0x53,0x8E,0x5B,0x72,0x83,0x70,0x6F,0x25,0x76,0x81,0x07};
extern const uint8_t spt_THIRTY[]            PROGMEM ={0x20,0x80,0x62,0x5D,0x35,0xA0,0x01,0x0B,0x9C,0x38,0x8A,0xB2,0xB4,0x68,0x75,0x12,0xE7,0xDC,0xB3,0x2C,0xCF,0x4A,0x4C,0x51,0xEB,0xD4,0x5C,0x33,0x29,0x89,0x5F,0x10,0x6E,0xD9,0x09,0x57,0x10,0x80,0xE6,0x8C,0x2C,0xB0,0x8A,0x32,0x94,0xD9,0xAA,0xCD,0x68,0xEB,0x0C,0x05,0xB6,0x77,0xBE,0xD3,0x03,0x1F,0xE9,0xF8};
extern const uint8_t spt_THIS[]              PROGMEM ={0xA4,0xE6,0x32,0xB2,0x39,0x65,0xB3,0x9A,0xC9,0x8C,0x92,0x70,0x24,0x1A,0x65,0x42,0x9D,0x2A,0xA3,0x6A,0x8D,0x56,0x0B,0xC8,0x56,0xAA,0x35,0xCA,0x34,0xC8,0x7B,0xBB,0xA6,0x04,0x13,0x55,0x6D,0xD2,0xAB,0x93,0x85,0x20,0xE1,0xDE,0x63,0x77,0xBC,0x92,0xE8,0x25,0xDD,0x6A,0xD5,0x4D,0x77,0x5E,0xF3,0x5A,0x19,0xE0,0x69,0x16,0x0F,0x58,0xC0,0x03,0x1E,0xB0,0x80,0x05,0x2C,0xF0};
extern const uint8_t spt_THREE[]             PROGMEM ={0x0C,0x08,0xCA,0x44,0x02,0x1A,0xB0,0x40,0xC8,0x4D,0x15,0x73,0xCB,0xB4,0x39,0x0F,0xB9,0xE9,0x14,0xE6,0xAD,0xBE,0xE4,0x7E,0x50,0x50,0xA9,0xDF,0x91,0xE5,0x25,0x05,0x21,0x79,0x47,0x5E,0x7A,0x18,0x09,0xBD,0x5F,0x45,0xCB,0xC1,0xA8,0xF6,0x76,0x56,0xAD,0x2D,0x41,0x98,0xB3,0xEF,0xD4,0x2E,0x0C,0x5E,0x89,0xE5,0x66,0x65,0x3F,0xB8,0xC1,0x6B,0xF2,0x9A,0x0E,0x63,0x46,0xAF,0x38,0xAB,0x53,0xCC,0x03};
extern const uint8_t spt_THREW[]             PROGMEM ={0x08,0xB0,0xDC,0x18,0x01,0x41,0xBB,0x50,0x80,0x03,0x16,0x48,0x81,0x6E,0x9C,0x9A,0x92,0x25,0x67,0x35,0x6D,0x89,0x1A,0x52,0x12,0xDA,0x77,0xC4,0x3A,0x4B,0x6B,0xA9,0xAF,0x95,0xD8,0x20,0x15,0x16,0x5E,0x47,0x1A,0xB4,0x7A,0x0E,0xB6,0x9B,0xF9,0xAC,0x5B,0x9F,0x94,0xBA,0x1F,0x66,0x0F,0x83,0x91,0xDE,0xB9,0xD0,0xC6,0x4E,0x7A,0xD6,0x8B,0x5C,0x1E};
extern const uint8_t spt_THROUGH[]           PROGMEM ={0x08,0xB0,0xDC,0x18,0x01,0x41,0xBB,0x50,0x80,0x03,0x16,0x48,0x81,0x6E,0x9C,0x9A,0x92,0x25,0x67,0x35,0x6D,0x89,0x1A,0x52,0x12,0xDA,0x77,0xC4,0x3A,0x4B,0x6B,0xA9,0xAF,0x95,0xD8,0x20,0x15,0x16,0x5E,0x47,0x1A,0xB4,0x7A,0x0E,0xB6,0x9B,0xF9,0xAC,0x5B,0x9F,0x94,0xBA,0x1F,0x66,0x0F,0x83,0x91,0xDE,0xB9,0xD0,0xC6,0x4E,0x7A,0xD6,0x8B,0x5C,0x1E};
extern const uint8_t spt_TIME[]              PROGMEM ={0x00,0x1E,0x90,0x80,0x03,0x72,0x28,0x17,0x80,0x9D,0x61,0x1E,0x38,0xB1,0xAF,0x5D,0xE6,0x5E,0xE7,0x26,0x37,0xB9,0xE9,0x4D,0x4F,0x16,0x66,0x96,0x5A,0xC4,0x3B,0x55,0x5A,0x19,0x2A,0x19,0xF7,0x56,0xA7,0xC9,0x3D,0x55,0x35,0xAB,0xEC,0x76,0x76,0xA9,0xB3,0x0E,0xDB,0xC4,0x1A,0xF9,0xDE,0x74,0xDA,0xE1,0x18,0x97,0x5B,0xDB,0xE9,0xCE,0xF4,0xD2,0x71,0x07,0x65,0xD2,0x07};
extern const uint8_t spt_TO[]                PROGMEM ={0x02,0xD8,0x51,0x3C,0x00,0xC7,0x7A,0x18,0x20,0x85,0xE2,0xE5,0x16,0x61,0x45,0x65,0xD9,0x6F,0xBC,0xE3,0x99,0xB4,0x34,0x51,0x6B,0x49,0xC9,0xDE,0xAB,0x56,0x3B,0x11,0xA9,0x2E,0xD9,0x73,0xEB,0x7A,0x69,0x2A,0xCD,0xB5,0x9B,0x1A,0x58,0x2A,0x73,0xF3,0xCD,0x6A,0x90,0x62,0x8A,0xD3,0xD3,0xAA,0x41,0xF1,0x4E,0x77,0x75,0xF2};
extern const uint8_t spt_TOGETHER[]          PROGMEM ={0x09,0x68,0x22,0xD4,0x00,0x5E,0xA6,0x9E,0x3C,0x25,0x77,0x71,0xED,0x72,0xAA,0x1C,0xC3,0x28,0xB4,0x5F,0x6B,0x72,0x75,0xC6,0x94,0x6C,0xAE,0x4D,0x9D,0x50,0x53,0x57,0x8D,0x2A,0xAF,0x60,0x74,0xDD,0x7B,0xAA,0xD2,0xCB,0x59,0xB9,0xDF,0xA9,0x72,0x76,0x57,0xF3,0x2D,0xA7,0x88,0xC9,0x53,0x35,0x96,0xDC,0x62,0x14,0xCE,0x59,0x07,0xE7,0x62,0xD7,0x46,0xA7,0xEE,0x62,0x49,0x66,0xB7,0xDA,0xEC,0xCD,0xDD,0xA8,0x7B,0x19,0x7C,0xD2,0x62,0xF3,0x65,0x65,0x74,0x31,0x9C,0x32,0xEA,0x86,0x49,0x17,0xF5,0xAC,0x4C,0x66,0x56,0x53,0xD9,0xDB,0xC3,0x89,0x58,0x4D,0x30,0x4B,0x6F,0xCB,0x0F};
extern const uint8_t spt_TONE[]              PROGMEM ={0x09,0x98,0xCA,0xD2,0x01,0x4B,0x5B,0x09,0x20,0xC4,0xB2,0x13,0x06,0x53,0x9D,0x22,0x59,0x6F,0xBC,0xE2,0xA0,0x7A,0x9C,0x25,0xED,0x48,0x82,0x9C,0x35,0xD2,0xA6,0x23,0x75,0x72,0x56,0xD9,0x92,0x96,0xCC,0xCA,0x5D,0x35,0x55,0x5A,0x2A,0x23,0xB7,0x2D,0xC8,0x4D,0xAA,0x1D,0xEF,0xF1,0x40,0xD7,0xA9,0xD5,0x76,0xD2,0x8D,0x62,0x87,0x4E,0xA6,0x0E,0x57,0x8E,0x9B,0x7A,0xA7,0xB3,0x82,0xDC,0x9E,0xEA,0x75,0xD5,0x62,0x09,0x3B,0xAA,0xB7,0x81,0x53,0xB9,0xDC,0xEA,0x5E,0xF5,0x2A,0xA8,0x1B,0x77,0x62,0x31,0x48,0xE7,0x6E,0x92,0x69,0xD8,0xC0,0x75,0x7A,0x58,0xBA,0x7E,0x00,0x00};
extern const uint8_t spt_TOO[]               PROGMEM ={0x02,0xD8,0x51,0x3C,0x00,0xC7,0x7A,0x18,0x20,0x85,0xE2,0xE5,0x16,0x61,0x45,0x65,0xD9,0x6F,0xBC,0xE3,0x99,0xB4,0x34,0x51,0x6B,0x49,0xC9,0xDE,0xAB,0x56,0x3B,0x11,0xA9,0x2E,0xD9,0x73,0xEB,0x7A,0x69,0x2A,0xCD,0xB5,0x9B,0x1A,0x58,0x2A,0x73,0xF3,0xCD,0x6A,0x90,0x62,0x8A,0xD3,0xD3,0xAA,0x41,0xF1,0x4E,0x77,0x75,0xF2};
extern const uint8_t spt_TOP[]               PROGMEM ={0x00,0x10,0x80,0x64,0x43,0x03,0xD0,0x59,0xAA,0x01,0x8A,0x1A,0x1D,0x51,0x30,0xDD,0xC1,0xD6,0xE4,0xC6,0x37,0xB9,0xE9,0xCD,0x6E,0x35,0x5A,0x9B,0xA7,0x02,0xA3,0x31,0x02,0x48,0x48,0x07,0x50,0x80,0x94,0x91,0x1C,0x00,0x80,0x07,0x00,0x00};
extern const uint8_t spt_TRY[]               PROGMEM ={0x0E,0x28,0xA1,0xA2,0x02,0x0E,0x28,0x6D,0xCC,0x03,0x2D,0x56,0x23,0x34,0x9A,0xD2,0x8D,0x44,0xA7,0x71,0x6B,0xD8,0x72,0x12,0x6F,0xA6,0xAC,0xB0,0xCB,0x49,0x82,0x9D,0x4A,0x91,0x26,0x37,0xB9,0xE9,0xC9,0x93,0xED,0x0A,0xD5,0xC6,0xB7,0x3A,0x6D,0xCC,0xE1,0xE6,0x3E,0x67,0x77,0xB3,0x9F,0x7D,0x19,0x42,0x51,0x8B,0xE8,0xB0,0x65,0x88,0xC1,0xC5,0x3B,0xC2,0xA4,0x21,0x38,0xB5,0xCC,0x0A,0xEC,0x86,0x54,0x84,0xD4,0x3B,0xF4,0x03,0x00,0x00};
extern const uint8_t spt_TRY_AGAIN[]         PROGMEM ={0x0E,0x28,0xA1,0xA2,0x02,0x0E,0x28,0x6D,0x6C,0xC4,0xB6,0xAB,0xA5,0x8B,0xDB,0x15,0xEB,0xEE,0x5E,0xCE,0x6B,0x4E,0xE2,0xED,0x84,0xB9,0x26,0xBE,0xD1,0x0D,0x57,0x10,0x8B,0x9B,0xEB,0x44,0xD9,0xC1,0x0E,0x57,0x1C,0x8B,0x99,0xDB,0x46,0x39,0x69,0x8E,0xA6,0xEE,0x35,0x7B,0x64,0x35,0x26,0xF2,0x44,0xA7,0x94,0xE7,0x24,0x60,0x1B,0x15,0x55,0xCE,0x45,0x66,0x35,0x3B,0x29,0x45,0xD1,0xCC,0x6E,0xE1,0x66,0x64,0xD5,0x39,0x53,0x74,0x9B,0x13,0xE7,0xE0,0xAC,0x55,0xB3,0x4F,0x5C,0x5D,0x98,0x45,0xCC,0xBE,0xD1,0x8D,0x6E,0x72,0xF3,0x5B,0xAD,0x36,0x46,0x4F,0x95,0x8C,0x32,0xFB,0xDE,0x87,0xDE,0x66,0x35,0xD7,0x70,0xE5,0x06,0x4F,0x53,0xCC,0xBC,0x95,0x1A,0xA4,0xD5,0x08,0x19,0xC7,0x0F};
extern const uint8_t spt_TURN[]              PROGMEM ={0x0A,0xE8,0x3A,0x35,0x02,0x02,0xF0,0x39,0x84,0x00,0x22,0xB5,0x9C,0x28,0xEA,0x31,0x5E,0x57,0x77,0xA3,0x1B,0xDF,0xE4,0x66,0xAB,0x88,0x7E,0x05,0x27,0xB8,0xCF,0x6A,0x54,0xB1,0x0C,0x73,0xAB,0xF6,0x59,0xF7,0x3A,0x35,0x29,0x40,0x4B,0x58,0xE2,0xDC,0xD4,0x36,0xB5,0xD1,0x41,0x6B,0x59,0xAC,0xDC,0x3E,0x00,0x00};
extern const uint8_t spt_TWELVE[]            PROGMEM ={0x0C,0x70,0x33,0x5D,0x01,0xAE,0x64,0x84,0x80,0xD5,0x5E,0x11,0xDA,0x1A,0x93,0x95,0x9A,0x98,0x95,0xE4,0x6D,0x6F,0xBA,0xD3,0x9B,0xAE,0x5C,0xA7,0x49,0xC7,0x4A,0xB2,0x8B,0x5D,0xED,0x7A,0xD4,0x3A,0x4C,0x1B,0x59,0xE6,0x59,0xF7,0x26,0x35,0xDA,0x65,0x0B,0x4B,0x1C,0xD3,0x48,0x93,0x21,0x6A,0x6A,0x4B,0x9B,0x4D,0x98,0xA2,0xD9,0x51,0x80,0xB3,0xA9,0x0C,0x30,0x21,0x91,0x00,0xD2,0xA7,0x3E};
extern const uint8_t spt_TWENTY[]            PROGMEM ={0x0A,0x30,0x21,0xDC,0x03,0x0A,0xD0,0x51,0x1D,0x56,0xA4,0xF3,0x94,0x98,0xE5,0x39,0x69,0x0C,0x95,0xEA,0xDC,0xE4,0xA4,0x39,0x85,0x9B,0xD9,0xDC,0x93,0x96,0x1A,0xEE,0x98,0xF5,0x5A,0x61,0xBD,0xBA,0xC9,0x59,0x31,0x85,0x12,0xAE,0xE3,0x66,0x4B,0x54,0xD9,0x1B,0x67,0xB8,0xD3,0x00,0x14,0x13,0xEC,0x80,0x6C,0x93,0x4A,0x9C,0x87,0x93,0x50,0x34,0x6E,0x75,0xAA,0x10,0x32,0x17,0x25,0xF5,0x65,0xA2,0x51,0xCD,0xEC,0x30,0xC4,0x88,0x5C,0x53,0x81,0xED,0xF8};
extern const uint8_t spt_TWO[]               PROGMEM ={0x02,0xD8,0x51,0x3C,0x00,0xC7,0x7A,0x18,0x20,0x85,0xE2,0xE5,0x16,0x61,0x45,0x65,0xD9,0x6F,0xBC,0xE3,0x99,0xB4,0x34,0x51,0x6B,0x49,0xC9,0xDE,0xAB,0x56,0x3B,0x11,0xA9,0x2E,0xD9,0x73,0xEB,0x7A,0x69,0x2A,0xCD,0xB5,0x9B,0x1A,0x58,0x2A,0x73,0xF3,0xCD,0x6A,0x90,0x62,0x8A,0xD3,0xD3,0xAA,0x41,0xF1,0x4E,0x77,0x75,0xF2};
extern const uint8_t spt_TYPE[]              PROGMEM ={0x02,0xC8,0xCA,0xDC,0x03,0x06,0x48,0x36,0xBC,0xC4,0xD9,0xA4,0xA5,0x4A,0xAC,0x93,0xBA,0x52,0x19,0x5C,0x51,0x4F,0x1A,0x53,0x65,0xB2,0xCF,0x39,0x59,0xAC,0x91,0xC1,0xD5,0xE4,0x14,0x69,0x84,0xB9,0x66,0x9D,0x55,0xE5,0x69,0xAA,0xDA,0x75,0x47,0x53,0xBA,0xA8,0x59,0x55,0x0D,0x6D,0x48,0x6C,0xEE,0x71,0x19,0x00,0x10,0x40,0x72,0x05,0x02,0x64,0x8C,0x44,0x80,0x8E,0xA9,0x08,0x50,0x29,0xF4,0x01,0x00,0x00};
extern const uint8_t spt_U[]                 PROGMEM ={0xA5,0xDA,0x0D,0x98,0x23,0x6F,0xF4,0x6A,0x55,0x33,0xA9,0x82,0xC6,0xEB,0x91,0xF5,0x68,0x02,0x11,0x5B,0x67,0x36,0x32,0x2B,0xA2,0x24,0x75,0x75,0xCF,0x7B,0xD5,0x9B,0xD6,0x5A,0x61,0xE5,0x49,0xDD,0x6A,0x97,0xFB,0xD8,0xFB,0x5E,0x77,0xA2,0xB3,0x2C,0x45,0x25,0x8D,0x3C,0x00,0x00};
extern const uint8_t spt_UHOH[]              PROGMEM ={0x2B,0xB5,0x31,0x46,0x3C,0x6D,0x9D,0x38,0xB8,0x6A,0xE7,0x5C,0x7C,0x7C,0x53,0xCA,0xCD,0xD7,0xEA,0x76,0xBA,0x45,0x00,0xAD,0xAB,0x00,0x10,0x20,0x6A,0x46,0x08,0xBC,0xCB,0x31,0xB5,0x3A,0x2B,0xF7,0x3A,0x37,0x9C,0xBA,0xDD,0xE2,0x56,0xB7,0xBA,0xD5,0xAA,0x8C,0xAA,0x0B,0xC7,0xB4,0xB3,0x1A,0x95,0x56,0xFD,0x62,0x92,0xB6,0x55,0x8E,0xF5,0x9B,0x29,0xFB,0x52,0xC9,0x38,0x1E,0x46,0x4E,0x44,0xC5,0x9B,0xB7,0xB1,0xC9,0x79};
extern const uint8_t spt_UNDER[]             PROGMEM ={0xA7,0xC8,0x3A,0xAB,0x54,0x9A,0xDE,0xE2,0x16,0xA7,0x48,0x3E,0x4B,0xC9,0xE7,0x94,0xC2,0x04,0x49,0xB2,0xF4,0x1D,0x33,0x9F,0xBB,0x4A,0x7A,0x29,0xD7,0x89,0x6D,0x2A,0x66,0xC3,0xD2,0x7D,0x61,0x69,0x5B,0xB5,0x22,0x66,0x39,0xB7,0x3E,0x6D,0x4C,0xE1,0x64,0xD6,0x7E,0x74,0x2E,0xBB,0xC8,0x46,0xF2,0xDE,0xD7,0x31,0x8C,0xAE,0xB1,0x44,0x5B,0x56,0x37,0x9A,0x81,0x5E,0x1D,0x8E,0xDD,0xE8,0x87,0x92,0x46,0xBA,0x56,0x63,0x9C,0x21,0x28,0xA2,0xF6,0x01,0x00,0x00};
extern const uint8_t spt_UNDERSTAND[]        PROGMEM ={0xAB,0xF0,0xC9,0x8F,0xA3,0x1C,0x9F,0xCA,0xA7,0x2A,0xD5,0xA8,0x73,0xAB,0x53,0xA5,0xD0,0xA1,0xE4,0x4D,0x52,0xA5,0x83,0x06,0x45,0x36,0x09,0x95,0x08,0xDA,0xE6,0xED,0xD0,0x54,0xB8,0x7A,0xB4,0xA5,0xC4,0xD2,0x44,0xAD,0xCA,0x16,0x71,0x5A,0xED,0xAB,0x09,0xB7,0xA7,0x9F,0xF5,0x6C,0x46,0x13,0xA6,0x2B,0xA6,0x79,0x4B,0x40,0xE7,0xA0,0x01,0xF8,0x49,0x35,0x02,0x0E,0xF8,0xD1,0x58,0x00,0xDF,0x30,0x82,0x00,0x78,0xF1,0x5A,0xB1,0x8F,0x6E,0xE6,0x13,0xF7,0xE4,0x31,0x87,0xA9,0x4D,0xD3,0x9B,0xEF,0x62,0x56,0xB3,0x1A,0x8D,0x2F,0xE6,0xE6,0x6D,0xB9,0xF7,0xA5,0xB7,0xCD,0xD4,0xAD,0xAD,0xD4,0x3E,0xF4,0xD6,0x51,0x9B,0x95,0x66,0xDF,0x9B,0x9E,0x79,0x9B,0x92,0x92,0x9C,0x7B,0xD7,0x63,0x5F,0x99,0xE6,0x32,0xC3,0x50,0x94,0x8B,0x78,0x6C,0xB0,0xC3,0x03,0x00,0x00};
extern const uint8_t spt_UNTIL[]             PROGMEM ={0xA7,0x72,0xBE,0xDA,0x25,0xEB,0x9C,0x2A,0xB8,0x2A,0xE7,0xAA,0x7D,0xAB,0x56,0x19,0xA7,0x6E,0x6A,0xCD,0x72,0x95,0xAB,0x54,0x5B,0x8B,0x6D,0x9E,0x9A,0x6D,0x2B,0xFA,0x60,0x4D,0x43,0xD4,0x71,0x02,0xAA,0x4A,0x49,0xC0,0x92,0x29,0x02,0x90,0x3E,0x72,0x25,0xC9,0xB9,0x98,0xFB,0x93,0x9B,0xDC,0x74,0x65,0x31,0x86,0xA9,0xD9,0x93,0x95,0x7B,0xEF,0xE5,0xEA,0x6B,0x56,0x65,0x5D,0x8C,0x6B,0x74,0x4A,0x35,0x9F,0x3D,0x42,0x9D,0x2A,0x37,0xB1,0x0D,0x2D,0xDF,0xDD,0x2C,0x99,0xDA,0xB5,0xEC,0x74,0x18,0x96,0x63,0xD5,0xD2,0x3B,0x6C,0x92,0xB1,0x55,0x4B,0xDB,0xA6,0x41,0x39,0x79,0x00,0x00};
extern const uint8_t spt_UP[]                PROGMEM ={0x2B,0xB1,0x29,0x47,0xBC,0x1A,0xDF,0x6C,0x65,0xA6,0xD4,0x88,0x4E,0xE3,0x5D,0xB4,0x4A,0xE5,0x5A,0x97,0x6C,0xED,0x2B,0x00,0x60,0x40,0x4C,0xAE,0x08,0x50,0xCE,0x0D,0x03,0x0F,0x00,0x00};
extern const uint8_t spt_UPPER[]             PROGMEM ={0x27,0xCF,0x2E,0xD6,0x55,0xF2,0x9C,0xCC,0x85,0x1A,0xF6,0x4C,0xD5,0x32,0x55,0x73,0xA8,0xCA,0x36,0x00,0x01,0x48,0x6C,0x77,0x40,0x4C,0x6E,0x29,0xB3,0x8B,0xCA,0x5D,0xD6,0xF6,0xAA,0xD5,0x76,0x63,0xA4,0xC9,0xE2,0xDA,0xA6,0xCE,0x2E,0xD2,0x4A,0x5E,0x1C,0x7A,0x33,0xB1,0x5A,0xBD,0xA6,0x1B,0xDC,0x60,0xA9,0x90,0x94,0x0F,0x00,0x00};
extern const uint8_t spt_USE[]               PROGMEM ={0xAD,0x3A,0x3D,0x03,0x80,0xB7,0xAD,0xA2,0xB7,0x49,0x60,0xCE,0x7F,0x8A,0x9E,0xD2,0xC0,0xB8,0xFF,0x2D,0x4E,0x51,0xAD,0x29,0x27,0xEF,0x9B,0xC5,0xAC,0x5A,0x55,0x99,0xB4,0xA6,0xF4,0xEB,0xD5,0xAC,0x66,0xDD,0x9B,0xD2,0x38,0xE1,0xA1,0x2E,0x8F,0x6B,0x43,0x00,0xA4,0x3F,0x04,0xB0,0x0D,0x82,0x00,0x7E,0x53,0x60,0xC0,0xF7,0x2C,0x0C,0x38,0x16,0xED,0x01,0x00,0x00};
extern const uint8_t spt_V[]                 PROGMEM ={0xA5,0x4A,0x3E,0x44,0x58,0x9D,0xAD,0xAA,0xA4,0x10,0x56,0x69,0x7A,0x8B,0x5B,0x9C,0xA2,0x95,0x20,0xD4,0x78,0xBA,0x8A,0x96,0x9C,0xC8,0xF3,0xE9,0xA8,0x5A,0x76,0xC4,0xA8,0xA7,0xA3,0x6A,0xD1,0x11,0x33,0xEF,0xB4,0xBA,0x07,0x23,0xAA,0xBA,0xDD,0x9A,0x16,0x14,0x29,0xEB,0x4E,0x68,0x6A,0x14,0x94,0xAA,0x29,0x0F,0x00,0x00};
extern const uint8_t spt_VARY[]              PROGMEM ={0xA6,0xD5,0xDA,0x4C,0x39,0xB2,0xA6,0x2E,0xB8,0x08,0x15,0xDB,0x7C,0xAB,0x53,0xD8,0x14,0xEE,0x3E,0x8D,0x6F,0x7E,0xD3,0x9B,0x9E,0x2C,0xA4,0xD4,0x70,0x5B,0xBD,0x2A,0xD7,0x5D,0xC3,0x6D,0xCD,0x6D,0x5A,0x6B,0x16,0x57,0x98,0xB4,0xE9,0xDD,0xE8,0xFD,0x56,0xD7,0xE4,0xEE,0x6D,0x48,0x9D,0x52,0x22,0xDA,0x96,0x29,0x36,0x61,0xAB,0x78,0x93,0xC6,0xA4,0x8D,0xB5,0x6A,0x4E,0x1C,0xDD,0x94,0xBC,0x81,0x76,0x57,0xD6,0x93,0x9E,0xF4,0xF8};
extern const uint8_t spt_VERY[]              PROGMEM ={0xAE,0x31,0xC6,0x8D,0x4C,0x36,0x95,0x26,0x3B,0x57,0x75,0xDF,0x7A,0xF3,0x9B,0xDF,0xFC,0x64,0xC9,0xBB,0xAA,0x67,0xD7,0x93,0xA7,0x14,0x2A,0x61,0xF9,0x4E,0xE1,0x87,0xB3,0x07,0xE7,0xDB,0xD5,0xAE,0x57,0xEB,0x67,0x88,0x06,0x67,0x5F,0x5D,0xE8,0x2E,0x1A,0xD2,0x7D,0x0E,0x65,0x88,0x49,0x45,0xC7,0x5F,0x97,0x31,0x79,0x65,0x8B,0x5C,0x95,0xA7,0x3C,0x3D,0x00,0x00};
extern const uint8_t spt_W[]                 PROGMEM ={0xAC,0xC1,0xAA,0xA2,0xB2,0x1C,0x0F,0x67,0x98,0x08,0x56,0x4F,0x77,0x0A,0x5B,0xD5,0xA3,0xBA,0xD5,0xC8,0x74,0xB7,0xF4,0xDA,0x58,0x23,0x55,0x2D,0xD3,0xAC,0x67,0xC6,0xD4,0xE4,0xC2,0x7F,0xA8,0x7A,0xCB,0x5E,0x8C,0x4A,0xA9,0x6D,0x73,0xE9,0x35,0x2A,0xAB,0x33,0x2D,0xF0,0xCF,0x6A,0xAA,0xF1,0xE4,0x20,0xFF,0xAD,0x9D,0x9E,0x1C,0xB5,0x5B,0xF7,0x2E,0xF5,0xC5,0xAB,0x42,0xFB,0xEB,0xDE,0xB7,0x3E,0x15,0x61,0x29,0xDB,0x53,0x86,0x98,0x54,0xE4,0xE4,0x4B,0x19,0xAC,0x75,0xD7,0x95,0xCF,0x61,0xD0,0xD6,0xDD,0x47,0x76,0xBB,0x51,0x86,0xD4,0x32,0xDB,0x6D,0x46,0xA5,0xDB,0x3A,0xD4,0xAF,0x19,0x9D,0x71,0x99,0x54,0x37,0xAA,0xF5,0x5A,0xA5,0x5C,0x94,0x3C};
extern const uint8_t spt_WAIT[]              PROGMEM ={0xA6,0x61,0xB6,0x5E,0x14,0xDD,0xB8,0x9A,0xF9,0x7E,0x16,0xF2,0xE3,0x2A,0x56,0x7B,0x45,0x68,0x6B,0x2B,0x94,0x8F,0x0D,0xE3,0x2D,0x27,0x8F,0xD1,0xDC,0x43,0xB6,0x9C,0x22,0x66,0x35,0xF3,0x9C,0x73,0xAA,0x1C,0x94,0xB5,0x72,0xF6,0xAC,0x7B,0xEB,0x7A,0x6B,0x38,0xB2,0x3A,0x8C,0xEE,0x01,0x00,0x1C,0x50,0x99,0x87,0x02,0x9A,0x2A,0x79,0x00,0x00};
extern const uint8_t spt_WANT[]              PROGMEM ={0xA1,0x56,0x3C,0xDE,0x99,0x2D,0xBB,0x9A,0xDB,0x7D,0x47,0x4A,0xDC,0x6A,0x11,0xFE,0x0D,0xA4,0xED,0xA8,0x8C,0xFE,0x55,0xD2,0x66,0xBB,0x3A,0x55,0x54,0x33,0xC1,0xD2,0xE6,0xD6,0xB7,0x59,0xAD,0x8B,0x93,0xC6,0x5E,0xA7,0x77,0xA9,0xB3,0x25,0x34,0xA4,0xA2,0xA4,0xCE,0xAB,0x30,0x33,0x75,0x1A,0x7B,0x00,0x07,0x78,0xE5,0x24,0x01,0x78,0x00,0x00};
extern const uint8_t spt_WANTS[]             PROGMEM ={0xAA,0xC2,0xB1,0x5F,0xD1,0xE5,0xA6,0x9A,0xFB,0x7A,0x07,0x49,0xD7,0x2A,0xE9,0xEB,0x0D,0x34,0xEF,0xA8,0x8C,0xC9,0x77,0xF0,0xB6,0xAD,0x30,0xBE,0x5F,0xB0,0x1A,0xCD,0x7C,0x14,0x66,0x8D,0x48,0xA4,0xD9,0x5E,0xF5,0x26,0xB5,0x66,0xB4,0xB2,0x95,0xD9,0xD0,0xDA,0xAB,0xA6,0x9E,0x8A,0x4D,0xA7,0x62,0x71,0x70,0xDB,0x62,0xB9,0xB3,0xAA,0x41,0x9E,0x14,0x80,0x00,0x41,0xB8,0x0A,0x60,0xB2,0x0C,0x01,0xFC,0x6E,0xCE,0x80,0x3F,0x4C,0x08,0xF0,0x8D,0x2A,0x02,0x3E,0x17,0x7F,0x00,0x00};
extern const uint8_t spt_WAY[]               PROGMEM ={0xAA,0xC1,0x69,0x2A,0xD4,0x98,0xB8,0x9A,0xB9,0x7E,0x55,0x56,0x52,0x6A,0x69,0xEA,0x85,0x31,0xEB,0xAA,0xB4,0xCE,0x37,0x92,0xBC,0xA7,0xB2,0x2E,0x47,0x54,0xB7,0x9C,0x22,0x67,0x73,0xD3,0x58,0x7A,0xF3,0x53,0x94,0xEC,0x6C,0x5E,0x8B,0x6F,0x75,0xAB,0x5B,0xDF,0xE6,0x74,0x2D,0x3A,0x49,0xE4,0xE2,0xDD,0x8D,0xBE,0xE7,0x20,0xF2,0x7A,0xD5,0xFA,0x5A,0x84,0x34,0x66,0x52,0xEA,0x4B,0x64,0x8C,0x9C,0xC2,0xAE,0xF7,0x5C,0x75,0xC6,0x83,0xA8,0x5E,0x73,0xB7,0x6B,0x15,0xAB,0x7A,0xA3,0x38,0xCE,0xDC,0xAA,0xE8,0x8C,0x34,0x6A,0x33,0xA7,0x0F};
extern const uint8_t spt_WE[]                PROGMEM ={0xAC,0xC5,0x63,0x23,0x90,0x9D,0xC8,0x36,0xB5,0xD2,0x77,0x89,0x50,0x9F,0x55,0xA7,0xC0,0x9C,0x5D,0x33,0x77,0x3D,0xEA,0xE6,0x8D,0x61,0x7A,0xF2,0xAC,0x67,0x35,0xAB,0x59,0x8F,0xA6,0x55,0x63,0xB0,0xBA,0x93,0x1B,0xDD,0xC8,0xC6,0xB4,0xC9,0x81,0x75,0x95,0x99,0x07};
extern const uint8_t spt_WEIGH[]             PROGMEM ={0xAA,0xC1,0x69,0x2A,0xD4,0x98,0xB8,0x9A,0xB9,0x7E,0x55,0x56,0x52,0x6A,0x69,0xEA,0x85,0x31,0xEB,0xAA,0xB4,0xCE,0x37,0x92,0xBC,0xA7,0xB2,0x2E,0x47,0x54,0xB7,0x9C,0x22,0x67,0x73,0xD3,0x58,0x7A,0xF3,0x53,0x94,0xEC,0x6C,0x5E,0x8B,0x6F,0x75,0xAB,0x5B,0xDF,0xE6,0x74,0x2D,0x3A,0x49,0xE4,0xE2,0xDD,0x8D,0xBE,0xE7,0x20,0xF2,0x7A,0xD5,0xFA,0x5A,0x84,0x34,0x66,0x52,0xEA,0x4B,0x64,0x8C,0x9C,0xC2,0xAE,0xF7,0x5C,0x75,0xC6,0x83,0xA8,0x5E,0x73,0xB7,0x6B,0x15,0xAB,0x7A,0xA3,0x38,0xCE,0xDC,0xAA,0xE8,0x8C,0x34,0x6A,0x33,0xA7,0x0F};
extern const uint8_t spt_WEIGHT[]            PROGMEM ={0xA6,0x61,0xB6,0x5E,0x14,0xDD,0xB8,0x9A,0xF9,0x7E,0x16,0xF2,0xE3,0x2A,0x56,0x7B,0x45,0x68,0x6B,0x2B,0x94,0x8F,0x0D,0xE3,0x2D,0x27,0x8F,0xD1,0xDC,0x43,0xB6,0x9C,0x22,0x66,0x35,0xF3,0x9C,0x73,0xAA,0x1C,0x94,0xB5,0x72,0xF6,0xAC,0x7B,0xEB,0x7A,0x6B,0x38,0xB2,0x3A,0x8C,0xEE,0x01,0x00,0x1C,0x50,0x99,0x87,0x02,0x9A,0x2A,0x79,0x00,0x00};
extern const uint8_t spt_WELL[]              PROGMEM ={0x80,0x12,0xD4,0x26,0x55,0x4D,0x89,0xAE,0x42,0x45,0x5B,0x0F,0xB2,0x67,0x6E,0xB9,0x48,0xF5,0x2A,0xDA,0xE7,0x64,0xC6,0x7B,0xB7,0x46,0xEB,0x9B,0xDD,0xF4,0x66,0xB7,0x58,0x95,0x4E,0xB9,0x2E,0x13,0xA7,0x35,0x72,0x4E,0xBA,0x46,0x95,0xDE,0xF6,0x2E,0x75,0xFC,0x4E,0xB2,0x69,0xAA,0xD8,0x9B,0x9E,0xDD,0x0E,0xF4,0x74,0x65,0x7A,0x76,0x5B,0x54,0xCA,0xF1,0x03};
extern const uint8_t spt_WERE[]              PROGMEM ={0xA2,0xC6,0x61,0x3A,0xD4,0x18,0xBB,0x9A,0xF9,0x7E,0x65,0x74,0x9A,0x6A,0x61,0xEB,0x43,0x21,0xFD,0xAA,0xAD,0xCA,0x8E,0x00,0xE7,0xAB,0xB6,0xCE,0xA3,0x86,0x9D,0xAF,0x5A,0xE5,0x88,0x48,0xCA,0xBE,0x2A,0x93,0x93,0xA3,0xC4,0xFF,0xAC,0x46,0xE5,0x72,0x93,0xAC,0x6B,0x9F,0x55,0xAF,0x7A,0xD5,0x2A,0xD7,0x9A,0x64,0x5C,0xFB,0xA8,0xFD,0x68,0x96,0x12,0xED,0xA5,0xF1,0x23,0x48,0x9B,0x3D,0xBB,0xD6,0xBB,0x20,0x0A,0x53,0xA3,0xBA,0x10,0x92,0x89,0x53,0x95,0x68,0xA3,0x0E,0x53,0x0B,0xC7,0x0F,0x00,0x00};
extern const uint8_t spt_WHAT[]              PROGMEM ={0x26,0xA4,0xE3,0x93,0x54,0x93,0xA4,0x44,0xD9,0x3F,0x11,0x4D,0xDB,0x12,0xED,0x7E,0x4C,0xB4,0xEE,0x48,0x4D,0xDC,0x32,0xC9,0x24,0x3B,0x1B,0x85,0x2F,0xE3,0x2E,0xD1,0xE4,0x56,0xB5,0xD5,0x3D,0x28,0xC0,0xB3,0x0A,0x0B,0x50,0xE0,0x01};
extern const uint8_t spt_WHAT_WAS_THAT[]     PROGMEM ={0x00,0xA9,0x62,0xAD,0x1F,0x38,0x3A,0x9F,0x4A,0x87,0x7C,0x12,0x6D,0x73,0x2A,0xE7,0xE3,0x4D,0x3D,0xF5,0x29,0x6C,0xCF,0x64,0xAF,0xC4,0x37,0x6F,0x55,0xD0,0x69,0x92,0xEA,0x24,0x00,0x59,0x85,0x1B,0x20,0x84,0x34,0x06,0xF8,0xEC,0x82,0x00,0xED,0xCC,0x52,0xC1,0x6A,0x46,0x6A,0x26,0x3E,0x75,0x54,0x99,0x62,0xD2,0x7D,0x34,0x45,0x44,0xB1,0x72,0x7E,0x07,0x68,0x5C,0xE3,0x00,0x0F,0x6C,0x0D,0x50,0x00,0x19,0x01,0x34,0x71,0x76,0x45,0x8B,0x13,0x66,0x22,0x77,0x54,0xDE,0xBB,0xAB,0xF2,0xEA,0x53,0xF9,0x10,0x61,0x6A,0x6F,0x4E,0xE5,0x9A,0x87,0xC6,0x4C,0x39,0x45,0x8C,0x65,0x66,0xFE,0x78,0x65,0x3E,0xA7,0x7A,0x44,0xE9,0x95,0x85,0x5C,0xEA,0x1E,0x95,0x47,0x11,0x4B,0x99,0x69,0x4C,0x01,0x07,0x0C,0x13,0xA1,0x81,0x07,0x00,0x00};
extern const uint8_t spt_WHEN[]              PROGMEM ={0x25,0x95,0xE1,0x9A,0xCC,0x56,0x8D,0xC4,0xA5,0x0E,0x15,0xBD,0xB3,0x92,0xD8,0xDC,0x55,0xBB,0xEA,0x4E,0x76,0x7A,0xF3,0x5B,0xDD,0x66,0x75,0xA9,0x65,0x09,0x7B,0xEB,0xD0,0x9B,0xA8,0xC6,0xD4,0xA9,0xE2,0x10,0x07,0x3F,0x98,0xC1,0x59,0x6C,0xB1,0x76,0x6D,0x47,0x3B,0x3E,0x00,0x00};
extern const uint8_t spt_WHERE[]             PROGMEM ={0x00,0x29,0x63,0xB5,0x57,0x58,0xD3,0x8E,0x4C,0xC7,0x6C,0x55,0xEB,0xBB,0xB2,0x98,0x5D,0xD5,0x75,0xCF,0xCD,0x77,0xB1,0xAB,0x5B,0x9F,0x26,0x96,0x64,0x2D,0xCB,0xB7,0xBB,0xD1,0x87,0xE1,0xE2,0x25,0x7D,0x67,0xDF,0x06,0xDF,0x55,0xA2,0xB5,0x4B,0x1A,0xFC,0xA4,0xA8,0xD0,0x45,0x6E,0x08,0x17,0x33,0x24,0x67,0xBA,0x21,0x6C,0x15,0xD5,0x70,0xAC,0x86,0xB8,0xC4,0x04,0xC5,0xE9,0x03};
extern const uint8_t spt_WHICH[]             PROGMEM ={0x0C,0x50,0xC9,0x53,0x01,0x26,0xBB,0x6B,0x20,0x45,0x3C,0x74,0x89,0x71,0x9A,0x1A,0xAD,0x38,0x78,0x57,0xEB,0x58,0xBA,0x93,0x9B,0x8F,0x2A,0x26,0x27,0xCF,0x98,0x2D,0x2B,0x00,0x30,0xC0,0xDD,0xED,0x1A,0xD0,0x80,0x06,0x24,0x20,0x81,0x07,0x00,0x00};
extern const uint8_t spt_WHITE[]             PROGMEM ={0x08,0x30,0xD5,0x0D,0x4A,0x2A,0xD2,0xBC,0x12,0xA7,0x1A,0xA9,0xF6,0xF9,0xCE,0xDC,0x66,0xA5,0x36,0xD5,0x0B,0x47,0xDB,0x93,0xBA,0x5A,0x6B,0xE2,0x4D,0x4F,0x1A,0x7A,0xB6,0x4B,0x34,0x39,0x59,0x1A,0x99,0x26,0xDA,0xF4,0x14,0x75,0x84,0xA9,0x79,0xDA,0x5B,0xA7,0x36,0x05,0x96,0x88,0x2A,0x0B,0x00,0x40,0x00,0x56,0x5B,0x1C,0xD0,0x74,0x19,0x03,0xB8,0x4F,0x7B};
extern const uint8_t spt_WHO[]               PROGMEM ={0x00,0x08,0x50,0x31,0x15,0x01,0x5A,0x35,0x1B,0x40,0xD9,0x96,0x92,0xF0,0x18,0x19,0xE2,0x89,0x56,0xE4,0x64,0xA4,0xBB,0xE6,0x19,0x91,0x11,0x59,0x11,0x9A,0xBB,0xC5,0x46,0x64,0x6B,0xF0,0x96,0x9E,0x94,0xCC,0x13,0x1F,0x2B,0xCA,0x5E,0xAB,0xDA,0xD4,0x36,0x74,0x86,0x57,0x89,0x63,0x7F,0xD7,0x0B,0x3D,0x29,0xCE,0x6B,0xD4,0x40,0xCA,0xB8,0x9A,0x37,0x56,0xA3,0xD4,0xE5,0xA6,0x6A,0xE7,0x01};
extern const uint8_t spt_WHY[]               PROGMEM ={0x0C,0x10,0x21,0x82,0x01,0xD2,0x77,0x26,0x3C,0x6B,0xAA,0x13,0xB1,0x72,0x72,0xE3,0xF2,0x1D,0xA5,0xCD,0xC9,0x9C,0xCD,0x77,0x92,0x35,0x27,0x77,0xBE,0x4F,0x29,0x9A,0xEC,0xE2,0x56,0xB7,0x3A,0xB5,0x8F,0x5D,0x66,0x96,0xF4,0x76,0xA7,0x8B,0xD9,0xCB,0xCD,0x9A,0xDC,0x7E,0xF5,0xA9,0xBA,0x99,0xE7,0x94,0xD9,0x8F,0x21,0x15,0x53,0xAD,0xAC,0xD2,0x86,0x14,0xD9,0xDD,0x27,0x48,0x1A,0xB2,0x67,0x8D,0xCA,0x40,0x6E,0x28,0x8D,0xC8,0xAC,0xCA,0x02,0x00,0x90,0x2E,0x98,0x74,0xB7,0x74,0xF3};
extern const uint8_t spt_WILL[]              PROGMEM ={0x2C,0xC5,0xA1,0x2B,0x3D,0x64,0x89,0x06,0x95,0xE9,0x10,0xA3,0x65,0x2A,0xE6,0xE6,0x99,0x31,0x69,0xA9,0x85,0xA9,0x37,0xC1,0xAE,0xAB,0x32,0x36,0x9B,0x4D,0xF7,0x9D,0xCA,0x59,0xF7,0x94,0x9A,0x7D,0x8B,0x5B,0xAC,0xCA,0x9A,0x4E,0x97,0xB8,0xBD,0xAB,0x5D,0x8F,0xC6,0xD8,0x5A,0x87,0x6C,0x3A,0xDB,0xDE,0x96,0x56,0xC4,0x59,0xA3,0x70,0xE2,0x5A,0x76,0xBB,0x18,0xCB,0x9E,0xEB,0xD8,0xE9,0x44,0x0D,0xC7,0xA6,0x63,0xB3,0x8B,0x38,0x1D,0xAB,0x8E,0xDB,0x29,0x17,0xA7,0xFD};
extern const uint8_t spt_WITH[]              PROGMEM ={0xA6,0x65,0xAE,0xCF,0x14,0x6C,0xDB,0x36,0x36,0xA5,0x32,0x3C,0xDE,0x0D,0x94,0xAF,0xCA,0x8A,0x1C,0x11,0x4B,0xBF,0x72,0x63,0x3C,0xA3,0xAC,0xCB,0xCA,0x9D,0xB1,0x88,0x8B,0x99,0xB3,0x98,0xD5,0x6C,0x72,0x8B,0x00,0xAE,0x5D,0x08,0xE0,0x8D,0x0B,0x01,0x82,0x72,0x25,0x40,0x54,0x6E,0x04,0x88,0xDA,0x8D,0x01,0xD6,0xBA,0x3D,0x00,0x00};
extern const uint8_t spt_WON[]               PROGMEM ={0xA6,0xA5,0x36,0xDF,0x89,0xEC,0xA5,0x86,0xDB,0xF9,0x42,0x56,0x9A,0x2A,0xE1,0xFB,0x0B,0x38,0x7D,0x6F,0x46,0x63,0x7C,0x9D,0x62,0x25,0x9E,0xCD,0x28,0x5C,0xAC,0x32,0xEA,0x38,0xBB,0x1A,0x4D,0x88,0x56,0x2A,0x53,0x67,0x76,0x79,0x70,0x83,0xF3,0x94,0x6C,0xE9,0xD6,0x0C,0xCE,0x61,0x8A,0xB4,0x3B,0x36,0xCA,0x20,0x1A,0xDC,0xAD,0xCD,0x28,0x8D,0x78,0x7B,0x5B,0x26,0x93,0x10,0x6A,0x95,0x9E,0xDA,0x4C,0x25,0x85,0x9A,0x5A,0x9A,0x07};
extern const uint8_t spt_WORD[]              PROGMEM ={0xA1,0x61,0x76,0xDF,0x80,0xE3,0xA7,0x8A,0xDE,0x74,0xB2,0xC8,0x5D,0x2A,0x7E,0xC5,0xDC,0xB2,0x67,0x29,0xF8,0x72,0xC9,0x90,0x4E,0xA5,0x90,0x35,0x25,0x87,0xB3,0xD4,0xA2,0x56,0xAD,0xB2,0x25,0x30,0x96,0xF3,0xF4,0x66,0x34,0x21,0x37,0x71,0x9B,0xFE,0xD9,0xAE,0x36,0xC6,0x66,0x4A,0xD7,0xBF,0xDA,0x14,0x5A,0xD0,0xCB,0x7D,0x69,0xE3,0x0C,0xC6,0xB0,0xE4,0xAA,0xA5,0x51,0xB5,0x63,0x64,0xEB,0x4E,0x74,0x24,0xB8,0x46,0xB7,0x2D,0xDD,0xEB,0x9E,0xF7,0x00,0x00,0xA4,0x49,0x26,0x2D,0x4C,0xEC,0x3C};
extern const uint8_t spt_WORDS[]             PROGMEM ={0xAA,0xC0,0x71,0xAA,0xD4,0xE4,0xB8,0x9A,0xFB,0x7D,0x45,0x4A,0x5E,0x2A,0x96,0xBB,0xCD,0xD8,0xFD,0xA8,0x64,0xF7,0x30,0x27,0xFF,0xA3,0x90,0x39,0x2C,0x5B,0xF4,0xB7,0x42,0x95,0x62,0x6F,0xD1,0x5F,0x2A,0xD9,0x9C,0x2E,0xA8,0x55,0xAE,0x52,0x2D,0x4B,0xD0,0x36,0xA5,0x2E,0x8D,0xED,0x8E,0xBE,0xE2,0xB7,0x36,0xAD,0xF5,0x3D,0x51,0xC6,0xF4,0xB7,0x36,0xF4,0x60,0xAA,0xD0,0x6E,0x3A,0x94,0xDC,0x32,0xCB,0x96,0x6C,0x65,0x2B,0x5A,0x1C,0x43,0xA3,0xDA,0xB6,0xEA,0xB9,0x48,0x0F,0x2F,0x27,0x02,0x78,0x41,0x4D,0x03,0x16,0xD0,0x80,0x05,0x14,0x70,0xA5,0xE8,0x03};
extern const uint8_t spt_WORK[]              PROGMEM ={0xAA,0xC1,0x65,0xC7,0x59,0x6D,0x85,0x56,0xE8,0x7A,0x53,0x50,0x53,0x5A,0x65,0xEA,0x5D,0x41,0xF9,0xAA,0x8D,0xC9,0x89,0x64,0xE9,0xA7,0x72,0xAA,0xD2,0x5B,0xA5,0x9F,0xCA,0xB8,0x4A,0x29,0xE3,0x3E,0x2A,0xD3,0x92,0xA2,0x45,0xFF,0xAC,0x5A,0x65,0x4B,0xA3,0x8E,0xF3,0x2F,0x95,0x1B,0x89,0x3A,0xAA,0xB7,0x54,0xC9,0xA6,0x3B,0x9B,0x12,0x80,0x00,0xD8,0x68,0xEC,0x81,0x07};
extern const uint8_t spt_WORKING[]           PROGMEM ={0xAA,0x25,0xA9,0xDB,0x54,0x14,0xA7,0x4E,0xBA,0xDA,0x30,0x70,0x3E,0x6A,0x99,0xAA,0xCD,0xC8,0xFD,0xA9,0x74,0x28,0xF7,0x62,0xE5,0xA7,0xB2,0x76,0x42,0x5A,0x95,0x9F,0xCA,0xA4,0x11,0x6D,0xE3,0xBE,0x0A,0x97,0x8B,0x74,0x54,0x7F,0x2D,0x04,0x60,0x85,0xB8,0x04,0x24,0x10,0x00,0xCB,0xCC,0x57,0x35,0x63,0x18,0x9A,0xAD,0xBE,0xCD,0x6E,0x5B,0xD7,0x9C,0x31,0x67,0x44,0x2A,0x7D,0xB0,0x2C,0x95,0x6E,0xC5,0xF4,0xDC,0x86,0x8F,0xBA,0x29,0xD3,0x73,0x6B,0x31,0x1C,0xB6,0x54,0xCF,0x8D,0xD5,0x72,0xDA,0x16,0xBD,0x34,0x9A,0xC7,0x61,0x4B,0xF4,0xD6,0x40,0xB6,0xA4,0x63,0xD6,0x79,0x43,0x1A,0x6C,0xB6,0x45,0x9F,0xB3,0xAA,0xA3,0xD8,0x81,0x07,0x00,0x00};
extern const uint8_t spt_WRITE[]             PROGMEM ={0xA2,0x65,0x21,0xDD,0x39,0x1C,0x8B,0x9A,0x8E,0x90,0xB0,0x74,0xAC,0x6A,0x3A,0x5C,0xA2,0x43,0x89,0x69,0xF8,0x52,0x8E,0x31,0x27,0xA9,0xD1,0x07,0xB3,0x54,0xDC,0xAF,0xDA,0xC4,0x1A,0x67,0x9D,0x77,0xEB,0x53,0x85,0x9C,0xE9,0xDC,0x71,0x6E,0x75,0xAA,0x58,0x33,0x4D,0x3A,0xEE,0xA9,0xD3,0xF0,0x64,0xCF,0xBA,0xA7,0xC9,0x45,0xC4,0xA2,0x2A,0xCD,0x2E,0xF5,0x29,0xB3,0x44,0x57,0x61,0x33,0x18,0x69,0x92,0xE9,0x16,0x00,0x40,0x01,0x5D,0x79,0x3C};
extern const uint8_t spt_X[]                 PROGMEM ={0xA5,0x28,0xB1,0x4C,0x2C,0xDE,0xDC,0xEA,0xD4,0xA9,0x84,0x99,0xF6,0x9C,0x5B,0xDF,0x7A,0x36,0xB1,0x05,0x00,0x00,0x30,0xC0,0x4B,0x6E,0x0A,0xF8,0x55,0x5D,0x02,0x1C,0xE0,0x00,0x06,0x30,0xF0};
extern const uint8_t spt_Y[]                 PROGMEM ={0xA2,0xC3,0xBE,0x5F,0xC1,0xEC,0xBA,0x86,0xBB,0x7C,0x13,0x72,0x53,0x1A,0x11,0xFB,0x59,0x38,0xCF,0xAA,0x75,0xDD,0x52,0x89,0xA6,0xBB,0xDE,0xF5,0xA9,0x83,0x99,0x35,0xF5,0x2A,0xB7,0x5E,0xB5,0x0F,0x53,0x66,0x51,0x65,0xD5,0x31,0x6C,0x68,0x6A,0xAD,0x5D,0x8D,0x2A,0x54,0x35,0xAD,0xB6,0xDD,0xAB,0x5C,0xA5,0x2A,0x45,0x51,0xF6,0x8A,0x64,0x2B,0x5D,0x3D,0x00,0x00};
extern const uint8_t spt_YELLOW[]            PROGMEM ={0xAE,0xDB,0x09,0x44,0xBC,0x2F,0xC5,0x2E,0x75,0xD3,0x83,0x8A,0xCF,0xA5,0xD2,0x0C,0x2D,0x4A,0xBE,0x8F,0x4F,0x55,0xAD,0x2B,0x47,0xAF,0x39,0x45,0xF4,0x16,0x1E,0xB9,0xF8,0x14,0xC1,0x7B,0xBB,0x79,0xEB,0x51,0x78,0xE7,0x93,0x1C,0x4D,0x4A,0x15,0xAC,0x6F,0x09,0xB7,0xEB,0xCD,0x6E,0x5A,0xA7,0x72,0xBE,0xAA,0xB4,0xA9,0x7D,0xE8,0x65,0x9E,0x63,0x93,0x36,0x66,0xE0,0xA3,0x4B,0x8C,0x5B,0xA9,0x81,0x97,0x2D,0x31,0xD5,0xA4,0x06,0x1B,0x24,0xC7,0x9C,0xB6,0xE8,0x7D,0x14,0x76,0xF6,0x34,0x0F,0x00,0x00};
extern const uint8_t spt_YES[]               PROGMEM ={0xAA,0x9A,0x0E,0x54,0x6A,0x26,0xC7,0xA6,0xB6,0xAB,0x9D,0xD5,0x0D,0xD8,0xDE,0x9E,0xA6,0x44,0x57,0x8D,0x78,0x73,0xDB,0xD3,0x96,0xEC,0xAE,0xE6,0x4B,0x57,0x1B,0x9B,0x27,0xEB,0xDA,0x9D,0x75,0xAB,0xC2,0x88,0x44,0x6B,0x3B,0xA1,0xB2,0xD1,0x55,0xAC,0x23,0xC4,0xDC,0x00,0xDF,0x88,0x69,0x40,0x03,0x12,0xE0,0x00,0x05,0x28,0x80,0x81,0x07};
extern const uint8_t spt_YET[]               PROGMEM ={0xAE,0x9F,0x16,0x8C,0x73,0x47,0xC5,0xA1,0xF4,0x3D,0x98,0x40,0xF4,0x9D,0xD5,0xD7,0x64,0x82,0x51,0x8F,0x4F,0xDF,0x6A,0x1A,0x29,0x7F,0x3F,0x6D,0xA9,0x16,0x66,0xFE,0xF4,0x76,0xB7,0x5D,0x4D,0xCC,0x5A,0xE2,0x35,0xA7,0xD4,0x31,0xCA,0xA8,0x6D,0x42,0x96,0x4B,0xE5,0xD6,0xE6,0x8E,0x00,0x14,0x90,0xB5,0x9B,0x00,0x52,0x4C,0x86,0x07,0x00,0x00};
extern const uint8_t spt_YOU[]               PROGMEM ={0xA5,0xDA,0x0D,0x98,0x23,0x6F,0xF4,0x6A,0x55,0x33,0xA9,0x82,0xC6,0xEB,0x91,0xF5,0x68,0x02,0x11,0x5B,0x67,0x36,0x32,0x2B,0xA2,0x24,0x75,0x75,0xCF,0x7B,0xD5,0x9B,0xD6,0x5A,0x61,0xE5,0x49,0xDD,0x6A,0x97,0xFB,0xD8,0xFB,0x5E,0x77,0xA2,0xB3,0x2C,0x45,0x25,0x8D,0x3C,0x00,0x00};
extern const uint8_t spt_YOU_WIN[]           PROGMEM ={0x26,0x2B,0x82,0x54,0x76,0x4B,0xA7,0x76,0x04,0x14,0xB6,0xBA,0x5D,0xBA,0x9E,0x48,0x30,0xEA,0xD6,0x69,0x6A,0x73,0x01,0xF7,0xB7,0xA7,0x6A,0xAD,0x0C,0x0C,0xFB,0x8F,0x2C,0x5A,0x55,0x2D,0xFD,0x52,0x62,0x6E,0xBA,0x06,0xA5,0x59,0x8E,0x72,0x1C,0x13,0x97,0x31,0xF7,0x61,0x2C,0x4D,0x5B,0x6E,0x64,0x8E,0x19,0x66,0x3D,0x55,0x16,0x9E,0x56,0xD8,0xF5,0xD4,0x35,0xA6,0x6A,0xC8,0x9A,0xDB,0xDC,0xF6,0xB6,0xB7,0x4D,0x9D,0xB4,0x66,0xEE,0xDE,0xD8,0xB7,0xAA,0xA5,0xC1,0xC2,0xB2,0x22,0xAB,0x86,0x7A,0x2F,0x8D,0x91,0x2D,0x6A,0x94,0x23,0x3D,0xDB,0x8E,0xA8,0xB0,0xCB,0x4E,0x2B,0x39,0x0F,0x00,0x00};
extern const uint8_t spt_YOUR[]              PROGMEM ={0xA6,0x1A,0x1A,0x4C,0xB2,0x2F,0xF9,0x2A,0x56,0xB9,0x1A,0x55,0xF4,0xEA,0x12,0xB6,0xA5,0x57,0xAD,0xB2,0xD1,0xA2,0x9C,0x95,0xF7,0xBA,0x37,0xA9,0x53,0x53,0x72,0x45,0xB3,0xE6,0x21,0x0D,0x66,0x89,0xAF,0x49,0x9E,0x34,0xE8,0x21,0xF6,0x9C,0x9A,0xCA,0x60,0xBB,0xC8,0x9A,0xAB,0x76,0x43,0x58,0xC4,0xA1,0xA1,0xD9,0x0C,0x2A,0x99,0x86,0xBB,0x2D,0x31,0x98,0xA8,0x1C,0xE6,0x6E,0xE0,0x01,0x00,0x00};
extern const uint8_t spt_Z[]                 PROGMEM ={0xA5,0x4A,0x24,0xCC,0x38,0x73,0x8F,0x7A,0x73,0x37,0x65,0xF6,0xBB,0x9B,0xD6,0x7C,0x6F,0x6A,0xA8,0xEE,0x56,0xD1,0x4D,0xA9,0xB0,0xF4,0x39,0x79,0xC9,0x29,0xC2,0xB6,0xF9,0x64,0x35,0x39,0x72,0xE4,0x93,0x9B,0xAD,0xBC,0x46,0x41,0xC9,0x9E,0xB3,0xAB,0x59,0xCD,0xA6,0x77,0xA1,0xCB,0x8E,0x38,0x7A,0x46,0x3F};
extern const uint8_t spt_ZERO[]              PROGMEM ={0xAD,0x59,0x3A,0xC8,0x18,0xFD,0x9E,0xA2,0x99,0x34,0x23,0xE9,0x77,0xB2,0xE0,0xDD,0xC4,0xAA,0xCD,0x49,0x5C,0x36,0xB3,0xAC,0x36,0x2B,0xB1,0x45,0xD2,0x33,0x72,0xEF,0x6C,0x54,0xA6,0x73,0x79,0x49,0xDE,0xD5,0xD8,0x2A,0xE9,0xA9,0xDE,0x67,0xEF,0x06,0x99,0xBB,0xA4,0x2D,0x75,0x19,0x54,0xB4,0x2F,0xD1,0xB4,0x79,0xF0,0x83,0x1F,0xFC,0xEC,0x17,0xBB,0x3C,0x00,0x00};
