-- MySQL Script generated by MySQL Workbench
-- Tue May  4 17:26:23 2021
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema doctoroffce
-- -----------------------------------------------------
DROP SCHEMA IF EXISTS `doctoroffce` ;

-- -----------------------------------------------------
-- Schema doctoroffce
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `doctoroffce` DEFAULT CHARACTER SET utf8 ;
USE `doctoroffce` ;

-- -----------------------------------------------------
-- Table `doctoroffce`.`users`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `doctoroffce`.`users` ;

CREATE TABLE IF NOT EXISTS `doctoroffce`.`users` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(45) NOT NULL,
  `email` VARCHAR(45) NOT NULL,
  `password` VARCHAR(256) NOT NULL,
  `created_at` DATETIME NOT NULL,
  `updated_at_` DATETIME NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `doctoroffce`.`doctors`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `doctoroffce`.`doctors` ;

CREATE TABLE IF NOT EXISTS `doctoroffce`.`doctors` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(45) NOT NULL,
  `especiality` VARCHAR(45) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `doctoroffce`.`consults`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `doctoroffce`.`consults` ;

CREATE TABLE IF NOT EXISTS `doctoroffce`.`consults` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `desc` LONGTEXT NOT NULL,
  `timeMarked` DATETIME NOT NULL,
  `created_at` DATETIME NOT NULL,
  `updated_at` DATETIME NOT NULL,
  `user` INT NOT NULL,
  `doctor` INT NOT NULL,
  PRIMARY KEY (`id`, `user`, `doctor`),
  INDEX `fk_consults_users1_idx` (`user` ASC) VISIBLE,
  INDEX `fk_consults_doctors1_idx` (`doctor` ASC) VISIBLE,
  CONSTRAINT `fk_consults_users1`
    FOREIGN KEY (`user`)
    REFERENCES `doctoroffce`.`users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_consults_doctors1`
    FOREIGN KEY (`doctor`)
    REFERENCES `doctoroffce`.`doctors` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;

-- -----------------------------------------------------
-- Data for table `doctoroffce`.`doctors`
-- -----------------------------------------------------
START TRANSACTION;
USE `doctoroffce`;
INSERT INTO `doctoroffce`.`doctors` (`id`, `name`, `especiality`) VALUES (1, 'Dr. Pedro', 'Dermatologista');
INSERT INTO `doctoroffce`.`doctors` (`id`, `name`, `especiality`) VALUES (2, 'Dra. Fabiana', 'Pediatra');
INSERT INTO `doctoroffce`.`doctors` (`id`, `name`, `especiality`) VALUES (3, 'Dra. Gabriela', 'Cardilogista');
INSERT INTO `doctoroffce`.`doctors` (`id`, `name`, `especiality`) VALUES (4, 'Dr. Alceu', 'Ortopedista');

COMMIT;

