package io.github.aquerr.eaglefactions.api.events;

import io.github.aquerr.eaglefactions.api.entities.Faction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;

/**
 * Base event for all events related to {@link Faction}
 */
public interface FactionEvent extends Event, Cancellable
{
    /**
     * Gets the player that triggered the event.
     * @return {@link Player} object.
     */
    Player getCreator();

    /**
     * Gets faction that this event is related to.
     * Clients can cancel this event by sending true to {@link Cancellable#setCancelled(boolean)} method.
     * @return the faction
     */
    Faction getFaction();
}
