import { useTheme } from "@mui/material";
import { ResponsiveBar } from "@nivo/bar";
import { tokens } from "../../theme";

const BarChart = ({ isDashboard = false }) => {
  const theme = useTheme();
  const colors = tokens(theme.palette.mode);

  return (
    <ResponsiveBar
      data={[
        {
          country: "AD",
          "hot dog": 137,
          "hot dogColor": "hsl(229, 70%, 50%)",
          burger: 96,
          burgerColor: "hsl(296, 70%, 50%)",
          kebab: 72,
          kebabColor: "hsl(97, 70%, 50%)",
          donut: 140,
          donutColor: "hsl(340, 70%, 50%)",
        },
        {
          country: "AE",
          "hot dog": 55,
          "hot dogColor": "hsl(307, 70%, 50%)",
          burger: 28,
          burgerColor: "hsl(111, 70%, 50%)",
          kebab: 58,
          kebabColor: "hsl(273, 70%, 50%)",
          donut: 29,
          donutColor: "hsl(275, 70%, 50%)",
        },
        {
          country: "AF",
          "hot dog": 109,
          "hot dogColor": "hsl(72, 70%, 50%)",
          burger: 23,
          burgerColor: "hsl(96, 70%, 50%)",
          kebab: 34,
          kebabColor: "hsl(106, 70%, 50%)",
          donut: 152,
          donutColor: "hsl(256, 70%, 50%)",
        },
        {
          country: "AG",
          "hot dog": 133,
          "hot dogColor": "hsl(257, 70%, 50%)",
          burger: 52,
          burgerColor: "hsl(326, 70%, 50%)",
          kebab: 43,
          kebabColor: "hsl(110, 70%, 50%)",
          donut: 83,
          donutColor: "hsl(9, 70%, 50%)",
        },
        {
          country: "AI",
          "hot dog": 81,
          "hot dogColor": "hsl(190, 70%, 50%)",
          burger: 80,
          burgerColor: "hsl(325, 70%, 50%)",
          kebab: 112,
          kebabColor: "hsl(54, 70%, 50%)",
          donut: 35,
          donutColor: "hsl(285, 70%, 50%)",
        },
        {
          country: "AL",
          "hot dog": 66,
          "hot dogColor": "hsl(208, 70%, 50%)",
          burger: 111,
          burgerColor: "hsl(334, 70%, 50%)",
          kebab: 167,
          kebabColor: "hsl(182, 70%, 50%)",
          donut: 18,
          donutColor: "hsl(76, 70%, 50%)",
        },
        {
          country: "AM",
          "hot dog": 80,
          "hot dogColor": "hsl(87, 70%, 50%)",
          burger: 47,
          burgerColor: "hsl(141, 70%, 50%)",
          kebab: 158,
          kebabColor: "hsl(224, 70%, 50%)",
          donut: 49,
          donutColor: "hsl(274, 70%, 50%)",
        },
      ]}
      theme={{
        // added
        axis: {
          domain: {
            line: {
              stroke: colors.grey[100],
            },
          },
          legend: {
            text: {
              fill: colors.grey[100],
            },
          },
          ticks: {
            line: {
              stroke: colors.grey[100],
              strokeWidth: 1,
            },
            text: {
              fill: colors.grey[100],
            },
          },
        },
        legends: {
          text: {
            fill: colors.grey[100],
          },
        },
      }}
      keys={["hot dog", "burger", "sandwich", "kebab", "fries", "donut"]}
      indexBy="country"
      margin={{ top: 50, right: 130, bottom: 50, left: 60 }}
      padding={0.3}
      valueScale={{ type: "linear" }}
      indexScale={{ type: "band", round: true }}
      colors={{ scheme: "nivo" }}
      defs={[
        {
          id: "dots",
          type: "patternDots",
          background: "inherit",
          color: "#38bcb2",
          size: 4,
          padding: 1,
          stagger: true,
        },
        {
          id: "lines",
          type: "patternLines",
          background: "inherit",
          color: "#eed312",
          rotation: -45,
          lineWidth: 6,
          spacing: 10,
        },
      ]}
      borderColor={{
        from: "color",
        modifiers: [["darker", "1.6"]],
      }}
      axisTop={null}
      axisRight={null}
      axisBottom={{
        tickSize: 5,
        tickPadding: 5,
        tickRotation: 0,
        legend: isDashboard ? undefined : "country", // changed
        legendPosition: "middle",
        legendOffset: 32,
      }}
      axisLeft={{
        tickSize: 5,
        tickPadding: 5,
        tickRotation: 0,
        legend: isDashboard ? undefined : "food", // changed
        legendPosition: "middle",
        legendOffset: -40,
      }}
      enableLabel={false}
      labelSkipWidth={12}
      labelSkipHeight={12}
      labelTextColor={{
        from: "color",
        modifiers: [["darker", 1.6]],
      }}
      legends={[
        {
          dataFrom: "keys",
          anchor: "bottom-right",
          direction: "column",
          justify: false,
          translateX: 120,
          translateY: 0,
          itemsSpacing: 2,
          itemWidth: 100,
          itemHeight: 20,
          itemDirection: "left-to-right",
          itemOpacity: 0.85,
          symbolSize: 20,
          effects: [
            {
              on: "hover",
              style: {
                itemOpacity: 1,
              },
            },
          ],
        },
      ]}
      role="application"
      barAriaLabel={function (e) {
        return e.id + ": " + e.formattedValue + " in country: " + e.indexValue;
      }}
    />
  );
};

export default BarChart;
