#pragma once

#include "Types.hpp"

//#pragma pack(push)
//#pragma pack(2)
struct Tbl1 final
{
    u8 mBitsToShift;
    //s8 padding;
    u16 mOutputWord;
};
//#pragma pack(pop)
//static_assert(sizeof(Tbl1) == 4, "Wrong size");


//#pragma pack(push)
//#pragma pack(2)
struct Tbl2 final
{
    u8 mBitsToShift;
    // s8 padding;
    u16 mOutputWord1;
    u16 mOutputWord2;
    u16 mOutputWord3;
};
//#pragma pack(pop)

static_assert(sizeof(Tbl2) == 8, "Wrong size");
static const Tbl1 gTbl1[512] =
{
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x00, 0x0000 },
    { 0x09, 0x0412 }, // 32
    { 0x09, 0x07EE },
    { 0x09, 0x0411 },
    { 0x09, 0x07EF },
    { 0x09, 0x0410 },
    { 0x09, 0x07F0 },
    { 0x09, 0x040F },
    { 0x09, 0x07F1 },
    { 0x09, 0x1803 },
    { 0x09, 0x1BFD },
    { 0x09, 0x4002 },
    { 0x09, 0x43FE },
    { 0x09, 0x3C02 },
    { 0x09, 0x3FFE },
    { 0x09, 0x3802 },
    { 0x09, 0x3BFE },
    { 0x09, 0x3402 },
    { 0x09, 0x37FE },
    { 0x09, 0x3002 },
    { 0x09, 0x33FE },
    { 0x09, 0x2C02 },
    { 0x09, 0x2FFE },
    { 0x09, 0x7C01 },
    { 0x09, 0x7FFF },
    { 0x09, 0x7801 },
    { 0x09, 0x7BFF },
    { 0x09, 0x7401 },
    { 0x09, 0x77FF },
    { 0x09, 0x7001 },
    { 0x09, 0x73FF },
    { 0x09, 0x6C01 },
    { 0x09, 0x6FFF }, // 31
    { 0x08, 0x0028 },
    { 0x08, 0x0028 },
    { 0x08, 0x03D8 },
    { 0x08, 0x03D8 },
    { 0x08, 0x0027 },
    { 0x08, 0x0027 },
    { 0x08, 0x03D9 },
    { 0x08, 0x03D9 },
    { 0x08, 0x0026 },
    { 0x08, 0x0026 },
    { 0x08, 0x03DA },
    { 0x08, 0x03DA },
    { 0x08, 0x0025 },
    { 0x08, 0x0025 },
    { 0x08, 0x03DB },
    { 0x08, 0x03DB },
    { 0x08, 0x0024 },
    { 0x08, 0x0024 },
    { 0x08, 0x03DC },
    { 0x08, 0x03DC },
    { 0x08, 0x0023 },
    { 0x08, 0x0023 },
    { 0x08, 0x03DD },
    { 0x08, 0x03DD },
    { 0x08, 0x0022 },
    { 0x08, 0x0022 },
    { 0x08, 0x03DE },
    { 0x08, 0x03DE },
    { 0x08, 0x0021 },
    { 0x08, 0x0021 },
    { 0x08, 0x03DF },
    { 0x08, 0x03DF },
    { 0x08, 0x0020 },
    { 0x08, 0x0020 },
    { 0x08, 0x03E0 },
    { 0x08, 0x03E0 },
    { 0x08, 0x040E },
    { 0x08, 0x040E },
    { 0x08, 0x07F2 },
    { 0x08, 0x07F2 },
    { 0x08, 0x040D },
    { 0x08, 0x040D },
    { 0x08, 0x07F3 },
    { 0x08, 0x07F3 },
    { 0x08, 0x040C },
    { 0x08, 0x040C },
    { 0x08, 0x07F4 },
    { 0x08, 0x07F4 },
    { 0x08, 0x040B },
    { 0x08, 0x040B },
    { 0x08, 0x07F5 },
    { 0x08, 0x07F5 },
    { 0x08, 0x040A },
    { 0x08, 0x040A },
    { 0x08, 0x07F6 },
    { 0x08, 0x07F6 },
    { 0x08, 0x0409 },
    { 0x08, 0x0409 },
    { 0x08, 0x07F7 },
    { 0x08, 0x07F7 },
    { 0x08, 0x0408 },
    { 0x08, 0x0408 },
    { 0x08, 0x07F8 },
    { 0x08, 0x07F8 },
    { 0x07, 0x001F }, // 65
    { 0x07, 0x001F },
    { 0x07, 0x001F },
    { 0x07, 0x001F },
    { 0x07, 0x03E1 },
    { 0x07, 0x03E1 },
    { 0x07, 0x03E1 },
    { 0x07, 0x03E1 },
    { 0x07, 0x001E },
    { 0x07, 0x001E },
    { 0x07, 0x001E },
    { 0x07, 0x001E },
    { 0x07, 0x03E2 },
    { 0x07, 0x03E2 },
    { 0x07, 0x03E2 },
    { 0x07, 0x03E2 },
    { 0x07, 0x001D },
    { 0x07, 0x001D },
    { 0x07, 0x001D },
    { 0x07, 0x001D },
    { 0x07, 0x03E3 },
    { 0x07, 0x03E3 },
    { 0x07, 0x03E3 },
    { 0x07, 0x03E3 },
    { 0x07, 0x001C },
    { 0x07, 0x001C },
    { 0x07, 0x001C },
    { 0x07, 0x001C },
    { 0x07, 0x03E4 },
    { 0x07, 0x03E4 },
    { 0x07, 0x03E4 },
    { 0x07, 0x03E4 },
    { 0x07, 0x001B },
    { 0x07, 0x001B },
    { 0x07, 0x001B },
    { 0x07, 0x001B },
    { 0x07, 0x03E5 },
    { 0x07, 0x03E5 },
    { 0x07, 0x03E5 },
    { 0x07, 0x03E5 },
    { 0x07, 0x001A },
    { 0x07, 0x001A },
    { 0x07, 0x001A },
    { 0x07, 0x001A },
    { 0x07, 0x03E6 },
    { 0x07, 0x03E6 },
    { 0x07, 0x03E6 },
    { 0x07, 0x03E6 },
    { 0x07, 0x0019 },
    { 0x07, 0x0019 },
    { 0x07, 0x0019 },
    { 0x07, 0x0019 },
    { 0x07, 0x03E7 },
    { 0x07, 0x03E7 },
    { 0x07, 0x03E7 },
    { 0x07, 0x03E7 },
    { 0x07, 0x0018 },
    { 0x07, 0x0018 },
    { 0x07, 0x0018 },
    { 0x07, 0x0018 },
    { 0x07, 0x03E8 },
    { 0x07, 0x03E8 },
    { 0x07, 0x03E8 },
    { 0x07, 0x03E8 },
    { 0x07, 0x0017 },
    { 0x07, 0x0017 },
    { 0x07, 0x0017 },
    { 0x07, 0x0017 },
    { 0x07, 0x03E9 },
    { 0x07, 0x03E9 },
    { 0x07, 0x03E9 },
    { 0x07, 0x03E9 },
    { 0x07, 0x0016 },
    { 0x07, 0x0016 },
    { 0x07, 0x0016 },
    { 0x07, 0x0016 },
    { 0x07, 0x03EA },
    { 0x07, 0x03EA },
    { 0x07, 0x03EA },
    { 0x07, 0x03EA },
    { 0x07, 0x0015 },
    { 0x07, 0x0015 },
    { 0x07, 0x0015 },
    { 0x07, 0x0015 },
    { 0x07, 0x03EB },
    { 0x07, 0x03EB },
    { 0x07, 0x03EB },
    { 0x07, 0x03EB },
    { 0x07, 0x0014 },
    { 0x07, 0x0014 },
    { 0x07, 0x0014 },
    { 0x07, 0x0014 },
    { 0x07, 0x03EC },
    { 0x07, 0x03EC },
    { 0x07, 0x03EC },
    { 0x07, 0x03EC },
    { 0x07, 0x0013 },
    { 0x07, 0x0013 },
    { 0x07, 0x0013 },
    { 0x07, 0x0013 },
    { 0x07, 0x03ED },
    { 0x07, 0x03ED },
    { 0x07, 0x03ED },
    { 0x07, 0x03ED },
    { 0x07, 0x0012 },
    { 0x07, 0x0012 },
    { 0x07, 0x0012 },
    { 0x07, 0x0012 },
    { 0x07, 0x03EE },
    { 0x07, 0x03EE },
    { 0x07, 0x03EE },
    { 0x07, 0x03EE },
    { 0x07, 0x0011 },
    { 0x07, 0x0011 },
    { 0x07, 0x0011 },
    { 0x07, 0x0011 },
    { 0x07, 0x03EF },
    { 0x07, 0x03EF },
    { 0x07, 0x03EF },
    { 0x07, 0x03EF },
    { 0x07, 0x0010 },
    { 0x07, 0x0010 },
    { 0x07, 0x0010 },
    { 0x07, 0x0010 },
    { 0x07, 0x03F0 },
    { 0x07, 0x03F0 },
    { 0x07, 0x03F0 },
    { 0x07, 0x03F0 },
    { 0x06, 0x2802 },
    { 0x06, 0x2802 },
    { 0x06, 0x2802 },
    { 0x06, 0x2802 },
    { 0x06, 0x2802 },
    { 0x06, 0x2802 },
    { 0x06, 0x2802 },
    { 0x06, 0x2802 },
    { 0x06, 0x2BFE },
    { 0x06, 0x2BFE },
    { 0x06, 0x2BFE },
    { 0x06, 0x2BFE },
    { 0x06, 0x2BFE },
    { 0x06, 0x2BFE },
    { 0x06, 0x2BFE },
    { 0x06, 0x2BFE },
    { 0x06, 0x2402 },
    { 0x06, 0x2402 },
    { 0x06, 0x2402 },
    { 0x06, 0x2402 },
    { 0x06, 0x2402 },
    { 0x06, 0x2402 },
    { 0x06, 0x2402 },
    { 0x06, 0x2402 },
    { 0x06, 0x27FE },
    { 0x06, 0x27FE },
    { 0x06, 0x27FE },
    { 0x06, 0x27FE },
    { 0x06, 0x27FE },
    { 0x06, 0x27FE },
    { 0x06, 0x27FE },
    { 0x06, 0x27FE },
    { 0x06, 0x1403 },
    { 0x06, 0x1403 },
    { 0x06, 0x1403 },
    { 0x06, 0x1403 },
    { 0x06, 0x1403 },
    { 0x06, 0x1403 },
    { 0x06, 0x1403 },
    { 0x06, 0x1403 },
    { 0x06, 0x17FD },
    { 0x06, 0x17FD },
    { 0x06, 0x17FD },
    { 0x06, 0x17FD },
    { 0x06, 0x17FD },
    { 0x06, 0x17FD },
    { 0x06, 0x17FD },
    { 0x06, 0x17FD },
    { 0x06, 0x0C04 },
    { 0x06, 0x0C04 },
    { 0x06, 0x0C04 },
    { 0x06, 0x0C04 },
    { 0x06, 0x0C04 },
    { 0x06, 0x0C04 },
    { 0x06, 0x0C04 },
    { 0x06, 0x0C04 },
    { 0x06, 0x0FFC },
    { 0x06, 0x0FFC },
    { 0x06, 0x0FFC },
    { 0x06, 0x0FFC },
    { 0x06, 0x0FFC },
    { 0x06, 0x0FFC },
    { 0x06, 0x0FFC },
    { 0x06, 0x0FFC },
    { 0x06, 0x0805 },
    { 0x06, 0x0805 },
    { 0x06, 0x0805 },
    { 0x06, 0x0805 },
    { 0x06, 0x0805 },
    { 0x06, 0x0805 },
    { 0x06, 0x0805 },
    { 0x06, 0x0805 },
    { 0x06, 0x0BFB },
    { 0x06, 0x0BFB },
    { 0x06, 0x0BFB },
    { 0x06, 0x0BFB },
    { 0x06, 0x0BFB },
    { 0x06, 0x0BFB },
    { 0x06, 0x0BFB },
    { 0x06, 0x0BFB },
    { 0x06, 0x0407 },
    { 0x06, 0x0407 },
    { 0x06, 0x0407 },
    { 0x06, 0x0407 },
    { 0x06, 0x0407 },
    { 0x06, 0x0407 },
    { 0x06, 0x0407 },
    { 0x06, 0x0407 },
    { 0x06, 0x07F9 },
    { 0x06, 0x07F9 },
    { 0x06, 0x07F9 },
    { 0x06, 0x07F9 },
    { 0x06, 0x07F9 },
    { 0x06, 0x07F9 },
    { 0x06, 0x07F9 },
    { 0x06, 0x07F9 },
    { 0x06, 0x0406 },
    { 0x06, 0x0406 },
    { 0x06, 0x0406 },
    { 0x06, 0x0406 },
    { 0x06, 0x0406 },
    { 0x06, 0x0406 },
    { 0x06, 0x0406 },
    { 0x06, 0x0406 },
    { 0x06, 0x07FA },
    { 0x06, 0x07FA },
    { 0x06, 0x07FA },
    { 0x06, 0x07FA },
    { 0x06, 0x07FA },
    { 0x06, 0x07FA },
    { 0x06, 0x07FA },
    { 0x06, 0x07FA },
    { 0x06, 0x000F },
    { 0x06, 0x000F },
    { 0x06, 0x000F },
    { 0x06, 0x000F },
    { 0x06, 0x000F },
    { 0x06, 0x000F },
    { 0x06, 0x000F },
    { 0x06, 0x000F },
    { 0x06, 0x03F1 },
    { 0x06, 0x03F1 },
    { 0x06, 0x03F1 },
    { 0x06, 0x03F1 },
    { 0x06, 0x03F1 },
    { 0x06, 0x03F1 },
    { 0x06, 0x03F1 },
    { 0x06, 0x03F1 },
    { 0x06, 0x000E },
    { 0x06, 0x000E },
    { 0x06, 0x000E },
    { 0x06, 0x000E },
    { 0x06, 0x000E },
    { 0x06, 0x000E },
    { 0x06, 0x000E },
    { 0x06, 0x000E },
    { 0x06, 0x03F2 },
    { 0x06, 0x03F2 },
    { 0x06, 0x03F2 },
    { 0x06, 0x03F2 },
    { 0x06, 0x03F2 },
    { 0x06, 0x03F2 },
    { 0x06, 0x03F2 },
    { 0x06, 0x03F2 },
    { 0x06, 0x000D },
    { 0x06, 0x000D },
    { 0x06, 0x000D },
    { 0x06, 0x000D },
    { 0x06, 0x000D },
    { 0x06, 0x000D },
    { 0x06, 0x000D },
    { 0x06, 0x000D },
    { 0x06, 0x03F3 },
    { 0x06, 0x03F3 },
    { 0x06, 0x03F3 },
    { 0x06, 0x03F3 },
    { 0x06, 0x03F3 },
    { 0x06, 0x03F3 },
    { 0x06, 0x03F3 },
    { 0x06, 0x03F3 },
    { 0x06, 0x000C },
    { 0x06, 0x000C },
    { 0x06, 0x000C },
    { 0x06, 0x000C },
    { 0x06, 0x000C },
    { 0x06, 0x000C },
    { 0x06, 0x000C },
    { 0x06, 0x000C },
    { 0x06, 0x03F4 },
    { 0x06, 0x03F4 },
    { 0x06, 0x03F4 },
    { 0x06, 0x03F4 },
    { 0x06, 0x03F4 },
    { 0x06, 0x03F4 },
    { 0x06, 0x03F4 },
    { 0x06, 0x03F4 },
    { 0x06, 0x6801 },
    { 0x06, 0x6801 },
    { 0x06, 0x6801 },
    { 0x06, 0x6801 },
    { 0x06, 0x6801 },
    { 0x06, 0x6801 },
    { 0x06, 0x6801 },
    { 0x06, 0x6801 },
    { 0x06, 0x6BFF },
    { 0x06, 0x6BFF },
    { 0x06, 0x6BFF },
    { 0x06, 0x6BFF },
    { 0x06, 0x6BFF },
    { 0x06, 0x6BFF },
    { 0x06, 0x6BFF },
    { 0x06, 0x6BFF },
    { 0x06, 0x6401 },
    { 0x06, 0x6401 },
    { 0x06, 0x6401 },
    { 0x06, 0x6401 },
    { 0x06, 0x6401 },
    { 0x06, 0x6401 },
    { 0x06, 0x6401 },
    { 0x06, 0x6401 },
    { 0x06, 0x67FF },
    { 0x06, 0x67FF },
    { 0x06, 0x67FF },
    { 0x06, 0x67FF },
    { 0x06, 0x67FF },
    { 0x06, 0x67FF },
    { 0x06, 0x67FF },
    { 0x06, 0x67FF },
    { 0x06, 0x6001 },
    { 0x06, 0x6001 },
    { 0x06, 0x6001 },
    { 0x06, 0x6001 },
    { 0x06, 0x6001 },
    { 0x06, 0x6001 },
    { 0x06, 0x6001 },
    { 0x06, 0x6001 },
    { 0x06, 0x63FF },
    { 0x06, 0x63FF },
    { 0x06, 0x63FF },
    { 0x06, 0x63FF },
    { 0x06, 0x63FF },
    { 0x06, 0x63FF },
    { 0x06, 0x63FF },
    { 0x06, 0x63FF },
    { 0x06, 0x5C01 },
    { 0x06, 0x5C01 },
    { 0x06, 0x5C01 },
    { 0x06, 0x5C01 },
    { 0x06, 0x5C01 },
    { 0x06, 0x5C01 },
    { 0x06, 0x5C01 },
    { 0x06, 0x5C01 },
    { 0x06, 0x5FFF },
    { 0x06, 0x5FFF },
    { 0x06, 0x5FFF },
    { 0x06, 0x5FFF },
    { 0x06, 0x5FFF },
    { 0x06, 0x5FFF },
    { 0x06, 0x5FFF },
    { 0x06, 0x5FFF },
    { 0x06, 0x5801 },
    { 0x06, 0x5801 },
    { 0x06, 0x5801 },
    { 0x06, 0x5801 },
    { 0x06, 0x5801 },
    { 0x06, 0x5801 },
    { 0x06, 0x5801 },
    { 0x06, 0x5801 },
    { 0x06, 0x5BFF },
    { 0x06, 0x5BFF },
    { 0x06, 0x5BFF },
    { 0x06, 0x5BFF },
    { 0x06, 0x5BFF },
    { 0x06, 0x5BFF },
    { 0x06, 0x5BFF },
    { 0x06, 0x5BFF }
};

static const Tbl2 gTbl2[8192] =
{
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x00, 0x0000, 0x0000, 0x0000 },
    { 0x0D, 0x000B, 0x0000, 0x0000 },
    { 0x0D, 0x03F5, 0x0000, 0x0000 },
    { 0x0D, 0x2002, 0x0000, 0x0000 },
    { 0x0D, 0x23FE, 0x0000, 0x0000 },
    { 0x0D, 0x1003, 0x0000, 0x0000 },
    { 0x0D, 0x13FD, 0x0000, 0x0000 },
    { 0x0D, 0x000A, 0x0000, 0x0000 },
    { 0x0D, 0x03F6, 0x0000, 0x0000 },
    { 0x0D, 0x0804, 0x0000, 0x0000 },
    { 0x0D, 0x0BFC, 0x0000, 0x0000 },
    { 0x0D, 0x1C02, 0x0000, 0x0000 },
    { 0x0D, 0x1FFE, 0x0000, 0x0000 },
    { 0x0D, 0x5401, 0x0000, 0x0000 },
    { 0x0D, 0x57FF, 0x0000, 0x0000 },
    { 0x0D, 0x5001, 0x0000, 0x0000 },
    { 0x0D, 0x53FF, 0x0000, 0x0000 },
    { 0x0D, 0x0009, 0x0000, 0x0000 },
    { 0x0D, 0x03F7, 0x0000, 0x0000 },
    { 0x0D, 0x4C01, 0x0000, 0x0000 },
    { 0x0D, 0x4FFF, 0x0000, 0x0000 },
    { 0x0D, 0x4801, 0x0000, 0x0000 },
    { 0x0D, 0x4BFF, 0x0000, 0x0000 },
    { 0x0D, 0x0405, 0x0000, 0x0000 },
    { 0x0D, 0x07FB, 0x0000, 0x0000 },
    { 0x0D, 0x0C03, 0x0000, 0x0000 },
    { 0x0D, 0x0FFD, 0x0000, 0x0000 },
    { 0x0D, 0x0008, 0x0000, 0x0000 },
    { 0x0D, 0x03F8, 0x0000, 0x0000 },
    { 0x0D, 0x1802, 0x0000, 0x0000 },
    { 0x0D, 0x1BFE, 0x0000, 0x0000 },
    { 0x0D, 0x4401, 0x0000, 0x0000 },
    { 0x0D, 0x47FF, 0x0000, 0x0000 },
    { 0x0B, 0x4001, 0x0000, 0x0000 },
    { 0x0B, 0x4001, 0x0000, 0x0000 },
    { 0x0D, 0x4001, 0xFE00, 0x0000 },
    { 0x0B, 0x4001, 0x0000, 0x0000 },
    { 0x0B, 0x43FF, 0x0000, 0x0000 },
    { 0x0B, 0x43FF, 0x0000, 0x0000 },
    { 0x0D, 0x43FF, 0xFE00, 0x0000 },
    { 0x0B, 0x43FF, 0x0000, 0x0000 },
    { 0x0B, 0x1402, 0x0000, 0x0000 },
    { 0x0B, 0x1402, 0x0000, 0x0000 },
    { 0x0D, 0x1402, 0xFE00, 0x0000 },
    { 0x0B, 0x1402, 0x0000, 0x0000 },
    { 0x0B, 0x17FE, 0x0000, 0x0000 },
    { 0x0B, 0x17FE, 0x0000, 0x0000 },
    { 0x0D, 0x17FE, 0xFE00, 0x0000 },
    { 0x0B, 0x17FE, 0x0000, 0x0000 },
    { 0x0B, 0x0007, 0x0000, 0x0000 },
    { 0x0B, 0x0007, 0x0000, 0x0000 },
    { 0x0D, 0x0007, 0xFE00, 0x0000 },
    { 0x0B, 0x0007, 0x0000, 0x0000 },
    { 0x0B, 0x03F9, 0x0000, 0x0000 },
    { 0x0B, 0x03F9, 0x0000, 0x0000 },
    { 0x0D, 0x03F9, 0xFE00, 0x0000 },
    { 0x0B, 0x03F9, 0x0000, 0x0000 },
    { 0x0B, 0x0803, 0x0000, 0x0000 },
    { 0x0B, 0x0803, 0x0000, 0x0000 },
    { 0x0D, 0x0803, 0xFE00, 0x0000 },
    { 0x0B, 0x0803, 0x0000, 0x0000 },
    { 0x0B, 0x0BFD, 0x0000, 0x0000 },
    { 0x0B, 0x0BFD, 0x0000, 0x0000 },
    { 0x0D, 0x0BFD, 0xFE00, 0x0000 },
    { 0x0B, 0x0BFD, 0x0000, 0x0000 },
    { 0x0B, 0x0404, 0x0000, 0x0000 },
    { 0x0B, 0x0404, 0x0000, 0x0000 },
    { 0x0D, 0x0404, 0xFE00, 0x0000 },
    { 0x0B, 0x0404, 0x0000, 0x0000 },
    { 0x0B, 0x07FC, 0x0000, 0x0000 },
    { 0x0B, 0x07FC, 0x0000, 0x0000 },
    { 0x0D, 0x07FC, 0xFE00, 0x0000 },
    { 0x0B, 0x07FC, 0x0000, 0x0000 },
    { 0x0B, 0x3C01, 0x0000, 0x0000 },
    { 0x0B, 0x3C01, 0x0000, 0x0000 },
    { 0x0D, 0x3C01, 0xFE00, 0x0000 },
    { 0x0B, 0x3C01, 0x0000, 0x0000 },
    { 0x0B, 0x3FFF, 0x0000, 0x0000 },
    { 0x0B, 0x3FFF, 0x0000, 0x0000 },
    { 0x0D, 0x3FFF, 0xFE00, 0x0000 },
    { 0x0B, 0x3FFF, 0x0000, 0x0000 },
    { 0x0B, 0x3801, 0x0000, 0x0000 },
    { 0x0B, 0x3801, 0x0000, 0x0000 },
    { 0x0D, 0x3801, 0xFE00, 0x0000 },
    { 0x0B, 0x3801, 0x0000, 0x0000 },
    { 0x0B, 0x3BFF, 0x0000, 0x0000 },
    { 0x0B, 0x3BFF, 0x0000, 0x0000 },
    { 0x0D, 0x3BFF, 0xFE00, 0x0000 },
    { 0x0B, 0x3BFF, 0x0000, 0x0000 },
    { 0x0B, 0x1002, 0x0000, 0x0000 },
    { 0x0B, 0x1002, 0x0000, 0x0000 },
    { 0x0D, 0x1002, 0xFE00, 0x0000 },
    { 0x0B, 0x1002, 0x0000, 0x0000 },
    { 0x0B, 0x13FE, 0x0000, 0x0000 },
    { 0x0B, 0x13FE, 0x0000, 0x0000 },
    { 0x0D, 0x13FE, 0xFE00, 0x0000 },
    { 0x0B, 0x13FE, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x06, 0x7C1F, 0x0000, 0x0000 },
    { 0x08, 0x0802, 0x0000, 0x0000 },
    { 0x08, 0x0802, 0x0000, 0x0000 },
    { 0x08, 0x0802, 0x0000, 0x0000 },
    { 0x08, 0x0802, 0x0000, 0x0000 },
    { 0x08, 0x0802, 0x0000, 0x0000 },
    { 0x08, 0x0802, 0x0000, 0x0000 },
    { 0x08, 0x0802, 0x0000, 0x0000 },
    { 0x08, 0x0802, 0x0000, 0x0000 },
    { 0x0D, 0x0802, 0x0002, 0x0000 },
    { 0x0D, 0x0802, 0x03FE, 0x0000 },
    { 0x0D, 0x0802, 0x0801, 0x0000 },
    { 0x0D, 0x0802, 0x0BFF, 0x0000 },
    { 0x0C, 0x0802, 0x0401, 0x0000 },
    { 0x0C, 0x0802, 0x0401, 0x0000 },
    { 0x0C, 0x0802, 0x07FF, 0x0000 },
    { 0x0C, 0x0802, 0x07FF, 0x0000 },
    { 0x0A, 0x0802, 0xFE00, 0x0000 },
    { 0x0A, 0x0802, 0xFE00, 0x0000 },
    { 0x0A, 0x0802, 0xFE00, 0x0000 },
    { 0x0A, 0x0802, 0xFE00, 0x0000 },
    { 0x0A, 0x0802, 0xFE00, 0x0000 },
    { 0x0A, 0x0802, 0xFE00, 0x0000 },
    { 0x0A, 0x0802, 0xFE00, 0x0000 },
    { 0x0A, 0x0802, 0xFE00, 0x0000 },
    { 0x0B, 0x0802, 0x0001, 0x0000 },
    { 0x0B, 0x0802, 0x0001, 0x0000 },
    { 0x0D, 0x0802, 0x0001, 0xFE00 },
    { 0x0B, 0x0802, 0x0001, 0x0000 },
    { 0x0B, 0x0802, 0x03FF, 0x0000 },
    { 0x0B, 0x0802, 0x03FF, 0x0000 },
    { 0x0D, 0x0802, 0x03FF, 0xFE00 },
    { 0x0B, 0x0802, 0x03FF, 0x0000 },
    { 0x08, 0x0BFE, 0x0000, 0x0000 },
    { 0x08, 0x0BFE, 0x0000, 0x0000 },
    { 0x08, 0x0BFE, 0x0000, 0x0000 },
    { 0x08, 0x0BFE, 0x0000, 0x0000 },
    { 0x08, 0x0BFE, 0x0000, 0x0000 },
    { 0x08, 0x0BFE, 0x0000, 0x0000 },
    { 0x08, 0x0BFE, 0x0000, 0x0000 },
    { 0x08, 0x0BFE, 0x0000, 0x0000 },
    { 0x0D, 0x0BFE, 0x0002, 0x0000 },
    { 0x0D, 0x0BFE, 0x03FE, 0x0000 },
    { 0x0D, 0x0BFE, 0x0801, 0x0000 },
    { 0x0D, 0x0BFE, 0x0BFF, 0x0000 },
    { 0x0C, 0x0BFE, 0x0401, 0x0000 },
    { 0x0C, 0x0BFE, 0x0401, 0x0000 },
    { 0x0C, 0x0BFE, 0x07FF, 0x0000 },
    { 0x0C, 0x0BFE, 0x07FF, 0x0000 },
    { 0x0A, 0x0BFE, 0xFE00, 0x0000 },
    { 0x0A, 0x0BFE, 0xFE00, 0x0000 },
    { 0x0A, 0x0BFE, 0xFE00, 0x0000 },
    { 0x0A, 0x0BFE, 0xFE00, 0x0000 },
    { 0x0A, 0x0BFE, 0xFE00, 0x0000 },
    { 0x0A, 0x0BFE, 0xFE00, 0x0000 },
    { 0x0A, 0x0BFE, 0xFE00, 0x0000 },
    { 0x0A, 0x0BFE, 0xFE00, 0x0000 },
    { 0x0B, 0x0BFE, 0x0001, 0x0000 },
    { 0x0B, 0x0BFE, 0x0001, 0x0000 },
    { 0x0D, 0x0BFE, 0x0001, 0xFE00 },
    { 0x0B, 0x0BFE, 0x0001, 0x0000 },
    { 0x0B, 0x0BFE, 0x03FF, 0x0000 },
    { 0x0B, 0x0BFE, 0x03FF, 0x0000 },
    { 0x0D, 0x0BFE, 0x03FF, 0xFE00 },
    { 0x0B, 0x0BFE, 0x03FF, 0x0000 },
    { 0x08, 0x2401, 0x0000, 0x0000 },
    { 0x08, 0x2401, 0x0000, 0x0000 },
    { 0x08, 0x2401, 0x0000, 0x0000 },
    { 0x08, 0x2401, 0x0000, 0x0000 },
    { 0x08, 0x2401, 0x0000, 0x0000 },
    { 0x08, 0x2401, 0x0000, 0x0000 },
    { 0x08, 0x2401, 0x0000, 0x0000 },
    { 0x08, 0x2401, 0x0000, 0x0000 },
    { 0x0D, 0x2401, 0x0002, 0x0000 },
    { 0x0D, 0x2401, 0x03FE, 0x0000 },
    { 0x0D, 0x2401, 0x0801, 0x0000 },
    { 0x0D, 0x2401, 0x0BFF, 0x0000 },
    { 0x0C, 0x2401, 0x0401, 0x0000 },
    { 0x0C, 0x2401, 0x0401, 0x0000 },
    { 0x0C, 0x2401, 0x07FF, 0x0000 },
    { 0x0C, 0x2401, 0x07FF, 0x0000 },
    { 0x0A, 0x2401, 0xFE00, 0x0000 },
    { 0x0A, 0x2401, 0xFE00, 0x0000 },
    { 0x0A, 0x2401, 0xFE00, 0x0000 },
    { 0x0A, 0x2401, 0xFE00, 0x0000 },
    { 0x0A, 0x2401, 0xFE00, 0x0000 },
    { 0x0A, 0x2401, 0xFE00, 0x0000 },
    { 0x0A, 0x2401, 0xFE00, 0x0000 },
    { 0x0A, 0x2401, 0xFE00, 0x0000 },
    { 0x0B, 0x2401, 0x0001, 0x0000 },
    { 0x0B, 0x2401, 0x0001, 0x0000 },
    { 0x0D, 0x2401, 0x0001, 0xFE00 },
    { 0x0B, 0x2401, 0x0001, 0x0000 },
    { 0x0B, 0x2401, 0x03FF, 0x0000 },
    { 0x0B, 0x2401, 0x03FF, 0x0000 },
    { 0x0D, 0x2401, 0x03FF, 0xFE00 },
    { 0x0B, 0x2401, 0x03FF, 0x0000 },
    { 0x08, 0x27FF, 0x0000, 0x0000 },
    { 0x08, 0x27FF, 0x0000, 0x0000 },
    { 0x08, 0x27FF, 0x0000, 0x0000 },
    { 0x08, 0x27FF, 0x0000, 0x0000 },
    { 0x08, 0x27FF, 0x0000, 0x0000 },
    { 0x08, 0x27FF, 0x0000, 0x0000 },
    { 0x08, 0x27FF, 0x0000, 0x0000 },
    { 0x08, 0x27FF, 0x0000, 0x0000 },
    { 0x0D, 0x27FF, 0x0002, 0x0000 },
    { 0x0D, 0x27FF, 0x03FE, 0x0000 },
    { 0x0D, 0x27FF, 0x0801, 0x0000 },
    { 0x0D, 0x27FF, 0x0BFF, 0x0000 },
    { 0x0C, 0x27FF, 0x0401, 0x0000 },
    { 0x0C, 0x27FF, 0x0401, 0x0000 },
    { 0x0C, 0x27FF, 0x07FF, 0x0000 },
    { 0x0C, 0x27FF, 0x07FF, 0x0000 },
    { 0x0A, 0x27FF, 0xFE00, 0x0000 },
    { 0x0A, 0x27FF, 0xFE00, 0x0000 },
    { 0x0A, 0x27FF, 0xFE00, 0x0000 },
    { 0x0A, 0x27FF, 0xFE00, 0x0000 },
    { 0x0A, 0x27FF, 0xFE00, 0x0000 },
    { 0x0A, 0x27FF, 0xFE00, 0x0000 },
    { 0x0A, 0x27FF, 0xFE00, 0x0000 },
    { 0x0A, 0x27FF, 0xFE00, 0x0000 },
    { 0x0B, 0x27FF, 0x0001, 0x0000 },
    { 0x0B, 0x27FF, 0x0001, 0x0000 },
    { 0x0D, 0x27FF, 0x0001, 0xFE00 },
    { 0x0B, 0x27FF, 0x0001, 0x0000 },
    { 0x0B, 0x27FF, 0x03FF, 0x0000 },
    { 0x0B, 0x27FF, 0x03FF, 0x0000 },
    { 0x0D, 0x27FF, 0x03FF, 0xFE00 },
    { 0x0B, 0x27FF, 0x03FF, 0x0000 },
    { 0x08, 0x0004, 0x0000, 0x0000 },
    { 0x08, 0x0004, 0x0000, 0x0000 },
    { 0x08, 0x0004, 0x0000, 0x0000 },
    { 0x08, 0x0004, 0x0000, 0x0000 },
    { 0x08, 0x0004, 0x0000, 0x0000 },
    { 0x08, 0x0004, 0x0000, 0x0000 },
    { 0x08, 0x0004, 0x0000, 0x0000 },
    { 0x08, 0x0004, 0x0000, 0x0000 },
    { 0x0D, 0x0004, 0x0002, 0x0000 },
    { 0x0D, 0x0004, 0x03FE, 0x0000 },
    { 0x0D, 0x0004, 0x0801, 0x0000 },
    { 0x0D, 0x0004, 0x0BFF, 0x0000 },
    { 0x0C, 0x0004, 0x0401, 0x0000 },
    { 0x0C, 0x0004, 0x0401, 0x0000 },
    { 0x0C, 0x0004, 0x07FF, 0x0000 },
    { 0x0C, 0x0004, 0x07FF, 0x0000 },
    { 0x0A, 0x0004, 0xFE00, 0x0000 },
    { 0x0A, 0x0004, 0xFE00, 0x0000 },
    { 0x0A, 0x0004, 0xFE00, 0x0000 },
    { 0x0A, 0x0004, 0xFE00, 0x0000 },
    { 0x0A, 0x0004, 0xFE00, 0x0000 },
    { 0x0A, 0x0004, 0xFE00, 0x0000 },
    { 0x0A, 0x0004, 0xFE00, 0x0000 },
    { 0x0A, 0x0004, 0xFE00, 0x0000 },
    { 0x0B, 0x0004, 0x0001, 0x0000 },
    { 0x0B, 0x0004, 0x0001, 0x0000 },
    { 0x0D, 0x0004, 0x0001, 0xFE00 },
    { 0x0B, 0x0004, 0x0001, 0x0000 },
    { 0x0B, 0x0004, 0x03FF, 0x0000 },
    { 0x0B, 0x0004, 0x03FF, 0x0000 },
    { 0x0D, 0x0004, 0x03FF, 0xFE00 },
    { 0x0B, 0x0004, 0x03FF, 0x0000 },
    { 0x08, 0x03FC, 0x0000, 0x0000 },
    { 0x08, 0x03FC, 0x0000, 0x0000 },
    { 0x08, 0x03FC, 0x0000, 0x0000 },
    { 0x08, 0x03FC, 0x0000, 0x0000 },
    { 0x08, 0x03FC, 0x0000, 0x0000 },
    { 0x08, 0x03FC, 0x0000, 0x0000 },
    { 0x08, 0x03FC, 0x0000, 0x0000 },
    { 0x08, 0x03FC, 0x0000, 0x0000 },
    { 0x0D, 0x03FC, 0x0002, 0x0000 },
    { 0x0D, 0x03FC, 0x03FE, 0x0000 },
    { 0x0D, 0x03FC, 0x0801, 0x0000 },
    { 0x0D, 0x03FC, 0x0BFF, 0x0000 },
    { 0x0C, 0x03FC, 0x0401, 0x0000 },
    { 0x0C, 0x03FC, 0x0401, 0x0000 },
    { 0x0C, 0x03FC, 0x07FF, 0x0000 },
    { 0x0C, 0x03FC, 0x07FF, 0x0000 },
    { 0x0A, 0x03FC, 0xFE00, 0x0000 },
    { 0x0A, 0x03FC, 0xFE00, 0x0000 },
    { 0x0A, 0x03FC, 0xFE00, 0x0000 },
    { 0x0A, 0x03FC, 0xFE00, 0x0000 },
    { 0x0A, 0x03FC, 0xFE00, 0x0000 },
    { 0x0A, 0x03FC, 0xFE00, 0x0000 },
    { 0x0A, 0x03FC, 0xFE00, 0x0000 },
    { 0x0A, 0x03FC, 0xFE00, 0x0000 },
    { 0x0B, 0x03FC, 0x0001, 0x0000 },
    { 0x0B, 0x03FC, 0x0001, 0x0000 },
    { 0x0D, 0x03FC, 0x0001, 0xFE00 },
    { 0x0B, 0x03FC, 0x0001, 0x0000 },
    { 0x0B, 0x03FC, 0x03FF, 0x0000 },
    { 0x0B, 0x03FC, 0x03FF, 0x0000 },
    { 0x0D, 0x03FC, 0x03FF, 0xFE00 },
    { 0x0B, 0x03FC, 0x03FF, 0x0000 },
    { 0x08, 0x2001, 0x0000, 0x0000 },
    { 0x08, 0x2001, 0x0000, 0x0000 },
    { 0x08, 0x2001, 0x0000, 0x0000 },
    { 0x08, 0x2001, 0x0000, 0x0000 },
    { 0x08, 0x2001, 0x0000, 0x0000 },
    { 0x08, 0x2001, 0x0000, 0x0000 },
    { 0x08, 0x2001, 0x0000, 0x0000 },
    { 0x08, 0x2001, 0x0000, 0x0000 },
    { 0x0D, 0x2001, 0x0002, 0x0000 },
    { 0x0D, 0x2001, 0x03FE, 0x0000 },
    { 0x0D, 0x2001, 0x0801, 0x0000 },
    { 0x0D, 0x2001, 0x0BFF, 0x0000 },
    { 0x0C, 0x2001, 0x0401, 0x0000 },
    { 0x0C, 0x2001, 0x0401, 0x0000 },
    { 0x0C, 0x2001, 0x07FF, 0x0000 },
    { 0x0C, 0x2001, 0x07FF, 0x0000 },
    { 0x0A, 0x2001, 0xFE00, 0x0000 },
    { 0x0A, 0x2001, 0xFE00, 0x0000 },
    { 0x0A, 0x2001, 0xFE00, 0x0000 },
    { 0x0A, 0x2001, 0xFE00, 0x0000 },
    { 0x0A, 0x2001, 0xFE00, 0x0000 },
    { 0x0A, 0x2001, 0xFE00, 0x0000 },
    { 0x0A, 0x2001, 0xFE00, 0x0000 },
    { 0x0A, 0x2001, 0xFE00, 0x0000 },
    { 0x0B, 0x2001, 0x0001, 0x0000 },
    { 0x0B, 0x2001, 0x0001, 0x0000 },
    { 0x0D, 0x2001, 0x0001, 0xFE00 },
    { 0x0B, 0x2001, 0x0001, 0x0000 },
    { 0x0B, 0x2001, 0x03FF, 0x0000 },
    { 0x0B, 0x2001, 0x03FF, 0x0000 },
    { 0x0D, 0x2001, 0x03FF, 0xFE00 },
    { 0x0B, 0x2001, 0x03FF, 0x0000 },
    { 0x08, 0x23FF, 0x0000, 0x0000 },
    { 0x08, 0x23FF, 0x0000, 0x0000 },
    { 0x08, 0x23FF, 0x0000, 0x0000 },
    { 0x08, 0x23FF, 0x0000, 0x0000 },
    { 0x08, 0x23FF, 0x0000, 0x0000 },
    { 0x08, 0x23FF, 0x0000, 0x0000 },
    { 0x08, 0x23FF, 0x0000, 0x0000 },
    { 0x08, 0x23FF, 0x0000, 0x0000 },
    { 0x0D, 0x23FF, 0x0002, 0x0000 },
    { 0x0D, 0x23FF, 0x03FE, 0x0000 },
    { 0x0D, 0x23FF, 0x0801, 0x0000 },
    { 0x0D, 0x23FF, 0x0BFF, 0x0000 },
    { 0x0C, 0x23FF, 0x0401, 0x0000 },
    { 0x0C, 0x23FF, 0x0401, 0x0000 },
    { 0x0C, 0x23FF, 0x07FF, 0x0000 },
    { 0x0C, 0x23FF, 0x07FF, 0x0000 },
    { 0x0A, 0x23FF, 0xFE00, 0x0000 },
    { 0x0A, 0x23FF, 0xFE00, 0x0000 },
    { 0x0A, 0x23FF, 0xFE00, 0x0000 },
    { 0x0A, 0x23FF, 0xFE00, 0x0000 },
    { 0x0A, 0x23FF, 0xFE00, 0x0000 },
    { 0x0A, 0x23FF, 0xFE00, 0x0000 },
    { 0x0A, 0x23FF, 0xFE00, 0x0000 },
    { 0x0A, 0x23FF, 0xFE00, 0x0000 },
    { 0x0B, 0x23FF, 0x0001, 0x0000 },
    { 0x0B, 0x23FF, 0x0001, 0x0000 },
    { 0x0D, 0x23FF, 0x0001, 0xFE00 },
    { 0x0B, 0x23FF, 0x0001, 0x0000 },
    { 0x0B, 0x23FF, 0x03FF, 0x0000 },
    { 0x0B, 0x23FF, 0x03FF, 0x0000 },
    { 0x0D, 0x23FF, 0x03FF, 0xFE00 },
    { 0x0B, 0x23FF, 0x03FF, 0x0000 },
    { 0x07, 0x1C01, 0x0000, 0x0000 },
    { 0x0D, 0x1C01, 0x7C1F, 0x0000 },
    { 0x07, 0x1C01, 0x0000, 0x0000 },
    { 0x07, 0x1C01, 0x0000, 0x0000 },
    { 0x07, 0x1C01, 0x0000, 0x0000 },
    { 0x07, 0x1C01, 0x0000, 0x0000 },
    { 0x07, 0x1C01, 0x0000, 0x0000 },
    { 0x07, 0x1C01, 0x0000, 0x0000 },
    { 0x07, 0x1C01, 0x0000, 0x0000 },
    { 0x07, 0x1C01, 0x0000, 0x0000 },
    { 0x0D, 0x1C01, 0x0003, 0x0000 },
    { 0x0D, 0x1C01, 0x03FD, 0x0000 },
    { 0x0D, 0x1C01, 0x1001, 0x0000 },
    { 0x0D, 0x1C01, 0x13FF, 0x0000 },
    { 0x0D, 0x1C01, 0x0C01, 0x0000 },
    { 0x0D, 0x1C01, 0x0FFF, 0x0000 },
    { 0x0C, 0x1C01, 0x0002, 0x0000 },
    { 0x0C, 0x1C01, 0x0002, 0x0000 },
    { 0x0C, 0x1C01, 0x03FE, 0x0000 },
    { 0x0C, 0x1C01, 0x03FE, 0x0000 },
    { 0x0C, 0x1C01, 0x0801, 0x0000 },
    { 0x0C, 0x1C01, 0x0801, 0x0000 },
    { 0x0C, 0x1C01, 0x0BFF, 0x0000 },
    { 0x0C, 0x1C01, 0x0BFF, 0x0000 },
    { 0x0B, 0x1C01, 0x0401, 0x0000 },
    { 0x0B, 0x1C01, 0x0401, 0x0000 },
    { 0x0D, 0x1C01, 0x0401, 0xFE00 },
    { 0x0B, 0x1C01, 0x0401, 0x0000 },
    { 0x0B, 0x1C01, 0x07FF, 0x0000 },
    { 0x0B, 0x1C01, 0x07FF, 0x0000 },
    { 0x0D, 0x1C01, 0x07FF, 0xFE00 },
    { 0x0B, 0x1C01, 0x07FF, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x09, 0x1C01, 0xFE00, 0x0000 },
    { 0x0A, 0x1C01, 0x0001, 0x0000 },
    { 0x0A, 0x1C01, 0x0001, 0x0000 },
    { 0x0A, 0x1C01, 0x0001, 0x0000 },
    { 0x0A, 0x1C01, 0x0001, 0x0000 },
    { 0x0C, 0x1C01, 0x0001, 0xFE00 },
    { 0x0C, 0x1C01, 0x0001, 0xFE00 },
    { 0x0D, 0x1C01, 0x0001, 0x0001 },
    { 0x0D, 0x1C01, 0x0001, 0x03FF },
    { 0x0A, 0x1C01, 0x03FF, 0x0000 },
    { 0x0A, 0x1C01, 0x03FF, 0x0000 },
    { 0x0A, 0x1C01, 0x03FF, 0x0000 },
    { 0x0A, 0x1C01, 0x03FF, 0x0000 },
    { 0x0C, 0x1C01, 0x03FF, 0xFE00 },
    { 0x0C, 0x1C01, 0x03FF, 0xFE00 },
    { 0x0D, 0x1C01, 0x03FF, 0x0001 },
    { 0x0D, 0x1C01, 0x03FF, 0x03FF },
    { 0x07, 0x1FFF, 0x0000, 0x0000 },
    { 0x0D, 0x1FFF, 0x7C1F, 0x0000 },
    { 0x07, 0x1FFF, 0x0000, 0x0000 },
    { 0x07, 0x1FFF, 0x0000, 0x0000 },
    { 0x07, 0x1FFF, 0x0000, 0x0000 },
    { 0x07, 0x1FFF, 0x0000, 0x0000 },
    { 0x07, 0x1FFF, 0x0000, 0x0000 },
    { 0x07, 0x1FFF, 0x0000, 0x0000 },
    { 0x07, 0x1FFF, 0x0000, 0x0000 },
    { 0x07, 0x1FFF, 0x0000, 0x0000 },
    { 0x0D, 0x1FFF, 0x0003, 0x0000 },
    { 0x0D, 0x1FFF, 0x03FD, 0x0000 },
    { 0x0D, 0x1FFF, 0x1001, 0x0000 },
    { 0x0D, 0x1FFF, 0x13FF, 0x0000 },
    { 0x0D, 0x1FFF, 0x0C01, 0x0000 },
    { 0x0D, 0x1FFF, 0x0FFF, 0x0000 },
    { 0x0C, 0x1FFF, 0x0002, 0x0000 },
    { 0x0C, 0x1FFF, 0x0002, 0x0000 },
    { 0x0C, 0x1FFF, 0x03FE, 0x0000 },
    { 0x0C, 0x1FFF, 0x03FE, 0x0000 },
    { 0x0C, 0x1FFF, 0x0801, 0x0000 },
    { 0x0C, 0x1FFF, 0x0801, 0x0000 },
    { 0x0C, 0x1FFF, 0x0BFF, 0x0000 },
    { 0x0C, 0x1FFF, 0x0BFF, 0x0000 },
    { 0x0B, 0x1FFF, 0x0401, 0x0000 },
    { 0x0B, 0x1FFF, 0x0401, 0x0000 },
    { 0x0D, 0x1FFF, 0x0401, 0xFE00 },
    { 0x0B, 0x1FFF, 0x0401, 0x0000 },
    { 0x0B, 0x1FFF, 0x07FF, 0x0000 },
    { 0x0B, 0x1FFF, 0x07FF, 0x0000 },
    { 0x0D, 0x1FFF, 0x07FF, 0xFE00 },
    { 0x0B, 0x1FFF, 0x07FF, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x09, 0x1FFF, 0xFE00, 0x0000 },
    { 0x0A, 0x1FFF, 0x0001, 0x0000 },
    { 0x0A, 0x1FFF, 0x0001, 0x0000 },
    { 0x0A, 0x1FFF, 0x0001, 0x0000 },
    { 0x0A, 0x1FFF, 0x0001, 0x0000 },
    { 0x0C, 0x1FFF, 0x0001, 0xFE00 },
    { 0x0C, 0x1FFF, 0x0001, 0xFE00 },
    { 0x0D, 0x1FFF, 0x0001, 0x0001 },
    { 0x0D, 0x1FFF, 0x0001, 0x03FF },
    { 0x0A, 0x1FFF, 0x03FF, 0x0000 },
    { 0x0A, 0x1FFF, 0x03FF, 0x0000 },
    { 0x0A, 0x1FFF, 0x03FF, 0x0000 },
    { 0x0A, 0x1FFF, 0x03FF, 0x0000 },
    { 0x0C, 0x1FFF, 0x03FF, 0xFE00 },
    { 0x0C, 0x1FFF, 0x03FF, 0xFE00 },
    { 0x0D, 0x1FFF, 0x03FF, 0x0001 },
    { 0x0D, 0x1FFF, 0x03FF, 0x03FF },
    { 0x07, 0x1801, 0x0000, 0x0000 },
    { 0x0D, 0x1801, 0x7C1F, 0x0000 },
    { 0x07, 0x1801, 0x0000, 0x0000 },
    { 0x07, 0x1801, 0x0000, 0x0000 },
    { 0x07, 0x1801, 0x0000, 0x0000 },
    { 0x07, 0x1801, 0x0000, 0x0000 },
    { 0x07, 0x1801, 0x0000, 0x0000 },
    { 0x07, 0x1801, 0x0000, 0x0000 },
    { 0x07, 0x1801, 0x0000, 0x0000 },
    { 0x07, 0x1801, 0x0000, 0x0000 },
    { 0x0D, 0x1801, 0x0003, 0x0000 },
    { 0x0D, 0x1801, 0x03FD, 0x0000 },
    { 0x0D, 0x1801, 0x1001, 0x0000 },
    { 0x0D, 0x1801, 0x13FF, 0x0000 },
    { 0x0D, 0x1801, 0x0C01, 0x0000 },
    { 0x0D, 0x1801, 0x0FFF, 0x0000 },
    { 0x0C, 0x1801, 0x0002, 0x0000 },
    { 0x0C, 0x1801, 0x0002, 0x0000 },
    { 0x0C, 0x1801, 0x03FE, 0x0000 },
    { 0x0C, 0x1801, 0x03FE, 0x0000 },
    { 0x0C, 0x1801, 0x0801, 0x0000 },
    { 0x0C, 0x1801, 0x0801, 0x0000 },
    { 0x0C, 0x1801, 0x0BFF, 0x0000 },
    { 0x0C, 0x1801, 0x0BFF, 0x0000 },
    { 0x0B, 0x1801, 0x0401, 0x0000 },
    { 0x0B, 0x1801, 0x0401, 0x0000 },
    { 0x0D, 0x1801, 0x0401, 0xFE00 },
    { 0x0B, 0x1801, 0x0401, 0x0000 },
    { 0x0B, 0x1801, 0x07FF, 0x0000 },
    { 0x0B, 0x1801, 0x07FF, 0x0000 },
    { 0x0D, 0x1801, 0x07FF, 0xFE00 },
    { 0x0B, 0x1801, 0x07FF, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x09, 0x1801, 0xFE00, 0x0000 },
    { 0x0A, 0x1801, 0x0001, 0x0000 },
    { 0x0A, 0x1801, 0x0001, 0x0000 },
    { 0x0A, 0x1801, 0x0001, 0x0000 },
    { 0x0A, 0x1801, 0x0001, 0x0000 },
    { 0x0C, 0x1801, 0x0001, 0xFE00 },
    { 0x0C, 0x1801, 0x0001, 0xFE00 },
    { 0x0D, 0x1801, 0x0001, 0x0001 },
    { 0x0D, 0x1801, 0x0001, 0x03FF },
    { 0x0A, 0x1801, 0x03FF, 0x0000 },
    { 0x0A, 0x1801, 0x03FF, 0x0000 },
    { 0x0A, 0x1801, 0x03FF, 0x0000 },
    { 0x0A, 0x1801, 0x03FF, 0x0000 },
    { 0x0C, 0x1801, 0x03FF, 0xFE00 },
    { 0x0C, 0x1801, 0x03FF, 0xFE00 },
    { 0x0D, 0x1801, 0x03FF, 0x0001 },
    { 0x0D, 0x1801, 0x03FF, 0x03FF },
    { 0x07, 0x1BFF, 0x0000, 0x0000 },
    { 0x0D, 0x1BFF, 0x7C1F, 0x0000 },
    { 0x07, 0x1BFF, 0x0000, 0x0000 },
    { 0x07, 0x1BFF, 0x0000, 0x0000 },
    { 0x07, 0x1BFF, 0x0000, 0x0000 },
    { 0x07, 0x1BFF, 0x0000, 0x0000 },
    { 0x07, 0x1BFF, 0x0000, 0x0000 },
    { 0x07, 0x1BFF, 0x0000, 0x0000 },
    { 0x07, 0x1BFF, 0x0000, 0x0000 },
    { 0x07, 0x1BFF, 0x0000, 0x0000 },
    { 0x0D, 0x1BFF, 0x0003, 0x0000 },
    { 0x0D, 0x1BFF, 0x03FD, 0x0000 },
    { 0x0D, 0x1BFF, 0x1001, 0x0000 },
    { 0x0D, 0x1BFF, 0x13FF, 0x0000 },
    { 0x0D, 0x1BFF, 0x0C01, 0x0000 },
    { 0x0D, 0x1BFF, 0x0FFF, 0x0000 },
    { 0x0C, 0x1BFF, 0x0002, 0x0000 },
    { 0x0C, 0x1BFF, 0x0002, 0x0000 },
    { 0x0C, 0x1BFF, 0x03FE, 0x0000 },
    { 0x0C, 0x1BFF, 0x03FE, 0x0000 },
    { 0x0C, 0x1BFF, 0x0801, 0x0000 },
    { 0x0C, 0x1BFF, 0x0801, 0x0000 },
    { 0x0C, 0x1BFF, 0x0BFF, 0x0000 },
    { 0x0C, 0x1BFF, 0x0BFF, 0x0000 },
    { 0x0B, 0x1BFF, 0x0401, 0x0000 },
    { 0x0B, 0x1BFF, 0x0401, 0x0000 },
    { 0x0D, 0x1BFF, 0x0401, 0xFE00 },
    { 0x0B, 0x1BFF, 0x0401, 0x0000 },
    { 0x0B, 0x1BFF, 0x07FF, 0x0000 },
    { 0x0B, 0x1BFF, 0x07FF, 0x0000 },
    { 0x0D, 0x1BFF, 0x07FF, 0xFE00 },
    { 0x0B, 0x1BFF, 0x07FF, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x09, 0x1BFF, 0xFE00, 0x0000 },
    { 0x0A, 0x1BFF, 0x0001, 0x0000 },
    { 0x0A, 0x1BFF, 0x0001, 0x0000 },
    { 0x0A, 0x1BFF, 0x0001, 0x0000 },
    { 0x0A, 0x1BFF, 0x0001, 0x0000 },
    { 0x0C, 0x1BFF, 0x0001, 0xFE00 },
    { 0x0C, 0x1BFF, 0x0001, 0xFE00 },
    { 0x0D, 0x1BFF, 0x0001, 0x0001 },
    { 0x0D, 0x1BFF, 0x0001, 0x03FF },
    { 0x0A, 0x1BFF, 0x03FF, 0x0000 },
    { 0x0A, 0x1BFF, 0x03FF, 0x0000 },
    { 0x0A, 0x1BFF, 0x03FF, 0x0000 },
    { 0x0A, 0x1BFF, 0x03FF, 0x0000 },
    { 0x0C, 0x1BFF, 0x03FF, 0xFE00 },
    { 0x0C, 0x1BFF, 0x03FF, 0xFE00 },
    { 0x0D, 0x1BFF, 0x03FF, 0x0001 },
    { 0x0D, 0x1BFF, 0x03FF, 0x03FF },
    { 0x07, 0x0402, 0x0000, 0x0000 },
    { 0x0D, 0x0402, 0x7C1F, 0x0000 },
    { 0x07, 0x0402, 0x0000, 0x0000 },
    { 0x07, 0x0402, 0x0000, 0x0000 },
    { 0x07, 0x0402, 0x0000, 0x0000 },
    { 0x07, 0x0402, 0x0000, 0x0000 },
    { 0x07, 0x0402, 0x0000, 0x0000 },
    { 0x07, 0x0402, 0x0000, 0x0000 },
    { 0x07, 0x0402, 0x0000, 0x0000 },
    { 0x07, 0x0402, 0x0000, 0x0000 },
    { 0x0D, 0x0402, 0x0003, 0x0000 },
    { 0x0D, 0x0402, 0x03FD, 0x0000 },
    { 0x0D, 0x0402, 0x1001, 0x0000 },
    { 0x0D, 0x0402, 0x13FF, 0x0000 },
    { 0x0D, 0x0402, 0x0C01, 0x0000 },
    { 0x0D, 0x0402, 0x0FFF, 0x0000 },
    { 0x0C, 0x0402, 0x0002, 0x0000 },
    { 0x0C, 0x0402, 0x0002, 0x0000 },
    { 0x0C, 0x0402, 0x03FE, 0x0000 },
    { 0x0C, 0x0402, 0x03FE, 0x0000 },
    { 0x0C, 0x0402, 0x0801, 0x0000 },
    { 0x0C, 0x0402, 0x0801, 0x0000 },
    { 0x0C, 0x0402, 0x0BFF, 0x0000 },
    { 0x0C, 0x0402, 0x0BFF, 0x0000 },
    { 0x0B, 0x0402, 0x0401, 0x0000 },
    { 0x0B, 0x0402, 0x0401, 0x0000 },
    { 0x0D, 0x0402, 0x0401, 0xFE00 },
    { 0x0B, 0x0402, 0x0401, 0x0000 },
    { 0x0B, 0x0402, 0x07FF, 0x0000 },
    { 0x0B, 0x0402, 0x07FF, 0x0000 },
    { 0x0D, 0x0402, 0x07FF, 0xFE00 },
    { 0x0B, 0x0402, 0x07FF, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x09, 0x0402, 0xFE00, 0x0000 },
    { 0x0A, 0x0402, 0x0001, 0x0000 },
    { 0x0A, 0x0402, 0x0001, 0x0000 },
    { 0x0A, 0x0402, 0x0001, 0x0000 },
    { 0x0A, 0x0402, 0x0001, 0x0000 },
    { 0x0C, 0x0402, 0x0001, 0xFE00 },
    { 0x0C, 0x0402, 0x0001, 0xFE00 },
    { 0x0D, 0x0402, 0x0001, 0x0001 },
    { 0x0D, 0x0402, 0x0001, 0x03FF },
    { 0x0A, 0x0402, 0x03FF, 0x0000 },
    { 0x0A, 0x0402, 0x03FF, 0x0000 },
    { 0x0A, 0x0402, 0x03FF, 0x0000 },
    { 0x0A, 0x0402, 0x03FF, 0x0000 },
    { 0x0C, 0x0402, 0x03FF, 0xFE00 },
    { 0x0C, 0x0402, 0x03FF, 0xFE00 },
    { 0x0D, 0x0402, 0x03FF, 0x0001 },
    { 0x0D, 0x0402, 0x03FF, 0x03FF },
    { 0x07, 0x07FE, 0x0000, 0x0000 },
    { 0x0D, 0x07FE, 0x7C1F, 0x0000 },
    { 0x07, 0x07FE, 0x0000, 0x0000 },
    { 0x07, 0x07FE, 0x0000, 0x0000 },
    { 0x07, 0x07FE, 0x0000, 0x0000 },
    { 0x07, 0x07FE, 0x0000, 0x0000 },
    { 0x07, 0x07FE, 0x0000, 0x0000 },
    { 0x07, 0x07FE, 0x0000, 0x0000 },
    { 0x07, 0x07FE, 0x0000, 0x0000 },
    { 0x07, 0x07FE, 0x0000, 0x0000 },
    { 0x0D, 0x07FE, 0x0003, 0x0000 },
    { 0x0D, 0x07FE, 0x03FD, 0x0000 },
    { 0x0D, 0x07FE, 0x1001, 0x0000 },
    { 0x0D, 0x07FE, 0x13FF, 0x0000 },
    { 0x0D, 0x07FE, 0x0C01, 0x0000 },
    { 0x0D, 0x07FE, 0x0FFF, 0x0000 },
    { 0x0C, 0x07FE, 0x0002, 0x0000 },
    { 0x0C, 0x07FE, 0x0002, 0x0000 },
    { 0x0C, 0x07FE, 0x03FE, 0x0000 },
    { 0x0C, 0x07FE, 0x03FE, 0x0000 },
    { 0x0C, 0x07FE, 0x0801, 0x0000 },
    { 0x0C, 0x07FE, 0x0801, 0x0000 },
    { 0x0C, 0x07FE, 0x0BFF, 0x0000 },
    { 0x0C, 0x07FE, 0x0BFF, 0x0000 },
    { 0x0B, 0x07FE, 0x0401, 0x0000 },
    { 0x0B, 0x07FE, 0x0401, 0x0000 },
    { 0x0D, 0x07FE, 0x0401, 0xFE00 },
    { 0x0B, 0x07FE, 0x0401, 0x0000 },
    { 0x0B, 0x07FE, 0x07FF, 0x0000 },
    { 0x0B, 0x07FE, 0x07FF, 0x0000 },
    { 0x0D, 0x07FE, 0x07FF, 0xFE00 },
    { 0x0B, 0x07FE, 0x07FF, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x09, 0x07FE, 0xFE00, 0x0000 },
    { 0x0A, 0x07FE, 0x0001, 0x0000 },
    { 0x0A, 0x07FE, 0x0001, 0x0000 },
    { 0x0A, 0x07FE, 0x0001, 0x0000 },
    { 0x0A, 0x07FE, 0x0001, 0x0000 },
    { 0x0C, 0x07FE, 0x0001, 0xFE00 },
    { 0x0C, 0x07FE, 0x0001, 0xFE00 },
    { 0x0D, 0x07FE, 0x0001, 0x0001 },
    { 0x0D, 0x07FE, 0x0001, 0x03FF },
    { 0x0A, 0x07FE, 0x03FF, 0x0000 },
    { 0x0A, 0x07FE, 0x03FF, 0x0000 },
    { 0x0A, 0x07FE, 0x03FF, 0x0000 },
    { 0x0A, 0x07FE, 0x03FF, 0x0000 },
    { 0x0C, 0x07FE, 0x03FF, 0xFE00 },
    { 0x0C, 0x07FE, 0x03FF, 0xFE00 },
    { 0x0D, 0x07FE, 0x03FF, 0x0001 },
    { 0x0D, 0x07FE, 0x03FF, 0x03FF },
    { 0x07, 0x1401, 0x0000, 0x0000 },
    { 0x0D, 0x1401, 0x7C1F, 0x0000 },
    { 0x07, 0x1401, 0x0000, 0x0000 },
    { 0x07, 0x1401, 0x0000, 0x0000 },
    { 0x07, 0x1401, 0x0000, 0x0000 },
    { 0x07, 0x1401, 0x0000, 0x0000 },
    { 0x07, 0x1401, 0x0000, 0x0000 },
    { 0x07, 0x1401, 0x0000, 0x0000 },
    { 0x07, 0x1401, 0x0000, 0x0000 },
    { 0x07, 0x1401, 0x0000, 0x0000 },
    { 0x0D, 0x1401, 0x0003, 0x0000 },
    { 0x0D, 0x1401, 0x03FD, 0x0000 },
    { 0x0D, 0x1401, 0x1001, 0x0000 },
    { 0x0D, 0x1401, 0x13FF, 0x0000 },
    { 0x0D, 0x1401, 0x0C01, 0x0000 },
    { 0x0D, 0x1401, 0x0FFF, 0x0000 },
    { 0x0C, 0x1401, 0x0002, 0x0000 },
    { 0x0C, 0x1401, 0x0002, 0x0000 },
    { 0x0C, 0x1401, 0x03FE, 0x0000 },
    { 0x0C, 0x1401, 0x03FE, 0x0000 },
    { 0x0C, 0x1401, 0x0801, 0x0000 },
    { 0x0C, 0x1401, 0x0801, 0x0000 },
    { 0x0C, 0x1401, 0x0BFF, 0x0000 },
    { 0x0C, 0x1401, 0x0BFF, 0x0000 },
    { 0x0B, 0x1401, 0x0401, 0x0000 },
    { 0x0B, 0x1401, 0x0401, 0x0000 },
    { 0x0D, 0x1401, 0x0401, 0xFE00 },
    { 0x0B, 0x1401, 0x0401, 0x0000 },
    { 0x0B, 0x1401, 0x07FF, 0x0000 },
    { 0x0B, 0x1401, 0x07FF, 0x0000 },
    { 0x0D, 0x1401, 0x07FF, 0xFE00 },
    { 0x0B, 0x1401, 0x07FF, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x09, 0x1401, 0xFE00, 0x0000 },
    { 0x0A, 0x1401, 0x0001, 0x0000 },
    { 0x0A, 0x1401, 0x0001, 0x0000 },
    { 0x0A, 0x1401, 0x0001, 0x0000 },
    { 0x0A, 0x1401, 0x0001, 0x0000 },
    { 0x0C, 0x1401, 0x0001, 0xFE00 },
    { 0x0C, 0x1401, 0x0001, 0xFE00 },
    { 0x0D, 0x1401, 0x0001, 0x0001 },
    { 0x0D, 0x1401, 0x0001, 0x03FF },
    { 0x0A, 0x1401, 0x03FF, 0x0000 },
    { 0x0A, 0x1401, 0x03FF, 0x0000 },
    { 0x0A, 0x1401, 0x03FF, 0x0000 },
    { 0x0A, 0x1401, 0x03FF, 0x0000 },
    { 0x0C, 0x1401, 0x03FF, 0xFE00 },
    { 0x0C, 0x1401, 0x03FF, 0xFE00 },
    { 0x0D, 0x1401, 0x03FF, 0x0001 },
    { 0x0D, 0x1401, 0x03FF, 0x03FF },
    { 0x07, 0x17FF, 0x0000, 0x0000 },
    { 0x0D, 0x17FF, 0x7C1F, 0x0000 },
    { 0x07, 0x17FF, 0x0000, 0x0000 },
    { 0x07, 0x17FF, 0x0000, 0x0000 },
    { 0x07, 0x17FF, 0x0000, 0x0000 },
    { 0x07, 0x17FF, 0x0000, 0x0000 },
    { 0x07, 0x17FF, 0x0000, 0x0000 },
    { 0x07, 0x17FF, 0x0000, 0x0000 },
    { 0x07, 0x17FF, 0x0000, 0x0000 },
    { 0x07, 0x17FF, 0x0000, 0x0000 },
    { 0x0D, 0x17FF, 0x0003, 0x0000 },
    { 0x0D, 0x17FF, 0x03FD, 0x0000 },
    { 0x0D, 0x17FF, 0x1001, 0x0000 },
    { 0x0D, 0x17FF, 0x13FF, 0x0000 },
    { 0x0D, 0x17FF, 0x0C01, 0x0000 },
    { 0x0D, 0x17FF, 0x0FFF, 0x0000 },
    { 0x0C, 0x17FF, 0x0002, 0x0000 },
    { 0x0C, 0x17FF, 0x0002, 0x0000 },
    { 0x0C, 0x17FF, 0x03FE, 0x0000 },
    { 0x0C, 0x17FF, 0x03FE, 0x0000 },
    { 0x0C, 0x17FF, 0x0801, 0x0000 },
    { 0x0C, 0x17FF, 0x0801, 0x0000 },
    { 0x0C, 0x17FF, 0x0BFF, 0x0000 },
    { 0x0C, 0x17FF, 0x0BFF, 0x0000 },
    { 0x0B, 0x17FF, 0x0401, 0x0000 },
    { 0x0B, 0x17FF, 0x0401, 0x0000 },
    { 0x0D, 0x17FF, 0x0401, 0xFE00 },
    { 0x0B, 0x17FF, 0x0401, 0x0000 },
    { 0x0B, 0x17FF, 0x07FF, 0x0000 },
    { 0x0B, 0x17FF, 0x07FF, 0x0000 },
    { 0x0D, 0x17FF, 0x07FF, 0xFE00 },
    { 0x0B, 0x17FF, 0x07FF, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x09, 0x17FF, 0xFE00, 0x0000 },
    { 0x0A, 0x17FF, 0x0001, 0x0000 },
    { 0x0A, 0x17FF, 0x0001, 0x0000 },
    { 0x0A, 0x17FF, 0x0001, 0x0000 },
    { 0x0A, 0x17FF, 0x0001, 0x0000 },
    { 0x0C, 0x17FF, 0x0001, 0xFE00 },
    { 0x0C, 0x17FF, 0x0001, 0xFE00 },
    { 0x0D, 0x17FF, 0x0001, 0x0001 },
    { 0x0D, 0x17FF, 0x0001, 0x03FF },
    { 0x0A, 0x17FF, 0x03FF, 0x0000 },
    { 0x0A, 0x17FF, 0x03FF, 0x0000 },
    { 0x0A, 0x17FF, 0x03FF, 0x0000 },
    { 0x0A, 0x17FF, 0x03FF, 0x0000 },
    { 0x0C, 0x17FF, 0x03FF, 0xFE00 },
    { 0x0C, 0x17FF, 0x03FF, 0xFE00 },
    { 0x0D, 0x17FF, 0x03FF, 0x0001 },
    { 0x0D, 0x17FF, 0x03FF, 0x03FF },
    { 0x09, 0x3401, 0x0000, 0x0000 },
    { 0x09, 0x3401, 0x0000, 0x0000 },
    { 0x09, 0x3401, 0x0000, 0x0000 },
    { 0x09, 0x3401, 0x0000, 0x0000 },
    { 0x09, 0x3401, 0x0000, 0x0000 },
    { 0x09, 0x3401, 0x0000, 0x0000 },
    { 0x0D, 0x3401, 0x0401, 0x0000 },
    { 0x0D, 0x3401, 0x07FF, 0x0000 },
    { 0x0B, 0x3401, 0xFE00, 0x0000 },
    { 0x0B, 0x3401, 0xFE00, 0x0000 },
    { 0x0B, 0x3401, 0xFE00, 0x0000 },
    { 0x0B, 0x3401, 0xFE00, 0x0000 },
    { 0x0C, 0x3401, 0x0001, 0x0000 },
    { 0x0C, 0x3401, 0x0001, 0x0000 },
    { 0x0C, 0x3401, 0x03FF, 0x0000 },
    { 0x0C, 0x3401, 0x03FF, 0x0000 },
    { 0x09, 0x37FF, 0x0000, 0x0000 },
    { 0x09, 0x37FF, 0x0000, 0x0000 },
    { 0x09, 0x37FF, 0x0000, 0x0000 },
    { 0x09, 0x37FF, 0x0000, 0x0000 },
    { 0x09, 0x37FF, 0x0000, 0x0000 },
    { 0x09, 0x37FF, 0x0000, 0x0000 },
    { 0x0D, 0x37FF, 0x0401, 0x0000 },
    { 0x0D, 0x37FF, 0x07FF, 0x0000 },
    { 0x0B, 0x37FF, 0xFE00, 0x0000 },
    { 0x0B, 0x37FF, 0xFE00, 0x0000 },
    { 0x0B, 0x37FF, 0xFE00, 0x0000 },
    { 0x0B, 0x37FF, 0xFE00, 0x0000 },
    { 0x0C, 0x37FF, 0x0001, 0x0000 },
    { 0x0C, 0x37FF, 0x0001, 0x0000 },
    { 0x0C, 0x37FF, 0x03FF, 0x0000 },
    { 0x0C, 0x37FF, 0x03FF, 0x0000 },
    { 0x09, 0x0006, 0x0000, 0x0000 },
    { 0x09, 0x0006, 0x0000, 0x0000 },
    { 0x09, 0x0006, 0x0000, 0x0000 },
    { 0x09, 0x0006, 0x0000, 0x0000 },
    { 0x09, 0x0006, 0x0000, 0x0000 },
    { 0x09, 0x0006, 0x0000, 0x0000 },
    { 0x0D, 0x0006, 0x0401, 0x0000 },
    { 0x0D, 0x0006, 0x07FF, 0x0000 },
    { 0x0B, 0x0006, 0xFE00, 0x0000 },
    { 0x0B, 0x0006, 0xFE00, 0x0000 },
    { 0x0B, 0x0006, 0xFE00, 0x0000 },
    { 0x0B, 0x0006, 0xFE00, 0x0000 },
    { 0x0C, 0x0006, 0x0001, 0x0000 },
    { 0x0C, 0x0006, 0x0001, 0x0000 },
    { 0x0C, 0x0006, 0x03FF, 0x0000 },
    { 0x0C, 0x0006, 0x03FF, 0x0000 },
    { 0x09, 0x03FA, 0x0000, 0x0000 },
    { 0x09, 0x03FA, 0x0000, 0x0000 },
    { 0x09, 0x03FA, 0x0000, 0x0000 },
    { 0x09, 0x03FA, 0x0000, 0x0000 },
    { 0x09, 0x03FA, 0x0000, 0x0000 },
    { 0x09, 0x03FA, 0x0000, 0x0000 },
    { 0x0D, 0x03FA, 0x0401, 0x0000 },
    { 0x0D, 0x03FA, 0x07FF, 0x0000 },
    { 0x0B, 0x03FA, 0xFE00, 0x0000 },
    { 0x0B, 0x03FA, 0xFE00, 0x0000 },
    { 0x0B, 0x03FA, 0xFE00, 0x0000 },
    { 0x0B, 0x03FA, 0xFE00, 0x0000 },
    { 0x0C, 0x03FA, 0x0001, 0x0000 },
    { 0x0C, 0x03FA, 0x0001, 0x0000 },
    { 0x0C, 0x03FA, 0x03FF, 0x0000 },
    { 0x0C, 0x03FA, 0x03FF, 0x0000 },
    { 0x09, 0x3001, 0x0000, 0x0000 },
    { 0x09, 0x3001, 0x0000, 0x0000 },
    { 0x09, 0x3001, 0x0000, 0x0000 },
    { 0x09, 0x3001, 0x0000, 0x0000 },
    { 0x09, 0x3001, 0x0000, 0x0000 },
    { 0x09, 0x3001, 0x0000, 0x0000 },
    { 0x0D, 0x3001, 0x0401, 0x0000 },
    { 0x0D, 0x3001, 0x07FF, 0x0000 },
    { 0x0B, 0x3001, 0xFE00, 0x0000 },
    { 0x0B, 0x3001, 0xFE00, 0x0000 },
    { 0x0B, 0x3001, 0xFE00, 0x0000 },
    { 0x0B, 0x3001, 0xFE00, 0x0000 },
    { 0x0C, 0x3001, 0x0001, 0x0000 },
    { 0x0C, 0x3001, 0x0001, 0x0000 },
    { 0x0C, 0x3001, 0x03FF, 0x0000 },
    { 0x0C, 0x3001, 0x03FF, 0x0000 },
    { 0x09, 0x33FF, 0x0000, 0x0000 },
    { 0x09, 0x33FF, 0x0000, 0x0000 },
    { 0x09, 0x33FF, 0x0000, 0x0000 },
    { 0x09, 0x33FF, 0x0000, 0x0000 },
    { 0x09, 0x33FF, 0x0000, 0x0000 },
    { 0x09, 0x33FF, 0x0000, 0x0000 },
    { 0x0D, 0x33FF, 0x0401, 0x0000 },
    { 0x0D, 0x33FF, 0x07FF, 0x0000 },
    { 0x0B, 0x33FF, 0xFE00, 0x0000 },
    { 0x0B, 0x33FF, 0xFE00, 0x0000 },
    { 0x0B, 0x33FF, 0xFE00, 0x0000 },
    { 0x0B, 0x33FF, 0xFE00, 0x0000 },
    { 0x0C, 0x33FF, 0x0001, 0x0000 },
    { 0x0C, 0x33FF, 0x0001, 0x0000 },
    { 0x0C, 0x33FF, 0x03FF, 0x0000 },
    { 0x0C, 0x33FF, 0x03FF, 0x0000 },
    { 0x09, 0x2C01, 0x0000, 0x0000 },
    { 0x09, 0x2C01, 0x0000, 0x0000 },
    { 0x09, 0x2C01, 0x0000, 0x0000 },
    { 0x09, 0x2C01, 0x0000, 0x0000 },
    { 0x09, 0x2C01, 0x0000, 0x0000 },
    { 0x09, 0x2C01, 0x0000, 0x0000 },
    { 0x0D, 0x2C01, 0x0401, 0x0000 },
    { 0x0D, 0x2C01, 0x07FF, 0x0000 },
    { 0x0B, 0x2C01, 0xFE00, 0x0000 },
    { 0x0B, 0x2C01, 0xFE00, 0x0000 },
    { 0x0B, 0x2C01, 0xFE00, 0x0000 },
    { 0x0B, 0x2C01, 0xFE00, 0x0000 },
    { 0x0C, 0x2C01, 0x0001, 0x0000 },
    { 0x0C, 0x2C01, 0x0001, 0x0000 },
    { 0x0C, 0x2C01, 0x03FF, 0x0000 },
    { 0x0C, 0x2C01, 0x03FF, 0x0000 },
    { 0x09, 0x2FFF, 0x0000, 0x0000 },
    { 0x09, 0x2FFF, 0x0000, 0x0000 },
    { 0x09, 0x2FFF, 0x0000, 0x0000 },
    { 0x09, 0x2FFF, 0x0000, 0x0000 },
    { 0x09, 0x2FFF, 0x0000, 0x0000 },
    { 0x09, 0x2FFF, 0x0000, 0x0000 },
    { 0x0D, 0x2FFF, 0x0401, 0x0000 },
    { 0x0D, 0x2FFF, 0x07FF, 0x0000 },
    { 0x0B, 0x2FFF, 0xFE00, 0x0000 },
    { 0x0B, 0x2FFF, 0xFE00, 0x0000 },
    { 0x0B, 0x2FFF, 0xFE00, 0x0000 },
    { 0x0B, 0x2FFF, 0xFE00, 0x0000 },
    { 0x0C, 0x2FFF, 0x0001, 0x0000 },
    { 0x0C, 0x2FFF, 0x0001, 0x0000 },
    { 0x0C, 0x2FFF, 0x03FF, 0x0000 },
    { 0x0C, 0x2FFF, 0x03FF, 0x0000 },
    { 0x09, 0x0C02, 0x0000, 0x0000 },
    { 0x09, 0x0C02, 0x0000, 0x0000 },
    { 0x09, 0x0C02, 0x0000, 0x0000 },
    { 0x09, 0x0C02, 0x0000, 0x0000 },
    { 0x09, 0x0C02, 0x0000, 0x0000 },
    { 0x09, 0x0C02, 0x0000, 0x0000 },
    { 0x0D, 0x0C02, 0x0401, 0x0000 },
    { 0x0D, 0x0C02, 0x07FF, 0x0000 },
    { 0x0B, 0x0C02, 0xFE00, 0x0000 },
    { 0x0B, 0x0C02, 0xFE00, 0x0000 },
    { 0x0B, 0x0C02, 0xFE00, 0x0000 },
    { 0x0B, 0x0C02, 0xFE00, 0x0000 },
    { 0x0C, 0x0C02, 0x0001, 0x0000 },
    { 0x0C, 0x0C02, 0x0001, 0x0000 },
    { 0x0C, 0x0C02, 0x03FF, 0x0000 },
    { 0x0C, 0x0C02, 0x03FF, 0x0000 },
    { 0x09, 0x0FFE, 0x0000, 0x0000 },
    { 0x09, 0x0FFE, 0x0000, 0x0000 },
    { 0x09, 0x0FFE, 0x0000, 0x0000 },
    { 0x09, 0x0FFE, 0x0000, 0x0000 },
    { 0x09, 0x0FFE, 0x0000, 0x0000 },
    { 0x09, 0x0FFE, 0x0000, 0x0000 },
    { 0x0D, 0x0FFE, 0x0401, 0x0000 },
    { 0x0D, 0x0FFE, 0x07FF, 0x0000 },
    { 0x0B, 0x0FFE, 0xFE00, 0x0000 },
    { 0x0B, 0x0FFE, 0xFE00, 0x0000 },
    { 0x0B, 0x0FFE, 0xFE00, 0x0000 },
    { 0x0B, 0x0FFE, 0xFE00, 0x0000 },
    { 0x0C, 0x0FFE, 0x0001, 0x0000 },
    { 0x0C, 0x0FFE, 0x0001, 0x0000 },
    { 0x0C, 0x0FFE, 0x03FF, 0x0000 },
    { 0x0C, 0x0FFE, 0x03FF, 0x0000 },
    { 0x09, 0x0403, 0x0000, 0x0000 },
    { 0x09, 0x0403, 0x0000, 0x0000 },
    { 0x09, 0x0403, 0x0000, 0x0000 },
    { 0x09, 0x0403, 0x0000, 0x0000 },
    { 0x09, 0x0403, 0x0000, 0x0000 },
    { 0x09, 0x0403, 0x0000, 0x0000 },
    { 0x0D, 0x0403, 0x0401, 0x0000 },
    { 0x0D, 0x0403, 0x07FF, 0x0000 },
    { 0x0B, 0x0403, 0xFE00, 0x0000 },
    { 0x0B, 0x0403, 0xFE00, 0x0000 },
    { 0x0B, 0x0403, 0xFE00, 0x0000 },
    { 0x0B, 0x0403, 0xFE00, 0x0000 },
    { 0x0C, 0x0403, 0x0001, 0x0000 },
    { 0x0C, 0x0403, 0x0001, 0x0000 },
    { 0x0C, 0x0403, 0x03FF, 0x0000 },
    { 0x0C, 0x0403, 0x03FF, 0x0000 },
    { 0x09, 0x07FD, 0x0000, 0x0000 },
    { 0x09, 0x07FD, 0x0000, 0x0000 },
    { 0x09, 0x07FD, 0x0000, 0x0000 },
    { 0x09, 0x07FD, 0x0000, 0x0000 },
    { 0x09, 0x07FD, 0x0000, 0x0000 },
    { 0x09, 0x07FD, 0x0000, 0x0000 },
    { 0x0D, 0x07FD, 0x0401, 0x0000 },
    { 0x0D, 0x07FD, 0x07FF, 0x0000 },
    { 0x0B, 0x07FD, 0xFE00, 0x0000 },
    { 0x0B, 0x07FD, 0xFE00, 0x0000 },
    { 0x0B, 0x07FD, 0xFE00, 0x0000 },
    { 0x0B, 0x07FD, 0xFE00, 0x0000 },
    { 0x0C, 0x07FD, 0x0001, 0x0000 },
    { 0x0C, 0x07FD, 0x0001, 0x0000 },
    { 0x0C, 0x07FD, 0x03FF, 0x0000 },
    { 0x0C, 0x07FD, 0x03FF, 0x0000 },
    { 0x09, 0x0005, 0x0000, 0x0000 },
    { 0x09, 0x0005, 0x0000, 0x0000 },
    { 0x09, 0x0005, 0x0000, 0x0000 },
    { 0x09, 0x0005, 0x0000, 0x0000 },
    { 0x09, 0x0005, 0x0000, 0x0000 },
    { 0x09, 0x0005, 0x0000, 0x0000 },
    { 0x0D, 0x0005, 0x0401, 0x0000 },
    { 0x0D, 0x0005, 0x07FF, 0x0000 },
    { 0x0B, 0x0005, 0xFE00, 0x0000 },
    { 0x0B, 0x0005, 0xFE00, 0x0000 },
    { 0x0B, 0x0005, 0xFE00, 0x0000 },
    { 0x0B, 0x0005, 0xFE00, 0x0000 },
    { 0x0C, 0x0005, 0x0001, 0x0000 },
    { 0x0C, 0x0005, 0x0001, 0x0000 },
    { 0x0C, 0x0005, 0x03FF, 0x0000 },
    { 0x0C, 0x0005, 0x03FF, 0x0000 },
    { 0x09, 0x03FB, 0x0000, 0x0000 },
    { 0x09, 0x03FB, 0x0000, 0x0000 },
    { 0x09, 0x03FB, 0x0000, 0x0000 },
    { 0x09, 0x03FB, 0x0000, 0x0000 },
    { 0x09, 0x03FB, 0x0000, 0x0000 },
    { 0x09, 0x03FB, 0x0000, 0x0000 },
    { 0x0D, 0x03FB, 0x0401, 0x0000 },
    { 0x0D, 0x03FB, 0x07FF, 0x0000 },
    { 0x0B, 0x03FB, 0xFE00, 0x0000 },
    { 0x0B, 0x03FB, 0xFE00, 0x0000 },
    { 0x0B, 0x03FB, 0xFE00, 0x0000 },
    { 0x0B, 0x03FB, 0xFE00, 0x0000 },
    { 0x0C, 0x03FB, 0x0001, 0x0000 },
    { 0x0C, 0x03FB, 0x0001, 0x0000 },
    { 0x0C, 0x03FB, 0x03FF, 0x0000 },
    { 0x0C, 0x03FB, 0x03FF, 0x0000 },
    { 0x09, 0x2801, 0x0000, 0x0000 },
    { 0x09, 0x2801, 0x0000, 0x0000 },
    { 0x09, 0x2801, 0x0000, 0x0000 },
    { 0x09, 0x2801, 0x0000, 0x0000 },
    { 0x09, 0x2801, 0x0000, 0x0000 },
    { 0x09, 0x2801, 0x0000, 0x0000 },
    { 0x0D, 0x2801, 0x0401, 0x0000 },
    { 0x0D, 0x2801, 0x07FF, 0x0000 },
    { 0x0B, 0x2801, 0xFE00, 0x0000 },
    { 0x0B, 0x2801, 0xFE00, 0x0000 },
    { 0x0B, 0x2801, 0xFE00, 0x0000 },
    { 0x0B, 0x2801, 0xFE00, 0x0000 },
    { 0x0C, 0x2801, 0x0001, 0x0000 },
    { 0x0C, 0x2801, 0x0001, 0x0000 },
    { 0x0C, 0x2801, 0x03FF, 0x0000 },
    { 0x0C, 0x2801, 0x03FF, 0x0000 },
    { 0x09, 0x2BFF, 0x0000, 0x0000 },
    { 0x09, 0x2BFF, 0x0000, 0x0000 },
    { 0x09, 0x2BFF, 0x0000, 0x0000 },
    { 0x09, 0x2BFF, 0x0000, 0x0000 },
    { 0x09, 0x2BFF, 0x0000, 0x0000 },
    { 0x09, 0x2BFF, 0x0000, 0x0000 },
    { 0x0D, 0x2BFF, 0x0401, 0x0000 },
    { 0x0D, 0x2BFF, 0x07FF, 0x0000 },
    { 0x0B, 0x2BFF, 0xFE00, 0x0000 },
    { 0x0B, 0x2BFF, 0xFE00, 0x0000 },
    { 0x0B, 0x2BFF, 0xFE00, 0x0000 },
    { 0x0B, 0x2BFF, 0xFE00, 0x0000 },
    { 0x0C, 0x2BFF, 0x0001, 0x0000 },
    { 0x0C, 0x2BFF, 0x0001, 0x0000 },
    { 0x0C, 0x2BFF, 0x03FF, 0x0000 },
    { 0x0C, 0x2BFF, 0x03FF, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x0C, 0x0003, 0x7C1F, 0x0000 },
    { 0x0C, 0x0003, 0x7C1F, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x0D, 0x0003, 0x1C01, 0x0000 },
    { 0x0D, 0x0003, 0x1FFF, 0x0000 },
    { 0x0D, 0x0003, 0x1801, 0x0000 },
    { 0x0D, 0x0003, 0x1BFF, 0x0000 },
    { 0x0D, 0x0003, 0x0402, 0x0000 },
    { 0x0D, 0x0003, 0x07FE, 0x0000 },
    { 0x0D, 0x0003, 0x1401, 0x0000 },
    { 0x0D, 0x0003, 0x17FF, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x06, 0x0003, 0x0000, 0x0000 },
    { 0x0C, 0x0003, 0x0003, 0x0000 },
    { 0x0C, 0x0003, 0x0003, 0x0000 },
    { 0x0C, 0x0003, 0x03FD, 0x0000 },
    { 0x0C, 0x0003, 0x03FD, 0x0000 },
    { 0x0C, 0x0003, 0x1001, 0x0000 },
    { 0x0C, 0x0003, 0x1001, 0x0000 },
    { 0x0C, 0x0003, 0x13FF, 0x0000 },
    { 0x0C, 0x0003, 0x13FF, 0x0000 },
    { 0x0C, 0x0003, 0x0C01, 0x0000 },
    { 0x0C, 0x0003, 0x0C01, 0x0000 },
    { 0x0C, 0x0003, 0x0FFF, 0x0000 },
    { 0x0C, 0x0003, 0x0FFF, 0x0000 },
    { 0x0B, 0x0003, 0x0002, 0x0000 },
    { 0x0B, 0x0003, 0x0002, 0x0000 },
    { 0x0D, 0x0003, 0x0002, 0xFE00 },
    { 0x0B, 0x0003, 0x0002, 0x0000 },
    { 0x0B, 0x0003, 0x03FE, 0x0000 },
    { 0x0B, 0x0003, 0x03FE, 0x0000 },
    { 0x0D, 0x0003, 0x03FE, 0xFE00 },
    { 0x0B, 0x0003, 0x03FE, 0x0000 },
    { 0x0B, 0x0003, 0x0801, 0x0000 },
    { 0x0B, 0x0003, 0x0801, 0x0000 },
    { 0x0D, 0x0003, 0x0801, 0xFE00 },
    { 0x0B, 0x0003, 0x0801, 0x0000 },
    { 0x0B, 0x0003, 0x0BFF, 0x0000 },
    { 0x0B, 0x0003, 0x0BFF, 0x0000 },
    { 0x0D, 0x0003, 0x0BFF, 0xFE00 },
    { 0x0B, 0x0003, 0x0BFF, 0x0000 },
    { 0x0A, 0x0003, 0x0401, 0x0000 },
    { 0x0A, 0x0003, 0x0401, 0x0000 },
    { 0x0A, 0x0003, 0x0401, 0x0000 },
    { 0x0A, 0x0003, 0x0401, 0x0000 },
    { 0x0C, 0x0003, 0x0401, 0xFE00 },
    { 0x0C, 0x0003, 0x0401, 0xFE00 },
    { 0x0D, 0x0003, 0x0401, 0x0001 },
    { 0x0D, 0x0003, 0x0401, 0x03FF },
    { 0x0A, 0x0003, 0x07FF, 0x0000 },
    { 0x0A, 0x0003, 0x07FF, 0x0000 },
    { 0x0A, 0x0003, 0x07FF, 0x0000 },
    { 0x0A, 0x0003, 0x07FF, 0x0000 },
    { 0x0C, 0x0003, 0x07FF, 0xFE00 },
    { 0x0C, 0x0003, 0x07FF, 0xFE00 },
    { 0x0D, 0x0003, 0x07FF, 0x0001 },
    { 0x0D, 0x0003, 0x07FF, 0x03FF },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x08, 0x0003, 0xFE00, 0x0000 },
    { 0x09, 0x0003, 0x0001, 0x0000 },
    { 0x09, 0x0003, 0x0001, 0x0000 },
    { 0x09, 0x0003, 0x0001, 0x0000 },
    { 0x09, 0x0003, 0x0001, 0x0000 },
    { 0x09, 0x0003, 0x0001, 0x0000 },
    { 0x09, 0x0003, 0x0001, 0x0000 },
    { 0x0D, 0x0003, 0x0001, 0x0401 },
    { 0x0D, 0x0003, 0x0001, 0x07FF },
    { 0x0B, 0x0003, 0x0001, 0xFE00 },
    { 0x0B, 0x0003, 0x0001, 0xFE00 },
    { 0x0B, 0x0003, 0x0001, 0xFE00 },
    { 0x0B, 0x0003, 0x0001, 0xFE00 },
    { 0x0C, 0x0003, 0x0001, 0x0001 },
    { 0x0C, 0x0003, 0x0001, 0x0001 },
    { 0x0C, 0x0003, 0x0001, 0x03FF },
    { 0x0C, 0x0003, 0x0001, 0x03FF },
    { 0x09, 0x0003, 0x03FF, 0x0000 },
    { 0x09, 0x0003, 0x03FF, 0x0000 },
    { 0x09, 0x0003, 0x03FF, 0x0000 },
    { 0x09, 0x0003, 0x03FF, 0x0000 },
    { 0x09, 0x0003, 0x03FF, 0x0000 },
    { 0x09, 0x0003, 0x03FF, 0x0000 },
    { 0x0D, 0x0003, 0x03FF, 0x0401 },
    { 0x0D, 0x0003, 0x03FF, 0x07FF },
    { 0x0B, 0x0003, 0x03FF, 0xFE00 },
    { 0x0B, 0x0003, 0x03FF, 0xFE00 },
    { 0x0B, 0x0003, 0x03FF, 0xFE00 },
    { 0x0B, 0x0003, 0x03FF, 0xFE00 },
    { 0x0C, 0x0003, 0x03FF, 0x0001 },
    { 0x0C, 0x0003, 0x03FF, 0x0001 },
    { 0x0C, 0x0003, 0x03FF, 0x03FF },
    { 0x0C, 0x0003, 0x03FF, 0x03FF },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x0C, 0x03FD, 0x7C1F, 0x0000 },
    { 0x0C, 0x03FD, 0x7C1F, 0x0000 },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x0D, 0x03FD, 0x1C01, 0x0000 },
    { 0x0D, 0x03FD, 0x1FFF, 0x0000 },
    { 0x0D, 0x03FD, 0x1801, 0x0000 },
    { 0x0D, 0x03FD, 0x1BFF, 0x0000 },
    { 0x0D, 0x03FD, 0x0402, 0x0000 },
    { 0x0D, 0x03FD, 0x07FE, 0x0000 },
    { 0x0D, 0x03FD, 0x1401, 0x0000 },
    { 0x0D, 0x03FD, 0x17FF, 0x0000 },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x06, 0x03FD, 0x0000, 0x0000 },
    { 0x0C, 0x03FD, 0x0003, 0x0000 },
    { 0x0C, 0x03FD, 0x0003, 0x0000 },
    { 0x0C, 0x03FD, 0x03FD, 0x0000 },
    { 0x0C, 0x03FD, 0x03FD, 0x0000 },
    { 0x0C, 0x03FD, 0x1001, 0x0000 },
    { 0x0C, 0x03FD, 0x1001, 0x0000 },
    { 0x0C, 0x03FD, 0x13FF, 0x0000 },
    { 0x0C, 0x03FD, 0x13FF, 0x0000 },
    { 0x0C, 0x03FD, 0x0C01, 0x0000 },
    { 0x0C, 0x03FD, 0x0C01, 0x0000 },
    { 0x0C, 0x03FD, 0x0FFF, 0x0000 },
    { 0x0C, 0x03FD, 0x0FFF, 0x0000 },
    { 0x0B, 0x03FD, 0x0002, 0x0000 },
    { 0x0B, 0x03FD, 0x0002, 0x0000 },
    { 0x0D, 0x03FD, 0x0002, 0xFE00 },
    { 0x0B, 0x03FD, 0x0002, 0x0000 },
    { 0x0B, 0x03FD, 0x03FE, 0x0000 },
    { 0x0B, 0x03FD, 0x03FE, 0x0000 },
    { 0x0D, 0x03FD, 0x03FE, 0xFE00 },
    { 0x0B, 0x03FD, 0x03FE, 0x0000 },
    { 0x0B, 0x03FD, 0x0801, 0x0000 },
    { 0x0B, 0x03FD, 0x0801, 0x0000 },
    { 0x0D, 0x03FD, 0x0801, 0xFE00 },
    { 0x0B, 0x03FD, 0x0801, 0x0000 },
    { 0x0B, 0x03FD, 0x0BFF, 0x0000 },
    { 0x0B, 0x03FD, 0x0BFF, 0x0000 },
    { 0x0D, 0x03FD, 0x0BFF, 0xFE00 },
    { 0x0B, 0x03FD, 0x0BFF, 0x0000 },
    { 0x0A, 0x03FD, 0x0401, 0x0000 },
    { 0x0A, 0x03FD, 0x0401, 0x0000 },
    { 0x0A, 0x03FD, 0x0401, 0x0000 },
    { 0x0A, 0x03FD, 0x0401, 0x0000 },
    { 0x0C, 0x03FD, 0x0401, 0xFE00 },
    { 0x0C, 0x03FD, 0x0401, 0xFE00 },
    { 0x0D, 0x03FD, 0x0401, 0x0001 },
    { 0x0D, 0x03FD, 0x0401, 0x03FF },
    { 0x0A, 0x03FD, 0x07FF, 0x0000 },
    { 0x0A, 0x03FD, 0x07FF, 0x0000 },
    { 0x0A, 0x03FD, 0x07FF, 0x0000 },
    { 0x0A, 0x03FD, 0x07FF, 0x0000 },
    { 0x0C, 0x03FD, 0x07FF, 0xFE00 },
    { 0x0C, 0x03FD, 0x07FF, 0xFE00 },
    { 0x0D, 0x03FD, 0x07FF, 0x0001 },
    { 0x0D, 0x03FD, 0x07FF, 0x03FF },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x08, 0x03FD, 0xFE00, 0x0000 },
    { 0x09, 0x03FD, 0x0001, 0x0000 },
    { 0x09, 0x03FD, 0x0001, 0x0000 },
    { 0x09, 0x03FD, 0x0001, 0x0000 },
    { 0x09, 0x03FD, 0x0001, 0x0000 },
    { 0x09, 0x03FD, 0x0001, 0x0000 },
    { 0x09, 0x03FD, 0x0001, 0x0000 },
    { 0x0D, 0x03FD, 0x0001, 0x0401 },
    { 0x0D, 0x03FD, 0x0001, 0x07FF },
    { 0x0B, 0x03FD, 0x0001, 0xFE00 },
    { 0x0B, 0x03FD, 0x0001, 0xFE00 },
    { 0x0B, 0x03FD, 0x0001, 0xFE00 },
    { 0x0B, 0x03FD, 0x0001, 0xFE00 },
    { 0x0C, 0x03FD, 0x0001, 0x0001 },
    { 0x0C, 0x03FD, 0x0001, 0x0001 },
    { 0x0C, 0x03FD, 0x0001, 0x03FF },
    { 0x0C, 0x03FD, 0x0001, 0x03FF },
    { 0x09, 0x03FD, 0x03FF, 0x0000 },
    { 0x09, 0x03FD, 0x03FF, 0x0000 },
    { 0x09, 0x03FD, 0x03FF, 0x0000 },
    { 0x09, 0x03FD, 0x03FF, 0x0000 },
    { 0x09, 0x03FD, 0x03FF, 0x0000 },
    { 0x09, 0x03FD, 0x03FF, 0x0000 },
    { 0x0D, 0x03FD, 0x03FF, 0x0401 },
    { 0x0D, 0x03FD, 0x03FF, 0x07FF },
    { 0x0B, 0x03FD, 0x03FF, 0xFE00 },
    { 0x0B, 0x03FD, 0x03FF, 0xFE00 },
    { 0x0B, 0x03FD, 0x03FF, 0xFE00 },
    { 0x0B, 0x03FD, 0x03FF, 0xFE00 },
    { 0x0C, 0x03FD, 0x03FF, 0x0001 },
    { 0x0C, 0x03FD, 0x03FF, 0x0001 },
    { 0x0C, 0x03FD, 0x03FF, 0x03FF },
    { 0x0C, 0x03FD, 0x03FF, 0x03FF },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x0C, 0x1001, 0x7C1F, 0x0000 },
    { 0x0C, 0x1001, 0x7C1F, 0x0000 },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x0D, 0x1001, 0x1C01, 0x0000 },
    { 0x0D, 0x1001, 0x1FFF, 0x0000 },
    { 0x0D, 0x1001, 0x1801, 0x0000 },
    { 0x0D, 0x1001, 0x1BFF, 0x0000 },
    { 0x0D, 0x1001, 0x0402, 0x0000 },
    { 0x0D, 0x1001, 0x07FE, 0x0000 },
    { 0x0D, 0x1001, 0x1401, 0x0000 },
    { 0x0D, 0x1001, 0x17FF, 0x0000 },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x06, 0x1001, 0x0000, 0x0000 },
    { 0x0C, 0x1001, 0x0003, 0x0000 },
    { 0x0C, 0x1001, 0x0003, 0x0000 },
    { 0x0C, 0x1001, 0x03FD, 0x0000 },
    { 0x0C, 0x1001, 0x03FD, 0x0000 },
    { 0x0C, 0x1001, 0x1001, 0x0000 },
    { 0x0C, 0x1001, 0x1001, 0x0000 },
    { 0x0C, 0x1001, 0x13FF, 0x0000 },
    { 0x0C, 0x1001, 0x13FF, 0x0000 },
    { 0x0C, 0x1001, 0x0C01, 0x0000 },
    { 0x0C, 0x1001, 0x0C01, 0x0000 },
    { 0x0C, 0x1001, 0x0FFF, 0x0000 },
    { 0x0C, 0x1001, 0x0FFF, 0x0000 },
    { 0x0B, 0x1001, 0x0002, 0x0000 },
    { 0x0B, 0x1001, 0x0002, 0x0000 },
    { 0x0D, 0x1001, 0x0002, 0xFE00 },
    { 0x0B, 0x1001, 0x0002, 0x0000 },
    { 0x0B, 0x1001, 0x03FE, 0x0000 },
    { 0x0B, 0x1001, 0x03FE, 0x0000 },
    { 0x0D, 0x1001, 0x03FE, 0xFE00 },
    { 0x0B, 0x1001, 0x03FE, 0x0000 },
    { 0x0B, 0x1001, 0x0801, 0x0000 },
    { 0x0B, 0x1001, 0x0801, 0x0000 },
    { 0x0D, 0x1001, 0x0801, 0xFE00 },
    { 0x0B, 0x1001, 0x0801, 0x0000 },
    { 0x0B, 0x1001, 0x0BFF, 0x0000 },
    { 0x0B, 0x1001, 0x0BFF, 0x0000 },
    { 0x0D, 0x1001, 0x0BFF, 0xFE00 },
    { 0x0B, 0x1001, 0x0BFF, 0x0000 },
    { 0x0A, 0x1001, 0x0401, 0x0000 },
    { 0x0A, 0x1001, 0x0401, 0x0000 },
    { 0x0A, 0x1001, 0x0401, 0x0000 },
    { 0x0A, 0x1001, 0x0401, 0x0000 },
    { 0x0C, 0x1001, 0x0401, 0xFE00 },
    { 0x0C, 0x1001, 0x0401, 0xFE00 },
    { 0x0D, 0x1001, 0x0401, 0x0001 },
    { 0x0D, 0x1001, 0x0401, 0x03FF },
    { 0x0A, 0x1001, 0x07FF, 0x0000 },
    { 0x0A, 0x1001, 0x07FF, 0x0000 },
    { 0x0A, 0x1001, 0x07FF, 0x0000 },
    { 0x0A, 0x1001, 0x07FF, 0x0000 },
    { 0x0C, 0x1001, 0x07FF, 0xFE00 },
    { 0x0C, 0x1001, 0x07FF, 0xFE00 },
    { 0x0D, 0x1001, 0x07FF, 0x0001 },
    { 0x0D, 0x1001, 0x07FF, 0x03FF },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x08, 0x1001, 0xFE00, 0x0000 },
    { 0x09, 0x1001, 0x0001, 0x0000 },
    { 0x09, 0x1001, 0x0001, 0x0000 },
    { 0x09, 0x1001, 0x0001, 0x0000 },
    { 0x09, 0x1001, 0x0001, 0x0000 },
    { 0x09, 0x1001, 0x0001, 0x0000 },
    { 0x09, 0x1001, 0x0001, 0x0000 },
    { 0x0D, 0x1001, 0x0001, 0x0401 },
    { 0x0D, 0x1001, 0x0001, 0x07FF },
    { 0x0B, 0x1001, 0x0001, 0xFE00 },
    { 0x0B, 0x1001, 0x0001, 0xFE00 },
    { 0x0B, 0x1001, 0x0001, 0xFE00 },
    { 0x0B, 0x1001, 0x0001, 0xFE00 },
    { 0x0C, 0x1001, 0x0001, 0x0001 },
    { 0x0C, 0x1001, 0x0001, 0x0001 },
    { 0x0C, 0x1001, 0x0001, 0x03FF },
    { 0x0C, 0x1001, 0x0001, 0x03FF },
    { 0x09, 0x1001, 0x03FF, 0x0000 },
    { 0x09, 0x1001, 0x03FF, 0x0000 },
    { 0x09, 0x1001, 0x03FF, 0x0000 },
    { 0x09, 0x1001, 0x03FF, 0x0000 },
    { 0x09, 0x1001, 0x03FF, 0x0000 },
    { 0x09, 0x1001, 0x03FF, 0x0000 },
    { 0x0D, 0x1001, 0x03FF, 0x0401 },
    { 0x0D, 0x1001, 0x03FF, 0x07FF },
    { 0x0B, 0x1001, 0x03FF, 0xFE00 },
    { 0x0B, 0x1001, 0x03FF, 0xFE00 },
    { 0x0B, 0x1001, 0x03FF, 0xFE00 },
    { 0x0B, 0x1001, 0x03FF, 0xFE00 },
    { 0x0C, 0x1001, 0x03FF, 0x0001 },
    { 0x0C, 0x1001, 0x03FF, 0x0001 },
    { 0x0C, 0x1001, 0x03FF, 0x03FF },
    { 0x0C, 0x1001, 0x03FF, 0x03FF },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x0C, 0x13FF, 0x7C1F, 0x0000 },
    { 0x0C, 0x13FF, 0x7C1F, 0x0000 },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x0D, 0x13FF, 0x1C01, 0x0000 },
    { 0x0D, 0x13FF, 0x1FFF, 0x0000 },
    { 0x0D, 0x13FF, 0x1801, 0x0000 },
    { 0x0D, 0x13FF, 0x1BFF, 0x0000 },
    { 0x0D, 0x13FF, 0x0402, 0x0000 },
    { 0x0D, 0x13FF, 0x07FE, 0x0000 },
    { 0x0D, 0x13FF, 0x1401, 0x0000 },
    { 0x0D, 0x13FF, 0x17FF, 0x0000 },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x06, 0x13FF, 0x0000, 0x0000 },
    { 0x0C, 0x13FF, 0x0003, 0x0000 },
    { 0x0C, 0x13FF, 0x0003, 0x0000 },
    { 0x0C, 0x13FF, 0x03FD, 0x0000 },
    { 0x0C, 0x13FF, 0x03FD, 0x0000 },
    { 0x0C, 0x13FF, 0x1001, 0x0000 },
    { 0x0C, 0x13FF, 0x1001, 0x0000 },
    { 0x0C, 0x13FF, 0x13FF, 0x0000 },
    { 0x0C, 0x13FF, 0x13FF, 0x0000 },
    { 0x0C, 0x13FF, 0x0C01, 0x0000 },
    { 0x0C, 0x13FF, 0x0C01, 0x0000 },
    { 0x0C, 0x13FF, 0x0FFF, 0x0000 },
    { 0x0C, 0x13FF, 0x0FFF, 0x0000 },
    { 0x0B, 0x13FF, 0x0002, 0x0000 },
    { 0x0B, 0x13FF, 0x0002, 0x0000 },
    { 0x0D, 0x13FF, 0x0002, 0xFE00 },
    { 0x0B, 0x13FF, 0x0002, 0x0000 },
    { 0x0B, 0x13FF, 0x03FE, 0x0000 },
    { 0x0B, 0x13FF, 0x03FE, 0x0000 },
    { 0x0D, 0x13FF, 0x03FE, 0xFE00 },
    { 0x0B, 0x13FF, 0x03FE, 0x0000 },
    { 0x0B, 0x13FF, 0x0801, 0x0000 },
    { 0x0B, 0x13FF, 0x0801, 0x0000 },
    { 0x0D, 0x13FF, 0x0801, 0xFE00 },
    { 0x0B, 0x13FF, 0x0801, 0x0000 },
    { 0x0B, 0x13FF, 0x0BFF, 0x0000 },
    { 0x0B, 0x13FF, 0x0BFF, 0x0000 },
    { 0x0D, 0x13FF, 0x0BFF, 0xFE00 },
    { 0x0B, 0x13FF, 0x0BFF, 0x0000 },
    { 0x0A, 0x13FF, 0x0401, 0x0000 },
    { 0x0A, 0x13FF, 0x0401, 0x0000 },
    { 0x0A, 0x13FF, 0x0401, 0x0000 },
    { 0x0A, 0x13FF, 0x0401, 0x0000 },
    { 0x0C, 0x13FF, 0x0401, 0xFE00 },
    { 0x0C, 0x13FF, 0x0401, 0xFE00 },
    { 0x0D, 0x13FF, 0x0401, 0x0001 },
    { 0x0D, 0x13FF, 0x0401, 0x03FF },
    { 0x0A, 0x13FF, 0x07FF, 0x0000 },
    { 0x0A, 0x13FF, 0x07FF, 0x0000 },
    { 0x0A, 0x13FF, 0x07FF, 0x0000 },
    { 0x0A, 0x13FF, 0x07FF, 0x0000 },
    { 0x0C, 0x13FF, 0x07FF, 0xFE00 },
    { 0x0C, 0x13FF, 0x07FF, 0xFE00 },
    { 0x0D, 0x13FF, 0x07FF, 0x0001 },
    { 0x0D, 0x13FF, 0x07FF, 0x03FF },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x08, 0x13FF, 0xFE00, 0x0000 },
    { 0x09, 0x13FF, 0x0001, 0x0000 },
    { 0x09, 0x13FF, 0x0001, 0x0000 },
    { 0x09, 0x13FF, 0x0001, 0x0000 },
    { 0x09, 0x13FF, 0x0001, 0x0000 },
    { 0x09, 0x13FF, 0x0001, 0x0000 },
    { 0x09, 0x13FF, 0x0001, 0x0000 },
    { 0x0D, 0x13FF, 0x0001, 0x0401 },
    { 0x0D, 0x13FF, 0x0001, 0x07FF },
    { 0x0B, 0x13FF, 0x0001, 0xFE00 },
    { 0x0B, 0x13FF, 0x0001, 0xFE00 },
    { 0x0B, 0x13FF, 0x0001, 0xFE00 },
    { 0x0B, 0x13FF, 0x0001, 0xFE00 },
    { 0x0C, 0x13FF, 0x0001, 0x0001 },
    { 0x0C, 0x13FF, 0x0001, 0x0001 },
    { 0x0C, 0x13FF, 0x0001, 0x03FF },
    { 0x0C, 0x13FF, 0x0001, 0x03FF },
    { 0x09, 0x13FF, 0x03FF, 0x0000 },
    { 0x09, 0x13FF, 0x03FF, 0x0000 },
    { 0x09, 0x13FF, 0x03FF, 0x0000 },
    { 0x09, 0x13FF, 0x03FF, 0x0000 },
    { 0x09, 0x13FF, 0x03FF, 0x0000 },
    { 0x09, 0x13FF, 0x03FF, 0x0000 },
    { 0x0D, 0x13FF, 0x03FF, 0x0401 },
    { 0x0D, 0x13FF, 0x03FF, 0x07FF },
    { 0x0B, 0x13FF, 0x03FF, 0xFE00 },
    { 0x0B, 0x13FF, 0x03FF, 0xFE00 },
    { 0x0B, 0x13FF, 0x03FF, 0xFE00 },
    { 0x0B, 0x13FF, 0x03FF, 0xFE00 },
    { 0x0C, 0x13FF, 0x03FF, 0x0001 },
    { 0x0C, 0x13FF, 0x03FF, 0x0001 },
    { 0x0C, 0x13FF, 0x03FF, 0x03FF },
    { 0x0C, 0x13FF, 0x03FF, 0x03FF },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x0C, 0x0C01, 0x7C1F, 0x0000 },
    { 0x0C, 0x0C01, 0x7C1F, 0x0000 },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x0D, 0x0C01, 0x1C01, 0x0000 },
    { 0x0D, 0x0C01, 0x1FFF, 0x0000 },
    { 0x0D, 0x0C01, 0x1801, 0x0000 },
    { 0x0D, 0x0C01, 0x1BFF, 0x0000 },
    { 0x0D, 0x0C01, 0x0402, 0x0000 },
    { 0x0D, 0x0C01, 0x07FE, 0x0000 },
    { 0x0D, 0x0C01, 0x1401, 0x0000 },
    { 0x0D, 0x0C01, 0x17FF, 0x0000 },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x06, 0x0C01, 0x0000, 0x0000 },
    { 0x0C, 0x0C01, 0x0003, 0x0000 },
    { 0x0C, 0x0C01, 0x0003, 0x0000 },
    { 0x0C, 0x0C01, 0x03FD, 0x0000 },
    { 0x0C, 0x0C01, 0x03FD, 0x0000 },
    { 0x0C, 0x0C01, 0x1001, 0x0000 },
    { 0x0C, 0x0C01, 0x1001, 0x0000 },
    { 0x0C, 0x0C01, 0x13FF, 0x0000 },
    { 0x0C, 0x0C01, 0x13FF, 0x0000 },
    { 0x0C, 0x0C01, 0x0C01, 0x0000 },
    { 0x0C, 0x0C01, 0x0C01, 0x0000 },
    { 0x0C, 0x0C01, 0x0FFF, 0x0000 },
    { 0x0C, 0x0C01, 0x0FFF, 0x0000 },
    { 0x0B, 0x0C01, 0x0002, 0x0000 },
    { 0x0B, 0x0C01, 0x0002, 0x0000 },
    { 0x0D, 0x0C01, 0x0002, 0xFE00 },
    { 0x0B, 0x0C01, 0x0002, 0x0000 },
    { 0x0B, 0x0C01, 0x03FE, 0x0000 },
    { 0x0B, 0x0C01, 0x03FE, 0x0000 },
    { 0x0D, 0x0C01, 0x03FE, 0xFE00 },
    { 0x0B, 0x0C01, 0x03FE, 0x0000 },
    { 0x0B, 0x0C01, 0x0801, 0x0000 },
    { 0x0B, 0x0C01, 0x0801, 0x0000 },
    { 0x0D, 0x0C01, 0x0801, 0xFE00 },
    { 0x0B, 0x0C01, 0x0801, 0x0000 },
    { 0x0B, 0x0C01, 0x0BFF, 0x0000 },
    { 0x0B, 0x0C01, 0x0BFF, 0x0000 },
    { 0x0D, 0x0C01, 0x0BFF, 0xFE00 },
    { 0x0B, 0x0C01, 0x0BFF, 0x0000 },
    { 0x0A, 0x0C01, 0x0401, 0x0000 },
    { 0x0A, 0x0C01, 0x0401, 0x0000 },
    { 0x0A, 0x0C01, 0x0401, 0x0000 },
    { 0x0A, 0x0C01, 0x0401, 0x0000 },
    { 0x0C, 0x0C01, 0x0401, 0xFE00 },
    { 0x0C, 0x0C01, 0x0401, 0xFE00 },
    { 0x0D, 0x0C01, 0x0401, 0x0001 },
    { 0x0D, 0x0C01, 0x0401, 0x03FF },
    { 0x0A, 0x0C01, 0x07FF, 0x0000 },
    { 0x0A, 0x0C01, 0x07FF, 0x0000 },
    { 0x0A, 0x0C01, 0x07FF, 0x0000 },
    { 0x0A, 0x0C01, 0x07FF, 0x0000 },
    { 0x0C, 0x0C01, 0x07FF, 0xFE00 },
    { 0x0C, 0x0C01, 0x07FF, 0xFE00 },
    { 0x0D, 0x0C01, 0x07FF, 0x0001 },
    { 0x0D, 0x0C01, 0x07FF, 0x03FF },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x08, 0x0C01, 0xFE00, 0x0000 },
    { 0x09, 0x0C01, 0x0001, 0x0000 },
    { 0x09, 0x0C01, 0x0001, 0x0000 },
    { 0x09, 0x0C01, 0x0001, 0x0000 },
    { 0x09, 0x0C01, 0x0001, 0x0000 },
    { 0x09, 0x0C01, 0x0001, 0x0000 },
    { 0x09, 0x0C01, 0x0001, 0x0000 },
    { 0x0D, 0x0C01, 0x0001, 0x0401 },
    { 0x0D, 0x0C01, 0x0001, 0x07FF },
    { 0x0B, 0x0C01, 0x0001, 0xFE00 },
    { 0x0B, 0x0C01, 0x0001, 0xFE00 },
    { 0x0B, 0x0C01, 0x0001, 0xFE00 },
    { 0x0B, 0x0C01, 0x0001, 0xFE00 },
    { 0x0C, 0x0C01, 0x0001, 0x0001 },
    { 0x0C, 0x0C01, 0x0001, 0x0001 },
    { 0x0C, 0x0C01, 0x0001, 0x03FF },
    { 0x0C, 0x0C01, 0x0001, 0x03FF },
    { 0x09, 0x0C01, 0x03FF, 0x0000 },
    { 0x09, 0x0C01, 0x03FF, 0x0000 },
    { 0x09, 0x0C01, 0x03FF, 0x0000 },
    { 0x09, 0x0C01, 0x03FF, 0x0000 },
    { 0x09, 0x0C01, 0x03FF, 0x0000 },
    { 0x09, 0x0C01, 0x03FF, 0x0000 },
    { 0x0D, 0x0C01, 0x03FF, 0x0401 },
    { 0x0D, 0x0C01, 0x03FF, 0x07FF },
    { 0x0B, 0x0C01, 0x03FF, 0xFE00 },
    { 0x0B, 0x0C01, 0x03FF, 0xFE00 },
    { 0x0B, 0x0C01, 0x03FF, 0xFE00 },
    { 0x0B, 0x0C01, 0x03FF, 0xFE00 },
    { 0x0C, 0x0C01, 0x03FF, 0x0001 },
    { 0x0C, 0x0C01, 0x03FF, 0x0001 },
    { 0x0C, 0x0C01, 0x03FF, 0x03FF },
    { 0x0C, 0x0C01, 0x03FF, 0x03FF },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x0C, 0x0FFF, 0x7C1F, 0x0000 },
    { 0x0C, 0x0FFF, 0x7C1F, 0x0000 },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x0D, 0x0FFF, 0x1C01, 0x0000 },
    { 0x0D, 0x0FFF, 0x1FFF, 0x0000 },
    { 0x0D, 0x0FFF, 0x1801, 0x0000 },
    { 0x0D, 0x0FFF, 0x1BFF, 0x0000 },
    { 0x0D, 0x0FFF, 0x0402, 0x0000 },
    { 0x0D, 0x0FFF, 0x07FE, 0x0000 },
    { 0x0D, 0x0FFF, 0x1401, 0x0000 },
    { 0x0D, 0x0FFF, 0x17FF, 0x0000 },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x06, 0x0FFF, 0x0000, 0x0000 },
    { 0x0C, 0x0FFF, 0x0003, 0x0000 },
    { 0x0C, 0x0FFF, 0x0003, 0x0000 },
    { 0x0C, 0x0FFF, 0x03FD, 0x0000 },
    { 0x0C, 0x0FFF, 0x03FD, 0x0000 },
    { 0x0C, 0x0FFF, 0x1001, 0x0000 },
    { 0x0C, 0x0FFF, 0x1001, 0x0000 },
    { 0x0C, 0x0FFF, 0x13FF, 0x0000 },
    { 0x0C, 0x0FFF, 0x13FF, 0x0000 },
    { 0x0C, 0x0FFF, 0x0C01, 0x0000 },
    { 0x0C, 0x0FFF, 0x0C01, 0x0000 },
    { 0x0C, 0x0FFF, 0x0FFF, 0x0000 },
    { 0x0C, 0x0FFF, 0x0FFF, 0x0000 },
    { 0x0B, 0x0FFF, 0x0002, 0x0000 },
    { 0x0B, 0x0FFF, 0x0002, 0x0000 },
    { 0x0D, 0x0FFF, 0x0002, 0xFE00 },
    { 0x0B, 0x0FFF, 0x0002, 0x0000 },
    { 0x0B, 0x0FFF, 0x03FE, 0x0000 },
    { 0x0B, 0x0FFF, 0x03FE, 0x0000 },
    { 0x0D, 0x0FFF, 0x03FE, 0xFE00 },
    { 0x0B, 0x0FFF, 0x03FE, 0x0000 },
    { 0x0B, 0x0FFF, 0x0801, 0x0000 },
    { 0x0B, 0x0FFF, 0x0801, 0x0000 },
    { 0x0D, 0x0FFF, 0x0801, 0xFE00 },
    { 0x0B, 0x0FFF, 0x0801, 0x0000 },
    { 0x0B, 0x0FFF, 0x0BFF, 0x0000 },
    { 0x0B, 0x0FFF, 0x0BFF, 0x0000 },
    { 0x0D, 0x0FFF, 0x0BFF, 0xFE00 },
    { 0x0B, 0x0FFF, 0x0BFF, 0x0000 },
    { 0x0A, 0x0FFF, 0x0401, 0x0000 },
    { 0x0A, 0x0FFF, 0x0401, 0x0000 },
    { 0x0A, 0x0FFF, 0x0401, 0x0000 },
    { 0x0A, 0x0FFF, 0x0401, 0x0000 },
    { 0x0C, 0x0FFF, 0x0401, 0xFE00 },
    { 0x0C, 0x0FFF, 0x0401, 0xFE00 },
    { 0x0D, 0x0FFF, 0x0401, 0x0001 },
    { 0x0D, 0x0FFF, 0x0401, 0x03FF },
    { 0x0A, 0x0FFF, 0x07FF, 0x0000 },
    { 0x0A, 0x0FFF, 0x07FF, 0x0000 },
    { 0x0A, 0x0FFF, 0x07FF, 0x0000 },
    { 0x0A, 0x0FFF, 0x07FF, 0x0000 },
    { 0x0C, 0x0FFF, 0x07FF, 0xFE00 },
    { 0x0C, 0x0FFF, 0x07FF, 0xFE00 },
    { 0x0D, 0x0FFF, 0x07FF, 0x0001 },
    { 0x0D, 0x0FFF, 0x07FF, 0x03FF },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x08, 0x0FFF, 0xFE00, 0x0000 },
    { 0x09, 0x0FFF, 0x0001, 0x0000 },
    { 0x09, 0x0FFF, 0x0001, 0x0000 },
    { 0x09, 0x0FFF, 0x0001, 0x0000 },
    { 0x09, 0x0FFF, 0x0001, 0x0000 },
    { 0x09, 0x0FFF, 0x0001, 0x0000 },
    { 0x09, 0x0FFF, 0x0001, 0x0000 },
    { 0x0D, 0x0FFF, 0x0001, 0x0401 },
    { 0x0D, 0x0FFF, 0x0001, 0x07FF },
    { 0x0B, 0x0FFF, 0x0001, 0xFE00 },
    { 0x0B, 0x0FFF, 0x0001, 0xFE00 },
    { 0x0B, 0x0FFF, 0x0001, 0xFE00 },
    { 0x0B, 0x0FFF, 0x0001, 0xFE00 },
    { 0x0C, 0x0FFF, 0x0001, 0x0001 },
    { 0x0C, 0x0FFF, 0x0001, 0x0001 },
    { 0x0C, 0x0FFF, 0x0001, 0x03FF },
    { 0x0C, 0x0FFF, 0x0001, 0x03FF },
    { 0x09, 0x0FFF, 0x03FF, 0x0000 },
    { 0x09, 0x0FFF, 0x03FF, 0x0000 },
    { 0x09, 0x0FFF, 0x03FF, 0x0000 },
    { 0x09, 0x0FFF, 0x03FF, 0x0000 },
    { 0x09, 0x0FFF, 0x03FF, 0x0000 },
    { 0x09, 0x0FFF, 0x03FF, 0x0000 },
    { 0x0D, 0x0FFF, 0x03FF, 0x0401 },
    { 0x0D, 0x0FFF, 0x03FF, 0x07FF },
    { 0x0B, 0x0FFF, 0x03FF, 0xFE00 },
    { 0x0B, 0x0FFF, 0x03FF, 0xFE00 },
    { 0x0B, 0x0FFF, 0x03FF, 0xFE00 },
    { 0x0B, 0x0FFF, 0x03FF, 0xFE00 },
    { 0x0C, 0x0FFF, 0x03FF, 0x0001 },
    { 0x0C, 0x0FFF, 0x03FF, 0x0001 },
    { 0x0C, 0x0FFF, 0x03FF, 0x03FF },
    { 0x0C, 0x0FFF, 0x03FF, 0x03FF },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x0B, 0x0002, 0x7C1F, 0x0000 },
    { 0x0B, 0x0002, 0x7C1F, 0x0000 },
    { 0x0B, 0x0002, 0x7C1F, 0x0000 },
    { 0x0B, 0x0002, 0x7C1F, 0x0000 },
    { 0x0D, 0x0002, 0x0802, 0x0000 },
    { 0x0D, 0x0002, 0x0BFE, 0x0000 },
    { 0x0D, 0x0002, 0x2401, 0x0000 },
    { 0x0D, 0x0002, 0x27FF, 0x0000 },
    { 0x0D, 0x0002, 0x0004, 0x0000 },
    { 0x0D, 0x0002, 0x03FC, 0x0000 },
    { 0x0D, 0x0002, 0x2001, 0x0000 },
    { 0x0D, 0x0002, 0x23FF, 0x0000 },
    { 0x0C, 0x0002, 0x1C01, 0x0000 },
    { 0x0C, 0x0002, 0x1C01, 0x0000 },
    { 0x0C, 0x0002, 0x1FFF, 0x0000 },
    { 0x0C, 0x0002, 0x1FFF, 0x0000 },
    { 0x0C, 0x0002, 0x1801, 0x0000 },
    { 0x0C, 0x0002, 0x1801, 0x0000 },
    { 0x0C, 0x0002, 0x1BFF, 0x0000 },
    { 0x0C, 0x0002, 0x1BFF, 0x0000 },
    { 0x0C, 0x0002, 0x0402, 0x0000 },
    { 0x0C, 0x0002, 0x0402, 0x0000 },
    { 0x0C, 0x0002, 0x07FE, 0x0000 },
    { 0x0C, 0x0002, 0x07FE, 0x0000 },
    { 0x0C, 0x0002, 0x1401, 0x0000 },
    { 0x0C, 0x0002, 0x1401, 0x0000 },
    { 0x0C, 0x0002, 0x17FF, 0x0000 },
    { 0x0C, 0x0002, 0x17FF, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x05, 0x0002, 0x0000, 0x0000 },
    { 0x0B, 0x0002, 0x0003, 0x0000 },
    { 0x0B, 0x0002, 0x0003, 0x0000 },
    { 0x0D, 0x0002, 0x0003, 0xFE00 },
    { 0x0B, 0x0002, 0x0003, 0x0000 },
    { 0x0B, 0x0002, 0x03FD, 0x0000 },
    { 0x0B, 0x0002, 0x03FD, 0x0000 },
    { 0x0D, 0x0002, 0x03FD, 0xFE00 },
    { 0x0B, 0x0002, 0x03FD, 0x0000 },
    { 0x0B, 0x0002, 0x1001, 0x0000 },
    { 0x0B, 0x0002, 0x1001, 0x0000 },
    { 0x0D, 0x0002, 0x1001, 0xFE00 },
    { 0x0B, 0x0002, 0x1001, 0x0000 },
    { 0x0B, 0x0002, 0x13FF, 0x0000 },
    { 0x0B, 0x0002, 0x13FF, 0x0000 },
    { 0x0D, 0x0002, 0x13FF, 0xFE00 },
    { 0x0B, 0x0002, 0x13FF, 0x0000 },
    { 0x0B, 0x0002, 0x0C01, 0x0000 },
    { 0x0B, 0x0002, 0x0C01, 0x0000 },
    { 0x0D, 0x0002, 0x0C01, 0xFE00 },
    { 0x0B, 0x0002, 0x0C01, 0x0000 },
    { 0x0B, 0x0002, 0x0FFF, 0x0000 },
    { 0x0B, 0x0002, 0x0FFF, 0x0000 },
    { 0x0D, 0x0002, 0x0FFF, 0xFE00 },
    { 0x0B, 0x0002, 0x0FFF, 0x0000 },
    { 0x0A, 0x0002, 0x0002, 0x0000 },
    { 0x0A, 0x0002, 0x0002, 0x0000 },
    { 0x0A, 0x0002, 0x0002, 0x0000 },
    { 0x0A, 0x0002, 0x0002, 0x0000 },
    { 0x0C, 0x0002, 0x0002, 0xFE00 },
    { 0x0C, 0x0002, 0x0002, 0xFE00 },
    { 0x0D, 0x0002, 0x0002, 0x0001 },
    { 0x0D, 0x0002, 0x0002, 0x03FF },
    { 0x0A, 0x0002, 0x03FE, 0x0000 },
    { 0x0A, 0x0002, 0x03FE, 0x0000 },
    { 0x0A, 0x0002, 0x03FE, 0x0000 },
    { 0x0A, 0x0002, 0x03FE, 0x0000 },
    { 0x0C, 0x0002, 0x03FE, 0xFE00 },
    { 0x0C, 0x0002, 0x03FE, 0xFE00 },
    { 0x0D, 0x0002, 0x03FE, 0x0001 },
    { 0x0D, 0x0002, 0x03FE, 0x03FF },
    { 0x0A, 0x0002, 0x0801, 0x0000 },
    { 0x0A, 0x0002, 0x0801, 0x0000 },
    { 0x0A, 0x0002, 0x0801, 0x0000 },
    { 0x0A, 0x0002, 0x0801, 0x0000 },
    { 0x0C, 0x0002, 0x0801, 0xFE00 },
    { 0x0C, 0x0002, 0x0801, 0xFE00 },
    { 0x0D, 0x0002, 0x0801, 0x0001 },
    { 0x0D, 0x0002, 0x0801, 0x03FF },
    { 0x0A, 0x0002, 0x0BFF, 0x0000 },
    { 0x0A, 0x0002, 0x0BFF, 0x0000 },
    { 0x0A, 0x0002, 0x0BFF, 0x0000 },
    { 0x0A, 0x0002, 0x0BFF, 0x0000 },
    { 0x0C, 0x0002, 0x0BFF, 0xFE00 },
    { 0x0C, 0x0002, 0x0BFF, 0xFE00 },
    { 0x0D, 0x0002, 0x0BFF, 0x0001 },
    { 0x0D, 0x0002, 0x0BFF, 0x03FF },
    { 0x09, 0x0002, 0x0401, 0x0000 },
    { 0x09, 0x0002, 0x0401, 0x0000 },
    { 0x09, 0x0002, 0x0401, 0x0000 },
    { 0x09, 0x0002, 0x0401, 0x0000 },
    { 0x09, 0x0002, 0x0401, 0x0000 },
    { 0x09, 0x0002, 0x0401, 0x0000 },
    { 0x0D, 0x0002, 0x0401, 0x0401 },
    { 0x0D, 0x0002, 0x0401, 0x07FF },
    { 0x0B, 0x0002, 0x0401, 0xFE00 },
    { 0x0B, 0x0002, 0x0401, 0xFE00 },
    { 0x0B, 0x0002, 0x0401, 0xFE00 },
    { 0x0B, 0x0002, 0x0401, 0xFE00 },
    { 0x0C, 0x0002, 0x0401, 0x0001 },
    { 0x0C, 0x0002, 0x0401, 0x0001 },
    { 0x0C, 0x0002, 0x0401, 0x03FF },
    { 0x0C, 0x0002, 0x0401, 0x03FF },
    { 0x09, 0x0002, 0x07FF, 0x0000 },
    { 0x09, 0x0002, 0x07FF, 0x0000 },
    { 0x09, 0x0002, 0x07FF, 0x0000 },
    { 0x09, 0x0002, 0x07FF, 0x0000 },
    { 0x09, 0x0002, 0x07FF, 0x0000 },
    { 0x09, 0x0002, 0x07FF, 0x0000 },
    { 0x0D, 0x0002, 0x07FF, 0x0401 },
    { 0x0D, 0x0002, 0x07FF, 0x07FF },
    { 0x0B, 0x0002, 0x07FF, 0xFE00 },
    { 0x0B, 0x0002, 0x07FF, 0xFE00 },
    { 0x0B, 0x0002, 0x07FF, 0xFE00 },
    { 0x0B, 0x0002, 0x07FF, 0xFE00 },
    { 0x0C, 0x0002, 0x07FF, 0x0001 },
    { 0x0C, 0x0002, 0x07FF, 0x0001 },
    { 0x0C, 0x0002, 0x07FF, 0x03FF },
    { 0x0C, 0x0002, 0x07FF, 0x03FF },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x07, 0x0002, 0xFE00, 0x0000 },
    { 0x08, 0x0002, 0x0001, 0x0000 },
    { 0x08, 0x0002, 0x0001, 0x0000 },
    { 0x08, 0x0002, 0x0001, 0x0000 },
    { 0x08, 0x0002, 0x0001, 0x0000 },
    { 0x08, 0x0002, 0x0001, 0x0000 },
    { 0x08, 0x0002, 0x0001, 0x0000 },
    { 0x08, 0x0002, 0x0001, 0x0000 },
    { 0x08, 0x0002, 0x0001, 0x0000 },
    { 0x0D, 0x0002, 0x0001, 0x0002 },
    { 0x0D, 0x0002, 0x0001, 0x03FE },
    { 0x0D, 0x0002, 0x0001, 0x0801 },
    { 0x0D, 0x0002, 0x0001, 0x0BFF },
    { 0x0C, 0x0002, 0x0001, 0x0401 },
    { 0x0C, 0x0002, 0x0001, 0x0401 },
    { 0x0C, 0x0002, 0x0001, 0x07FF },
    { 0x0C, 0x0002, 0x0001, 0x07FF },
    { 0x0A, 0x0002, 0x0001, 0xFE00 },
    { 0x0A, 0x0002, 0x0001, 0xFE00 },
    { 0x0A, 0x0002, 0x0001, 0xFE00 },
    { 0x0A, 0x0002, 0x0001, 0xFE00 },
    { 0x0A, 0x0002, 0x0001, 0xFE00 },
    { 0x0A, 0x0002, 0x0001, 0xFE00 },
    { 0x0A, 0x0002, 0x0001, 0xFE00 },
    { 0x0A, 0x0002, 0x0001, 0xFE00 },
    { 0x0B, 0x0002, 0x0001, 0x0001 },
    { 0x0B, 0x0002, 0x0001, 0x0001 },
    { 0x0B, 0x0002, 0x0001, 0x0001 },
    { 0x0B, 0x0002, 0x0001, 0x0001 },
    { 0x0B, 0x0002, 0x0001, 0x03FF },
    { 0x0B, 0x0002, 0x0001, 0x03FF },
    { 0x0B, 0x0002, 0x0001, 0x03FF },
    { 0x0B, 0x0002, 0x0001, 0x03FF },
    { 0x08, 0x0002, 0x03FF, 0x0000 },
    { 0x08, 0x0002, 0x03FF, 0x0000 },
    { 0x08, 0x0002, 0x03FF, 0x0000 },
    { 0x08, 0x0002, 0x03FF, 0x0000 },
    { 0x08, 0x0002, 0x03FF, 0x0000 },
    { 0x08, 0x0002, 0x03FF, 0x0000 },
    { 0x08, 0x0002, 0x03FF, 0x0000 },
    { 0x08, 0x0002, 0x03FF, 0x0000 },
    { 0x0D, 0x0002, 0x03FF, 0x0002 },
    { 0x0D, 0x0002, 0x03FF, 0x03FE },
    { 0x0D, 0x0002, 0x03FF, 0x0801 },
    { 0x0D, 0x0002, 0x03FF, 0x0BFF },
    { 0x0C, 0x0002, 0x03FF, 0x0401 },
    { 0x0C, 0x0002, 0x03FF, 0x0401 },
    { 0x0C, 0x0002, 0x03FF, 0x07FF },
    { 0x0C, 0x0002, 0x03FF, 0x07FF },
    { 0x0A, 0x0002, 0x03FF, 0xFE00 },
    { 0x0A, 0x0002, 0x03FF, 0xFE00 },
    { 0x0A, 0x0002, 0x03FF, 0xFE00 },
    { 0x0A, 0x0002, 0x03FF, 0xFE00 },
    { 0x0A, 0x0002, 0x03FF, 0xFE00 },
    { 0x0A, 0x0002, 0x03FF, 0xFE00 },
    { 0x0A, 0x0002, 0x03FF, 0xFE00 },
    { 0x0A, 0x0002, 0x03FF, 0xFE00 },
    { 0x0B, 0x0002, 0x03FF, 0x0001 },
    { 0x0B, 0x0002, 0x03FF, 0x0001 },
    { 0x0B, 0x0002, 0x03FF, 0x0001 },
    { 0x0B, 0x0002, 0x03FF, 0x0001 },
    { 0x0B, 0x0002, 0x03FF, 0x03FF },
    { 0x0B, 0x0002, 0x03FF, 0x03FF },
    { 0x0B, 0x0002, 0x03FF, 0x03FF },
    { 0x0B, 0x0002, 0x03FF, 0x03FF },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x0B, 0x03FE, 0x7C1F, 0x0000 },
    { 0x0B, 0x03FE, 0x7C1F, 0x0000 },
    { 0x0B, 0x03FE, 0x7C1F, 0x0000 },
    { 0x0B, 0x03FE, 0x7C1F, 0x0000 },
    { 0x0D, 0x03FE, 0x0802, 0x0000 },
    { 0x0D, 0x03FE, 0x0BFE, 0x0000 },
    { 0x0D, 0x03FE, 0x2401, 0x0000 },
    { 0x0D, 0x03FE, 0x27FF, 0x0000 },
    { 0x0D, 0x03FE, 0x0004, 0x0000 },
    { 0x0D, 0x03FE, 0x03FC, 0x0000 },
    { 0x0D, 0x03FE, 0x2001, 0x0000 },
    { 0x0D, 0x03FE, 0x23FF, 0x0000 },
    { 0x0C, 0x03FE, 0x1C01, 0x0000 },
    { 0x0C, 0x03FE, 0x1C01, 0x0000 },
    { 0x0C, 0x03FE, 0x1FFF, 0x0000 },
    { 0x0C, 0x03FE, 0x1FFF, 0x0000 },
    { 0x0C, 0x03FE, 0x1801, 0x0000 },
    { 0x0C, 0x03FE, 0x1801, 0x0000 },
    { 0x0C, 0x03FE, 0x1BFF, 0x0000 },
    { 0x0C, 0x03FE, 0x1BFF, 0x0000 },
    { 0x0C, 0x03FE, 0x0402, 0x0000 },
    { 0x0C, 0x03FE, 0x0402, 0x0000 },
    { 0x0C, 0x03FE, 0x07FE, 0x0000 },
    { 0x0C, 0x03FE, 0x07FE, 0x0000 },
    { 0x0C, 0x03FE, 0x1401, 0x0000 },
    { 0x0C, 0x03FE, 0x1401, 0x0000 },
    { 0x0C, 0x03FE, 0x17FF, 0x0000 },
    { 0x0C, 0x03FE, 0x17FF, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x05, 0x03FE, 0x0000, 0x0000 },
    { 0x0B, 0x03FE, 0x0003, 0x0000 },
    { 0x0B, 0x03FE, 0x0003, 0x0000 },
    { 0x0D, 0x03FE, 0x0003, 0xFE00 },
    { 0x0B, 0x03FE, 0x0003, 0x0000 },
    { 0x0B, 0x03FE, 0x03FD, 0x0000 },
    { 0x0B, 0x03FE, 0x03FD, 0x0000 },
    { 0x0D, 0x03FE, 0x03FD, 0xFE00 },
    { 0x0B, 0x03FE, 0x03FD, 0x0000 },
    { 0x0B, 0x03FE, 0x1001, 0x0000 },
    { 0x0B, 0x03FE, 0x1001, 0x0000 },
    { 0x0D, 0x03FE, 0x1001, 0xFE00 },
    { 0x0B, 0x03FE, 0x1001, 0x0000 },
    { 0x0B, 0x03FE, 0x13FF, 0x0000 },
    { 0x0B, 0x03FE, 0x13FF, 0x0000 },
    { 0x0D, 0x03FE, 0x13FF, 0xFE00 },
    { 0x0B, 0x03FE, 0x13FF, 0x0000 },
    { 0x0B, 0x03FE, 0x0C01, 0x0000 },
    { 0x0B, 0x03FE, 0x0C01, 0x0000 },
    { 0x0D, 0x03FE, 0x0C01, 0xFE00 },
    { 0x0B, 0x03FE, 0x0C01, 0x0000 },
    { 0x0B, 0x03FE, 0x0FFF, 0x0000 },
    { 0x0B, 0x03FE, 0x0FFF, 0x0000 },
    { 0x0D, 0x03FE, 0x0FFF, 0xFE00 },
    { 0x0B, 0x03FE, 0x0FFF, 0x0000 },
    { 0x0A, 0x03FE, 0x0002, 0x0000 },
    { 0x0A, 0x03FE, 0x0002, 0x0000 },
    { 0x0A, 0x03FE, 0x0002, 0x0000 },
    { 0x0A, 0x03FE, 0x0002, 0x0000 },
    { 0x0C, 0x03FE, 0x0002, 0xFE00 },
    { 0x0C, 0x03FE, 0x0002, 0xFE00 },
    { 0x0D, 0x03FE, 0x0002, 0x0001 },
    { 0x0D, 0x03FE, 0x0002, 0x03FF },
    { 0x0A, 0x03FE, 0x03FE, 0x0000 },
    { 0x0A, 0x03FE, 0x03FE, 0x0000 },
    { 0x0A, 0x03FE, 0x03FE, 0x0000 },
    { 0x0A, 0x03FE, 0x03FE, 0x0000 },
    { 0x0C, 0x03FE, 0x03FE, 0xFE00 },
    { 0x0C, 0x03FE, 0x03FE, 0xFE00 },
    { 0x0D, 0x03FE, 0x03FE, 0x0001 },
    { 0x0D, 0x03FE, 0x03FE, 0x03FF },
    { 0x0A, 0x03FE, 0x0801, 0x0000 },
    { 0x0A, 0x03FE, 0x0801, 0x0000 },
    { 0x0A, 0x03FE, 0x0801, 0x0000 },
    { 0x0A, 0x03FE, 0x0801, 0x0000 },
    { 0x0C, 0x03FE, 0x0801, 0xFE00 },
    { 0x0C, 0x03FE, 0x0801, 0xFE00 },
    { 0x0D, 0x03FE, 0x0801, 0x0001 },
    { 0x0D, 0x03FE, 0x0801, 0x03FF },
    { 0x0A, 0x03FE, 0x0BFF, 0x0000 },
    { 0x0A, 0x03FE, 0x0BFF, 0x0000 },
    { 0x0A, 0x03FE, 0x0BFF, 0x0000 },
    { 0x0A, 0x03FE, 0x0BFF, 0x0000 },
    { 0x0C, 0x03FE, 0x0BFF, 0xFE00 },
    { 0x0C, 0x03FE, 0x0BFF, 0xFE00 },
    { 0x0D, 0x03FE, 0x0BFF, 0x0001 },
    { 0x0D, 0x03FE, 0x0BFF, 0x03FF },
    { 0x09, 0x03FE, 0x0401, 0x0000 },
    { 0x09, 0x03FE, 0x0401, 0x0000 },
    { 0x09, 0x03FE, 0x0401, 0x0000 },
    { 0x09, 0x03FE, 0x0401, 0x0000 },
    { 0x09, 0x03FE, 0x0401, 0x0000 },
    { 0x09, 0x03FE, 0x0401, 0x0000 },
    { 0x0D, 0x03FE, 0x0401, 0x0401 },
    { 0x0D, 0x03FE, 0x0401, 0x07FF },
    { 0x0B, 0x03FE, 0x0401, 0xFE00 },
    { 0x0B, 0x03FE, 0x0401, 0xFE00 },
    { 0x0B, 0x03FE, 0x0401, 0xFE00 },
    { 0x0B, 0x03FE, 0x0401, 0xFE00 },
    { 0x0C, 0x03FE, 0x0401, 0x0001 },
    { 0x0C, 0x03FE, 0x0401, 0x0001 },
    { 0x0C, 0x03FE, 0x0401, 0x03FF },
    { 0x0C, 0x03FE, 0x0401, 0x03FF },
    { 0x09, 0x03FE, 0x07FF, 0x0000 },
    { 0x09, 0x03FE, 0x07FF, 0x0000 },
    { 0x09, 0x03FE, 0x07FF, 0x0000 },
    { 0x09, 0x03FE, 0x07FF, 0x0000 },
    { 0x09, 0x03FE, 0x07FF, 0x0000 },
    { 0x09, 0x03FE, 0x07FF, 0x0000 },
    { 0x0D, 0x03FE, 0x07FF, 0x0401 },
    { 0x0D, 0x03FE, 0x07FF, 0x07FF },
    { 0x0B, 0x03FE, 0x07FF, 0xFE00 },
    { 0x0B, 0x03FE, 0x07FF, 0xFE00 },
    { 0x0B, 0x03FE, 0x07FF, 0xFE00 },
    { 0x0B, 0x03FE, 0x07FF, 0xFE00 },
    { 0x0C, 0x03FE, 0x07FF, 0x0001 },
    { 0x0C, 0x03FE, 0x07FF, 0x0001 },
    { 0x0C, 0x03FE, 0x07FF, 0x03FF },
    { 0x0C, 0x03FE, 0x07FF, 0x03FF },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x07, 0x03FE, 0xFE00, 0x0000 },
    { 0x08, 0x03FE, 0x0001, 0x0000 },
    { 0x08, 0x03FE, 0x0001, 0x0000 },
    { 0x08, 0x03FE, 0x0001, 0x0000 },
    { 0x08, 0x03FE, 0x0001, 0x0000 },
    { 0x08, 0x03FE, 0x0001, 0x0000 },
    { 0x08, 0x03FE, 0x0001, 0x0000 },
    { 0x08, 0x03FE, 0x0001, 0x0000 },
    { 0x08, 0x03FE, 0x0001, 0x0000 },
    { 0x0D, 0x03FE, 0x0001, 0x0002 },
    { 0x0D, 0x03FE, 0x0001, 0x03FE },
    { 0x0D, 0x03FE, 0x0001, 0x0801 },
    { 0x0D, 0x03FE, 0x0001, 0x0BFF },
    { 0x0C, 0x03FE, 0x0001, 0x0401 },
    { 0x0C, 0x03FE, 0x0001, 0x0401 },
    { 0x0C, 0x03FE, 0x0001, 0x07FF },
    { 0x0C, 0x03FE, 0x0001, 0x07FF },
    { 0x0A, 0x03FE, 0x0001, 0xFE00 },
    { 0x0A, 0x03FE, 0x0001, 0xFE00 },
    { 0x0A, 0x03FE, 0x0001, 0xFE00 },
    { 0x0A, 0x03FE, 0x0001, 0xFE00 },
    { 0x0A, 0x03FE, 0x0001, 0xFE00 },
    { 0x0A, 0x03FE, 0x0001, 0xFE00 },
    { 0x0A, 0x03FE, 0x0001, 0xFE00 },
    { 0x0A, 0x03FE, 0x0001, 0xFE00 },
    { 0x0B, 0x03FE, 0x0001, 0x0001 },
    { 0x0B, 0x03FE, 0x0001, 0x0001 },
    { 0x0B, 0x03FE, 0x0001, 0x0001 },
    { 0x0B, 0x03FE, 0x0001, 0x0001 },
    { 0x0B, 0x03FE, 0x0001, 0x03FF },
    { 0x0B, 0x03FE, 0x0001, 0x03FF },
    { 0x0B, 0x03FE, 0x0001, 0x03FF },
    { 0x0B, 0x03FE, 0x0001, 0x03FF },
    { 0x08, 0x03FE, 0x03FF, 0x0000 },
    { 0x08, 0x03FE, 0x03FF, 0x0000 },
    { 0x08, 0x03FE, 0x03FF, 0x0000 },
    { 0x08, 0x03FE, 0x03FF, 0x0000 },
    { 0x08, 0x03FE, 0x03FF, 0x0000 },
    { 0x08, 0x03FE, 0x03FF, 0x0000 },
    { 0x08, 0x03FE, 0x03FF, 0x0000 },
    { 0x08, 0x03FE, 0x03FF, 0x0000 },
    { 0x0D, 0x03FE, 0x03FF, 0x0002 },
    { 0x0D, 0x03FE, 0x03FF, 0x03FE },
    { 0x0D, 0x03FE, 0x03FF, 0x0801 },
    { 0x0D, 0x03FE, 0x03FF, 0x0BFF },
    { 0x0C, 0x03FE, 0x03FF, 0x0401 },
    { 0x0C, 0x03FE, 0x03FF, 0x0401 },
    { 0x0C, 0x03FE, 0x03FF, 0x07FF },
    { 0x0C, 0x03FE, 0x03FF, 0x07FF },
    { 0x0A, 0x03FE, 0x03FF, 0xFE00 },
    { 0x0A, 0x03FE, 0x03FF, 0xFE00 },
    { 0x0A, 0x03FE, 0x03FF, 0xFE00 },
    { 0x0A, 0x03FE, 0x03FF, 0xFE00 },
    { 0x0A, 0x03FE, 0x03FF, 0xFE00 },
    { 0x0A, 0x03FE, 0x03FF, 0xFE00 },
    { 0x0A, 0x03FE, 0x03FF, 0xFE00 },
    { 0x0A, 0x03FE, 0x03FF, 0xFE00 },
    { 0x0B, 0x03FE, 0x03FF, 0x0001 },
    { 0x0B, 0x03FE, 0x03FF, 0x0001 },
    { 0x0B, 0x03FE, 0x03FF, 0x0001 },
    { 0x0B, 0x03FE, 0x03FF, 0x0001 },
    { 0x0B, 0x03FE, 0x03FF, 0x03FF },
    { 0x0B, 0x03FE, 0x03FF, 0x03FF },
    { 0x0B, 0x03FE, 0x03FF, 0x03FF },
    { 0x0B, 0x03FE, 0x03FF, 0x03FF },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x0B, 0x0801, 0x7C1F, 0x0000 },
    { 0x0B, 0x0801, 0x7C1F, 0x0000 },
    { 0x0B, 0x0801, 0x7C1F, 0x0000 },
    { 0x0B, 0x0801, 0x7C1F, 0x0000 },
    { 0x0D, 0x0801, 0x0802, 0x0000 },
    { 0x0D, 0x0801, 0x0BFE, 0x0000 },
    { 0x0D, 0x0801, 0x2401, 0x0000 },
    { 0x0D, 0x0801, 0x27FF, 0x0000 },
    { 0x0D, 0x0801, 0x0004, 0x0000 },
    { 0x0D, 0x0801, 0x03FC, 0x0000 },
    { 0x0D, 0x0801, 0x2001, 0x0000 },
    { 0x0D, 0x0801, 0x23FF, 0x0000 },
    { 0x0C, 0x0801, 0x1C01, 0x0000 },
    { 0x0C, 0x0801, 0x1C01, 0x0000 },
    { 0x0C, 0x0801, 0x1FFF, 0x0000 },
    { 0x0C, 0x0801, 0x1FFF, 0x0000 },
    { 0x0C, 0x0801, 0x1801, 0x0000 },
    { 0x0C, 0x0801, 0x1801, 0x0000 },
    { 0x0C, 0x0801, 0x1BFF, 0x0000 },
    { 0x0C, 0x0801, 0x1BFF, 0x0000 },
    { 0x0C, 0x0801, 0x0402, 0x0000 },
    { 0x0C, 0x0801, 0x0402, 0x0000 },
    { 0x0C, 0x0801, 0x07FE, 0x0000 },
    { 0x0C, 0x0801, 0x07FE, 0x0000 },
    { 0x0C, 0x0801, 0x1401, 0x0000 },
    { 0x0C, 0x0801, 0x1401, 0x0000 },
    { 0x0C, 0x0801, 0x17FF, 0x0000 },
    { 0x0C, 0x0801, 0x17FF, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x05, 0x0801, 0x0000, 0x0000 },
    { 0x0B, 0x0801, 0x0003, 0x0000 },
    { 0x0B, 0x0801, 0x0003, 0x0000 },
    { 0x0D, 0x0801, 0x0003, 0xFE00 },
    { 0x0B, 0x0801, 0x0003, 0x0000 },
    { 0x0B, 0x0801, 0x03FD, 0x0000 },
    { 0x0B, 0x0801, 0x03FD, 0x0000 },
    { 0x0D, 0x0801, 0x03FD, 0xFE00 },
    { 0x0B, 0x0801, 0x03FD, 0x0000 },
    { 0x0B, 0x0801, 0x1001, 0x0000 },
    { 0x0B, 0x0801, 0x1001, 0x0000 },
    { 0x0D, 0x0801, 0x1001, 0xFE00 },
    { 0x0B, 0x0801, 0x1001, 0x0000 },
    { 0x0B, 0x0801, 0x13FF, 0x0000 },
    { 0x0B, 0x0801, 0x13FF, 0x0000 },
    { 0x0D, 0x0801, 0x13FF, 0xFE00 },
    { 0x0B, 0x0801, 0x13FF, 0x0000 },
    { 0x0B, 0x0801, 0x0C01, 0x0000 },
    { 0x0B, 0x0801, 0x0C01, 0x0000 },
    { 0x0D, 0x0801, 0x0C01, 0xFE00 },
    { 0x0B, 0x0801, 0x0C01, 0x0000 },
    { 0x0B, 0x0801, 0x0FFF, 0x0000 },
    { 0x0B, 0x0801, 0x0FFF, 0x0000 },
    { 0x0D, 0x0801, 0x0FFF, 0xFE00 },
    { 0x0B, 0x0801, 0x0FFF, 0x0000 },
    { 0x0A, 0x0801, 0x0002, 0x0000 },
    { 0x0A, 0x0801, 0x0002, 0x0000 },
    { 0x0A, 0x0801, 0x0002, 0x0000 },
    { 0x0A, 0x0801, 0x0002, 0x0000 },
    { 0x0C, 0x0801, 0x0002, 0xFE00 },
    { 0x0C, 0x0801, 0x0002, 0xFE00 },
    { 0x0D, 0x0801, 0x0002, 0x0001 },
    { 0x0D, 0x0801, 0x0002, 0x03FF },
    { 0x0A, 0x0801, 0x03FE, 0x0000 },
    { 0x0A, 0x0801, 0x03FE, 0x0000 },
    { 0x0A, 0x0801, 0x03FE, 0x0000 },
    { 0x0A, 0x0801, 0x03FE, 0x0000 },
    { 0x0C, 0x0801, 0x03FE, 0xFE00 },
    { 0x0C, 0x0801, 0x03FE, 0xFE00 },
    { 0x0D, 0x0801, 0x03FE, 0x0001 },
    { 0x0D, 0x0801, 0x03FE, 0x03FF },
    { 0x0A, 0x0801, 0x0801, 0x0000 },
    { 0x0A, 0x0801, 0x0801, 0x0000 },
    { 0x0A, 0x0801, 0x0801, 0x0000 },
    { 0x0A, 0x0801, 0x0801, 0x0000 },
    { 0x0C, 0x0801, 0x0801, 0xFE00 },
    { 0x0C, 0x0801, 0x0801, 0xFE00 },
    { 0x0D, 0x0801, 0x0801, 0x0001 },
    { 0x0D, 0x0801, 0x0801, 0x03FF },
    { 0x0A, 0x0801, 0x0BFF, 0x0000 },
    { 0x0A, 0x0801, 0x0BFF, 0x0000 },
    { 0x0A, 0x0801, 0x0BFF, 0x0000 },
    { 0x0A, 0x0801, 0x0BFF, 0x0000 },
    { 0x0C, 0x0801, 0x0BFF, 0xFE00 },
    { 0x0C, 0x0801, 0x0BFF, 0xFE00 },
    { 0x0D, 0x0801, 0x0BFF, 0x0001 },
    { 0x0D, 0x0801, 0x0BFF, 0x03FF },
    { 0x09, 0x0801, 0x0401, 0x0000 },
    { 0x09, 0x0801, 0x0401, 0x0000 },
    { 0x09, 0x0801, 0x0401, 0x0000 },
    { 0x09, 0x0801, 0x0401, 0x0000 },
    { 0x09, 0x0801, 0x0401, 0x0000 },
    { 0x09, 0x0801, 0x0401, 0x0000 },
    { 0x0D, 0x0801, 0x0401, 0x0401 },
    { 0x0D, 0x0801, 0x0401, 0x07FF },
    { 0x0B, 0x0801, 0x0401, 0xFE00 },
    { 0x0B, 0x0801, 0x0401, 0xFE00 },
    { 0x0B, 0x0801, 0x0401, 0xFE00 },
    { 0x0B, 0x0801, 0x0401, 0xFE00 },
    { 0x0C, 0x0801, 0x0401, 0x0001 },
    { 0x0C, 0x0801, 0x0401, 0x0001 },
    { 0x0C, 0x0801, 0x0401, 0x03FF },
    { 0x0C, 0x0801, 0x0401, 0x03FF },
    { 0x09, 0x0801, 0x07FF, 0x0000 },
    { 0x09, 0x0801, 0x07FF, 0x0000 },
    { 0x09, 0x0801, 0x07FF, 0x0000 },
    { 0x09, 0x0801, 0x07FF, 0x0000 },
    { 0x09, 0x0801, 0x07FF, 0x0000 },
    { 0x09, 0x0801, 0x07FF, 0x0000 },
    { 0x0D, 0x0801, 0x07FF, 0x0401 },
    { 0x0D, 0x0801, 0x07FF, 0x07FF },
    { 0x0B, 0x0801, 0x07FF, 0xFE00 },
    { 0x0B, 0x0801, 0x07FF, 0xFE00 },
    { 0x0B, 0x0801, 0x07FF, 0xFE00 },
    { 0x0B, 0x0801, 0x07FF, 0xFE00 },
    { 0x0C, 0x0801, 0x07FF, 0x0001 },
    { 0x0C, 0x0801, 0x07FF, 0x0001 },
    { 0x0C, 0x0801, 0x07FF, 0x03FF },
    { 0x0C, 0x0801, 0x07FF, 0x03FF },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x07, 0x0801, 0xFE00, 0x0000 },
    { 0x08, 0x0801, 0x0001, 0x0000 },
    { 0x08, 0x0801, 0x0001, 0x0000 },
    { 0x08, 0x0801, 0x0001, 0x0000 },
    { 0x08, 0x0801, 0x0001, 0x0000 },
    { 0x08, 0x0801, 0x0001, 0x0000 },
    { 0x08, 0x0801, 0x0001, 0x0000 },
    { 0x08, 0x0801, 0x0001, 0x0000 },
    { 0x08, 0x0801, 0x0001, 0x0000 },
    { 0x0D, 0x0801, 0x0001, 0x0002 },
    { 0x0D, 0x0801, 0x0001, 0x03FE },
    { 0x0D, 0x0801, 0x0001, 0x0801 },
    { 0x0D, 0x0801, 0x0001, 0x0BFF },
    { 0x0C, 0x0801, 0x0001, 0x0401 },
    { 0x0C, 0x0801, 0x0001, 0x0401 },
    { 0x0C, 0x0801, 0x0001, 0x07FF },
    { 0x0C, 0x0801, 0x0001, 0x07FF },
    { 0x0A, 0x0801, 0x0001, 0xFE00 },
    { 0x0A, 0x0801, 0x0001, 0xFE00 },
    { 0x0A, 0x0801, 0x0001, 0xFE00 },
    { 0x0A, 0x0801, 0x0001, 0xFE00 },
    { 0x0A, 0x0801, 0x0001, 0xFE00 },
    { 0x0A, 0x0801, 0x0001, 0xFE00 },
    { 0x0A, 0x0801, 0x0001, 0xFE00 },
    { 0x0A, 0x0801, 0x0001, 0xFE00 },
    { 0x0B, 0x0801, 0x0001, 0x0001 },
    { 0x0B, 0x0801, 0x0001, 0x0001 },
    { 0x0B, 0x0801, 0x0001, 0x0001 },
    { 0x0B, 0x0801, 0x0001, 0x0001 },
    { 0x0B, 0x0801, 0x0001, 0x03FF },
    { 0x0B, 0x0801, 0x0001, 0x03FF },
    { 0x0B, 0x0801, 0x0001, 0x03FF },
    { 0x0B, 0x0801, 0x0001, 0x03FF },
    { 0x08, 0x0801, 0x03FF, 0x0000 },
    { 0x08, 0x0801, 0x03FF, 0x0000 },
    { 0x08, 0x0801, 0x03FF, 0x0000 },
    { 0x08, 0x0801, 0x03FF, 0x0000 },
    { 0x08, 0x0801, 0x03FF, 0x0000 },
    { 0x08, 0x0801, 0x03FF, 0x0000 },
    { 0x08, 0x0801, 0x03FF, 0x0000 },
    { 0x08, 0x0801, 0x03FF, 0x0000 },
    { 0x0D, 0x0801, 0x03FF, 0x0002 },
    { 0x0D, 0x0801, 0x03FF, 0x03FE },
    { 0x0D, 0x0801, 0x03FF, 0x0801 },
    { 0x0D, 0x0801, 0x03FF, 0x0BFF },
    { 0x0C, 0x0801, 0x03FF, 0x0401 },
    { 0x0C, 0x0801, 0x03FF, 0x0401 },
    { 0x0C, 0x0801, 0x03FF, 0x07FF },
    { 0x0C, 0x0801, 0x03FF, 0x07FF },
    { 0x0A, 0x0801, 0x03FF, 0xFE00 },
    { 0x0A, 0x0801, 0x03FF, 0xFE00 },
    { 0x0A, 0x0801, 0x03FF, 0xFE00 },
    { 0x0A, 0x0801, 0x03FF, 0xFE00 },
    { 0x0A, 0x0801, 0x03FF, 0xFE00 },
    { 0x0A, 0x0801, 0x03FF, 0xFE00 },
    { 0x0A, 0x0801, 0x03FF, 0xFE00 },
    { 0x0A, 0x0801, 0x03FF, 0xFE00 },
    { 0x0B, 0x0801, 0x03FF, 0x0001 },
    { 0x0B, 0x0801, 0x03FF, 0x0001 },
    { 0x0B, 0x0801, 0x03FF, 0x0001 },
    { 0x0B, 0x0801, 0x03FF, 0x0001 },
    { 0x0B, 0x0801, 0x03FF, 0x03FF },
    { 0x0B, 0x0801, 0x03FF, 0x03FF },
    { 0x0B, 0x0801, 0x03FF, 0x03FF },
    { 0x0B, 0x0801, 0x03FF, 0x03FF },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x0B, 0x0BFF, 0x7C1F, 0x0000 },
    { 0x0B, 0x0BFF, 0x7C1F, 0x0000 },
    { 0x0B, 0x0BFF, 0x7C1F, 0x0000 },
    { 0x0B, 0x0BFF, 0x7C1F, 0x0000 },
    { 0x0D, 0x0BFF, 0x0802, 0x0000 },
    { 0x0D, 0x0BFF, 0x0BFE, 0x0000 },
    { 0x0D, 0x0BFF, 0x2401, 0x0000 },
    { 0x0D, 0x0BFF, 0x27FF, 0x0000 },
    { 0x0D, 0x0BFF, 0x0004, 0x0000 },
    { 0x0D, 0x0BFF, 0x03FC, 0x0000 },
    { 0x0D, 0x0BFF, 0x2001, 0x0000 },
    { 0x0D, 0x0BFF, 0x23FF, 0x0000 },
    { 0x0C, 0x0BFF, 0x1C01, 0x0000 },
    { 0x0C, 0x0BFF, 0x1C01, 0x0000 },
    { 0x0C, 0x0BFF, 0x1FFF, 0x0000 },
    { 0x0C, 0x0BFF, 0x1FFF, 0x0000 },
    { 0x0C, 0x0BFF, 0x1801, 0x0000 },
    { 0x0C, 0x0BFF, 0x1801, 0x0000 },
    { 0x0C, 0x0BFF, 0x1BFF, 0x0000 },
    { 0x0C, 0x0BFF, 0x1BFF, 0x0000 },
    { 0x0C, 0x0BFF, 0x0402, 0x0000 },
    { 0x0C, 0x0BFF, 0x0402, 0x0000 },
    { 0x0C, 0x0BFF, 0x07FE, 0x0000 },
    { 0x0C, 0x0BFF, 0x07FE, 0x0000 },
    { 0x0C, 0x0BFF, 0x1401, 0x0000 },
    { 0x0C, 0x0BFF, 0x1401, 0x0000 },
    { 0x0C, 0x0BFF, 0x17FF, 0x0000 },
    { 0x0C, 0x0BFF, 0x17FF, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x05, 0x0BFF, 0x0000, 0x0000 },
    { 0x0B, 0x0BFF, 0x0003, 0x0000 },
    { 0x0B, 0x0BFF, 0x0003, 0x0000 },
    { 0x0D, 0x0BFF, 0x0003, 0xFE00 },
    { 0x0B, 0x0BFF, 0x0003, 0x0000 },
    { 0x0B, 0x0BFF, 0x03FD, 0x0000 },
    { 0x0B, 0x0BFF, 0x03FD, 0x0000 },
    { 0x0D, 0x0BFF, 0x03FD, 0xFE00 },
    { 0x0B, 0x0BFF, 0x03FD, 0x0000 },
    { 0x0B, 0x0BFF, 0x1001, 0x0000 },
    { 0x0B, 0x0BFF, 0x1001, 0x0000 },
    { 0x0D, 0x0BFF, 0x1001, 0xFE00 },
    { 0x0B, 0x0BFF, 0x1001, 0x0000 },
    { 0x0B, 0x0BFF, 0x13FF, 0x0000 },
    { 0x0B, 0x0BFF, 0x13FF, 0x0000 },
    { 0x0D, 0x0BFF, 0x13FF, 0xFE00 },
    { 0x0B, 0x0BFF, 0x13FF, 0x0000 },
    { 0x0B, 0x0BFF, 0x0C01, 0x0000 },
    { 0x0B, 0x0BFF, 0x0C01, 0x0000 },
    { 0x0D, 0x0BFF, 0x0C01, 0xFE00 },
    { 0x0B, 0x0BFF, 0x0C01, 0x0000 },
    { 0x0B, 0x0BFF, 0x0FFF, 0x0000 },
    { 0x0B, 0x0BFF, 0x0FFF, 0x0000 },
    { 0x0D, 0x0BFF, 0x0FFF, 0xFE00 },
    { 0x0B, 0x0BFF, 0x0FFF, 0x0000 },
    { 0x0A, 0x0BFF, 0x0002, 0x0000 },
    { 0x0A, 0x0BFF, 0x0002, 0x0000 },
    { 0x0A, 0x0BFF, 0x0002, 0x0000 },
    { 0x0A, 0x0BFF, 0x0002, 0x0000 },
    { 0x0C, 0x0BFF, 0x0002, 0xFE00 },
    { 0x0C, 0x0BFF, 0x0002, 0xFE00 },
    { 0x0D, 0x0BFF, 0x0002, 0x0001 },
    { 0x0D, 0x0BFF, 0x0002, 0x03FF },
    { 0x0A, 0x0BFF, 0x03FE, 0x0000 },
    { 0x0A, 0x0BFF, 0x03FE, 0x0000 },
    { 0x0A, 0x0BFF, 0x03FE, 0x0000 },
    { 0x0A, 0x0BFF, 0x03FE, 0x0000 },
    { 0x0C, 0x0BFF, 0x03FE, 0xFE00 },
    { 0x0C, 0x0BFF, 0x03FE, 0xFE00 },
    { 0x0D, 0x0BFF, 0x03FE, 0x0001 },
    { 0x0D, 0x0BFF, 0x03FE, 0x03FF },
    { 0x0A, 0x0BFF, 0x0801, 0x0000 },
    { 0x0A, 0x0BFF, 0x0801, 0x0000 },
    { 0x0A, 0x0BFF, 0x0801, 0x0000 },
    { 0x0A, 0x0BFF, 0x0801, 0x0000 },
    { 0x0C, 0x0BFF, 0x0801, 0xFE00 },
    { 0x0C, 0x0BFF, 0x0801, 0xFE00 },
    { 0x0D, 0x0BFF, 0x0801, 0x0001 },
    { 0x0D, 0x0BFF, 0x0801, 0x03FF },
    { 0x0A, 0x0BFF, 0x0BFF, 0x0000 },
    { 0x0A, 0x0BFF, 0x0BFF, 0x0000 },
    { 0x0A, 0x0BFF, 0x0BFF, 0x0000 },
    { 0x0A, 0x0BFF, 0x0BFF, 0x0000 },
    { 0x0C, 0x0BFF, 0x0BFF, 0xFE00 },
    { 0x0C, 0x0BFF, 0x0BFF, 0xFE00 },
    { 0x0D, 0x0BFF, 0x0BFF, 0x0001 },
    { 0x0D, 0x0BFF, 0x0BFF, 0x03FF },
    { 0x09, 0x0BFF, 0x0401, 0x0000 },
    { 0x09, 0x0BFF, 0x0401, 0x0000 },
    { 0x09, 0x0BFF, 0x0401, 0x0000 },
    { 0x09, 0x0BFF, 0x0401, 0x0000 },
    { 0x09, 0x0BFF, 0x0401, 0x0000 },
    { 0x09, 0x0BFF, 0x0401, 0x0000 },
    { 0x0D, 0x0BFF, 0x0401, 0x0401 },
    { 0x0D, 0x0BFF, 0x0401, 0x07FF },
    { 0x0B, 0x0BFF, 0x0401, 0xFE00 },
    { 0x0B, 0x0BFF, 0x0401, 0xFE00 },
    { 0x0B, 0x0BFF, 0x0401, 0xFE00 },
    { 0x0B, 0x0BFF, 0x0401, 0xFE00 },
    { 0x0C, 0x0BFF, 0x0401, 0x0001 },
    { 0x0C, 0x0BFF, 0x0401, 0x0001 },
    { 0x0C, 0x0BFF, 0x0401, 0x03FF },
    { 0x0C, 0x0BFF, 0x0401, 0x03FF },
    { 0x09, 0x0BFF, 0x07FF, 0x0000 },
    { 0x09, 0x0BFF, 0x07FF, 0x0000 },
    { 0x09, 0x0BFF, 0x07FF, 0x0000 },
    { 0x09, 0x0BFF, 0x07FF, 0x0000 },
    { 0x09, 0x0BFF, 0x07FF, 0x0000 },
    { 0x09, 0x0BFF, 0x07FF, 0x0000 },
    { 0x0D, 0x0BFF, 0x07FF, 0x0401 },
    { 0x0D, 0x0BFF, 0x07FF, 0x07FF },
    { 0x0B, 0x0BFF, 0x07FF, 0xFE00 },
    { 0x0B, 0x0BFF, 0x07FF, 0xFE00 },
    { 0x0B, 0x0BFF, 0x07FF, 0xFE00 },
    { 0x0B, 0x0BFF, 0x07FF, 0xFE00 },
    { 0x0C, 0x0BFF, 0x07FF, 0x0001 },
    { 0x0C, 0x0BFF, 0x07FF, 0x0001 },
    { 0x0C, 0x0BFF, 0x07FF, 0x03FF },
    { 0x0C, 0x0BFF, 0x07FF, 0x03FF },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x07, 0x0BFF, 0xFE00, 0x0000 },
    { 0x08, 0x0BFF, 0x0001, 0x0000 },
    { 0x08, 0x0BFF, 0x0001, 0x0000 },
    { 0x08, 0x0BFF, 0x0001, 0x0000 },
    { 0x08, 0x0BFF, 0x0001, 0x0000 },
    { 0x08, 0x0BFF, 0x0001, 0x0000 },
    { 0x08, 0x0BFF, 0x0001, 0x0000 },
    { 0x08, 0x0BFF, 0x0001, 0x0000 },
    { 0x08, 0x0BFF, 0x0001, 0x0000 },
    { 0x0D, 0x0BFF, 0x0001, 0x0002 },
    { 0x0D, 0x0BFF, 0x0001, 0x03FE },
    { 0x0D, 0x0BFF, 0x0001, 0x0801 },
    { 0x0D, 0x0BFF, 0x0001, 0x0BFF },
    { 0x0C, 0x0BFF, 0x0001, 0x0401 },
    { 0x0C, 0x0BFF, 0x0001, 0x0401 },
    { 0x0C, 0x0BFF, 0x0001, 0x07FF },
    { 0x0C, 0x0BFF, 0x0001, 0x07FF },
    { 0x0A, 0x0BFF, 0x0001, 0xFE00 },
    { 0x0A, 0x0BFF, 0x0001, 0xFE00 },
    { 0x0A, 0x0BFF, 0x0001, 0xFE00 },
    { 0x0A, 0x0BFF, 0x0001, 0xFE00 },
    { 0x0A, 0x0BFF, 0x0001, 0xFE00 },
    { 0x0A, 0x0BFF, 0x0001, 0xFE00 },
    { 0x0A, 0x0BFF, 0x0001, 0xFE00 },
    { 0x0A, 0x0BFF, 0x0001, 0xFE00 },
    { 0x0B, 0x0BFF, 0x0001, 0x0001 },
    { 0x0B, 0x0BFF, 0x0001, 0x0001 },
    { 0x0B, 0x0BFF, 0x0001, 0x0001 },
    { 0x0B, 0x0BFF, 0x0001, 0x0001 },
    { 0x0B, 0x0BFF, 0x0001, 0x03FF },
    { 0x0B, 0x0BFF, 0x0001, 0x03FF },
    { 0x0B, 0x0BFF, 0x0001, 0x03FF },
    { 0x0B, 0x0BFF, 0x0001, 0x03FF },
    { 0x08, 0x0BFF, 0x03FF, 0x0000 },
    { 0x08, 0x0BFF, 0x03FF, 0x0000 },
    { 0x08, 0x0BFF, 0x03FF, 0x0000 },
    { 0x08, 0x0BFF, 0x03FF, 0x0000 },
    { 0x08, 0x0BFF, 0x03FF, 0x0000 },
    { 0x08, 0x0BFF, 0x03FF, 0x0000 },
    { 0x08, 0x0BFF, 0x03FF, 0x0000 },
    { 0x08, 0x0BFF, 0x03FF, 0x0000 },
    { 0x0D, 0x0BFF, 0x03FF, 0x0002 },
    { 0x0D, 0x0BFF, 0x03FF, 0x03FE },
    { 0x0D, 0x0BFF, 0x03FF, 0x0801 },
    { 0x0D, 0x0BFF, 0x03FF, 0x0BFF },
    { 0x0C, 0x0BFF, 0x03FF, 0x0401 },
    { 0x0C, 0x0BFF, 0x03FF, 0x0401 },
    { 0x0C, 0x0BFF, 0x03FF, 0x07FF },
    { 0x0C, 0x0BFF, 0x03FF, 0x07FF },
    { 0x0A, 0x0BFF, 0x03FF, 0xFE00 },
    { 0x0A, 0x0BFF, 0x03FF, 0xFE00 },
    { 0x0A, 0x0BFF, 0x03FF, 0xFE00 },
    { 0x0A, 0x0BFF, 0x03FF, 0xFE00 },
    { 0x0A, 0x0BFF, 0x03FF, 0xFE00 },
    { 0x0A, 0x0BFF, 0x03FF, 0xFE00 },
    { 0x0A, 0x0BFF, 0x03FF, 0xFE00 },
    { 0x0A, 0x0BFF, 0x03FF, 0xFE00 },
    { 0x0B, 0x0BFF, 0x03FF, 0x0001 },
    { 0x0B, 0x0BFF, 0x03FF, 0x0001 },
    { 0x0B, 0x0BFF, 0x03FF, 0x0001 },
    { 0x0B, 0x0BFF, 0x03FF, 0x0001 },
    { 0x0B, 0x0BFF, 0x03FF, 0x03FF },
    { 0x0B, 0x0BFF, 0x03FF, 0x03FF },
    { 0x0B, 0x0BFF, 0x03FF, 0x03FF },
    { 0x0B, 0x0BFF, 0x03FF, 0x03FF },
    { 0x04, 0x0401, 0x0000, 0x0000 },
    { 0x04, 0x0401, 0x0000, 0x0000 },
    { 0x04, 0x0401, 0x0000, 0x0000 },
    { 0x04, 0x0401, 0x0000, 0x0000 },
    { 0x04, 0x0401, 0x0000, 0x0000 },
    { 0x04, 0x0401, 0x0000, 0x0000 },
    { 0x04, 0x0401, 0x0000, 0x0000 },
    { 0x04, 0x0401, 0x0000, 0x0000 },
    { 0x0A, 0x0401, 0x7C1F, 0x0000 },
    { 0x0A, 0x0401, 0x7C1F, 0x0000 },
    { 0x0A, 0x0401, 0x7C1F, 0x0000 },
    { 0x0A, 0x0401, 0x7C1F, 0x0000 },
    { 0x0A, 0x0401, 0x7C1F, 0x0000 },
    { 0x0A, 0x0401, 0x7C1F, 0x0000 },
    { 0x0A, 0x0401, 0x7C1F, 0x0000 },
    { 0x0A, 0x0401, 0x7C1F, 0x0000 },
    { 0x0C, 0x0401, 0x0802, 0x0000 },
    { 0x0C, 0x0401, 0x0802, 0x0000 },
    { 0x0C, 0x0401, 0x0BFE, 0x0000 },
    { 0x0C, 0x0401, 0x0BFE, 0x0000 },
    { 0x0C, 0x0401, 0x2401, 0x0000 },
    { 0x0C, 0x0401, 0x2401, 0x0000 },
    { 0x0C, 0x0401, 0x27FF, 0x0000 },
    { 0x0C, 0x0401, 0x27FF, 0x0000 },
    { 0x0C, 0x0401, 0x0004, 0x0000 },
    { 0x0C, 0x0401, 0x0004, 0x0000 },
    { 0x0C, 0x0401, 0x03FC, 0x0000 },
    { 0x0C, 0x0401, 0x03FC, 0x0000 },
    { 0x0C, 0x0401, 0x2001, 0x0000 },
    { 0x0C, 0x0401, 0x2001, 0x0000 },
    { 0x0C, 0x0401, 0x23FF, 0x0000 },
    { 0x0C, 0x0401, 0x23FF, 0x0000 },
    { 0x0B, 0x0401, 0x1C01, 0x0000 },
    { 0x0B, 0x0401, 0x1C01, 0x0000 },
    { 0x0D, 0x0401, 0x1C01, 0xFE00 },
    { 0x0B, 0x0401, 0x1C01, 0x0000 },
    { 0x0B, 0x0401, 0x1FFF, 0x0000 },
    { 0x0B, 0x0401, 0x1FFF, 0x0000 },
    { 0x0D, 0x0401, 0x1FFF, 0xFE00 },
    { 0x0B, 0x0401, 0x1FFF, 0x0000 },
    { 0x0B, 0x0401, 0x1801, 0x0000 },
    { 0x0B, 0x0401, 0x1801, 0x0000 },
    { 0x0D, 0x0401, 0x1801, 0xFE00 },
    { 0x0B, 0x0401, 0x1801, 0x0000 },
    { 0x0B, 0x0401, 0x1BFF, 0x0000 },
    { 0x0B, 0x0401, 0x1BFF, 0x0000 },
    { 0x0D, 0x0401, 0x1BFF, 0xFE00 },
    { 0x0B, 0x0401, 0x1BFF, 0x0000 },
    { 0x0B, 0x0401, 0x0402, 0x0000 },
    { 0x0B, 0x0401, 0x0402, 0x0000 },
    { 0x0D, 0x0401, 0x0402, 0xFE00 },
    { 0x0B, 0x0401, 0x0402, 0x0000 },
    { 0x0B, 0x0401, 0x07FE, 0x0000 },
    { 0x0B, 0x0401, 0x07FE, 0x0000 },
    { 0x0D, 0x0401, 0x07FE, 0xFE00 },
    { 0x0B, 0x0401, 0x07FE, 0x0000 },
    { 0x0B, 0x0401, 0x1401, 0x0000 },
    { 0x0B, 0x0401, 0x1401, 0x0000 },
    { 0x0D, 0x0401, 0x1401, 0xFE00 },
    { 0x0B, 0x0401, 0x1401, 0x0000 },
    { 0x0B, 0x0401, 0x17FF, 0x0000 },
    { 0x0B, 0x0401, 0x17FF, 0x0000 },
    { 0x0D, 0x0401, 0x17FF, 0xFE00 },
    { 0x0B, 0x0401, 0x17FF, 0x0000 },
    { 0x0D, 0x0401, 0x3401, 0x0000 },
    { 0x0D, 0x0401, 0x37FF, 0x0000 },
    { 0x0D, 0x0401, 0x0006, 0x0000 },
    { 0x0D, 0x0401, 0x03FA, 0x0000 },
    { 0x0D, 0x0401, 0x3001, 0x0000 },
    { 0x0D, 0x0401, 0x33FF, 0x0000 },
    { 0x0D, 0x0401, 0x2C01, 0x0000 },
    { 0x0D, 0x0401, 0x2FFF, 0x0000 },
    { 0x0D, 0x0401, 0x0C02, 0x0000 },
    { 0x0D, 0x0401, 0x0FFE, 0x0000 },
    { 0x0D, 0x0401, 0x0403, 0x0000 },
    { 0x0D, 0x0401, 0x07FD, 0x0000 },
    { 0x0D, 0x0401, 0x0005, 0x0000 },
    { 0x0D, 0x0401, 0x03FB, 0x0000 },
    { 0x0D, 0x0401, 0x2801, 0x0000 },
    { 0x0D, 0x0401, 0x2BFF, 0x0000 },
    { 0x0A, 0x0401, 0x0003, 0x0000 },
    { 0x0A, 0x0401, 0x0003, 0x0000 },
    { 0x0A, 0x0401, 0x0003, 0x0000 },
    { 0x0A, 0x0401, 0x0003, 0x0000 },
    { 0x0C, 0x0401, 0x0003, 0xFE00 },
    { 0x0C, 0x0401, 0x0003, 0xFE00 },
    { 0x0D, 0x0401, 0x0003, 0x0001 },
    { 0x0D, 0x0401, 0x0003, 0x03FF },
    { 0x0A, 0x0401, 0x03FD, 0x0000 },
    { 0x0A, 0x0401, 0x03FD, 0x0000 },
    { 0x0A, 0x0401, 0x03FD, 0x0000 },
    { 0x0A, 0x0401, 0x03FD, 0x0000 },
    { 0x0C, 0x0401, 0x03FD, 0xFE00 },
    { 0x0C, 0x0401, 0x03FD, 0xFE00 },
    { 0x0D, 0x0401, 0x03FD, 0x0001 },
    { 0x0D, 0x0401, 0x03FD, 0x03FF },
    { 0x0A, 0x0401, 0x1001, 0x0000 },
    { 0x0A, 0x0401, 0x1001, 0x0000 },
    { 0x0A, 0x0401, 0x1001, 0x0000 },
    { 0x0A, 0x0401, 0x1001, 0x0000 },
    { 0x0C, 0x0401, 0x1001, 0xFE00 },
    { 0x0C, 0x0401, 0x1001, 0xFE00 },
    { 0x0D, 0x0401, 0x1001, 0x0001 },
    { 0x0D, 0x0401, 0x1001, 0x03FF },
    { 0x0A, 0x0401, 0x13FF, 0x0000 },
    { 0x0A, 0x0401, 0x13FF, 0x0000 },
    { 0x0A, 0x0401, 0x13FF, 0x0000 },
    { 0x0A, 0x0401, 0x13FF, 0x0000 },
    { 0x0C, 0x0401, 0x13FF, 0xFE00 },
    { 0x0C, 0x0401, 0x13FF, 0xFE00 },
    { 0x0D, 0x0401, 0x13FF, 0x0001 },
    { 0x0D, 0x0401, 0x13FF, 0x03FF },
    { 0x0A, 0x0401, 0x0C01, 0x0000 },
    { 0x0A, 0x0401, 0x0C01, 0x0000 },
    { 0x0A, 0x0401, 0x0C01, 0x0000 },
    { 0x0A, 0x0401, 0x0C01, 0x0000 },
    { 0x0C, 0x0401, 0x0C01, 0xFE00 },
    { 0x0C, 0x0401, 0x0C01, 0xFE00 },
    { 0x0D, 0x0401, 0x0C01, 0x0001 },
    { 0x0D, 0x0401, 0x0C01, 0x03FF },
    { 0x0A, 0x0401, 0x0FFF, 0x0000 },
    { 0x0A, 0x0401, 0x0FFF, 0x0000 },
    { 0x0A, 0x0401, 0x0FFF, 0x0000 },
    { 0x0A, 0x0401, 0x0FFF, 0x0000 },
    { 0x0C, 0x0401, 0x0FFF, 0xFE00 },
    { 0x0C, 0x0401, 0x0FFF, 0xFE00 },
    { 0x0D, 0x0401, 0x0FFF, 0x0001 },
    { 0x0D, 0x0401, 0x0FFF, 0x03FF },
    { 0x09, 0x0401, 0x0002, 0x0000 },
    { 0x09, 0x0401, 0x0002, 0x0000 },
    { 0x09, 0x0401, 0x0002, 0x0000 },
    { 0x09, 0x0401, 0x0002, 0x0000 },
    { 0x09, 0x0401, 0x0002, 0x0000 },
    { 0x09, 0x0401, 0x0002, 0x0000 },
    { 0x0D, 0x0401, 0x0002, 0x0401 },
    { 0x0D, 0x0401, 0x0002, 0x07FF },
    { 0x0B, 0x0401, 0x0002, 0xFE00 },
    { 0x0B, 0x0401, 0x0002, 0xFE00 },
    { 0x0B, 0x0401, 0x0002, 0xFE00 },
    { 0x0B, 0x0401, 0x0002, 0xFE00 },
    { 0x0C, 0x0401, 0x0002, 0x0001 },
    { 0x0C, 0x0401, 0x0002, 0x0001 },
    { 0x0C, 0x0401, 0x0002, 0x03FF },
    { 0x0C, 0x0401, 0x0002, 0x03FF },
    { 0x09, 0x0401, 0x03FE, 0x0000 },
    { 0x09, 0x0401, 0x03FE, 0x0000 },
    { 0x09, 0x0401, 0x03FE, 0x0000 },
    { 0x09, 0x0401, 0x03FE, 0x0000 },
    { 0x09, 0x0401, 0x03FE, 0x0000 },
    { 0x09, 0x0401, 0x03FE, 0x0000 },
    { 0x0D, 0x0401, 0x03FE, 0x0401 },
    { 0x0D, 0x0401, 0x03FE, 0x07FF },
    { 0x0B, 0x0401, 0x03FE, 0xFE00 },
    { 0x0B, 0x0401, 0x03FE, 0xFE00 },
    { 0x0B, 0x0401, 0x03FE, 0xFE00 },
    { 0x0B, 0x0401, 0x03FE, 0xFE00 },
    { 0x0C, 0x0401, 0x03FE, 0x0001 },
    { 0x0C, 0x0401, 0x03FE, 0x0001 },
    { 0x0C, 0x0401, 0x03FE, 0x03FF },
    { 0x0C, 0x0401, 0x03FE, 0x03FF },
    { 0x09, 0x0401, 0x0801, 0x0000 },
    { 0x09, 0x0401, 0x0801, 0x0000 },
    { 0x09, 0x0401, 0x0801, 0x0000 },
    { 0x09, 0x0401, 0x0801, 0x0000 },
    { 0x09, 0x0401, 0x0801, 0x0000 },
    { 0x09, 0x0401, 0x0801, 0x0000 },
    { 0x0D, 0x0401, 0x0801, 0x0401 },
    { 0x0D, 0x0401, 0x0801, 0x07FF },
    { 0x0B, 0x0401, 0x0801, 0xFE00 },
    { 0x0B, 0x0401, 0x0801, 0xFE00 },
    { 0x0B, 0x0401, 0x0801, 0xFE00 },
    { 0x0B, 0x0401, 0x0801, 0xFE00 },
    { 0x0C, 0x0401, 0x0801, 0x0001 },
    { 0x0C, 0x0401, 0x0801, 0x0001 },
    { 0x0C, 0x0401, 0x0801, 0x03FF },
    { 0x0C, 0x0401, 0x0801, 0x03FF },
    { 0x09, 0x0401, 0x0BFF, 0x0000 },
    { 0x09, 0x0401, 0x0BFF, 0x0000 },
    { 0x09, 0x0401, 0x0BFF, 0x0000 },
    { 0x09, 0x0401, 0x0BFF, 0x0000 },
    { 0x09, 0x0401, 0x0BFF, 0x0000 },
    { 0x09, 0x0401, 0x0BFF, 0x0000 },
    { 0x0D, 0x0401, 0x0BFF, 0x0401 },
    { 0x0D, 0x0401, 0x0BFF, 0x07FF },
    { 0x0B, 0x0401, 0x0BFF, 0xFE00 },
    { 0x0B, 0x0401, 0x0BFF, 0xFE00 },
    { 0x0B, 0x0401, 0x0BFF, 0xFE00 },
    { 0x0B, 0x0401, 0x0BFF, 0xFE00 },
    { 0x0C, 0x0401, 0x0BFF, 0x0001 },
    { 0x0C, 0x0401, 0x0BFF, 0x0001 },
    { 0x0C, 0x0401, 0x0BFF, 0x03FF },
    { 0x0C, 0x0401, 0x0BFF, 0x03FF },
    { 0x08, 0x0401, 0x0401, 0x0000 },
    { 0x08, 0x0401, 0x0401, 0x0000 },
    { 0x08, 0x0401, 0x0401, 0x0000 },
    { 0x08, 0x0401, 0x0401, 0x0000 },
    { 0x08, 0x0401, 0x0401, 0x0000 },
    { 0x08, 0x0401, 0x0401, 0x0000 },
    { 0x08, 0x0401, 0x0401, 0x0000 },
    { 0x08, 0x0401, 0x0401, 0x0000 },
    { 0x0D, 0x0401, 0x0401, 0x0002 },
    { 0x0D, 0x0401, 0x0401, 0x03FE },
    { 0x0D, 0x0401, 0x0401, 0x0801 },
    { 0x0D, 0x0401, 0x0401, 0x0BFF },
    { 0x0C, 0x0401, 0x0401, 0x0401 },
    { 0x0C, 0x0401, 0x0401, 0x0401 },
    { 0x0C, 0x0401, 0x0401, 0x07FF },
    { 0x0C, 0x0401, 0x0401, 0x07FF },
    { 0x0A, 0x0401, 0x0401, 0xFE00 },
    { 0x0A, 0x0401, 0x0401, 0xFE00 },
    { 0x0A, 0x0401, 0x0401, 0xFE00 },
    { 0x0A, 0x0401, 0x0401, 0xFE00 },
    { 0x0A, 0x0401, 0x0401, 0xFE00 },
    { 0x0A, 0x0401, 0x0401, 0xFE00 },
    { 0x0A, 0x0401, 0x0401, 0xFE00 },
    { 0x0A, 0x0401, 0x0401, 0xFE00 },
    { 0x0B, 0x0401, 0x0401, 0x0001 },
    { 0x0B, 0x0401, 0x0401, 0x0001 },
    { 0x0B, 0x0401, 0x0401, 0x0001 },
    { 0x0B, 0x0401, 0x0401, 0x0001 },
    { 0x0B, 0x0401, 0x0401, 0x03FF },
    { 0x0B, 0x0401, 0x0401, 0x03FF },
    { 0x0B, 0x0401, 0x0401, 0x03FF },
    { 0x0B, 0x0401, 0x0401, 0x03FF },
    { 0x08, 0x0401, 0x07FF, 0x0000 },
    { 0x08, 0x0401, 0x07FF, 0x0000 },
    { 0x08, 0x0401, 0x07FF, 0x0000 },
    { 0x08, 0x0401, 0x07FF, 0x0000 },
    { 0x08, 0x0401, 0x07FF, 0x0000 },
    { 0x08, 0x0401, 0x07FF, 0x0000 },
    { 0x08, 0x0401, 0x07FF, 0x0000 },
    { 0x08, 0x0401, 0x07FF, 0x0000 },
    { 0x0D, 0x0401, 0x07FF, 0x0002 },
    { 0x0D, 0x0401, 0x07FF, 0x03FE },
    { 0x0D, 0x0401, 0x07FF, 0x0801 },
    { 0x0D, 0x0401, 0x07FF, 0x0BFF },
    { 0x0C, 0x0401, 0x07FF, 0x0401 },
    { 0x0C, 0x0401, 0x07FF, 0x0401 },
    { 0x0C, 0x0401, 0x07FF, 0x07FF },
    { 0x0C, 0x0401, 0x07FF, 0x07FF },
    { 0x0A, 0x0401, 0x07FF, 0xFE00 },
    { 0x0A, 0x0401, 0x07FF, 0xFE00 },
    { 0x0A, 0x0401, 0x07FF, 0xFE00 },
    { 0x0A, 0x0401, 0x07FF, 0xFE00 },
    { 0x0A, 0x0401, 0x07FF, 0xFE00 },
    { 0x0A, 0x0401, 0x07FF, 0xFE00 },
    { 0x0A, 0x0401, 0x07FF, 0xFE00 },
    { 0x0A, 0x0401, 0x07FF, 0xFE00 },
    { 0x0B, 0x0401, 0x07FF, 0x0001 },
    { 0x0B, 0x0401, 0x07FF, 0x0001 },
    { 0x0B, 0x0401, 0x07FF, 0x0001 },
    { 0x0B, 0x0401, 0x07FF, 0x0001 },
    { 0x0B, 0x0401, 0x07FF, 0x03FF },
    { 0x0B, 0x0401, 0x07FF, 0x03FF },
    { 0x0B, 0x0401, 0x07FF, 0x03FF },
    { 0x0B, 0x0401, 0x07FF, 0x03FF },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x06, 0x0401, 0xFE00, 0x0000 },
    { 0x07, 0x0401, 0x0001, 0x0000 },
    { 0x0D, 0x0401, 0x0001, 0x7C1F },
    { 0x07, 0x0401, 0x0001, 0x0000 },
    { 0x07, 0x0401, 0x0001, 0x0000 },
    { 0x07, 0x0401, 0x0001, 0x0000 },
    { 0x07, 0x0401, 0x0001, 0x0000 },
    { 0x07, 0x0401, 0x0001, 0x0000 },
    { 0x07, 0x0401, 0x0001, 0x0000 },
    { 0x07, 0x0401, 0x0001, 0x0000 },
    { 0x07, 0x0401, 0x0001, 0x0000 },
    { 0x0D, 0x0401, 0x0001, 0x0003 },
    { 0x0D, 0x0401, 0x0001, 0x03FD },
    { 0x0D, 0x0401, 0x0001, 0x1001 },
    { 0x0D, 0x0401, 0x0001, 0x13FF },
    { 0x0D, 0x0401, 0x0001, 0x0C01 },
    { 0x0D, 0x0401, 0x0001, 0x0FFF },
    { 0x0C, 0x0401, 0x0001, 0x0002 },
    { 0x0C, 0x0401, 0x0001, 0x0002 },
    { 0x0C, 0x0401, 0x0001, 0x03FE },
    { 0x0C, 0x0401, 0x0001, 0x03FE },
    { 0x0C, 0x0401, 0x0001, 0x0801 },
    { 0x0C, 0x0401, 0x0001, 0x0801 },
    { 0x0C, 0x0401, 0x0001, 0x0BFF },
    { 0x0C, 0x0401, 0x0001, 0x0BFF },
    { 0x0B, 0x0401, 0x0001, 0x0401 },
    { 0x0B, 0x0401, 0x0001, 0x0401 },
    { 0x0B, 0x0401, 0x0001, 0x0401 },
    { 0x0B, 0x0401, 0x0001, 0x0401 },
    { 0x0B, 0x0401, 0x0001, 0x07FF },
    { 0x0B, 0x0401, 0x0001, 0x07FF },
    { 0x0B, 0x0401, 0x0001, 0x07FF },
    { 0x0B, 0x0401, 0x0001, 0x07FF },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x09, 0x0401, 0x0001, 0xFE00 },
    { 0x0A, 0x0401, 0x0001, 0x0001 },
    { 0x0A, 0x0401, 0x0001, 0x0001 },
    { 0x0A, 0x0401, 0x0001, 0x0001 },
    { 0x0A, 0x0401, 0x0001, 0x0001 },
    { 0x0A, 0x0401, 0x0001, 0x0001 },
    { 0x0A, 0x0401, 0x0001, 0x0001 },
    { 0x0A, 0x0401, 0x0001, 0x0001 },
    { 0x0A, 0x0401, 0x0001, 0x0001 },
    { 0x0A, 0x0401, 0x0001, 0x03FF },
    { 0x0A, 0x0401, 0x0001, 0x03FF },
    { 0x0A, 0x0401, 0x0001, 0x03FF },
    { 0x0A, 0x0401, 0x0001, 0x03FF },
    { 0x0A, 0x0401, 0x0001, 0x03FF },
    { 0x0A, 0x0401, 0x0001, 0x03FF },
    { 0x0A, 0x0401, 0x0001, 0x03FF },
    { 0x0A, 0x0401, 0x0001, 0x03FF },
    { 0x07, 0x0401, 0x03FF, 0x0000 },
    { 0x0D, 0x0401, 0x03FF, 0x7C1F },
    { 0x07, 0x0401, 0x03FF, 0x0000 },
    { 0x07, 0x0401, 0x03FF, 0x0000 },
    { 0x07, 0x0401, 0x03FF, 0x0000 },
    { 0x07, 0x0401, 0x03FF, 0x0000 },
    { 0x07, 0x0401, 0x03FF, 0x0000 },
    { 0x07, 0x0401, 0x03FF, 0x0000 },
    { 0x07, 0x0401, 0x03FF, 0x0000 },
    { 0x07, 0x0401, 0x03FF, 0x0000 },
    { 0x0D, 0x0401, 0x03FF, 0x0003 },
    { 0x0D, 0x0401, 0x03FF, 0x03FD },
    { 0x0D, 0x0401, 0x03FF, 0x1001 },
    { 0x0D, 0x0401, 0x03FF, 0x13FF },
    { 0x0D, 0x0401, 0x03FF, 0x0C01 },
    { 0x0D, 0x0401, 0x03FF, 0x0FFF },
    { 0x0C, 0x0401, 0x03FF, 0x0002 },
    { 0x0C, 0x0401, 0x03FF, 0x0002 },
    { 0x0C, 0x0401, 0x03FF, 0x03FE },
    { 0x0C, 0x0401, 0x03FF, 0x03FE },
    { 0x0C, 0x0401, 0x03FF, 0x0801 },
    { 0x0C, 0x0401, 0x03FF, 0x0801 },
    { 0x0C, 0x0401, 0x03FF, 0x0BFF },
    { 0x0C, 0x0401, 0x03FF, 0x0BFF },
    { 0x0B, 0x0401, 0x03FF, 0x0401 },
    { 0x0B, 0x0401, 0x03FF, 0x0401 },
    { 0x0B, 0x0401, 0x03FF, 0x0401 },
    { 0x0B, 0x0401, 0x03FF, 0x0401 },
    { 0x0B, 0x0401, 0x03FF, 0x07FF },
    { 0x0B, 0x0401, 0x03FF, 0x07FF },
    { 0x0B, 0x0401, 0x03FF, 0x07FF },
    { 0x0B, 0x0401, 0x03FF, 0x07FF },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x09, 0x0401, 0x03FF, 0xFE00 },
    { 0x0A, 0x0401, 0x03FF, 0x0001 },
    { 0x0A, 0x0401, 0x03FF, 0x0001 },
    { 0x0A, 0x0401, 0x03FF, 0x0001 },
    { 0x0A, 0x0401, 0x03FF, 0x0001 },
    { 0x0A, 0x0401, 0x03FF, 0x0001 },
    { 0x0A, 0x0401, 0x03FF, 0x0001 },
    { 0x0A, 0x0401, 0x03FF, 0x0001 },
    { 0x0A, 0x0401, 0x03FF, 0x0001 },
    { 0x0A, 0x0401, 0x03FF, 0x03FF },
    { 0x0A, 0x0401, 0x03FF, 0x03FF },
    { 0x0A, 0x0401, 0x03FF, 0x03FF },
    { 0x0A, 0x0401, 0x03FF, 0x03FF },
    { 0x0A, 0x0401, 0x03FF, 0x03FF },
    { 0x0A, 0x0401, 0x03FF, 0x03FF },
    { 0x0A, 0x0401, 0x03FF, 0x03FF },
    { 0x0A, 0x0401, 0x03FF, 0x03FF },
    { 0x04, 0x07FF, 0x0000, 0x0000 },
    { 0x04, 0x07FF, 0x0000, 0x0000 },
    { 0x04, 0x07FF, 0x0000, 0x0000 },
    { 0x04, 0x07FF, 0x0000, 0x0000 },
    { 0x04, 0x07FF, 0x0000, 0x0000 },
    { 0x04, 0x07FF, 0x0000, 0x0000 },
    { 0x04, 0x07FF, 0x0000, 0x0000 },
    { 0x04, 0x07FF, 0x0000, 0x0000 },
    { 0x0A, 0x07FF, 0x7C1F, 0x0000 },
    { 0x0A, 0x07FF, 0x7C1F, 0x0000 },
    { 0x0A, 0x07FF, 0x7C1F, 0x0000 },
    { 0x0A, 0x07FF, 0x7C1F, 0x0000 },
    { 0x0A, 0x07FF, 0x7C1F, 0x0000 },
    { 0x0A, 0x07FF, 0x7C1F, 0x0000 },
    { 0x0A, 0x07FF, 0x7C1F, 0x0000 },
    { 0x0A, 0x07FF, 0x7C1F, 0x0000 },
    { 0x0C, 0x07FF, 0x0802, 0x0000 },
    { 0x0C, 0x07FF, 0x0802, 0x0000 },
    { 0x0C, 0x07FF, 0x0BFE, 0x0000 },
    { 0x0C, 0x07FF, 0x0BFE, 0x0000 },
    { 0x0C, 0x07FF, 0x2401, 0x0000 },
    { 0x0C, 0x07FF, 0x2401, 0x0000 },
    { 0x0C, 0x07FF, 0x27FF, 0x0000 },
    { 0x0C, 0x07FF, 0x27FF, 0x0000 },
    { 0x0C, 0x07FF, 0x0004, 0x0000 },
    { 0x0C, 0x07FF, 0x0004, 0x0000 },
    { 0x0C, 0x07FF, 0x03FC, 0x0000 },
    { 0x0C, 0x07FF, 0x03FC, 0x0000 },
    { 0x0C, 0x07FF, 0x2001, 0x0000 },
    { 0x0C, 0x07FF, 0x2001, 0x0000 },
    { 0x0C, 0x07FF, 0x23FF, 0x0000 },
    { 0x0C, 0x07FF, 0x23FF, 0x0000 },
    { 0x0B, 0x07FF, 0x1C01, 0x0000 },
    { 0x0B, 0x07FF, 0x1C01, 0x0000 },
    { 0x0D, 0x07FF, 0x1C01, 0xFE00 },
    { 0x0B, 0x07FF, 0x1C01, 0x0000 },
    { 0x0B, 0x07FF, 0x1FFF, 0x0000 },
    { 0x0B, 0x07FF, 0x1FFF, 0x0000 },
    { 0x0D, 0x07FF, 0x1FFF, 0xFE00 },
    { 0x0B, 0x07FF, 0x1FFF, 0x0000 },
    { 0x0B, 0x07FF, 0x1801, 0x0000 },
    { 0x0B, 0x07FF, 0x1801, 0x0000 },
    { 0x0D, 0x07FF, 0x1801, 0xFE00 },
    { 0x0B, 0x07FF, 0x1801, 0x0000 },
    { 0x0B, 0x07FF, 0x1BFF, 0x0000 },
    { 0x0B, 0x07FF, 0x1BFF, 0x0000 },
    { 0x0D, 0x07FF, 0x1BFF, 0xFE00 },
    { 0x0B, 0x07FF, 0x1BFF, 0x0000 },
    { 0x0B, 0x07FF, 0x0402, 0x0000 },
    { 0x0B, 0x07FF, 0x0402, 0x0000 },
    { 0x0D, 0x07FF, 0x0402, 0xFE00 },
    { 0x0B, 0x07FF, 0x0402, 0x0000 },
    { 0x0B, 0x07FF, 0x07FE, 0x0000 },
    { 0x0B, 0x07FF, 0x07FE, 0x0000 },
    { 0x0D, 0x07FF, 0x07FE, 0xFE00 },
    { 0x0B, 0x07FF, 0x07FE, 0x0000 },
    { 0x0B, 0x07FF, 0x1401, 0x0000 },
    { 0x0B, 0x07FF, 0x1401, 0x0000 },
    { 0x0D, 0x07FF, 0x1401, 0xFE00 },
    { 0x0B, 0x07FF, 0x1401, 0x0000 },
    { 0x0B, 0x07FF, 0x17FF, 0x0000 },
    { 0x0B, 0x07FF, 0x17FF, 0x0000 },
    { 0x0D, 0x07FF, 0x17FF, 0xFE00 },
    { 0x0B, 0x07FF, 0x17FF, 0x0000 },
    { 0x0D, 0x07FF, 0x3401, 0x0000 },
    { 0x0D, 0x07FF, 0x37FF, 0x0000 },
    { 0x0D, 0x07FF, 0x0006, 0x0000 },
    { 0x0D, 0x07FF, 0x03FA, 0x0000 },
    { 0x0D, 0x07FF, 0x3001, 0x0000 },
    { 0x0D, 0x07FF, 0x33FF, 0x0000 },
    { 0x0D, 0x07FF, 0x2C01, 0x0000 },
    { 0x0D, 0x07FF, 0x2FFF, 0x0000 },
    { 0x0D, 0x07FF, 0x0C02, 0x0000 },
    { 0x0D, 0x07FF, 0x0FFE, 0x0000 },
    { 0x0D, 0x07FF, 0x0403, 0x0000 },
    { 0x0D, 0x07FF, 0x07FD, 0x0000 },
    { 0x0D, 0x07FF, 0x0005, 0x0000 },
    { 0x0D, 0x07FF, 0x03FB, 0x0000 },
    { 0x0D, 0x07FF, 0x2801, 0x0000 },
    { 0x0D, 0x07FF, 0x2BFF, 0x0000 },
    { 0x0A, 0x07FF, 0x0003, 0x0000 },
    { 0x0A, 0x07FF, 0x0003, 0x0000 },
    { 0x0A, 0x07FF, 0x0003, 0x0000 },
    { 0x0A, 0x07FF, 0x0003, 0x0000 },
    { 0x0C, 0x07FF, 0x0003, 0xFE00 },
    { 0x0C, 0x07FF, 0x0003, 0xFE00 },
    { 0x0D, 0x07FF, 0x0003, 0x0001 },
    { 0x0D, 0x07FF, 0x0003, 0x03FF },
    { 0x0A, 0x07FF, 0x03FD, 0x0000 },
    { 0x0A, 0x07FF, 0x03FD, 0x0000 },
    { 0x0A, 0x07FF, 0x03FD, 0x0000 },
    { 0x0A, 0x07FF, 0x03FD, 0x0000 },
    { 0x0C, 0x07FF, 0x03FD, 0xFE00 },
    { 0x0C, 0x07FF, 0x03FD, 0xFE00 },
    { 0x0D, 0x07FF, 0x03FD, 0x0001 },
    { 0x0D, 0x07FF, 0x03FD, 0x03FF },
    { 0x0A, 0x07FF, 0x1001, 0x0000 },
    { 0x0A, 0x07FF, 0x1001, 0x0000 },
    { 0x0A, 0x07FF, 0x1001, 0x0000 },
    { 0x0A, 0x07FF, 0x1001, 0x0000 },
    { 0x0C, 0x07FF, 0x1001, 0xFE00 },
    { 0x0C, 0x07FF, 0x1001, 0xFE00 },
    { 0x0D, 0x07FF, 0x1001, 0x0001 },
    { 0x0D, 0x07FF, 0x1001, 0x03FF },
    { 0x0A, 0x07FF, 0x13FF, 0x0000 },
    { 0x0A, 0x07FF, 0x13FF, 0x0000 },
    { 0x0A, 0x07FF, 0x13FF, 0x0000 },
    { 0x0A, 0x07FF, 0x13FF, 0x0000 },
    { 0x0C, 0x07FF, 0x13FF, 0xFE00 },
    { 0x0C, 0x07FF, 0x13FF, 0xFE00 },
    { 0x0D, 0x07FF, 0x13FF, 0x0001 },
    { 0x0D, 0x07FF, 0x13FF, 0x03FF },
    { 0x0A, 0x07FF, 0x0C01, 0x0000 },
    { 0x0A, 0x07FF, 0x0C01, 0x0000 },
    { 0x0A, 0x07FF, 0x0C01, 0x0000 },
    { 0x0A, 0x07FF, 0x0C01, 0x0000 },
    { 0x0C, 0x07FF, 0x0C01, 0xFE00 },
    { 0x0C, 0x07FF, 0x0C01, 0xFE00 },
    { 0x0D, 0x07FF, 0x0C01, 0x0001 },
    { 0x0D, 0x07FF, 0x0C01, 0x03FF },
    { 0x0A, 0x07FF, 0x0FFF, 0x0000 },
    { 0x0A, 0x07FF, 0x0FFF, 0x0000 },
    { 0x0A, 0x07FF, 0x0FFF, 0x0000 },
    { 0x0A, 0x07FF, 0x0FFF, 0x0000 },
    { 0x0C, 0x07FF, 0x0FFF, 0xFE00 },
    { 0x0C, 0x07FF, 0x0FFF, 0xFE00 },
    { 0x0D, 0x07FF, 0x0FFF, 0x0001 },
    { 0x0D, 0x07FF, 0x0FFF, 0x03FF },
    { 0x09, 0x07FF, 0x0002, 0x0000 },
    { 0x09, 0x07FF, 0x0002, 0x0000 },
    { 0x09, 0x07FF, 0x0002, 0x0000 },
    { 0x09, 0x07FF, 0x0002, 0x0000 },
    { 0x09, 0x07FF, 0x0002, 0x0000 },
    { 0x09, 0x07FF, 0x0002, 0x0000 },
    { 0x0D, 0x07FF, 0x0002, 0x0401 },
    { 0x0D, 0x07FF, 0x0002, 0x07FF },
    { 0x0B, 0x07FF, 0x0002, 0xFE00 },
    { 0x0B, 0x07FF, 0x0002, 0xFE00 },
    { 0x0B, 0x07FF, 0x0002, 0xFE00 },
    { 0x0B, 0x07FF, 0x0002, 0xFE00 },
    { 0x0C, 0x07FF, 0x0002, 0x0001 },
    { 0x0C, 0x07FF, 0x0002, 0x0001 },
    { 0x0C, 0x07FF, 0x0002, 0x03FF },
    { 0x0C, 0x07FF, 0x0002, 0x03FF },
    { 0x09, 0x07FF, 0x03FE, 0x0000 },
    { 0x09, 0x07FF, 0x03FE, 0x0000 },
    { 0x09, 0x07FF, 0x03FE, 0x0000 },
    { 0x09, 0x07FF, 0x03FE, 0x0000 },
    { 0x09, 0x07FF, 0x03FE, 0x0000 },
    { 0x09, 0x07FF, 0x03FE, 0x0000 },
    { 0x0D, 0x07FF, 0x03FE, 0x0401 },
    { 0x0D, 0x07FF, 0x03FE, 0x07FF },
    { 0x0B, 0x07FF, 0x03FE, 0xFE00 },
    { 0x0B, 0x07FF, 0x03FE, 0xFE00 },
    { 0x0B, 0x07FF, 0x03FE, 0xFE00 },
    { 0x0B, 0x07FF, 0x03FE, 0xFE00 },
    { 0x0C, 0x07FF, 0x03FE, 0x0001 },
    { 0x0C, 0x07FF, 0x03FE, 0x0001 },
    { 0x0C, 0x07FF, 0x03FE, 0x03FF },
    { 0x0C, 0x07FF, 0x03FE, 0x03FF },
    { 0x09, 0x07FF, 0x0801, 0x0000 },
    { 0x09, 0x07FF, 0x0801, 0x0000 },
    { 0x09, 0x07FF, 0x0801, 0x0000 },
    { 0x09, 0x07FF, 0x0801, 0x0000 },
    { 0x09, 0x07FF, 0x0801, 0x0000 },
    { 0x09, 0x07FF, 0x0801, 0x0000 },
    { 0x0D, 0x07FF, 0x0801, 0x0401 },
    { 0x0D, 0x07FF, 0x0801, 0x07FF },
    { 0x0B, 0x07FF, 0x0801, 0xFE00 },
    { 0x0B, 0x07FF, 0x0801, 0xFE00 },
    { 0x0B, 0x07FF, 0x0801, 0xFE00 },
    { 0x0B, 0x07FF, 0x0801, 0xFE00 },
    { 0x0C, 0x07FF, 0x0801, 0x0001 },
    { 0x0C, 0x07FF, 0x0801, 0x0001 },
    { 0x0C, 0x07FF, 0x0801, 0x03FF },
    { 0x0C, 0x07FF, 0x0801, 0x03FF },
    { 0x09, 0x07FF, 0x0BFF, 0x0000 },
    { 0x09, 0x07FF, 0x0BFF, 0x0000 },
    { 0x09, 0x07FF, 0x0BFF, 0x0000 },
    { 0x09, 0x07FF, 0x0BFF, 0x0000 },
    { 0x09, 0x07FF, 0x0BFF, 0x0000 },
    { 0x09, 0x07FF, 0x0BFF, 0x0000 },
    { 0x0D, 0x07FF, 0x0BFF, 0x0401 },
    { 0x0D, 0x07FF, 0x0BFF, 0x07FF },
    { 0x0B, 0x07FF, 0x0BFF, 0xFE00 },
    { 0x0B, 0x07FF, 0x0BFF, 0xFE00 },
    { 0x0B, 0x07FF, 0x0BFF, 0xFE00 },
    { 0x0B, 0x07FF, 0x0BFF, 0xFE00 },
    { 0x0C, 0x07FF, 0x0BFF, 0x0001 },
    { 0x0C, 0x07FF, 0x0BFF, 0x0001 },
    { 0x0C, 0x07FF, 0x0BFF, 0x03FF },
    { 0x0C, 0x07FF, 0x0BFF, 0x03FF },
    { 0x08, 0x07FF, 0x0401, 0x0000 },
    { 0x08, 0x07FF, 0x0401, 0x0000 },
    { 0x08, 0x07FF, 0x0401, 0x0000 },
    { 0x08, 0x07FF, 0x0401, 0x0000 },
    { 0x08, 0x07FF, 0x0401, 0x0000 },
    { 0x08, 0x07FF, 0x0401, 0x0000 },
    { 0x08, 0x07FF, 0x0401, 0x0000 },
    { 0x08, 0x07FF, 0x0401, 0x0000 },
    { 0x0D, 0x07FF, 0x0401, 0x0002 },
    { 0x0D, 0x07FF, 0x0401, 0x03FE },
    { 0x0D, 0x07FF, 0x0401, 0x0801 },
    { 0x0D, 0x07FF, 0x0401, 0x0BFF },
    { 0x0C, 0x07FF, 0x0401, 0x0401 },
    { 0x0C, 0x07FF, 0x0401, 0x0401 },
    { 0x0C, 0x07FF, 0x0401, 0x07FF },
    { 0x0C, 0x07FF, 0x0401, 0x07FF },
    { 0x0A, 0x07FF, 0x0401, 0xFE00 },
    { 0x0A, 0x07FF, 0x0401, 0xFE00 },
    { 0x0A, 0x07FF, 0x0401, 0xFE00 },
    { 0x0A, 0x07FF, 0x0401, 0xFE00 },
    { 0x0A, 0x07FF, 0x0401, 0xFE00 },
    { 0x0A, 0x07FF, 0x0401, 0xFE00 },
    { 0x0A, 0x07FF, 0x0401, 0xFE00 },
    { 0x0A, 0x07FF, 0x0401, 0xFE00 },
    { 0x0B, 0x07FF, 0x0401, 0x0001 },
    { 0x0B, 0x07FF, 0x0401, 0x0001 },
    { 0x0B, 0x07FF, 0x0401, 0x0001 },
    { 0x0B, 0x07FF, 0x0401, 0x0001 },
    { 0x0B, 0x07FF, 0x0401, 0x03FF },
    { 0x0B, 0x07FF, 0x0401, 0x03FF },
    { 0x0B, 0x07FF, 0x0401, 0x03FF },
    { 0x0B, 0x07FF, 0x0401, 0x03FF },
    { 0x08, 0x07FF, 0x07FF, 0x0000 },
    { 0x08, 0x07FF, 0x07FF, 0x0000 },
    { 0x08, 0x07FF, 0x07FF, 0x0000 },
    { 0x08, 0x07FF, 0x07FF, 0x0000 },
    { 0x08, 0x07FF, 0x07FF, 0x0000 },
    { 0x08, 0x07FF, 0x07FF, 0x0000 },
    { 0x08, 0x07FF, 0x07FF, 0x0000 },
    { 0x08, 0x07FF, 0x07FF, 0x0000 },
    { 0x0D, 0x07FF, 0x07FF, 0x0002 },
    { 0x0D, 0x07FF, 0x07FF, 0x03FE },
    { 0x0D, 0x07FF, 0x07FF, 0x0801 },
    { 0x0D, 0x07FF, 0x07FF, 0x0BFF },
    { 0x0C, 0x07FF, 0x07FF, 0x0401 },
    { 0x0C, 0x07FF, 0x07FF, 0x0401 },
    { 0x0C, 0x07FF, 0x07FF, 0x07FF },
    { 0x0C, 0x07FF, 0x07FF, 0x07FF },
    { 0x0A, 0x07FF, 0x07FF, 0xFE00 },
    { 0x0A, 0x07FF, 0x07FF, 0xFE00 },
    { 0x0A, 0x07FF, 0x07FF, 0xFE00 },
    { 0x0A, 0x07FF, 0x07FF, 0xFE00 },
    { 0x0A, 0x07FF, 0x07FF, 0xFE00 },
    { 0x0A, 0x07FF, 0x07FF, 0xFE00 },
    { 0x0A, 0x07FF, 0x07FF, 0xFE00 },
    { 0x0A, 0x07FF, 0x07FF, 0xFE00 },
    { 0x0B, 0x07FF, 0x07FF, 0x0001 },
    { 0x0B, 0x07FF, 0x07FF, 0x0001 },
    { 0x0B, 0x07FF, 0x07FF, 0x0001 },
    { 0x0B, 0x07FF, 0x07FF, 0x0001 },
    { 0x0B, 0x07FF, 0x07FF, 0x03FF },
    { 0x0B, 0x07FF, 0x07FF, 0x03FF },
    { 0x0B, 0x07FF, 0x07FF, 0x03FF },
    { 0x0B, 0x07FF, 0x07FF, 0x03FF },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x06, 0x07FF, 0xFE00, 0x0000 },
    { 0x07, 0x07FF, 0x0001, 0x0000 },
    { 0x0D, 0x07FF, 0x0001, 0x7C1F },
    { 0x07, 0x07FF, 0x0001, 0x0000 },
    { 0x07, 0x07FF, 0x0001, 0x0000 },
    { 0x07, 0x07FF, 0x0001, 0x0000 },
    { 0x07, 0x07FF, 0x0001, 0x0000 },
    { 0x07, 0x07FF, 0x0001, 0x0000 },
    { 0x07, 0x07FF, 0x0001, 0x0000 },
    { 0x07, 0x07FF, 0x0001, 0x0000 },
    { 0x07, 0x07FF, 0x0001, 0x0000 },
    { 0x0D, 0x07FF, 0x0001, 0x0003 },
    { 0x0D, 0x07FF, 0x0001, 0x03FD },
    { 0x0D, 0x07FF, 0x0001, 0x1001 },
    { 0x0D, 0x07FF, 0x0001, 0x13FF },
    { 0x0D, 0x07FF, 0x0001, 0x0C01 },
    { 0x0D, 0x07FF, 0x0001, 0x0FFF },
    { 0x0C, 0x07FF, 0x0001, 0x0002 },
    { 0x0C, 0x07FF, 0x0001, 0x0002 },
    { 0x0C, 0x07FF, 0x0001, 0x03FE },
    { 0x0C, 0x07FF, 0x0001, 0x03FE },
    { 0x0C, 0x07FF, 0x0001, 0x0801 },
    { 0x0C, 0x07FF, 0x0001, 0x0801 },
    { 0x0C, 0x07FF, 0x0001, 0x0BFF },
    { 0x0C, 0x07FF, 0x0001, 0x0BFF },
    { 0x0B, 0x07FF, 0x0001, 0x0401 },
    { 0x0B, 0x07FF, 0x0001, 0x0401 },
    { 0x0B, 0x07FF, 0x0001, 0x0401 },
    { 0x0B, 0x07FF, 0x0001, 0x0401 },
    { 0x0B, 0x07FF, 0x0001, 0x07FF },
    { 0x0B, 0x07FF, 0x0001, 0x07FF },
    { 0x0B, 0x07FF, 0x0001, 0x07FF },
    { 0x0B, 0x07FF, 0x0001, 0x07FF },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x09, 0x07FF, 0x0001, 0xFE00 },
    { 0x0A, 0x07FF, 0x0001, 0x0001 },
    { 0x0A, 0x07FF, 0x0001, 0x0001 },
    { 0x0A, 0x07FF, 0x0001, 0x0001 },
    { 0x0A, 0x07FF, 0x0001, 0x0001 },
    { 0x0A, 0x07FF, 0x0001, 0x0001 },
    { 0x0A, 0x07FF, 0x0001, 0x0001 },
    { 0x0A, 0x07FF, 0x0001, 0x0001 },
    { 0x0A, 0x07FF, 0x0001, 0x0001 },
    { 0x0A, 0x07FF, 0x0001, 0x03FF },
    { 0x0A, 0x07FF, 0x0001, 0x03FF },
    { 0x0A, 0x07FF, 0x0001, 0x03FF },
    { 0x0A, 0x07FF, 0x0001, 0x03FF },
    { 0x0A, 0x07FF, 0x0001, 0x03FF },
    { 0x0A, 0x07FF, 0x0001, 0x03FF },
    { 0x0A, 0x07FF, 0x0001, 0x03FF },
    { 0x0A, 0x07FF, 0x0001, 0x03FF },
    { 0x07, 0x07FF, 0x03FF, 0x0000 },
    { 0x0D, 0x07FF, 0x03FF, 0x7C1F },
    { 0x07, 0x07FF, 0x03FF, 0x0000 },
    { 0x07, 0x07FF, 0x03FF, 0x0000 },
    { 0x07, 0x07FF, 0x03FF, 0x0000 },
    { 0x07, 0x07FF, 0x03FF, 0x0000 },
    { 0x07, 0x07FF, 0x03FF, 0x0000 },
    { 0x07, 0x07FF, 0x03FF, 0x0000 },
    { 0x07, 0x07FF, 0x03FF, 0x0000 },
    { 0x07, 0x07FF, 0x03FF, 0x0000 },
    { 0x0D, 0x07FF, 0x03FF, 0x0003 },
    { 0x0D, 0x07FF, 0x03FF, 0x03FD },
    { 0x0D, 0x07FF, 0x03FF, 0x1001 },
    { 0x0D, 0x07FF, 0x03FF, 0x13FF },
    { 0x0D, 0x07FF, 0x03FF, 0x0C01 },
    { 0x0D, 0x07FF, 0x03FF, 0x0FFF },
    { 0x0C, 0x07FF, 0x03FF, 0x0002 },
    { 0x0C, 0x07FF, 0x03FF, 0x0002 },
    { 0x0C, 0x07FF, 0x03FF, 0x03FE },
    { 0x0C, 0x07FF, 0x03FF, 0x03FE },
    { 0x0C, 0x07FF, 0x03FF, 0x0801 },
    { 0x0C, 0x07FF, 0x03FF, 0x0801 },
    { 0x0C, 0x07FF, 0x03FF, 0x0BFF },
    { 0x0C, 0x07FF, 0x03FF, 0x0BFF },
    { 0x0B, 0x07FF, 0x03FF, 0x0401 },
    { 0x0B, 0x07FF, 0x03FF, 0x0401 },
    { 0x0B, 0x07FF, 0x03FF, 0x0401 },
    { 0x0B, 0x07FF, 0x03FF, 0x0401 },
    { 0x0B, 0x07FF, 0x03FF, 0x07FF },
    { 0x0B, 0x07FF, 0x03FF, 0x07FF },
    { 0x0B, 0x07FF, 0x03FF, 0x07FF },
    { 0x0B, 0x07FF, 0x03FF, 0x07FF },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x09, 0x07FF, 0x03FF, 0xFE00 },
    { 0x0A, 0x07FF, 0x03FF, 0x0001 },
    { 0x0A, 0x07FF, 0x03FF, 0x0001 },
    { 0x0A, 0x07FF, 0x03FF, 0x0001 },
    { 0x0A, 0x07FF, 0x03FF, 0x0001 },
    { 0x0A, 0x07FF, 0x03FF, 0x0001 },
    { 0x0A, 0x07FF, 0x03FF, 0x0001 },
    { 0x0A, 0x07FF, 0x03FF, 0x0001 },
    { 0x0A, 0x07FF, 0x03FF, 0x0001 },
    { 0x0A, 0x07FF, 0x03FF, 0x03FF },
    { 0x0A, 0x07FF, 0x03FF, 0x03FF },
    { 0x0A, 0x07FF, 0x03FF, 0x03FF },
    { 0x0A, 0x07FF, 0x03FF, 0x03FF },
    { 0x0A, 0x07FF, 0x03FF, 0x03FF },
    { 0x0A, 0x07FF, 0x03FF, 0x03FF },
    { 0x0A, 0x07FF, 0x03FF, 0x03FF },
    { 0x0A, 0x07FF, 0x03FF, 0x03FF },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x02, 0xFE00, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x03, 0x0001, 0x0000, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x09, 0x0001, 0x7C1F, 0x0000 },
    { 0x0B, 0x0001, 0x0802, 0x0000 },
    { 0x0B, 0x0001, 0x0802, 0x0000 },
    { 0x0D, 0x0001, 0x0802, 0xFE00 },
    { 0x0B, 0x0001, 0x0802, 0x0000 },
    { 0x0B, 0x0001, 0x0BFE, 0x0000 },
    { 0x0B, 0x0001, 0x0BFE, 0x0000 },
    { 0x0D, 0x0001, 0x0BFE, 0xFE00 },
    { 0x0B, 0x0001, 0x0BFE, 0x0000 },
    { 0x0B, 0x0001, 0x2401, 0x0000 },
    { 0x0B, 0x0001, 0x2401, 0x0000 },
    { 0x0D, 0x0001, 0x2401, 0xFE00 },
    { 0x0B, 0x0001, 0x2401, 0x0000 },
    { 0x0B, 0x0001, 0x27FF, 0x0000 },
    { 0x0B, 0x0001, 0x27FF, 0x0000 },
    { 0x0D, 0x0001, 0x27FF, 0xFE00 },
    { 0x0B, 0x0001, 0x27FF, 0x0000 },
    { 0x0B, 0x0001, 0x0004, 0x0000 },
    { 0x0B, 0x0001, 0x0004, 0x0000 },
    { 0x0D, 0x0001, 0x0004, 0xFE00 },
    { 0x0B, 0x0001, 0x0004, 0x0000 },
    { 0x0B, 0x0001, 0x03FC, 0x0000 },
    { 0x0B, 0x0001, 0x03FC, 0x0000 },
    { 0x0D, 0x0001, 0x03FC, 0xFE00 },
    { 0x0B, 0x0001, 0x03FC, 0x0000 },
    { 0x0B, 0x0001, 0x2001, 0x0000 },
    { 0x0B, 0x0001, 0x2001, 0x0000 },
    { 0x0D, 0x0001, 0x2001, 0xFE00 },
    { 0x0B, 0x0001, 0x2001, 0x0000 },
    { 0x0B, 0x0001, 0x23FF, 0x0000 },
    { 0x0B, 0x0001, 0x23FF, 0x0000 },
    { 0x0D, 0x0001, 0x23FF, 0xFE00 },
    { 0x0B, 0x0001, 0x23FF, 0x0000 },
    { 0x0A, 0x0001, 0x1C01, 0x0000 },
    { 0x0A, 0x0001, 0x1C01, 0x0000 },
    { 0x0A, 0x0001, 0x1C01, 0x0000 },
    { 0x0A, 0x0001, 0x1C01, 0x0000 },
    { 0x0C, 0x0001, 0x1C01, 0xFE00 },
    { 0x0C, 0x0001, 0x1C01, 0xFE00 },
    { 0x0D, 0x0001, 0x1C01, 0x0001 },
    { 0x0D, 0x0001, 0x1C01, 0x03FF },
    { 0x0A, 0x0001, 0x1FFF, 0x0000 },
    { 0x0A, 0x0001, 0x1FFF, 0x0000 },
    { 0x0A, 0x0001, 0x1FFF, 0x0000 },
    { 0x0A, 0x0001, 0x1FFF, 0x0000 },
    { 0x0C, 0x0001, 0x1FFF, 0xFE00 },
    { 0x0C, 0x0001, 0x1FFF, 0xFE00 },
    { 0x0D, 0x0001, 0x1FFF, 0x0001 },
    { 0x0D, 0x0001, 0x1FFF, 0x03FF },
    { 0x0A, 0x0001, 0x1801, 0x0000 },
    { 0x0A, 0x0001, 0x1801, 0x0000 },
    { 0x0A, 0x0001, 0x1801, 0x0000 },
    { 0x0A, 0x0001, 0x1801, 0x0000 },
    { 0x0C, 0x0001, 0x1801, 0xFE00 },
    { 0x0C, 0x0001, 0x1801, 0xFE00 },
    { 0x0D, 0x0001, 0x1801, 0x0001 },
    { 0x0D, 0x0001, 0x1801, 0x03FF },
    { 0x0A, 0x0001, 0x1BFF, 0x0000 },
    { 0x0A, 0x0001, 0x1BFF, 0x0000 },
    { 0x0A, 0x0001, 0x1BFF, 0x0000 },
    { 0x0A, 0x0001, 0x1BFF, 0x0000 },
    { 0x0C, 0x0001, 0x1BFF, 0xFE00 },
    { 0x0C, 0x0001, 0x1BFF, 0xFE00 },
    { 0x0D, 0x0001, 0x1BFF, 0x0001 },
    { 0x0D, 0x0001, 0x1BFF, 0x03FF },
    { 0x0A, 0x0001, 0x0402, 0x0000 },
    { 0x0A, 0x0001, 0x0402, 0x0000 },
    { 0x0A, 0x0001, 0x0402, 0x0000 },
    { 0x0A, 0x0001, 0x0402, 0x0000 },
    { 0x0C, 0x0001, 0x0402, 0xFE00 },
    { 0x0C, 0x0001, 0x0402, 0xFE00 },
    { 0x0D, 0x0001, 0x0402, 0x0001 },
    { 0x0D, 0x0001, 0x0402, 0x03FF },
    { 0x0A, 0x0001, 0x07FE, 0x0000 },
    { 0x0A, 0x0001, 0x07FE, 0x0000 },
    { 0x0A, 0x0001, 0x07FE, 0x0000 },
    { 0x0A, 0x0001, 0x07FE, 0x0000 },
    { 0x0C, 0x0001, 0x07FE, 0xFE00 },
    { 0x0C, 0x0001, 0x07FE, 0xFE00 },
    { 0x0D, 0x0001, 0x07FE, 0x0001 },
    { 0x0D, 0x0001, 0x07FE, 0x03FF },
    { 0x0A, 0x0001, 0x1401, 0x0000 },
    { 0x0A, 0x0001, 0x1401, 0x0000 },
    { 0x0A, 0x0001, 0x1401, 0x0000 },
    { 0x0A, 0x0001, 0x1401, 0x0000 },
    { 0x0C, 0x0001, 0x1401, 0xFE00 },
    { 0x0C, 0x0001, 0x1401, 0xFE00 },
    { 0x0D, 0x0001, 0x1401, 0x0001 },
    { 0x0D, 0x0001, 0x1401, 0x03FF },
    { 0x0A, 0x0001, 0x17FF, 0x0000 },
    { 0x0A, 0x0001, 0x17FF, 0x0000 },
    { 0x0A, 0x0001, 0x17FF, 0x0000 },
    { 0x0A, 0x0001, 0x17FF, 0x0000 },
    { 0x0C, 0x0001, 0x17FF, 0xFE00 },
    { 0x0C, 0x0001, 0x17FF, 0xFE00 },
    { 0x0D, 0x0001, 0x17FF, 0x0001 },
    { 0x0D, 0x0001, 0x17FF, 0x03FF },
    { 0x0C, 0x0001, 0x3401, 0x0000 },
    { 0x0C, 0x0001, 0x3401, 0x0000 },
    { 0x0C, 0x0001, 0x37FF, 0x0000 },
    { 0x0C, 0x0001, 0x37FF, 0x0000 },
    { 0x0C, 0x0001, 0x0006, 0x0000 },
    { 0x0C, 0x0001, 0x0006, 0x0000 },
    { 0x0C, 0x0001, 0x03FA, 0x0000 },
    { 0x0C, 0x0001, 0x03FA, 0x0000 },
    { 0x0C, 0x0001, 0x3001, 0x0000 },
    { 0x0C, 0x0001, 0x3001, 0x0000 },
    { 0x0C, 0x0001, 0x33FF, 0x0000 },
    { 0x0C, 0x0001, 0x33FF, 0x0000 },
    { 0x0C, 0x0001, 0x2C01, 0x0000 },
    { 0x0C, 0x0001, 0x2C01, 0x0000 },
    { 0x0C, 0x0001, 0x2FFF, 0x0000 },
    { 0x0C, 0x0001, 0x2FFF, 0x0000 },
    { 0x0C, 0x0001, 0x0C02, 0x0000 },
    { 0x0C, 0x0001, 0x0C02, 0x0000 },
    { 0x0C, 0x0001, 0x0FFE, 0x0000 },
    { 0x0C, 0x0001, 0x0FFE, 0x0000 },
    { 0x0C, 0x0001, 0x0403, 0x0000 },
    { 0x0C, 0x0001, 0x0403, 0x0000 },
    { 0x0C, 0x0001, 0x07FD, 0x0000 },
    { 0x0C, 0x0001, 0x07FD, 0x0000 },
    { 0x0C, 0x0001, 0x0005, 0x0000 },
    { 0x0C, 0x0001, 0x0005, 0x0000 },
    { 0x0C, 0x0001, 0x03FB, 0x0000 },
    { 0x0C, 0x0001, 0x03FB, 0x0000 },
    { 0x0C, 0x0001, 0x2801, 0x0000 },
    { 0x0C, 0x0001, 0x2801, 0x0000 },
    { 0x0C, 0x0001, 0x2BFF, 0x0000 },
    { 0x0C, 0x0001, 0x2BFF, 0x0000 },
    { 0x09, 0x0001, 0x0003, 0x0000 },
    { 0x09, 0x0001, 0x0003, 0x0000 },
    { 0x09, 0x0001, 0x0003, 0x0000 },
    { 0x09, 0x0001, 0x0003, 0x0000 },
    { 0x09, 0x0001, 0x0003, 0x0000 },
    { 0x09, 0x0001, 0x0003, 0x0000 },
    { 0x0D, 0x0001, 0x0003, 0x0401 },
    { 0x0D, 0x0001, 0x0003, 0x07FF },
    { 0x0B, 0x0001, 0x0003, 0xFE00 },
    { 0x0B, 0x0001, 0x0003, 0xFE00 },
    { 0x0B, 0x0001, 0x0003, 0xFE00 },
    { 0x0B, 0x0001, 0x0003, 0xFE00 },
    { 0x0C, 0x0001, 0x0003, 0x0001 },
    { 0x0C, 0x0001, 0x0003, 0x0001 },
    { 0x0C, 0x0001, 0x0003, 0x03FF },
    { 0x0C, 0x0001, 0x0003, 0x03FF },
    { 0x09, 0x0001, 0x03FD, 0x0000 },
    { 0x09, 0x0001, 0x03FD, 0x0000 },
    { 0x09, 0x0001, 0x03FD, 0x0000 },
    { 0x09, 0x0001, 0x03FD, 0x0000 },
    { 0x09, 0x0001, 0x03FD, 0x0000 },
    { 0x09, 0x0001, 0x03FD, 0x0000 },
    { 0x0D, 0x0001, 0x03FD, 0x0401 },
    { 0x0D, 0x0001, 0x03FD, 0x07FF },
    { 0x0B, 0x0001, 0x03FD, 0xFE00 },
    { 0x0B, 0x0001, 0x03FD, 0xFE00 },
    { 0x0B, 0x0001, 0x03FD, 0xFE00 },
    { 0x0B, 0x0001, 0x03FD, 0xFE00 },
    { 0x0C, 0x0001, 0x03FD, 0x0001 },
    { 0x0C, 0x0001, 0x03FD, 0x0001 },
    { 0x0C, 0x0001, 0x03FD, 0x03FF },
    { 0x0C, 0x0001, 0x03FD, 0x03FF },
    { 0x09, 0x0001, 0x1001, 0x0000 },
    { 0x09, 0x0001, 0x1001, 0x0000 },
    { 0x09, 0x0001, 0x1001, 0x0000 },
    { 0x09, 0x0001, 0x1001, 0x0000 },
    { 0x09, 0x0001, 0x1001, 0x0000 },
    { 0x09, 0x0001, 0x1001, 0x0000 },
    { 0x0D, 0x0001, 0x1001, 0x0401 },
    { 0x0D, 0x0001, 0x1001, 0x07FF },
    { 0x0B, 0x0001, 0x1001, 0xFE00 },
    { 0x0B, 0x0001, 0x1001, 0xFE00 },
    { 0x0B, 0x0001, 0x1001, 0xFE00 },
    { 0x0B, 0x0001, 0x1001, 0xFE00 },
    { 0x0C, 0x0001, 0x1001, 0x0001 },
    { 0x0C, 0x0001, 0x1001, 0x0001 },
    { 0x0C, 0x0001, 0x1001, 0x03FF },
    { 0x0C, 0x0001, 0x1001, 0x03FF },
    { 0x09, 0x0001, 0x13FF, 0x0000 },
    { 0x09, 0x0001, 0x13FF, 0x0000 },
    { 0x09, 0x0001, 0x13FF, 0x0000 },
    { 0x09, 0x0001, 0x13FF, 0x0000 },
    { 0x09, 0x0001, 0x13FF, 0x0000 },
    { 0x09, 0x0001, 0x13FF, 0x0000 },
    { 0x0D, 0x0001, 0x13FF, 0x0401 },
    { 0x0D, 0x0001, 0x13FF, 0x07FF },
    { 0x0B, 0x0001, 0x13FF, 0xFE00 },
    { 0x0B, 0x0001, 0x13FF, 0xFE00 },
    { 0x0B, 0x0001, 0x13FF, 0xFE00 },
    { 0x0B, 0x0001, 0x13FF, 0xFE00 },
    { 0x0C, 0x0001, 0x13FF, 0x0001 },
    { 0x0C, 0x0001, 0x13FF, 0x0001 },
    { 0x0C, 0x0001, 0x13FF, 0x03FF },
    { 0x0C, 0x0001, 0x13FF, 0x03FF },
    { 0x09, 0x0001, 0x0C01, 0x0000 },
    { 0x09, 0x0001, 0x0C01, 0x0000 },
    { 0x09, 0x0001, 0x0C01, 0x0000 },
    { 0x09, 0x0001, 0x0C01, 0x0000 },
    { 0x09, 0x0001, 0x0C01, 0x0000 },
    { 0x09, 0x0001, 0x0C01, 0x0000 },
    { 0x0D, 0x0001, 0x0C01, 0x0401 },
    { 0x0D, 0x0001, 0x0C01, 0x07FF },
    { 0x0B, 0x0001, 0x0C01, 0xFE00 },
    { 0x0B, 0x0001, 0x0C01, 0xFE00 },
    { 0x0B, 0x0001, 0x0C01, 0xFE00 },
    { 0x0B, 0x0001, 0x0C01, 0xFE00 },
    { 0x0C, 0x0001, 0x0C01, 0x0001 },
    { 0x0C, 0x0001, 0x0C01, 0x0001 },
    { 0x0C, 0x0001, 0x0C01, 0x03FF },
    { 0x0C, 0x0001, 0x0C01, 0x03FF },
    { 0x09, 0x0001, 0x0FFF, 0x0000 },
    { 0x09, 0x0001, 0x0FFF, 0x0000 },
    { 0x09, 0x0001, 0x0FFF, 0x0000 },
    { 0x09, 0x0001, 0x0FFF, 0x0000 },
    { 0x09, 0x0001, 0x0FFF, 0x0000 },
    { 0x09, 0x0001, 0x0FFF, 0x0000 },
    { 0x0D, 0x0001, 0x0FFF, 0x0401 },
    { 0x0D, 0x0001, 0x0FFF, 0x07FF },
    { 0x0B, 0x0001, 0x0FFF, 0xFE00 },
    { 0x0B, 0x0001, 0x0FFF, 0xFE00 },
    { 0x0B, 0x0001, 0x0FFF, 0xFE00 },
    { 0x0B, 0x0001, 0x0FFF, 0xFE00 },
    { 0x0C, 0x0001, 0x0FFF, 0x0001 },
    { 0x0C, 0x0001, 0x0FFF, 0x0001 },
    { 0x0C, 0x0001, 0x0FFF, 0x03FF },
    { 0x0C, 0x0001, 0x0FFF, 0x03FF },
    { 0x08, 0x0001, 0x0002, 0x0000 },
    { 0x08, 0x0001, 0x0002, 0x0000 },
    { 0x08, 0x0001, 0x0002, 0x0000 },
    { 0x08, 0x0001, 0x0002, 0x0000 },
    { 0x08, 0x0001, 0x0002, 0x0000 },
    { 0x08, 0x0001, 0x0002, 0x0000 },
    { 0x08, 0x0001, 0x0002, 0x0000 },
    { 0x08, 0x0001, 0x0002, 0x0000 },
    { 0x0D, 0x0001, 0x0002, 0x0002 },
    { 0x0D, 0x0001, 0x0002, 0x03FE },
    { 0x0D, 0x0001, 0x0002, 0x0801 },
    { 0x0D, 0x0001, 0x0002, 0x0BFF },
    { 0x0C, 0x0001, 0x0002, 0x0401 },
    { 0x0C, 0x0001, 0x0002, 0x0401 },
    { 0x0C, 0x0001, 0x0002, 0x07FF },
    { 0x0C, 0x0001, 0x0002, 0x07FF },
    { 0x0A, 0x0001, 0x0002, 0xFE00 },
    { 0x0A, 0x0001, 0x0002, 0xFE00 },
    { 0x0A, 0x0001, 0x0002, 0xFE00 },
    { 0x0A, 0x0001, 0x0002, 0xFE00 },
    { 0x0A, 0x0001, 0x0002, 0xFE00 },
    { 0x0A, 0x0001, 0x0002, 0xFE00 },
    { 0x0A, 0x0001, 0x0002, 0xFE00 },
    { 0x0A, 0x0001, 0x0002, 0xFE00 },
    { 0x0B, 0x0001, 0x0002, 0x0001 },
    { 0x0B, 0x0001, 0x0002, 0x0001 },
    { 0x0B, 0x0001, 0x0002, 0x0001 },
    { 0x0B, 0x0001, 0x0002, 0x0001 },
    { 0x0B, 0x0001, 0x0002, 0x03FF },
    { 0x0B, 0x0001, 0x0002, 0x03FF },
    { 0x0B, 0x0001, 0x0002, 0x03FF },
    { 0x0B, 0x0001, 0x0002, 0x03FF },
    { 0x08, 0x0001, 0x03FE, 0x0000 },
    { 0x08, 0x0001, 0x03FE, 0x0000 },
    { 0x08, 0x0001, 0x03FE, 0x0000 },
    { 0x08, 0x0001, 0x03FE, 0x0000 },
    { 0x08, 0x0001, 0x03FE, 0x0000 },
    { 0x08, 0x0001, 0x03FE, 0x0000 },
    { 0x08, 0x0001, 0x03FE, 0x0000 },
    { 0x08, 0x0001, 0x03FE, 0x0000 },
    { 0x0D, 0x0001, 0x03FE, 0x0002 },
    { 0x0D, 0x0001, 0x03FE, 0x03FE },
    { 0x0D, 0x0001, 0x03FE, 0x0801 },
    { 0x0D, 0x0001, 0x03FE, 0x0BFF },
    { 0x0C, 0x0001, 0x03FE, 0x0401 },
    { 0x0C, 0x0001, 0x03FE, 0x0401 },
    { 0x0C, 0x0001, 0x03FE, 0x07FF },
    { 0x0C, 0x0001, 0x03FE, 0x07FF },
    { 0x0A, 0x0001, 0x03FE, 0xFE00 },
    { 0x0A, 0x0001, 0x03FE, 0xFE00 },
    { 0x0A, 0x0001, 0x03FE, 0xFE00 },
    { 0x0A, 0x0001, 0x03FE, 0xFE00 },
    { 0x0A, 0x0001, 0x03FE, 0xFE00 },
    { 0x0A, 0x0001, 0x03FE, 0xFE00 },
    { 0x0A, 0x0001, 0x03FE, 0xFE00 },
    { 0x0A, 0x0001, 0x03FE, 0xFE00 },
    { 0x0B, 0x0001, 0x03FE, 0x0001 },
    { 0x0B, 0x0001, 0x03FE, 0x0001 },
    { 0x0B, 0x0001, 0x03FE, 0x0001 },
    { 0x0B, 0x0001, 0x03FE, 0x0001 },
    { 0x0B, 0x0001, 0x03FE, 0x03FF },
    { 0x0B, 0x0001, 0x03FE, 0x03FF },
    { 0x0B, 0x0001, 0x03FE, 0x03FF },
    { 0x0B, 0x0001, 0x03FE, 0x03FF },
    { 0x08, 0x0001, 0x0801, 0x0000 },
    { 0x08, 0x0001, 0x0801, 0x0000 },
    { 0x08, 0x0001, 0x0801, 0x0000 },
    { 0x08, 0x0001, 0x0801, 0x0000 },
    { 0x08, 0x0001, 0x0801, 0x0000 },
    { 0x08, 0x0001, 0x0801, 0x0000 },
    { 0x08, 0x0001, 0x0801, 0x0000 },
    { 0x08, 0x0001, 0x0801, 0x0000 },
    { 0x0D, 0x0001, 0x0801, 0x0002 },
    { 0x0D, 0x0001, 0x0801, 0x03FE },
    { 0x0D, 0x0001, 0x0801, 0x0801 },
    { 0x0D, 0x0001, 0x0801, 0x0BFF },
    { 0x0C, 0x0001, 0x0801, 0x0401 },
    { 0x0C, 0x0001, 0x0801, 0x0401 },
    { 0x0C, 0x0001, 0x0801, 0x07FF },
    { 0x0C, 0x0001, 0x0801, 0x07FF },
    { 0x0A, 0x0001, 0x0801, 0xFE00 },
    { 0x0A, 0x0001, 0x0801, 0xFE00 },
    { 0x0A, 0x0001, 0x0801, 0xFE00 },
    { 0x0A, 0x0001, 0x0801, 0xFE00 },
    { 0x0A, 0x0001, 0x0801, 0xFE00 },
    { 0x0A, 0x0001, 0x0801, 0xFE00 },
    { 0x0A, 0x0001, 0x0801, 0xFE00 },
    { 0x0A, 0x0001, 0x0801, 0xFE00 },
    { 0x0B, 0x0001, 0x0801, 0x0001 },
    { 0x0B, 0x0001, 0x0801, 0x0001 },
    { 0x0B, 0x0001, 0x0801, 0x0001 },
    { 0x0B, 0x0001, 0x0801, 0x0001 },
    { 0x0B, 0x0001, 0x0801, 0x03FF },
    { 0x0B, 0x0001, 0x0801, 0x03FF },
    { 0x0B, 0x0001, 0x0801, 0x03FF },
    { 0x0B, 0x0001, 0x0801, 0x03FF },
    { 0x08, 0x0001, 0x0BFF, 0x0000 },
    { 0x08, 0x0001, 0x0BFF, 0x0000 },
    { 0x08, 0x0001, 0x0BFF, 0x0000 },
    { 0x08, 0x0001, 0x0BFF, 0x0000 },
    { 0x08, 0x0001, 0x0BFF, 0x0000 },
    { 0x08, 0x0001, 0x0BFF, 0x0000 },
    { 0x08, 0x0001, 0x0BFF, 0x0000 },
    { 0x08, 0x0001, 0x0BFF, 0x0000 },
    { 0x0D, 0x0001, 0x0BFF, 0x0002 },
    { 0x0D, 0x0001, 0x0BFF, 0x03FE },
    { 0x0D, 0x0001, 0x0BFF, 0x0801 },
    { 0x0D, 0x0001, 0x0BFF, 0x0BFF },
    { 0x0C, 0x0001, 0x0BFF, 0x0401 },
    { 0x0C, 0x0001, 0x0BFF, 0x0401 },
    { 0x0C, 0x0001, 0x0BFF, 0x07FF },
    { 0x0C, 0x0001, 0x0BFF, 0x07FF },
    { 0x0A, 0x0001, 0x0BFF, 0xFE00 },
    { 0x0A, 0x0001, 0x0BFF, 0xFE00 },
    { 0x0A, 0x0001, 0x0BFF, 0xFE00 },
    { 0x0A, 0x0001, 0x0BFF, 0xFE00 },
    { 0x0A, 0x0001, 0x0BFF, 0xFE00 },
    { 0x0A, 0x0001, 0x0BFF, 0xFE00 },
    { 0x0A, 0x0001, 0x0BFF, 0xFE00 },
    { 0x0A, 0x0001, 0x0BFF, 0xFE00 },
    { 0x0B, 0x0001, 0x0BFF, 0x0001 },
    { 0x0B, 0x0001, 0x0BFF, 0x0001 },
    { 0x0B, 0x0001, 0x0BFF, 0x0001 },
    { 0x0B, 0x0001, 0x0BFF, 0x0001 },
    { 0x0B, 0x0001, 0x0BFF, 0x03FF },
    { 0x0B, 0x0001, 0x0BFF, 0x03FF },
    { 0x0B, 0x0001, 0x0BFF, 0x03FF },
    { 0x0B, 0x0001, 0x0BFF, 0x03FF },
    { 0x07, 0x0001, 0x0401, 0x0000 },
    { 0x0D, 0x0001, 0x0401, 0x7C1F },
    { 0x07, 0x0001, 0x0401, 0x0000 },
    { 0x07, 0x0001, 0x0401, 0x0000 },
    { 0x07, 0x0001, 0x0401, 0x0000 },
    { 0x07, 0x0001, 0x0401, 0x0000 },
    { 0x07, 0x0001, 0x0401, 0x0000 },
    { 0x07, 0x0001, 0x0401, 0x0000 },
    { 0x07, 0x0001, 0x0401, 0x0000 },
    { 0x07, 0x0001, 0x0401, 0x0000 },
    { 0x0D, 0x0001, 0x0401, 0x0003 },
    { 0x0D, 0x0001, 0x0401, 0x03FD },
    { 0x0D, 0x0001, 0x0401, 0x1001 },
    { 0x0D, 0x0001, 0x0401, 0x13FF },
    { 0x0D, 0x0001, 0x0401, 0x0C01 },
    { 0x0D, 0x0001, 0x0401, 0x0FFF },
    { 0x0C, 0x0001, 0x0401, 0x0002 },
    { 0x0C, 0x0001, 0x0401, 0x0002 },
    { 0x0C, 0x0001, 0x0401, 0x03FE },
    { 0x0C, 0x0001, 0x0401, 0x03FE },
    { 0x0C, 0x0001, 0x0401, 0x0801 },
    { 0x0C, 0x0001, 0x0401, 0x0801 },
    { 0x0C, 0x0001, 0x0401, 0x0BFF },
    { 0x0C, 0x0001, 0x0401, 0x0BFF },
    { 0x0B, 0x0001, 0x0401, 0x0401 },
    { 0x0B, 0x0001, 0x0401, 0x0401 },
    { 0x0B, 0x0001, 0x0401, 0x0401 },
    { 0x0B, 0x0001, 0x0401, 0x0401 },
    { 0x0B, 0x0001, 0x0401, 0x07FF },
    { 0x0B, 0x0001, 0x0401, 0x07FF },
    { 0x0B, 0x0001, 0x0401, 0x07FF },
    { 0x0B, 0x0001, 0x0401, 0x07FF },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x09, 0x0001, 0x0401, 0xFE00 },
    { 0x0A, 0x0001, 0x0401, 0x0001 },
    { 0x0A, 0x0001, 0x0401, 0x0001 },
    { 0x0A, 0x0001, 0x0401, 0x0001 },
    { 0x0A, 0x0001, 0x0401, 0x0001 },
    { 0x0A, 0x0001, 0x0401, 0x0001 },
    { 0x0A, 0x0001, 0x0401, 0x0001 },
    { 0x0A, 0x0001, 0x0401, 0x0001 },
    { 0x0A, 0x0001, 0x0401, 0x0001 },
    { 0x0A, 0x0001, 0x0401, 0x03FF },
    { 0x0A, 0x0001, 0x0401, 0x03FF },
    { 0x0A, 0x0001, 0x0401, 0x03FF },
    { 0x0A, 0x0001, 0x0401, 0x03FF },
    { 0x0A, 0x0001, 0x0401, 0x03FF },
    { 0x0A, 0x0001, 0x0401, 0x03FF },
    { 0x0A, 0x0001, 0x0401, 0x03FF },
    { 0x0A, 0x0001, 0x0401, 0x03FF },
    { 0x07, 0x0001, 0x07FF, 0x0000 },
    { 0x0D, 0x0001, 0x07FF, 0x7C1F },
    { 0x07, 0x0001, 0x07FF, 0x0000 },
    { 0x07, 0x0001, 0x07FF, 0x0000 },
    { 0x07, 0x0001, 0x07FF, 0x0000 },
    { 0x07, 0x0001, 0x07FF, 0x0000 },
    { 0x07, 0x0001, 0x07FF, 0x0000 },
    { 0x07, 0x0001, 0x07FF, 0x0000 },
    { 0x07, 0x0001, 0x07FF, 0x0000 },
    { 0x07, 0x0001, 0x07FF, 0x0000 },
    { 0x0D, 0x0001, 0x07FF, 0x0003 },
    { 0x0D, 0x0001, 0x07FF, 0x03FD },
    { 0x0D, 0x0001, 0x07FF, 0x1001 },
    { 0x0D, 0x0001, 0x07FF, 0x13FF },
    { 0x0D, 0x0001, 0x07FF, 0x0C01 },
    { 0x0D, 0x0001, 0x07FF, 0x0FFF },
    { 0x0C, 0x0001, 0x07FF, 0x0002 },
    { 0x0C, 0x0001, 0x07FF, 0x0002 },
    { 0x0C, 0x0001, 0x07FF, 0x03FE },
    { 0x0C, 0x0001, 0x07FF, 0x03FE },
    { 0x0C, 0x0001, 0x07FF, 0x0801 },
    { 0x0C, 0x0001, 0x07FF, 0x0801 },
    { 0x0C, 0x0001, 0x07FF, 0x0BFF },
    { 0x0C, 0x0001, 0x07FF, 0x0BFF },
    { 0x0B, 0x0001, 0x07FF, 0x0401 },
    { 0x0B, 0x0001, 0x07FF, 0x0401 },
    { 0x0B, 0x0001, 0x07FF, 0x0401 },
    { 0x0B, 0x0001, 0x07FF, 0x0401 },
    { 0x0B, 0x0001, 0x07FF, 0x07FF },
    { 0x0B, 0x0001, 0x07FF, 0x07FF },
    { 0x0B, 0x0001, 0x07FF, 0x07FF },
    { 0x0B, 0x0001, 0x07FF, 0x07FF },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x09, 0x0001, 0x07FF, 0xFE00 },
    { 0x0A, 0x0001, 0x07FF, 0x0001 },
    { 0x0A, 0x0001, 0x07FF, 0x0001 },
    { 0x0A, 0x0001, 0x07FF, 0x0001 },
    { 0x0A, 0x0001, 0x07FF, 0x0001 },
    { 0x0A, 0x0001, 0x07FF, 0x0001 },
    { 0x0A, 0x0001, 0x07FF, 0x0001 },
    { 0x0A, 0x0001, 0x07FF, 0x0001 },
    { 0x0A, 0x0001, 0x07FF, 0x0001 },
    { 0x0A, 0x0001, 0x07FF, 0x03FF },
    { 0x0A, 0x0001, 0x07FF, 0x03FF },
    { 0x0A, 0x0001, 0x07FF, 0x03FF },
    { 0x0A, 0x0001, 0x07FF, 0x03FF },
    { 0x0A, 0x0001, 0x07FF, 0x03FF },
    { 0x0A, 0x0001, 0x07FF, 0x03FF },
    { 0x0A, 0x0001, 0x07FF, 0x03FF },
    { 0x0A, 0x0001, 0x07FF, 0x03FF },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x05, 0x0001, 0xFE00, 0x0000 },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x0C, 0x0001, 0x0001, 0x7C1F },
    { 0x0C, 0x0001, 0x0001, 0x7C1F },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x0D, 0x0001, 0x0001, 0x1C01 },
    { 0x0D, 0x0001, 0x0001, 0x1FFF },
    { 0x0D, 0x0001, 0x0001, 0x1801 },
    { 0x0D, 0x0001, 0x0001, 0x1BFF },
    { 0x0D, 0x0001, 0x0001, 0x0402 },
    { 0x0D, 0x0001, 0x0001, 0x07FE },
    { 0x0D, 0x0001, 0x0001, 0x1401 },
    { 0x0D, 0x0001, 0x0001, 0x17FF },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x06, 0x0001, 0x0001, 0x0000 },
    { 0x0C, 0x0001, 0x0001, 0x0003 },
    { 0x0C, 0x0001, 0x0001, 0x0003 },
    { 0x0C, 0x0001, 0x0001, 0x03FD },
    { 0x0C, 0x0001, 0x0001, 0x03FD },
    { 0x0C, 0x0001, 0x0001, 0x1001 },
    { 0x0C, 0x0001, 0x0001, 0x1001 },
    { 0x0C, 0x0001, 0x0001, 0x13FF },
    { 0x0C, 0x0001, 0x0001, 0x13FF },
    { 0x0C, 0x0001, 0x0001, 0x0C01 },
    { 0x0C, 0x0001, 0x0001, 0x0C01 },
    { 0x0C, 0x0001, 0x0001, 0x0FFF },
    { 0x0C, 0x0001, 0x0001, 0x0FFF },
    { 0x0B, 0x0001, 0x0001, 0x0002 },
    { 0x0B, 0x0001, 0x0001, 0x0002 },
    { 0x0B, 0x0001, 0x0001, 0x0002 },
    { 0x0B, 0x0001, 0x0001, 0x0002 },
    { 0x0B, 0x0001, 0x0001, 0x03FE },
    { 0x0B, 0x0001, 0x0001, 0x03FE },
    { 0x0B, 0x0001, 0x0001, 0x03FE },
    { 0x0B, 0x0001, 0x0001, 0x03FE },
    { 0x0B, 0x0001, 0x0001, 0x0801 },
    { 0x0B, 0x0001, 0x0001, 0x0801 },
    { 0x0B, 0x0001, 0x0001, 0x0801 },
    { 0x0B, 0x0001, 0x0001, 0x0801 },
    { 0x0B, 0x0001, 0x0001, 0x0BFF },
    { 0x0B, 0x0001, 0x0001, 0x0BFF },
    { 0x0B, 0x0001, 0x0001, 0x0BFF },
    { 0x0B, 0x0001, 0x0001, 0x0BFF },
    { 0x0A, 0x0001, 0x0001, 0x0401 },
    { 0x0A, 0x0001, 0x0001, 0x0401 },
    { 0x0A, 0x0001, 0x0001, 0x0401 },
    { 0x0A, 0x0001, 0x0001, 0x0401 },
    { 0x0A, 0x0001, 0x0001, 0x0401 },
    { 0x0A, 0x0001, 0x0001, 0x0401 },
    { 0x0A, 0x0001, 0x0001, 0x0401 },
    { 0x0A, 0x0001, 0x0001, 0x0401 },
    { 0x0A, 0x0001, 0x0001, 0x07FF },
    { 0x0A, 0x0001, 0x0001, 0x07FF },
    { 0x0A, 0x0001, 0x0001, 0x07FF },
    { 0x0A, 0x0001, 0x0001, 0x07FF },
    { 0x0A, 0x0001, 0x0001, 0x07FF },
    { 0x0A, 0x0001, 0x0001, 0x07FF },
    { 0x0A, 0x0001, 0x0001, 0x07FF },
    { 0x0A, 0x0001, 0x0001, 0x07FF },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x08, 0x0001, 0x0001, 0xFE00 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x0001 },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x09, 0x0001, 0x0001, 0x03FF },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x0C, 0x0001, 0x03FF, 0x7C1F },
    { 0x0C, 0x0001, 0x03FF, 0x7C1F },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x0D, 0x0001, 0x03FF, 0x1C01 },
    { 0x0D, 0x0001, 0x03FF, 0x1FFF },
    { 0x0D, 0x0001, 0x03FF, 0x1801 },
    { 0x0D, 0x0001, 0x03FF, 0x1BFF },
    { 0x0D, 0x0001, 0x03FF, 0x0402 },
    { 0x0D, 0x0001, 0x03FF, 0x07FE },
    { 0x0D, 0x0001, 0x03FF, 0x1401 },
    { 0x0D, 0x0001, 0x03FF, 0x17FF },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x06, 0x0001, 0x03FF, 0x0000 },
    { 0x0C, 0x0001, 0x03FF, 0x0003 },
    { 0x0C, 0x0001, 0x03FF, 0x0003 },
    { 0x0C, 0x0001, 0x03FF, 0x03FD },
    { 0x0C, 0x0001, 0x03FF, 0x03FD },
    { 0x0C, 0x0001, 0x03FF, 0x1001 },
    { 0x0C, 0x0001, 0x03FF, 0x1001 },
    { 0x0C, 0x0001, 0x03FF, 0x13FF },
    { 0x0C, 0x0001, 0x03FF, 0x13FF },
    { 0x0C, 0x0001, 0x03FF, 0x0C01 },
    { 0x0C, 0x0001, 0x03FF, 0x0C01 },
    { 0x0C, 0x0001, 0x03FF, 0x0FFF },
    { 0x0C, 0x0001, 0x03FF, 0x0FFF },
    { 0x0B, 0x0001, 0x03FF, 0x0002 },
    { 0x0B, 0x0001, 0x03FF, 0x0002 },
    { 0x0B, 0x0001, 0x03FF, 0x0002 },
    { 0x0B, 0x0001, 0x03FF, 0x0002 },
    { 0x0B, 0x0001, 0x03FF, 0x03FE },
    { 0x0B, 0x0001, 0x03FF, 0x03FE },
    { 0x0B, 0x0001, 0x03FF, 0x03FE },
    { 0x0B, 0x0001, 0x03FF, 0x03FE },
    { 0x0B, 0x0001, 0x03FF, 0x0801 },
    { 0x0B, 0x0001, 0x03FF, 0x0801 },
    { 0x0B, 0x0001, 0x03FF, 0x0801 },
    { 0x0B, 0x0001, 0x03FF, 0x0801 },
    { 0x0B, 0x0001, 0x03FF, 0x0BFF },
    { 0x0B, 0x0001, 0x03FF, 0x0BFF },
    { 0x0B, 0x0001, 0x03FF, 0x0BFF },
    { 0x0B, 0x0001, 0x03FF, 0x0BFF },
    { 0x0A, 0x0001, 0x03FF, 0x0401 },
    { 0x0A, 0x0001, 0x03FF, 0x0401 },
    { 0x0A, 0x0001, 0x03FF, 0x0401 },
    { 0x0A, 0x0001, 0x03FF, 0x0401 },
    { 0x0A, 0x0001, 0x03FF, 0x0401 },
    { 0x0A, 0x0001, 0x03FF, 0x0401 },
    { 0x0A, 0x0001, 0x03FF, 0x0401 },
    { 0x0A, 0x0001, 0x03FF, 0x0401 },
    { 0x0A, 0x0001, 0x03FF, 0x07FF },
    { 0x0A, 0x0001, 0x03FF, 0x07FF },
    { 0x0A, 0x0001, 0x03FF, 0x07FF },
    { 0x0A, 0x0001, 0x03FF, 0x07FF },
    { 0x0A, 0x0001, 0x03FF, 0x07FF },
    { 0x0A, 0x0001, 0x03FF, 0x07FF },
    { 0x0A, 0x0001, 0x03FF, 0x07FF },
    { 0x0A, 0x0001, 0x03FF, 0x07FF },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x08, 0x0001, 0x03FF, 0xFE00 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x0001 },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x09, 0x0001, 0x03FF, 0x03FF },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x03, 0x03FF, 0x0000, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x09, 0x03FF, 0x7C1F, 0x0000 },
    { 0x0B, 0x03FF, 0x0802, 0x0000 },
    { 0x0B, 0x03FF, 0x0802, 0x0000 },
    { 0x0D, 0x03FF, 0x0802, 0xFE00 },
    { 0x0B, 0x03FF, 0x0802, 0x0000 },
    { 0x0B, 0x03FF, 0x0BFE, 0x0000 },
    { 0x0B, 0x03FF, 0x0BFE, 0x0000 },
    { 0x0D, 0x03FF, 0x0BFE, 0xFE00 },
    { 0x0B, 0x03FF, 0x0BFE, 0x0000 },
    { 0x0B, 0x03FF, 0x2401, 0x0000 },
    { 0x0B, 0x03FF, 0x2401, 0x0000 },
    { 0x0D, 0x03FF, 0x2401, 0xFE00 },
    { 0x0B, 0x03FF, 0x2401, 0x0000 },
    { 0x0B, 0x03FF, 0x27FF, 0x0000 },
    { 0x0B, 0x03FF, 0x27FF, 0x0000 },
    { 0x0D, 0x03FF, 0x27FF, 0xFE00 },
    { 0x0B, 0x03FF, 0x27FF, 0x0000 },
    { 0x0B, 0x03FF, 0x0004, 0x0000 },
    { 0x0B, 0x03FF, 0x0004, 0x0000 },
    { 0x0D, 0x03FF, 0x0004, 0xFE00 },
    { 0x0B, 0x03FF, 0x0004, 0x0000 },
    { 0x0B, 0x03FF, 0x03FC, 0x0000 },
    { 0x0B, 0x03FF, 0x03FC, 0x0000 },
    { 0x0D, 0x03FF, 0x03FC, 0xFE00 },
    { 0x0B, 0x03FF, 0x03FC, 0x0000 },
    { 0x0B, 0x03FF, 0x2001, 0x0000 },
    { 0x0B, 0x03FF, 0x2001, 0x0000 },
    { 0x0D, 0x03FF, 0x2001, 0xFE00 },
    { 0x0B, 0x03FF, 0x2001, 0x0000 },
    { 0x0B, 0x03FF, 0x23FF, 0x0000 },
    { 0x0B, 0x03FF, 0x23FF, 0x0000 },
    { 0x0D, 0x03FF, 0x23FF, 0xFE00 },
    { 0x0B, 0x03FF, 0x23FF, 0x0000 },
    { 0x0A, 0x03FF, 0x1C01, 0x0000 },
    { 0x0A, 0x03FF, 0x1C01, 0x0000 },
    { 0x0A, 0x03FF, 0x1C01, 0x0000 },
    { 0x0A, 0x03FF, 0x1C01, 0x0000 },
    { 0x0C, 0x03FF, 0x1C01, 0xFE00 },
    { 0x0C, 0x03FF, 0x1C01, 0xFE00 },
    { 0x0D, 0x03FF, 0x1C01, 0x0001 },
    { 0x0D, 0x03FF, 0x1C01, 0x03FF },
    { 0x0A, 0x03FF, 0x1FFF, 0x0000 },
    { 0x0A, 0x03FF, 0x1FFF, 0x0000 },
    { 0x0A, 0x03FF, 0x1FFF, 0x0000 },
    { 0x0A, 0x03FF, 0x1FFF, 0x0000 },
    { 0x0C, 0x03FF, 0x1FFF, 0xFE00 },
    { 0x0C, 0x03FF, 0x1FFF, 0xFE00 },
    { 0x0D, 0x03FF, 0x1FFF, 0x0001 },
    { 0x0D, 0x03FF, 0x1FFF, 0x03FF },
    { 0x0A, 0x03FF, 0x1801, 0x0000 },
    { 0x0A, 0x03FF, 0x1801, 0x0000 },
    { 0x0A, 0x03FF, 0x1801, 0x0000 },
    { 0x0A, 0x03FF, 0x1801, 0x0000 },
    { 0x0C, 0x03FF, 0x1801, 0xFE00 },
    { 0x0C, 0x03FF, 0x1801, 0xFE00 },
    { 0x0D, 0x03FF, 0x1801, 0x0001 },
    { 0x0D, 0x03FF, 0x1801, 0x03FF },
    { 0x0A, 0x03FF, 0x1BFF, 0x0000 },
    { 0x0A, 0x03FF, 0x1BFF, 0x0000 },
    { 0x0A, 0x03FF, 0x1BFF, 0x0000 },
    { 0x0A, 0x03FF, 0x1BFF, 0x0000 },
    { 0x0C, 0x03FF, 0x1BFF, 0xFE00 },
    { 0x0C, 0x03FF, 0x1BFF, 0xFE00 },
    { 0x0D, 0x03FF, 0x1BFF, 0x0001 },
    { 0x0D, 0x03FF, 0x1BFF, 0x03FF },
    { 0x0A, 0x03FF, 0x0402, 0x0000 },
    { 0x0A, 0x03FF, 0x0402, 0x0000 },
    { 0x0A, 0x03FF, 0x0402, 0x0000 },
    { 0x0A, 0x03FF, 0x0402, 0x0000 },
    { 0x0C, 0x03FF, 0x0402, 0xFE00 },
    { 0x0C, 0x03FF, 0x0402, 0xFE00 },
    { 0x0D, 0x03FF, 0x0402, 0x0001 },
    { 0x0D, 0x03FF, 0x0402, 0x03FF },
    { 0x0A, 0x03FF, 0x07FE, 0x0000 },
    { 0x0A, 0x03FF, 0x07FE, 0x0000 },
    { 0x0A, 0x03FF, 0x07FE, 0x0000 },
    { 0x0A, 0x03FF, 0x07FE, 0x0000 },
    { 0x0C, 0x03FF, 0x07FE, 0xFE00 },
    { 0x0C, 0x03FF, 0x07FE, 0xFE00 },
    { 0x0D, 0x03FF, 0x07FE, 0x0001 },
    { 0x0D, 0x03FF, 0x07FE, 0x03FF },
    { 0x0A, 0x03FF, 0x1401, 0x0000 },
    { 0x0A, 0x03FF, 0x1401, 0x0000 },
    { 0x0A, 0x03FF, 0x1401, 0x0000 },
    { 0x0A, 0x03FF, 0x1401, 0x0000 },
    { 0x0C, 0x03FF, 0x1401, 0xFE00 },
    { 0x0C, 0x03FF, 0x1401, 0xFE00 },
    { 0x0D, 0x03FF, 0x1401, 0x0001 },
    { 0x0D, 0x03FF, 0x1401, 0x03FF },
    { 0x0A, 0x03FF, 0x17FF, 0x0000 },
    { 0x0A, 0x03FF, 0x17FF, 0x0000 },
    { 0x0A, 0x03FF, 0x17FF, 0x0000 },
    { 0x0A, 0x03FF, 0x17FF, 0x0000 },
    { 0x0C, 0x03FF, 0x17FF, 0xFE00 },
    { 0x0C, 0x03FF, 0x17FF, 0xFE00 },
    { 0x0D, 0x03FF, 0x17FF, 0x0001 },
    { 0x0D, 0x03FF, 0x17FF, 0x03FF },
    { 0x0C, 0x03FF, 0x3401, 0x0000 },
    { 0x0C, 0x03FF, 0x3401, 0x0000 },
    { 0x0C, 0x03FF, 0x37FF, 0x0000 },
    { 0x0C, 0x03FF, 0x37FF, 0x0000 },
    { 0x0C, 0x03FF, 0x0006, 0x0000 },
    { 0x0C, 0x03FF, 0x0006, 0x0000 },
    { 0x0C, 0x03FF, 0x03FA, 0x0000 },
    { 0x0C, 0x03FF, 0x03FA, 0x0000 },
    { 0x0C, 0x03FF, 0x3001, 0x0000 },
    { 0x0C, 0x03FF, 0x3001, 0x0000 },
    { 0x0C, 0x03FF, 0x33FF, 0x0000 },
    { 0x0C, 0x03FF, 0x33FF, 0x0000 },
    { 0x0C, 0x03FF, 0x2C01, 0x0000 },
    { 0x0C, 0x03FF, 0x2C01, 0x0000 },
    { 0x0C, 0x03FF, 0x2FFF, 0x0000 },
    { 0x0C, 0x03FF, 0x2FFF, 0x0000 },
    { 0x0C, 0x03FF, 0x0C02, 0x0000 },
    { 0x0C, 0x03FF, 0x0C02, 0x0000 },
    { 0x0C, 0x03FF, 0x0FFE, 0x0000 },
    { 0x0C, 0x03FF, 0x0FFE, 0x0000 },
    { 0x0C, 0x03FF, 0x0403, 0x0000 },
    { 0x0C, 0x03FF, 0x0403, 0x0000 },
    { 0x0C, 0x03FF, 0x07FD, 0x0000 },
    { 0x0C, 0x03FF, 0x07FD, 0x0000 },
    { 0x0C, 0x03FF, 0x0005, 0x0000 },
    { 0x0C, 0x03FF, 0x0005, 0x0000 },
    { 0x0C, 0x03FF, 0x03FB, 0x0000 },
    { 0x0C, 0x03FF, 0x03FB, 0x0000 },
    { 0x0C, 0x03FF, 0x2801, 0x0000 },
    { 0x0C, 0x03FF, 0x2801, 0x0000 },
    { 0x0C, 0x03FF, 0x2BFF, 0x0000 },
    { 0x0C, 0x03FF, 0x2BFF, 0x0000 },
    { 0x09, 0x03FF, 0x0003, 0x0000 },
    { 0x09, 0x03FF, 0x0003, 0x0000 },
    { 0x09, 0x03FF, 0x0003, 0x0000 },
    { 0x09, 0x03FF, 0x0003, 0x0000 },
    { 0x09, 0x03FF, 0x0003, 0x0000 },
    { 0x09, 0x03FF, 0x0003, 0x0000 },
    { 0x0D, 0x03FF, 0x0003, 0x0401 },
    { 0x0D, 0x03FF, 0x0003, 0x07FF },
    { 0x0B, 0x03FF, 0x0003, 0xFE00 },
    { 0x0B, 0x03FF, 0x0003, 0xFE00 },
    { 0x0B, 0x03FF, 0x0003, 0xFE00 },
    { 0x0B, 0x03FF, 0x0003, 0xFE00 },
    { 0x0C, 0x03FF, 0x0003, 0x0001 },
    { 0x0C, 0x03FF, 0x0003, 0x0001 },
    { 0x0C, 0x03FF, 0x0003, 0x03FF },
    { 0x0C, 0x03FF, 0x0003, 0x03FF },
    { 0x09, 0x03FF, 0x03FD, 0x0000 },
    { 0x09, 0x03FF, 0x03FD, 0x0000 },
    { 0x09, 0x03FF, 0x03FD, 0x0000 },
    { 0x09, 0x03FF, 0x03FD, 0x0000 },
    { 0x09, 0x03FF, 0x03FD, 0x0000 },
    { 0x09, 0x03FF, 0x03FD, 0x0000 },
    { 0x0D, 0x03FF, 0x03FD, 0x0401 },
    { 0x0D, 0x03FF, 0x03FD, 0x07FF },
    { 0x0B, 0x03FF, 0x03FD, 0xFE00 },
    { 0x0B, 0x03FF, 0x03FD, 0xFE00 },
    { 0x0B, 0x03FF, 0x03FD, 0xFE00 },
    { 0x0B, 0x03FF, 0x03FD, 0xFE00 },
    { 0x0C, 0x03FF, 0x03FD, 0x0001 },
    { 0x0C, 0x03FF, 0x03FD, 0x0001 },
    { 0x0C, 0x03FF, 0x03FD, 0x03FF },
    { 0x0C, 0x03FF, 0x03FD, 0x03FF },
    { 0x09, 0x03FF, 0x1001, 0x0000 },
    { 0x09, 0x03FF, 0x1001, 0x0000 },
    { 0x09, 0x03FF, 0x1001, 0x0000 },
    { 0x09, 0x03FF, 0x1001, 0x0000 },
    { 0x09, 0x03FF, 0x1001, 0x0000 },
    { 0x09, 0x03FF, 0x1001, 0x0000 },
    { 0x0D, 0x03FF, 0x1001, 0x0401 },
    { 0x0D, 0x03FF, 0x1001, 0x07FF },
    { 0x0B, 0x03FF, 0x1001, 0xFE00 },
    { 0x0B, 0x03FF, 0x1001, 0xFE00 },
    { 0x0B, 0x03FF, 0x1001, 0xFE00 },
    { 0x0B, 0x03FF, 0x1001, 0xFE00 },
    { 0x0C, 0x03FF, 0x1001, 0x0001 },
    { 0x0C, 0x03FF, 0x1001, 0x0001 },
    { 0x0C, 0x03FF, 0x1001, 0x03FF },
    { 0x0C, 0x03FF, 0x1001, 0x03FF },
    { 0x09, 0x03FF, 0x13FF, 0x0000 },
    { 0x09, 0x03FF, 0x13FF, 0x0000 },
    { 0x09, 0x03FF, 0x13FF, 0x0000 },
    { 0x09, 0x03FF, 0x13FF, 0x0000 },
    { 0x09, 0x03FF, 0x13FF, 0x0000 },
    { 0x09, 0x03FF, 0x13FF, 0x0000 },
    { 0x0D, 0x03FF, 0x13FF, 0x0401 },
    { 0x0D, 0x03FF, 0x13FF, 0x07FF },
    { 0x0B, 0x03FF, 0x13FF, 0xFE00 },
    { 0x0B, 0x03FF, 0x13FF, 0xFE00 },
    { 0x0B, 0x03FF, 0x13FF, 0xFE00 },
    { 0x0B, 0x03FF, 0x13FF, 0xFE00 },
    { 0x0C, 0x03FF, 0x13FF, 0x0001 },
    { 0x0C, 0x03FF, 0x13FF, 0x0001 },
    { 0x0C, 0x03FF, 0x13FF, 0x03FF },
    { 0x0C, 0x03FF, 0x13FF, 0x03FF },
    { 0x09, 0x03FF, 0x0C01, 0x0000 },
    { 0x09, 0x03FF, 0x0C01, 0x0000 },
    { 0x09, 0x03FF, 0x0C01, 0x0000 },
    { 0x09, 0x03FF, 0x0C01, 0x0000 },
    { 0x09, 0x03FF, 0x0C01, 0x0000 },
    { 0x09, 0x03FF, 0x0C01, 0x0000 },
    { 0x0D, 0x03FF, 0x0C01, 0x0401 },
    { 0x0D, 0x03FF, 0x0C01, 0x07FF },
    { 0x0B, 0x03FF, 0x0C01, 0xFE00 },
    { 0x0B, 0x03FF, 0x0C01, 0xFE00 },
    { 0x0B, 0x03FF, 0x0C01, 0xFE00 },
    { 0x0B, 0x03FF, 0x0C01, 0xFE00 },
    { 0x0C, 0x03FF, 0x0C01, 0x0001 },
    { 0x0C, 0x03FF, 0x0C01, 0x0001 },
    { 0x0C, 0x03FF, 0x0C01, 0x03FF },
    { 0x0C, 0x03FF, 0x0C01, 0x03FF },
    { 0x09, 0x03FF, 0x0FFF, 0x0000 },
    { 0x09, 0x03FF, 0x0FFF, 0x0000 },
    { 0x09, 0x03FF, 0x0FFF, 0x0000 },
    { 0x09, 0x03FF, 0x0FFF, 0x0000 },
    { 0x09, 0x03FF, 0x0FFF, 0x0000 },
    { 0x09, 0x03FF, 0x0FFF, 0x0000 },
    { 0x0D, 0x03FF, 0x0FFF, 0x0401 },
    { 0x0D, 0x03FF, 0x0FFF, 0x07FF },
    { 0x0B, 0x03FF, 0x0FFF, 0xFE00 },
    { 0x0B, 0x03FF, 0x0FFF, 0xFE00 },
    { 0x0B, 0x03FF, 0x0FFF, 0xFE00 },
    { 0x0B, 0x03FF, 0x0FFF, 0xFE00 },
    { 0x0C, 0x03FF, 0x0FFF, 0x0001 },
    { 0x0C, 0x03FF, 0x0FFF, 0x0001 },
    { 0x0C, 0x03FF, 0x0FFF, 0x03FF },
    { 0x0C, 0x03FF, 0x0FFF, 0x03FF },
    { 0x08, 0x03FF, 0x0002, 0x0000 },
    { 0x08, 0x03FF, 0x0002, 0x0000 },
    { 0x08, 0x03FF, 0x0002, 0x0000 },
    { 0x08, 0x03FF, 0x0002, 0x0000 },
    { 0x08, 0x03FF, 0x0002, 0x0000 },
    { 0x08, 0x03FF, 0x0002, 0x0000 },
    { 0x08, 0x03FF, 0x0002, 0x0000 },
    { 0x08, 0x03FF, 0x0002, 0x0000 },
    { 0x0D, 0x03FF, 0x0002, 0x0002 },
    { 0x0D, 0x03FF, 0x0002, 0x03FE },
    { 0x0D, 0x03FF, 0x0002, 0x0801 },
    { 0x0D, 0x03FF, 0x0002, 0x0BFF },
    { 0x0C, 0x03FF, 0x0002, 0x0401 },
    { 0x0C, 0x03FF, 0x0002, 0x0401 },
    { 0x0C, 0x03FF, 0x0002, 0x07FF },
    { 0x0C, 0x03FF, 0x0002, 0x07FF },
    { 0x0A, 0x03FF, 0x0002, 0xFE00 },
    { 0x0A, 0x03FF, 0x0002, 0xFE00 },
    { 0x0A, 0x03FF, 0x0002, 0xFE00 },
    { 0x0A, 0x03FF, 0x0002, 0xFE00 },
    { 0x0A, 0x03FF, 0x0002, 0xFE00 },
    { 0x0A, 0x03FF, 0x0002, 0xFE00 },
    { 0x0A, 0x03FF, 0x0002, 0xFE00 },
    { 0x0A, 0x03FF, 0x0002, 0xFE00 },
    { 0x0B, 0x03FF, 0x0002, 0x0001 },
    { 0x0B, 0x03FF, 0x0002, 0x0001 },
    { 0x0B, 0x03FF, 0x0002, 0x0001 },
    { 0x0B, 0x03FF, 0x0002, 0x0001 },
    { 0x0B, 0x03FF, 0x0002, 0x03FF },
    { 0x0B, 0x03FF, 0x0002, 0x03FF },
    { 0x0B, 0x03FF, 0x0002, 0x03FF },
    { 0x0B, 0x03FF, 0x0002, 0x03FF },
    { 0x08, 0x03FF, 0x03FE, 0x0000 },
    { 0x08, 0x03FF, 0x03FE, 0x0000 },
    { 0x08, 0x03FF, 0x03FE, 0x0000 },
    { 0x08, 0x03FF, 0x03FE, 0x0000 },
    { 0x08, 0x03FF, 0x03FE, 0x0000 },
    { 0x08, 0x03FF, 0x03FE, 0x0000 },
    { 0x08, 0x03FF, 0x03FE, 0x0000 },
    { 0x08, 0x03FF, 0x03FE, 0x0000 },
    { 0x0D, 0x03FF, 0x03FE, 0x0002 },
    { 0x0D, 0x03FF, 0x03FE, 0x03FE },
    { 0x0D, 0x03FF, 0x03FE, 0x0801 },
    { 0x0D, 0x03FF, 0x03FE, 0x0BFF },
    { 0x0C, 0x03FF, 0x03FE, 0x0401 },
    { 0x0C, 0x03FF, 0x03FE, 0x0401 },
    { 0x0C, 0x03FF, 0x03FE, 0x07FF },
    { 0x0C, 0x03FF, 0x03FE, 0x07FF },
    { 0x0A, 0x03FF, 0x03FE, 0xFE00 },
    { 0x0A, 0x03FF, 0x03FE, 0xFE00 },
    { 0x0A, 0x03FF, 0x03FE, 0xFE00 },
    { 0x0A, 0x03FF, 0x03FE, 0xFE00 },
    { 0x0A, 0x03FF, 0x03FE, 0xFE00 },
    { 0x0A, 0x03FF, 0x03FE, 0xFE00 },
    { 0x0A, 0x03FF, 0x03FE, 0xFE00 },
    { 0x0A, 0x03FF, 0x03FE, 0xFE00 },
    { 0x0B, 0x03FF, 0x03FE, 0x0001 },
    { 0x0B, 0x03FF, 0x03FE, 0x0001 },
    { 0x0B, 0x03FF, 0x03FE, 0x0001 },
    { 0x0B, 0x03FF, 0x03FE, 0x0001 },
    { 0x0B, 0x03FF, 0x03FE, 0x03FF },
    { 0x0B, 0x03FF, 0x03FE, 0x03FF },
    { 0x0B, 0x03FF, 0x03FE, 0x03FF },
    { 0x0B, 0x03FF, 0x03FE, 0x03FF },
    { 0x08, 0x03FF, 0x0801, 0x0000 },
    { 0x08, 0x03FF, 0x0801, 0x0000 },
    { 0x08, 0x03FF, 0x0801, 0x0000 },
    { 0x08, 0x03FF, 0x0801, 0x0000 },
    { 0x08, 0x03FF, 0x0801, 0x0000 },
    { 0x08, 0x03FF, 0x0801, 0x0000 },
    { 0x08, 0x03FF, 0x0801, 0x0000 },
    { 0x08, 0x03FF, 0x0801, 0x0000 },
    { 0x0D, 0x03FF, 0x0801, 0x0002 },
    { 0x0D, 0x03FF, 0x0801, 0x03FE },
    { 0x0D, 0x03FF, 0x0801, 0x0801 },
    { 0x0D, 0x03FF, 0x0801, 0x0BFF },
    { 0x0C, 0x03FF, 0x0801, 0x0401 },
    { 0x0C, 0x03FF, 0x0801, 0x0401 },
    { 0x0C, 0x03FF, 0x0801, 0x07FF },
    { 0x0C, 0x03FF, 0x0801, 0x07FF },
    { 0x0A, 0x03FF, 0x0801, 0xFE00 },
    { 0x0A, 0x03FF, 0x0801, 0xFE00 },
    { 0x0A, 0x03FF, 0x0801, 0xFE00 },
    { 0x0A, 0x03FF, 0x0801, 0xFE00 },
    { 0x0A, 0x03FF, 0x0801, 0xFE00 },
    { 0x0A, 0x03FF, 0x0801, 0xFE00 },
    { 0x0A, 0x03FF, 0x0801, 0xFE00 },
    { 0x0A, 0x03FF, 0x0801, 0xFE00 },
    { 0x0B, 0x03FF, 0x0801, 0x0001 },
    { 0x0B, 0x03FF, 0x0801, 0x0001 },
    { 0x0B, 0x03FF, 0x0801, 0x0001 },
    { 0x0B, 0x03FF, 0x0801, 0x0001 },
    { 0x0B, 0x03FF, 0x0801, 0x03FF },
    { 0x0B, 0x03FF, 0x0801, 0x03FF },
    { 0x0B, 0x03FF, 0x0801, 0x03FF },
    { 0x0B, 0x03FF, 0x0801, 0x03FF },
    { 0x08, 0x03FF, 0x0BFF, 0x0000 },
    { 0x08, 0x03FF, 0x0BFF, 0x0000 },
    { 0x08, 0x03FF, 0x0BFF, 0x0000 },
    { 0x08, 0x03FF, 0x0BFF, 0x0000 },
    { 0x08, 0x03FF, 0x0BFF, 0x0000 },
    { 0x08, 0x03FF, 0x0BFF, 0x0000 },
    { 0x08, 0x03FF, 0x0BFF, 0x0000 },
    { 0x08, 0x03FF, 0x0BFF, 0x0000 },
    { 0x0D, 0x03FF, 0x0BFF, 0x0002 },
    { 0x0D, 0x03FF, 0x0BFF, 0x03FE },
    { 0x0D, 0x03FF, 0x0BFF, 0x0801 },
    { 0x0D, 0x03FF, 0x0BFF, 0x0BFF },
    { 0x0C, 0x03FF, 0x0BFF, 0x0401 },
    { 0x0C, 0x03FF, 0x0BFF, 0x0401 },
    { 0x0C, 0x03FF, 0x0BFF, 0x07FF },
    { 0x0C, 0x03FF, 0x0BFF, 0x07FF },
    { 0x0A, 0x03FF, 0x0BFF, 0xFE00 },
    { 0x0A, 0x03FF, 0x0BFF, 0xFE00 },
    { 0x0A, 0x03FF, 0x0BFF, 0xFE00 },
    { 0x0A, 0x03FF, 0x0BFF, 0xFE00 },
    { 0x0A, 0x03FF, 0x0BFF, 0xFE00 },
    { 0x0A, 0x03FF, 0x0BFF, 0xFE00 },
    { 0x0A, 0x03FF, 0x0BFF, 0xFE00 },
    { 0x0A, 0x03FF, 0x0BFF, 0xFE00 },
    { 0x0B, 0x03FF, 0x0BFF, 0x0001 },
    { 0x0B, 0x03FF, 0x0BFF, 0x0001 },
    { 0x0B, 0x03FF, 0x0BFF, 0x0001 },
    { 0x0B, 0x03FF, 0x0BFF, 0x0001 },
    { 0x0B, 0x03FF, 0x0BFF, 0x03FF },
    { 0x0B, 0x03FF, 0x0BFF, 0x03FF },
    { 0x0B, 0x03FF, 0x0BFF, 0x03FF },
    { 0x0B, 0x03FF, 0x0BFF, 0x03FF },
    { 0x07, 0x03FF, 0x0401, 0x0000 },
    { 0x0D, 0x03FF, 0x0401, 0x7C1F },
    { 0x07, 0x03FF, 0x0401, 0x0000 },
    { 0x07, 0x03FF, 0x0401, 0x0000 },
    { 0x07, 0x03FF, 0x0401, 0x0000 },
    { 0x07, 0x03FF, 0x0401, 0x0000 },
    { 0x07, 0x03FF, 0x0401, 0x0000 },
    { 0x07, 0x03FF, 0x0401, 0x0000 },
    { 0x07, 0x03FF, 0x0401, 0x0000 },
    { 0x07, 0x03FF, 0x0401, 0x0000 },
    { 0x0D, 0x03FF, 0x0401, 0x0003 },
    { 0x0D, 0x03FF, 0x0401, 0x03FD },
    { 0x0D, 0x03FF, 0x0401, 0x1001 },
    { 0x0D, 0x03FF, 0x0401, 0x13FF },
    { 0x0D, 0x03FF, 0x0401, 0x0C01 },
    { 0x0D, 0x03FF, 0x0401, 0x0FFF },
    { 0x0C, 0x03FF, 0x0401, 0x0002 },
    { 0x0C, 0x03FF, 0x0401, 0x0002 },
    { 0x0C, 0x03FF, 0x0401, 0x03FE },
    { 0x0C, 0x03FF, 0x0401, 0x03FE },
    { 0x0C, 0x03FF, 0x0401, 0x0801 },
    { 0x0C, 0x03FF, 0x0401, 0x0801 },
    { 0x0C, 0x03FF, 0x0401, 0x0BFF },
    { 0x0C, 0x03FF, 0x0401, 0x0BFF },
    { 0x0B, 0x03FF, 0x0401, 0x0401 },
    { 0x0B, 0x03FF, 0x0401, 0x0401 },
    { 0x0B, 0x03FF, 0x0401, 0x0401 },
    { 0x0B, 0x03FF, 0x0401, 0x0401 },
    { 0x0B, 0x03FF, 0x0401, 0x07FF },
    { 0x0B, 0x03FF, 0x0401, 0x07FF },
    { 0x0B, 0x03FF, 0x0401, 0x07FF },
    { 0x0B, 0x03FF, 0x0401, 0x07FF },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x09, 0x03FF, 0x0401, 0xFE00 },
    { 0x0A, 0x03FF, 0x0401, 0x0001 },
    { 0x0A, 0x03FF, 0x0401, 0x0001 },
    { 0x0A, 0x03FF, 0x0401, 0x0001 },
    { 0x0A, 0x03FF, 0x0401, 0x0001 },
    { 0x0A, 0x03FF, 0x0401, 0x0001 },
    { 0x0A, 0x03FF, 0x0401, 0x0001 },
    { 0x0A, 0x03FF, 0x0401, 0x0001 },
    { 0x0A, 0x03FF, 0x0401, 0x0001 },
    { 0x0A, 0x03FF, 0x0401, 0x03FF },
    { 0x0A, 0x03FF, 0x0401, 0x03FF },
    { 0x0A, 0x03FF, 0x0401, 0x03FF },
    { 0x0A, 0x03FF, 0x0401, 0x03FF },
    { 0x0A, 0x03FF, 0x0401, 0x03FF },
    { 0x0A, 0x03FF, 0x0401, 0x03FF },
    { 0x0A, 0x03FF, 0x0401, 0x03FF },
    { 0x0A, 0x03FF, 0x0401, 0x03FF },
    { 0x07, 0x03FF, 0x07FF, 0x0000 },
    { 0x0D, 0x03FF, 0x07FF, 0x7C1F },
    { 0x07, 0x03FF, 0x07FF, 0x0000 },
    { 0x07, 0x03FF, 0x07FF, 0x0000 },
    { 0x07, 0x03FF, 0x07FF, 0x0000 },
    { 0x07, 0x03FF, 0x07FF, 0x0000 },
    { 0x07, 0x03FF, 0x07FF, 0x0000 },
    { 0x07, 0x03FF, 0x07FF, 0x0000 },
    { 0x07, 0x03FF, 0x07FF, 0x0000 },
    { 0x07, 0x03FF, 0x07FF, 0x0000 },
    { 0x0D, 0x03FF, 0x07FF, 0x0003 },
    { 0x0D, 0x03FF, 0x07FF, 0x03FD },
    { 0x0D, 0x03FF, 0x07FF, 0x1001 },
    { 0x0D, 0x03FF, 0x07FF, 0x13FF },
    { 0x0D, 0x03FF, 0x07FF, 0x0C01 },
    { 0x0D, 0x03FF, 0x07FF, 0x0FFF },
    { 0x0C, 0x03FF, 0x07FF, 0x0002 },
    { 0x0C, 0x03FF, 0x07FF, 0x0002 },
    { 0x0C, 0x03FF, 0x07FF, 0x03FE },
    { 0x0C, 0x03FF, 0x07FF, 0x03FE },
    { 0x0C, 0x03FF, 0x07FF, 0x0801 },
    { 0x0C, 0x03FF, 0x07FF, 0x0801 },
    { 0x0C, 0x03FF, 0x07FF, 0x0BFF },
    { 0x0C, 0x03FF, 0x07FF, 0x0BFF },
    { 0x0B, 0x03FF, 0x07FF, 0x0401 },
    { 0x0B, 0x03FF, 0x07FF, 0x0401 },
    { 0x0B, 0x03FF, 0x07FF, 0x0401 },
    { 0x0B, 0x03FF, 0x07FF, 0x0401 },
    { 0x0B, 0x03FF, 0x07FF, 0x07FF },
    { 0x0B, 0x03FF, 0x07FF, 0x07FF },
    { 0x0B, 0x03FF, 0x07FF, 0x07FF },
    { 0x0B, 0x03FF, 0x07FF, 0x07FF },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x09, 0x03FF, 0x07FF, 0xFE00 },
    { 0x0A, 0x03FF, 0x07FF, 0x0001 },
    { 0x0A, 0x03FF, 0x07FF, 0x0001 },
    { 0x0A, 0x03FF, 0x07FF, 0x0001 },
    { 0x0A, 0x03FF, 0x07FF, 0x0001 },
    { 0x0A, 0x03FF, 0x07FF, 0x0001 },
    { 0x0A, 0x03FF, 0x07FF, 0x0001 },
    { 0x0A, 0x03FF, 0x07FF, 0x0001 },
    { 0x0A, 0x03FF, 0x07FF, 0x0001 },
    { 0x0A, 0x03FF, 0x07FF, 0x03FF },
    { 0x0A, 0x03FF, 0x07FF, 0x03FF },
    { 0x0A, 0x03FF, 0x07FF, 0x03FF },
    { 0x0A, 0x03FF, 0x07FF, 0x03FF },
    { 0x0A, 0x03FF, 0x07FF, 0x03FF },
    { 0x0A, 0x03FF, 0x07FF, 0x03FF },
    { 0x0A, 0x03FF, 0x07FF, 0x03FF },
    { 0x0A, 0x03FF, 0x07FF, 0x03FF },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x05, 0x03FF, 0xFE00, 0x0000 },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x0C, 0x03FF, 0x0001, 0x7C1F },
    { 0x0C, 0x03FF, 0x0001, 0x7C1F },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x0D, 0x03FF, 0x0001, 0x1C01 },
    { 0x0D, 0x03FF, 0x0001, 0x1FFF },
    { 0x0D, 0x03FF, 0x0001, 0x1801 },
    { 0x0D, 0x03FF, 0x0001, 0x1BFF },
    { 0x0D, 0x03FF, 0x0001, 0x0402 },
    { 0x0D, 0x03FF, 0x0001, 0x07FE },
    { 0x0D, 0x03FF, 0x0001, 0x1401 },
    { 0x0D, 0x03FF, 0x0001, 0x17FF },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x06, 0x03FF, 0x0001, 0x0000 },
    { 0x0C, 0x03FF, 0x0001, 0x0003 },
    { 0x0C, 0x03FF, 0x0001, 0x0003 },
    { 0x0C, 0x03FF, 0x0001, 0x03FD },
    { 0x0C, 0x03FF, 0x0001, 0x03FD },
    { 0x0C, 0x03FF, 0x0001, 0x1001 },
    { 0x0C, 0x03FF, 0x0001, 0x1001 },
    { 0x0C, 0x03FF, 0x0001, 0x13FF },
    { 0x0C, 0x03FF, 0x0001, 0x13FF },
    { 0x0C, 0x03FF, 0x0001, 0x0C01 },
    { 0x0C, 0x03FF, 0x0001, 0x0C01 },
    { 0x0C, 0x03FF, 0x0001, 0x0FFF },
    { 0x0C, 0x03FF, 0x0001, 0x0FFF },
    { 0x0B, 0x03FF, 0x0001, 0x0002 },
    { 0x0B, 0x03FF, 0x0001, 0x0002 },
    { 0x0B, 0x03FF, 0x0001, 0x0002 },
    { 0x0B, 0x03FF, 0x0001, 0x0002 },
    { 0x0B, 0x03FF, 0x0001, 0x03FE },
    { 0x0B, 0x03FF, 0x0001, 0x03FE },
    { 0x0B, 0x03FF, 0x0001, 0x03FE },
    { 0x0B, 0x03FF, 0x0001, 0x03FE },
    { 0x0B, 0x03FF, 0x0001, 0x0801 },
    { 0x0B, 0x03FF, 0x0001, 0x0801 },
    { 0x0B, 0x03FF, 0x0001, 0x0801 },
    { 0x0B, 0x03FF, 0x0001, 0x0801 },
    { 0x0B, 0x03FF, 0x0001, 0x0BFF },
    { 0x0B, 0x03FF, 0x0001, 0x0BFF },
    { 0x0B, 0x03FF, 0x0001, 0x0BFF },
    { 0x0B, 0x03FF, 0x0001, 0x0BFF },
    { 0x0A, 0x03FF, 0x0001, 0x0401 },
    { 0x0A, 0x03FF, 0x0001, 0x0401 },
    { 0x0A, 0x03FF, 0x0001, 0x0401 },
    { 0x0A, 0x03FF, 0x0001, 0x0401 },
    { 0x0A, 0x03FF, 0x0001, 0x0401 },
    { 0x0A, 0x03FF, 0x0001, 0x0401 },
    { 0x0A, 0x03FF, 0x0001, 0x0401 },
    { 0x0A, 0x03FF, 0x0001, 0x0401 },
    { 0x0A, 0x03FF, 0x0001, 0x07FF },
    { 0x0A, 0x03FF, 0x0001, 0x07FF },
    { 0x0A, 0x03FF, 0x0001, 0x07FF },
    { 0x0A, 0x03FF, 0x0001, 0x07FF },
    { 0x0A, 0x03FF, 0x0001, 0x07FF },
    { 0x0A, 0x03FF, 0x0001, 0x07FF },
    { 0x0A, 0x03FF, 0x0001, 0x07FF },
    { 0x0A, 0x03FF, 0x0001, 0x07FF },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x08, 0x03FF, 0x0001, 0xFE00 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x0001 },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x09, 0x03FF, 0x0001, 0x03FF },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x0C, 0x03FF, 0x03FF, 0x7C1F },
    { 0x0C, 0x03FF, 0x03FF, 0x7C1F },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x0D, 0x03FF, 0x03FF, 0x1C01 },
    { 0x0D, 0x03FF, 0x03FF, 0x1FFF },
    { 0x0D, 0x03FF, 0x03FF, 0x1801 },
    { 0x0D, 0x03FF, 0x03FF, 0x1BFF },
    { 0x0D, 0x03FF, 0x03FF, 0x0402 },
    { 0x0D, 0x03FF, 0x03FF, 0x07FE },
    { 0x0D, 0x03FF, 0x03FF, 0x1401 },
    { 0x0D, 0x03FF, 0x03FF, 0x17FF },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x06, 0x03FF, 0x03FF, 0x0000 },
    { 0x0C, 0x03FF, 0x03FF, 0x0003 },
    { 0x0C, 0x03FF, 0x03FF, 0x0003 },
    { 0x0C, 0x03FF, 0x03FF, 0x03FD },
    { 0x0C, 0x03FF, 0x03FF, 0x03FD },
    { 0x0C, 0x03FF, 0x03FF, 0x1001 },
    { 0x0C, 0x03FF, 0x03FF, 0x1001 },
    { 0x0C, 0x03FF, 0x03FF, 0x13FF },
    { 0x0C, 0x03FF, 0x03FF, 0x13FF },
    { 0x0C, 0x03FF, 0x03FF, 0x0C01 },
    { 0x0C, 0x03FF, 0x03FF, 0x0C01 },
    { 0x0C, 0x03FF, 0x03FF, 0x0FFF },
    { 0x0C, 0x03FF, 0x03FF, 0x0FFF },
    { 0x0B, 0x03FF, 0x03FF, 0x0002 },
    { 0x0B, 0x03FF, 0x03FF, 0x0002 },
    { 0x0B, 0x03FF, 0x03FF, 0x0002 },
    { 0x0B, 0x03FF, 0x03FF, 0x0002 },
    { 0x0B, 0x03FF, 0x03FF, 0x03FE },
    { 0x0B, 0x03FF, 0x03FF, 0x03FE },
    { 0x0B, 0x03FF, 0x03FF, 0x03FE },
    { 0x0B, 0x03FF, 0x03FF, 0x03FE },
    { 0x0B, 0x03FF, 0x03FF, 0x0801 },
    { 0x0B, 0x03FF, 0x03FF, 0x0801 },
    { 0x0B, 0x03FF, 0x03FF, 0x0801 },
    { 0x0B, 0x03FF, 0x03FF, 0x0801 },
    { 0x0B, 0x03FF, 0x03FF, 0x0BFF },
    { 0x0B, 0x03FF, 0x03FF, 0x0BFF },
    { 0x0B, 0x03FF, 0x03FF, 0x0BFF },
    { 0x0B, 0x03FF, 0x03FF, 0x0BFF },
    { 0x0A, 0x03FF, 0x03FF, 0x0401 },
    { 0x0A, 0x03FF, 0x03FF, 0x0401 },
    { 0x0A, 0x03FF, 0x03FF, 0x0401 },
    { 0x0A, 0x03FF, 0x03FF, 0x0401 },
    { 0x0A, 0x03FF, 0x03FF, 0x0401 },
    { 0x0A, 0x03FF, 0x03FF, 0x0401 },
    { 0x0A, 0x03FF, 0x03FF, 0x0401 },
    { 0x0A, 0x03FF, 0x03FF, 0x0401 },
    { 0x0A, 0x03FF, 0x03FF, 0x07FF },
    { 0x0A, 0x03FF, 0x03FF, 0x07FF },
    { 0x0A, 0x03FF, 0x03FF, 0x07FF },
    { 0x0A, 0x03FF, 0x03FF, 0x07FF },
    { 0x0A, 0x03FF, 0x03FF, 0x07FF },
    { 0x0A, 0x03FF, 0x03FF, 0x07FF },
    { 0x0A, 0x03FF, 0x03FF, 0x07FF },
    { 0x0A, 0x03FF, 0x03FF, 0x07FF },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x08, 0x03FF, 0x03FF, 0xFE00 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x0001 },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF },
    { 0x09, 0x03FF, 0x03FF, 0x03FF }
};
