-- USE wiztools;

INSERT INTO `wtkCompanySettings` (`CoName`, `DomainName`, `AppVersion`, `EnableLockout`)
 VALUES ('Your Company', 'https://your-company.com', '2.0.0', 'Y');

INSERT INTO `wtkUsers` (`UID`,`DelDate`,`FirstName`,`LastName`,`Address`,`Title`,`Email`,`WebPassword`,`SecurityLevel`,`StaffRole`,`CanPrint`,`CanExport`,`FilePath`,`NewFileName`,`NewPassHash`)
 VALUES (1,NULL,'Your','Name','Some Address', 'Admin', 'admin@email.com', 'needToSet', 99, 'Tech', 'Y', 'Y',NULL,NULL,'needToSet'),
   (2, NOW(), 'Your', 'Server', 'web server', 'Internal Processing', 'server@yourdomain.com', NULL, 99, 'Tech', 'N', 'N',NULL,NULL,NULL);
UPDATE `wtkUsers` SET `UID` = 0 WHERE `UID` = 2;

INSERT INTO `wtkEcommerce` (`PaymentProvider`, `EcomWebsite`)
  VALUES ('PayPal','https://www.paypal.com'),
         ('Stripe','https://www.stripe.com'),
         ('Checkout.com','https://www.checkout.com');

INSERT INTO `wtkEmailTemplate` (`EmailCode`, `AutomationOnly`, `EmailType`, `Subject`, `EmailBody`, `InternalNote`) VALUES
('invite', 'Y', 'A', 'Welcome to @CompanyName@', '<p>Welcome to our website.</p>\r\n<p>Log in at @website@ using your email and password.</p>\r\n<p>If you do not know your password you can request a password reset on our website.</p>', 'this template is called from the User List by clicking the "Send Invite" button'),
('WelcomePIN', 'Y', 'A', 'Welcome to @CompanyName@', '<p>Welcome to our website.</p>\r\n<p>Your PIN is: <span style=\"font-family: \'Courier New\';\"><b>@PIN@</b></span></p>\r\n<p>Thank you for joining our website!</p>', 'this template is called from PIN Registration process'),
('DelAcct', 'Y', 'A', 'Account Deleted', '<h3>Account Deleted</h3>\r\nAs requested, your account has been deleted and all personally identifiable information (PII) has been removed from our database.\r\n\r\nWe are sorry to see you go.  If you ever want to return, simply register a new account at our website at:\r\n@website@\r\n\r\nSincerely,\r\n@CompanyName@', 'automatically sent when user chooses to delete their account');

INSERT INTO `wtkReports` (`ViewOrder`, `SecurityLevel`, `TestMode`, `HideFooter`, `RptType`, `RptName`, `RptNotes`, `URLredirect`, `RptSelect`, `SelTableName`, `SelValueColumn`, `SelDisplayColumn`, `SelWhere`, `AddLink`, `EditLink`, `AlignCenter`, `AlignRight`, `FieldSuppress`,
     `ChartSuppress`, `SortableCols`, `TotalCols`, `TotalMoneyCols`, `DaysAgo`, `StartDatePrompt`, `StartDateCol`, `EndDatePrompt`, `EndDateCol`, `GraphRpt`, `RegRpt`, `BarChart`, `LineChart`, `AreaChart`, `PieChart`)
 VALUES
(10, 80, 'N', 'N', 'An', 'User Activity', 'This shows user activity on site.  It tracks logins, page views, report views and data updates.', NULL, 'SELECT CONCAT(wu.`FirstName`, \' \', COALESCE(wu.`LastName`,\'\')) AS `User`,\r\n  L.`LookupDisplay` AS `StaffRole`,\r\n   (SELECT COUNT(L.`UID`) FROM `wtkLoginLog` L WHERE  L.`UserUID` = wu.`UID`) AS `Logins`,\r\n   COUNT(h.`UID`) AS `PageViews`,\r\n   (SELECT COUNT(r.`UID`) FROM `wtkReportCntr` r WHERE  r.`UserUID` = wu.`UID`) AS `ReportViews`,\r\n   (SELECT COUNT(u.`UID`) FROM `wtkUpdateLog` u WHERE  u.`UserUID` = wu.`UID`) AS `Updates`\r\n  FROM `wtkUsers` wu\r\n    INNER JOIN `wtkUserHistory` h ON h.`UserUID` = wu.`UID`\r\n    INNER JOIN `wtkLookups` L ON L.`LookupType` = \'StaffRole\' AND L.`LookupValue` = wu.`StaffRole`\r\n WHERE wu.`DelDate` IS NULL\nGROUP BY wu.`UID`\r\nORDER BY COUNT(h.`UID`) DESC, wu.`FirstName` ASC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PageViews, Logins, ReportViews, Updates', NULL, 'StaffRole', NULL, 'PageViews, Logins, ReportViews, Updates', NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 'Y', 'Y', NULL, 'Y', 'Y'),
(20, 80, 'N', 'N', 'An', 'Page Views by User', 'This shows how many page views and logins each user has had.', NULL, 'SELECT CONCAT(wu.`FirstName`, \' \', COALESCE(wu.`LastName`,\'\')) AS `User`,\n  COUNT(h.`UID`) AS `PageViews`,\n  (SELECT COUNT(L.`UID`) FROM `wtkLoginLog` L WHERE  L.`UserUID` = wu.`UID`) AS `Logins`\nFROM `wtkUsers` wu\n  INNER JOIN `wtkUserHistory` h ON h.`UserUID` = wu.`UID`\nWHERE wu.`DelDate` IS NULL\nGROUP BY wu.`UID`\nORDER BY COUNT(h.`UID`) DESC, wu.`FirstName` ASC', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PageViews, Logins', NULL, NULL, NULL, 'PageViews, Logins', NULL, NULL, NULL, NULL, NULL, NULL, 'Y', NULL, 'Y', 'Y', NULL, NULL),
(10, 1, 'N', 'N', 'Core', 'User Contact Information', 'Contact information for all users.', NULL, 'SELECT wu.`UID`,\r\n   CONCAT(wu.`FirstName`, \' \', COALESCE(wu.`LastName`,\'\')) AS `User`,\r\n   L.`LookupDisplay` AS `SecurityLevel`,\r\n   `fncContactIcons`(wu.`Email`, wu.`Phone`,0,0,\'Y\',wu.`UID`,wu.`SMSEnabled`,\'Y\',\'\') AS `Contact`\r\n FROM `wtkUsers` wu\r\n  LEFT OUTER JOIN `wtkLookups` L\r\n   ON L.`LookupType` = \'SecurityLevel\' AND L.`LookupValue` = wu.`SecurityLevel`\r\n WHERE wu.`DelDate` IS NULL\nORDER BY wu.`FirstName` ASC, wu.`LastName` ASC', NULL, NULL, NULL, NULL, 'userEdit', 'userEdit', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, NULL, NULL),
(20, 99, 'N', 'N', 'Core', 'User History Last Few Days', 'This is a demo for the Days Limit filter feature. It starts with showing page history for last @DaysPast@ days.', NULL, 'SELECT h.`UID`,\r\n  CONCAT(wu.`FirstName`, \' \', COALESCE(wu.`LastName`,\'\')) AS `User`,\r\n  DATE_FORMAT(h.`AddDate`,\'%c/%e/%Y at %l:%i %p\') AS `VisitDate`,\r\n  h.`PageURL`, h.`OtherUID` AS `PassedId`, h.`SecondsTaken`\r\n FROM `wtkUserHistory` h\r\nLEFT OUTER JOIN `wtkUsers` wu ON wu.`UID` = h.`UserUID`\r\nWHERE h.`AddDate` >= DATE_SUB(NOW(), INTERVAL @DaysPast@ DAY)\nORDER BY h.`UID` DESC', NULL, NULL, NULL, NULL, NULL, NULL, 'PassedId,SecondsTaken', NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, NULL, NULL),
(30, 80, 'N', 'N', 'Core', 'User History with Date Range', 'Website page history of users.', NULL, 'SELECT h.`UID`,\r\n   CONCAT(wu.`FirstName`, \' \', COALESCE(wu.`LastName`,\'\')) AS `User`,\r\n   DATE_FORMAT(h.`AddDate`,\'%c/%e/%Y at %l:%i %p\') AS `VisitDate`,\r\n   h.`PageURL`, h.`OtherUID` AS `PassedId`, h.`SecondsTaken`\r\n  FROM `wtkUserHistory` h\r\n   LEFT OUTER JOIN `wtkUsers` wu ON wu.`UID` = h.`UserUID`\r\nWHERE h.`AddDate` >= \'@StartDate@\' AND\r\n  DATE_FORMAT(h.`AddDate`,\'%Y-%m-%d\') <= \'@EndDate@\'\r\n  AND h.`UserUID` = @RptFilter@\r\nORDER BY h.`UID` DESC', 'wtkUsers', 'UID', 'FirstName', '`DelDate` IS NULL', NULL, NULL, 'PassedId,SecondsTaken', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Visit Date', NULL, 'Visit Date', NULL, 'N', NULL, NULL, NULL, NULL, NULL),
(10, 80, 'N', 'N', 'Money', 'Money Stats', 'This uses the moneyStats file as an external report as a demo that you can have any hand-coded report / page added to the report list.', '/admin/moneyStats.php', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'N', NULL, NULL, NULL, NULL, NULL),
(20, 80, 'N', 'Y', 'Money', 'Payments by Ecommerce Provider', NULL, NULL, 'SELECT\r\n CONCAT(\'<a onclick=\"JavaScript:rpt(\', 8, \',\' , e.`UID`, \')\">\', e.`PaymentProvider`,\'</a>\') AS `PaymentProvider`,\r\n  COUNT(r.`UID`) AS `Count`,\r\n    CONCAT(\'$\',FORMAT(SUM(r.`GrossAmount`),2)) AS `Amount`\r\n  FROM `wtkRevenue` r\r\n    INNER JOIN `wtkEcommerce` e ON e.`UID` = r.`EcomUID`\r\nWHERE r.`AddDate` >= \'@StartDate@\' AND\r\n  DATE_FORMAT(r.`AddDate`,\'%Y-%m-%d\') <= \'@EndDate@\'\r\nGROUP BY e.`PaymentProvider`\r\nORDER BY e.`PaymentProvider` DESC', NULL, NULL, NULL, NULL, NULL, NULL, 'Count', 'Amount', NULL, NULL, NULL, 'Count', 'Amount', NULL, 'Purchase Date', NULL, 'Purchase Date', NULL, 'N', NULL, NULL, NULL, NULL, NULL),
(30, 80, 'N', 'N', 'Money', 'Revenue List', NULL, NULL, 'SELECT r.`UID`, DATE_FORMAT(r.`AddDate`,\'%c/%e/%Y at %l:%i %p\') AS `AddDate`,\r\n    CONCAT(\'<a onclick=\"JavaScript:ajaxGo(\\\'/wtk/userEdit\\\',\',r.`UserUID`,\')\">\',\r\n       COALESCE(u.`FirstName`,\'\'), \' \', COALESCE(u.`LastName`,\'\'),\'</a><br>\',u.`Email`) AS `Buyer`,\r\n\r\n    CONCAT(\'<a class=\"btn-floating\" onclick=\"JavaScript:rpt(22,\',r.`UserUID`,\')\">\',\r\n           \'<i class=\"material-icons\">format_list_numbered</i></a>\',\r\n           \r\n           \'<a onclick=\"JavaScript:ajaxGo(\\\'/admin/userLogins\\\',0,\'\r\n               ,r.`UserUID`,\');\" class=\"btn btn-floating btn-small\">\',\r\n               \'<i class=\"material-icons\" alt=\"Click to User Logins\" title=\"Click to User Logins\">beenhere</i></a>\'\r\n       ) AS `Reports`,\r\n\r\n    CONCAT(\'<a onclick=\"JavaScript:wtkModal(\\\'/admin/ecomEdit\\\',\\\'MODAL\\\',\',r.`EcomUID`,\')\">\',\r\n       e.`PaymentProvider`,\'</a>\') AS `PaymentProvider`,\r\n    r.`PaymentStatus`,\r\n\r\n    IF (r.`CurrencyCode` = \'USD\', \'\',\r\n        CONCAT(\'<a target=\"_blank\" href=\"https://www.xe.com/currencyconverter/convert/?Amount=\',\r\n            r.`GrossAmount`,\'&From=\',r.`CurrencyCode`,\'&To=USD\">\',r.`GrossAmount`,\'</a>\')\r\n    ) AS `GrossAmount`,\r\n\r\n    r.`MerchantFee`, r.`CurrencyCode`\r\nFROM `wtkRevenue` r\r\n  INNER JOIN `wtkEcommerce` e ON e.`UID` = r.`EcomUID`\r\n  INNER JOIN `wtkUsers` u ON u.`UID` = r.`UserUID`\r\nWHERE r.`EcomUID` = @RptFilter@\r\n  AND r.`AddDate` >= \'@StartDate@\' AND\r\n  DATE_FORMAT(r.`AddDate`,\'%Y-%m-%d\') <= \'@EndDate@\'\r\nORDER BY r.`UID` DESC', 'wtkEcommerce', 'UID', 'PaymentProvider', '`DelDate` IS NULL', NULL, NULL, 'CurrencyCode', 'GrossAmount,MerchantFee', NULL, NULL, NULL, NULL, NULL, NULL, 'Purchase Date', NULL, 'Purchase Date', NULL, 'N', NULL, NULL, NULL, NULL, NULL),
(40, 80, 'N', 'Y', 'Money', 'Revenue Monthly', 'Income comparison for last 6 months', NULL, 'SELECT DATE_FORMAT(`AddDate`,\'%M\') AS `Month` ,\r\n    CONCAT(\'$\',FORMAT(SUM(`GrossAmount`),2)) AS `TotalIncome`\r\n  FROM `wtkRevenue`\r\nGROUP BY DATE_FORMAT(`AddDate`,\'%Y-%m\')\r\nORDER BY DATE_FORMAT(`AddDate`,\'%Y-%m\') DESC LIMIT 6', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'TotalIncome', NULL, NULL, NULL, NULL, 'TotalIncome', NULL, NULL, NULL, NULL, NULL, 'Y', 'Y', 'Y', 'N', 'Y', 'N'),
(50, 80, 'N', 'Y', 'Money', 'Revenue Yearly', 'Income comparison for last 5 years', NULL, 'SELECT DATE_FORMAT(`AddDate`,\'%Y\') AS `Year`,\r\n    CONCAT(\'$\',FORMAT(SUM(`GrossAmount`),2)) AS `TotalIncome`\r\n  FROM `wtkRevenue`\r\nGROUP BY DATE_FORMAT(`AddDate`,\'%Y\')\r\nORDER BY DATE_FORMAT(`AddDate`,\'%Y\') DESC LIMIT 5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'TotalIncome', NULL, NULL, NULL, NULL, 'TotalIncome', NULL, NULL, NULL, NULL, NULL, 'Y', 'Y', 'Y', NULL, 'Y', NULL);

INSERT INTO `wtkPages` (`UID`, `PageName`, `FileName`, `Path`)
  VALUES
(1, 'Settings', 'companyEdit', '/admin/'),
(2, 'Page List', 'pageList', '/admin/'),
(3, 'Menu Sets', 'menuSetList', '/admin/'),
(4, 'Login Log', 'loginLogList', '/admin/'),
(5, 'Update Logs', 'updateLogList', '/admin/'),
(6, 'Error Logs', 'errorLogList', '/admin/'),
(7, 'WTK Builder', 'wtkBuilder', '/admin/'),
(8, 'Clients', 'clientList', '/admin/'),
(9, 'Ad Tracking', 'adList', '/admin/'),
(10, 'Lookups', 'lookupList', '/admin/'),
(11, 'User History', 'userHistory', '/admin/'),
(12, 'Landing Pages', 'linkList', '/admin/'),
(13, 'Language', 'languageList', '/admin/'),
(14, 'My Profile', 'user', '/wtk/'),
(15, 'Report Wizard', 'reportList', '/admin/'),
(16, 'Users', 'userList', '/admin/'),
(17, 'Help', 'helpList', '/admin/'),
(18, 'Email Templates', 'emailTemplates', '/admin/'),
(19, 'Reports Viewer', 'reportViewer', '/wtk/'),
(20, 'Polls', 'polls', '/admin/'),
(21, 'User Edit', 'userEdit', '/wtk/'),
(22, 'Forums', 'forumList', '/wtk/'),
(23, 'Messages', 'messageList', '/wtk/'),
(24, 'Menu Groups', 'menuGroupList', '/admin/'),
(25, 'Email History', 'emailHistory', '/admin/'),
(26, 'Chats', 'chatList', '/wtk/'),
(27, 'Access Fails', 'failedAttemptList', '/admin/'),
(28, 'Broadcast List', 'broadcastList', '/admin/'),
(29, 'Widget Groups', 'widgetGroupList', '/admin/'),
(30, 'Widgets', 'widgetList', '/admin/'),
(31, 'Revenue', 'revenueList', '/admin/'),
(32, 'Feedback', 'bugList', '/admin/'),
(33, 'Visitors', 'visitorStats', '/admin/'),
(34, 'Ecom Providers', 'ecomList', '/admin/'),
(35, 'Money Stats', 'moneyStats', '/admin/'),
(36, 'Affiliates', 'affiliateList', '/admin/'),
(37, 'Prospects', 'prospectList', '/admin/'),
(38, 'Prospect Staff', 'prospectStaffList', '/admin/'),
(39, 'CSV Importer', 'pickDataTable', '/admin/');

INSERT INTO `wtkMenuSets` (`UID`, `MenuName`, `Description`)
  VALUES (1, 'WTK-Admin', 'administration of Wizards Toolkit');
INSERT INTO `wtkMenuGroups` (`UID`, `MenuUID`, `GroupName`, `GroupURL`, `Priority`)
  VALUES
(1, 1, 'Dashboard', 'dashboard', 10),
(2, 1, 'Client Control', NULL, 20),
(3, 1, 'Marketing', NULL, 30),
(4, 1, 'Site Management', NULL, 40),
(5, 1, 'View Logs', NULL, 50),
(6, 1, 'Logout', 'logout', 90);

INSERT INTO `wtkMenuItems` (`MenuGroupUID`, `Priority`, `PgUID`)
  VALUES
(2, 10, 1),
(2, 20, 8),
(2, 30, 16),
(2, 40, 34),
(2, 50, 28),
(2, 60, 18),
(2, 70, 19),
(2, 80, 31),
(3, 10, 36),
(3, 20, 37),
(3, 30, 33),
(3, 40, 35),
(4, 10, 7),
(4, 20, 15),
(4, 30, 30),
(4, 40, 29),
(4, 50, 10),
(4, 60, 2),
(4, 70, 3),
(4, 80, 17),
(4, 90, 13),
(4, 100, 39),
(5, 10, 4),
(5, 20, 11),
(5, 30, 5),
(5, 40, 6),
(5, 50, 27),
(5, 60, 25),
(5, 70, 32);

INSERT INTO `wtkHelp` (`HelpIndex`, `HelpTitle`, `HelpText`)
 VALUES
('reportEdit.php', 'SQL Report Wizard', '<h4>Filtering @Tokens@</h4>\n<p>On this page you will see which tokens can be added within your SQL SELECT or WHERE and they will be automatically replaced by data and passed parameters.</p>\n<p>For example, if you put in something like:<br>\n<code>WHERE `UserUID` = @UserUID@</code><br>\nthat will automatically replace the @UserUID@ with the currently logged in user\'s UID (wtkUsers.UID).  This can be very useful if you want to create a report that only shows a user data related to their account.</p>\n<br>\n<h4>Sorting Functionality</h4>\n<p>Each column that you want to sort should be on a separate line in the \"Sorting\" box.  This function can take 1, 2 or 3 parameters. Note, as usual spaces will be automatically be inserted for WordCaps or snake_case.  For example, \'FirstName\' will be changed to \'First Name\'.</p>\n<br>\n<h5>One Parameter</h5>\n<code>Count</code><br>\n<p>This uses column named `Count` and leaves headers as \"Count\" and sorts by this column.</p>\n<br>\n<h5>Two Parameters</h5>\n<code>LookupDisplay, USA State</code><br>\n<p>This uses column named `LookupDisplay` but shows the header as \"USA State\".  It sorts by the `LookupDisplay` column.</p>\n<br>\n<h5>Three Parameters</h5>\n<code>DOB, Birthday, u.`BirthDate`</code><br>\n<p>This uses column named `DOB` but shows the header as \"Birthday\".  It sorts using u.`BirthDate` column. This is really important when formatting causes problem with sort order.  For example if your date format is \'%b %D, %Y\' then sorting by that would not give the results you want.</p>\n<br>\n<h4>Example</h4>\n<p>Here is an example SQL query and the associated Sort Options.</p>\n<code>\nSELECT p.`UID`, u.`FirstName` AS `Owner`, p.`PetName`, p.`City`, DATE_FORMAT(p.`BirthDate`,\'%b %D, %Y\') AS `DOB`<br>\n  FROM `pets` p<br>\n   INNER JOIN `wtkUsers` u ON u.`UID` = p.`UserUID`\n</code>\n<br><br>\n<h5>Sortable Columns</h5>\n<code>\nOwner<br>\nCity, Town<br>\nDOB, Birthday, p.`BirthDate`\n</code>');


INSERT INTO `wtkLookups` (`LookupType`, `LookupValue`, `LookupDisplay`)
 VALUES
   ('SecurityLevel', '1', 'Customer'),
   ('SecurityLevel', '30', 'Staff'),
   ('SecurityLevel', '80', 'Manager'),
   ('SecurityLevel', '95', 'Owner'),
   ('SecurityLevel', '99', 'Programmer'),
   ('StaffRole', 'Mgr', 'Manager'),
   ('StaffRole', 'Emp', 'Customer Service'),
   ('StaffRole', 'Tech', 'Tech Support'),
   ('ClientStatus', 'T', 'Trial'),
   ('ClientStatus', 'A', 'Active'),
   ('ClientStatus', 'I', 'Inactive'),
   ('FailCode','SQL','SQL Injection'),
   ('FailCode','Hash','PW Reset'),
   ('FailCode','DDOS','DDOS Attack?'),
   ('FailCode','Hack','Hacker Attempt'),
   ('PagePath', '/wtk/', 'WTK'),
   ('PagePath', '/admin/', 'Admin'),
   ('PagePath', NULL, 'Root'),
   ('RptType', 'An', 'Analytics'),
   ('RptType', 'Core', 'Core Info'),
   ('RptType', 'Money', 'Financials'),
   ('SelTableName', 'wtkUsers', 'wtkUsers'),
   ('SelTableName', 'wtkLookups', 'wtkLookups'),
   ('SelTableName', 'wtkEcommerce', 'wtkEcommerce'),
   ('SelValueColumn', 'UID', 'UID'),
   ('SelValueColumn', 'LookupValue', 'LookupValue'),
   ('YesNoUnknown', 'U', 'Unknown'),
   ('YesNoUnknown', 'Y', 'Yes'),
   ('YesNoUnknown', 'N', 'No'),
   ('Currency', 'USD', 'USD $'),
   ('Currency', 'MXN', 'Mexican Pesos'),
   ('LangPref', 'eng', 'English'),
   ('LangPref', 'esp', 'Espa&ntilde;ol'),
   ('emFreq', 'N', 'Never'),
   ('emFreq', 'M', 'Monthly'),
   ('emFreq', 'W', 'Weekly'),
   ('emFreq', 'D', 'Once Daily'),
   ('EmailType', 'A', 'Everyone'),
   ('EmailType', 'Af', 'Affiliate'),
   ('EmailType', 'P', 'Prospect'),
   ('EmailType', 'C', 'Customer'),
   ('EmailType', 'S', 'Staff'),
   ('EmailHTM', 'emailLight', 'emailLight'),
   ('EmailHTM', 'emailDark', 'emailDark'),
   ('AudienceType', 'All', 'All'),
   ('AudienceType', 'Cust', 'Customer'),
   ('AudienceType', 'Staf', 'Staff'),
   ('BroadcastColor', 'green', 'Green'),
   ('BroadcastColor', 'blue', 'Blue'),
   ('BroadcastColor', 'blue-grey', 'Blue-Grey'),
   ('BroadcastColor', 'deep-purple darken-1', 'Purple'),
   ('BroadcastColor', 'yellow', 'Yellow'),
   ('BroadcastColor', 'orange', 'Orange'),
   ('BroadcastColor', 'pink accent-1', 'Pink'),
   ('BroadcastColor', 'red darken-3', 'Red'),
   ('TextColor', '', 'Black'),
   ('TextColor', 'white-text', 'White'),
   ('TextColor', 'blue-text', 'Blue'),
   ('TextColor', 'red-text', 'Red'),
   ('USAstate', 'AL', 'Alabama'),
   ('USAstate', 'AK', 'Alaska'),
   ('USAstate', 'AZ', 'Arizona'),
   ('USAstate', 'AR', 'Arkansas'),
   ('USAstate', 'CA', 'California'),
   ('USAstate', 'CO', 'Colorado'),
   ('USAstate', 'CT', 'Connecticut'),
   ('USAstate', 'DE', 'Delaware'),
   ('USAstate', 'FL', 'Florida'),
   ('USAstate', 'GA', 'Georgia'),
   ('USAstate', 'HI', 'Hawaii'),
   ('USAstate', 'ID', 'Idaho'),
   ('USAstate', 'IL', 'Illinois'),
   ('USAstate', 'IN', 'Indiana'),
   ('USAstate', 'IA', 'Iowa'),
   ('USAstate', 'KS', 'Kansas'),
   ('USAstate', 'KY', 'Kentucky'),
   ('USAstate', 'LA', 'Louisiana'),
   ('USAstate', 'ME', 'Maine'),
   ('USAstate', 'MD', 'Maryland'),
   ('USAstate', 'MA', 'Massachusetts'),
   ('USAstate', 'MI', 'Michigan'),
   ('USAstate', 'MN', 'Minnesota'),
   ('USAstate', 'MS', 'Mississippi'),
   ('USAstate', 'MO', 'Missouri'),
   ('USAstate', 'MT', 'Montana'),
   ('USAstate', 'NE', 'Nebraska'),
   ('USAstate', 'NV', 'Nevada'),
   ('USAstate', 'NH', 'New Hampshire'),
   ('USAstate', 'NJ', 'New Jersey'),
   ('USAstate', 'NM', 'New Mexico'),
   ('USAstate', 'NY', 'New York'),
   ('USAstate', 'NC', 'North Carolina'),
   ('USAstate', 'ND', 'North Dakota'),
   ('USAstate', 'OH', 'Ohio'),
   ('USAstate', 'OK', 'Oklahoma'),
   ('USAstate', 'OR', 'Oregon'),
   ('USAstate', 'PA', 'Pennsylvania'),
   ('USAstate', 'RI', 'Rhode Island'),
   ('USAstate', 'SC', 'South Carolina'),
   ('USAstate', 'SD', 'South Dakota'),
   ('USAstate', 'TN', 'Tennessee'),
   ('USAstate', 'TX', 'Texas'),
   ('USAstate', 'UT', 'Utah'),
   ('USAstate', 'VT', 'Vermont'),
   ('USAstate', 'VA', 'Virginia'),
   ('USAstate', 'WA', 'Washington'),
   ('USAstate', 'WV', 'West Virginia'),
   ('USAstate', 'WI', 'Wisconsin'),
   ('USAstate', 'WY', 'Wyoming'),
   ('Canada', 'AB', 'Alberta'),
   ('Canada', 'BC', 'British Columbia'),
   ('Canada', 'MB', 'Manitoba'),
   ('Canada', 'NB', 'New Brunswick'),
   ('Canada', 'NL', 'Newfoundland and Labrador'),
   ('Canada', 'NT', 'Northwest Territories'),
   ('Canada', 'NS', 'Nova Scotia'),
   ('Canada', 'NU', 'Nunavut'),
   ('Canada', 'ON', 'Ontario'),
   ('Canada', 'PE', 'Prince Edward Island'),
   ('Canada', 'QC', 'Quebec'),
   ('Canada', 'SK', 'Saskatchewan'),
   ('Canada', 'YT', 'Yukon'),
   ('Country','AF','Afghanistan'),
   ('Country','AX','Aland Islands'),
   ('Country','AL','Albania'),
   ('Country','DZ','Algeria'),
   ('Country','AS','American Samoa'),
   ('Country','AD','Andorra'),
   ('Country','AO','Angola'),
   ('Country','AI','Anguilla'),
   ('Country','AQ','Antarctica'),
   ('Country','AG','Antigua and Barbuda'),
   ('Country','AR','Argentina'),
   ('Country','AM','Armenia'),
   ('Country','AW','Aruba'),
   ('Country','AU','Australia'),
   ('Country','AT','Austria'),
   ('Country','AZ','Azerbaijan'),
   ('Country','BS','Bahamas'),
   ('Country','BH','Bahrain'),
   ('Country','BD','Bangladesh'),
   ('Country','BB','Barbados'),
   ('Country','BY','Belarus'),
   ('Country','BE','Belgium'),
   ('Country','BZ','Belize'),
   ('Country','BJ','Benin'),
   ('Country','BM','Bermuda'),
   ('Country','BT','Bhutan'),
   ('Country','BO','Bolivia'),
   ('Country','BA','Bosnia and Herzegovina'),
   ('Country','BW','Botswana'),
   ('Country','BV','Bouvet Island'),
   ('Country','BR','Brazil'),
   ('Country','IO','British Indian Ocean Territory'),
   ('Country','BN','Brunei Darussalam'),
   ('Country','BG','Bulgaria'),
   ('Country','BF','Burkina Faso'),
   ('Country','BI','Burundi'),
   ('Country','KH','Cambodia'),
   ('Country','CM','Cameroon'),
   ('Country','CA','Canada'),
   ('Country','CV','Cape Verde'),
   ('Country','KY','Cayman Islands'),
   ('Country','CF','Central African Republic'),
   ('Country','TD','Chad'),
   ('Country','CL','Chile'),
   ('Country','CN','China'),
   ('Country','CX','Christmas Island'),
   ('Country','C','Cocos (Keeling) Islands'),
   ('Country','CO','Colombia'),
   ('Country','KM','Comoros'),
   ('Country','CG','Congo'),
   ('Country','CD','Congo, Democratic Republic of the'),
   ('Country','CK','Cook Islands'),
   ('Country','CR','Costa Rica'),
   ('Country','CI','Cote D`ivoire'),
   ('Country','HR','Croatia'),
   ('Country','CU','Cuba'),
   ('Country','CY','Cyprus'),
   ('Country','CZ','Czech Republic'),
   ('Country','DK','Denmark'),
   ('Country','DJ','Djibouti'),
   ('Country','DM','Dominica'),
   ('Country','DO','Dominican Republic'),
   ('Country','EC','Ecuador'),
   ('Country','EG','Egypt'),
   ('Country','SV','El Salvador'),
   ('Country','GQ','Equatorial Guinea'),
   ('Country','ER','Eritrea'),
   ('Country','EE','Estonia'),
   ('Country','ET','Ethiopia'),
   ('Country','K','Falkland Islands (Malvinas):'),
   ('Country','FO','Faroe Islands'),
   ('Country','FJ','Fiji'),
   ('Country','FI','Finland'),
   ('Country','FR','France'),
   ('Country','GF','French Guiana'),
   ('Country','PF','French Polynesia'),
   ('Country','TF','French Southern Territories'),
   ('Country','GA','Gabon'),
   ('Country','GM','Gambia'),
   ('Country','GE','Georgia'),
   ('Country','DE','Germany'),
   ('Country','GH','Ghana'),
   ('Country','GI','Gibraltar'),
   ('Country','GR','Greece'),
   ('Country','GL','Greenland'),
   ('Country','GD','Grenada'),
   ('Country','GP','Guadeloupe'),
   ('Country','GU','Guam'),
   ('Country','GT','Guatemala'),
   ('Country','GG','Guernsey'),
   ('Country','GN','Guinea'),
   ('Country','GW','Guinea-Bissau'),
   ('Country','GY','Guyana'),
   ('Country','HT','Haiti'),
   ('Country','HM','Heard Island and Mcdonald Islands'),
   ('Country','A','Holy See (Vatican City State):'),
   ('Country','HN','Honduras'),
   ('Country','HK','Hong Kong'),
   ('Country','HU','Hungary'),
   ('Country','IS','Iceland'),
   ('Country','IN','India'),
   ('Country','ID','Indonesia'),
   ('Country','IR','Iran'),
   ('Country','IQ','Iraq'),
   ('Country','IE','Ireland'),
   ('Country','IM','Isle of Man'),
   ('Country','IL','Israel'),
   ('Country','IT','Italy'),
   ('Country','JM','Jamaica'),
   ('Country','JP','Japan'),
   ('Country','JE','Jersey'),
   ('Country','JO','Jordan'),
   ('Country','KZ','Kazakhstan'),
   ('Country','KE','Kenya'),
   ('Country','KI','Kiribati'),
   ('Country','KP','Korea, Democratic Peoples Republic of'),
   ('Country','KR','Korea, Republic of'),
   ('Country','KW','Kuwait'),
   ('Country','KG','Kyrgyzstan'),
   ('Country','LA','Lao Peoples Democratic Republic'),
   ('Country','LV','Latvia'),
   ('Country','LB','Lebanon'),
   ('Country','LS','Lesotho'),
   ('Country','LR','Liberia'),
   ('Country','LY','Libyan Arab Jamahiriya'),
   ('Country','LI','Liechtenstein'),
   ('Country','LT','Lithuania'),
   ('Country','LU','Luxembourg'),
   ('Country','MO','Macao'),
   ('Country','MK','Macedonia, The Former Yugoslav Republic of'),
   ('Country','MG','Madagascar'),
   ('Country','MW','Malawi'),
   ('Country','MY','Malaysia'),
   ('Country','MV','Maldives'),
   ('Country','ML','Mali'),
   ('Country','MT','Malta'),
   ('Country','MH','Marshall Islands'),
   ('Country','MQ','Martinique'),
   ('Country','MR','Mauritania'),
   ('Country','MU','Mauritius'),
   ('Country','YT','Mayotte'),
   ('Country','MX','Mexico'),
   ('Country','FM','Micronesia, Federated States of'),
   ('Country','MD','Moldova, Republic of'),
   ('Country','MC','Monaco'),
   ('Country','MN','Mongolia'),
   ('Country','ME','Montenegro'),
   ('Country','MS','Montserrat'),
   ('Country','MA','Morocco'),
   ('Country','MZ','Mozambique'),
   ('Country','MM','Myanmar'),
   ('Country','NA','Namibia'),
   ('Country','NR','Nauru'),
   ('Country','NP','Nepal'),
   ('Country','NL','Netherlands'),
   ('Country','AN','Netherlands Antilles'),
   ('Country','NC','New Caledonia'),
   ('Country','NZ','New Zealand'),
   ('Country','NI','Nicaragua'),
   ('Country','NE','Niger'),
   ('Country','NG','Nigeria'),
   ('Country','NU','Niue'),
   ('Country','NF','Norfolk Island'),
   ('Country','MP','Northern Mariana Islands'),
   ('Country','NO','Norway'),
   ('Country','OM','Oman'),
   ('Country','PK','Pakistan'),
   ('Country','PW','Palau'),
   ('Country','PS','Palestinian Territory, Occupied'),
   ('Country','PA','Panama'),
   ('Country','PG','Papua New Guinea'),
   ('Country','PY','Paraguay'),
   ('Country','PE','Peru'),
   ('Country','PH','Philippines'),
   ('Country','PN','Pitcairn'),
   ('Country','PL','Poland'),
   ('Country','PT','Portugal'),
   ('Country','PR','Puerto Rico'),
   ('Country','QA','Qatar'),
   ('Country','RE','Reunion'),
   ('Country','RO','Romania'),
   ('Country','RU','Russian Federation'),
   ('Country','RW','Rwanda'),
   ('Country','BL','Saint Barthelemy'),
   ('Country','SH','Saint Helena'),
   ('Country','KN','Saint Kitts and Nevis'),
   ('Country','LC','Saint Lucia'),
   ('Country','MF','Saint Martin'),
   ('Country','PM','Saint Pierre and Miquelon'),
   ('Country','VC','Saint Vincent and the Grenadines'),
   ('Country','WS','Samoa'),
   ('Country','SM','San Marino'),
   ('Country','ST','Sao Tome and Principe'),
   ('Country','SA','Saudi Arabia'),
   ('Country','SN','Senegal'),
   ('Country','RS','Serbia'),
   ('Country','SC','Seychelles'),
   ('Country','SL','Sierra Leone'),
   ('Country','SG','Singapore'),
   ('Country','SK','Slovakia'),
   ('Country','SI','Slovenia'),
   ('Country','SB','Solomon Islands'),
   ('Country','SO','Somalia'),
   ('Country','ZA','South Africa'),
   ('Country','GS','South Georgia and South Sandwich Islands'),
   ('Country','ES','Spain'),
   ('Country','LK','Sri Lanka'),
   ('Country','SD','Sudan'),
   ('Country','SR','Suriname'),
   ('Country','SJ','Svalbard and Jan Mayen'),
   ('Country','SZ','Swaziland'),
   ('Country','SE','Sweden'),
   ('Country','CH','Switzerland'),
   ('Country','SY','Syrian Arab Republic'),
   ('Country','TW','Taiwan'),
   ('Country','TJ','Tajikistan'),
   ('Country','TZ','Tanzania, United Republic of'),
   ('Country','TH','Thailand'),
   ('Country','TL','Timor-Leste'),
   ('Country','TG','Togo'),
   ('Country','TK','Tokelau'),
   ('Country','TO','Tonga'),
   ('Country','TT','Trinidad and Tobago'),
   ('Country','TN','Tunisia'),
   ('Country','TR','Turkey'),
   ('Country','TM','Turkmenistan'),
   ('Country','TC','Turks and Caicos Islands'),
   ('Country','TV','Tuvalu'),
   ('Country','UG','Uganda'),
   ('Country','UA','Ukraine'),
   ('Country','AE','United Arab Emirates'),
   ('Country','GB','United Kingdom'),
   ('Country','US','United States'),
   ('Country','UM','United States Minor Outlying Islands'),
   ('Country','UY','Uruguay'),
   ('Country','UZ','Uzbekistan'),
   ('Country','VU','Vanuatu'),
   ('Country','VE','Venezuela'),
   ('Country','VN','Viet Nam'),
   ('Country','VG','Virgin Islands, British'),
   ('Country','VI','Virgin Islands, U.S.'),
   ('Country','WF','Wallis and Futuna'),
   ('Country','EH','Western Sahara'),
   ('Country','YE','Yemen'),
   ('Country','ZM','Zambia'),
   ('Country','ZW','Zimbabwe'),
   ('WidgetType','Count','Count'),
   ('WidgetType','Chart','Chart'),
   ('WidgetType','List','List'),
   ('WidgetType','Link','Link'),
   ('WidgetColor','info-gradient','Blue Gradient'),
   ('WidgetColor','success-gradient','Green Gradient'),
   ('WidgetColor','warning-gradient','Orange Gradient'),
   ('WidgetColor','red-gradient','Red Gradient'),
   ('WidgetColor','danger-gradient','Purple-Pink Gradient'),
   ('ChartType','Line','Line'),
   ('ChartType','Area','Area'),
   ('ChartType','Pie','Pie'),
   ('ChartType','Bar','Bar'),
   ('ChartType','All','All'),
   ('ProspectStatus', 'new', 'Not contacted'),
   ('ProspectStatus', 'email', 'Emailed'),
   ('ProspectStatus', 'reply', 'Replied'),
   ('ProspectStatus', 'close', 'Closed'),
   ('ProspectStatus', 'sold', 'Client');

INSERT INTO `wtkLanguage` (`Language`, `PrimaryText`, `NewText`, `MassUpdateId`)
VALUES
('eng', 'main template', 'Is there a problem with our app?<br>Or do you have ideas on how to make it better?', 'BugLabel'),
('esp', 'Is there a problem with our app? Or do you have ideas on how to make it better?', '¿Hay algún problema con nuestra aplicaci&oacute;n? ¿O tienes ideas sobre c&oacute;mo mejorarlo?', 'BugLabel'),
('hin', 'Is there a problem with our app?<br>Or do you have ideas on how to make it better?', 'क्या हमारे ऐप में कोई समस्या है?<br>या क्या आपके पास इसे बेहतर बनाने के बारे में कोई विचार है?', 'BugLabel'),
('eng', 'main template', 'Problem? Idea?', 'BugRpt'),
('esp', 'Problem? Idea?', '¿Algún problema?¿Tienes alguna soluci&oacute;n?', 'BugRpt'),
('hin', 'Problem? Idea?', 'मुसीबत? विचार?', 'BugRpt'),
('eng', 'main template', 'Message Delivered', 'BugSent'),
('esp', 'Message Delivered', 'Mensaje Enviado', 'BugSent'),
('hin', 'Message Delivered', 'संदेश दिया', 'BugSent'),
('eng', 'main template', 'Thank you for your feedback.<br>Your message has been sent to tech support.', 'BugThanks'),
('esp', 'Thank you for your feedback.<br>Your message has been sent to tech support.', 'Gracias por sus comentarios.<br>Su mensaje ha sido enviado al soporte t&eacute;cnico.', 'BugThanks'),
('hin', 'Thank you for your feedback.<br>Your message has been sent to tech support.', 'आपके फ़ीडबैक के लिए धन्यवाद।<br>आपका संदेश तकनीकी सहायता को भेज दिया गया है।', 'BugThanks'),
('eng', 'main template', 'See you later!', 'Bye'),
('esp', 'See you later!', '¡Hasta Luego!', 'Bye'),
('hin', 'See you later!', 'बाद में मिलते है!', 'Bye'),
('eng', 'main template', 'Close', 'Close'),
('esp', 'close', 'Cerrar', 'Close'),
('hin', 'Close', 'बंद करे', 'Close'),
('eng', 'main template', 'Create Account', 'CreateAcct'),
('esp', 'Create Account', 'Crear Cuenta', 'CreateAcct'),
('hin', 'Create Account', 'खाता बनाएं', 'CreateAcct'),
('eng', 'main template', 'Email', 'Email'),
('esp', 'Email', 'Email', 'Email'),
('hin', 'Email', 'ईमेल', 'Email'),
('eng', 'main template', 'An email has been sent with a link to reset your password.', 'EmailMsg'),
('esp', 'An email has been sent with a link to reset your password.', 'Se ha enviado un correo electr&oacute;nico con un enlace para restablecer su contrase&ntilde;a.', 'EmailMsg'),
('hin', 'An email has been sent with a link to reset your password.', 'आपका पासवर्ड रीसेट करने के लिए एक लिंक के साथ एक ईमेल भेजा गया है।', 'EmailMsg'),
('eng', 'main template', 'Email Sent', 'EmailSent'),
('esp', 'Email Sent', 'Email enviado', 'EmailSent'),
('hin', 'Email Sent', 'ईमेल भेजा', 'EmailSent'),
('eng', 'main template', 'First Name', 'FN'),
('esp', 'First Name', 'Primer Nombre', 'FN'),
('hin', 'First Name', 'पहला नाम', 'FN'),
('eng', 'main template', 'Enter email address you have on file with us and we will<br>send you a link where you can reset your password.', 'ForgotMsg'),
('esp', 'main template', 'Plantilla principal', 'ForgotMsg'),
('hin', 'main template', 'मुख्य टेम्पलेट', 'ForgotMsg'),
('eng', 'main template', 'Forgot password?', 'ForgotPW'),
('esp', 'Forgot password?', '¿Has olvidado la contrase&ntilde;a?', 'ForgotPW'),
('hin', 'Forgot password?', 'पासवर्ड भूल गए?', 'ForgotPW'),
('eng', 'main template', 'Return Home', 'GoHome'),
('esp', 'Return Home', 'Regresar a Pantalla Inicial', 'GoHome'),
('hin', 'Return Home', 'घर लौटना', 'GoHome'),
('eng', 'main template', 'Have an account?', 'HaveAcct'),
('esp', 'Have an account?', '¿Tiene una cuenta?', 'HaveAcct'),
('hin', 'Have an account?', 'खाता होना?', 'HaveAcct'),
('eng', 'main template', 'Last Name', 'LN'),
('esp', 'Last Name', 'Apellido(s)', 'LN'),
('hin', 'Last Name', 'अंतिम नाम', 'LN'),
('eng', 'main template', 'Login', 'Login'),
('esp', 'Login', 'Accesar', 'Login'),
('hin', 'Login', 'लॉग इन करें', 'Login'),
('eng', 'main template', 'Password', 'PW'),
('esp', 'Password', 'Contrase&ntilde;a', 'PW'),
('hin', 'Password', 'कुंजिका', 'PW'),
('eng', 'main template', 'Remember Me', 'Remember'),
('esp', 'Remember Me', 'Recordarme', 'Remember'),
('hin', 'Remember Me', 'मुझे याद रखें', 'Remember'),
('eng', 'main template', 'Remembered your password?', 'RememberPW'),
('esp', 'Remembered your password?', '¿Recordar contrase&ntilde;a?', 'RememberPW'),
('hin', 'Remembered your password?', 'अपना पासवर्ड याद है?', 'RememberPW'),
('eng', 'main template', 'Retype Password', 'RetypePW'),
('esp', 'Retype Password', 'Reescribir la contrase&ntilde;a', 'RetypePW'),
('hin', 'Retype Password', 'पासवर्ड फिर से लिखें', 'RetypePW'),
('eng', 'main template', 'Save', 'Save'),
('esp', 'Save', 'Guardar', 'Save'),
('hin', 'Save', 'सहेजें', 'Save'),
('eng', 'main template', 'Send', 'Send'),
('esp', 'Send', 'Enviado', 'Send'),
('hin', 'Send', 'भेजना', 'Send'),
('eng', 'main template', 'Welcome', 'Welcome'),
('esp', 'Welcome', 'Bienvenido', 'Welcome'),
('hin', 'Welcome', 'स्वागत', 'Welcome'),
('esp', '4 digit year', '4 D&iacute;gitos del a&ntilde;o', NULL),
('esp', 'Account', 'Cuenta', NULL),
('esp', 'Account Activated', 'Cuenta Activada', NULL),
('esp', 'Account Features', 'Beneficios de la Cuenta', NULL),
('esp', 'Account Type', 'Tipo de Cuenta', NULL),
('esp', 'Add Skill', 'Agregar Otra Habilidad', NULL),
('esp', 'Additional Notes', 'Notas adicionales', NULL),
('esp', 'Age Range', 'Rango de Edades', NULL),
('esp', 'Agreement', 'Acuerdo', NULL),
('esp', 'App Version', 'Versi&oacute;n de la Aplicaci&oacute;n', NULL),
('esp', 'Applicants', 'Interesados', NULL),
('esp', 'Application', 'Solicitud', NULL),
('esp', 'Applications', 'Solicitudes', NULL),
('esp', 'Based on Device Type', 'Basado en el tipo de dispositivo', NULL),
('esp', 'Based on Operating System', 'Basado en el Sistema Operativo', NULL),
('esp', 'Birth Month', 'Mes de nacimiento', NULL),
('esp', 'Browser', 'Navegador', NULL),
('esp', 'Browsers Used', 'Navegadores utilizados', NULL),
('esp', 'Cancel', 'Cancelar', NULL),
('esp', 'Cell Phone', 'Tel&eacute;fono Celular', NULL),
('esp', 'Changed', 'Cambiado', NULL),
('esp', 'City', 'Ciudad', NULL),
('esp', 'Clear', 'Borrar', NULL),
('esp', 'Clear All', 'Borrar Todo', NULL),
('esp', 'Click here to join us', 'Haz clik aqui para unirse con nosotros', NULL),
('esp', 'Click here to login', 'Haz clik aqui para entrar a su cuenta', NULL),
('esp', 'Click here to logout', 'Haz clik aqui para salir', NULL),
('esp', 'Click here to view talent', 'Haz clik aqui para ver al  talento', NULL),
('esp', 'Click here to view your account', 'Haz clik aqui para ver a su cuenta', NULL),
('esp', 'Company Name', 'Nombre de la Compa&ntilde;&iacute;a', NULL),
('esp', 'Convert To', 'Convertir a', NULL),
('esp', 'Country', 'Pa&iacute;s', NULL),
('esp', 'Country of Origin', 'Pais de origen', NULL),
('esp', 'Create  Group', 'Crear Grupo', NULL),
('esp', 'Create QR Code', 'Crear C&oacute;digo QR', NULL),
('esp', 'Current Subscription', 'Cuenta Actual', NULL),
('esp', 'Device Type', 'Tipo de Dispositivo', NULL),
('esp', 'Display', 'Pantalla', NULL),
('esp', 'Domain', 'Dominio', NULL),
('esp', 'Domain Analytics', 'Anal&iacute;tica de Dominio', NULL),
('esp', 'Domain Name', 'Nombre del Dominio', NULL),
('esp', 'Edit Profile', 'Editar Perfil', NULL),
('esp', 'Email address or password is invalid', 'La direcci&oacute;n de correo o la contrase&ntilde;a es inválido', NULL),
('esp', 'Enable Lockout', 'Habilitar Bloqueo', NULL),
('esp', 'English', 'Ingl&eacute;s', NULL),
('esp', 'Expire', 'Vencimiento', NULL),
('esp', 'Expire on Date', 'Fecha de Vencimiento', NULL),
('esp', 'Eye Color', 'Color de Ojos', NULL),
('esp', 'Facebook: No Account', 'Facebook: No Tengo Cuenta', NULL),
('esp', 'Female', 'Mujer', NULL),
('esp', 'From Domain', 'Desde Dominio', NULL),
('esp', 'Full Access', 'Acceso Completo', NULL),
('esp', 'Gender', 'G&eacute;nero', NULL),
('esp', 'Hair Color', 'Color de Cabello', NULL),
('esp', 'Height', 'Estatura', NULL),
('esp', 'Home', 'Inicio', NULL),
('esp', 'Home Phone', 'Tel&eacute;fono de casa', NULL),
('esp', 'I would like to create a', 'Me gustaria crear una', NULL),
('esp', 'Imperial (feet, inches and pounds)', 'Imperial (pies, pulgadas y libras)', NULL),
('esp', 'in centimeters', 'en centimetros', NULL),
('esp', 'in kilos', 'en kilos', NULL),
('esp', 'Industry', 'Industria', NULL),
('esp', 'Introducing', 'Presentando', NULL),
('esp', 'IP Address', 'Direcci&oacute;n IP', NULL),
('esp', 'Language Preference', 'Lenguaje Preferencial', NULL),
('esp', 'Languages', 'Idiomas', NULL),
('esp', 'Last Visit Date', 'Dato de ultima visita', NULL),
('esp', 'Link Name', 'Nombre del Link', NULL),
('esp', 'List', 'Lista', NULL),
('esp', 'Log In', 'Entrar a su Cuenta', NULL),
('esp', 'Login', 'Entrar', NULL),
('esp', 'Login/Email', 'Entrar/Correo electr&oacute;nico', NULL),
('esp', 'Logout', 'Salir', NULL),
('esp', 'Lookup Type', 'Tipo de Búsqueda', NULL),
('esp', 'Male', 'Hombre', NULL),
('esp', 'Manage Photos', 'Administrar Fotos', NULL),
('esp', 'Measurement Preference', 'Preferencia de Sistema de Medidas', NULL),
('esp', 'Message to Show', 'Mensaje a mostrar', NULL),
('esp', 'My', 'Mi', NULL),
('esp', 'My Account', 'Mi Cuenta', NULL),
('esp', 'My Profile', 'Mi Perfil', NULL),
('esp', 'My Projects', 'Mis Proyectos', NULL),
('esp', 'My Role', 'Mi Rol', NULL),
('esp', 'Name', 'Nombre', NULL),
('esp', 'No', 'No', NULL),
('esp', 'No Data to Retrieve', 'No hay datos por Recuperar', NULL),
('esp', 'no photos', 'sin fotos', NULL),
('esp', 'No Preference', 'Ninguna Preferencia', NULL),
('esp', 'Operating System', 'Sistema Operativo', NULL),
('esp', 'Other Language', 'Otro Idioma', NULL),
('esp', 'Password for Access', 'Contrase&ntilde;a para el acceso', NULL),
('esp', 'Password Instructions', 'Instrucciones de Contrase&ntilde;as', NULL),
('esp', 'Pay Pal Email', 'Correo de PayPal', NULL),
('esp', 'Personal Data', 'Datos Personales', NULL),
('esp', 'Phone', 'Celular', NULL),
('esp', 'Phone OS', 'Celular OS', NULL),
('esp', 'Photos', 'Fotos', NULL),
('esp', 'Plan', 'Plan', NULL),
('esp', 'Please check with your Administrator regarding increasing your security access', 'Favor de consultar con su Administrador respecto a mejorar el nivel de su aceso de seguridad.', NULL),
('esp', 'Position Filled', 'Posici&oacute;n llena', NULL),
('esp', 'Premium Features', 'Caracter&iacute;sticas Premium', NULL),
('esp', 'Pricing', 'Precios', NULL),
('esp', 'Pro Subscription Options', 'Opciones de Cuentas Profesionales', NULL),
('esp', 'Pro Tools', 'Herramientas Profesionales', NULL),
('esp', 'Profile', 'Perfil', NULL),
('esp', 'Project', 'Proyecto', NULL),
('esp', 'Project Date', 'Fecha del Proyecto', NULL),
('esp', 'Project Title', 'Nombre del Proyecto', NULL),
('esp', 'Race', 'Raza/Ascendencia', NULL),
('esp', 'Register', 'Incribirse', NULL),
('esp', 'remove', 'eliminar', NULL),
('esp', 'Requested', 'Pedido', NULL),
('esp', 'Required Skill', 'Habilidad Requerida', NULL),
('esp', 'Reset', 'Reestablecer', NULL),
('esp', 'Reset Requested', 'Reinicio Pedido', NULL),
('esp', 'Return', 'Regresar', NULL),
('esp', 'Save Changes', 'Guardar Cambios', NULL),
('esp', 'Saving Error', 'Error de Guardar', NULL),
('esp', 'Search', 'Buscar', NULL),
('esp', 'Secondary Link', 'Link Secundario', NULL),
('esp', 'Sign Up', 'Inscribirse', NULL),
('esp', 'Silver', 'Plata', NULL),
('esp', 'Skills', 'Habilidades', NULL),
('esp', 'Social Network', 'Redes Sociales', NULL),
('esp', 'soon', 'proximamente', NULL),
('esp', 'Spanish Display', 'Pantalla en Espa&ntilde;ol', NULL),
('esp', 'Special Notes', 'Notas Especiales', NULL),
('esp', 'Specials', 'Ofertas', NULL),
('esp', 'State', 'Estado', NULL),
('esp', 'Subscription Type', 'Tipo de Cuenta', NULL),
('esp', 'Testing', 'Pruebas', NULL),
('esp', 'Total Visits', 'Total de Visitas', NULL),
('esp', 'Twitter', 'Twitter', NULL),
('esp', 'Twitter: no account', 'Twitter: No tengo cuenta', NULL),
('esp', 'Types', 'Tipos', NULL),
('esp', 'Upgrade', 'Mejorar', NULL),
('esp', 'Upgrade Account', 'Subir Cuenta', NULL),
('esp', 'Upload video', 'Subir Video', NULL),
('esp', 'Use Password', 'Usar Contrase&ntilde;a', NULL),
('esp', 'Use Skype for calls', 'Usar Skype para llamadas', NULL),
('esp', 'User Note', 'Nota para el Usuario', NULL),
('esp', 'User Photo', 'Foto del Usuario', NULL),
('esp', 'Value', 'Valor', NULL),
('esp', 'Visit Date', 'Dato de Visitante', NULL),
('esp', 'Web Password', 'Contrase&ntilde;a de la WEB', NULL),
('esp', 'Weight', 'Peso', NULL),
('esp', 'Weight range', 'Rango de Peso', NULL),
('esp', 'Which Takes Priority?', '¿Cuál tiene Prioridad?', NULL),
('esp', 'You data has been saved', 'Tus datos han sido guardados', NULL),
('esp', 'Your Link', 'Tu Link', NULL),
('hin', 'Browser', 'ब्राउज़र', NULL),
('hin', 'Browsers Used', 'उपयोग किए गए ब्राउज़र', NULL),
('hin', 'Cancel', 'रद्द करें', NULL),
('hin', 'Cancel', 'रद्द करें', NULL),
('hin', 'Cell Phone', 'सेलफोन', NULL),
('hin', 'Convert To', 'में बदलो', NULL),
('hin', 'Create QR Code', 'क्यूआर कोड बनाएं', NULL),
('hin', 'Device Type', 'उपकरण का प्रकार', NULL),
('hin', 'Domain', 'कार्यक्षेत्र', NULL),
('hin', 'Edit Profile', 'प्रोफ़ाइल संपादित करें', NULL),
('hin', 'Email address does not exist in our system', 'ईमेल पता हमारे सिस्टम में मौजूद नहीं है', NULL),
('hin', 'Email address or password is invalid', 'ईमेल पता या पासवर्ड अमान्य है', NULL),
('hin', 'English', 'अंग्रेज़ी', NULL),
('hin', 'Expire', 'समय सीमा समाप्त', NULL),
('hin', 'Expire on Date', 'दिनांक को समाप्त', NULL),
('hin', 'From Domain', 'डोमेन से', NULL),
('hin', 'IP Address', 'ए / बी परीक्षण', NULL),
('hin', 'Language Preference', 'भाषा वरीयता', NULL),
('hin', 'Last Visit Date', 'अंतिम मुलाकात की तारीख', NULL),
('hin', 'Message to Show', 'दिखाने के लिए संदेश', NULL),
('hin', 'Operating System', 'ऑपरेटिंग सिस्टम', NULL),
('hin', 'Other Language', 'अन्य भाषा', NULL),
('hin', 'Password for Access', 'एक्सेस के लिए पासवर्ड', NULL),
('hin', 'Password Instructions', 'पासवर्ड निर्देश', NULL),
('hin', 'Phone', 'फ़ोन', NULL),
('hin', 'Plan', 'योजना', NULL),
('hin', 'Premium Features', 'प्रीमियम विशेषताएं', NULL),
('hin', 'Referer', 'संदर्भित', NULL),
('hin', 'Report Name', 'रिपोर्ट का नाम', NULL),
('hin', 'Save Changes', 'परिवर्तनों को सुरक्षित करें', NULL),
('hin', 'Spanish', 'स्पेनिश', NULL),
('hin', 'That email account does not exist on our site', 'वह ईमेल खाता हमारे साइट पर मौजूद नहीं है', NULL),
('hin', 'Total Visits', 'कुल विज़िट', NULL),
('hin', 'Use Password', 'पासवर्ड का प्रयोग करें', NULL),
('hin', 'Use Skype for calls', 'कॉल के लिए स्काइप का उपयोग करें', NULL),
('hin', 'User Photo', 'उपयोगकर्ता फोटो', NULL),
('hin', 'Visit Count', 'गिनती पर जाएँ', NULL),
('hin', 'Visit Counter', 'काउंटर पर जाएँ', NULL),
('hin', 'Visit Date', 'यात्रा तिथि', NULL),
('hin', 'Web Password', 'वेब पासवर्ड', NULL),
('hin', 'Your Link', 'आपकी कड़ी', NULL);

INSERT INTO `wtkWidgetGroup` (`WidgetGroupName`, `StaffRole`, `SecurityLevel`, `UseForDefault`)
  VALUES ('DevOps', 'Tech', 99, 'N'),
         ('Personal - leave blank, autofilled','Emp', 1, 'N'),
         ('Marketing','Mgr', 30, 'Y');

UPDATE `wtkWidgetGroup` SET `UID` = (`UID` - 1) WHERE `UID` < 4;
ALTER TABLE `wtkWidgetGroup` AUTO_INCREMENT = 3;

INSERT INTO `wtkWidget` (`UID`, `WidgetName`, `SecurityLevel`, `WidgetType`, `ChartType`, `WidgetColor`, `SkipFooter`, `WidgetDescription`, `WidgetSQL`, `WidgetURL`, `PassRNG`, `WindowModal`)
  VALUES
(1, 'Users by Security Level', 30, 'List', NULL, NULL, 'Y', NULL, 'SELECT L.`LookupDisplay` AS `SecurityLevel`,\r\n   COUNT(u.`UID`) AS `Count`\r\nFROM `wtkUsers` u\r\n  LEFT OUTER JOIN `wtkLookups` L ON L.`LookupType` = \'SecurityLevel\' AND L.`LookupValue` = u.`SecurityLevel`\r\nWHERE u.`DelDate` IS NULL\r\nGROUP BY u.`SecurityLevel`\r\nORDER BY u.`SecurityLevel` ASC', NULL, NULL, 'N'),
(2, 'Last 10 Users', 30, 'List', NULL, NULL, 'Y', 'Last 10 unique users that accessed website.',
    'SELECT wu.`FirstName` AS `User`,\r\n    DATE_FORMAT(h.`AddDate`, \'%c/%e/%y at %k:%i\') AS `LastAccess`,\r\n    h.`PageURL`\r\nFROM `wtkUserHistory` h\r\n  INNER JOIN (\r\n    SELECT MAX(`UID`) AS `MaxUID`\r\n    FROM `wtkUserHistory`\r\n    GROUP BY `UserUID`\r\n  ) latest ON h.`UID` = latest.`MaxUID`\r\n  INNER JOIN `wtkUsers` wu ON wu.`UID` = h.`UserUID`\r\nWHERE wu.`DelDate` IS NULL\r\nORDER BY h.`UID` DESC LIMIT 10', NULL, NULL, 'N'),
(3, 'New Users - 7 Days', 30, 'Count', NULL, 'info-gradient', NULL, 'how many users signed up in the last 7 days', 'SELECT COUNT(`UID`)\r\nFROM `wtkUsers`\r\nWHERE `DelDate` IS NULL AND `AddDate` > (NOW() - INTERVAL 7 DAY)', NULL, NULL, 'N'),
(4, 'Revenue Today', 80, 'Count', NULL, 'info-gradient', NULL, NULL, 'SELECT CONCAT(\'$\', FORMAT(COALESCE(SUM(`GrossAmount`), 0),0)) AS `Income`\r\nFROM `wtkRevenue`\r\nWHERE DATE_FORMAT(`AddDate`, \'%Y-%m-%d\') = CURRENT_DATE\r\n   AND `PaymentStatus` IN (\'Paid\',\'Authorized\')', '/admin/revenueList', NULL, 'N'),
(5, 'Revenue This Week', 80, 'Count', NULL, 'danger-gradient', NULL, 'income from the last 7 days', 'SELECT CONCAT(\'$\', FORMAT(COALESCE(SUM(`GrossAmount`), 0),0)) AS `Income`\r\nFROM `wtkRevenue`\r\nWHERE `AddDate` > (CURRENT_DATE - INTERVAL 7 DAY) AND `PaymentStatus` IN (\'Paid\',\'Authorized\')', '/admin/revenueList', NULL, 'N'),
(6, 'Revenue This Month', 80, 'Count', NULL, 'success-gradient', NULL, 'income from the last 30 days', 'SELECT CONCAT(\'$\', FORMAT(COALESCE(SUM(`GrossAmount`), 0),0)) AS `Income`\r\nFROM `wtkRevenue`\r\nWHERE `AddDate` > (CURRENT_DATE - INTERVAL 30 DAY) AND `PaymentStatus` IN (\'Paid\',\'Authorized\')', '/admin/revenueList', NULL, 'N'),
(7, 'Daily Income', 80, 'Chart', 'Line', NULL, NULL, 'last 7 days income summaries', 'SELECT DATE_FORMAT(`AddDate`, \'%b %D (%a)\') AS `Day`,\r\n   COALESCE(SUM(`GrossAmount`), 0) AS `Income`\r\n FROM `wtkRevenue`\r\nWHERE `PaymentStatus` IN (\'Paid\', \'Authorized\')\r\nGROUP BY DATE_FORMAT(`AddDate`, \'%Y%j\'), DATE_FORMAT(`AddDate`, \'%b %D (%a)\')\r\nORDER BY DATE_FORMAT(`AddDate`, \'%Y%j\') DESC LIMIT 7', '/admin/moneyStats', NULL, 'N'),
(8, 'Revenue by Currency Type', 80, 'Chart', 'Pie', NULL, NULL, 'income by currency type', 'SELECT `CurrencyCode`, COALESCE(SUM(`GrossAmount`), 0) AS `Income`\r\nFROM `wtkRevenue`\r\nWHERE `PaymentStatus` IN (\'Paid\',\'Authorized\')\r\n-- AND `AddDate` > (NOW() - INTERVAL 7 DAY)\r\nGROUP BY `CurrencyCode`\r\nORDER BY SUM(`GrossAmount`) DESC', '/admin/revenueList', NULL, 'N'),
(9, 'Activity 1 Day', 80, 'List', NULL, NULL, 'Y', 'Server access statistics', 'call make_widget(1)', NULL, NULL, 'N'),
(10, 'Activity 7 Days', 80, 'List', NULL, NULL, 'Y', 'Server access statistics', 'call make_widget(7)', NULL, NULL, 'N'),
(11, 'Activity 30 Days', 80, 'List', NULL, NULL, 'Y', 'Server access statistics', 'call make_widget(30)', NULL, NULL, 'N'),
(12, 'Update History', 80, 'Chart', 'Bar', NULL, NULL, 'data updates during last 5 days', 'SELECT DATE_FORMAT(`AddDate`, \'%b %D (%a)\') AS `Day`,\r\n    COUNT(`UID`) AS `Count`\r\nFROM `wtkUpdateLog`\r\nGROUP BY DATE_FORMAT(`AddDate`, \'%Y%j\'),DATE_FORMAT(`AddDate`, \'%b %D (%a)\')\r\nORDER BY DATE_FORMAT(`AddDate`, \'%Y%j\') DESC LIMIT 5', NULL, NULL, 'N'),
(13, 'Login History', 80, 'Chart', 'Bar', NULL, NULL, 'login activity last 5 days', 'SELECT DATE_FORMAT(`LastLogin`, \'%b %D (%a)\') AS `Day`,\r\n    COUNT(`UID`) AS `Count`\r\n  FROM `wtkLoginLog`\r\nwhere `LastLogin` IS NOT NULL\r\nGROUP BY DATE_FORMAT(`LastLogin`, \'%Y%j\'),DATE_FORMAT(`LastLogin`, \'%b %D (%a)\')\r\nORDER BY DATE_FORMAT(`LastLogin`, \'%Y%j\') DESC LIMIT 5', NULL, NULL, 'N'),
(14, 'Page View History', 80, 'Chart', 'Bar', NULL, NULL, 'page views during last 5 days', 'SELECT DATE_FORMAT(`AddDate`, \'%b %D (%a)\') AS `Day`,\r\n    COUNT(`UID`) AS `Count`\r\n  FROM `wtkUserHistory`\r\nGROUP BY DATE_FORMAT(`AddDate`, \'%Y%j\'),DATE_FORMAT(`AddDate`, \'%b %D (%a)\')\r\nORDER BY DATE_FORMAT(`AddDate`, \'%Y%j\') DESC LIMIT 5', NULL, NULL, 'N'),
(15, 'Errors Today', 99, 'Count', NULL, 'red-gradient', NULL, 'how many errors in last 24 hours', 'SELECT COUNT(`UID`)\r\n   FROM `wtkErrorLog`\r\n WHERE `DelDate` IS NULL AND `AddDate` > DATE_SUB(NOW(), INTERVAL 1 DAY)', 'errorList', NULL, 'N'),
(16, 'Active Users', 30, 'Count', NULL, 'danger-gradient', NULL, NULL, 'SELECT COUNT(*) as `Count`\r\nFROM `wtkUsers`\r\nWHERE `DelDate` IS NULL', NULL, NULL, 'N'),
(17, 'Emails Sent', 80, 'Count', NULL, 'warning-gradient', NULL, 'how many emails sent in the last 24 hours', 'SELECT 81 AS `Count`\r\nFROM `wtkEmailsSent`\r\nWHERE `AddDate` > (NOW() - INTERVAL 1 DAY)', NULL, NULL, 'N'),
(18, 'Reports Viewed', 80, 'Count', NULL, 'info-gradient', NULL, 'how many reports viewed in the last 24 hours', 'SELECT COUNT(`UID`) AS `Count`\r\nFROM `wtkReportCntr`\r\nWHERE `AddDate` > (NOW() - INTERVAL 1 DAY)', NULL, NULL, 'N'),
(19, 'Last 5 Users', 30, 'List', NULL, NULL, 'Y', 'Last 5 unique users that accessed website.',
    'SELECT wu.`FirstName` AS `User`,\n    DATE_FORMAT(h.`AddDate`, \'%c/%e/%y at %k:%i\') AS `LastAccess`,\n    h.`PageURL`\nFROM `wtkUserHistory` h\n  INNER JOIN (\n    SELECT MAX(`UID`) AS `MaxUID`\n    FROM `wtkUserHistory`\n    GROUP BY `UserUID`\n  ) latest ON h.`UID` = latest.`MaxUID`\n  INNER JOIN `wtkUsers` wu ON wu.`UID` = h.`UserUID`\nWHERE wu.`DelDate` IS NULL\nORDER BY h.`UID` DESC LIMIT 5', NULL, NULL, 'N'),
(20, 'Weekly Income', 80, 'Chart', 'Area', NULL, NULL, 'weekly income summaries', 'SELECT DATE_FORMAT(DATE_ADD(`AddDate`, INTERVAL (1 - DAYOFWEEK(`AddDate`)) + 7 DAY), \'%b %D\') AS `WeekEnding`,\r\n   COALESCE(SUM(`GrossAmount`), 0) AS `Income`\r\n FROM `wtkRevenue`\r\nWHERE `PaymentStatus` IN (\'Paid\', \'Authorized\')\r\nGROUP BY YEAR(`AddDate`), WEEK(`AddDate`, 1)\r\nORDER BY YEAR(`AddDate`) DESC, WEEK(`AddDate`, 1) DESC LIMIT 7', '/admin/moneyStats', NULL, 'N'),
(21, 'Unique Visitors', 80, 'Count', NULL, 'info-gradient', NULL, 'visitors to marketing site', 'SELECT COUNT(DISTINCT(`IPaddress`)) as `Count`\r\nFROM `wtkVisitors`\r\nWHERE `AddDate` > (NOW() - INTERVAL 7 DAY)', '/admin/visitorStats', NULL, 'N'),
(22, 'Affiliates', 80, 'Count', NULL, 'success-gradient', NULL, NULL, 'SELECT COUNT(*)\r\n FROM `wtkAffiliates`\r\nWHERE `DelDate` IS NULL', '/admin/affiliateList', NULL, 'N'),
(23, 'Prospects', 80, 'Count', NULL, 'info-gradient', NULL, NULL, 'SELECT COUNT(*)\r\n FROM `wtkProspects`\r\nWHERE `DelDate` IS NULL', '/admin/prospectList', NULL, 'N');

INSERT INTO `wtkWidgetGroup_X_Widget` (`WidgetGroupUID`, `WidgetUID`, `WidgetPriority`)
 VALUES
(0, 15, 10),
(0, 16, 20),
(0, 17, 30),
(0, 18, 40),
(0, 13, 50),
(0, 1, 60),
(0, 12, 70),
(0, 9, 80),
(0, 10, 90),
(0, 11, 100),
(0, 14, 110),
(2, 4, 10),
(2, 5, 20),
(2, 6, 30),
(2, 21, 40),
(2, 22, 50),
(2, 23, 60),
(2, 16, 70),
(2, 17, 80),
(2, 8, 90),
(2, 7, 100),
(2, 20, 110);

/*
-- For App Testing of Microphone
INSERT INTO `wtkWidget` (`WidgetName`, `SecurityLevel`, `WidgetType`, `ChartType`, `WidgetColor`, `SkipFooter`, `WidgetDescription`, `WidgetSQL`, `WidgetURL`, `PassRNG`, `WindowModal`) VALUES
('Microphone Test', 1, 'Link', 'Area', 'danger-gradient', 'N', 'test out microphone on mobile app', NULL, '/demo/micTest', NULL, 'N');

INSERT INTO `wtkWidgetGroup_X_Widget` (`WidgetGroupUID`, `WidgetUID`)
SELECT 1, `UID`
  FROM `wtkWidget`
 WHERE `WidgetName` = 'Microphone Test';
*/
