# Lunaria
<p align="center">
  <img src="./github-pages/images/tenor-nibutani.gif" alt="Lunaria ロゴ" width="200" height="200">
</p>
<h3 align="center">Lunariaへようこそ</h3>

[English](README.md) | [日本語](README_ja.md) | [Українська](README_ua.md)

Lunariaは、QUICプロトコルを中心に構築された、安全で効率的な通信を目指すオープンソースのチャットアプリケーションです。

## ステータス
🚧 **活発な開発中** 🚧

このプロジェクトは、個人開発者によって約2ヶ月間活発に開発されています。多くのコア機能が実装中で、8月末にはプレアルファリリースを予定しています。アプリケーションの進行に伴い、皆様のご関心とフィードバックを大切にしています。

## 概要

[FAQ](docs/FAQ.md)

Lunariaは、セキュリティと効率性を重視したチャットアプリケーションです。QUICプロトコルを活用し、自己ホスト可能でカスタマイズ可能な通信プラットフォームを提供することを目指して開発されています。

## 開発中の機能
- QUICプロトコルを使用したセキュリティ強化
- 自己ホスト可能なサーバー
- VPNネットワーク内でのピアツーピア通信
- Luaスクリプトを使用したクライアントのカスタマイズ
- Luaを利用したCLI/チャットボット機能

## 実装中の技術
このプロジェクトでは、以下の技術を積極的に使用または統合しています：

- **プログラミング言語**
  - C++
  - C
  - Shell
  - Lua
- **ライブラリ/フレームワーク**
  - Qt - GUI開発用
  - pqxx - PostgreSQL C++ライブラリ
  - cassandra - ScyllaDB用C++ドライバ
  - Protobuf - データシリアライゼーション用
  - NetBird - VPNソリューション
  - MsQuic - クロスプラットフォームQUICプロトコル実装
  - Abseil - GoogleによるC++共通ライブラリ
  - OpenSSL - 暗号化操作用
- **データベース**
  - PostgreSQL
  - ScyllaDB（移行中）
- **ツール**
  - g++ - コンパイラ
  - CMake - ビルドシステム
  - Git - バージョン管理

## 対象プラットフォーム
Lunariaは以下のプラットフォームをサポートするよう開発されています：
- Linux (x11 | Wayland)
- Windows

## 計画中の言語サポート
以下の言語のローカライズを計画しています：
- ウクライナ語
- 日本語
- 英語

## ソースからのビルド
プロジェクトが最初のプレアルファリリースに近づいているため、ビルド手順を最終調整中です。8月末のプレアルファバージョンリリース時に、このREADMEは詳細なビルド手順で更新される予定です。

## GUIプレビュー
現在のグラフィカルユーザーインターフェース（GUI）のプレビュー画像です：

<img src="./GUI/Server.png" alt="サーバーGUIプレビュー">

<div align="center">
    <img width=390 src="./GUI/Sign in(1).png" alt="サインインプレビュー">
    &nbsp; &nbsp; &nbsp; &nbsp;
    <img width=390 src="./GUI/Sign up(1).png" alt="サインアッププレビュー">
</div>

<img src="./GUI/Group 56.png" alt="チャットインターフェースプレビュー">
<img src="./GUI/Group 58.png" alt="設定プレビュー">
<img src="./GUI/Group 57.png" alt="ユーザープロフィールプレビュー">

## 貢献について
個人開発中のプロジェクトのため、現在Lunariaは一般的な貢献を受け付けていません。しかし、皆様のご関心を大変ありがたく思っています。

### 将来のコラボレーション計画
プロジェクトへの貢献に大きな関心がある場合、以下の目標を持って完全な書き直しを検討しています：

1. コーディング規約と標準化の実装
2. 構造化された開発ワークフローの確立
3. より協力的なアーキテクチャの作成

この書き直しは、複数の開発者が同時に作業できるようLunariaをより利用しやすくすることを目指しています。

プロジェクトに情熱を持ち、将来の開発への参加について議論したい方は、直接ご連絡ください：

[メール](mailto:akzestia@gmail.com)

プロジェクトの進捗状況やコラボレーションの機会に関するお知らせを受け取るには、このリポジトリをスターし、ウォッチしてください。

## お問い合わせ
Lunariaに関するご質問、フィードバック、または興味がある方は、お気軽にご連絡ください：

[メール](mailto:akzestia@gmail.com)

Lunariaにご関心いただき、ありがとうございます！皆様のサポートとフィードバックは、このプロジェクトの開発に非常に重要です。
