/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TimeUtils;
import com.alee.utils.swing.DelayFormatException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class WebTimer {
    public static final int msInDay = 86400000;
    public static final int msInHour = 3600000;
    public static final int msInMinute = 60000;
    public static final int msInSecond = 1000;
    public static String defaultThreadName = "WebTimer";
    protected final List<ActionListener> listeners = new ArrayList<ActionListener>(1);
    protected int id = 0;
    protected int lastId;
    protected final Map<Integer, Boolean> running = new Hashtable<Integer, Boolean>();
    protected long sleepStart = 0L;
    protected long sleepTime = 0L;
    protected Thread exec = null;
    protected long delay;
    protected long initialDelay;
    protected boolean repeats = true;
    protected boolean coalesce = true;
    protected boolean useEventDispatchThread = true;
    protected String actionCommand = "";
    protected String name = null;
    protected int cyclesLimit = 0;

    public WebTimer(String delay) {
        this(WebTimer.parseDelay(delay));
    }

    public WebTimer(long delay) {
        this(defaultThreadName, delay);
    }

    public WebTimer(String name, String delay) {
        this(name, WebTimer.parseDelay(delay));
    }

    public WebTimer(String name, long delay) {
        this(name, delay, null);
    }

    public WebTimer(long delay, long initialDelay) {
        this(defaultThreadName, delay, initialDelay);
    }

    public WebTimer(String name, long delay, long initialDelay) {
        this(name, delay, initialDelay, null);
    }

    public WebTimer(String delay, ActionListener listener) {
        this(WebTimer.parseDelay(delay), listener);
    }

    public WebTimer(long delay, ActionListener listener) {
        this(defaultThreadName, delay, listener);
    }

    public WebTimer(String name, String delay, ActionListener listener) {
        this(name, WebTimer.parseDelay(delay), listener);
    }

    public WebTimer(String name, long delay, ActionListener listener) {
        this(name, delay, -1L, listener);
    }

    public WebTimer(long delay, long initialDelay, ActionListener listener) {
        this(defaultThreadName, delay, initialDelay, listener);
    }

    public WebTimer(String name, String delay, String initialDelay, ActionListener listener) {
        this(name, WebTimer.parseDelay(delay), WebTimer.parseDelay(initialDelay), listener);
    }

    public WebTimer(String name, long delay, long initialDelay, ActionListener listener) {
        this.setName(name);
        this.setDelay(delay);
        this.setInitialDelay(initialDelay);
        this.addActionListener(listener);
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public String getInitialStringDelay() {
        return WebTimer.toStringDelay(this.initialDelay);
    }

    public WebTimer setInitialDelay(String initialDelay) {
        this.setInitialDelay(WebTimer.parseDelay(initialDelay));
        return this;
    }

    public WebTimer setInitialDelay(long initialDelay) {
        if (initialDelay != -1L && initialDelay < 0L) {
            throw new IllegalArgumentException("Invalid initial delay: " + initialDelay);
        }
        this.initialDelay = initialDelay;
        return this;
    }

    public long getDelay() {
        return this.delay;
    }

    public String getStringDelay() {
        return WebTimer.toStringDelay(this.delay);
    }

    public WebTimer setDelay(String delay) {
        this.setDelay(WebTimer.parseDelay(delay));
        return this;
    }

    public WebTimer setDelay(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Invalid delay: " + delay);
        }
        this.delay = delay;
        return this;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public WebTimer setRepeats(boolean repeats) {
        this.repeats = repeats;
        return this;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public WebTimer setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
        return this;
    }

    public boolean isUseEventDispatchThread() {
        return this.useEventDispatchThread;
    }

    public WebTimer setUseEventDispatchThread(boolean useEventDispatchThread) {
        this.useEventDispatchThread = useEventDispatchThread;
        return this;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public WebTimer setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
        return this;
    }

    public int getCyclesLimit() {
        return this.cyclesLimit;
    }

    public WebTimer setCyclesLimit(int cyclesLimit) {
        this.cyclesLimit = cyclesLimit;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public WebTimer setName(String name) {
        this.name = name;
        if (this.exec != null) {
            this.exec.setName(name);
        }
        return this;
    }

    public long getCycleTimePassed() {
        return System.currentTimeMillis() - this.sleepStart;
    }

    public long getCycleTimeLeft() {
        return this.sleepTime - this.getCycleTimePassed();
    }

    public WebTimer start() {
        this.startExec();
        return this;
    }

    public WebTimer stop() {
        this.stopExec();
        return this;
    }

    public WebTimer restart() {
        this.stopExec();
        this.startExec();
        return this;
    }

    public WebTimer restart(long delay) {
        this.stopExec();
        this.setInitialDelay(delay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    public WebTimer restart(long initialDelay, long delay) {
        this.stopExec();
        this.setInitialDelay(initialDelay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    public WebTimer restart(String delay) {
        this.stopExec();
        this.setInitialDelay(delay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    public WebTimer restart(String initialDelay, String delay) {
        this.stopExec();
        this.setInitialDelay(initialDelay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    public synchronized boolean isRunning() {
        return this.exec != null && this.exec.isAlive();
    }

    protected synchronized void startExec() {
        if (this.isRunning()) {
            return;
        }
        final int currentId = this.lastId = this.id++;
        this.exec = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    WebTimer.this.setAlive(currentId, true);
                    try {
                        long actualInitialDelay;
                        long l = actualInitialDelay = WebTimer.this.getInitialDelay() < 0L ? WebTimer.this.getDelay() : WebTimer.this.getInitialDelay();
                        if (actualInitialDelay > 0L) {
                            WebTimer.this.sleepStart = System.currentTimeMillis();
                            WebTimer.this.sleepTime = actualInitialDelay;
                            Thread.sleep(actualInitialDelay);
                        }
                        if (!WebTimer.this.shouldContinue(-1, currentId)) break block6;
                        if (WebTimer.this.repeats) {
                            int cycle = 0;
                            while (WebTimer.this.shouldContinue(cycle, currentId)) {
                                WebTimer.this.fireActionPerformed();
                                if (WebTimer.this.shouldContinue(++cycle, currentId)) {
                                    if (WebTimer.this.getDelay() <= 0L) continue;
                                    long currentDelay = WebTimer.this.getDelay();
                                    WebTimer.this.sleepStart = System.currentTimeMillis();
                                    WebTimer.this.sleepTime = currentDelay;
                                    Thread.sleep(currentDelay);
                                    continue;
                                }
                                break block6;
                            }
                            break block6;
                        }
                        WebTimer.this.fireActionPerformed();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                WebTimer.this.cleanUp(currentId);
            }
        }, this.name);
        this.exec.start();
    }

    protected boolean shouldContinue(int cycle, int id) {
        return this.running.get(id) != false && !Thread.currentThread().isInterrupted() && (this.cyclesLimit <= 0 || this.cyclesLimit > cycle);
    }

    protected void setAlive(int id, boolean alive) {
        this.running.put(id, alive);
    }

    protected void cleanUp(int id) {
        this.running.remove(id);
    }

    protected synchronized void stopExec() {
        if (this.exec != null) {
            this.exec.interrupt();
            this.setAlive(this.lastId, false);
            try {
                this.exec.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public WebTimer addActionListener(ActionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
        return this;
    }

    public WebTimer removeActionListener(ActionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
        return this;
    }

    public List<ActionListener> getListeners() {
        return this.listeners;
    }

    public void fireActionPerformed() {
        block6: {
            if (this.listeners.size() <= 0) break block6;
            final ActionEvent actionEvent = this.createActionEvent();
            final List<ActionListener> listenerList = CollectionUtils.copy(this.listeners);
            if (this.useEventDispatchThread) {
                if (this.coalesce) {
                    SwingUtils.invokeAndWaitSafely(new Runnable(){

                        @Override
                        public void run() {
                            for (ActionListener listener : listenerList) {
                                listener.actionPerformed(actionEvent);
                            }
                        }
                    });
                } else {
                    for (final ActionListener listener : listenerList) {
                        SwingUtils.invokeAndWaitSafely(new Runnable(){

                            @Override
                            public void run() {
                                listener.actionPerformed(actionEvent);
                            }
                        });
                    }
                }
            } else {
                for (ActionListener listener : listenerList) {
                    listener.actionPerformed(actionEvent);
                }
            }
        }
    }

    protected ActionEvent createActionEvent() {
        return new ActionEvent(this, 0, this.actionCommand, TimeUtils.currentTime(), 0);
    }

    public String toString() {
        return this.name + ", delay (" + this.getStringDelay() + "), initialDelay (" + this.getInitialStringDelay() + ")";
    }

    public static WebTimer delay(String delay, ActionListener listener) {
        return WebTimer.delay(WebTimer.parseDelay(delay), listener);
    }

    public static WebTimer delay(long delay, ActionListener listener) {
        return WebTimer.delay(defaultThreadName, delay, listener);
    }

    public static WebTimer delay(String name, String delay, ActionListener listener) {
        return WebTimer.delay(name, WebTimer.parseDelay(delay), listener);
    }

    public static WebTimer delay(String name, long delay, ActionListener listener) {
        return WebTimer.delay(name, delay, true, listener);
    }

    public static WebTimer delay(String delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.delay(WebTimer.parseDelay(delay), useEventDispatchThread, listener);
    }

    public static WebTimer delay(long delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.delay(defaultThreadName, delay, useEventDispatchThread, listener);
    }

    public static WebTimer delay(String name, String delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.delay(name, WebTimer.parseDelay(delay), useEventDispatchThread, listener);
    }

    public static WebTimer delay(String name, long delay, boolean useEventDispatchThread, ActionListener listener) {
        WebTimer once = new WebTimer(name, delay, listener);
        once.setRepeats(false);
        once.setUseEventDispatchThread(useEventDispatchThread);
        once.start();
        return once;
    }

    public static WebTimer repeat(String delay, ActionListener listener) {
        return WebTimer.repeat(WebTimer.parseDelay(delay), listener);
    }

    public static WebTimer repeat(long delay, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, listener);
    }

    public static WebTimer repeat(String name, String delay, ActionListener listener) {
        return WebTimer.repeat(name, WebTimer.parseDelay(delay), listener);
    }

    public static WebTimer repeat(String name, long delay, ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, true, listener);
    }

    public static WebTimer repeat(String delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(WebTimer.parseDelay(delay), useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String name, String delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(name, WebTimer.parseDelay(delay), useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String name, long delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, listener);
    }

    public static WebTimer repeat(String name, long delay, long initialDelay, ActionListener listener) {
        return WebTimer.repeat(name, delay, initialDelay, true, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String name, long delay, long initialDelay, boolean useEventDispatchThread, ActionListener listener) {
        WebTimer repeat = new WebTimer(name, delay, initialDelay, listener);
        repeat.setRepeats(true);
        repeat.setUseEventDispatchThread(useEventDispatchThread);
        repeat.start();
        return repeat;
    }

    public static long parseDelay(String delay) throws DelayFormatException {
        try {
            String[] parts;
            long summ = 0L;
            block9: for (String part : parts = delay.split(" ")) {
                for (int i = 0; i < part.length(); ++i) {
                    if (Character.isDigit(part.charAt(i))) continue;
                    int time = Integer.parseInt(part.substring(0, i));
                    PartType type = PartType.valueOf(part.substring(i));
                    switch (type) {
                        case d: {
                            summ += (long)(time * 86400000);
                            break;
                        }
                        case h: {
                            summ += (long)(time * 3600000);
                            break;
                        }
                        case m: {
                            summ += (long)(time * 60000);
                            break;
                        }
                        case s: {
                            summ += (long)(time * 1000);
                            break;
                        }
                        case ms: {
                            summ += (long)time;
                        }
                    }
                    continue block9;
                }
            }
            return summ;
        }
        catch (Throwable e) {
            throw new DelayFormatException(e);
        }
    }

    public static String toStringDelay(long delay) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("Invalid delay: " + delay);
        }
        long time = delay;
        long d = time / 86400000L;
        long h = (time -= d * 86400000L) / 3600000L;
        long m = (time -= h * 3600000L) / 60000L;
        long s = (time -= m * 60000L) / 1000L;
        long ms = time -= s * 1000L;
        String stringDelay = (d > 0L ? d + "d " : "") + (h > 0L ? h + "h " : "") + (m > 0L ? m + "m " : "") + (s > 0L ? s + "s " : "") + (ms > 0L ? ms + "ms " : "");
        return stringDelay.trim();
    }

    protected static enum PartType {
        d,
        h,
        m,
        s,
        ms;

    }
}

