/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Rectangle;
import java.io.Serializable;

@XStreamAlias(value="NinePatchInterval")
public final class NinePatchInterval
implements Serializable,
Cloneable {
    public static final String ID_PREFIX = "NPI";
    @XStreamAsAttribute
    private transient String id;
    @XStreamAsAttribute
    private boolean pixel;
    @XStreamAsAttribute
    private int start;
    @XStreamAsAttribute
    private int end;

    public NinePatchInterval() {
        this(0);
    }

    public NinePatchInterval(int start) {
        this(start, start);
    }

    public NinePatchInterval(int start, boolean pixel) {
        this(start, start, pixel);
    }

    public NinePatchInterval(int start, int end) {
        this(start, end, true);
    }

    public NinePatchInterval(int start, int end, boolean pixel) {
        this.setId();
        this.setPixel(pixel);
        this.setStart(start);
        this.setEnd(end);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setId() {
        this.id = TextUtils.generateId(ID_PREFIX);
    }

    public boolean isPixel() {
        return this.pixel;
    }

    public void setPixel(boolean pixel) {
        this.pixel = pixel;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public boolean intersects(NinePatchInterval npi) {
        return new Rectangle(this.getStart(), 0, this.getEnd() - this.getStart(), 1).intersects(new Rectangle(npi.getStart(), 0, npi.getEnd() - npi.getStart(), 1));
    }

    public NinePatchInterval clone() {
        NinePatchInterval npi = new NinePatchInterval();
        npi.setId(this.getId());
        npi.setPixel(this.isPixel());
        npi.setStart(this.getStart());
        npi.setEnd(this.getEnd());
        return npi;
    }

    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    public boolean isSame(NinePatchInterval ninePatchInterval) {
        return ninePatchInterval != null && this.getId().equals(ninePatchInterval.getId());
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof NinePatchInterval) {
            NinePatchInterval npi = (NinePatchInterval)obj;
            return this.isPixel() == npi.isPixel() && this.getStart() == npi.getStart() && this.getEnd() == npi.getEnd();
        }
        return false;
    }
}

