/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.ninepatch;

import com.alee.utils.ReflectUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;

public class NinePatchIconConverter
extends ReflectionConverter {
    public static final String NEAR_CLASS_ATTRIBUTE = "nearClass";

    public NinePatchIconConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(NinePatchIcon.class);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String nearClass = reader.getAttribute(NEAR_CLASS_ATTRIBUTE);
        if (nearClass == null) {
            nearClass = (String)context.get("class");
        }
        if (nearClass == null) {
            return null;
        }
        Class nearRealClass = ReflectUtils.getClassSafely(nearClass);
        if (nearRealClass == null) {
            return null;
        }
        String iconPath = reader.getValue();
        try {
            return new NinePatchIcon(nearRealClass.getResource(iconPath));
        }
        catch (Throwable e) {
            System.err.println("Unable to read 9-patch icon near class \"" + nearClass + "\": " + iconPath);
            e.printStackTrace();
            return null;
        }
    }
}

